/* Please keep these tables in alphabetical order, and in sync with
 * the ACT_* constants in kbdbind.h.  */

/* These two actions are common over all keymaps: */
ACTION_(EDIT, "none", NONE, N__("Do nothing"), 0),
ACTION_(EDIT, " *scripting-function*", SCRIPTING_FUNCTION, NULL, 0),
ACTION_(EDIT, "auto-complete", AUTO_COMPLETE, N__("Attempt to auto-complete the input"), 0),
ACTION_(EDIT, "auto-complete-file", AUTO_COMPLETE_FILE, N__("Attempt to auto-complete a local file"), ACTION_RESTRICT_ANONYMOUS),
ACTION_(EDIT, "auto-complete-unambiguous", AUTO_COMPLETE_UNAMBIGUOUS, N__("Attempt to unambiguously auto-complete the input"), 0),
ACTION_(EDIT, "backspace", BACKSPACE, N__("Delete character in front of the cursor"), 0),
ACTION_(EDIT, "beginning-of-buffer", BEGINNING_OF_BUFFER, N__("Go to the first line of the buffer"), 0),
ACTION_(EDIT, "cancel", CANCEL, N__("Cancel current state"), 0),
ACTION_(EDIT, "copy-clipboard", COPY_CLIPBOARD, N__("Copy text to clipboard"), 0),
ACTION_(EDIT, "cut-clipboard", CUT_CLIPBOARD, N__("Delete text from clipboard"), 0),
ACTION_(EDIT, "delete", DELETE, N__("Delete character under cursor"), 0),
ACTION_(EDIT, "down", DOWN, N__("Move cursor downwards"), 0),
ACTION_(EDIT, "end", END, N__("Go to the end of the page/line"), 0),
ACTION_(EDIT, "end-of-buffer", END_OF_BUFFER, N__("Go to the last line of the buffer"), 0),
ACTION_(EDIT, "enter", ENTER, N__("Follow the current link"), 0),
ACTION_(EDIT, "home", HOME, N__("Go to the start of the page/line"), 0),
ACTION_(EDIT, "kill-to-bol", KILL_TO_BOL, N__("Delete to beginning of line"), 0),
ACTION_(EDIT, "kill-to-eol", KILL_TO_EOL, N__("Delete to end of line"), 0),
ACTION_(EDIT, "left", LEFT, N__("Move the cursor left"), 0),
ACTION_(EDIT, "next-item", NEXT_ITEM, N__("Move to the next item"), 0),
ACTION_(EDIT, "open-external", OPEN_EXTERNAL, N__("Open in external editor"), ACTION_RESTRICT_ANONYMOUS),
ACTION_(EDIT, "paste-clipboard", PASTE_CLIPBOARD, N__("Paste text from the clipboard"), 0),
ACTION_(EDIT, "previous-item", PREVIOUS_ITEM, N__("Move to the previous item"), 0),
ACTION_(EDIT, "redraw", REDRAW, N__("Redraw the terminal"), 0),
ACTION_(EDIT, "right", RIGHT, N__("Move the cursor right"), 0),
ACTION_(EDIT, "search-toggle-regex", SEARCH_TOGGLE_REGEX, N__("Toggle regex matching (type-ahead searching)"), 0),
ACTION_(EDIT, "up", UP, N__("Move cursor upwards"), 0),
