#! perl
#
# TITLE: Password authentication modules
#
# $Id: admin-10password.pl,v 1.4 2001/10/07 02:35:04 mrsam Exp $
#
# Copyright 2001 Double Precision, Inc.  See COPYING for
# distribution information.

my $vars=ReadEnvVarConfigFile("authdaemonrc");

my $authmodulelist=$$vars{'authmodulelist'};

my @mods=grep(/./, split (/\s+/, $authmodulelist));

my $authmodule_param=$cgi->param("authmodulelist");

my $selected= -1;

my $errstr="";

if ($cgi->param("Up") && $authmodule_param)
{
    my $i;

    for ($i=0; $i <= $#mods; $i++)
    {
	next unless $mods[$i] eq $authmodule_param;

	if ($i > 0)
	{
	    $mods[$i]=$mods[$i-1];
	    $mods[$i-1]=$authmodule_param;

	    ReplaceEnvVarConfigFile("authdaemonrc", "authmodulelist",
				    join(" ", @mods));
	    changed("$libexecdir/authlib/authdaemond restart");
	    $selected= $i-1;
	    last;
	}
    }
}

if ($cgi->param("Down") && $authmodule_param)
{
    my $i;

    for ($i=0; $i <= $#mods; $i++)
    {
	next unless $mods[$i] eq $authmodule_param;

	if ($i < $#mods)
	{
	    $mods[$i]=$mods[$i+1];
	    $mods[$i+1]=$authmodule_param;

	    ReplaceEnvVarConfigFile("authdaemonrc", "authmodulelist",
				    join(" ", @mods));
	    changed("$libexecdir/authlib/authdaemond restart");
	    $selected=$i+1;
	    last;
	}
    }
}

if ($cgi->param("Delete") && $authmodule_param)
{
    my $i;

    for ($i=0; $i <= $#mods; $i++)
    {
	next unless $mods[$i] eq $authmodule_param;

	splice @mods, $i, 1;
	ReplaceEnvVarConfigFile("authdaemonrc", "authmodulelist",
				join(" ", @mods));
	changed("$libexecdir/authlib/authdaemond restart");
	last;
    }
}

if ($authmodule_param=$cgi->param("authmodulelistorig"))
{
    push @mods, $authmodule_param;
    ReplaceEnvVarConfigFile("authdaemonrc", "authmodulelist",
			    join(" ", @mods));
    changed("$libexecdir/authlib/authdaemond restart");
    $errstr="\@SAVED\@";
}

my $authmodulelist_current="<tt><select name=authmodulelist size=6>";

foreach (@mods)
{
    my $n=$_;

    $authmodulelist_current .=
	"<option value=\"$n\" " . (($selected--) ? "":"selected") . ">$n\n";
}
$authmodulelist_current .= "</select></tt>";

my $authmodulelistorig=$$vars{'authmodulelistorig'};

my $authmodulelistorig_current="<tt><select name=authmodulelistorig><option>";

foreach (grep(/./, split (/\s+/, $authmodulelistorig)))
{
    $authmodulelistorig_current .= "<option>$_\n";
}
$authmodulelistorig_current .= "</select></tt>";

my $authdaemond=$$vars{'version'};

my $new_authdaemond=$cgi->param("authdaemond");

if ($new_authdaemond)
{
    my $good=0;

    ($good=1, $new_authdaemond="") if $new_authdaemond eq "(default)";
    ($good=1, $new_authdaemond=$1) if $new_authdaemond =~ /([a-z0-9\.]*)/;

    if ($good)
    {
	if ($new_authdaemond eq "" ||
	    -f "$libexecdir/authlib/$new_authdaemond")
	{
	    ReplaceEnvVarConfigFile("authdaemonrc", "version",
				    $new_authdaemond);
	    $authdaemond=$new_authdaemond;
	    changed("$libexecdir/authlib/authdaemond stop ; $libexecdir/authlib/authdaemond start");
	}
    }
}

my $daemons=$$vars{'daemons'};

my $daemons_params=$cgi->param("daemons");

if ($daemons_params =~ /([1-9][0-9]*)/)
{
    $daemons_params=$1;

    ReplaceEnvVarConfigFile("authdaemonrc", "daemons", $daemons_params);
    $daemons=$daemons_params;
}

my $authdaemond_html="<tt><select name=authdaemond>";

foreach (("(default)",
	  "authdaemond.plain", "authdaemond.mysql",
	  "authdaemond.pgsql", "authdaemond.ldap"))
{
    my $n=$_;

    $authdaemond_html .= "<option value=\"$n\" "
	. ($n eq $authdaemond ? "selected":"") . ">";

    $authdaemond_html .= $n;
}

$authdaemond_html .= "</select></tt>";


display_form("admin-10password.html",
	     {
		 "AUTHMODULELIST" => $authmodulelist_current,
		 "AUTHMODULELISTORIG" => $authmodulelistorig_current,
		 "AUTHDAEMOND" => $authdaemond_html,
		 "DAEMONS" => $daemons
	     }
	     );
