/*
 * Copyright 2012 Google Inc.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */
#include "EdgeWalker_Test.h"
#include "Intersection_Tests.h"
#include "SkBitmap.h"

// edges that didn't match
struct misMatch {
    SkPath::FillType fType;
    int a, b, c, d, e, f, g, h;
} misMatches[] = {
/*
___________________________________|___________________________________
_xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx__|_xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx__
__xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx___|__xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx___
__xxxxxxxxxxxxxxxxxxxxxxxxxxxx_____|__xxxxxxxxxxxxxxxxxxxxxxxxxxxx_____
___xxxxxxxxxx__xxxxxxxxxxxxxx______|___xxxxxxxxxx__xxxxxxxxxxxxxx______
___xxxxxxx______xxxxxxxxxxx________|___xxxxxxx______xxxxxxxxxxx________
____xxx__________xxxxxxxxx_________|____xxx__________xxxxxxxxx_________
____x_____________xxxxxxx__________|____x_____________xxxxxxx__________
__xx_______________xxxx____________|__xxx______________xxxx____________
___xx_______________xx_____________|___xx_______________xx_____________
____________________x______________|____________________x______________
______x____________xxx_____________|______x____________xxx_____________
______xxx_________xxxxx____________|______xxx_________xxxxx____________
_______xxxx_____xxxxxxxx___________|_______xxxx_____xxxxxxxx___________
_______xxxxxx__xxxxxxxxx___________|_______xxxxxx__xxxxxxxxxx__________
________xxxxx__xxxxxxxxxx__________|________xxxxx__xxxxxxxxxx__________
________xxxx_____xxxxxxxxx_________|________xxxx_____xxxxxxxxx_________
_________xxx_______xxxxxxxx________|_________xxx_______xxxxxxxx________
_________xxx_________xxxxxxx_______|_________xxx_________xxxxxxx_______
__________xx____________xxxxx______|__________xx____________xxxxx______
__________xx______________xxxx_____|__________xx______________xxxx_____
___________x________________xxx____|___________x________________xxx____
___________x__________________xx___|___________x__________________xx___
___________x____________________x__|___________x____________________x__
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kWinding_FillType, 0, 3, 9, 13, 1, 2, 4, 15 },
/*
___________________________________|___________________________________
_xxxxxxxxxxx_________xxxxxxxxxxxx__|_xxxxxxxxxxx_________xxxxxxxxxxxx__
__xxxxxxxxxxx______xxxxxxxxxxxxx___|__xxxxxxxxxxx______xxxxxxxxxxxxx___
__xxxxxxxxxxxx__xxxxxxxxxxxxxx_____|__xxxxxxxxxxxx__xxxxxxxxxxxxxx_____
___xxxxxxxxxx__xxxxxxxxxxxxxx______|___xxxxxxxxxx__xxxxxxxxxxxxxx______
___xxxxxxx______xxxxxxxxxxx________|___xxxxxxx______xxxxxxxxxxx________
____xxx__________xxxxxxxxx_________|____xxx__________xxxxxxxxx_________
____x_____________xxxxxxx__________|____x_____________xxxxxxx__________
__xx_______________xxxx____________|__xxx______________xxxx____________
___xx_______________xx_____________|___xx_______________xx_____________
____________________x______________|____________________x______________
______x____________xxx_____________|______x____________xxx_____________
______xxx_________xxxxx____________|______xxx_________xxxxx____________
_______xxxx_____xxxxxxxx___________|_______xxxx_____xxxxxxxx___________
_______xxxxxx__xxxxxxxxx___________|_______xxxxxx__xxxxxxxxxx__________
________xxxxx__xxxxxxxxxx__________|________xxxxx__xxxxxxxxxx__________
________xxxx_____xxxxxxxxx_________|________xxxx_____xxxxxxxxx_________
_________xxx_______xxxxxxxx________|_________xxx_______xxxxxxxx________
_________xxx_________xxxxxxx_______|_________xxx_________xxxxxxx_______
__________xx____________xxxxx______|__________xx____________xxxxx______
__________xx______________xxxx_____|__________xx______________xxxx_____
___________x________________xxx____|___________x________________xxx____
___________x__________________xx___|___________x__________________xx___
___________x____________________x__|___________x____________________x__
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kEvenOdd_FillType, 0, 3, 9, 13, 1, 2, 4, 15 },
/*
___________________________________|___________________________________
_x__________xxxxxxxxx______________|_x__________xxxxxxxxx______________
__xxx________xxxxxx________________|__xxx________xxxxxx________________
__xxxxxx______xx___________________|__xxxxxx______xx___________________
___xxxxxxxx__xx____________________|___xxxxxxxx__xx____________________
___xxxxxxx____xx___________________|___xxxxxxx____xx___________________
____xxx_________x__________________|____xxx_________x__________________
____x_____________x________________|____x_____________x________________
__xx_______________xxx_____________|__xxx______________xxx_____________
___xx_______________xx_____________|___xx_______________xx_____________
____________________x______________|____________________x______________
______x____________xxx_____________|______x____________xxx_____________
______xxx_________xxxxx____________|______xxx_________xxxxx____________
_______xxxx_____xxxxxxxx___________|_______xxxx_____xxxxxxxx___________
_______xxxxxx__xxxxxxxxx___________|_______xxxxxx__xxxxxxxxxx__________
________xxxxx__xxxxxxxxxx__________|________xxxxx__xxxxxxxxxx__________
________xxxx_____xxxxxxxxx_________|________xxxx_____xxxxxxxxx_________
_________xxx_______xxxxxxxx________|_________xxx_______xxxxxxxx________
_________xxx_________xxxxxxx_______|_________xxx_________xxxxxxx_______
__________xx____________xxxxx______|__________xx____________xxxxx______
__________xx______________xxxx_____|__________xx______________xxxx_____
___________x________________xxx____|___________x________________xxx____
___________x__________________xx___|___________x__________________xx___
___________x____________________x__|___________x____________________x__
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kWinding_FillType, 0, 6, 9, 13, 1, 2, 4, 15 },
/*
___________________________________|___________________________________
_x__________xxxxxxxxx______________|_x__________xxxxxxxxx______________
__xxx________xxxxxx________________|__xxx________xxxxxx________________
__xxxxxx______xx___________________|__xxxxxx______xx___________________
___xxxxxxxx__xx____________________|___xxxxxxxx__xx____________________
___xxxxxxx____xx___________________|___xxxxxxx____xx___________________
____xxx_________x__________________|____xxx_________x__________________
____x_____________x________________|____x_____________x________________
__xx_______________xxx_____________|__xxx______________xxx_____________
___xx_______________xx_____________|___xx_______________xx_____________
____________________x______________|____________________x______________
______x____________xxx_____________|______x____________xxx_____________
______xxx_________xxxxx____________|______xxx_________xxxxx____________
_______xxxx_____xxxxxxxx___________|_______xxxx_____xxxxxxxx___________
_______xxxxxx__xxxxxxxxx___________|_______xxxxxx__xxxxxxxxxx__________
________xxxxx__xxxxxxxxxx__________|________xxxxx__xxxxxxxxxx__________
________xxxx_____xxxxxxxxx_________|________xxxx_____xxxxxxxxx_________
_________xxx_______xxxxxxxx________|_________xxx_______xxxxxxxx________
_________xxx_________xxxxxxx_______|_________xxx_________xxxxxxx_______
__________xx____________xxxxx______|__________xx____________xxxxx______
__________xx______________xxxx_____|__________xx______________xxxx_____
___________x________________xxx____|___________x________________xxx____
___________x__________________xx___|___________x__________________xx___
___________x____________________x__|___________x____________________x__
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kEvenOdd_FillType, 0, 6, 9, 13, 1, 2, 4, 15 },
/*
___________________________________|___________________________________
_xx__________________x_____________|_xx__________________x_____________
__xxxxx____________xx______________|__xxxxx____________xx______________
__xxxxxxxxxx____xxxx_______________|__xxxxxxxxxx____xxxx_______________
___xxxxxxxxxx___xxx________________|___xxxxxxxxxx___xxx________________
___xxxxxxx_________x_______________|___xxxxxxx_________x_______________
____xxx___________xxxxxx___________|____xxx___________xxxxxx___________
____x____________xxxxxxxxxxx_______|____x____________xxxxxxxxxxx_______
__xx____________xxxxxxxxxxxxxxxxx__|__xxx___________xxxxxxxxxxxxxxxxx__
__xxx__________xxxxxxxxxxxxxxxx____|__xxx__________xxxxxxxxxxxxxxxx____
___xx_________xxxxxxxxxxxx_________|___xx_________xxxxxxxxxxxx_________
_____x_______xxxxxxxxx_____________|_____x_______xxxxxxxxx_____________
____________xxxxxx_________________|____________xxxxxx_________________
_______x___xxx_____________________|_______x___xxx_____________________
_______xx__________________________|_______xx__________________________
_____xxx_x_________________________|_____xxx_x_________________________
_xxxxxxxxxxx_______________________|_xxxxxxxxxxx_______________________
__xxxxx__xx________________________|__xxxxx__xx________________________
____xx_____________________________|____xx_____________________________
________xx_________________________|________xx_________________________
_____x_xxx_________________________|_____x_xxx_________________________
____x___xxx________________________|____x___xxx________________________
___x_____xx________________________|___x_____xx________________________
___________________________________|___________________________________
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kWinding_FillType, 0, 7, 8, 13, 2, 4, 9, 12 },
/*
___________________________________|___________________________________
_xx__________________x_____________|_xx__________________x_____________
__xxxxx____________xx______________|__xxxxx____________xx______________
__xxxxxxxxxx____xxxx_______________|__xxxxxxxxxx____xxxx_______________
___xxxxxxxxxx___xxx________________|___xxxxxxxxxx___xxx________________
___xxxxxxx_________x_______________|___xxxxxxx_________x_______________
____xxx___________xxxxxx___________|____xxx___________xxxxxx___________
____x____________xxxxxxxxxxx_______|____x____________xxxxxxxxxxx_______
__xx____________xxxxxxxxxxxxxxxxx__|__xxx___________xxxxxxxxxxxxxxxxx__
__xxx__________xxxxxxxxxxxxxxxx____|__xxx__________xxxxxxxxxxxxxxxx____
___xx_________xxxxxxxxxxxx_________|___xx_________xxxxxxxxxxxx_________
_____x_______xxxxxxxxx_____________|_____x_______xxxxxxxxx_____________
____________xxxxxx_________________|____________xxxxxx_________________
_______x___xxx_____________________|_______x___xxx_____________________
_______xx__________________________|_______xx__________________________
_____xxx_x_________________________|_____xxx_x_________________________
_xxxxxxxxxxx_______________________|_xxxxxxxxxxx_______________________
__xxxxx__xx________________________|__xxxxx__xx________________________
____xx_____________________________|____xx_____________________________
________xx_________________________|________xx_________________________
_____x_xxx_________________________|_____x_xxx_________________________
____x___xxx________________________|____x___xxx________________________
___x_____xx________________________|___x_____xx________________________
___________________________________|___________________________________
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kEvenOdd_FillType, 0, 7, 8, 13, 2, 4, 9, 12 },
/*
___________________________________|___________________________________
_x_________x_______________________|_x_________x_______________________
__x_______xxx______________________|__x_______xxx______________________
___x____xxxxxx_____________________|___x____xxxxxx_____________________
____xx_xxxxxxxx____________________|____xx_xxxxxxxx____________________
_____x_xxxxxxxxx___________________|_____x_xxxxxxxxx___________________
____xx___xxxxxxxx__________________|____xx___xxxxxxxx__________________
___xxxx___xxxxxxxx_________________|___xxxx___xxxxxxxx_________________
_xxxxxxx___xxxxxxxx________________|_xxxxxxx____xxxxxxx________________
__xxxxxxx____xxxxxxx_______________|__xxxxxxx____xxxxxxx_______________
___xxxxxxx____xxxxxxx______________|___xxxxxxx____xxxxxxx______________
_____xxxxxx_____xxxxxx_____________|_____xxxxxx_____xxxxxx_____________
______xxxxxx_____xxxxxx____________|______xxxxxx_____xxxxxx____________
________xxxxx______xxxxx___________|________xxxxx______xxxxx___________
_________xxxxx______xxxx___________|_________xxxxx______xxxx___________
__________xxxxx______xxxx__________|__________xxxxx______xxxx__________
____________xxx________xxx_________|____________xxx________xxx_________
_______________x___________xxxxx___|_______________x___________xxxxx___
____________________________xxx____|____________________________xxx____
__________________xx_______________|__________________xx_________x_____
___________________xxxx_____xx_____|___________________xxxx_____xx_____
____________________xxxxxx_xxxx____|____________________xxxxxx_xxxx____
_____________________xxxx____xxx___|_____________________xxxx____xxx___
______________________xx_______xx__|______________________xx_______xx__
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kWinding_FillType, 0, 10, 11, 14, 1, 4, 9, 15 },
/*
___________________________________|___________________________________
_x_________x_______________________|_x_________x_______________________
__x_______xxx______________________|__x_______xxx______________________
___x____xxxxxx_____________________|___x____xxxxxx_____________________
____xx_xxxxxxxx____________________|____xx_xxxxxxxx____________________
_____x_xxxxxxxxx___________________|_____x_xxxxxxxxx___________________
____xx___xxxxxxxx__________________|____xx___xxxxxxxx__________________
___xxxx___xxxxxxxx_________________|___xxxx___xxxxxxxx_________________
_xxxxxxx___xxxxxxxx________________|_xxxxxxx____xxxxxxx________________
__xxxxxxx____xxxxxxx_______________|__xxxxxxx____xxxxxxx_______________
___xxxxxxx____xxxxxxx______________|___xxxxxxx____xxxxxxx______________
_____xxxxxx_____xxxxxx_____________|_____xxxxxx_____xxxxxx_____________
______xxxxxx_____xxxxxx____________|______xxxxxx_____xxxxxx____________
________xxxxx______xxxxx___________|________xxxxx______xxxxx___________
_________xxxxx______xxxx___________|_________xxxxx______xxxx___________
__________xxxxx______xxxx__________|__________xxxxx______xxxx__________
____________xxx________xxx_________|____________xxx________xxx_________
_______________x___________xxxxx___|_______________x___________xxxxx___
____________________________xxx____|____________________________xxx____
__________________xx_______________|__________________xx_________x_____
___________________xxxx_____xx_____|___________________xxxx_____xx_____
____________________xxxxxx_xxxx____|____________________xxxxxx_xxxx____
_____________________xxxx____xxx___|_____________________xxxx____xxx___
______________________xx_______xx__|______________________xx_______xx__
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kEvenOdd_FillType, 0, 10, 11, 14, 1, 4, 9, 15 },
/*
___________________________________|___________________________________
_____________xxxxxxxxxxxxxxxxxxx___|_____________xxxxxxxxxxxxxxxxxxx___
___________xx___xxxxxxxxxxx________|___________xx___xxxxxxxxxxx________
___________xxx_____xxxx____________|___________xxx_____xxxx____________
__________xxxxx____xxx_____________|__________xxxxx____xxx_____________
__________xxxxx_xxxxxxxx___________|__________xxxxx_xxxxxxxxx__________
_________xx______xxxxxxxxxx________|_________x_______xxxxxxxxxx________
______xxx_________xxxxxxxxxxxx_____|______xxx_________xxxxxxxxxxxx_____
__xxxxxx___________xxxxxxxxxxxxxx__|__xxxxxx___________xxxxxxxxxxxxxx__
___xxxxx____________xxxxxxxxxxxx___|___xxxxx____________xxxxxxxxxxxx___
_____xx______________xxxxxxxxx_____|_____xx______________xxxxxxxxx_____
______________________xxxxxx_______|______________________xxxxxx_______
_______xx______________xxx_________|_______xx______________xxx_________
______xxxxx________________________|______xxxxx________________________
______xxxxxxx_________xx___________|______xxxxxxx_________xxx__________
_____xxxxxxxxxx____xxxxxx__________|_____xxxxxxxxxx____xxxxxx__________
_____xxxxxxxxxxxxxxxxxxxxx_________|_____xxxxxxxxxxxxxxxxxxxxx_________
____xxxxxxxxxxx____xxxxxxxx________|____xxxxxxxxxxx____xxxxxxxx________
____xxxxxxxxx________xxxxxxx_______|____xxxxxxxxx________xxxxxxx_______
___xxxxxxxx_____________xxxxx______|___xxxxxxxx_____________xxxxx______
___xxxxxx_________________xxxx_____|___xxxxxx_________________xxxx_____
__xxxxx_____________________xxx____|__xxxxx_____________________xxx____
__xxx_________________________xx___|__xxx_________________________xx___
_xx_____________________________x__|_xx_____________________________x__
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kEvenOdd_FillType, 1, 1, 7, 12, 1, 3, 4, 15 },
/*
___________________________________|___________________________________
_xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx__|_xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx__
__xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx___|__xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx___
__xxxxxxxxxxxxxxxxxxxxxxxxxxxx_____|__xxxxxxxxxxxxxxxxxxxxxxxxxxxx_____
___xxxxxxxxxx__xxxxxxxxxxxxxx______|___xxxxxxxxxx__xxxxxxxxxxxxxx______
___xxxxxxx______xxxxxxxxxxx________|___xxxxxxx______xxxxxxxxxxx________
____xxx__________xxxxxxxxx_________|____xxx__________xxxxxxxxx_________
____x_____________xxxxxxx__________|____x_____________xxxxxxx__________
__xx_______________xxxx____________|__xxx______________xxxx____________
___xx_______________xx_____________|___xx_______________xx_____________
____________________x______________|____________________x______________
______x____________xxx_____________|______x____________xxx_____________
______xxx_________xxxxx____________|______xxx_________xxxxx____________
_______xxxx_____xxxxxxxx___________|_______xxxx_____xxxxxxxx___________
_______xxxxxx__xxxxxxxxx___________|_______xxxxxx__xxxxxxxxxx__________
________xxxxx__xxxxxxxxxx__________|________xxxxx__xxxxxxxxxx__________
________xxxx_____xxxxxxxxx_________|________xxxx_____xxxxxxxxx_________
_________xxx_______xxxxxxxx________|_________xxx_______xxxxxxxx________
_________xxx_________xxxxxxx_______|_________xxx_________xxxxxxx_______
__________xx____________xxxxx______|__________xx____________xxxxx______
__________xx______________xxxx_____|__________xx______________xxxx_____
___________x________________xxx____|___________x________________xxx____
___________x__________________xx___|___________x__________________xx___
___________x____________________x__|___________x____________________x__
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kWinding_FillType, 1, 2, 4, 15, 0, 3, 9, 13 },
/*
___________________________________|___________________________________
_xxxxxxxxxxx_________xxxxxxxxxxxx__|_xxxxxxxxxxx_________xxxxxxxxxxxx__
__xxxxxxxxxxx______xxxxxxxxxxxxx___|__xxxxxxxxxxx______xxxxxxxxxxxxx___
__xxxxxxxxxxxx__xxxxxxxxxxxxxx_____|__xxxxxxxxxxxx__xxxxxxxxxxxxxx_____
___xxxxxxxxxx__xxxxxxxxxxxxxx______|___xxxxxxxxxx__xxxxxxxxxxxxxx______
___xxxxxxx______xxxxxxxxxxx________|___xxxxxxx______xxxxxxxxxxx________
____xxx__________xxxxxxxxx_________|____xxx__________xxxxxxxxx_________
____x_____________xxxxxxx__________|____x_____________xxxxxxx__________
__xx_______________xxxx____________|__xxx______________xxxx____________
___xx_______________xx_____________|___xx_______________xx_____________
____________________x______________|____________________x______________
______x____________xxx_____________|______x____________xxx_____________
______xxx_________xxxxx____________|______xxx_________xxxxx____________
_______xxxx_____xxxxxxxx___________|_______xxxx_____xxxxxxxx___________
_______xxxxxx__xxxxxxxxx___________|_______xxxxxx__xxxxxxxxxx__________
________xxxxx__xxxxxxxxxx__________|________xxxxx__xxxxxxxxxx__________
________xxxx_____xxxxxxxxx_________|________xxxx_____xxxxxxxxx_________
_________xxx_______xxxxxxxx________|_________xxx_______xxxxxxxx________
_________xxx_________xxxxxxx_______|_________xxx_________xxxxxxx_______
__________xx____________xxxxx______|__________xx____________xxxxx______
__________xx______________xxxx_____|__________xx______________xxxx_____
___________x________________xxx____|___________x________________xxx____
___________x__________________xx___|___________x__________________xx___
___________x____________________x__|___________x____________________x__
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kEvenOdd_FillType, 1, 2, 4, 15, 0, 3, 9, 13 },
/*
___________________________________|___________________________________
_x__________xxxxxxxxx______________|_x__________xxxxxxxxx______________
__xxx________xxxxxx________________|__xxx________xxxxxx________________
__xxxxxx______xx___________________|__xxxxxx______xx___________________
___xxxxxxxx__xx____________________|___xxxxxxxx__xx____________________
___xxxxxxx____xx___________________|___xxxxxxx____xx___________________
____xxx_________x__________________|____xxx_________x__________________
____x_____________x________________|____x_____________x________________
__xx_______________xxx_____________|__xxx______________xxx_____________
___xx_______________xx_____________|___xx_______________xx_____________
____________________x______________|____________________x______________
______x____________xxx_____________|______x____________xxx_____________
______xxx_________xxxxx____________|______xxx_________xxxxx____________
_______xxxx_____xxxxxxxx___________|_______xxxx_____xxxxxxxx___________
_______xxxxxx__xxxxxxxxx___________|_______xxxxxx__xxxxxxxxxx__________
________xxxxx__xxxxxxxxxx__________|________xxxxx__xxxxxxxxxx__________
________xxxx_____xxxxxxxxx_________|________xxxx_____xxxxxxxxx_________
_________xxx_______xxxxxxxx________|_________xxx_______xxxxxxxx________
_________xxx_________xxxxxxx_______|_________xxx_________xxxxxxx_______
__________xx____________xxxxx______|__________xx____________xxxxx______
__________xx______________xxxx_____|__________xx______________xxxx_____
___________x________________xxx____|___________x________________xxx____
___________x__________________xx___|___________x__________________xx___
___________x____________________x__|___________x____________________x__
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kWinding_FillType, 1, 2, 4, 15, 0, 6, 9, 13 },
/*
___________________________________|___________________________________
_x__________xxxxxxxxx______________|_x__________xxxxxxxxx______________
__xxx________xxxxxx________________|__xxx________xxxxxx________________
__xxxxxx______xx___________________|__xxxxxx______xx___________________
___xxxxxxxx__xx____________________|___xxxxxxxx__xx____________________
___xxxxxxx____xx___________________|___xxxxxxx____xx___________________
____xxx_________x__________________|____xxx_________x__________________
____x_____________x________________|____x_____________x________________
__xx_______________xxx_____________|__xxx______________xxx_____________
___xx_______________xx_____________|___xx_______________xx_____________
____________________x______________|____________________x______________
______x____________xxx_____________|______x____________xxx_____________
______xxx_________xxxxx____________|______xxx_________xxxxx____________
_______xxxx_____xxxxxxxx___________|_______xxxx_____xxxxxxxx___________
_______xxxxxx__xxxxxxxxx___________|_______xxxxxx__xxxxxxxxxx__________
________xxxxx__xxxxxxxxxx__________|________xxxxx__xxxxxxxxxx__________
________xxxx_____xxxxxxxxx_________|________xxxx_____xxxxxxxxx_________
_________xxx_______xxxxxxxx________|_________xxx_______xxxxxxxx________
_________xxx_________xxxxxxx_______|_________xxx_________xxxxxxx_______
__________xx____________xxxxx______|__________xx____________xxxxx______
__________xx______________xxxx_____|__________xx______________xxxx_____
___________x________________xxx____|___________x________________xxx____
___________x__________________xx___|___________x__________________xx___
___________x____________________x__|___________x____________________x__
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kEvenOdd_FillType, 1, 2, 4, 15, 0, 6, 9, 13 },
/*
___________________________________|___________________________________
_______________________xxxxxxxxx___|_______________________xxxxxxxxx___
___________xx____________xx________|___________xx____________xx________
___________xxx_________xxx_________|___________xxx_________xxx_________
__________xxxxx____xxxxxxxxx_______|__________xxxxx____xxxxxxxxx_______
__________xxxxx_xxxxxxxxxxxxx______|__________xxxxx_xxxxxxxxxxxxx______
_________xx______xxxxxxxxxxxxx_____|_________x_______xxxxxxxxxxxxx_____
______xxx_________xxxxxxxxxxxxxx___|______xxx_________xxxxxxxxxxxxxx___
__xxxxxx___________xxxxxxxxxxxxxx__|__xxxxxx___________xxxxxxxxxxxxxx__
___xxxxx____________xxxxxxxxxxxx___|___xxxxx____________xxxxxxxxxxxx___
_____xx______________xxxxxxxxx_____|_____xx______________xxxxxxxxx_____
______________________xxxxxx_______|______________________xxxxxx_______
_______xx______________xxx_________|_______xx______________xxx_________
______xxxxx________________________|______xxxxx________________________
______xxxxxxx_________xx___________|______xxxxxxx_________xxx__________
_____xxxxxxxxxx____xxxxxx__________|_____xxxxxxxxxx____xxxxxx__________
_____xxxxxxxxxxxxxxxxxxxxx_________|_____xxxxxxxxxxxxxxxxxxxxx_________
____xxxxxxxxxxx____xxxxxxxx________|____xxxxxxxxxxx____xxxxxxxx________
____xxxxxxxxx________xxxxxxx_______|____xxxxxxxxx________xxxxxxx_______
___xxxxxxxx_____________xxxxx______|___xxxxxxxx_____________xxxxx______
___xxxxxx_________________xxxx_____|___xxxxxx_________________xxxx_____
__xxxxx_____________________xxx____|__xxxxx_____________________xxx____
__xxx_________________________xx___|__xxx_________________________xx___
_xx_____________________________x__|_xx_____________________________x__
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kEvenOdd_FillType, 1, 2, 7, 12, 1, 3, 4, 15 },
/*
___________________________________|___________________________________
_____________xxxxxxxxxxxxxxxxxxx___|_____________xxxxxxxxxxxxxxxxxxx___
___________xx___xxxxxxxxxxx________|___________xx___xxxxxxxxxxx________
___________xxx_____xxxx____________|___________xxx_____xxxx____________
__________xxxxx____xxx_____________|__________xxxxx____xxx_____________
__________xxxxx_xxxxxxxx___________|__________xxxxx_xxxxxxxxx__________
_________xx______xxxxxxxxxx________|_________x_______xxxxxxxxxx________
______xxx_________xxxxxxxxxxxx_____|______xxx_________xxxxxxxxxxxx_____
__xxxxxx___________xxxxxxxxxxxxxx__|__xxxxxx___________xxxxxxxxxxxxxx__
___xxxxx____________xxxxxxxxxxxx___|___xxxxx____________xxxxxxxxxxxx___
_____xx______________xxxxxxxxx_____|_____xx______________xxxxxxxxx_____
______________________xxxxxx_______|______________________xxxxxx_______
_______xx______________xxx_________|_______xx______________xxx_________
______xxxxx________________________|______xxxxx________________________
______xxxxxxx_________xx___________|______xxxxxxx_________xxx__________
_____xxxxxxxxxx____xxxxxx__________|_____xxxxxxxxxx____xxxxxx__________
_____xxxxxxxxxxxxxxxxxxxxx_________|_____xxxxxxxxxxxxxxxxxxxxx_________
____xxxxxxxxxxx____xxxxxxxx________|____xxxxxxxxxxx____xxxxxxxx________
____xxxxxxxxx________xxxxxxx_______|____xxxxxxxxx________xxxxxxx_______
___xxxxxxxx_____________xxxxx______|___xxxxxxxx_____________xxxxx______
___xxxxxx_________________xxxx_____|___xxxxxx_________________xxxx_____
__xxxxx_____________________xxx____|__xxxxx_____________________xxx____
__xxx_________________________xx___|__xxx_________________________xx___
_xx_____________________________x__|_xx_____________________________x__
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kEvenOdd_FillType, 1, 3, 4, 15, 1, 1, 7, 12 },
/*
___________________________________|___________________________________
_______________________xxxxxxxxx___|_______________________xxxxxxxxx___
___________xx____________xx________|___________xx____________xx________
___________xxx_________xxx_________|___________xxx_________xxx_________
__________xxxxx____xxxxxxxxx_______|__________xxxxx____xxxxxxxxx_______
__________xxxxx_xxxxxxxxxxxxx______|__________xxxxx_xxxxxxxxxxxxx______
_________xx______xxxxxxxxxxxxx_____|_________x_______xxxxxxxxxxxxx_____
______xxx_________xxxxxxxxxxxxxx___|______xxx_________xxxxxxxxxxxxxx___
__xxxxxx___________xxxxxxxxxxxxxx__|__xxxxxx___________xxxxxxxxxxxxxx__
___xxxxx____________xxxxxxxxxxxx___|___xxxxx____________xxxxxxxxxxxx___
_____xx______________xxxxxxxxx_____|_____xx______________xxxxxxxxx_____
______________________xxxxxx_______|______________________xxxxxx_______
_______xx______________xxx_________|_______xx______________xxx_________
______xxxxx________________________|______xxxxx________________________
______xxxxxxx_________xx___________|______xxxxxxx_________xxx__________
_____xxxxxxxxxx____xxxxxx__________|_____xxxxxxxxxx____xxxxxx__________
_____xxxxxxxxxxxxxxxxxxxxx_________|_____xxxxxxxxxxxxxxxxxxxxx_________
____xxxxxxxxxxx____xxxxxxxx________|____xxxxxxxxxxx____xxxxxxxx________
____xxxxxxxxx________xxxxxxx_______|____xxxxxxxxx________xxxxxxx_______
___xxxxxxxx_____________xxxxx______|___xxxxxxxx_____________xxxxx______
___xxxxxx_________________xxxx_____|___xxxxxx_________________xxxx_____
__xxxxx_____________________xxx____|__xxxxx_____________________xxx____
__xxx_________________________xx___|__xxx_________________________xx___
_xx_____________________________x__|_xx_____________________________x__
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kEvenOdd_FillType, 1, 3, 4, 15, 1, 2, 7, 12 },
/*
___________________________________|___________________________________
________________________________xx_|________________________________xx_
___________xx______________xxxxxxx_|___________xx______________xxxxxxx_
___________xxx_________xxxxxxxxxxx_|___________xxx_________xxxxxxxxxxx_
__________xxxxx____xxxxxxxxxxxxxxx_|__________xxxxx____xxxxxxxxxxxxxxx_
__________xxxxx_xxxxxxxxxxxxxxxxxx_|__________xxxxx_xxxxxxxxxxxxxxxxxx_
_________xx______xxxxxxxxxxxxxxxxx_|_________x_______xxxxxxxxxxxxxxxxx_
______xxx_________xxxxxxxxxxxxxxxx_|______xxx_________xxxxxxxxxxxxxxxx_
__xxxxxx___________xxxxxxxxxxxxxxx_|__xxxxxx___________xxxxxxxxxxxxxxx_
___xxxxx____________xxxxxxxxxxxx___|___xxxxx____________xxxxxxxxxxxx___
_____xx______________xxxxxxxxx_____|_____xx______________xxxxxxxxx_____
______________________xxxxxx_______|______________________xxxxxx_______
_______xx______________xxx_________|_______xx______________xxx_________
______xxxxx________________________|______xxxxx________________________
______xxxxxxx_________xx___________|______xxxxxxx_________xxx__________
_____xxxxxxxxxx____xxxxxx__________|_____xxxxxxxxxx____xxxxxx__________
_____xxxxxxxxxxxxxxxxxxxxx_________|_____xxxxxxxxxxxxxxxxxxxxx_________
____xxxxxxxxxxx____xxxxxxxx________|____xxxxxxxxxxx____xxxxxxxx________
____xxxxxxxxx________xxxxxxx_______|____xxxxxxxxx________xxxxxxx_______
___xxxxxxxx_____________xxxxx______|___xxxxxxxx_____________xxxxx______
___xxxxxx_________________xxxx_____|___xxxxxx_________________xxxx_____
__xxxxx_____________________xxx____|__xxxxx_____________________xxx____
__xxx_________________________xx___|__xxx_________________________xx___
_xx_____________________________x__|_xx_____________________________x__
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kEvenOdd_FillType, 1, 3, 4, 15, 1, 3, 7, 12 },
/*
___________________________________|___________________________________
_____________xxxxxxxxxxxxxxxxxxx___|_____________xxxxxxxxxxxxxxxxxxx___
___________xx___xxxxxxxxxxx________|___________xx___xxxxxxxxxxx________
___________xxx_____xxxx____________|___________xxx_____xxxx____________
__________xxxxx____xxx_____________|__________xxxxx____xxx_____________
__________xxxxx_xxxxxxxx___________|__________xxxxx_xxxxxxxxx__________
_________xx______xxxxxxxxxx________|_________x_______xxxxxxxxxx________
______xxx_________xxxxxxxxxxxx_____|______xxx_________xxxxxxxxxxxx_____
__xxxxxx___________xxxxxxxxxxxxxx__|__xxxxxx___________xxxxxxxxxxxxxx__
___xxxxx____________xxxxxxxxxxxx___|___xxxxx____________xxxxxxxxxxxx___
_____xx______________xxxxxxxxx_____|_____xx______________xxxxxxxxx_____
______________________xxxxxx_______|______________________xxxxxx_______
_______xx______________xxx_________|_______xx______________xxx_________
______xxxxx________________________|______xxxxx________________________
______xxxxxxx_________xx___________|______xxxxxxx_________xxx__________
_____xxxxxxxxxx____xxxxxx__________|_____xxxxxxxxxx____xxxxxx__________
_____xxxxxxxxxxxxxxxxxxxxx_________|_____xxxxxxxxxxxxxxxxxxxxx_________
____xxxxxxxxxxx____xxxxxxxx________|____xxxxxxxxxxx____xxxxxxxx________
____xxxxxxxxx________xxxxxxx_______|____xxxxxxxxx________xxxxxxx_______
___xxxxxxxx_____________xxxxx______|___xxxxxxxx_____________xxxxx______
___xxxxxx_________________xxxx_____|___xxxxxx_________________xxxx_____
__xxxxx_____________________xxx____|__xxxxx_____________________xxx____
__xxx_________________________xx___|__xxx_________________________xx___
_xx_____________________________x__|_xx_____________________________x__
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kEvenOdd_FillType, 1, 3, 4, 15, 1, 7, 7, 12 },
/*
___________________________________|___________________________________
_____________xxxxxxxxxxxxxxxxxxx___|_____________xxxxxxxxxxxxxxxxxxx___
___________xx___xxxxxxxxxxx________|___________xx___xxxxxxxxxxx________
___________xxx_____xxxx____________|___________xxx_____xxxx____________
__________xxxxx____xxx_____________|__________xxxxx____xxx_____________
__________xxxxx_xxxxxxxx___________|__________xxxxx_xxxxxxxxx__________
_________xx______xxxxxxxxxx________|_________x_______xxxxxxxxxx________
______xxx_________xxxxxxxxxxxx_____|______xxx_________xxxxxxxxxxxx_____
__xxxxxx___________xxxxxxxxxxxxxx__|__xxxxxx___________xxxxxxxxxxxxxx__
___xxxxx____________xxxxxxxxxxxx___|___xxxxx____________xxxxxxxxxxxx___
_____xx______________xxxxxxxxx_____|_____xx______________xxxxxxxxx_____
______________________xxxxxx_______|______________________xxxxxx_______
_______xx______________xxx_________|_______xx______________xxx_________
______xxxxx________________________|______xxxxx________________________
______xxxxxxx_________xx___________|______xxxxxxx_________xxx__________
_____xxxxxxxxxx____xxxxxx__________|_____xxxxxxxxxx____xxxxxx__________
_____xxxxxxxxxxxxxxxxxxxxx_________|_____xxxxxxxxxxxxxxxxxxxxx_________
____xxxxxxxxxxx____xxxxxxxx________|____xxxxxxxxxxx____xxxxxxxx________
____xxxxxxxxx________xxxxxxx_______|____xxxxxxxxx________xxxxxxx_______
___xxxxxxxx_____________xxxxx______|___xxxxxxxx_____________xxxxx______
___xxxxxx_________________xxxx_____|___xxxxxx_________________xxxx_____
__xxxxx_____________________xxx____|__xxxxx_____________________xxx____
__xxx_________________________xx___|__xxx_________________________xx___
_xx_____________________________x__|_xx_____________________________x__
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kEvenOdd_FillType, 1, 3, 4, 15, 1, 7, 12, 12 },
/*
___________________________________|___________________________________
________________________________xx_|________________________________xx_
___________xx______________xxxxxxx_|___________xx______________xxxxxxx_
___________xxx_________xxxxxxxxxxx_|___________xxx_________xxxxxxxxxxx_
__________xxxxx____xxxxxxxxxxxxxxx_|__________xxxxx____xxxxxxxxxxxxxxx_
__________xxxxx_xxxxxxxxxxxxxxxxxx_|__________xxxxx_xxxxxxxxxxxxxxxxxx_
_________xx______xxxxxxxxxxxxxxxxx_|_________x_______xxxxxxxxxxxxxxxxx_
______xxx_________xxxxxxxxxxxxxxxx_|______xxx_________xxxxxxxxxxxxxxxx_
__xxxxxx___________xxxxxxxxxxxxxxx_|__xxxxxx___________xxxxxxxxxxxxxxx_
___xxxxx____________xxxxxxxxxxxx___|___xxxxx____________xxxxxxxxxxxx___
_____xx______________xxxxxxxxx_____|_____xx______________xxxxxxxxx_____
______________________xxxxxx_______|______________________xxxxxx_______
_______xx______________xxx_________|_______xx______________xxx_________
______xxxxx________________________|______xxxxx________________________
______xxxxxxx_________xx___________|______xxxxxxx_________xxx__________
_____xxxxxxxxxx____xxxxxx__________|_____xxxxxxxxxx____xxxxxx__________
_____xxxxxxxxxxxxxxxxxxxxx_________|_____xxxxxxxxxxxxxxxxxxxxx_________
____xxxxxxxxxxx____xxxxxxxx________|____xxxxxxxxxxx____xxxxxxxx________
____xxxxxxxxx________xxxxxxx_______|____xxxxxxxxx________xxxxxxx_______
___xxxxxxxx_____________xxxxx______|___xxxxxxxx_____________xxxxx______
___xxxxxx_________________xxxx_____|___xxxxxx_________________xxxx_____
__xxxxx_____________________xxx____|__xxxxx_____________________xxx____
__xxx_________________________xx___|__xxx_________________________xx___
_xx_____________________________x__|_xx_____________________________x__
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kEvenOdd_FillType, 1, 3, 7, 12, 1, 3, 4, 15 },
/*
___________________________________|___________________________________
____________xxxxxxxxxxxxxxxxxxxxx__|____________xxxxxxxxxxxxxxxxxxxxx__
_____________xxxxxxxxxxxxxxxxxxx___|_____________xxxxxxxxxxxxxxxxxxx___
______________xxxxxxxxx_xxxxxx_____|______________xxxxxxxxx_xxxxxx_____
_______________xxxxxxxx_xxxxx______|_______________xxxxxxxx_xxxxx______
________________xxxxxxx__xx________|________________xxxxxxx__xx________
_________________xxxxxx__x_________|_________________xxxxxx__x_________
__________________xxxxx__x_________|__________________xxxxx__x_________
___________________xxxxxxx_________|___________________xxxxxxx_________
____________________x_xxxxx________|____________________x_xxxxx________
__________________xx_xxxxxx________|__________________xx_xxxxxx________
_______________xxxx___xxxxxx_______|_______________xxxx___xxxxxx_______
____________xxxxxx_____xxxxx_______|____________xxxxxx_____xxxxx_______
_________xxxxxxx________xxxxx______|_________xxxxxxx________xxxxx______
_______xxxxxxxx_________xxxxx______|_______xxxxxxxx__________xxxx______
____xxxxxxxxx____________xxxxx_____|____xxxxxxxxx____________xxxxx_____
_xxxxxxxxxxx______________xxxx_____|_xxxxxxxxxxx______________xxxx_____
_____xxxxxx________________xxx_____|_____xxxxxx________________xxx_____
____________________________xxx____|____________________________xxx____
________xxxxx________________xx____|________xxxxx________________xx____
______xxxxxxxxxxxx____________xx___|______xxxxxxxxxxxx____________xx___
_____xxxxxxxxxxxxxxxxx_________x___|_____xxxxxxxxxxxxxxxxx_________x___
____xxxxxxxxxxxxxxxxxxxxxx______x__|____xxxxxxxxxxxxxxxxxxxxxx______x__
__xxxxxxxxxxxxxxxxxxxxxxxxxxxx_____|__xxxxxxxxxxxxxxxxxxxxxxxxxxxx_____
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kEvenOdd_FillType, 1, 3, 12, 15, 2, 6, 8, 15 },
/*
___________________________________|___________________________________
_x_________x_______________________|_x_________x_______________________
__x_______xxx______________________|__x_______xxx______________________
___x____xxxxxx_____________________|___x____xxxxxx_____________________
____xx_xxxxxxxx____________________|____xx_xxxxxxxx____________________
_____x_xxxxxxxxx___________________|_____x_xxxxxxxxx___________________
____xx___xxxxxxxx__________________|____xx___xxxxxxxx__________________
___xxxx___xxxxxxxx_________________|___xxxx___xxxxxxxx_________________
_xxxxxxx___xxxxxxxx________________|_xxxxxxx____xxxxxxx________________
__xxxxxxx____xxxxxxx_______________|__xxxxxxx____xxxxxxx_______________
___xxxxxxx____xxxxxxx______________|___xxxxxxx____xxxxxxx______________
_____xxxxxx_____xxxxxx_____________|_____xxxxxx_____xxxxxx_____________
______xxxxxx_____xxxxxx____________|______xxxxxx_____xxxxxx____________
________xxxxx______xxxxx___________|________xxxxx______xxxxx___________
_________xxxxx______xxxx___________|_________xxxxx______xxxx___________
__________xxxxx______xxxx__________|__________xxxxx______xxxx__________
____________xxx________xxx_________|____________xxx________xxx_________
_______________x___________xxxxx___|_______________x___________xxxxx___
____________________________xxx____|____________________________xxx____
__________________xx_______________|__________________xx_________x_____
___________________xxxx_____xx_____|___________________xxxx_____xx_____
____________________xxxxxx_xxxx____|____________________xxxxxx_xxxx____
_____________________xxxx____xxx___|_____________________xxxx____xxx___
______________________xx_______xx__|______________________xx_______xx__
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kWinding_FillType, 1, 4, 9, 15, 0, 10, 11, 14 },
/*
___________________________________|___________________________________
_x_________x_______________________|_x_________x_______________________
__x_______xxx______________________|__x_______xxx______________________
___x____xxxxxx_____________________|___x____xxxxxx_____________________
____xx_xxxxxxxx____________________|____xx_xxxxxxxx____________________
_____x_xxxxxxxxx___________________|_____x_xxxxxxxxx___________________
____xx___xxxxxxxx__________________|____xx___xxxxxxxx__________________
___xxxx___xxxxxxxx_________________|___xxxx___xxxxxxxx_________________
_xxxxxxx___xxxxxxxx________________|_xxxxxxx____xxxxxxx________________
__xxxxxxx____xxxxxxx_______________|__xxxxxxx____xxxxxxx_______________
___xxxxxxx____xxxxxxx______________|___xxxxxxx____xxxxxxx______________
_____xxxxxx_____xxxxxx_____________|_____xxxxxx_____xxxxxx_____________
______xxxxxx_____xxxxxx____________|______xxxxxx_____xxxxxx____________
________xxxxx______xxxxx___________|________xxxxx______xxxxx___________
_________xxxxx______xxxx___________|_________xxxxx______xxxx___________
__________xxxxx______xxxx__________|__________xxxxx______xxxx__________
____________xxx________xxx_________|____________xxx________xxx_________
_______________x___________xxxxx___|_______________x___________xxxxx___
____________________________xxx____|____________________________xxx____
__________________xx_______________|__________________xx_________x_____
___________________xxxx_____xx_____|___________________xxxx_____xx_____
____________________xxxxxx_xxxx____|____________________xxxxxx_xxxx____
_____________________xxxx____xxx___|_____________________xxxx____xxx___
______________________xx_______xx__|______________________xx_______xx__
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kEvenOdd_FillType, 1, 4, 9, 15, 0, 10, 11, 14 },
/*
___________________________________|___________________________________
____________x__________xxxxxxxxxx__|____________x__________xxxxxxxxxx__
_____________x_________xxxxxxxxx___|_____________x_________xxxxxxxxx___
______________x_________xxxxxx_____|______________x_________xxxxxx_____
_______________xx_______xxxxx______|_______________xx_______xxxxx______
________________xx_______xx________|________________xx_______xx________
_________________xxx_____x_________|_________________xxx_____x_________
__________________xxx____x_________|__________________xxx____x_________
___________________xxx_xxx_________|___________________xxx_xxx_________
____________________x_xxxxx________|____________________x_xxxxx________
__________________xx_xxxxxx________|__________________xx_xxxxxx________
_______________xxxx___xxxxxx_______|_______________xxxx___xxxxxx_______
____________xxxxxx_____xxxxx_______|____________xxxxxx_____xxxxx_______
_________xxxxxxx________xxxxx______|_________xxxxxxx________xxxxx______
_______xxxxxxxx_________xxxxx______|_______xxxxxxxx__________xxxx______
____xxxxxxxxx____________xxxxx_____|____xxxxxxxxx____________xxxxx_____
_xxxxxxxxxxx______________xxxx_____|_xxxxxxxxxxx______________xxxx_____
_____xxxxxx________________xxx_____|_____xxxxxx________________xxx_____
____________________________xxx____|____________________________xxx____
________xxxxx________________xx____|________xxxxx________________xx____
______xxxxxxxxxxxx____________xx___|______xxxxxxxxxxxx____________xx___
_____xxxxxxxxxxxxxxxxx_________x___|_____xxxxxxxxxxxxxxxxx_________x___
____xxxxxxxxxxxxxxxxxxxxxx______x__|____xxxxxxxxxxxxxxxxxxxxxx______x__
__xxxxxxxxxxxxxxxxxxxxxxxxxxxx_____|__xxxxxxxxxxxxxxxxxxxxxxxxxxxx_____
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kEvenOdd_FillType, 1, 6, 8, 15, 2, 3, 12, 15 },
/*
___________________________________|___________________________________
____________x________x_____________|____________x________x_____________
_____________x_____xx______________|_____________x_____xx______________
______________x_xxxx_______________|______________x_xxxx_______________
_____________xx__xx________________|_____________xx__xx________________
__________xxxxxx__x________________|__________xxxxxx__x________________
_______xxxxxxxxxx_xx_______________|_______xxxxxxxxxx_xx_______________
_____xxxxxxxxxxxx_xxx______________|_____xxxxxxxxxxxx_xxx______________
__xxxxxxxxxxxxxx___xxx_____________|__xxxxxxxxxxxxxx___xxx_____________
____xxxxxxxxxxx_____xx_____________|____xxxxxxxxxxx_____xx_____________
________xxxxxx______x______________|________xxxxxx______x______________
____________x______xxx_____________|____________x______xxx_____________
____________xxxxx_xxxxx____________|____________xxxxx_xxxxx____________
___________xxxxx_____xxx___________|___________xxxxx_____xxx___________
__________xxxxx_________x__________|__________xxxxx____________________
_________xxxx____________xxxx______|_________xxxx____________xxxx______
________xxxx______________xxxxxxxx_|________xxxx______________xxxxxxxx_
_______xxxxxxxx____________xxx_____|_______xxxxxxxx____________xxx_____
______xxxxxxxxxxx________xxx_______|______xxxxxxxxxxx________xxx_______
_____xxxxxxxxxxxxxxx_xxxxxxxx______|_____xxxxxxxxxxxxxxx_xxxxxxxx______
_____xxxxxxxxxxxx______xxxxxxx_____|_____xxxxxxxxxxxx______xxxxxxx_____
____xxxxxxxxx_____________xxxxx____|____xxxxxxxxx_____________xxxxx____
___xxxxxx____________________xxx___|___xxxxxx____________________xxx___
__xx___________________________xx__|__xx___________________________xx__
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kWinding_FillType, 1, 6, 9, 15, 2, 4, 11, 12 },
/*
___________________________________|___________________________________
____________x________x_____________|____________x________x_____________
_____________x_____xx______________|_____________x_____xx______________
______________x_xxxx_______________|______________x_xxxx_______________
_____________xx__xx________________|_____________xx__xx________________
__________xxxxxx__x________________|__________xxxxxx__x________________
_______xxxxxxxxxx_xx_______________|_______xxxxxxxxxx_xx_______________
_____xxxxxxxxxxxx_xxx______________|_____xxxxxxxxxxxx_xxx______________
__xxxxxxxxxxxxxx___xxx_____________|__xxxxxxxxxxxxxx___xxx_____________
____xxxxxxxxxxx_____xx_____________|____xxxxxxxxxxx_____xx_____________
________xxxxxx______x______________|________xxxxxx______x______________
____________x______xxx_____________|____________x______xxx_____________
____________xxxxx_xxxxx____________|____________xxxxx_xxxxx____________
___________xxxxx_____xxx___________|___________xxxxx_____xxx___________
__________xxxxx_________x__________|__________xxxxx____________________
_________xxxx____________xxxx______|_________xxxx____________xxxx______
________xxxx______________xxxxxxxx_|________xxxx______________xxxxxxxx_
_______xxxxxxxx____________xxx_____|_______xxxxxxxx____________xxx_____
______xxxxxxxxxxx________xxx_______|______xxxxxxxxxxx________xxx_______
_____xxxxxxxxxxxxxxx_xxxxxxxx______|_____xxxxxxxxxxxxxxx_xxxxxxxx______
_____xxxxxxxxxxxx______xxxxxxx_____|_____xxxxxxxxxxxx______xxxxxxx_____
____xxxxxxxxx_____________xxxxx____|____xxxxxxxxx_____________xxxxx____
___xxxxxx____________________xxx___|___xxxxxx____________________xxx___
__xx___________________________xx__|__xx___________________________xx__
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kEvenOdd_FillType, 1, 6, 9, 15, 2, 4, 11, 12 },
/*
___________________________________|___________________________________
_____________xxxxxxxxxxxxxxxxxxx___|_____________xxxxxxxxxxxxxxxxxxx___
___________xx___xxxxxxxxxxx________|___________xx___xxxxxxxxxxx________
___________xxx_____xxxx____________|___________xxx_____xxxx____________
__________xxxxx____xxx_____________|__________xxxxx____xxx_____________
__________xxxxx_xxxxxxxx___________|__________xxxxx_xxxxxxxxx__________
_________xx______xxxxxxxxxx________|_________x_______xxxxxxxxxx________
______xxx_________xxxxxxxxxxxx_____|______xxx_________xxxxxxxxxxxx_____
__xxxxxx___________xxxxxxxxxxxxxx__|__xxxxxx___________xxxxxxxxxxxxxx__
___xxxxx____________xxxxxxxxxxxx___|___xxxxx____________xxxxxxxxxxxx___
_____xx______________xxxxxxxxx_____|_____xx______________xxxxxxxxx_____
______________________xxxxxx_______|______________________xxxxxx_______
_______xx______________xxx_________|_______xx______________xxx_________
______xxxxx________________________|______xxxxx________________________
______xxxxxxx_________xx___________|______xxxxxxx_________xxx__________
_____xxxxxxxxxx____xxxxxx__________|_____xxxxxxxxxx____xxxxxx__________
_____xxxxxxxxxxxxxxxxxxxxx_________|_____xxxxxxxxxxxxxxxxxxxxx_________
____xxxxxxxxxxx____xxxxxxxx________|____xxxxxxxxxxx____xxxxxxxx________
____xxxxxxxxx________xxxxxxx_______|____xxxxxxxxx________xxxxxxx_______
___xxxxxxxx_____________xxxxx______|___xxxxxxxx_____________xxxxx______
___xxxxxx_________________xxxx_____|___xxxxxx_________________xxxx_____
__xxxxx_____________________xxx____|__xxxxx_____________________xxx____
__xxx_________________________xx___|__xxx_________________________xx___
_xx_____________________________x__|_xx_____________________________x__
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kEvenOdd_FillType, 1, 7, 7, 12, 1, 3, 4, 15 },
/*
___________________________________|___________________________________
____________x____________________x_|____________x____________________x_
_____________xxx_________________x_|_____________xxx_________________x_
______________xxxxx_____________xx_|______________xxxxx_____________xx_
_______________xxxxxxx__________xx_|_______________xxxxxxx__________xx_
________________xxxxxxxx________xx_|________________xxxxxxxx________xx_
_________________xxxxxxxxxx____xxx_|_________________xxxxxxxxxx____xxx_
__________________xxxxxxxxxxxx_xxx_|__________________xxxxxxxxxxxx_xxx_
___________________xxxxxxxxxxx___x_|___________________xxxxxxxxxxx___x_
____________________xxxxxxxxxx_xxx_|____________________xxxxxxxxxx_xxx_
_____________________xxxxx___xxxxx_|_____________________xxxxx___xxxxx_
_____________________________xxxxx_|_____________________________xxxxx_
__________________xxxxx_____xxxxxx_|__________________xxxxx_____xxxxxx_
______________xxxxxxxxxx____xxxxxx_|______________xxxxxxxxxx____xxxxxx_
__________xxxxxxxxxxxxxx___xxxxxxx_|__________xxxxxxxxxxxxxx___xxxxxxx_
_____xxxxxxxxxxxxxxxxxxxx__xxxxxxx_|_____xxxxxxxxxxxxxxxxxxxx__xxxxxxx_
_xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx_|_xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx_
_____xxxxxxxxxxxxxxxxxxxxx_xxxxx___|_____xxxxxxxxxxxxxxxxxxxxx_xxxxx___
_________xxxxxxxxxxxxxxxx___xxx____|_________xxxxxxxxxxxxxxxx___xxx____
_____________xxxxxxxxxxxx__________|_____________xxxxxxxxxxxx____x_____
__________________xxxxxxx___xx_____|__________________xxxxxxx___xx_____
______________________xx___xxxx____|______________________xx___xxxx____
________________________x_xxxxxx___|________________________x_xxxxxx___
_______________________x______xxx__|_______________________x______xxx__
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kEvenOdd_FillType, 1, 7, 8, 15, 3, 3, 11, 14 },
/*
___________________________________|___________________________________
____________x___________________x__|____________x___________________x__
_____________xxx___________xxxxxx__|_____________xxx___________xxxxxx__
______________xxxxx____xxxxxxxxx___|______________xxxxx____xxxxxxxxx___
_______________xxxx___xxxxxxxxxx___|_______________xxxx___xxxxxxxxxx___
_______________x________xxxxxxxx___|_______________x_________xxxxxxx___
___________xxxxxx__________xxxx____|___________xxxxxx__________xxxx____
______xxxxxxxxxxxx____________x____|______xxxxxxxxxxxx____________x____
__xxxxxxxxxxxxxxxxx___________xxx__|__xxxxxxxxxxxxxxxxx___________xxx__
____xxxxxxxxxxxxxxxx__________x____|____xxxxxxxxxxxxxxxx__________x____
________xxxxxxxxxxxxx_____xxx______|________xxxxxxxxxxxxx_____xxx______
____________xxxxxxxxxxxxxxxxx______|_____________xxxxxxxxxxxxxxxx______
_________________xxxxxxxxxxx_______|_________________xxxxxxxxxxx_______
______________xxxxxxxxxxxxxx_______|______________xxxxxxxxxxxxxx_______
__________xxxxxxxxxxxxxx_xx________|__________xxxxxxxxxxxxxxxxx________
_____xxxxxxxxxxxxxxxxxxxx__xx______|_____xxxxxxxxxxxxxxxxxxxx__xx______
_xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx_|_xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx_
_____xxxxxxxxxxxxxxxxxxxxx_xxxxx___|_____xxxxxxxxxxxxxxxxxxxxx_xxxxx___
_________xxxxxxxxxxxxxxxx___xxx____|_________xxxxxxxxxxxxxxxx___xxx____
_____________xxxxxxxxxxxx__________|_____________xxxxxxxxxxxx____x_____
__________________xxxxxxx___xx_____|__________________xxxxxxx___xx_____
______________________xx___xxxx____|______________________xx___xxxx____
________________________x_xxxxxx___|________________________x_xxxxxx___
_______________________x______xxx__|_______________________x______xxx__
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kWinding_FillType, 1, 7, 8, 15, 3, 4, 11, 14 },
/*
___________________________________|___________________________________
____________x___________________x__|____________x___________________x__
_____________xxx___________xxxxxx__|_____________xxx___________xxxxxx__
______________xxxxx____xxxxxxxxx___|______________xxxxx____xxxxxxxxx___
_______________xxxx___xxxxxxxxxx___|_______________xxxx___xxxxxxxxxx___
_______________x________xxxxxxxx___|_______________x_________xxxxxxx___
___________xxxxxx__________xxxx____|___________xxxxxx__________xxxx____
______xxxxxxxxxxxx____________x____|______xxxxxxxxxxxx____________x____
__xxxxxxxxxxxxxxxxx___________xxx__|__xxxxxxxxxxxxxxxxx___________xxx__
____xxxxxxxxxxxxxxxx__________x____|____xxxxxxxxxxxxxxxx__________x____
________xxxxxxxxxxxxx_____xxx______|________xxxxxxxxxxxxx_____xxx______
____________xxxxxxxxxxxxxxxxx______|_____________xxxxxxxxxxxxxxxx______
_________________x_____xxxxx_______|_________________x_____xxxxx_______
______________xxxxxxx___xxxx_______|______________xxxxxxx___xxxx_______
__________xxxxxxxxxxxxxx_xx________|__________xxxxxxxxxxxxxxxxx________
_____xxxxxxxxxxxxxxxxxxxx__xx______|_____xxxxxxxxxxxxxxxxxxxx__xx______
_xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx_|_xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx_
_____xxxxxxxxxxxxxxxxxxxxx_xxxxx___|_____xxxxxxxxxxxxxxxxxxxxx_xxxxx___
_________xxxxxxxxxxxxxxxx___xxx____|_________xxxxxxxxxxxxxxxx___xxx____
_____________xxxxxxxxxxxx__________|_____________xxxxxxxxxxxx____x_____
__________________xxxxxxx___xx_____|__________________xxxxxxx___xx_____
______________________xx___xxxx____|______________________xx___xxxx____
________________________x_xxxxxx___|________________________x_xxxxxx___
_______________________x______xxx__|_______________________x______xxx__
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kEvenOdd_FillType, 1, 7, 8, 15, 3, 4, 11, 14 },
/*
___________________________________|___________________________________
____________x______________________|____________x______________________
_____________xxx________________x__|_____________xxx________________x__
______________xxxxx___________xx___|______________xxxxx___________xx___
_______________xxxxxxx_______xxx___|_______________xxxxxxx_______xxx___
________________xxxxxxxx___xxxxx___|________________xxxxxxxxx__xxxxx___
_________________xxxxxxxxx_xxxx____|_________________xxxxxxxxx_xxxx____
__________________xxxxxxx_____x____|__________________xxxxxxx_____x____
___________________xxxx_______xxx__|___________________xxxx_______xxx__
____________________xxxx______x____|____________________xxxx______x____
_____________________xxxx_xxx______|_____________________xxxx_xxx______
___________________________xx______|___________________________xx______
__________________xxxxx____________|__________________xxxxx____________
______________xxxxxxxxxx____x______|______________xxxxxxxxxx____x______
__________xxxxxxxxxxxxxx___xxxx____|__________xxxxxxxxxxxxxx___xxxx____
_____xxxxxxxxxxxxxxxxxxxx__xxxxx___|_____xxxxxxxxxxxxxxxxxxxx__xxxxx___
_xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx_|_xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx_
_____xxxxxxxxxxxxxxxxxxxxx_xxxxx___|_____xxxxxxxxxxxxxxxxxxxxx_xxxxx___
_________xxxxxxxxxxxxxxxx___xxx____|_________xxxxxxxxxxxxxxxx___xxx____
_____________xxxxxxxxxxxx__________|_____________xxxxxxxxxxxx____x_____
__________________xxxxxxx___xx_____|__________________xxxxxxx___xx_____
______________________xx___xxxx____|______________________xx___xxxx____
________________________x_xxxxxx___|________________________x_xxxxxx___
_______________________x______xxx__|_______________________x______xxx__
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kWinding_FillType, 1, 7, 8, 15, 3, 6, 11, 14 },
/*
___________________________________|___________________________________
____________x______________________|____________x______________________
_____________xxx________________x__|_____________xxx________________x__
______________xxxxx___________xx___|______________xxxxx___________xx___
_______________xxxxxxx_______xxx___|_______________xxxxxxx_______xxx___
________________xxxxxxxx___xxxxx___|________________xxxxxxxxx__xxxxx___
_________________xxxxxxxxx_xxxx____|_________________xxxxxxxxx_xxxx____
__________________xxxxxxx_____x____|__________________xxxxxxx_____x____
___________________xxxx_______xxx__|___________________xxxx_______xxx__
____________________xxxx______x____|____________________xxxx______x____
_____________________xxxx_xxx______|_____________________xxxx_xxx______
___________________________xx______|___________________________xx______
__________________xxxxx____________|__________________xxxxx____________
______________xxxxxxxxxx____x______|______________xxxxxxxxxx____x______
__________xxxxxxxxxxxxxx___xxxx____|__________xxxxxxxxxxxxxx___xxxx____
_____xxxxxxxxxxxxxxxxxxxx__xxxxx___|_____xxxxxxxxxxxxxxxxxxxx__xxxxx___
_xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx_|_xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx_
_____xxxxxxxxxxxxxxxxxxxxx_xxxxx___|_____xxxxxxxxxxxxxxxxxxxxx_xxxxx___
_________xxxxxxxxxxxxxxxx___xxx____|_________xxxxxxxxxxxxxxxx___xxx____
_____________xxxxxxxxxxxx__________|_____________xxxxxxxxxxxx____x_____
__________________xxxxxxx___xx_____|__________________xxxxxxx___xx_____
______________________xx___xxxx____|______________________xx___xxxx____
________________________x_xxxxxx___|________________________x_xxxxxx___
_______________________x______xxx__|_______________________x______xxx__
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kEvenOdd_FillType, 1, 7, 8, 15, 3, 6, 11, 14 },
/*
___________________________________|___________________________________
____________x____________________x_|____________x____________________x_
_____________xxx_________________x_|_____________xxx_________________x_
______________xxxxx_____________xx_|______________xxxxx_____________xx_
_______________xxxxxxx__________xx_|_______________xxxxxxx__________xx_
________________xxxxxxxx________xx_|________________xxxxxxxx________xx_
_________________xxxxxxxxxx____xxx_|_________________xxxxxxxxxx____xxx_
__________________xxxxxxxxxxxx_xxx_|__________________xxxxxxxxxxxx_xxx_
___________________xxxxxxxxxxx___x_|___________________xxxxxxxxxxx___x_
____________________xxxxxxxxxx_xxx_|____________________xxxxxxxxxx_xxx_
_____________________xxxxx___xxxxx_|_____________________xxxxx___xxxxx_
_____________________________xxxxx_|_____________________________xxxxx_
__________________xxxxx_____xxxxxx_|__________________xxxxx_____xxxxxx_
______________xxxxxxxxxx____xxxxxx_|______________xxxxxxxxxx____xxxxxx_
__________xxxxxxxxxxxxxx___xxxxxxx_|__________xxxxxxxxxxxxxx___xxxxxxx_
_____xxxxxxxxxxxxxxxxxxxx__xxxxxxx_|_____xxxxxxxxxxxxxxxxxxxx__xxxxxxx_
_xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx_|_xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx_
_____xxxxxxxxxxxxxxxxxxxxx_xxxxx___|_____xxxxxxxxxxxxxxxxxxxxx_xxxxx___
_________xxxxxxxxxxxxxxxx___xxx____|_________xxxxxxxxxxxxxxxx___xxx____
_____________xxxxxxxxxxxx__________|_____________xxxxxxxxxxxx____x_____
__________________xxxxxxx___xx_____|__________________xxxxxxx___xx_____
______________________xx___xxxx____|______________________xx___xxxx____
________________________x_xxxxxx___|________________________x_xxxxxx___
_______________________x______xxx__|_______________________x______xxx__
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kEvenOdd_FillType, 1, 7, 8, 15, 3, 7, 11, 14 },
/*
___________________________________|___________________________________
____________x______________________|____________x______________________
_____________xxx___________________|_____________xxx___________________
______________xxxxx________________|______________xxxxx________________
_______________xxxxxxx_________x___|_______________xxxxxxx_________x___
________________xxxxxxxx______xx___|________________xxxxxxxxx_____xx___
_________________xxxxxxxxxx___x____|_________________xxxxxxxxxx___x____
__________________xxxxxxxxxxx_x____|__________________xxxxxxxxxxx_x____
___________________xxxxxxxxx__xxx__|___________________xxxxxxxxx__xxx__
____________________xxxxxxxx__x____|____________________xxxxxxxx__x____
_____________________xxxxx_xx______|_____________________xxxxx_xx______
__________________________xxx______|__________________________xxx______
__________________xxxxx___xx_______|__________________xxxxx___xx_______
______________xxxxxxxxxx_xxx_______|______________xxxxxxxxxx_xxx_______
__________xxxxxxxxxxxxxxxxx________|__________xxxxxxxxxxxxxxxxx________
_____xxxxxxxxxxxxxxxxxxxxxx________|_____xxxxxxxxxxxxxxxxxxxxxx________
_xxxxxxxxxxxxxxxxxxxxxxxxx_________|_xxxxxxxxxxxxxxxxxxxxxxxxx_________
_____xxxxxxxxxxxxxxxxxxxxx_xxxxx___|_____xxxxxxxxxxxxxxxxxxxxx_xxxxx___
_________xxxxxxxxxxxxxxxx___xxx____|_________xxxxxxxxxxxxxxxx___xxx____
_____________xxxxxxxxxxxx__________|_____________xxxxxxxxxxxx____x_____
__________________xxxxxxx___xx_____|__________________xxxxxxx___xx_____
______________________xx___xxxx____|______________________xx___xxxx____
________________________x_xxxxxx___|________________________x_xxxxxx___
_______________________x______xxx__|_______________________x______xxx__
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kWinding_FillType, 1, 7, 8, 15, 3, 10, 11, 14 },
/*
___________________________________|___________________________________
____________x______________________|____________x______________________
_____________xxx___________________|_____________xxx___________________
______________xxxxx________________|______________xxxxx________________
_______________xxxxxxx_________x___|_______________xxxxxxx_________x___
________________xxxxxxxx______xx___|________________xxxxxxxxx_____xx___
_________________xxxxxxxxxx___x____|_________________xxxxxxxxxx___x____
__________________xxxxxxxxxxx_x____|__________________xxxxxxxxxxx_x____
___________________xxxxxxxxx__xxx__|___________________xxxxxxxxx__xxx__
____________________xxxxxxxx__x____|____________________xxxxxxxx__x____
_____________________xxxxx_xx______|_____________________xxxxx_xx______
__________________________xxx______|__________________________xxx______
__________________xxxxx___xx_______|__________________xxxxx___xx_______
______________xxxxxxxxxx_xxx_______|______________xxxxxxxxxx_xxx_______
__________xxxxxxxxxxxxxxxxx________|__________xxxxxxxxxxxxxx_xx________
_____xxxxxxxxxxxxxxxxxx__xx________|_____xxxxxxxxxxxxxxxxxx__xx________
_xxxxxxxxxxxxxxxxxxxxxx____________|_xxxxxxxxxxxxxxxxxxxxxx____________
_____xxxxxxxxxxxxxxxxxxxxx_xxxxx___|_____xxxxxxxxxxxxxxxxxxxxx_xxxxx___
_________xxxxxxxxxxxxxxxx___xxx____|_________xxxxxxxxxxxxxxxx___xxx____
_____________xxxxxxxxxxxx__________|_____________xxxxxxxxxxxx____x_____
__________________xxxxxxx___xx_____|__________________xxxxxxx___xx_____
______________________xx___xxxx____|______________________xx___xxxx____
________________________x_xxxxxx___|________________________x_xxxxxx___
_______________________x______xxx__|_______________________x______xxx__
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kEvenOdd_FillType, 1, 7, 8, 15, 3, 10, 11, 14 },
/*
___________________________________|___________________________________
____________x____________________x_|____________x____________________x_
_____________xxx_________________x_|_____________xxx_________________x_
______________xxxxx_____________xx_|______________xxxxx_____________xx_
_______________xxxxxxx__________xx_|_______________xxxxxxx__________xx_
________________xxxxxxxx________xx_|________________xxxxxxxx________xx_
_________________xxxxxxxxxx____xxx_|_________________xxxxxxxxxx____xxx_
__________________xxxxxxxxxxxx_xxx_|__________________xxxxxxxxxxxx_xxx_
___________________xxxxxxxxxxx___x_|___________________xxxxxxxxxxx___x_
____________________xxxxxxxxxx_xxx_|____________________xxxxxxxxxx_xxx_
_____________________xxxxx___xxxxx_|_____________________xxxxx___xxxxx_
_____________________________xxxxx_|_____________________________xxxxx_
__________________xxxxx_____xxxxxx_|__________________xxxxx_____xxxxxx_
______________xxxxxxxxxx____xxxxxx_|______________xxxxxxxxxx____xxxxxx_
__________xxxxxxxxxxxxxx___xxxxxxx_|__________xxxxxxxxxxxxxx___xxxxxxx_
_____xxxxxxxxxxxxxxxxxxxx__xxxxxxx_|_____xxxxxxxxxxxxxxxxxxxx__xxxxxxx_
_xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx_|_xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx_
_____xxxxxxxxxxxxxxxxxxxxx_xxxxx___|_____xxxxxxxxxxxxxxxxxxxxx_xxxxx___
_________xxxxxxxxxxxxxxxx___xxx____|_________xxxxxxxxxxxxxxxx___xxx____
_____________xxxxxxxxxxxx__________|_____________xxxxxxxxxxxx____x_____
__________________xxxxxxx___xx_____|__________________xxxxxxx___xx_____
______________________xx___xxxx____|______________________xx___xxxx____
________________________x_xxxxxx___|________________________x_xxxxxx___
_______________________x______xxx__|_______________________x______xxx__
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kEvenOdd_FillType, 1, 7, 8, 15, 3, 11, 11, 14 },
/*
___________________________________|___________________________________
____________x____________________x_|____________x____________________x_
_____________xxx_________________x_|_____________xxx_________________x_
______________xxxxx_____________xx_|______________xxxxx_____________xx_
_______________xxxxxxx__________xx_|_______________xxxxxxx__________xx_
________________xxxxxxxx________xx_|________________xxxxxxxx________xx_
_________________xxxxxxxxxx____xxx_|_________________xxxxxxxxxx____xxx_
__________________xxxxxxxxxxxx_xxx_|__________________xxxxxxxxxxxx_xxx_
___________________xxxxxxxxxxx___x_|___________________xxxxxxxxxxx___x_
____________________xxxxxxxxxx_xxx_|____________________xxxxxxxxxx_xxx_
_____________________xxxxx___xxxxx_|_____________________xxxxx___xxxxx_
_____________________________xxxxx_|_____________________________xxxxx_
__________________xxxxx_____xxxxxx_|__________________xxxxx_____xxxxxx_
______________xxxxxxxxxx____xxxxxx_|______________xxxxxxxxxx____xxxxxx_
__________xxxxxxxxxxxxxx___xxxxxxx_|__________xxxxxxxxxxxxxx___xxxxxxx_
_____xxxxxxxxxxxxxxxxxxxx__xxxxxxx_|_____xxxxxxxxxxxxxxxxxxxx__xxxxxxx_
_xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx_|_xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx_
_____xxxxxxxxxxxxxxxxxxxxx_xxxxx___|_____xxxxxxxxxxxxxxxxxxxxx_xxxxx___
_________xxxxxxxxxxxxxxxx___xxx____|_________xxxxxxxxxxxxxxxx___xxx____
_____________xxxxxxxxxxxx__________|_____________xxxxxxxxxxxx____x_____
__________________xxxxxxx___xx_____|__________________xxxxxxx___xx_____
______________________xx___xxxx____|______________________xx___xxxx____
________________________x_xxxxxx___|________________________x_xxxxxx___
_______________________x______xxx__|_______________________x______xxx__
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kEvenOdd_FillType, 1, 7, 8, 15, 3, 11, 14, 14 },
/*
___________________________________|___________________________________
_____________xxxxxxxxxxxxxxxxxxx___|_____________xxxxxxxxxxxxxxxxxxx___
___________xx___xxxxxxxxxxx________|___________xx___xxxxxxxxxxx________
___________xxx_____xxxx____________|___________xxx_____xxxx____________
__________xxxxx____xxx_____________|__________xxxxx____xxx_____________
__________xxxxx_xxxxxxxx___________|__________xxxxx_xxxxxxxxx__________
_________xx______xxxxxxxxxx________|_________x_______xxxxxxxxxx________
______xxx_________xxxxxxxxxxxx_____|______xxx_________xxxxxxxxxxxx_____
__xxxxxx___________xxxxxxxxxxxxxx__|__xxxxxx___________xxxxxxxxxxxxxx__
___xxxxx____________xxxxxxxxxxxx___|___xxxxx____________xxxxxxxxxxxx___
_____xx______________xxxxxxxxx_____|_____xx______________xxxxxxxxx_____
______________________xxxxxx_______|______________________xxxxxx_______
_______xx______________xxx_________|_______xx______________xxx_________
______xxxxx________________________|______xxxxx________________________
______xxxxxxx_________xx___________|______xxxxxxx_________xxx__________
_____xxxxxxxxxx____xxxxxx__________|_____xxxxxxxxxx____xxxxxx__________
_____xxxxxxxxxxxxxxxxxxxxx_________|_____xxxxxxxxxxxxxxxxxxxxx_________
____xxxxxxxxxxx____xxxxxxxx________|____xxxxxxxxxxx____xxxxxxxx________
____xxxxxxxxx________xxxxxxx_______|____xxxxxxxxx________xxxxxxx_______
___xxxxxxxx_____________xxxxx______|___xxxxxxxx_____________xxxxx______
___xxxxxx_________________xxxx_____|___xxxxxx_________________xxxx_____
__xxxxx_____________________xxx____|__xxxxx_____________________xxx____
__xxx_________________________xx___|__xxx_________________________xx___
_xx_____________________________x__|_xx_____________________________x__
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kEvenOdd_FillType, 1, 7, 12, 12, 1, 3, 4, 15 },
/*
___________________________________|___________________________________
____________x__________xxxxxxxxxx__|____________x__________xxxxxxxxxx__
_____________x_________xxxxxxxxx___|_____________x_________xxxxxxxxx___
______________x_________xxxxxx_____|______________x_________xxxxxx_____
_______________xx_______xxxxx______|_______________xx_______xxxxx______
________________xx_______xx________|________________xx_______xx________
_________________xxx_____x_________|_________________xxx_____x_________
__________________xxx____x_________|__________________xxx____x_________
___________________xxx_xxx_________|___________________xxx_xxx_________
____________________x_xxxxx________|____________________x_xxxxx________
__________________xx_xxxxxx________|__________________xx_xxxxxx________
_______________xxxx___xxxxxx_______|_______________xxxx___xxxxxx_______
____________xxxxxx_____xxxxx_______|____________xxxxxx_____xxxxx_______
_________xxxxxxx________xxxxx______|_________xxxxxxx________xxxxx______
_______xxxxxxxx_________xxxxx______|_______xxxxxxxx__________xxxx______
____xxxxxxxxx____________xxxxx_____|____xxxxxxxxx____________xxxxx_____
_xxxxxxxxxxx______________xxxx_____|_xxxxxxxxxxx______________xxxx_____
_____xxxxxx________________xxx_____|_____xxxxxx________________xxx_____
____________________________xxx____|____________________________xxx____
________xxxxx________________xx____|________xxxxx________________xx____
______xxxxxxxxxxxx____________xx___|______xxxxxxxxxxxx____________xx___
_____xxxxxxxxxxxxxxxxx_________x___|_____xxxxxxxxxxxxxxxxx_________x___
____xxxxxxxxxxxxxxxxxxxxxx______x__|____xxxxxxxxxxxxxxxxxxxxxx______x__
__xxxxxxxxxxxxxxxxxxxxxxxxxxxx_____|__xxxxxxxxxxxxxxxxxxxxxxxxxxxx_____
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kEvenOdd_FillType, 2, 3, 12, 15, 1, 6, 8, 15 },
/*
___________________________________|___________________________________
_xx__________________x_____________|_xx__________________x_____________
__xxxxx____________xx______________|__xxxxx____________xx______________
__xxxxxxxxxx____xxxx_______________|__xxxxxxxxxx____xxxx_______________
___xxxxxxxxxx___xxx________________|___xxxxxxxxxx___xxx________________
___xxxxxxx_________x_______________|___xxxxxxx_________x_______________
____xxx___________xxxxxx___________|____xxx___________xxxxxx___________
____x____________xxxxxxxxxxx_______|____x____________xxxxxxxxxxx_______
__xx____________xxxxxxxxxxxxxxxxx__|__xxx___________xxxxxxxxxxxxxxxxx__
__xxx__________xxxxxxxxxxxxxxxx____|__xxx__________xxxxxxxxxxxxxxxx____
___xx_________xxxxxxxxxxxx_________|___xx_________xxxxxxxxxxxx_________
_____x_______xxxxxxxxx_____________|_____x_______xxxxxxxxx_____________
____________xxxxxx_________________|____________xxxxxx_________________
_______x___xxx_____________________|_______x___xxx_____________________
_______xx__________________________|_______xx__________________________
_____xxx_x_________________________|_____xxx_x_________________________
_xxxxxxxxxxx_______________________|_xxxxxxxxxxx_______________________
__xxxxx__xx________________________|__xxxxx__xx________________________
____xx_____________________________|____xx_____________________________
________xx_________________________|________xx_________________________
_____x_xxx_________________________|_____x_xxx_________________________
____x___xxx________________________|____x___xxx________________________
___x_____xx________________________|___x_____xx________________________
___________________________________|___________________________________
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kWinding_FillType, 2, 4, 9, 12, 0, 7, 8, 13 },
/*
___________________________________|___________________________________
_xx__________________x_____________|_xx__________________x_____________
__xxxxx____________xx______________|__xxxxx____________xx______________
__xxxxxxxxxx____xxxx_______________|__xxxxxxxxxx____xxxx_______________
___xxxxxxxxxx___xxx________________|___xxxxxxxxxx___xxx________________
___xxxxxxx_________x_______________|___xxxxxxx_________x_______________
____xxx___________xxxxxx___________|____xxx___________xxxxxx___________
____x____________xxxxxxxxxxx_______|____x____________xxxxxxxxxxx_______
__xx____________xxxxxxxxxxxxxxxxx__|__xxx___________xxxxxxxxxxxxxxxxx__
__xxx__________xxxxxxxxxxxxxxxx____|__xxx__________xxxxxxxxxxxxxxxx____
___xx_________xxxxxxxxxxxx_________|___xx_________xxxxxxxxxxxx_________
_____x_______xxxxxxxxx_____________|_____x_______xxxxxxxxx_____________
____________xxxxxx_________________|____________xxxxxx_________________
_______x___xxx_____________________|_______x___xxx_____________________
_______xx__________________________|_______xx__________________________
_____xxx_x_________________________|_____xxx_x_________________________
_xxxxxxxxxxx_______________________|_xxxxxxxxxxx_______________________
__xxxxx__xx________________________|__xxxxx__xx________________________
____xx_____________________________|____xx_____________________________
________xx_________________________|________xx_________________________
_____x_xxx_________________________|_____x_xxx_________________________
____x___xxx________________________|____x___xxx________________________
___x_____xx________________________|___x_____xx________________________
___________________________________|___________________________________
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kEvenOdd_FillType, 2, 4, 9, 12, 0, 7, 8, 13 },
/*
___________________________________|___________________________________
____________x________x_____________|____________x________x_____________
_____________x_____xx______________|_____________x_____xx______________
______________x_xxxx_______________|______________x_xxxx_______________
_____________xx__xx________________|_____________xx__xx________________
__________xxxxxx__x________________|__________xxxxxx__x________________
_______xxxxxxxxxx_xx_______________|_______xxxxxxxxxx_xx_______________
_____xxxxxxxxxxxx_xxx______________|_____xxxxxxxxxxxx_xxx______________
__xxxxxxxxxxxxxx___xxx_____________|__xxxxxxxxxxxxxx___xxx_____________
____xxxxxxxxxxx_____xx_____________|____xxxxxxxxxxx_____xx_____________
________xxxxxx______x______________|________xxxxxx______x______________
____________x______xxx_____________|____________x______xxx_____________
____________xxxxx_xxxxx____________|____________xxxxx_xxxxx____________
___________xxxxx_____xxx___________|___________xxxxx_____xxx___________
__________xxxxx_________x__________|__________xxxxx____________________
_________xxxx____________xxxx______|_________xxxx____________xxxx______
________xxxx______________xxxxxxxx_|________xxxx______________xxxxxxxx_
_______xxxxxxxx____________xxx_____|_______xxxxxxxx____________xxx_____
______xxxxxxxxxxx________xxx_______|______xxxxxxxxxxx________xxx_______
_____xxxxxxxxxxxxxxx_xxxxxxxx______|_____xxxxxxxxxxxxxxx_xxxxxxxx______
_____xxxxxxxxxxxx______xxxxxxx_____|_____xxxxxxxxxxxx______xxxxxxx_____
____xxxxxxxxx_____________xxxxx____|____xxxxxxxxx_____________xxxxx____
___xxxxxx____________________xxx___|___xxxxxx____________________xxx___
__xx___________________________xx__|__xx___________________________xx__
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kWinding_FillType, 2, 4, 11, 12, 1, 6, 9, 15 },
/*
___________________________________|___________________________________
____________x________x_____________|____________x________x_____________
_____________x_____xx______________|_____________x_____xx______________
______________x_xxxx_______________|______________x_xxxx_______________
_____________xx__xx________________|_____________xx__xx________________
__________xxxxxx__x________________|__________xxxxxx__x________________
_______xxxxxxxxxx_xx_______________|_______xxxxxxxxxx_xx_______________
_____xxxxxxxxxxxx_xxx______________|_____xxxxxxxxxxxx_xxx______________
__xxxxxxxxxxxxxx___xxx_____________|__xxxxxxxxxxxxxx___xxx_____________
____xxxxxxxxxxx_____xx_____________|____xxxxxxxxxxx_____xx_____________
________xxxxxx______x______________|________xxxxxx______x______________
____________x______xxx_____________|____________x______xxx_____________
____________xxxxx_xxxxx____________|____________xxxxx_xxxxx____________
___________xxxxx_____xxx___________|___________xxxxx_____xxx___________
__________xxxxx_________x__________|__________xxxxx____________________
_________xxxx____________xxxx______|_________xxxx____________xxxx______
________xxxx______________xxxxxxxx_|________xxxx______________xxxxxxxx_
_______xxxxxxxx____________xxx_____|_______xxxxxxxx____________xxx_____
______xxxxxxxxxxx________xxx_______|______xxxxxxxxxxx________xxx_______
_____xxxxxxxxxxxxxxx_xxxxxxxx______|_____xxxxxxxxxxxxxxx_xxxxxxxx______
_____xxxxxxxxxxxx______xxxxxxx_____|_____xxxxxxxxxxxx______xxxxxxx_____
____xxxxxxxxx_____________xxxxx____|____xxxxxxxxx_____________xxxxx____
___xxxxxx____________________xxx___|___xxxxxx____________________xxx___
__xx___________________________xx__|__xx___________________________xx__
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kEvenOdd_FillType, 2, 4, 11, 12, 1, 6, 9, 15 },
/*
___________________________________|___________________________________
____________xxxxxxxxxxxxxxxxxxxxx__|____________xxxxxxxxxxxxxxxxxxxxx__
_____________xxxxxxxxxxxxxxxxxxx___|_____________xxxxxxxxxxxxxxxxxxx___
______________xxxxxxxxx_xxxxxx_____|______________xxxxxxxxx_xxxxxx_____
_______________xxxxxxxx_xxxxx______|_______________xxxxxxxx_xxxxx______
________________xxxxxxx__xx________|________________xxxxxxx__xx________
_________________xxxxxx__x_________|_________________xxxxxx__x_________
__________________xxxxx__x_________|__________________xxxxx__x_________
___________________xxxxxxx_________|___________________xxxxxxx_________
____________________x_xxxxx________|____________________x_xxxxx________
__________________xx_xxxxxx________|__________________xx_xxxxxx________
_______________xxxx___xxxxxx_______|_______________xxxx___xxxxxx_______
____________xxxxxx_____xxxxx_______|____________xxxxxx_____xxxxx_______
_________xxxxxxx________xxxxx______|_________xxxxxxx________xxxxx______
_______xxxxxxxx_________xxxxx______|_______xxxxxxxx__________xxxx______
____xxxxxxxxx____________xxxxx_____|____xxxxxxxxx____________xxxxx_____
_xxxxxxxxxxx______________xxxx_____|_xxxxxxxxxxx______________xxxx_____
_____xxxxxx________________xxx_____|_____xxxxxx________________xxx_____
____________________________xxx____|____________________________xxx____
________xxxxx________________xx____|________xxxxx________________xx____
______xxxxxxxxxxxx____________xx___|______xxxxxxxxxxxx____________xx___
_____xxxxxxxxxxxxxxxxx_________x___|_____xxxxxxxxxxxxxxxxx_________x___
____xxxxxxxxxxxxxxxxxxxxxx______x__|____xxxxxxxxxxxxxxxxxxxxxx______x__
__xxxxxxxxxxxxxxxxxxxxxxxxxxxx_____|__xxxxxxxxxxxxxxxxxxxxxxxxxxxx_____
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kEvenOdd_FillType, 2, 6, 8, 15, 1, 3, 12, 15 },
/*
___________________________________|___________________________________
____________x____________________x_|____________x____________________x_
_____________xxx_________________x_|_____________xxx_________________x_
______________xxxxx_____________xx_|______________xxxxx_____________xx_
_______________xxxxxxx__________xx_|_______________xxxxxxx__________xx_
________________xxxxxxxx________xx_|________________xxxxxxxx________xx_
_________________xxxxxxxxxx____xxx_|_________________xxxxxxxxxx____xxx_
__________________xxxxxxxxxxxx_xxx_|__________________xxxxxxxxxxxx_xxx_
___________________xxxxxxxxxxx___x_|___________________xxxxxxxxxxx___x_
____________________xxxxxxxxxx_xxx_|____________________xxxxxxxxxx_xxx_
_____________________xxxxx___xxxxx_|_____________________xxxxx___xxxxx_
_____________________________xxxxx_|_____________________________xxxxx_
__________________xxxxx_____xxxxxx_|__________________xxxxx_____xxxxxx_
______________xxxxxxxxxx____xxxxxx_|______________xxxxxxxxxx____xxxxxx_
__________xxxxxxxxxxxxxx___xxxxxxx_|__________xxxxxxxxxxxxxx___xxxxxxx_
_____xxxxxxxxxxxxxxxxxxxx__xxxxxxx_|_____xxxxxxxxxxxxxxxxxxxx__xxxxxxx_
_xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx_|_xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx_
_____xxxxxxxxxxxxxxxxxxxxx_xxxxx___|_____xxxxxxxxxxxxxxxxxxxxx_xxxxx___
_________xxxxxxxxxxxxxxxx___xxx____|_________xxxxxxxxxxxxxxxx___xxx____
_____________xxxxxxxxxxxx__________|_____________xxxxxxxxxxxx____x_____
__________________xxxxxxx___xx_____|__________________xxxxxxx___xx_____
______________________xx___xxxx____|______________________xx___xxxx____
________________________x_xxxxxx___|________________________x_xxxxxx___
_______________________x______xxx__|_______________________x______xxx__
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kEvenOdd_FillType, 3, 3, 11, 14, 1, 7, 8, 15 },
/*
___________________________________|___________________________________
____________x___________________x__|____________x___________________x__
_____________xxx___________xxxxxx__|_____________xxx___________xxxxxx__
______________xxxxx____xxxxxxxxx___|______________xxxxx____xxxxxxxxx___
_______________xxxx___xxxxxxxxxx___|_______________xxxx___xxxxxxxxxx___
_______________x________xxxxxxxx___|_______________x_________xxxxxxx___
___________xxxxxx__________xxxx____|___________xxxxxx__________xxxx____
______xxxxxxxxxxxx____________x____|______xxxxxxxxxxxx____________x____
__xxxxxxxxxxxxxxxxx___________xxx__|__xxxxxxxxxxxxxxxxx___________xxx__
____xxxxxxxxxxxxxxxx__________x____|____xxxxxxxxxxxxxxxx__________x____
________xxxxxxxxxxxxx_____xxx______|________xxxxxxxxxxxxx_____xxx______
____________xxxxxxxxxxxxxxxxx______|_____________xxxxxxxxxxxxxxxx______
_________________xxxxxxxxxxx_______|_________________xxxxxxxxxxx_______
______________xxxxxxxxxxxxxx_______|______________xxxxxxxxxxxxxx_______
__________xxxxxxxxxxxxxx_xx________|__________xxxxxxxxxxxxxxxxx________
_____xxxxxxxxxxxxxxxxxxxx__xx______|_____xxxxxxxxxxxxxxxxxxxx__xx______
_xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx_|_xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx_
_____xxxxxxxxxxxxxxxxxxxxx_xxxxx___|_____xxxxxxxxxxxxxxxxxxxxx_xxxxx___
_________xxxxxxxxxxxxxxxx___xxx____|_________xxxxxxxxxxxxxxxx___xxx____
_____________xxxxxxxxxxxx__________|_____________xxxxxxxxxxxx____x_____
__________________xxxxxxx___xx_____|__________________xxxxxxx___xx_____
______________________xx___xxxx____|______________________xx___xxxx____
________________________x_xxxxxx___|________________________x_xxxxxx___
_______________________x______xxx__|_______________________x______xxx__
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kWinding_FillType, 3, 4, 11, 14, 1, 7, 8, 15 },
/*
___________________________________|___________________________________
____________x___________________x__|____________x___________________x__
_____________xxx___________xxxxxx__|_____________xxx___________xxxxxx__
______________xxxxx____xxxxxxxxx___|______________xxxxx____xxxxxxxxx___
_______________xxxx___xxxxxxxxxx___|_______________xxxx___xxxxxxxxxx___
_______________x________xxxxxxxx___|_______________x_________xxxxxxx___
___________xxxxxx__________xxxx____|___________xxxxxx__________xxxx____
______xxxxxxxxxxxx____________x____|______xxxxxxxxxxxx____________x____
__xxxxxxxxxxxxxxxxx___________xxx__|__xxxxxxxxxxxxxxxxx___________xxx__
____xxxxxxxxxxxxxxxx__________x____|____xxxxxxxxxxxxxxxx__________x____
________xxxxxxxxxxxxx_____xxx______|________xxxxxxxxxxxxx_____xxx______
____________xxxxxxxxxxxxxxxxx______|_____________xxxxxxxxxxxxxxxx______
_________________x_____xxxxx_______|_________________x_____xxxxx_______
______________xxxxxxx___xxxx_______|______________xxxxxxx___xxxx_______
__________xxxxxxxxxxxxxx_xx________|__________xxxxxxxxxxxxxxxxx________
_____xxxxxxxxxxxxxxxxxxxx__xx______|_____xxxxxxxxxxxxxxxxxxxx__xx______
_xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx_|_xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx_
_____xxxxxxxxxxxxxxxxxxxxx_xxxxx___|_____xxxxxxxxxxxxxxxxxxxxx_xxxxx___
_________xxxxxxxxxxxxxxxx___xxx____|_________xxxxxxxxxxxxxxxx___xxx____
_____________xxxxxxxxxxxx__________|_____________xxxxxxxxxxxx____x_____
__________________xxxxxxx___xx_____|__________________xxxxxxx___xx_____
______________________xx___xxxx____|______________________xx___xxxx____
________________________x_xxxxxx___|________________________x_xxxxxx___
_______________________x______xxx__|_______________________x______xxx__
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kEvenOdd_FillType, 3, 4, 11, 14, 1, 7, 8, 15 },
/*
___________________________________|___________________________________
____________x______________________|____________x______________________
_____________xxx________________x__|_____________xxx________________x__
______________xxxxx___________xx___|______________xxxxx___________xx___
_______________xxxxxxx_______xxx___|_______________xxxxxxx_______xxx___
________________xxxxxxxx___xxxxx___|________________xxxxxxxxx__xxxxx___
_________________xxxxxxxxx_xxxx____|_________________xxxxxxxxx_xxxx____
__________________xxxxxxx_____x____|__________________xxxxxxx_____x____
___________________xxxx_______xxx__|___________________xxxx_______xxx__
____________________xxxx______x____|____________________xxxx______x____
_____________________xxxx_xxx______|_____________________xxxx_xxx______
___________________________xx______|___________________________xx______
__________________xxxxx____________|__________________xxxxx____________
______________xxxxxxxxxx____x______|______________xxxxxxxxxx____x______
__________xxxxxxxxxxxxxx___xxxx____|__________xxxxxxxxxxxxxx___xxxx____
_____xxxxxxxxxxxxxxxxxxxx__xxxxx___|_____xxxxxxxxxxxxxxxxxxxx__xxxxx___
_xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx_|_xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx_
_____xxxxxxxxxxxxxxxxxxxxx_xxxxx___|_____xxxxxxxxxxxxxxxxxxxxx_xxxxx___
_________xxxxxxxxxxxxxxxx___xxx____|_________xxxxxxxxxxxxxxxx___xxx____
_____________xxxxxxxxxxxx__________|_____________xxxxxxxxxxxx____x_____
__________________xxxxxxx___xx_____|__________________xxxxxxx___xx_____
______________________xx___xxxx____|______________________xx___xxxx____
________________________x_xxxxxx___|________________________x_xxxxxx___
_______________________x______xxx__|_______________________x______xxx__
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kWinding_FillType, 3, 6, 11, 14, 1, 7, 8, 15 },
/*
___________________________________|___________________________________
____________x______________________|____________x______________________
_____________xxx________________x__|_____________xxx________________x__
______________xxxxx___________xx___|______________xxxxx___________xx___
_______________xxxxxxx_______xxx___|_______________xxxxxxx_______xxx___
________________xxxxxxxx___xxxxx___|________________xxxxxxxxx__xxxxx___
_________________xxxxxxxxx_xxxx____|_________________xxxxxxxxx_xxxx____
__________________xxxxxxx_____x____|__________________xxxxxxx_____x____
___________________xxxx_______xxx__|___________________xxxx_______xxx__
____________________xxxx______x____|____________________xxxx______x____
_____________________xxxx_xxx______|_____________________xxxx_xxx______
___________________________xx______|___________________________xx______
__________________xxxxx____________|__________________xxxxx____________
______________xxxxxxxxxx____x______|______________xxxxxxxxxx____x______
__________xxxxxxxxxxxxxx___xxxx____|__________xxxxxxxxxxxxxx___xxxx____
_____xxxxxxxxxxxxxxxxxxxx__xxxxx___|_____xxxxxxxxxxxxxxxxxxxx__xxxxx___
_xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx_|_xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx_
_____xxxxxxxxxxxxxxxxxxxxx_xxxxx___|_____xxxxxxxxxxxxxxxxxxxxx_xxxxx___
_________xxxxxxxxxxxxxxxx___xxx____|_________xxxxxxxxxxxxxxxx___xxx____
_____________xxxxxxxxxxxx__________|_____________xxxxxxxxxxxx____x_____
__________________xxxxxxx___xx_____|__________________xxxxxxx___xx_____
______________________xx___xxxx____|______________________xx___xxxx____
________________________x_xxxxxx___|________________________x_xxxxxx___
_______________________x______xxx__|_______________________x______xxx__
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kEvenOdd_FillType, 3, 6, 11, 14, 1, 7, 8, 15 },
/*
___________________________________|___________________________________
____________x____________________x_|____________x____________________x_
_____________xxx_________________x_|_____________xxx_________________x_
______________xxxxx_____________xx_|______________xxxxx_____________xx_
_______________xxxxxxx__________xx_|_______________xxxxxxx__________xx_
________________xxxxxxxx________xx_|________________xxxxxxxx________xx_
_________________xxxxxxxxxx____xxx_|_________________xxxxxxxxxx____xxx_
__________________xxxxxxxxxxxx_xxx_|__________________xxxxxxxxxxxx_xxx_
___________________xxxxxxxxxxx___x_|___________________xxxxxxxxxxx___x_
____________________xxxxxxxxxx_xxx_|____________________xxxxxxxxxx_xxx_
_____________________xxxxx___xxxxx_|_____________________xxxxx___xxxxx_
_____________________________xxxxx_|_____________________________xxxxx_
__________________xxxxx_____xxxxxx_|__________________xxxxx_____xxxxxx_
______________xxxxxxxxxx____xxxxxx_|______________xxxxxxxxxx____xxxxxx_
__________xxxxxxxxxxxxxx___xxxxxxx_|__________xxxxxxxxxxxxxx___xxxxxxx_
_____xxxxxxxxxxxxxxxxxxxx__xxxxxxx_|_____xxxxxxxxxxxxxxxxxxxx__xxxxxxx_
_xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx_|_xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx_
_____xxxxxxxxxxxxxxxxxxxxx_xxxxx___|_____xxxxxxxxxxxxxxxxxxxxx_xxxxx___
_________xxxxxxxxxxxxxxxx___xxx____|_________xxxxxxxxxxxxxxxx___xxx____
_____________xxxxxxxxxxxx__________|_____________xxxxxxxxxxxx____x_____
__________________xxxxxxx___xx_____|__________________xxxxxxx___xx_____
______________________xx___xxxx____|______________________xx___xxxx____
________________________x_xxxxxx___|________________________x_xxxxxx___
_______________________x______xxx__|_______________________x______xxx__
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kEvenOdd_FillType, 3, 7, 11, 14, 1, 7, 8, 15 },
/*
___________________________________|___________________________________
____________x______________________|____________x______________________
_____________xxx___________________|_____________xxx___________________
______________xxxxx________________|______________xxxxx________________
_______________xxxxxxx_________x___|_______________xxxxxxx_________x___
________________xxxxxxxx______xx___|________________xxxxxxxxx_____xx___
_________________xxxxxxxxxx___x____|_________________xxxxxxxxxx___x____
__________________xxxxxxxxxxx_x____|__________________xxxxxxxxxxx_x____
___________________xxxxxxxxx__xxx__|___________________xxxxxxxxx__xxx__
____________________xxxxxxxx__x____|____________________xxxxxxxx__x____
_____________________xxxxx_xx______|_____________________xxxxx_xx______
__________________________xxx______|__________________________xxx______
__________________xxxxx___xx_______|__________________xxxxx___xx_______
______________xxxxxxxxxx_xxx_______|______________xxxxxxxxxx_xxx_______
__________xxxxxxxxxxxxxxxxx________|__________xxxxxxxxxxxxxxxxx________
_____xxxxxxxxxxxxxxxxxxxxxx________|_____xxxxxxxxxxxxxxxxxxxxxx________
_xxxxxxxxxxxxxxxxxxxxxxxxx_________|_xxxxxxxxxxxxxxxxxxxxxxxxx_________
_____xxxxxxxxxxxxxxxxxxxxx_xxxxx___|_____xxxxxxxxxxxxxxxxxxxxx_xxxxx___
_________xxxxxxxxxxxxxxxx___xxx____|_________xxxxxxxxxxxxxxxx___xxx____
_____________xxxxxxxxxxxx__________|_____________xxxxxxxxxxxx____x_____
__________________xxxxxxx___xx_____|__________________xxxxxxx___xx_____
______________________xx___xxxx____|______________________xx___xxxx____
________________________x_xxxxxx___|________________________x_xxxxxx___
_______________________x______xxx__|_______________________x______xxx__
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kWinding_FillType, 3, 10, 11, 14, 1, 7, 8, 15 },
/*
___________________________________|___________________________________
____________x______________________|____________x______________________
_____________xxx___________________|_____________xxx___________________
______________xxxxx________________|______________xxxxx________________
_______________xxxxxxx_________x___|_______________xxxxxxx_________x___
________________xxxxxxxx______xx___|________________xxxxxxxxx_____xx___
_________________xxxxxxxxxx___x____|_________________xxxxxxxxxx___x____
__________________xxxxxxxxxxx_x____|__________________xxxxxxxxxxx_x____
___________________xxxxxxxxx__xxx__|___________________xxxxxxxxx__xxx__
____________________xxxxxxxx__x____|____________________xxxxxxxx__x____
_____________________xxxxx_xx______|_____________________xxxxx_xx______
__________________________xxx______|__________________________xxx______
__________________xxxxx___xx_______|__________________xxxxx___xx_______
______________xxxxxxxxxx_xxx_______|______________xxxxxxxxxx_xxx_______
__________xxxxxxxxxxxxxxxxx________|__________xxxxxxxxxxxxxx_xx________
_____xxxxxxxxxxxxxxxxxx__xx________|_____xxxxxxxxxxxxxxxxxx__xx________
_xxxxxxxxxxxxxxxxxxxxxx____________|_xxxxxxxxxxxxxxxxxxxxxx____________
_____xxxxxxxxxxxxxxxxxxxxx_xxxxx___|_____xxxxxxxxxxxxxxxxxxxxx_xxxxx___
_________xxxxxxxxxxxxxxxx___xxx____|_________xxxxxxxxxxxxxxxx___xxx____
_____________xxxxxxxxxxxx__________|_____________xxxxxxxxxxxx____x_____
__________________xxxxxxx___xx_____|__________________xxxxxxx___xx_____
______________________xx___xxxx____|______________________xx___xxxx____
________________________x_xxxxxx___|________________________x_xxxxxx___
_______________________x______xxx__|_______________________x______xxx__
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kEvenOdd_FillType, 3, 10, 11, 14, 1, 7, 8, 15 },
/*
___________________________________|___________________________________
____________x____________________x_|____________x____________________x_
_____________xxx_________________x_|_____________xxx_________________x_
______________xxxxx_____________xx_|______________xxxxx_____________xx_
_______________xxxxxxx__________xx_|_______________xxxxxxx__________xx_
________________xxxxxxxx________xx_|________________xxxxxxxx________xx_
_________________xxxxxxxxxx____xxx_|_________________xxxxxxxxxx____xxx_
__________________xxxxxxxxxxxx_xxx_|__________________xxxxxxxxxxxx_xxx_
___________________xxxxxxxxxxx___x_|___________________xxxxxxxxxxx___x_
____________________xxxxxxxxxx_xxx_|____________________xxxxxxxxxx_xxx_
_____________________xxxxx___xxxxx_|_____________________xxxxx___xxxxx_
_____________________________xxxxx_|_____________________________xxxxx_
__________________xxxxx_____xxxxxx_|__________________xxxxx_____xxxxxx_
______________xxxxxxxxxx____xxxxxx_|______________xxxxxxxxxx____xxxxxx_
__________xxxxxxxxxxxxxx___xxxxxxx_|__________xxxxxxxxxxxxxx___xxxxxxx_
_____xxxxxxxxxxxxxxxxxxxx__xxxxxxx_|_____xxxxxxxxxxxxxxxxxxxx__xxxxxxx_
_xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx_|_xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx_
_____xxxxxxxxxxxxxxxxxxxxx_xxxxx___|_____xxxxxxxxxxxxxxxxxxxxx_xxxxx___
_________xxxxxxxxxxxxxxxx___xxx____|_________xxxxxxxxxxxxxxxx___xxx____
_____________xxxxxxxxxxxx__________|_____________xxxxxxxxxxxx____x_____
__________________xxxxxxx___xx_____|__________________xxxxxxx___xx_____
______________________xx___xxxx____|______________________xx___xxxx____
________________________x_xxxxxx___|________________________x_xxxxxx___
_______________________x______xxx__|_______________________x______xxx__
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kEvenOdd_FillType, 3, 11, 11, 14, 1, 7, 8, 15 },
/*
___________________________________|___________________________________
____________x____________________x_|____________x____________________x_
_____________xxx_________________x_|_____________xxx_________________x_
______________xxxxx_____________xx_|______________xxxxx_____________xx_
_______________xxxxxxx__________xx_|_______________xxxxxxx__________xx_
________________xxxxxxxx________xx_|________________xxxxxxxx________xx_
_________________xxxxxxxxxx____xxx_|_________________xxxxxxxxxx____xxx_
__________________xxxxxxxxxxxx_xxx_|__________________xxxxxxxxxxxx_xxx_
___________________xxxxxxxxxxx___x_|___________________xxxxxxxxxxx___x_
____________________xxxxxxxxxx_xxx_|____________________xxxxxxxxxx_xxx_
_____________________xxxxx___xxxxx_|_____________________xxxxx___xxxxx_
_____________________________xxxxx_|_____________________________xxxxx_
__________________xxxxx_____xxxxxx_|__________________xxxxx_____xxxxxx_
______________xxxxxxxxxx____xxxxxx_|______________xxxxxxxxxx____xxxxxx_
__________xxxxxxxxxxxxxx___xxxxxxx_|__________xxxxxxxxxxxxxx___xxxxxxx_
_____xxxxxxxxxxxxxxxxxxxx__xxxxxxx_|_____xxxxxxxxxxxxxxxxxxxx__xxxxxxx_
_xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx_|_xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx_
_____xxxxxxxxxxxxxxxxxxxxx_xxxxx___|_____xxxxxxxxxxxxxxxxxxxxx_xxxxx___
_________xxxxxxxxxxxxxxxx___xxx____|_________xxxxxxxxxxxxxxxx___xxx____
_____________xxxxxxxxxxxx__________|_____________xxxxxxxxxxxx____x_____
__________________xxxxxxx___xx_____|__________________xxxxxxx___xx_____
______________________xx___xxxx____|______________________xx___xxxx____
________________________x_xxxxxx___|________________________x_xxxxxx___
_______________________x______xxx__|_______________________x______xxx__
___________________________________|___________________________________
___________________________________|___________________________________
*/
{ SkPath::kEvenOdd_FillType, 3, 11, 14, 14, 1, 7, 8, 15 },
};

size_t misMatchCount = sizeof(misMatches) / sizeof(misMatches[0]);

void TestMismatches();

void TestMismatches() {
    SkBitmap bitmap;
    for (size_t index = 0; index < misMatchCount; ++index) {
        const misMatch& miss = misMatches[index];
        int ax = miss.a & 0x03;
        int ay = miss.a >> 2;
        int bx = miss.b & 0x03;
        int by = miss.b >> 2;
        int cx = miss.c & 0x03;
        int cy = miss.c >> 2;
        int dx = miss.d & 0x03;
        int dy = miss.d >> 2;
        int ex = miss.e & 0x03;
        int ey = miss.e >> 2;
        int fx = miss.f & 0x03;
        int fy = miss.f >> 2;
        int gx = miss.g & 0x03;
        int gy = miss.g >> 2;
        int hx = miss.h & 0x03;
        int hy = miss.h >> 2;
        SkPath path, out;
        path.setFillType(miss.fType);
        path.moveTo(ax, ay);
        path.lineTo(bx, by);
        path.lineTo(cx, cy);
        path.lineTo(dx, dy);
        path.close();
        path.moveTo(ex, ey);
        path.lineTo(fx, fy);
        path.lineTo(gx, gy);
        path.lineTo(hx, hy);
        path.close();
        testSimplify(path, true, out, bitmap);
    }
}
