/*
 *
 *  Bluetooth packet analyzer - BPA parser
 *
 *  Copyright (C) 2004-2005  Marcel Holtmann <marcel@holtmann.org>
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 *  $Id: bpa.c,v 1.3 2005/02/01 14:36:59 holtmann Exp $
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>

#include <sys/types.h>
#include <netinet/in.h>

#include <bluetooth/bluetooth.h>
#include <bluetooth/hci.h>

#include "parser.h"

#define BPA_U8(frm)  (get_u8(frm))
#define BPA_U16(frm) (btohs(htons(get_u16(frm))))
#define BPA_U32(frm) (btohl(htonl(get_u32(frm))))

void bpa_dump(int level, struct frame *frm)
{
	uint8_t id, status, channel;
	uint16_t num, len;
	uint32_t time;

	id = get_u8(frm);
	num = get_u16(frm);
	len = BPA_U16(frm);

	status  = get_u8(frm);
	time    = get_u32(frm);
	channel = get_u8(frm);

	p_indent(level, frm);
	printf("BPA: id %d num %d status 0x%02x time %d channel %d\n",
		id, num, status, time, channel);

	raw_dump(level, frm);
}
