/**
 * blenlib/BKE_ika.h (mar-2001 nzc)
 *	
 * $Id: BKE_ika.h,v 1.5 2002/12/27 13:10:09 mein Exp $ 
 *
 * ***** BEGIN GPL/BL DUAL LICENSE BLOCK *****
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. The Blender
 * Foundation also sells licenses for use in proprietary software under
 * the Blender License.  See http://www.blender.org/BL/ for information
 * about this.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * The Original Code is Copyright (C) 2001-2002 by NaN Holding BV.
 * All rights reserved.
 *
 * The Original Code is: all of this file.
 *
 * Contributor(s): none yet.
 *
 * ***** END GPL/BL DUAL LICENSE BLOCK *****
 */
#ifndef BKE_IKA_H
#define BKE_IKA_H

struct Ika;
struct Limb;
struct Object;

void unlink_ika(struct Ika *ika);
void free_ika(struct Ika *ika);
struct Ika *add_ika(void);
struct Ika *copy_ika(struct Ika *ika);
void make_local_ika(struct Ika *ika);
int count_limbs(struct Object *ob);
void calc_limb(struct Limb *li);
void calc_ika(struct Ika *ika, struct Limb *li);
void init_defstate_ika(struct Object *ob);
void itterate_limb(struct Ika *ika, struct Limb *li);
void rotate_ika(struct Object *ob, struct Ika *ika);
void rotate_ika_xy(struct Object *ob, struct Ika *ika);
void itterate_ika(struct Object *ob);
void do_all_ikas(void);
void do_all_visible_ikas(void);
void init_skel_deform(struct Object *par, struct Object *ob);
void calc_skel_deform(struct Ika *ika, float *co);

#endif

