#!/bin/sh
# Copyright (C) 2001-2002 AbiSource
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

abi_version=1.0.2

# abi_plugins is the list of subdirectories that are plugins
# The definition of a plugin is a directory containing a file called "plugin.cfg".
# 
abi_plugins=

# abi_subdirs is a list of all directories in the current directory that are plugins or
# which have plugins in subdirectories, i.e., those directories into which make should
# recurse...
# 
abi_subdirs=

# abi_recurse is a subset of abi_subdirs which excludes plugins
# 
abi_recurse=

# abi_local is a subset of abi_subdirs which includes only plugins
# 
abi_local=

# abi_makefiles is the list of makefiles that configure must create
# 
abi_makefiles=

# abi_configs is the list of plugins that autoconf should scan
# 
abi_configs=

# abi_manual is the list of plugins that configure must run (i.e., w/o autoconf)
# 
abi_manual=

if test "x$CONFIG_SHELL" = "x"; then
  CONFIG_SHELL=/bin/sh
  export CONFIG_SHELL
fi

abi_mode=abi_build

# Parse our command line options once, thoroughly.
while test "$#" -gt 0
do
  arg="$1"
  shift

  case $arg in
  --query)
    abi_mode=abi_query
    ;;
  --config)
    abi_mode=abi_config
    ;;
  --help|-h)
    echo "Usage:"
    echo "     --query  list plugin subdirs"
    echo " -h, --help   print this help and exit"
    exit 1
    ;;
  *)
    echo 'Option `'$arg"' not recognized. Try --help for more information."
    exit 1
    ;;
  esac
done

if test "x$abi_topdir" = "x"; then
  abi_topdir=`pwd`
  export abi_topdir
  if test $abi_mode = abi_build; then
    abi_mode=abi_all
    echo "Searching for AbiWord plugins. Please wait..."
  fi
fi
if test "x$abi_dir" = "x"; then
  abi_dir=.
  abi_am=abi_
else
  abi_am=abi_`echo $abi_dir | sed 's@/@_@g'`
fi

# Find plugins
# 
_abi_dir=$abi_dir
for i in *; do
  if test -d $i; then
    if test -r $i/plugin.cfg; then
      # Found a plugin!
      abi_plugins="$abi_plugins $i"
      abi_subdirs="$abi_subdirs $i"
      abi_local="$abi_local $i"
    else
      abi_subquery=`(cd $i > /dev/null && $CONFIG_SHELL $abi_topdir/autogen.sh --query)`
      if test "x$abi_subquery" != "x"; then
        for j in $abi_subquery; do
          abi_plugins="$abi_plugins $i/$j"
        done
        abi_subdirs="$abi_subdirs $i"
        abi_recurse="$abi_recurse $i"
        if test $abi_mode = abi_config; then
          if test $_abi_dir = .; then
            abi_dir=$i
          else
            abi_dir=$_abi_dir/$i
          fi
          export abi_dir
          (cd $i > /dev/null && $CONFIG_SHELL $abi_topdir/autogen.sh --config)
        fi
      fi
    fi
  fi
done
abi_dir=$_abi_dir

if test $abi_mode = abi_config; then
  if test "x$abi_local" != "x"; then
    echo "$abi_am="
    for i in $abi_local; do
      echo 'abi_plugin_add=yes'
      echo 'AC_ARG_ENABLE('$i',[  --disable-'$i'],['
      echo '	if test "x$enableval" = "xno"; then'
      echo '		abi_plugin_add=no'
      echo '	fi'
      echo '],[	abi_plugin_add=$abi_plugin_opt'
      echo '])'
      echo 'if test $abi_plugin_add = yes; then'
      echo '	'$abi_am'="$'$abi_am $i'"'

      abi_plugin_autoconf=no
      . $i/plugin.cfg
      if test $abi_plugin_autoconf = yes; then
        echo '	AC_CONFIG_SUBDIRS('$abi_dir/$i')'
      else
        echo '	abi_plugin_extra="$abi_plugin_extra '$abi_dir/$i'"'
      fi

      echo 'fi'
    done
    echo "AC_SUBST($abi_am)"
    echo ''
  fi

  # The rest is build stuff, so quit here.
  # 
  exit 0
elif test $abi_mode = abi_query; then
  if test "x$abi_plugins" != "x"; then
    for i in $abi_plugins; do
      echo $i
    done
  fi

  # The rest is build stuff, so quit here.
  # 
  exit 0
else
  if test $abi_mode = abi_all; then
    if test "x$abi_subdirs" = "x"; then
      echo "Sorry. No AbiWord plugins found."
      exit 0
    fi
    if test -f "ac-helpers/abi-plugin-init.m4"; then
      echo "Creating build system for AbiWord plugins"
    else
      echo "This script creates a build system for AbiWord plugins. It deletes and creates a number"
      echo "of files, so it must be run from the top directory of the plugin source tree."
      exit 1
    fi
  else
    if test "x$abi_subdirs" = "x"; then
      echo "Glitch! Shouldn't be building when there are no subdirectories!"
      exit 1
    fi
  fi

  # Create GNUmakefile.am - only a SUBDIRS entry is required.
  # 
  if test $abi_dir = .; then
    abi_makefiles="GNUmakefile"
  else
    abi_makefiles="$abi_dir/GNUmakefile"
  fi
  rm -f GNUmakefile.am
  if test "x$abi_local" = "x"; then
    echo "SUBDIRS = $abi_recurse" > GNUmakefile.am
  else
    echo "SUBDIRS = @$abi_am@ $abi_recurse" > GNUmakefile.am
  fi

# Not sure about this:
# echo "" >> GNUmakefile.am
# echo "DIST_SUBDIRS = $abi_subdirs" >> GNUmakefile.am

  # and recurse into subdirectories...
  # 
  _abi_dir=$abi_dir
  for i in $abi_recurse; do
    if test $_abi_dir = .; then
      abi_dir=$i
    else
      abi_dir=$_abi_dir/$i
    fi
    export abi_dir
    abi_subbuild=`(cd $i > /dev/null && $CONFIG_SHELL $abi_topdir/autogen.sh)`
    for j in $abi_subbuild; do
      abi_makefiles="$abi_makefiles $j"
    done
  done
  abi_dir=$_abi_dir

  # Standard build just creates GNUmakefile.am, so quit here.
  # 
  if test $abi_mode = abi_build; then
    for i in $abi_makefiles; do
      echo $i
    done
    exit 0
  fi
fi

# Determine which plugins wish to be configured
# 
for i in $abi_plugins; do
  echo "  $i"
  abi_plugin_autoconf=no
  abi_plugin_configure=no
  . $i/plugin.cfg
  if test $abi_plugin_autoconf = yes; then
    abi_plugin_configure=yes
  fi
  if test $abi_plugin_configure = yes; then
    if test $abi_plugin_autoconf = yes; then
      abi_configs="$abi_configs $i"
    else
      abi_manual="$abi_manual $i"
    fi
  fi
done

# Create configure.ac
# 
rm -f configure.ac
cat > configure.ac << EOF
AC_INIT(abiword-plugins, $abi_version, [http://bugzilla.abisource.com/])
AC_CONFIG_SRCDIR([ac-helpers/abi-plugin-init.m4])

dnl First of all AbiWord plugin macros:
dnl 
ABI_PLUGIN_INIT($abi_version)

AM_INIT_AUTOMAKE(abiword, $abi_version)

AC_DISABLE_STATIC
AC_PROG_LIBTOOL

dnl Configure plugin sources
dnl 
dnl AC_CONFIG_SUBDIRS($abi_configs)

abi_plugin_extra=
abi_plugin_opt=yes
AC_ARG_ENABLE(all,[  --disable-all           disable all plugins by default],[
	if test "x\$enableval" = "xno"; then
		abi_plugin_opt=no
	fi
])

EOF
($CONFIG_SHELL $abi_topdir/autogen.sh --config) >> configure.ac
cat >> configure.ac << EOF
AC_CONFIG_FILES($abi_makefiles)
AC_OUTPUT

if test "x\$abi_plugin_extra" != "x"; then
	for i in \$abi_plugin_extra; do
		echo "Running configure in \$i..."
		(cd \$i > /dev/null && \$CONFIG_SHELL configure \$ac_configure_args)
	done
fi

if test -f plugin.status; then
	echo ""
	echo "Plugin reports:"
	echo ""
	cat plugin.status
	echo ""
fi
EOF

# Create configure.in
# 
rm -f configure.in
cat > configure.in << EOF
AC_INIT(ac-helpers/abi-plugin-init.m4)

dnl First of all AbiWord plugin macros:
dnl 
ABI_PLUGIN_INIT($abi_version)

AM_INIT_AUTOMAKE(abiword, $abi_version)

AC_DISABLE_STATIC
AC_PROG_LIBTOOL

dnl Configure plugin sources
dnl 
dnl AC_CONFIG_SUBDIRS($abi_configs)

abi_plugin_extra=
abi_plugin_opt=yes
AC_ARG_ENABLE(all,[  --disable-all           disable all plugins by default],[
	if test "x\$enableval" = "xno"; then
		abi_plugin_opt=no
	fi
])

EOF
($CONFIG_SHELL $abi_topdir/autogen.sh --config) >> configure.in
cat >> configure.in << EOF
AC_OUTPUT($abi_makefiles)

if test "x\$abi_plugin_extra" != "x"; then
	for i in \$abi_plugin_extra; do
		echo "Running configure in \$i..."
		(cd \$i > /dev/null && \$CONFIG_SHELL configure \$ac_configure_args)
	done
fi

if test -f plugin.status; then
	echo ""
	echo "Plugin reports:"
	echo ""
	cat plugin.status
	echo ""
fi
EOF

# And, finally, call in the big boys...
# 
rm -f autogen.out
rm -f autogen.err

echo "Running libtoolize -f -c"
(libtoolize -f -c >> $abi_topdir/autogen.out 2>> $abi_topdir/autogen.err) || {
  echo "libtoolize failed! Unable to continue."
  exit 1
}

echo "Running aclocal -I ac-helpers"
(aclocal -I ac-helpers >> $abi_topdir/autogen.out 2>> $abi_topdir/autogen.err) || {
  echo "aclocal failed! Unable to continue."
  exit 1
}

echo "Running automake -a -c --foreign"
(automake -a -c --foreign >> $abi_topdir/autogen.out 2>> $abi_topdir/autogen.err) || {
  echo "automake failed! Unable to continue."
  exit 1
}

echo "Running autoconf"
(autoconf >> $abi_topdir/autogen.out 2>> $abi_topdir/autogen.err) || {
  echo "autoconf failed! Unable to continue."
  exit 1
}

# If plugin requests, run a desired script
# 
for i in $abi_plugins; do
  abi_plugin_script=no
  . $i/plugin.cfg
  if test "x$abi_plugin_script" != "xno"; then
    echo 'Running `'$abi_plugin_script"' in $i" >> $abi_topdir/autogen.err
    echo 'Running `'$abi_plugin_script"' in $i"
    (cd $i && $CONFIG_SHELL $abi_plugin_script 2>> $abi_topdir/autogen.err)
  fi
done
