/* This file is Copyright 1993 by Clifford A. Adams */
/* svmisc.c
 *
 * virt scan mode misc. functions
 * (includes many of the Scan interface routines)
 */

/* trim this list */
#include "EXTERN.h"
#include "common.h"
#ifdef SCAN
#include "cache.h"
#include "ng.h"		/* for NG_PREV, etc... */
#include "ngdata.h"	/* abs1st[] */
#include "trn.h"
#include "rcln.h"
#include "rcstuff.h"
#include "scan.h"
#include "scmd.h"
#include "sdisp.h"
#include "smisc.h"
#include "svirt.h"
#include "svdata.h"
#include "term.h"
#include "util.h"
#include "INTERN.h"
#include "svmisc.h"

/* taken from rcln.c */
/* returns 1 if article was read in the named group */

/* trim this down even more */
/* optimize later by passing a newsgroup number? */
bool
was_read_group(artnum,ngnam)
ART_NUM artnum;
char *ngnam;
{
    register NG_NUM ngnum = find_ng(ngnam);
    register char *s, *t, *maxt = Nullch;
    ART_NUM min = 0, max = -1, lastnum = 0;

/* the two ifs below are actually really bad errors,
 * but I'm uncertain what should be done.
 * (It might be appropriate to return a TRUE value
 *  in hopes of masking a later error.)
 */
    if (!artnum)
	return TRUE;
    if (ngnum == nextrcline || !rcnums[ngnum])
					/* not found in newsrc? */
	return TRUE;

/* CONSIDER: replace with quieter version of set_toread? */
    if (!abs1st[ngnum])
#ifndef ANCIENT_NEWS
					/* now is a good time to trim down */
	set_toread(ngnum);		/* the list due to expires if we */
					/* have not yet. */
#endif
    if (toread[ngnum] <= TR_UNSUB)
	return TRUE;			/* consider it read */

    s = rcline[ngnum] + rcnums[ngnum];
    while (*s == ' ') s++;		/* skip spaces */
    t = s;
    while (isdigit(*s) && artnum >= (min = atol(s))) {
					/* while it might have been read */
	for (t = s; isdigit(*t); t++) ;	/* skip number */
	if (*t == '-') {		/* is it a range? */
	    t++;			/* skip to next number */
	    if (artnum <= (max = atol(t)))
		return TRUE;		/* it is in range => already read */
	    lastnum = max;		/* remember it */
	    maxt = t;			/* remember position in case we */
					/* want to overwrite the max */
	    while (isdigit(*t)) t++;	/* skip second number */
	}
	else {
	    if (artnum == min)		/* explicitly a read article? */
		return TRUE;
	    lastnum = min;		/* remember what the number was */
	    maxt = Nullch;		/* last one was not a range */
	}
	while (*t && !isdigit(*t)) t++;	/* skip comma and any spaces */
	s = t;
    }

    /* we have not read the article */
    return(FALSE);
}


bool
sv_eligible(ent)
long ent;
{
    if (sv_ents[ent].type <= 0)
	return(FALSE);
    if (sv_e_unread &&
	was_read_group(sv_ents[ent].artnum,
		       sv_groups[sv_ents[ent].group].name)) {
	return(FALSE);
    }
    if (sv_e_minused && (sv_ents[ent].score < sv_e_minscore))
	return(FALSE);
    if (sv_e_maxused && (sv_ents[ent].score > sv_e_maxscore))
	return(FALSE);
    return(TRUE);
}

int
sv_compare(a,b)
long a,b;		/* the two entries to compare */
{
    if (!sv_score_order)	/* arrival order */
	return(a-b);
#ifdef SCORE
    if (sv_ents[a].score == sv_ents[b].score)
	return(a-b);	/* entry order secondary */
    else
	return(sv_ents[b].score-sv_ents[a].score);   /* high scores first */
#else
    return(a-b);
#endif
}

char *
sv_get_desc(ent,line,trunc)
long ent;
int line;
bool_int trunc;		/* should this be truncated? */
{
    static char desc_buf[LBUFLEN];
    bool has_re;	/* if true, subject has "re: " at front */
    char *p;		/* pointer into desc_buf */
    char *s,*s2;	/* misc */

    has_re = FALSE;
    switch (line) {
	case 1:
	    p = desc_buf;
	    *p = '\0';
#ifdef SCORE
	    if (sv_show_score) {
		sprintf(p,"[%3ld] ",sv_ents[ent].score);
		for (;*p;p++)
		    ;	/* EMPTY */
	    }
#endif
	    if (sv_show_author) {
		s = s_compress_from(sv_ents[ent].author,16);
		sprintf(p,"%-16s ",s);
		for (;*p;p++)
		    ;	/* EMPTY */
	    }
	    if (sv_show_subject) {
		if (sv_ents[ent].desc && !sv_show_subjects_only)
		    s = sv_ents[ent].desc;
		else
		    s = sv_ents[ent].subject;
		if (!s || !*s)
		    s = "<No Subject>";
		s2 = s;
		if ((tolower(*s2++) == 'r') && (tolower(*s2++) == 'e') &&
		    (*s2++ == ':')) {
			has_re = TRUE;
			if (*s2 == ' ')
			    s2++;
			s = s2;
		}
/* check subject length later */
		sprintf(p,"%s%s ",(has_re ? ">" : ""),s);
		for (;*p;p++)
		    ;	/* EMPTY */
	    }
	    if (sv_show_groups) {
		s = sv_groups[sv_ents[ent].group].name;
		if (!s || !*s)
		    s = "No group";
		sprintf(p,"<%s>",s);
	    }
	    /* remove trailing space if any */
	    if (desc_buf[strlen(desc_buf)-1] == ' ')
		desc_buf[strlen(desc_buf)-1] = '\0';
	    break;
	default:
	    strcpy(desc_buf,"Invalid number of lines.");
	    break;
    }
    if (trunc)
	desc_buf[s_desc_cols] = '\0';
    /* replace bad characters with spaces */
    for (s=desc_buf;*s;s++)
	if ((*s=='\t') || (*s=='\n'))
	    *s = ' ';
    return(desc_buf);
}

/* fixed 5-character line */
char *
sv_get_statchars(ent,line)
long ent;
int line;
{
    static char statbuf[256];

    /* strings copied so they can be altered */
    if (line>=2) {
	strcpy(statbuf,"     ");
	return(statbuf);
    }
    switch (sv_ents[ent].type) {
	case 1:		/* ordinary article */
	    strcpy(statbuf,".....");
	    if (was_read_group(sv_ents[ent].artnum,
		sv_groups[sv_ents[ent].group].name))
		    statbuf[0] = '-';
	    else
		    statbuf[0] = '+';
	    if (sv_marked(ent))
		statbuf[4] = 'x';
	    break;
	default:
	    strcpy(statbuf,"error");
	    break;
    }
    return(statbuf);
}

void
sv_refresh_top()
{
    char lbuf[256];
    char *s;

    standout();
    printf("Virtual %2d |",sv_num_contexts);
    if (sv_e_unread)
	printf(" unread");
    else
	printf(" unread+read");
    if (sv_show_subjects_only)
	printf(" subjonly");
    if (sv_follow)
	printf(" follow");
    printf(" |");
    /* print up to 40 characters of title (change to less later?) */
    s = sv_contexts[sv_num_contexts-1].title;
    if (strlen(s)<41)
	printf(" %s",s);
    else {
	/* actually use 43 characters of line */
	strncpy(lbuf,s,40);
	lbuf[40] = '\0';
	printf(" %s...",lbuf);
    }
    un_standout();
    erase_eol();
    printf("\n") FLUSH;
}

void
sv_refresh_bot()
{
    standout();
    s_mail_and_place();
    if (sv_score_order)
	printf("(score order)");
    else
	printf("(arrival order)");
    un_standout();
    erase_eol();
    fflush(stdout);
}

int
sv_ent_lines(ent)
long ent;
{
    /* probably allow a 2-line style later */
    return(1);		/* possibly more later */
}

/* returns TRUE if screen/window is big enough, FALSE otherwise */
/* for now, the requirements are 15 columns and 5 lines */
bool
sv_check_screen()
{
    if (LINES<5 || COLS<15)
	return(FALSE);
    return(TRUE);
}

/* sets up shape of screen */
/* assumes s_initscreen has been called */
void
sv_set_screen()
{
    /* One size fits all for now. */
    s_top_lines = 1;
    s_bot_lines = 1;
    s_status_cols = 5;
    s_cursor_cols = 2;
    /* (scr_width-1) keeps last character blank. */
    s_desc_cols = (scr_width-1)-s_status_cols-s_cursor_cols;
}

/* no lookahead (yet?) for virtual scan mode */

void
sv_init_settings()
{
    char *s;
    int i;

    sv_f_minused = sv_f_maxused = FALSE;

    s = getval("SVMODE","5");
    /* consider error checking later */
    i = atoi(s);
    sv_follow = (i & 1);
    sv_f_unread = !(i & 2);
#ifdef SCORE
    sv_score_order = (i & 4);
#else
    sv_score_order = FALSE;
#endif
    sv_e_unread = !(i & 8);

    s = getval("SVDISPLAY","15");
    /* consider error checking later */
    i = atoi(s);
#ifdef SCORE
    sv_show_score = (i & 1);
#else
    sv_show_score = FALSE;
#endif
    sv_show_author = (i & 2);
    sv_show_subject = (i & 4);
    sv_show_groups = (i & 8);
    sv_show_subjects_only = (i & 16);

    /* obsolete, but still allowed for now */
    if (getval("SVNOFOLLOW",Nullch))
	sv_follow = FALSE;
}
#endif /* SCAN */
