/* This file is Copyright 1993 by Clifford A. Adams */
/* sgroup.c
 *
 * (News)group scan mode main code.
 */

#include "EXTERN.h"
#include "common.h"
#ifdef SCAN
#include "cache.h"
#include "init.h"	/* group_default */
#include "ng.h"		/* for NG_PREV, etc... */
#include "trn.h"
#include "rcln.h"
#include "rcstuff.h"
#include "scan.h"
#include "scmd.h"
#include "sdisp.h"
#include "smisc.h"
#include "sorder.h"
#include "spage.h"
#include "sgdata.h"
#include "sgfile.h"
#include "sgmisc.h"
#include "term.h"
#include "util.h"
#include "INTERN.h"
#include "sgroup.h"

int
sg_main()
{
    if (sg_initialized)
	return(sg_continue());
    if (!sg_init())		/* failed to initialize */
	return(SG_RETURN);	/* just leave group scan mode for now */
    return(sg_continue());
}

/* returns TRUE for successful init, false otherwise */
bool
sg_init()
{
    char lbuf[LBUFLEN];

    /* check to see if screen is big enough */
    if (!sg_check_screen()) {
	printf("Sorry--the screen is too small for group scan mode.\n") FLUSH;
	return(FALSE);
    }
    sg_init_context();

    /* read in all the newsgroups in newsrc and initialize sg_groups */
    sg_init_groups();

    /* early initialization of ents (not currently necessary) */
/*    sg_init_ents(); */

    /* first try customized, then default, then all groups */
    strcpy(lbuf,getval("SCANGROUPS","%p/scangroups"));
    strcat(lbuf,"/top");
    if (!sg_use_file(lbuf,"Top Level"))
	if (!sg_use_file("%X/default_topic","Top Level"))
	    sg_allgroups();
/* CONSIDER: this initialization/check is late in the initialization. */
    if (s_initscreen()) {		/* If not able to init screen...*/
/* de-initialize later? */
	return(FALSE);			/* ...most likely dumb terminal */
    }
    sg_initialized = TRUE;
    s_save_context();
    return(TRUE);
}


int
sg_continue()
{
    char sg_oldmode;
    int i;

    /* return to the group scan-context */
    s_change_context(sg_contexts[sg_num_contexts-1].cnum);

    /* If a major change was made to the .newsrc (like reordering or
     * deleting newsgroups), adjust to the changes.
     */
    if (sg_changed_newsrc)
	sg_reinit_groups();

    sg_force_read = FALSE;
    /* redraw it *all* */
    s_ref_all = TRUE;
    if ((s_top_ent<1) || (s_top_ent>=sg_num_ents))
	s_top_ent = s_first();
    i = s_fillpage();
    if ((i==-1) || (i == 0)) {
/*	printf("s_fillpage could not get a page\n") FLUSH; */
	printf("group scan: No eligible groups or topics at this level.\n")
		FLUSH;
	get_anything();
	eat_typeahead();
	if (sg_num_contexts>1) {
	    sg_old_context();
	    s_refill = TRUE;
	    return(sg_continue());
	}
	/* for now just leave if no page could be filled. */
	printf("No News?  (is good news??? :-)\n") FLUSH;
	sg_loop = 0;	/* go back */
	return(SG_RETURN);
    }
    sg_oldmode = mode;			/* save mode */
    mode = 'g';				/* for RN macros */
    i = s_cmdloop();
    mode = sg_oldmode;			/* restore mode */
    if (i>0) {		/* an entry is selected */
	/* for moment, all names are same as group names */
	sg_go_ng(sg_groups[sg_ents[i].groupnum].name);
	sg_lastent_read = i;
	printf("Going to newsgroup %s\n",
		sg_groups[sg_ents[i].groupnum].name) FLUSH;
	/* the command will set the fake */
	if (sg_num_contexts)
	    s_save_context();
	return(SG_FAKE);
    }
    /* something else (quit, return, etc...) */
    if (i==SG_QUIT) {
	sg_loop = 0;
	/* later deinitialize */
	if (sg_num_contexts)
	    s_save_context();
	return(SG_RETURN);
    }
    if (sg_num_contexts)
	s_save_context();
    return(i);
}
#endif /* SCAN */
