// *************************************************************
// File logging.h
// -------------------------------------------------------------
// Created: Ingmar Egger
//
// Tool fuer Instrumentierung
// *************************************************************

#ifndef _LOGGING_H_
#define _LOGGING_H_

#include <stdio.h>
#include <hyperg/utils/str.h>

class Instrumentation
{
 public:
        Instrumentation();
        ~Instrumentation();
        static Instrumentation* instance();
        void init(unsigned char viewer, const char* sid);   //--- creates logfile
        void write_prefix(unsigned char prefix_log);
	     void write_to_log(const char* action);      //--- writes data to it 
        void start();
        void finish();
        boolean transmission_ok() const { return transok; }
        boolean transmission_nok() const { return transnok; }
        boolean firstTime() const { return first_time; }
        boolean lastTime() const { return last_time; }
private:                
        static Instrumentation* instance_;
	     unsigned char instrumented;  //--- shows if a logfile should be created and used
        unsigned char prefix;        //--- shows the type of action (menu,button,key,mouse)
        unsigned char viewername;
        FILE* logfile;
        RString path;
        RString logfilename;
        RString session_id;
        boolean first_time;    //--- shows if it is the first time Harmony is started
        boolean last_time;     //--- end of the test phase
        boolean transok;       //--- Data-Transmission okay or not
        boolean transnok;
};

//*********** Data-defines used for the logfile *****************

//----------- Prefixes ------------------------------------------

#define startviewer               0
#define endviewer                 1
#define log_menu                  2   //--- which kind of action
#define log_button                3
#define log_key                   4
#define log_dclick                5
#define log_init_value            6
#define log_error_message         7

//------------- max. 256 possible -------------------------------

//------------- Viewers -----------------------------------------

#define log_session                8   //--- which viewer
#define log_text                   9
#define log_image                 10
#define log_film                  11
#define log_3d                    12 
#define log_haradminsession       13
#define log_hareditapitoolsession 14

//---------- Start/End defines for Viewers -------------------------------------

#define startsession_harmony                           "StartSession_Harmony "
#define endsession_harmony                             "EndSession_Harmony "
#define startsession_hartextd                          "StartSession_TextViewer "
#define endsession_hartextd                            "EndSession_TextViewer "
#define startsession_harimaged                         "StartSession_ImageViewer "
#define endsession_harimaged                           "EndSession_ImageViewer "
#define startsession_harfilmd                          "StartSession_FilmViewer "
#define endsession_harfilmd                            "EndSession_FilmViewer "
#define startsession_harscened                         "StartSession_3DViewer "
#define endsession_harscened                           "EndSession_3DViewer "
#define startsession_haradmin                          "StartSession_HarAdmin "
#define endsession_haradmin                            "EndSession_HarAdmin "
#define startsession_hareditapitool                    "StartSession_HarEditAPITool "
#define endsession_hareditapitool                      "EndSession_HarEditAPITool "

//-------------- End of Start/End defines for Viewers------------------------------

//-------------- Session-Manager defines ------------------------------------------

#define n_back                                         "Navigate_Back "
#define n_forward                                      "Navigate_Forward "
#define n_history                                      "Navigate_History "
#define n_history_in                                   "Navigate_HistoryDialog "
#define n_history_out                                  "Navigate_HistoryDialog "
#define n_open                                         "Navigate_Open"
#define n_close                                        "Navigate_Close "
#define n_children                                     "Navigate_Children "
#define n_ref_links                                    "Navigate_Ref_Links "
#define n_parents                                      "Navigate_Parents "
#define n_annotations                                  "Navigate_Annotations "
#define n_annotated                                    "Navigate_Annotated "
#define n_home                                         "Navigate_Home "
#define n_goto                                         "Navigate_Goto "
#define n_closeall                                     "Navigate_CloseAll "
#define n_active_collections                           "Navigate_Active_Collections "
#define n_activate                                     "Navigate_Activate "
#define n_localmap                                     "Navigate_LocalMap "
#define n_localmap_generate                            "Navigate_LocalMap_Generate-"
#define n_localmap_options                             "Navigate_LocalMap_Options "
#define n_showtextures                                 "Navigate_Show_Textures "
#define n_hold                                         "Navigate_Hold "
#define n_search                                       "Navigate_Search_TextViewer "
#define n_search_sess                                  "Navigate_Search-" 
#define n_search_in                                    "Navigate_SearchDialog "
#define n_search_out                                   "Navigate_SearchDialog "
#define n_search_language                              "Navigate_Search_Language-"

#define v_attributes                                   "View_Attributes "
#define v_showhost                                     "View_ShowHost "
#define v_showcount                                    "View_ShowCount "

#define s_identify                                     "System_Identify "
#define s_change_password                              "System_Change_Password "
#define s_status                                       "System_Status "
#define s_clear_chache                                 "System_Clear_Cache "
#define s_statusbrowser_send_message                   "System_StatusBrowser_Send_Message "
#define s_statusbrowser_selectall                      "System_StatusBrowser_SelectAll "
#define s_statusbrowser_deselectall                    "System_StatusBrowser_DeselectAll "

#define e_delete                                       "Edit_Delete "
#define e_move                                         "Edit_Move "
#define e_copy                                         "Edit_Copy "
#define e_attributes                                   "Edit_Attributes "
#define e_annotate                                     "Edit_Annotate "

#define h_overview                                     "Help_Overview "
#define h_index                                        "Help_Index "
#define h_about                                        "Help_About "

//#define f_filebrowser                                  "File_FileBrowser "
#define f_insert                                       "File_Insert "
#define f_mail_send_message                            "File_Mail_Send_Message "
#define f_mail_reply                                   "File_Mail_Reply "
#define f_mail_forward                                 "File_Mail_Forward "
#define f_editapitool                                  "File_EditAPITool "

#define o_general_scan_attribute                       "Options_General_Scan_Attribute "
#define o_general_global_viewer                        "Options_General_Global_Viewer "
#define o_sort_order                                   "Options_Sort_Order-"   
#define o_language                                     "Options_Language-"


#define d_search_help                                  "Dialog_Navigate_Search "
#define d_attributes_help                              "Dialog_Navigate_Attributes "   
#define d_identify_help                                "Dialog_System_Identify "
#define d_localmap_help                                "Dialog_LocalMap "

//-------------- End of Session-Manager defines -----------------

//-------------- Text-Viewer defines ----------------------------
//#define doc_references                                 "Document_References "
//#define doc_annotations                                "Document_Annotations "
//#define doc_parents                                    "Document_Parents "
//#define doc_attributes                                 "Document_Attributes "

#define n_inlines                                      "Navigate_Inlines "
#define n_attributes                                   "Navigate_Attributes "

#define a_next_hyperlink                               "Anchors_Next_Hyperlink "
#define a_previous_hyperlink                           "Anchors_Previous_Hyperlink "
#define a_activate_hyperlink                           "Anchors_Activate_Hyperlink "
#define a_attributes                                   "Anchors_Attributes "
#define a_define_as_source                             "Anchors_Define_As_Source "
#define a_define_as_inline_source                      "Anchors_Define_As_Inline_Source "
#define a_define_as_destination                        "Anchors_Define_As_Destination "
#define a_use_default_destination                      "Anchors_Use_Default_Destination "
#define a_delete                                       "Anchors_Delete "

#define n_search_next                                  "Navigate_Search_Next "
#define n_search_previous                              "Navigate_Search_Previous "

#define f_new                                          "File_New "
#define f_view_source                                  "File_View_Source "
#define f_open                                         "File_Open-"
#define f_save_as                                      "File_Save_As "
#define f_edit                                         "File_Edit "
#define f_print                                        "File_Print "
#define f_mail_to                                      "File_Mail_To "

#define dis_options_hyphenation                        "Display_Options_Hyphenation "
#define dis_color                                      "Display_Colors "
#define dis_selected_anchor                            "Display_Selected_Anchor "
#define dis_background                                 "Display_BackGround "
#define dis_font                                       "Display_Fonts "
#define dis_settings                                   "Display_Settings "
#define dis_show_anchors                               "Display_Show_Anchors "
#define dis_use_checkmarks                             "Display_Use_Checkmarks "
#define dis_destination_color                          "Display_Destination_Color "
#define dis_txt_select                                 "Display_Text_Select_Color "
#define dis_color_anchor                               "Display_Color_Anchor "
#define dis_anchor                                     "Display_Anchor "

//-------------- End of Text-Viewer defines ---------------------

//-------------- Image-Viewer defines ---------------------------
#define dis_live                                       "Display_Live "
#define dis_autofit                                    "Display_AutoFit "
#define dis_shrink_only                                "Display_ShrinkOnly " 
#define dis_zoom_in                                    "Display_ZoomIn-"
#define dis_zoom_out                                   "Display_ZoomOut-"
#define dis_dithering                                  "Display_Dithering-" 
#define dis_refresh                                    "Display_Refresh " 
#define dis_colours                                    "Display_Colours-"
#define dis_display_anchors                            "Display_Display_Anchors "
#define dis_shape                                      "Anchors_Shape-"

#define d_reload                                       "Document_Reload "

//-------------- End of Image-Viewer defines --------------------

//-------------- 3D-Viewer defines ---------------------------
#define f_parseout                                       "File_ViewParserOutput "

#define a_selectobjects                                  "Anchors_SelectObjects " 
#define a_selectgroup                                    "Anchors_SelectGroup "
#define a_deselectobjgrp                                 "Anchors_DeselectObjectGroup "
#define a_follow                                         "Anchors_Follow " 

#define n_resetview                                      "Navigate_ResetView " 
#define n_levelview                                      "Navigate_LevelView "
#define n_untiltview                                     "Navigate_UntiltView "
#define n_settings                                       "Navigate_Settings "
#define n_move                                           "Navigate_Move-"
#define n_spaceball                                      "Navigate_SpaceBall "
#define n_options                                        "Navigate_Options_"

#define d_settings_help                                  "Dialog_NavigateSettingsHelp "
#define dis_drawmode                                     "Display_DrawMode-"
#define dis_drawmodeinter                                "Display_Interactive-"
#define dis_viewinglight                                 "Display_ViewingLight "
#define dis_texturelighting                              "Display_TextureLighting "
#define dis_texturetransparency                          "Display_TextureTransparency "
#define dis_lineantialiasing                             "Display_LineAntialiasing "
#define dis_anchors                                      "Display_Anchors "
#define dis_colour                                       "Display_Colour "

//-------------- End of 3D-Viewer defines --------------------

//-------------- Film-Viewer defines ---------------------------

#define n_gotoframe                                      "Navigate_GotoFrame "

#define a_interpolation                                  "Anchors_Interpolation-"

#define dis_loop                                         "Display_Loop "
#define dis_zoom                                         "Display_Zoom_"
#define dis_synchronize                                  "Display_Synchronize "
#define dis_no_b_frames                                  "Display_NoBFrames "
#define dis_no_p_frames                                  "Display_NoPFrames "

#define b_rewind                                         "Navigate_Rewind "
#define b_stop                                           "Navigate_Stop "
#define b_play                                           "Navigate_Play "
#define b_pause                                          "Navigate_Pause "
#define b_backstep                                       "Navigate_Backstep "
#define b_step                                           "Navigate_Step "
#define b_wind                                           "Navigate_Wind " 

//-------------- End of Film-Viewer defines --------------------

//-------------- HarAdmin defines ---------------------------

#define n_grp                                           "New_Groups "
#define n_person                                        "New_Users "
#define e_grp                                           "Edit_Groups "
#define e_person                                        "Edit_Users "
#define r_grp                                           "Remove_Groups "
#define r_person                                        "Remove_Users "
#define person                                          "Info_Users "
#define people                                          "Info_Groups "
#define person_id                                       "Users_Identify "
#define o_people                                        "Options_Groups "
#define o_person                                        "Options_Users "
#define s_grp                                           "Show_Groups "
#define so_person                                       "ShowAll_Users "
#define so_grp                                          "ShowAll_Groups "
#define s_person                                        "Show_Users "

//-------------- End of HarAdmin defines --------------------

//-------------- HarEditAPITool defines ---------------------------

#define apitool_end                                           "APITool_Quit "
#define apitool_insert                                        "APITool_Insert "
#define apitool_cancel                                        "APITool_Cancel "
#define apitool_edit                                          "APITool_Edit "
#define apitool_replace                                       "APITool_Replace "

//-------------- End of HarEditAPITool defines --------------------

//************* End of Declarations *****************************

#endif /* _LOGGING_H_ */
