// This may look like C code, but it is really -*- C++ -*-
// 
// <copyright> 
//  
//  Copyright (c) 1994
//  Institute for Information Processing and Computer Supported New Media (IICM), 
//  Graz University of Technology, Austria. 
//  
// </copyright> 
// 
// 
// <file> 
// 
// Name:        fdmask.h
// 
// Purpose:     
// 
// Created:     2 Nov 95   Joerg Faschingbauer
// 
// Modified:    
// 
// Description: 
// 
// 
// </file> 
#ifndef hg_dispatch_fdmask_h
#define hg_dispatch_fdmask_h

#include "libdispatch.h"

#include <hyperg/utils/types.h>

// makedepend apparently doesnt know how to deal with #if (defined
// ...), so I have to do it this way. sorry.
#ifdef HPUX
#  define FDMASK_INCLUDES_TYPES_H
#endif
#ifdef ULTRIX
#  define FDMASK_INCLUDES_TYPES_H
#endif
#ifdef SUN
#  ifdef SOLARIS
#    define FDMASK_INCLUDES_SELECT_H
#  else
#    define FDMASK_INCLUDES_TYPES_H
#  endif
#endif
#ifdef LINUX
#  define FDMASK_INCLUDES_TYPES_H
#endif
#ifdef IRIX
#  define FDMASK_INCLUDES_SELECT_H
#endif
#ifdef OSF1
#  define FDMASK_INCLUDES_SELECT_H
#endif
#ifdef AIX
#  define FDMASK_INCLUDES_SELECT_H
#endif
#ifdef FreeBSD
#  define FDMASK_INCLUDES_TYPES_H
#endif
#ifdef BSDI
#  define FDMASK_INCLUDES_TYPES_H
#endif


#ifdef WIN32
#include <sys/socket.h>
#include <sys/param.h>
#else
#ifdef FDMASK_INCLUDES_SELECT_H
#  ifdef FDMASK_INCLUDES_TYPES_H
#    error both FDMASK_INCLUDES_*_H defined
#  else
#    include <sys/select.h>
#    undef FDMASK_INCLUDES_SELECT_H
#  endif
#else
#  ifdef FDMASK_INCLUDES_TYPES_H
#    include <sys/types.h>
#    undef FDMASK_INCLUDES_TYPES_H
#  else
#    error none FDMASK_INCLUDES_*_H defined
#  endif
#endif
#endif

#include "enter-scope.h"



class FdMask : public fd_set {
public:
   FdMask();
#ifdef WIN32
   FdMask(const FdMask& fdM);
   FdMask& operator=(const FdMask&);
#endif
   void zero();
   void setBit(int);
   void clrBit(int);
   boolean isSet(int) const;
   boolean anySet() const;
   int numSet() const;
} ;

inline FdMask::FdMask() {
   zero() ;
}


#endif
