/*************************************************
*     Exim - an Internet mail transport agent    *
*************************************************/

/* Copyright (c) University of Cambridge 1995 - 1999 */
/* See the file NOTICE for conditions of use and distribution. */

#include "../exim.h"
#include "dnsdb.h"



/* Ancient systems (e.g. SunOS4) don't appear to have T_TXT defined in their
header files. */

#ifndef T_TXT
#define T_TXT 16
#endif



/*************************************************
*              Open entry point                  *
*************************************************/

/* See local README for interface description. */

void *
dnsdb_open(char *filename, char **errmsg)
{
filename = filename;   /* Keep picky compilers happy */
errmsg = errmsg;       /* Ditto */
return (void *)(-1);   /* Any non-0 value */
}



/*************************************************
*           Find entry point for dnsdb           *
*************************************************/

/* See local README for interface description. */

int
dnsdb_find(void *handle, char *filename, char *keystring, int length,
  char **result, char **errmsg)
{
int rc;
dns_record *rr;

handle = handle;           /* Keep picky compilers happy */
filename = filename;
length = length;
errmsg = errmsg;

dns_init(FALSE, FALSE);    /* In case first time resolver is used. */

rc = dns_lookup(keystring, T_TXT, NULL);

if (rc == DNS_NOMATCH) return FAIL;
if (rc != DNS_SUCCEED) return DEFER;

for (rr = dns_next_rr(RESET_ANSWERS); rr != NULL;
     rr = dns_next_rr(RESET_NEXT))
  {
  if (rr->type == T_TXT)
    {
    int len = (rr->data)[0];
    *result = string_copyn((char *)(rr->data+1), len);
    break;
    }
  }

return OK;
}

/* End of lookups/dnsdb.c */
