/**
 * SIEGE socket header file
 *
 * Copyright (C) 2001 Jeffrey Fulmer <jdfulmer@armstrong.com>
 * This file is part of Siege
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef SOCK_H
#define SOCK_H

/**
 * create socket 
 * char *hostname
 * int portnumber
 * int SSL( 1=yes, 0=no )
 */
int SIEGEsocket( char *, int, int );

/** 
 * write int sock 
 * from char *buf, 
 * unsigned int length 
 */
int SIEGEsocket_write( char *, unsigned int );

/** 
 * read int sock, 
 * into char *buf, 
 * unsigned int length 
 */
int SIEGEsocket_read( char *, unsigned int );

/** 
 * close int socket 
 */
void SIEGEclose( );

#endif /* SOCK_H */

