/***************************************************************************
                          qttudo.h  -  description                              
                             -------------------                                         
    begin                : Don Sep  2 09:24:15 CEST 1999
    version              : $Id: qttudo.h,v 1.19 2001/02/28 07:54:50 joerg_bemme Exp $
    copyright            : (C) 1999-2001 by Jrg Bemm
    email                : j.bemme@bemme.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef QTTUDO_H
#define QTTUDO_H

// include files for QT
#include <qpopupmenu.h>
#include <qmainwindow.h>
#include <qaccel.h>
#include <qmenubar.h>
#include <qtoolbar.h>
#include <qpixmap.h>
#include <qtoolbutton.h>
#include <qapp.h>
#include <qstatusbar.h>
#include <qwhatsthis.h>
#include <qmsgbox.h>
#include <qfiledialog.h>
#include <qprinter.h>
#include <qpainter.h>

// application specific includes
#include "printsystem.h"
#include "resource.h"
#include "allgemein_anmeldung.h"
#include "kartei_debitor.h"
#include "kartei_kreditor.h"
#include "kartei_artikel.h"
#include "kartei_sachkonto.h"
#include "kartei_kontenplan.h"
#include "erfassung_zeiterfassung.h"
#include "erfassung_allg_erfassung.h"
#include "erfassung_warenerfassung.h"
#include "verkauf_rechnung.h"
#include "verkauf_gutschrift.h"
#include "verkauf_gebrechnung.h"
#include "verkauf_gebgutschrift.h"

/**
  * This Class is the base class for your application. It sets up the main
  * window and providing a menubar, toolbar
  * and statusbar. For the main view, an instance of class QtTudoView is
  * created which creates your view.
  */
class QtTudoApp : public QMainWindow
{
  Q_OBJECT
  
public:
  /** construtor */
  QtTudoApp(); 
  ~QtTudoApp();
	virtual bool close( bool forceKill );
  /** initMenuBar creates the menu_bar and inserts the menuitems */
  void initMenuBar();
  /** this creates the toolbars. Change the toobar look and add new toolbars in this
   * function */
  void initToolBar();
  /** setup the statusbar */
  void initStatusBar();
  /** setup the document*/
  void initDoc();
  /** setup the mainview*/
  void initView();
  
  /** overloaded for Message box on last window exit */
  bool queryExit();

	QCString	*ProgName;

	PrintSystem *print;

public slots:
  
	/** switch argument for Statusbar help entries on slot selection */
	void statusCallback(int id_);
  /** open a new application window */
  
  /** exits the application */
  void slotFileQuit();
  /** toggle the toolbar*/
  void slotViewToolBar();
  /** toggle the statusbar*/
  void slotViewStatusBar();
  
  /** shows an about dlg*/
  void slotHelpAbout();
  
  /** change the status message of the whole statusbar temporary */
  void slotStatusHelpMsg(const char *text);

  void slotBericht_Sachkonto_Liste();
  void slotBericht_Sachkonto_GuV();
  void slotBericht_Sachkonto_GuV_Stichtag();

  void slotKartei_Debitor();
  void slotKartei_Kreditor();
  void slotKartei_Artikel();
  void slotKartei_Preisgruppe();
  void slotKartei_Sachkonto();
  void slotKartei_Kontenplan();
  void slotKartei_Warengruppe();
  void slotKartei_Ressource();
  void slotKartei_Projekt();

  void slotErfassung_Allg_Erfassung();
  void slotErfassung_Warenerfassung();
  void slotErfassung_Zeiterfassung();

  void slotVerkauf_Angebot();
  void slotVerkauf_Auftrag();
  void slotVerkauf_Rechnung();
	void slotVerkauf_Gutschrift();

	void slotGebuchtVK_Lieferschein();
	void slotGebuchtVK_Rechnung();
	void slotGebuchtVK_Gutschrift();
	void slotGebuchtVK_Mahnung();

  void slotEinkauf_Anfrage();
  void slotEinkauf_Bestellung();
  void slotEinkauf_Rechnung();

	void slotGebuchtEK_Lieferschein();
	void slotGebuchtEK_Rechnung();
	void slotGebuchtEK_Gutschrift();

  void slotAllgemein_Anmeldung();
  void slotAllgemein_Buchhaltungsdaten();
  void slotAllgemein_Buchungsart();
  void slotAllgemein_Einheit();
  void slotAllgemein_Firmendaten();
  void slotAllgemein_Kontoart();
  void slotAllgemein_Sachkontoart();
  void slotAllgemein_Debitorgruppe();
  void slotAllgemein_Kreditorgruppe();
  void slotAllgemein_MwStCode();
  void slotAllgemein_Wahrungscode();
  void slotAllgemein_Landercode();
	void slotAllgemein_Sprache();
	void slotAllgemein_Zahlungsbedingung();
	void slotAllgemein_Projektstatus();
	void slotAllgemein_Lieferung();
	void slotAllgemein_Lokation();
	void slotAllgemein_Vertreter();
	void slotAllgemein_Preisgruppe();

	void slotAllg_BuchGr_Deb_Buch_Gruppe();
	void slotAllg_BuchGr_Kred_Buch_Gruppe();
	void slotAllg_BuchGr_Warenbuch_Gruppe();
	void slotAllg_BuchGr_ResBuch_Gruppe();

	void slotAllg_Intra_Bundesland();
	void slotAllg_Intra_Art_des_Geschaeftes();
	void slotAllg_Intra_Verkehrszweig();
	void slotAllg_Intra_Warenverzeichnis();
	void slotAllg_Intra_Hafen();
	void slotAllg_Intra_Verfahren();
	void slotAllg_Intra_Sitz_des_Versenders();
	void slotAllg_Intra_Sitz_des_Empfaengers();

	void slotAllg_Admin_GuV_Bilanz();
	void slotAllg_Admin_Soll_Haben();
	void slotAllg_Admin_UVA_Typ();
	void slotAllg_Admin_Rech_Rund_Methode();
	void slotAllg_Admin_Warenpostenart();
	void slotAllg_Admin_Belegart_EK();
	void slotAllg_Admin_Belegart_VK();
	void slotAllg_Admin_Zeileart();
	void slotAllg_Admin_Ressourceart();
	void slotAllg_Admin_Res_Posten_Art();
	void slotAllg_Admin_Projektpostenart();
	void slotAllg_Admin_Intra_Art();

	void slotBericht_Rep_ImportTex();
	void slotBericht_Rep_PrintRep();
	void slotBericht_Rep_EditReport();

	void slotPrint_Elements();
	void slotPrint_Logictype();
	void slotPrint_Syntax();
	void slotPrint_Printer();

private:

  /** Karteien contains all items of the menubar entry "Karteien" */
  QPopupMenu *Karteien_menu;
  QPopupMenu *Erfassung_menu;
  QPopupMenu *Verkauf_menu;
  QPopupMenu *Einkauf_menu;
  QPopupMenu *Berichte_menu;
  QPopupMenu *Allgemein_menu;
  QPopupMenu *view_menu;
  QPopupMenu *help_menu;
  
  QToolBar *toolbar;

	Kartei_Debitor				*debitor;
	Kartei_Kontenplan			*kontenplan;
	Kartei_Kreditor				*kreditor;
	Kartei_Artikel				*artikel;
	Kartei_Sachkonto			*sachkonto;
	Verkauf_Rechnung			*VKrechnung;
	Verkauf_Gutschrift		*VKgutschrift;
	Verkauf_GebRechnung		*gebVKrechnung;
	Verkauf_GebGutschrift	*gebVKgutschrift;

	QDBDialog *debitorgruppe;
	QDBDialog *kreditorgruppe;
	QDBDialog *buchhaltungsdaten;
	QDBDialog *firmendaten;
	QDBDialog *mwst;
	QDBDialog *waehrung;
	QDBDialog *land;
	QDBDialog *buchungsart;
	QDBDialog *einheit;
	QDBDialog *kontoart;
	QDBDialog *sachkontoart;
	QDBDialog *ressource;

	QDBErfassung *sprache;
	QDBErfassung *zahlungsbedingung;
	QDBErfassung *projektstatus;
	QDBErfassung *bundesland;
	QDBErfassung *art_des_geschaeftes;
	QDBErfassung *verkehrszweig;
	QDBErfassung *warenverzeichnis;
	QDBErfassung *hafen;
	QDBErfassung *verfahren;
	QDBErfassung *sitz_des_versenders;
	QDBErfassung *sitz_des_empfaengers;
	QDBErfassung *deb_buch_gruppe;
	QDBErfassung *kred_buch_gruppe;
	QDBErfassung *warenbuch_gruppe;
	QDBErfassung *resbuch_gruppe;
	QDBErfassung *lieferung;
	QDBErfassung *lokation;
	QDBErfassung *vertreter;
	QDBErfassung *preisgruppe;
	QDBErfassung *printElements;
	QDBErfassung *printLogictype;
	QDBErfassung *printSyntax;
	QDBErfassung *printPrinter;

	QDBTableEdit *guv_bilanz;
	QDBTableEdit *soll_haben;
	QDBTableEdit *uva_typ;
	QDBTableEdit *rech_rund_methode;
	QDBTableEdit *warenpostenart;
	QDBTableEdit *belegart_vk;
	QDBTableEdit *belegart_ek;
	QDBTableEdit *zeilenart;
	QDBTableEdit *ressourceart;
	QDBTableEdit *res_posten_art;
	QDBTableEdit *projektpostenart;
	QDBTableEdit *intra_art;

	Erfassung_Zeiterfassung *zeiterfassung;
	Erfassung_Allg_Erfassung *allg_erfassung;
	Erfassung_Warenerfassung *warenerfassung;
};
#endif
