/***************************************************************************
                          QDBTABLEEDIT.H  -  description
                             -------------------                                         
    begin                : 09.03.2000
    version              : $Id: qdbtableedit.h,v 1.13 2001/03/06 21:32:33 joerg_bemme Exp $
    copyright            : (C) 2000 by Jrg Bemm
    email                : info@bemme.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef QDBTABLEEDIT_H
#define QDBTABLEEDIT_H

#include <qlineedit.h>
#include <qlistview.h>
#include <qptrdict.h>
#include <qstatusbar.h>

#include "sqlquerier.h"

class RectLineEdit;
class QDBTableEditItem;

class QDBTableEdit : public QListView
{
	Q_OBJECT
public:
	QDBTableEdit( QWidget *parent = 0L, const char *name = 0L,
  							SQLQuerier *sql_ptr = 0, SQLTable* table_ptr = 0,
								QStatusBar *statusBar_ptr = 0,
								const char *tableName = 0, bool all_visible = true,
								bool editable = false );
	~QDBTableEdit();

	// Makes the item in column col editable / not editable
	// By default, all items/all columns are editable
//	void setEditable( QDBTableEditItem *item, int col, bool enable );
	bool update( bool withEmit = true );
	QDBTableEditItem * currentItem() const;
	void makeVisible( int i );
	void addCol( int i ); // add column with fieldindex i
	bool insTuple();
	// get the column index for a tuple
	int colIndex( int tupleInd );
	void changeColumn( int tupleInd, int size, const char *text );
	bool isInsMode();

	// functions for make is easier to fill or modify fields in a line
	void setText( const char *field, const char *value );
	QString getText( const char *field );
	void copyText( const char *fromField, const char *toField );

	int puCol;
	bool isEditable;

	// Default values for preinserting
	// This has nothing to do with the default values
	// of the SQL-Database.
	QString *Feldvorgabe[MAXFELDER];

	// Is the column visible?
	bool visible[MAXFELDER];
	// What column index the tuple column has.
	// -1 = no index
	int tupleIndex[MAXFELDER];
	// Name of the column, if not the fieldname
	QString *colName[MAXFELDER];
	// Size of column
	int colSize[MAXFELDER];

protected:
	virtual void keyPressEvent( QKeyEvent * );
//	virtual void contentsMousePressEvent( QMouseEvent * e );
//	virtual void setSelected( QDBTableEditItem * item, bool selected );

protected slots:
	void slotItemClicked( QDBTableEditItem * );
	void slotDestroyEdit();

private:
	virtual void insLine();
	void delTuple();
	void fReturnPressed( bool ColumnChange );
	void makeItemVisible();

	// a list of columns per item that are NOT editable
//	typedef QValueList<int> ColumnList;
//	QPtrDict<ColumnList> myUnEditableDict;

	RectLineEdit	*prEdit;
	SQLQuerier		*sql;
	SQLTable			*table;
	const char 		*sName;
	QStatusBar		*statusBar;
	QString				slastKey;
	int						ilastKey;
	int nTuples;
	bool insMode;

signals:
	// Emitted, when an item was edited and changed. Parameters are the
	// modified item and the respective column.
	void itemChanged( int );
	void doubleClicked( QDBTableEditItem * );
	void newTuple();
	void tupleModified();
	// Emitted, when a tuple was modified/updated, for
	// making different things after the tuple was changed.
	void tupleUpdated( const char * );
};

// a lineEdit that paints a rectangle instead of the standard frame
// used for in-place editing
class RectLineEdit : public QLineEdit
{
public:
	RectLineEdit( QWidget *parent=0, const char *name=0 );
	RectLineEdit( const QString& text, QWidget *parent=0, const char *name=0 );

protected:
	virtual void keyPressEvent( QKeyEvent * );
	virtual void paintEvent( QPaintEvent *e );
};

class QDBTableEditItem : public QListViewItem
{
public:
  QDBTableEditItem( QDBTableEdit *parent = 0, const QString &name = 0, int pos=0 );
	~QDBTableEditItem();
	QDBTableEditItem * itemBelow();

	QDBTableEdit *DBTableEdit;
	int		DBPos;
	bool	modified;

protected:
	virtual void paintFocus( QPainter *, const QColorGroup & cg, const QRect & r );
};

#endif // QDBTABLEEDIT_H
