/***************************************************************************
                      qdberfassung.cpp  -  description
                      --------------------------------
    begin                : 19.04.2000
    version              : $Id: qdberfassung.cpp,v 1.4 2001/01/24 20:43:13 joerg_bemme Exp $
    copyright            : (C) 2000 by Jrg Bemm
    email                : <info@bemme.de> www.bemme.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "qdberfassung.h"

QDBErfassung::QDBErfassung(QWidget *parent, const char *name,
			SQLQuerier *sql_ptr, SQLTable *table_ptr, const char *tableName,
			bool all_visible )
	: QMainWindow(parent,name)
{
	setCaption( name );

	tabWidget = new QTabWidget( this );

	Page1 =	new QDBTableEdit(this,0,sql_ptr,table_ptr,statusBar(),tableName,all_visible,true);

  QWidget *Page2      = new QWidget( this );
	QFrame *frSortP2		= new QFrame( Page2 );
  QVBoxLayout *topLayoutP2 = new QVBoxLayout( Page2, 10 );

	// Sortierung
  frSortP2->setFrameStyle( QFrame::Box | QFrame::Sunken );
	frSortP2->setMinimumSize( Page2->sizeHint() );
	SortP2 = new QDBSortFilter( frSortP2, "Filter", sql_ptr, table_ptr );
	topLayoutP2->addWidget( frSortP2, 10 );

	tabWidget->addTab( Page1, "&Kladde" );
	tabWidget->addTab( Page2, "&Selektion" );
	tabWidget->adjustSize();
	tabWidget->resize( 800, 400 );
	setCentralWidget( tabWidget );

	connect( tabWidget, SIGNAL(selected(const QString &) ),
		SLOT(updateView(const QString &)) );
}

QDBErfassung::~QDBErfassung()
{

}

void QDBErfassung::updateView( const QString &seite ) {
	// Hier mssen die Tabellendaten neu gelesen werden.
	if ( seite != "&Selektion" )
		Page1->update();
}
