/***************************************************************************
                          kartei_artikel.cpp  -  description
                             -------------------
    begin                : Sat Jul 22 2000
    version              : $Id: kartei_artikel.cpp,v 1.4 2000/09/16 18:25:54 joerg_bemme Exp $
    copyright            : (C) 2000 by Jrg Bemm
    email                : info@bemme.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qmessagebox.h>

#include "kartei_artikel.h"
#include "qdbtableviewsum.h"

Kartei_Artikel::Kartei_Artikel(QWidget *parent, const char *name,
															SQLQuerier *sql_ptr )
: QWidget(parent,name)
{
	QBoxLayout *topLayout = new QVBoxLayout( this, 5 );

	dialog = new QDBMenuDialog( this, 0, sql_ptr, false,
									"select * from artikel order by nummer", "nummer", "artikel",
									"Artikel.kdevdlg" );

	table = dialog->dialog->table;

	buchhaltung = new QPopupMenu( this );
	buchhaltung->insertItem( "B&uchungen", this, SLOT(sBuchungen()) );
	dialog->menuBar->insertItem( "&Buchhaltung", buchhaltung );

	topLayout->addWidget( dialog, 5 );

	setMinimumSize( dialog->dialog->Page1->sizeHint() );
	setMinimumSize( width()+50, dialog->dialog->Page1->height()+100 );
}

Kartei_Artikel::~Kartei_Artikel(){
}

void Kartei_Artikel::sBuchungen()
{
	QString selectStr = "select * from warenposten where artikelnr='";
	selectStr += table->getValue( table->pos, table->fNumber( "nummer" ) );
	selectStr += "' order by artikelnr,lfd_nr";

	SQLTable *table2 = new SQLTable( selectStr.ascii(), "lfd_nr" );

	// Test: If you want to see the query before.
	//QMessageBox::information( this, "Test: Posten", selectStr.ascii() );

	table2->execute();

	QDialog *Posten = new QDialog( this, 0, true );
	QDBTableViewSum *view = new QDBTableViewSum( Posten, 0, &sql, table2,
			"menge,restmenge,betrag" );
	QBoxLayout *topLayout = new QVBoxLayout( Posten, 5 );
	topLayout->addWidget( view, 5 );

	QString sName = "QtTudo Warenposten Artikel-Nr. ";
	sName += table->getValue( table->pos, table->fNumber( "nummer" ) );
	Posten->setCaption( sName );
	Posten->exec();
}
