.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "DROP TABLE" "l" "2002-01-30" "SQL - Language Statements" "SQL Commands"
.SH NAME
DROP TABLE \- remove a table
.SH SYNOPSIS
.sp
.nf
DROP TABLE \fIname\fR [, ...]
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIname\fB\fR
The name of an existing table to drop.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBDROP\fR
The message returned if the command completes successfully.
.TP
\fBERROR: table "\fIname\fB" does not exist\fR
If the specified table does not exist in the database.
.PP
.SH "DESCRIPTION"
.PP
\fBDROP TABLE\fR removes tables from the database.
Only its owner may destroy a table. A table
may be emptied of rows, but not destroyed, by using \fBDELETE\fR.
.PP
If a table being destroyed has secondary indexes on it,
they will be removed first. The removal of just a
secondary index will not affect the contents of the underlying table.
.SS "NOTES"
.PP
Refer to \fBCREATE TABLE\fR and
\fBALTER TABLE\fR for information on
how to create or modify tables.
.SH "USAGE"
.PP
To destroy two tables, films and 
distributors:
.sp
.nf
DROP TABLE films, distributors;
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
SQL92 specifies some additional capabilities for DROP TABLE:
.sp
.nf
DROP TABLE \fItable\fR { RESTRICT | CASCADE }
   
.sp
.fi
.TP
\fBRESTRICT\fR
Ensures that only a table with no dependent views or
integrity constraints can be destroyed.
.TP
\fBCASCADE\fR
Any referencing views or integrity constraints
will also be dropped.
.sp
.RS
.B "Tip:"
At present, to remove a referenced view you must drop
it explicitly.
.PP
.RE
.sp
