/*
 * Open Gatekeeper address utilities
 *
 * Copyright (c) Egoboo Ltd. 1999-2000
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Open Gatekeeper
 *
 * The Initial Developer of the Original Code is Egoboo Ltd.
 *
 * $Log: AddrUtils.cxx,v $
 * Revision 1.2  2000/04/12 13:30:14  aunitt
 * Added new convenience functions to convert to and from H225 Transport Addresses.
 *
 * Revision 1.1  2000/02/27 20:40:47  aunitt
 * Address utilities module
 *
 *
 *
 */

#include "AddrUtils.h"

void AddrUtils::GetIPAddress(       H225_TransportAddress &           IPAddress,
                              const H225_ArrayOf_TransportAddress &   Addresses
                            )
// Task: given an array of transport address, returns the first IP address
//       will throw an error if no IP address
{
	for ( PINDEX i=0; i < Addresses.GetSize(); ++i )
	{
		if ( Addresses[i].GetTag() == H225_TransportAddress::e_ipAddress )
		{
			IPAddress = Addresses[i];
			return;
		}
	}

	throw IPAddrNotFoundError("No H225 IP address found!");
}

void AddrUtils::GetIPAddress(       H225_TransportAddress_ipAddress & IPAddress,
                              const H225_ArrayOf_TransportAddress &   Addresses
                            )
// Task: given an array of transport address, returns the first IP address
//       will throw an error if no IP address
{
    H225_TransportAddress AkaIPAddr;
    AddrUtils::GetIPAddress( AkaIPAddr, Addresses );
    IPAddress = static_cast<H225_TransportAddress_ipAddress &>(AkaIPAddr);
}

H225_TransportAddress AddrUtils::ConvertToH225TransportAddr( const PIPSocket::Address & Addr,
                                                                   WORD                 Port
                                                           )
// Task: to convert an IP address into an H225 transport address
{
    H225_TransportAddress Result;

    Result.SetTag( H225_TransportAddress::e_ipAddress );
    H225_TransportAddress_ipAddress & ResultIP = Result;

    ResultIP.m_ip[0]    = Addr.Byte1();
    ResultIP.m_ip[1]    = Addr.Byte2();
    ResultIP.m_ip[2]    = Addr.Byte3();
    ResultIP.m_ip[3]    = Addr.Byte4();
    ResultIP.m_port     = Port;

    return Result;
}

void AddrUtils::ConvertToIPAddress( const H225_TransportAddress_ipAddress &   H225IP,
                                          PIPSocket::Address &                Addr,
                                          WORD &                              Port
                                  )
// Task: to convert an IP address in H225 format to PWLIB format
{
	PIPSocket::Address ResultAddr(H225IP.m_ip[0], H225IP.m_ip[1],
	                              H225IP.m_ip[2], H225IP.m_ip[3]
	                             );
	
    Addr = ResultAddr;
    Port = static_cast<WORD>(H225IP.m_port);	
}
