/*
 * sdl.h
 *
 * SDL video interface
 *
 * Copyright (c) 1999-2000 Equivalence Pty. Ltd.
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Open H323 Library.
 *
 * The Initial Developer of the Original Code is Equivalence Pty. Ltd.
 *
 * Contributor(s): Derek J Smithies (derek@indranet.co.nz)
 *
 * $Log: sdlvid.h,v $
 * Revision 1.2  2001/05/25 01:14:44  dereks
 * Alter SetFrameSize & OpenWindo to use unsigned variables. Change type of
 * other variables to eliminate compiler warnings.
 *
 * Revision 1.1  2001/03/07 01:47:45  dereks
 * Initial release of SDL (Simple DirectMedia Layer, a cross-platform multimedia library),
 * a video library code.
 *
 *
 */
#ifdef  HAS_SDL
#ifndef _OhPhone_SDL_H
#define _OhPhone_SDL_H

#include <ptlib.h>
#include <videoio.h>

#include <SDL.h>

/**Display data to the SDL screen.
  */
class SDLVideoDevice : public H323VideoDevice
{
  PCLASSINFO(SDLVideoDevice, H323VideoDevice);

 public:
  /**Constructor. Does not make a window. Initializes all variables;
   */
  SDLVideoDevice(const PString & _remoteName,BOOL _isEncoding, BOOL _videoPIP);

  /**Destructor.  Closes window if necessary, (which initializes all variables)
   */
  ~SDLVideoDevice();

  /**Synonymous with the destructor.
   */
  BOOL Close();
  
  /**Global test function to determine if this video rendering
     class is open.*/
  BOOL IsOpen();
  
  /**Take a YUV411 format image, render it on the existing window. 
     If the window is not present, there is no rendering.
  */
   BOOL Redraw (const void *frame);

   /**Set size of the window. Closes existing window, opens new window.
    */
   BOOL SetFrameSize (unsigned _width ,unsigned _height);

   /**Name of remote computer, which is used for window title.
    */
   virtual PString GetRemoteName() const
     { return remoteName ; }
    
   /**Name of remote computer, which is used for window title.
    */
   virtual void SetRemoteName(const PString & _remoteName)
     { remoteName = _remoteName; }

   /**Specifies required number of bitplanes in the image.
    */
   void ForceDepth(int d)
     { forceDepth = d; }

   /** Set static array variables to null
    */
static  void InitializeStaticVariables(void);

  protected:
    // overrides from H323VideoDevice
    BOOL WriteLineSegment(int /*x*/, int /*y*/, unsigned /*len*/, const BYTE * /*data*/)
       { return TRUE; }

 private:
    /**Report (in one word) if this is the local or received window.
     */
    inline const char *DirectionStr(void)  
      { return(isEncoding?"Local":"Receiving"); }

    /**Open the SDL screen, on which all windows are rendered.
     */
    BOOL OpenScreen();

    /**Close the SDL screen, on which all windows are rendered.
     */
    void CloseScreen();

    /**Open the YUV overlay, on which data for this window is rendered.
     */
    BOOL CreateOverlay();

    /**Store the height,widths etc for this classes window
     */
    void InitDisplayPosn();

    /**Closes the window associated with this task. 
     */
    void CloseWindow();

    /**Handles all events that occur in the SDL window (resize and quit)
     */
    void ProcessSdlEvents(void);

    /**Returns index to determine display params for this class*/
    int xIndex(void)
      { return (isEncoding ? 1 : 0); }

    /**Returns the index if this is the local image */
    int encodeIndex(void)
      { return 1; }

    /**Returns the index if this is the remote image*/
    int remoteIndex(void)
      { return 0; }

    //videoMutex provides protection for the SDL libraries.
    //Only one task access the video stuff at any point in time.
    static PMutex        videoMutex;
    static SDL_Surface  *screen;
    static SDL_Overlay  *overlay[2];
 public:
    static SDL_Rect      displayPosn[2];
 protected:
    static unsigned   wide[2];
    static unsigned   high[2];
    
    PString  remoteName;
    int      forceDepth;

    BOOL     isEncoding;
    BOOL     videoPIP;

    unsigned     width,height;
};




#endif
#endif

// End of File ///////////////////////////////////////////////////////////////
