// Copyright (c) 2000 Brad Hughes <bhughes@trolltech.com>
//
// Use, modification and distribution is allowed without limitation,
// warranty, or liability of any kind.
//

#ifndef __mq3d_h
#define __mq3d_h

class MQ3d;

#include <qserversocket.h>
#include <qtextstream.h>


const int mq3dListenPort = 42666; // why not?

class Collections;


class MQ3d : public QServerSocket
{
public:
    MQ3d(bool);
    virtual ~MQ3d();

    inline Collections *collections() const { return colls; }
    inline const QString &collectionsFileName() const { return collpath; }
    inline bool error() const { return err; }

    virtual void newConnection(int);

    void load();
    void generate();
    void addCollection(QTextStream &, const QString &, const QString &);


private:
    void doDir(QTextStream &, const QString &, int);

    bool err;
    QString collpath;
    Collections *colls;
};


#endif // __mq3d_h
