/*
hashtbl
Copyright (C) 2001 Ed Cashin

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#ifndef	ELC_ERRMACS_H
#define	ELC_ERRMACS_H

#ifndef	PROGNAME
#define	PROGNAME	__FILE__
#endif

#define	STDIO_ERRORS
#ifdef	STDIO_ERRORS
#define	fatal_error(s) do {				\
    fprintf(stderr, PROGNAME ": Error in %s (%s): %s\n",	\
	    __FUNCTION__, s, strerror(errno));		\
    exit(EXIT_FAILURE);					\
} while (0)
#define	fatal_death(s) do {				\
    fprintf(stderr, PROGNAME ": Error in %s: %s\n",	\
	    __FUNCTION__, s);				\
    exit(EXIT_FAILURE);					\
} while (0)
#define	pwarn(s) do {						\
    fprintf(stderr, PROGNAME ": Warning in %s (%s): %s\n",	\
	    __FUNCTION__, s, strerror(errno));			\
} while (0)
#define	warn(s) do {					\
    fprintf(stderr, PROGNAME ": Warning in %s: %s\n",	\
	    __FUNCTION__, s);				\
} while (0)
#define	sndlib_error(s)	do {					\
    fprintf(stderr, PROGNAME " Error in %s:%s (%s): %s\n",	\
	    __FILE__, __FUNCTION__,				\
	    s, audio_error_name(audio_error()));		\
    exit(EXIT_FAILURE);						\
} while (0)
#else
#define	fatal_error(s)	do {				\
    syslog(LOG_ERR, PROGNAME ": Error in %s (%s): %s",	\
	   __FUNCTION__, s, strerror(errno));		\
    exit(EXIT_FAILURE);					\
} while (0)
#define	fatal_death(s)	do {				\
    syslog(LOG_ERR, PROGNAME ": Error in %s: %s",	\
	   __FUNCTION__, s);				\
    exit(EXIT_FAILURE);					\
} while (0)
#define	pwarn(s)	do {					\
    syslog(LOG_WARNING, PROGNAME ": Warning in %s (%s): %s",	\
	   __FUNCTION__, s, strerror(errno));			\
} while (0)
#define	warn(s)	do {					\
    syslog(LOG_WARNING, PROGNAME ": Warning in %s: %s",	\
	   __FUNCTION__, s);				\
} while (0)
#define	sndlib_error(s)	do {					\
    syslog(LOG_ERR, PROGNAME ": Error in %s:%s (%s): %s",	\
	   __FILE__, __FUNCTION__, s,				\
	   audio_error_name(audio_error()));			\
    exit(EXIT_FAILURE);						\
} while (0)
#endif

#endif
