/*
 *  Copyright (C) 2001 Philip Langdale
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef PROGRESSLISTENER_H__
#define PROGRESSLISTENER_H__

#include "nsIWebProgressListener.h"

#include <gtk/gtkwidget.h>

#include "nsIHelperAppLauncherDialog.h"
#include "nsIExternalHelperAppService.h"
#include "nsCExternalHandlerService.h"
#include "nsIWebBrowserPersist.h"
#include "nsCOMPtr.h"
#include "nsWeakReference.h"

#include "nsIURI.h"
#include "nsILocalFile.h"
#include "nsIDOMWindow.h"
#include "nsIRequest.h"

#include "mozilla.h"
#include "favicon.h"
#include "ProgressCallbacks.h"
#include "ContentHandler.h"

class GProgressListener : public nsIWebProgressListener,
			  public nsSupportsWeakReference,
			  public GIProgressCallbacks
{
 public:
 	NS_DECL_ISUPPORTS
	NS_DECL_NSIWEBPROGRESSLISTENER
	G_DECL_GIPROGRESSCALLBACKS

	GProgressListener (void);
	virtual ~GProgressListener ();

	NS_METHOD InitForPersist (nsIWebBrowserPersist *aPersist,
			     nsIDOMWindow *aParent, nsIURI *aURI,
			     nsIFile *aFile, DownloadAction aAction,
			     gpointer info,
			     PRInt64 aTimeDownloadStarted = 0);
	NS_METHOD InitForDownload (nsIHelperAppLauncher *aLauncher,
			      nsISupports *aContext,
			      GContentHandler *aHandler,
			      DownloadAction aAction);
	GTimer *mTimer;
 private:
	char * FormatTime (PRUint32 aTime);

	nsCOMPtr<nsIHelperAppLauncher> mLauncher;
	nsCOMPtr<nsIWebBrowserPersist> mPersist;
	nsCOMPtr<GContentHandler> mHandler;
	nsCOMPtr<nsIDOMWindow> mParent;
	nsCOMPtr<nsIRequest> mRequest;
	DownloadAction mAction;
        gpointer mCallbackInfo;
	
	nsCOMPtr<nsIURI> mUri;
	PRInt64 mTimeDownloadStarted;
	nsCOMPtr<nsIFile> mFile;
	
	PRInt64 mStartTime;
	PRInt64 mElapsed;
	
	PRInt64 mLastUpdate;
	PRInt32 mInterval;

	PRFloat64 mPriorKRate;
	PRInt32 mRateChanges;
	PRInt32 mRateChangeLimit;

	PRBool mCheckedCanPause;
	PRBool mCanPause;
	PRBool mIsPaused;

	GtkWidget *mProgressDialog;
	GtkWidget *mProgressBar;
	GtkWidget *mLocation;
	GtkWidget *mFileName;
	GtkWidget *mStatus;
	GtkWidget *mTimeElapsed;
	GtkWidget *mTimeRemaining;
	GtkWidget *mPauseButton;
	guint mTimeoutFunc;
};

#endif // PROGRESSLISTENER_H__

