/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "galeon.h"
#include "mozilla.h"

void context_menu_add_seperator (GtkMenu *extra_menu);
void context_menu_add_item (GtkMenu *extra_menu, const gchar *text,
			    GtkSignalFunc cb_func, void *cb_data,
			    const char *icon, gboolean sensitive);
void context_menu_add_check_item (GtkMenu *extra_menu, const gchar *text,
				  GtkSignalFunc cb_func, void *cb_data,
				  gboolean checked);
void context_menu_add_radio_item (GtkMenu *extra_menu, const gchar *text,
				  GtkSignalFunc cb_func, void *cb_data,
				  gboolean checked, GSList **group);

void context_show_menu (GaleonEmbed *embed, WrapperContextInfo *info,
			int button, guint timestamp);
void context_show_bookmark_menu (GaleonEmbed *embed,
				 int button,
			         guint timestamp);
void context_show_appearance_menu (GaleonWindow *window, GtkMenu *menu, 
				   BookmarkItem *bi, gboolean is_button, 
				   gboolean in_submenu);
