// ErlComServTest.cpp : Implementation of CErlComTestServApp and DLL registration.

#include "stdafx.h"
#include "ErlComTestServ.h"
#include "ErlComServTest.h"

/////////////////////////////////////////////////////////////////////////////
//

STDMETHODIMP CErlComServTst::InterfaceSupportsErrorInfo(REFIID riid)
{
    static const IID* arr[] = 
    {
	&IID_IErlComServTst,
    };
    
    for (int i=0;i<sizeof(arr)/sizeof(arr[0]);i++)
    {
	if (InlineIsEqualGUID(*arr[i],riid))
	    return S_OK;
    }
    return S_FALSE;
}

STDMETHODIMP CErlComServTst::I4Add(long a, long b, long *c)
{
    *c = a + b;
    return S_OK;
}

STDMETHODIMP CErlComServTst::GetCurrentDate(DATE *currentDate)
{
    UDATE s;
    s.wDayOfYear = 0;
    GetSystemTime(&s.st);
    VarDateFromUdate(&s, 0, currentDate);
    
    return S_OK;
}

STDMETHODIMP CErlComServTst::ReverseString(BSTR inStr, BSTR *outStr)
{
    int n = SysStringLen(inStr);
    *outStr = SysAllocStringLen(NULL, n);
    for (int i = 0; i < n; ++i) 
    {
	(*outStr)[n-i-1] = inStr[i];
    }
    SysFreeString(inStr);
    
    return S_OK;
}

STDMETHODIMP CErlComServTst::DaysBetween(DATE date1, DATE date2, double* daysBetween)
{
    *daysBetween = date2-date1;
    
    return S_OK;
}

/*STDMETHODIMP CErlComServTst::GetPixelRow(double x0, double xd, double y0, 
					 LONG nPts, LONG maxIter, SAFEARRAY* ptArray)
{
    int i, j;
    for (i = 0; i < nPts; ++i) {
        double x = x0, y = y0;
	LONG* nIter = 0;
	for (j = 0; j < maxIter; ++j) {
	    double x2 = x*x, y2 = y*y;
	    double norm = x2+y2;
	    if (norm>4) {
		break; 
	    }
	    y = 2*x*y+y0;
	    x = x2-y2+x0; 
	}
	*nIter = j; 
    }
    return S_OK;
}*/

STDMETHODIMP CErlComServTst::R8Add(double a, double b, double *c)
{
    *c = a + b;    
    return S_OK;
}

STDMETHODIMP CErlComServTst::SumArray(VARIANT* numbers, double* sum)
{
    if (numbers->vt != VT_ARRAY) return E_INVALIDARG;
    void* p;
    SafeArrayAccessData(*numbers->pparray, &p);
    int n = 1;
    for (int i = 0; i < (*numbers->pparray)->cDims; ++i) {
	n *= (*numbers->pparray)->rgsabound[i].cElements; 
    }
    *sum = 0;
    for (i = 0; i < n; ++i) {
	*sum += ((double*)p)[i];
    }
    SafeArrayUnaccessData(*numbers->pparray);
    return S_OK;
}

STDMETHODIMP CErlComServTst::Delay(long mSecs)
{

    SleepEx(mSecs, TRUE);

    return S_OK;
}

STDMETHODIMP CErlComServTst::Clone(IErlComServTst **clone)
{
    LPVOID p;
    HRESULT r = CoCreateInstance(CLSID_ErlComServTst, NULL, 15, IID_IErlComServTst, &p);
    if (SUCCEEDED(r))
	*clone = (IErlComServTst*)p;
    return r;
}

STDMETHODIMP CErlComServTst::R8Sub(double a, double b, double *c)
{
 	*c = a - b;
	return S_OK;
}
