//
//  configwindow.cpp  --  generate the GUI configuration window
//  -- created 5/23/00  updated 5/23/00
///////////////////////////////////////////////

#include "configwindow.h"

extern Althea gAlthea_config;

GtkWidget*
create_configwindow (void)
{
  GtkWidget *window;
  GtkWidget *main_vbox;
  GtkWidget *notebook;
  GtkWidget *server_list_box;
  GtkWidget *server_list;
  GtkWidget *server_vbox;
  GtkWidget *add_server_button;
  GtkWidget *edit_server_button;
  GtkWidget *delete_server_button;
  GtkWidget *servers;
  GtkWidget *filter_list_box;
  GtkWidget *filter_list;
  GtkWidget *filter_vbox;
  GtkWidget *add_filter_button;
  GtkWidget *edit_filter_button;
  GtkWidget *delete_filter_button;
  GtkWidget *filters;
  GtkWidget *placeholder_label;
  GtkWidget *appearance;
  GtkWidget *buttonbox;
  GtkWidget *ok_button;
  GtkWidget *cancel_button;


  // BUILD WINDOW
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (window), "window", window);
  gtk_window_set_title (GTK_WINDOW (window), ("Althea Configuration"));
  gtk_container_set_border_width (GTK_CONTAINER (window), 10);


  // BUILD MAIN VBOX
  main_vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (main_vbox);
  gtk_object_set_data_full (GTK_OBJECT (window), "main_vbox", main_vbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (main_vbox);
  gtk_container_add (GTK_CONTAINER (window), main_vbox);
  gtk_container_set_border_width (GTK_CONTAINER (main_vbox), 10);


  // BUILD NOTEBOOK
  notebook = gtk_notebook_new ();
  gtk_widget_ref (notebook);
  gtk_object_set_data_full (GTK_OBJECT (window), "notebook", notebook,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (notebook);
  gtk_box_pack_start (GTK_BOX (main_vbox), notebook, TRUE, TRUE, 0);


  // SERVER LIST BOX
  server_list_box = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (server_list_box);
  gtk_object_set_data_full (GTK_OBJECT (window), "server_list_box",
			    server_list_box,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (server_list_box);
  gtk_container_add (GTK_CONTAINER (notebook), server_list_box);

  // SERVER LIST
  server_list = gtk_list_new ();
  gAlthea_config.set_Server_Config_List(server_list);
  gtk_widget_ref (server_list);
  gtk_object_set_data_full (GTK_OBJECT (window), "server_list", server_list,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (server_list);
  gtk_box_pack_start (GTK_BOX (server_list_box), server_list, TRUE, TRUE, 0);
  gtk_widget_set_usize (server_list, 327, -2);

  // SERVER VBOX
  server_vbox = gtk_vbox_new (TRUE, 0);
  gtk_widget_ref (server_vbox);
  gtk_object_set_data_full (GTK_OBJECT (window), "server_vbox", server_vbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (server_vbox);
  gtk_box_pack_start (GTK_BOX (server_list_box), server_vbox, FALSE, FALSE, 0);

  // ADD SERVER BUTTON
  add_server_button = gtk_button_new_with_label ("Add");
  gtk_widget_ref (add_server_button);
  gtk_object_set_data_full (GTK_OBJECT (window), "add_server_button",
			    add_server_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (add_server_button);
  gtk_box_pack_start (GTK_BOX (server_vbox), add_server_button, FALSE, FALSE, 0);

  // EDIT SERVER BUTTON
  edit_server_button = gtk_button_new_with_label ("Edit");
  gtk_widget_ref (edit_server_button);
  gtk_object_set_data_full (GTK_OBJECT (window), "edit_server_button",
			    edit_server_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (edit_server_button);
  gtk_box_pack_start(GTK_BOX (server_vbox), edit_server_button, FALSE, FALSE, 0);

  // DELETE SERVER BUTTON
  delete_server_button = gtk_button_new_with_label ("Delete");
  gtk_widget_ref (delete_server_button);
  gtk_object_set_data_full (GTK_OBJECT (window), "delete_server_button",
			    delete_server_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (delete_server_button);
  gtk_box_pack_start (GTK_BOX (server_vbox), delete_server_button, FALSE,
		      FALSE, 0);

  // SERVERS TAB
  servers = gtk_label_new (_("Servers"));
  gtk_widget_ref (servers);
  gtk_object_set_data_full (GTK_OBJECT (window), "servers", servers,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (servers);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook),
			      gtk_notebook_get_nth_page
			      (GTK_NOTEBOOK (notebook), 0), servers);

  // FILTER LIST BOX
  filter_list_box = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (filter_list_box);
  gtk_object_set_data_full (GTK_OBJECT (window), "filter_list_box",
			    filter_list_box,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (filter_list_box);
  gtk_container_add (GTK_CONTAINER (notebook), filter_list_box);

  // FILTER LIST
  filter_list = gtk_list_new ();
  gAlthea_config.set_Filter_Config_List(filter_list);
  gtk_widget_ref (filter_list);
  gtk_object_set_data_full (GTK_OBJECT (window), "filter_list", filter_list,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (filter_list);
  gtk_box_pack_start (GTK_BOX (filter_list_box), filter_list, TRUE, TRUE, 0);

  // FILTER VBOX
  filter_vbox = gtk_vbox_new (TRUE, 0);
  gtk_widget_ref (filter_vbox);
  gtk_object_set_data_full (GTK_OBJECT (window), "filter_vbox", filter_vbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (filter_vbox);
  gtk_box_pack_start (GTK_BOX (filter_list_box), filter_vbox, FALSE, TRUE, 0);

  // ADD FILTER BUTTON
  add_filter_button = gtk_button_new_with_label ("Add");
  gtk_widget_ref (add_filter_button);
  gtk_object_set_data_full (GTK_OBJECT (window), "add_filter_button",
			    add_filter_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (add_filter_button);
  gtk_box_pack_start (GTK_BOX (filter_vbox), add_filter_button, FALSE, FALSE, 0);

  // EDIT FILTER BUTTON
  edit_filter_button = gtk_button_new_with_label ("Edit");
  gtk_widget_ref (edit_filter_button);
  gtk_object_set_data_full (GTK_OBJECT (window), "edit_filter_buton",
			    edit_filter_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (edit_filter_button);
  gtk_box_pack_start(GTK_BOX (filter_vbox), edit_filter_button, FALSE, FALSE, 0);

  // DELETE FILTER BUTTON
  delete_filter_button = gtk_button_new_with_label ("Delete");
  gtk_widget_ref (delete_filter_button);
  gtk_object_set_data_full (GTK_OBJECT (window), "delete_filter_button",
			    delete_filter_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (delete_filter_button);
  gtk_box_pack_start (GTK_BOX (filter_vbox), delete_filter_button, FALSE,
		      FALSE, 0);

  // FILTERS TAB
  filters = gtk_label_new ("Filters");
  gtk_widget_ref (filters);
  gtk_object_set_data_full (GTK_OBJECT (window), "filters", filters,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (filters);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook),
			      gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook),
							 1),
			      filters);

  // PLACEHOLDER
  placeholder_label = gtk_label_new (_("To Be Implemented"));
  gtk_widget_ref (placeholder_label);
  gtk_object_set_data_full (GTK_OBJECT (window), "placeholder_label",
			    placeholder_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (placeholder_label);
  gtk_container_add (GTK_CONTAINER (notebook), placeholder_label);


  // APPEARANE TAB
  appearance = gtk_label_new (_("Appearance"));
  gtk_widget_ref (appearance);
  gtk_object_set_data_full (GTK_OBJECT (window), "appearance", appearance,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (appearance);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook),
			      gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook),
							 2),
			      appearance);


  // BUTTON BOX
  buttonbox = gtk_hbox_new (TRUE, 0);
  gtk_widget_ref (buttonbox);
  gtk_object_set_data_full (GTK_OBJECT (window), "buttonbox", buttonbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (buttonbox);
  gtk_box_pack_start (GTK_BOX (main_vbox), buttonbox, TRUE, TRUE, 0);


  // CANCEL BUTTON
  cancel_button = gtk_button_new_with_label (_("Cancel"));
  gtk_widget_ref (cancel_button);
  gtk_object_set_data_full (GTK_OBJECT (window), "cancel_button", cancel_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (cancel_button);
  gtk_box_pack_start (GTK_BOX (buttonbox), cancel_button, TRUE, TRUE, 10);


  // OK BUTTON
  ok_button = gtk_button_new_with_label (_("OK"));
  gtk_widget_ref (ok_button);
  gtk_object_set_data_full (GTK_OBJECT (window), "ok_button", ok_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (ok_button);
  gtk_box_pack_start (GTK_BOX (buttonbox), ok_button, TRUE, TRUE, 10);
  GTK_WIDGET_SET_FLAGS (ok_button, GTK_CAN_DEFAULT);


  // SET UP CALLBACKS
  gtk_signal_connect (GTK_OBJECT (add_server_button), "clicked",
                      GTK_SIGNAL_FUNC (on_add_server_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (edit_server_button), "clicked",
                      GTK_SIGNAL_FUNC (on_edit_server_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (delete_server_button), "clicked",
                      GTK_SIGNAL_FUNC (on_delete_server_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (add_filter_button), "clicked",
                      GTK_SIGNAL_FUNC (on_add_filter_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (edit_filter_button), "clicked",
                      GTK_SIGNAL_FUNC (on_edit_filter_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (delete_filter_button), "clicked",
                      GTK_SIGNAL_FUNC (on_delete_filter_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (ok_button), "clicked",
                      GTK_SIGNAL_FUNC (on_okconfig_clicked),
                      NULL);
  gtk_signal_connect_object( GTK_OBJECT (ok_button), "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     GTK_OBJECT (window) );
  gtk_signal_connect_object( GTK_OBJECT (cancel_button), "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     GTK_OBJECT (window) );


  gtk_widget_grab_default (ok_button);

  return window;
}

GtkWidget*
create_serverconfig (void)
{
  GtkWidget *serverconfig;
  GtkWidget *vbox4;
  GtkWidget *table1;
  GtkWidget *label7;
  GtkWidget *label8;
  GtkWidget *label9;
  GtkWidget *label10;
  GtkWidget *label11;
  GtkWidget *label12;
  GtkWidget *label13;
  GtkWidget *servernameentry;
  GtkWidget *hbox5;
  GtkWidget *serverimapentry;
  GtkWidget *hbox6;
  GtkWidget *label14;
  GtkWidget *serverimapportentry;
  GtkWidget *serverusernameentry;
  GtkWidget *usessl;
  GtkWidget *hbox7;
  GtkWidget *sslhbox;
  GtkWidget *serverpasswordentry;
  GtkWidget *savepassword;
  GtkWidget *serverfolderrootentry;
  GtkWidget *serversmtpserverentry;
  GtkWidget *serverfccfolderentry;
  GtkWidget *label15;
  GtkWidget *emailaddressentry;
  GtkWidget *hbox4;
  GtkWidget *serverok;
  GtkWidget *servercancel;


  Server *the_server = gAlthea_config.get_Config_Current_Server();
  


  serverconfig = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_object_set_data (GTK_OBJECT (serverconfig), "serverconfig", serverconfig);
  gtk_window_set_title (GTK_WINDOW (serverconfig), ("Althea - Server Config"));
  gtk_window_set_modal (GTK_WINDOW (serverconfig), TRUE);
  gtk_window_set_policy (GTK_WINDOW (serverconfig), TRUE, TRUE, FALSE);

  vbox4 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox4);
  gtk_object_set_data_full (GTK_OBJECT (serverconfig), "vbox4", vbox4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox4);
  gtk_container_add (GTK_CONTAINER (serverconfig), vbox4);

  table1 = gtk_table_new (8, 2, FALSE);
  gtk_widget_ref (table1);
  gtk_object_set_data_full (GTK_OBJECT (serverconfig), "table1", table1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table1);
  gtk_box_pack_start (GTK_BOX (vbox4), table1, TRUE, TRUE, 0);

  label7 = gtk_label_new (_("Name:"));
  gtk_widget_ref (label7);
  gtk_object_set_data_full (GTK_OBJECT (serverconfig), "label7", label7,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label7);
  gtk_table_attach (GTK_TABLE (table1), label7, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label7), 0, 0.5);

  label8 = gtk_label_new (_("IMAP Server:"));
  gtk_widget_ref (label8);
  gtk_object_set_data_full (GTK_OBJECT (serverconfig), "label8", label8,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label8);
  gtk_table_attach (GTK_TABLE (table1), label8, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label8), 0, 0.5);

  label9 = gtk_label_new (_("Username:"));
  gtk_widget_ref (label9);
  gtk_object_set_data_full (GTK_OBJECT (serverconfig), "label9", label9,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label9);
  gtk_table_attach (GTK_TABLE (table1), label9, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label9), 0, 0.5);

  label10 = gtk_label_new (_("Password:"));
  gtk_widget_ref (label10);
  gtk_object_set_data_full (GTK_OBJECT (serverconfig), "label10", label10,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label10);
  gtk_table_attach (GTK_TABLE (table1), label10, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label10), 0, 0.5);

  label11 = gtk_label_new (_("Folder Root:"));
  gtk_widget_ref (label11);
  gtk_object_set_data_full (GTK_OBJECT (serverconfig), "label11", label11,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label11);
  gtk_table_attach (GTK_TABLE (table1), label11, 0, 1, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label11), 0, 0.5);

  label12 = gtk_label_new (_("SMTP Server:"));
  gtk_widget_ref (label12);
  gtk_object_set_data_full (GTK_OBJECT (serverconfig), "label12", label12,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label12);
  gtk_table_attach (GTK_TABLE (table1), label12, 0, 1, 5, 6,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label12), 0, 0.5);

  label13 = gtk_label_new (_("Sent Mail Folder:"));
  gtk_widget_ref (label13);
  gtk_object_set_data_full (GTK_OBJECT (serverconfig), "label13", label13,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label13);
  gtk_table_attach (GTK_TABLE (table1), label13, 0, 1, 6, 7,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label13), 0, 0.5);

  servernameentry = gtk_entry_new ();
  gtk_widget_ref (servernameentry);
  if (the_server)
    gtk_entry_set_text (GTK_ENTRY (servernameentry), (the_server->get_Server_Name().c_str()));
  else
    gtk_entry_set_text (GTK_ENTRY (servernameentry), "");
  gtk_object_set_data_full (GTK_OBJECT (serverconfig), "servernameentry", servernameentry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (servernameentry);
  gtk_table_attach (GTK_TABLE (table1), servernameentry, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  hbox5 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox5);
  gtk_object_set_data_full (GTK_OBJECT (serverconfig), "hbox5", hbox5,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox5);
  gtk_table_attach (GTK_TABLE (table1), hbox5, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  serverimapentry = gtk_entry_new ();
  gtk_widget_ref (serverimapentry);
  if (the_server)
    gtk_entry_set_text (GTK_ENTRY (serverimapentry), (the_server->get_IMAP_Server_Name().c_str()));
  else
    gtk_entry_set_text (GTK_ENTRY (serverimapentry), "");
  gtk_object_set_data_full (GTK_OBJECT (serverconfig), "serverimapentry", serverimapentry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (serverimapentry);
  gtk_box_pack_start (GTK_BOX (hbox5), serverimapentry, TRUE, TRUE, 0);

  hbox6 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox6);
  gtk_object_set_data_full (GTK_OBJECT (serverconfig), "hbox6", hbox6,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox6);
  gtk_box_pack_start (GTK_BOX (hbox5), hbox6, TRUE, TRUE, 0);

  label14 = gtk_label_new (_("Port:"));
  gtk_widget_ref (label14);
  gtk_object_set_data_full (GTK_OBJECT (serverconfig), "label14", label14,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label14);
  gtk_box_pack_start (GTK_BOX (hbox6), label14, FALSE, FALSE, 0);

  serverimapportentry = gtk_entry_new_with_max_length (5);
  gtk_widget_ref (serverimapportentry);
  gtk_object_set_data_full (GTK_OBJECT (serverconfig), "serverimapportentry", serverimapportentry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (serverimapportentry);
  gtk_box_pack_end (GTK_BOX (hbox6), serverimapportentry, TRUE, TRUE, 0);
  gtk_widget_set_usize (serverimapportentry, 69, -2);
  if (the_server) 
    gtk_entry_set_text (GTK_ENTRY (serverimapportentry), (itoa(the_server->get_Port_Number())).c_str());
  else
    gtk_entry_set_text (GTK_ENTRY (serverimapportentry), ("143"));


  sslhbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (sslhbox);
  gtk_object_set_data_full (GTK_OBJECT (serverconfig), "sslhbox", sslhbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (sslhbox);
  gtk_table_attach (GTK_TABLE (table1), sslhbox, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);


  serverusernameentry = gtk_entry_new ();
  gtk_widget_ref (serverusernameentry);
  if (the_server)
    gtk_entry_set_text (GTK_ENTRY (serverusernameentry), (the_server->get_Username().c_str()));
  else
    gtk_entry_set_text (GTK_ENTRY (serverusernameentry), "");
  
  gtk_object_set_data_full (GTK_OBJECT (serverconfig), "serverusernameentry", serverusernameentry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (serverusernameentry);
  gtk_box_pack_start (GTK_BOX (sslhbox), serverusernameentry, FALSE, FALSE, 0);
  //  gtk_table_attach (GTK_TABLE (table1), serverusernameentry, 1, 2, 2, 3,
  //                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
  //                    (GtkAttachOptions) (0), 0, 0);
  // added by Ethan for ssl
  usessl = gtk_check_button_new_with_label (_("Use SSL"));
  if (the_server)
       gtk_toggle_button_set_active(&GTK_CHECK_BUTTON(usessl)->toggle_button,the_server->get_Use_SSL());
  else
       gtk_toggle_button_set_active(&GTK_CHECK_BUTTON(usessl)->toggle_button,0);
  gtk_widget_ref (usessl);
  gtk_object_set_data_full (GTK_OBJECT (serverconfig), "usessl", usessl,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (usessl);
  gtk_box_pack_start (GTK_BOX (sslhbox), usessl, FALSE, FALSE, 0);
  //end add



  hbox7 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox7);
  gtk_object_set_data_full (GTK_OBJECT (serverconfig), "hbox7", hbox7,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox7);
  gtk_table_attach (GTK_TABLE (table1), hbox7, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  serverpasswordentry = gtk_entry_new ();
  gtk_widget_ref (serverpasswordentry);
  if (the_server)
    gtk_entry_set_text (GTK_ENTRY (serverpasswordentry), (the_server->get_Password().c_str()));
  else
    gtk_entry_set_text (GTK_ENTRY (serverpasswordentry), "");
  gtk_object_set_data_full (GTK_OBJECT (serverconfig), "serverpasswordentry", serverpasswordentry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_box_pack_start (GTK_BOX (hbox7), serverpasswordentry, TRUE, TRUE, 0);
  gtk_entry_set_visibility (GTK_ENTRY (serverpasswordentry), FALSE);
  gtk_widget_show (serverpasswordentry);
  savepassword = gtk_check_button_new_with_label (_("Save Password"));
  if (the_server)
       gtk_toggle_button_set_active(&GTK_CHECK_BUTTON(savepassword)->toggle_button,the_server->get_Save_Password());
  else
       gtk_toggle_button_set_active(&GTK_CHECK_BUTTON(savepassword)->toggle_button,0);
  gtk_widget_ref (savepassword);
  gtk_object_set_data_full (GTK_OBJECT (serverconfig), "savepassword", savepassword,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (savepassword);
  gtk_box_pack_start (GTK_BOX (hbox7), savepassword, FALSE, FALSE, 0);

  serverfolderrootentry = gtk_entry_new ();
  gtk_widget_ref (serverfolderrootentry);
  if (the_server)
    gtk_entry_set_text (GTK_ENTRY (serverfolderrootentry), (the_server->get_Folder_Root().c_str()));
  else
    gtk_entry_set_text (GTK_ENTRY (serverfolderrootentry), ("~/mail"));    
  gtk_object_set_data_full (GTK_OBJECT (serverconfig), "serverfolderrootentry", serverfolderrootentry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (serverfolderrootentry);
  gtk_table_attach (GTK_TABLE (table1), serverfolderrootentry, 1, 2, 4, 5,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  serversmtpserverentry = gtk_entry_new ();
  gtk_widget_ref (serversmtpserverentry);
  gtk_object_set_data_full (GTK_OBJECT (serverconfig), "serversmtpserverentry", serversmtpserverentry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (serversmtpserverentry);
  if (the_server)
    gtk_entry_set_text (GTK_ENTRY (serversmtpserverentry), (the_server->get_SMTP_Server_Name().c_str()));
  else
    gtk_entry_set_text (GTK_ENTRY (serversmtpserverentry), "");
  gtk_table_attach (GTK_TABLE (table1), serversmtpserverentry, 1, 2, 5, 6,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  serverfccfolderentry = gtk_entry_new ();
  gtk_widget_ref (serverfccfolderentry);
  if (the_server)
    gtk_entry_set_text (GTK_ENTRY (serverfccfolderentry), (the_server->get_FCC_Folder().c_str()));
  else
    gtk_entry_set_text (GTK_ENTRY (serverfccfolderentry), ("sent-mail"));
  gtk_object_set_data_full (GTK_OBJECT (serverconfig), "serverfccfolderentry", serverfccfolderentry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (serverfccfolderentry);
  gtk_table_attach (GTK_TABLE (table1), serverfccfolderentry, 1, 2, 6, 7,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  label15 = gtk_label_new (_("E-Mail Address:"));
  gtk_widget_ref (label15);
  gtk_object_set_data_full (GTK_OBJECT (serverconfig), "label15", label15,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label15);
  gtk_table_attach (GTK_TABLE (table1), label15, 0, 1, 7, 8,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label15), 0, 0.5);

  emailaddressentry = gtk_entry_new ();
  gtk_widget_ref (emailaddressentry);
  if (the_server)
    gtk_entry_set_text (GTK_ENTRY (emailaddressentry), (the_server->get_EMail_Address().c_str()));
  else
    gtk_entry_set_text (GTK_ENTRY (emailaddressentry), (""));
  gtk_object_set_data_full (GTK_OBJECT (serverconfig), "emailaddressentry", emailaddressentry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (emailaddressentry);
  gtk_table_attach (GTK_TABLE (table1), emailaddressentry, 1, 2, 7, 8,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  hbox4 = gtk_hbox_new (TRUE, 0);
  gtk_widget_ref (hbox4);
  gtk_object_set_data_full (GTK_OBJECT (serverconfig), "hbox4", hbox4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox4);
  gtk_box_pack_start (GTK_BOX (vbox4), hbox4, FALSE, FALSE, 0);
  serverok = gtk_button_new_with_label (_("OK"));
  gtk_widget_ref (serverok);
  gtk_object_set_data_full (GTK_OBJECT (serverconfig), "serverok", serverok,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (serverok);
  gtk_box_pack_start (GTK_BOX (hbox4), serverok, FALSE, FALSE, 0);

  servercancel =  gtk_button_new_with_label (_("Cancel"));
  gtk_widget_ref (servercancel);
  gtk_object_set_data_full (GTK_OBJECT (serverconfig), "servercancel", servercancel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (servercancel);
  gtk_box_pack_start (GTK_BOX (hbox4), servercancel, FALSE, FALSE, 0);

  // The ok button sends the data to another function
  server_text_widgets *temp = new server_text_widgets;
  temp->name = GTK_ENTRY (servernameentry);
  temp->imapserver = GTK_ENTRY (serverimapentry);
  temp->imapport = GTK_ENTRY (serverimapportentry);
  temp->username = GTK_ENTRY (serverusernameentry);
  temp->password = GTK_ENTRY (serverpasswordentry);
  temp->folderroot = GTK_ENTRY (serverfolderrootentry);
  temp->smtpserver = GTK_ENTRY (serversmtpserverentry);
  temp->sentmailfolder = GTK_ENTRY (serverfccfolderentry);
  temp->email = GTK_ENTRY (emailaddressentry);
  temp->savepassword = GTK_CHECK_BUTTON (savepassword);
  temp->usessl = GTK_CHECK_BUTTON (usessl);



  gtk_signal_connect (GTK_OBJECT (serverok), "clicked",
                      GTK_SIGNAL_FUNC (on_serverok_clicked),
                      temp);
  gtk_signal_connect (GTK_OBJECT (servercancel), "clicked",
                      GTK_SIGNAL_FUNC (on_servercancel_clicked),
                      NULL);
  gtk_signal_connect_object( GTK_OBJECT (serverok), "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     GTK_OBJECT (serverconfig) );
  gtk_signal_connect_object( GTK_OBJECT (servercancel), "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     GTK_OBJECT (serverconfig) );
  return serverconfig;
}

GtkWidget*
create_filterconfig (void)
{
  GtkWidget *filterconfig;
  GtkWidget *vbox6;
  GtkWidget *table2;
  // GtkWidget *label16;
  GtkWidget *label17;
  GtkWidget *label18;
  GtkWidget *label19;

  GtkWidget *filterfieldcombo;
  /*  GtkWidget *optionmenu1;
      GtkWidget *optionmenu1_menu;*/
  //GtkWidget *glade_menuitem;
  // GtkWidget *filternameentry;
  GtkWidget *filterstringentry;
  GtkWidget *filterfolderentry;
  GtkWidget *hbox8;
  GtkWidget *filterok;
  GtkWidget *filtercancel;


  Filter *the_filter = gAlthea_config.get_Config_Current_Filter();




  filterconfig = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (filterconfig), "filterconfig", filterconfig);
  gtk_window_set_title (GTK_WINDOW (filterconfig), ("Althea - Filter Configuration"));

  vbox6 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox6);
  gtk_object_set_data_full (GTK_OBJECT (filterconfig), "vbox6", vbox6,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox6);
  gtk_container_add (GTK_CONTAINER (filterconfig), vbox6);

  table2 = gtk_table_new (4, 2, FALSE);
  gtk_widget_ref (table2);
  gtk_object_set_data_full (GTK_OBJECT (filterconfig), "table2", table2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table2);
  gtk_box_pack_start (GTK_BOX (vbox6), table2, TRUE, TRUE, 0);

  /*  label16 = gtk_label_new (_("Name:"));
  gtk_widget_ref (label16);
  gtk_object_set_data_full (GTK_OBJECT (filterconfig), "label16", label16,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label16);
  gtk_table_attach (GTK_TABLE (table2), label16, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label16), 0, 0.5);
  */
  label17 = gtk_label_new (_("Field:"));
  gtk_widget_ref (label17);
  gtk_object_set_data_full (GTK_OBJECT (filterconfig), "label17", label17,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label17);
  gtk_table_attach (GTK_TABLE (table2), label17, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label17), 0, 0.5);

  label18 = gtk_label_new (_("Filter String:"));
  gtk_widget_ref (label18);
  gtk_object_set_data_full (GTK_OBJECT (filterconfig), "label18", label18,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label18);
  gtk_table_attach (GTK_TABLE (table2), label18, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label18), 0, 0.5);
  




  label19 = gtk_label_new (_("Destination Folder:"));
  gtk_widget_ref (label19);
  gtk_object_set_data_full (GTK_OBJECT (filterconfig), "label19", label19,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label19);
  gtk_table_attach (GTK_TABLE (table2), label19, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label19), 0, 0.5);


  filterfieldcombo = gtk_combo_new();
  GList *cbitems;
  cbitems=NULL;
  cbitems=g_list_append(cbitems,_("From"));
  cbitems=g_list_append(cbitems,_("To"));
  cbitems=g_list_append(cbitems,_("Subject"));
  cbitems=g_list_append(cbitems,_("Body"));
  gtk_combo_set_popdown_strings(GTK_COMBO(filterfieldcombo),cbitems);
  gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(filterfieldcombo)->entry),FALSE);

  gtk_widget_ref(filterfieldcombo);
  gtk_widget_show(filterfieldcombo);
  gtk_table_attach (GTK_TABLE (table2), filterfieldcombo, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);


  /*  optionmenu1 = gtk_option_menu_new ();
  gtk_widget_ref (optionmenu1);
  gtk_object_set_data_full (GTK_OBJECT (filterconfig), "optionmenu1", optionmenu1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (optionmenu1);
  gtk_table_attach (GTK_TABLE (table2), optionmenu1, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  optionmenu1_menu = gtk_menu_new ();
  glade_menuitem = gtk_menu_item_new_with_label (_("From"));
  gtk_widget_show (glade_menuitem);
  gtk_menu_append (GTK_MENU (optionmenu1_menu), glade_menuitem);
  glade_menuitem = gtk_menu_item_new_with_label (_("To"));
  gtk_widget_show (glade_menuitem);
  gtk_menu_append (GTK_MENU (optionmenu1_menu), glade_menuitem);
  glade_menuitem = gtk_menu_item_new_with_label (_("Subject"));
  gtk_widget_show (glade_menuitem);
  gtk_menu_append (GTK_MENU (optionmenu1_menu), glade_menuitem);
  glade_menuitem = gtk_menu_item_new_with_label (_("Body"));
  gtk_widget_show (glade_menuitem);
  gtk_menu_append (GTK_MENU (optionmenu1_menu), glade_menuitem);
  gtk_option_menu_set_menu (GTK_OPTION_MENU (optionmenu1), optionmenu1_menu);
  
  */

  /*
    filternameentry = gtk_entry_new ();
    gtk_widget_ref (filternameentry);
    gtk_object_set_data_full (GTK_OBJECT (filterconfig), "filternameentry", filternameentry,
    (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (filternameentry);
    gtk_table_attach (GTK_TABLE (table2), filternameentry, 1, 2, 0, 1,
    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
    (GtkAttachOptions) (0), 0, 0);
    
  */

  filterstringentry = gtk_entry_new ();
  gtk_widget_ref (filterstringentry);
  gtk_object_set_data_full (GTK_OBJECT (filterconfig), "filterstringentry", filterstringentry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (filterstringentry);
  gtk_table_attach (GTK_TABLE (table2), filterstringentry, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  if (the_filter)
    gtk_entry_set_text (GTK_ENTRY (filterstringentry), (the_filter->filter_string.c_str()));
  else
    gtk_entry_set_text (GTK_ENTRY (filterstringentry), (""));



  filterfolderentry = gtk_entry_new ();
  gtk_widget_ref (filterfolderentry);
  gtk_object_set_data_full (GTK_OBJECT (filterconfig), "filterfolderentry", filterfolderentry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (filterfolderentry);
  gtk_table_attach (GTK_TABLE (table2), filterfolderentry, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  if (the_filter)
    gtk_entry_set_text (GTK_ENTRY (filterfolderentry), (the_filter->folder.c_str()));
  else
    gtk_entry_set_text (GTK_ENTRY (filterfolderentry), (""));





  hbox8 = gtk_hbox_new (TRUE, 0);
  gtk_widget_ref (hbox8);
  gtk_object_set_data_full (GTK_OBJECT (filterconfig), "hbox8", hbox8,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox8);
  gtk_box_pack_start (GTK_BOX (vbox6), hbox8, FALSE, TRUE, 0);

  filterok =  gtk_button_new_with_label (_("OK"));
  gtk_widget_ref (filterok);
  gtk_object_set_data_full (GTK_OBJECT (filterconfig), "filterok", filterok,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (filterok);
  gtk_box_pack_start (GTK_BOX (hbox8), filterok, FALSE, FALSE, 0);

  filtercancel =  gtk_button_new_with_label (_("Cancel"));
  gtk_widget_ref (filtercancel);
  gtk_object_set_data_full (GTK_OBJECT (filterconfig), "filtercancel", filtercancel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (filtercancel);
  gtk_box_pack_start (GTK_BOX (hbox8), filtercancel, FALSE, FALSE, 0);




  filter_text_widgets *temp = new filter_text_widgets;
  temp->filter_string = GTK_ENTRY (filterstringentry);
  temp->folder = GTK_ENTRY (filterfolderentry);
  temp->filter_field = GTK_ENTRY(GTK_COMBO(filterfieldcombo)->entry);




  gtk_signal_connect (GTK_OBJECT (filterok), "clicked",
                      GTK_SIGNAL_FUNC (on_filterok_clicked),
                      temp);
  gtk_signal_connect (GTK_OBJECT (filtercancel), "clicked",
                      GTK_SIGNAL_FUNC (on_filtercancel_clicked),
                      NULL);







  return filterconfig;
}

