/***************************************************************************/
/* 		This code is part of WWW graber called pavuk		   */
/*		Copyright (c) 1997,1998,1999 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <netdb.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <ctype.h>

#include "config.h"
#include "url.h"
#include "http.h"
#include "net.h"
#include "doc.h"
#include "errcode.h"
#include "abstract.h"

/********************************************************/
/* otvori spojenie na gopher server pre dane gopher URL	*/
/********************************************************/
bufio *gopher_get_data_socket(docp)
doc *docp;
{
	char pom[2048];
	char *host;
	int port;

	if (cfg.gopher_proxy)
	{
		host = cfg.gopher_proxy;
		port = cfg.gopher_proxy_port;
	}
	else
	{
		host = docp->doc_url->p.gopher.host;
		port = docp->doc_url->p.gopher.port;
	}

	docp->datasock = bufio_fdopen(net_connect(host , port));

	if (docp->datasock)
	{
		if (cfg.gopher_proxy)
		{
			if (http_dumy_proxy_connect(docp, 
				url_get_site(docp->doc_url) , 
				url_get_port(docp->doc_url)))
			{
				docp->errcode = ERR_PROXY_CONNECT;
				shutdown(bufio_getfd(docp->datasock) , 2);
				bufio_close(docp->datasock);
				docp->datasock = NULL;
				return NULL;
			}
		}

		sprintf(pom , "%s\r\n" , docp->doc_url->p.gopher.selector+1);
		abs_write(docp, docp->datasock , pom , strlen(pom));
		DEBUG_PROTOC(gettext("********************* Gopher request **************\n"));
		DEBUG_PROTOC("%s" , pom);
		DEBUG_PROTOC("***************************************************\n");
	}
	else
	{
		docp->errcode = ERR_GOPHER_CONNECT;
		if (h_errno)
			xherror(host);
		else
			xperror("net_connect");
	}


	return docp->datasock;
}

/********************************************************/
/* z gopher adresara urobi HTML dokument		*/
/********************************************************/
void gopher_dir_to_html(docp)
doc *docp;
{
	char *p,*res = NULL;
	char pom[8192];
	int tsize,s;
	char tp;
	char *title;
	char *host;
	char *sel;
	int port;
	int ilen;
	bool last = 1;

	if (docp->doc_url->p.gopher.selector[0] != '1') return;

	sprintf(pom , gettext("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\">\n\
<HTML>\n<TITLE>\nDirectory of gopher://%s:%d/%s\n</TITLE>\n<BODY>\n<H1 ALIGN=CENTER><B>\
Directory of gopher://%s:%d/%s </H1><BR><BR><UL>") ,
docp->doc_url->p.gopher.host , docp->doc_url->p.gopher.port ,
docp->doc_url->p.gopher.selector ,
docp->doc_url->p.gopher.host , docp->doc_url->p.gopher.port ,
docp->doc_url->p.gopher.selector);

	res = new_string(pom);
	tsize = strlen(pom);

	p = docp->contents;

	while (*p)
	{
		ilen = strcspn(p , "\r\n");
		if (*(p+ilen)) *(p+ilen) = '\0';
		else last = 0;

		if (*p == '.') break;

		s = strlen(p);

		title = strtokc(p, '\t');
		tp = *title;
		title++;

		sel = strtokc(NULL , '\t');
		host = strtokc(NULL , '\t');
		port = _atoi(strtokc(NULL , '\t'));

		sprintf(pom , 
			"<LI><A HREF=\"gopher://%s:%c%d/%s\">&quot;%s&quot;</A></LI>\n" ,
			host , port , tp , sel , title);

		tsize += strlen(pom);
		res = _realloc(res , tsize + 1);

		strcat(res , pom);
		p += ilen+last;
		p += strspn(p , "\r\n");
	}
	
	tsize += 22;
	res = _realloc(res , tsize + 1);

	strcat(res , "</UL>\n</BODY>\n</HTML>\n");

	free(docp->contents);

	docp->contents = res;
	docp->size = tsize;
}
