/***************************************************************************/
/* 	This code is part of X-toolkit widget library called Nws 	   */
/*	Copyright (c) 1997,1998,1999 Ondrejicka Stefan			   */
/*	(ondrej@idata.sk)						   */
/*	Distributed under GPL 2 or later				   */
/***************************************************************************/

#ifndef _TreeList_H_
#define _TreeList_H_

#include <Nws/Base.h>
#include <Nws/cvt.h>


typedef struct _TreeListClassRec	*TreeListWidgetClass;
typedef struct _TreeListRec		*TreeListWidget;

extern WidgetClass treeListWidgetClass;

typedef struct {
	long	id;
	char	*label;
	Icon	*icon;
	void	*related_info;
} TreeListItem;

typedef struct _TreeList {
	struct _TreeList	*parent;
	struct _TreeList	*first_child;
	struct _TreeList	*neighbour;
	TreeListItem		*item;
	int			level;
	Boolean			expand_children;
	int			x;
	int			y;
	unsigned short		width;
	unsigned short		height;
	Boolean			activated;
	Boolean			managed;
	Boolean			sensitive;
} TreeList;

#ifndef XtNfont
#define XtNfont		"font"
#endif
#ifndef XtCFont
#define XtCFont		"Font"
#endif

#ifndef XtNtree_line_color
#define XtNtree_line_color	"tree_line_color"
#endif
#ifndef XtCTree_line_color
#define XtCTree_line_color	"Tree_line_color"
#endif

#ifndef XtNspacing
#define XtNspacing      "spacing"
#endif
#ifndef XtCSpacing
#define XtCSpacing      "Spacing"
#endif

#ifndef XtNselect_cb
#define XtNselect_cb    "select_cb"
#endif
#ifndef XtCSelect_cb
#define XtCSelect_cb    "Select_cb"
#endif

#ifndef XtNselect_changed_cb
#define XtNselect_changed_cb    "select_changed_cb"
#endif
#ifndef XtCSelect_changed_cb
#define XtCSelect_changed_cb    "Select_changed_cb"
#endif

#ifndef XtNselected_fg
#define XtNselected_fg  "selected_fg"
#endif
#ifndef XtCSelected_fg
#define XtCSelected_fg  "Selected_fg"
#endif

#ifndef XtNselected_bg
#define XtNselected_bg  "selected_bg"
#endif
#ifndef XtCSelected_bg
#define XtCSelected_bg  "Selected_bg"
#endif

#ifndef XtNsection_distance
#define XtNsection_distance	"section_distance"
#endif
#ifndef XtCSection_distance
#define XtCSection_distance	"Section_distance"
#endif

#ifndef XtNdo_layout
#define XtNdo_layout	"do_layout"
#endif
#ifndef XtCDo_layout
#define XtCDo_layout	"Do_layout"
#endif

#ifndef XtNdelete_subtree_on_close
#define XtNdelete_subtree_on_close	"delete_subtree_on_close"
#endif
#ifndef XtCDelete_subtree_on_close
#define XtCDelete_subtree_on_close	"Delete_subtree_on_close"
#endif

#ifndef XtNrestore_state_on_open
#define XtNrestore_state_on_open	"restore_state_on_open"
#endif
#ifndef XtCRestore_state_on_open
#define XtCRestore_state_on_open	"Restore_state_on_open"
#endif

#ifndef XtNdirect_draw
#define XtNdirect_draw			"direct_draw"
#endif
#ifndef XtCDirect_draw
#define XtCDirect_draw			"Direct_draw"
#endif

extern  void 		TreeListItemSetIcon();
extern  void 		TreeListItemSetSensitive();
extern	TreeList * 	TreeListGetItemParent();
extern	TreeList * 	TreeListGetSelectedItem();
extern	void 		TreeListDeleteItem();
extern  TreeList *	TreeListGetItemByID();
extern  TreeList *	TreeListInsertItem();
extern  void		TreeListFreeSubTree();
extern  TreeList *      TreeListSetNewRoot();
extern void TreeListDontDoLayout();
extern void TreeListDoLayout();
#endif
