/***************************************************************************/
/* 	This code is part of X-toolkit widget library called Nws 	   */
/*	Copyright (c) 1997,1998,1999 Ondrejicka Stefan			   */
/*	(ondrej@idata.sk)						   */
/*	Distributed under GPL 2 or later				   */
/***************************************************************************/

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <stdio.h>

#include	"MenuBarP.h"
#include	"Init.h"
#define HIDE_PROTO 1
#include	"MBButtonP.h"
#undef HIDE_PROTO 

static XtResource menuBarConstraintsResources [] = {
        {
         XtNleft_space ,
         XtCLeft_space ,
         XtRInt ,
         sizeof(int) ,
         XtOffsetOf(MenuBarConstraintsRec , row.left_space) ,
         XtRImmediate ,
         (XtPointer) 0
        },
        {
         XtNright_space ,
         XtCRight_space ,
         XtRInt ,
         sizeof(int) ,
         XtOffsetOf(MenuBarConstraintsRec , row.right_space) ,
         XtRImmediate ,
         (XtPointer) 0
        },
};

#define offset(field) XtOffsetOf(MenuBarRec, menuBar.field)

static void ClassInitialize();
static void Initialize ();
static void ResolveInheritance ();
static void Redisplay();

static void DispatchEvent ();
static void GetPositionEntry ();

static void Unactivate();
MenuBarClassRec menuBarClassRec = {
/* core */
   {
    /* superclass            */ (WidgetClass) &rowClassRec,
    /* class_name            */ "MenuBar",
    /* widget_size           */ sizeof(MenuBarRec),
    /* class_initialize      */ ClassInitialize,
    /* class_part_initialize */ ResolveInheritance,
    /* class_inited          */ FALSE,
    /* initialize            */ Initialize,
    /* initialize_hook       */ NULL,
    /* realize               */ XtInheritRealize,
    /* actions               */ NULL,
    /* num_actions           */ 0,
    /* resources             */ NULL,
    /* num_resources         */ 0,
    /* xrm_class             */ NULLQUARK,
    /* compress_motion       */ False,
    /* compress_exposure     */ True,
    /* compress_enterleave   */ True,
    /* visible_interest      */ FALSE,
    /* destroy               */ NULL,
    /* resize                */ XtInheritResize,
    /* expose                */ Redisplay,
    /* set_values            */ NULL,
    /* set_values_hook       */ NULL,
    /* set_values_almost     */ XtInheritSetValuesAlmost,
    /* get_values_hook       */ NULL,
    /* accept_focus          */ XtInheritAcceptFocus,
    /* version               */ XtVersion,
    /* callback_private      */ NULL,
    /* tm_table              */ NULL,
    /* query_geometry        */ XtInheritQueryGeometry,
    /* display_accelerator   */ XtInheritDisplayAccelerator,
    /* extension             */ NULL
   },
/* composite */
   {
    /* geometry_manager	     */ XtInheritGeometryManager,
    /* change_managed	     */ XtInheritChangeManaged,
    /* insert_child	     */ XtInheritInsertChild,
    /* delete_child	     */ XtInheritDeleteChild,
    /* extension	     */ NULL
   },
   {
/* constraint */
    /* subresourses       */   menuBarConstraintsResources ,
    /* subresource_count  */   XtNumber(menuBarConstraintsResources) ,
    /* constraint_size    */   sizeof(MenuBarConstraintsRec),
    /* initialize         */   NULL,
    /* destroy            */   NULL,
    /* set_values         */   NULL,
    /* extension          */   NULL
   },
/* baseConst */
   {
    /* get_internal_dimension  */ XtInheritGetInternalDimension,
    /* set_internal_dimension  */ XtInheritSetInternalDimension,
    /* traverse		       */ XtInheritTraverse,
    /* traverseTo              */ XtInheritTraverseTo,
    /* traverseOut	       */ XtInheritTraverseOut,
    /* traverseInside          */ XtInheritTraverseInside,
    /* highlightBorder         */ XtInheritHighlightBorder,
    /* unhighlightBorder       */ XtInheritUnhighlightBorder,
   },
/* row */
   {
    /* empty		       */ 0
   },
/* menuBar */
   {
    /* unactivate	       */ Unactivate
   },
};

WidgetClass menuBarWidgetClass = (WidgetClass) & menuBarClassRec;

#define ForAllChildren(cw, childP) \
	for ( (childP) = (BaseMEObject *) (cw)->composite.children ; \
		(childP) < (BaseMEObject *) ((cw)->composite.children + \
		(cw)->composite.num_children ) ; \
		(childP)++ )


static void ClassInitialize()
{
	_InitializeWidgetSet();
}

static void ResolveInheritance(class)
WidgetClass class;
{
        MenuBarWidgetClass c = (MenuBarWidgetClass) class;
        MenuBarWidgetClass super;
        static CompositeClassExtensionRec extension_rec = {
                NULL, NULLQUARK, XtCompositeExtensionVersion,
                sizeof(CompositeClassExtensionRec), True };
        CompositeClassExtensionRec *ext;

        ext = (XtPointer)XtMalloc(sizeof(*ext));
        *ext = extension_rec;
        ext->next_extension = c->composite_class.extension;
        c->composite_class.extension = ext;

	if (class == menuBarWidgetClass) return;

	super = (MenuBarWidgetClass)class->core_class.superclass;

	if (c->menuBar_class.unactivate == XtInheritUnactivate)
                c->menuBar_class.unactivate =
                        super->menuBar_class.unactivate;


}

static void Initialize(req_widget,new_widget,args,num_args)
Widget req_widget;
Widget new_widget;
ArgList args;
Cardinal *num_args;
{
	MenuBarWidget nw = (MenuBarWidget) new_widget;

	nw->menuBar.is_activated = False;
	nw->menuBar.do_popdown = False;
	nw->menuBar.have_grab = False;

	XtAddEventHandler(new_widget ,   ButtonPressMask | 
                ButtonMotionMask | PointerMotionMask,
                True , DispatchEvent , (XtPointer)NULL);

}

static void Redisplay(w,event,region)
Widget w;
XEvent * event;
Region  region;
{
	MenuBarWidget cw = (MenuBarWidget) w;
        BaseMEObject * entry;   
        BaseMEObjectClass class;

        if (region == NULL) XClearWindow(XtDisplay(w) , XtWindow(w));

	rowClassRec.core_class.expose(w,event,region);

        ForAllChildren(cw, entry)
        {
                if (!XtIsManaged ( (Widget) *entry)) continue;

                if (region != NULL) 
                        switch(XRectInRegion(region , (*entry)->rectangle.x,
                                (*entry)->rectangle.y , (*entry)->rectangle.width ,
                                (*entry)->rectangle.height)) 
                        {

                                case RectangleIn:
                                case RectanglePart:
                                        break;
                                default:
                                        continue;
                        }
                class = (BaseMEObjectClass) (*entry)->object.widget_class;

                if (class->rect_class.expose != NULL)
                        (class->rect_class.expose)( (Widget) *entry, NULL, NULL);
        }

}

/* volane ak je menu zrusene 
 treba osetrit flag 'do_popdown' ktory zisti ci menu zrusil 
 menuBar alebo bolo zrusene z ineho dovodu
 metoda je volana z MBButton !!!!!!!!!!!!!!!!!!!!!!!!
 */
 
static void Unactivate(w)
Widget w;
{
	MenuBarWidget cw = (MenuBarWidget) w;

	if (cw->menuBar.is_activated && !cw->menuBar.do_popdown)
	{
		cw->menuBar.is_activated = False;
		cw->menuBar.last_activated = NULL;
	}
}

static void DispatchEvent(w , client_data , event , ctd)
Widget w;
XtPointer client_data;
XEvent *event;
Boolean * ctd;
{
	MenuBarWidget cw = (MenuBarWidget) w;
	MBButtonObject *entry =  NULL;
	MBButtonObjectClass class;

	switch(event->type)
	{
		case ButtonPress:
			if (cw->menuBar.is_activated)
			{
				if (cw->menuBar.last_activated)
				{
					class = (MBButtonObjectClass)
						((MBButtonObject)
						*cw->menuBar.last_activated)
						->object.widget_class;


					if (class->mBButton_class.popdown_menu)
						class->mBButton_class.
						popdown_menu((Widget) 
						*cw->menuBar.last_activated);

				}

				cw->menuBar.is_activated = False;
				cw->menuBar.last_activated = NULL;

				return;
			}

			GetPositionEntry(w , event->xbutton.x , event->xbutton.y ,
				event , &entry);

			if (entry)
			{
				class = (MBButtonObjectClass)
					(*entry)->object.widget_class;

				if (class->baseME_class.activate)
					class->baseME_class.activate((Widget) *entry);


				if ((*entry)->mBButton.menu)
				{
					XtAddGrab(w,False,False);
					cw->menuBar.is_activated = True;
				}
			}
			cw->menuBar.last_activated = (Widget *) entry;
			break;

		case MotionNotify:
			if (!cw->menuBar.is_activated) return;

			GetPositionEntry(w , event->xmotion.x , event->xmotion.y ,
				event , &entry);

			if (entry)
			{
				if (cw->menuBar.last_activated &&
				   cw->menuBar.last_activated != (Widget *) entry)
				{
					class = (MBButtonObjectClass)
						((MBButtonObject)
						*cw->menuBar.last_activated)
						->object.widget_class;

					cw->menuBar.do_popdown = True;

					if (class->mBButton_class.popdown_menu)
						class->mBButton_class.
						popdown_menu((Widget) 
						*cw->menuBar.last_activated);

					cw->menuBar.do_popdown = False;

					cw->menuBar.last_activated = (Widget *) entry;

					class = (MBButtonObjectClass)
						(*entry)->object.widget_class;

					if (class->baseME_class.activate)
						class->baseME_class.activate((Widget) 
						*entry);

					if ((*entry)->mBButton.menu)
					{
						XtAddGrab(w,False,False);
					}
				}
			}
			break;
		default:
			printf("unsupported event type\n");
	}
}

static void GetPositionEntry(w , x , y , event , entry )
Widget w;
int x;
int y;
XEvent *event;
BaseMEObject **entry;
{
        MenuBarWidget cw = (MenuBarWidget) w;
        BaseMEObject * pentry;
        Position pomx , pomy;
        Dimension width , height;

        if (XtWindow(w) != event->xany.window) return;

        menuBarClassRec.baseConst_class.get_internal_dimension(w , &pomx , &pomy , 
                &width , &height);

        if ((x < pomx) || (x > pomx + width) || (y < pomy) || (y > pomy + height)) return;
        
        ForAllChildren(cw , pentry)
        {
                if (!XtIsManaged ((Widget) *pentry)) continue;

                if ( ( (*pentry)->rectangle.x <= x) && (( (*pentry)->rectangle.x +
                        (int) (*pentry)->rectangle.width) >= x) 
                        && (*pentry)->rectangle.sensitive)
                {
                        *entry = pentry;
                        return;
                }
                        
                        
        }

}
