#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 name["english"] = "uploader.exe";
 name["francais"] = "uploader.exe";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "The 'uploader.exe' cgi is installed. This CGI has
a well known security flaw that lets anyone upload arbitrary
CGI on the server, and then execute them.

Solution : remove it from /cgi-win.

Risk factor : Serious";


 desc["francais"] = "Le cgi 'uploader.exe' est install. Celui-ci possde
un problme de scurit bien connu qui permet  n'importe qui
d'uploader des CGI arbitraires puis de les executer.

Solution : retirez-le de /cgi-win.

Facteur de risque : Srieux";


 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Checks for the presence of /cgi-win/uploader.exe";
 summary["francais"] = "Vrifie la prsence de /cgi-win/uploader.exe";
 
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_ATTACK);
 
 
 script_copyright(english:"This script is Copyright (C) 1999 Renaud Deraison",
		francais:"Ce script est Copyright (C) 1999 Renaud Deraison");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

cgi = "/cgi-win/uploader.exe";
if(is_cgi_installed(cgi))
{
 port = get_kb_item("Services/www");
 if(!port)port = 80;
 security_hole(port);
}
