// GENERATED FILE - DO NOT EDIT.
// Generated by gen_builtin_symbols.py using data from builtin_function_declarations.txt.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// ImmutableString_test_ESSL_autogen.cpp:
//   Tests for matching script-generated hashes with runtime computed hashes.

#include "compiler/translator/ImmutableString.h"
#include "gtest/gtest.h"

namespace sh
{

TEST(ImmutableStringTest, ScriptGeneratedHashesMatch)
{
    ASSERT_EQ(0x00000110u, ImmutableString("radians(00B").mangledNameHash());
    ASSERT_EQ(0x0000008fu, ImmutableString("radians(10B").mangledNameHash());
    ASSERT_EQ(0x0000020eu, ImmutableString("radians(20B").mangledNameHash());
    ASSERT_EQ(0x0000019au, ImmutableString("radians(30B").mangledNameHash());
    ASSERT_EQ(0x0000057au, ImmutableString("degrees(00B").mangledNameHash());
    ASSERT_EQ(0x00000603u, ImmutableString("degrees(10B").mangledNameHash());
    ASSERT_EQ(0x000000c2u, ImmutableString("degrees(20B").mangledNameHash());
    ASSERT_EQ(0x00000099u, ImmutableString("degrees(30B").mangledNameHash());
    ASSERT_EQ(0x00000480u, ImmutableString("sin(00B").mangledNameHash());
    ASSERT_EQ(0x000003f9u, ImmutableString("sin(10B").mangledNameHash());
    ASSERT_EQ(0x000005c6u, ImmutableString("sin(20B").mangledNameHash());
    ASSERT_EQ(0x00000073u, ImmutableString("sin(30B").mangledNameHash());
    ASSERT_EQ(0x00000596u, ImmutableString("cos(00B").mangledNameHash());
    ASSERT_EQ(0x00000175u, ImmutableString("cos(10B").mangledNameHash());
    ASSERT_EQ(0x00000631u, ImmutableString("cos(20B").mangledNameHash());
    ASSERT_EQ(0x0000006eu, ImmutableString("cos(30B").mangledNameHash());
    ASSERT_EQ(0x00000592u, ImmutableString("tan(00B").mangledNameHash());
    ASSERT_EQ(0x00000612u, ImmutableString("tan(10B").mangledNameHash());
    ASSERT_EQ(0x00000323u, ImmutableString("tan(20B").mangledNameHash());
    ASSERT_EQ(0x00000513u, ImmutableString("tan(30B").mangledNameHash());
    ASSERT_EQ(0x000000f9u, ImmutableString("asin(00B").mangledNameHash());
    ASSERT_EQ(0x0000018au, ImmutableString("asin(10B").mangledNameHash());
    ASSERT_EQ(0x000004bbu, ImmutableString("asin(20B").mangledNameHash());
    ASSERT_EQ(0x00000532u, ImmutableString("asin(30B").mangledNameHash());
    ASSERT_EQ(0x000001ccu, ImmutableString("acos(00B").mangledNameHash());
    ASSERT_EQ(0x0000013eu, ImmutableString("acos(10B").mangledNameHash());
    ASSERT_EQ(0x00000432u, ImmutableString("acos(20B").mangledNameHash());
    ASSERT_EQ(0x000003b7u, ImmutableString("acos(30B").mangledNameHash());
    ASSERT_EQ(0x00000588u, ImmutableString("atan(00B00B").mangledNameHash());
    ASSERT_EQ(0x00000017u, ImmutableString("atan(10B10B").mangledNameHash());
    ASSERT_EQ(0x000003eau, ImmutableString("atan(20B20B").mangledNameHash());
    ASSERT_EQ(0x000003a2u, ImmutableString("atan(30B30B").mangledNameHash());
    ASSERT_EQ(0x000000c9u, ImmutableString("atan(00B").mangledNameHash());
    ASSERT_EQ(0x000004e2u, ImmutableString("atan(10B").mangledNameHash());
    ASSERT_EQ(0x000001dcu, ImmutableString("atan(20B").mangledNameHash());
    ASSERT_EQ(0x0000015au, ImmutableString("atan(30B").mangledNameHash());
    ASSERT_EQ(0x0000029fu, ImmutableString("sinh(00B").mangledNameHash());
    ASSERT_EQ(0x00000606u, ImmutableString("sinh(10B").mangledNameHash());
    ASSERT_EQ(0x0000026du, ImmutableString("sinh(20B").mangledNameHash());
    ASSERT_EQ(0x00000204u, ImmutableString("sinh(30B").mangledNameHash());
    ASSERT_EQ(0x00000437u, ImmutableString("cosh(00B").mangledNameHash());
    ASSERT_EQ(0x000005f4u, ImmutableString("cosh(10B").mangledNameHash());
    ASSERT_EQ(0x00000167u, ImmutableString("cosh(20B").mangledNameHash());
    ASSERT_EQ(0x00000424u, ImmutableString("cosh(30B").mangledNameHash());
    ASSERT_EQ(0x000004d3u, ImmutableString("tanh(00B").mangledNameHash());
    ASSERT_EQ(0x00000547u, ImmutableString("tanh(10B").mangledNameHash());
    ASSERT_EQ(0x000005c5u, ImmutableString("tanh(20B").mangledNameHash());
    ASSERT_EQ(0x00000008u, ImmutableString("tanh(30B").mangledNameHash());
    ASSERT_EQ(0x000005bbu, ImmutableString("asinh(00B").mangledNameHash());
    ASSERT_EQ(0x00000635u, ImmutableString("asinh(10B").mangledNameHash());
    ASSERT_EQ(0x00000208u, ImmutableString("asinh(20B").mangledNameHash());
    ASSERT_EQ(0x00000271u, ImmutableString("asinh(30B").mangledNameHash());
    ASSERT_EQ(0x000000a2u, ImmutableString("acosh(00B").mangledNameHash());
    ASSERT_EQ(0x000004f9u, ImmutableString("acosh(10B").mangledNameHash());
    ASSERT_EQ(0x000001afu, ImmutableString("acosh(20B").mangledNameHash());
    ASSERT_EQ(0x0000012au, ImmutableString("acosh(30B").mangledNameHash());
    ASSERT_EQ(0x00000226u, ImmutableString("atanh(00B").mangledNameHash());
    ASSERT_EQ(0x000001b0u, ImmutableString("atanh(10B").mangledNameHash());
    ASSERT_EQ(0x00000451u, ImmutableString("atanh(20B").mangledNameHash());
    ASSERT_EQ(0x000003ceu, ImmutableString("atanh(30B").mangledNameHash());
    ASSERT_EQ(0x000003cau, ImmutableString("pow(00B00B").mangledNameHash());
    ASSERT_EQ(0x000001e0u, ImmutableString("pow(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000463u, ImmutableString("pow(20B20B").mangledNameHash());
    ASSERT_EQ(0x00000273u, ImmutableString("pow(30B30B").mangledNameHash());
    ASSERT_EQ(0x000002dfu, ImmutableString("exp(00B").mangledNameHash());
    ASSERT_EQ(0x00000355u, ImmutableString("exp(10B").mangledNameHash());
    ASSERT_EQ(0x0000009fu, ImmutableString("exp(20B").mangledNameHash());
    ASSERT_EQ(0x00000123u, ImmutableString("exp(30B").mangledNameHash());
    ASSERT_EQ(0x00000126u, ImmutableString("log(00B").mangledNameHash());
    ASSERT_EQ(0x000000a3u, ImmutableString("log(10B").mangledNameHash());
    ASSERT_EQ(0x00000221u, ImmutableString("log(20B").mangledNameHash());
    ASSERT_EQ(0x0000037bu, ImmutableString("log(30B").mangledNameHash());
    ASSERT_EQ(0x000004a6u, ImmutableString("exp2(00B").mangledNameHash());
    ASSERT_EQ(0x00000516u, ImmutableString("exp2(10B").mangledNameHash());
    ASSERT_EQ(0x000003abu, ImmutableString("exp2(20B").mangledNameHash());
    ASSERT_EQ(0x0000041du, ImmutableString("exp2(30B").mangledNameHash());
    ASSERT_EQ(0x00000546u, ImmutableString("log2(00B").mangledNameHash());
    ASSERT_EQ(0x000004e8u, ImmutableString("log2(10B").mangledNameHash());
    ASSERT_EQ(0x0000046du, ImmutableString("log2(20B").mangledNameHash());
    ASSERT_EQ(0x00000250u, ImmutableString("log2(30B").mangledNameHash());
    ASSERT_EQ(0x0000025du, ImmutableString("sqrt(00B").mangledNameHash());
    ASSERT_EQ(0x000001f0u, ImmutableString("sqrt(10B").mangledNameHash());
    ASSERT_EQ(0x00000359u, ImmutableString("sqrt(20B").mangledNameHash());
    ASSERT_EQ(0x000002deu, ImmutableString("sqrt(30B").mangledNameHash());
    ASSERT_EQ(0x0000002au, ImmutableString("inversesqrt(00B").mangledNameHash());
    ASSERT_EQ(0x000005e8u, ImmutableString("inversesqrt(10B").mangledNameHash());
    ASSERT_EQ(0x00000100u, ImmutableString("inversesqrt(20B").mangledNameHash());
    ASSERT_EQ(0x0000009au, ImmutableString("inversesqrt(30B").mangledNameHash());
    ASSERT_EQ(0x0000029bu, ImmutableString("abs(00B").mangledNameHash());
    ASSERT_EQ(0x00000233u, ImmutableString("abs(10B").mangledNameHash());
    ASSERT_EQ(0x000001c4u, ImmutableString("abs(20B").mangledNameHash());
    ASSERT_EQ(0x00000457u, ImmutableString("abs(30B").mangledNameHash());
    ASSERT_EQ(0x0000029au, ImmutableString("abs(00D").mangledNameHash());
    ASSERT_EQ(0x00000232u, ImmutableString("abs(10D").mangledNameHash());
    ASSERT_EQ(0x000001c3u, ImmutableString("abs(20D").mangledNameHash());
    ASSERT_EQ(0x000005e9u, ImmutableString("abs(30D").mangledNameHash());
    ASSERT_EQ(0x00000093u, ImmutableString("sign(00B").mangledNameHash());
    ASSERT_EQ(0x000004a0u, ImmutableString("sign(10B").mangledNameHash());
    ASSERT_EQ(0x00000042u, ImmutableString("sign(20B").mangledNameHash());
    ASSERT_EQ(0x000000acu, ImmutableString("sign(30B").mangledNameHash());
    ASSERT_EQ(0x0000043cu, ImmutableString("sign(00D").mangledNameHash());
    ASSERT_EQ(0x000005f7u, ImmutableString("sign(10D").mangledNameHash());
    ASSERT_EQ(0x00000043u, ImmutableString("sign(20D").mangledNameHash());
    ASSERT_EQ(0x000000adu, ImmutableString("sign(30D").mangledNameHash());
    ASSERT_EQ(0x00000324u, ImmutableString("floor(00B").mangledNameHash());
    ASSERT_EQ(0x00000567u, ImmutableString("floor(10B").mangledNameHash());
    ASSERT_EQ(0x00000405u, ImmutableString("floor(20B").mangledNameHash());
    ASSERT_EQ(0x00000392u, ImmutableString("floor(30B").mangledNameHash());
    ASSERT_EQ(0x0000050eu, ImmutableString("trunc(00B").mangledNameHash());
    ASSERT_EQ(0x00000499u, ImmutableString("trunc(10B").mangledNameHash());
    ASSERT_EQ(0x00000610u, ImmutableString("trunc(20B").mangledNameHash());
    ASSERT_EQ(0x0000058bu, ImmutableString("trunc(30B").mangledNameHash());
    ASSERT_EQ(0x00000060u, ImmutableString("round(00B").mangledNameHash());
    ASSERT_EQ(0x0000061bu, ImmutableString("round(10B").mangledNameHash());
    ASSERT_EQ(0x000002a7u, ImmutableString("round(20B").mangledNameHash());
    ASSERT_EQ(0x0000051cu, ImmutableString("round(30B").mangledNameHash());
    ASSERT_EQ(0x00000450u, ImmutableString("roundEven(00B").mangledNameHash());
    ASSERT_EQ(0x000003cdu, ImmutableString("roundEven(10B").mangledNameHash());
    ASSERT_EQ(0x00000225u, ImmutableString("roundEven(20B").mangledNameHash());
    ASSERT_EQ(0x000001aeu, ImmutableString("roundEven(30B").mangledNameHash());
    ASSERT_EQ(0x000005a8u, ImmutableString("ceil(00B").mangledNameHash());
    ASSERT_EQ(0x0000015du, ImmutableString("ceil(10B").mangledNameHash());
    ASSERT_EQ(0x000001e6u, ImmutableString("ceil(20B").mangledNameHash());
    ASSERT_EQ(0x0000024eu, ImmutableString("ceil(30B").mangledNameHash());
    ASSERT_EQ(0x000003beu, ImmutableString("fract(00B").mangledNameHash());
    ASSERT_EQ(0x0000034du, ImmutableString("fract(10B").mangledNameHash());
    ASSERT_EQ(0x000002cfu, ImmutableString("fract(20B").mangledNameHash());
    ASSERT_EQ(0x00000252u, ImmutableString("fract(30B").mangledNameHash());
    ASSERT_EQ(0x000003cbu, ImmutableString("mod(00B00B").mangledNameHash());
    ASSERT_EQ(0x0000053cu, ImmutableString("mod(10B00B").mangledNameHash());
    ASSERT_EQ(0x000004fcu, ImmutableString("mod(20B00B").mangledNameHash());
    ASSERT_EQ(0x000000b6u, ImmutableString("mod(30B00B").mangledNameHash());
    ASSERT_EQ(0x000005d6u, ImmutableString("mod(10B10B").mangledNameHash());
    ASSERT_EQ(0x000003fbu, ImmutableString("mod(20B20B").mangledNameHash());
    ASSERT_EQ(0x000003c6u, ImmutableString("mod(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000578u, ImmutableString("min(00B00B").mangledNameHash());
    ASSERT_EQ(0x000001bdu, ImmutableString("min(10B00B").mangledNameHash());
    ASSERT_EQ(0x000001eeu, ImmutableString("min(20B00B").mangledNameHash());
    ASSERT_EQ(0x00000353u, ImmutableString("min(30B00B").mangledNameHash());
    ASSERT_EQ(0x000001dfu, ImmutableString("min(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000599u, ImmutableString("min(20B20B").mangledNameHash());
    ASSERT_EQ(0x000004dau, ImmutableString("min(30B30B").mangledNameHash());
    ASSERT_EQ(0x0000016bu, ImmutableString("min(00D00D").mangledNameHash());
    ASSERT_EQ(0x00000340u, ImmutableString("min(10D10D").mangledNameHash());
    ASSERT_EQ(0x000005bfu, ImmutableString("min(20D20D").mangledNameHash());
    ASSERT_EQ(0x000005afu, ImmutableString("min(30D30D").mangledNameHash());
    ASSERT_EQ(0x000002b9u, ImmutableString("min(10D00D").mangledNameHash());
    ASSERT_EQ(0x000004cbu, ImmutableString("min(20D00D").mangledNameHash());
    ASSERT_EQ(0x00000627u, ImmutableString("min(30D00D").mangledNameHash());
    ASSERT_EQ(0x00000281u, ImmutableString("min(00E00E").mangledNameHash());
    ASSERT_EQ(0x00000619u, ImmutableString("min(10E10E").mangledNameHash());
    ASSERT_EQ(0x000004bau, ImmutableString("min(20E20E").mangledNameHash());
    ASSERT_EQ(0x00000574u, ImmutableString("min(30E30E").mangledNameHash());
    ASSERT_EQ(0x0000005cu, ImmutableString("min(10E00E").mangledNameHash());
    ASSERT_EQ(0x00000593u, ImmutableString("min(20E00E").mangledNameHash());
    ASSERT_EQ(0x000003bfu, ImmutableString("min(30E00E").mangledNameHash());
    ASSERT_EQ(0x000003a6u, ImmutableString("max(00B00B").mangledNameHash());
    ASSERT_EQ(0x000005b6u, ImmutableString("max(10B00B").mangledNameHash());
    ASSERT_EQ(0x000001b6u, ImmutableString("max(20B00B").mangledNameHash());
    ASSERT_EQ(0x00000292u, ImmutableString("max(30B00B").mangledNameHash());
    ASSERT_EQ(0x00000188u, ImmutableString("max(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000434u, ImmutableString("max(20B20B").mangledNameHash());
    ASSERT_EQ(0x00000230u, ImmutableString("max(30B30B").mangledNameHash());
    ASSERT_EQ(0x0000022cu, ImmutableString("max(00D00D").mangledNameHash());
    ASSERT_EQ(0x00000403u, ImmutableString("max(10D10D").mangledNameHash());
    ASSERT_EQ(0x00000402u, ImmutableString("max(20D20D").mangledNameHash());
    ASSERT_EQ(0x000002e0u, ImmutableString("max(30D30D").mangledNameHash());
    ASSERT_EQ(0x00000390u, ImmutableString("max(10D00D").mangledNameHash());
    ASSERT_EQ(0x00000500u, ImmutableString("max(20D00D").mangledNameHash());
    ASSERT_EQ(0x0000002eu, ImmutableString("max(30D00D").mangledNameHash());
    ASSERT_EQ(0x000004a1u, ImmutableString("max(00E00E").mangledNameHash());
    ASSERT_EQ(0x00000079u, ImmutableString("max(10E10E").mangledNameHash());
    ASSERT_EQ(0x0000007au, ImmutableString("max(20E20E").mangledNameHash());
    ASSERT_EQ(0x00000253u, ImmutableString("max(30E30E").mangledNameHash());
    ASSERT_EQ(0x00000268u, ImmutableString("max(10E00E").mangledNameHash());
    ASSERT_EQ(0x00000136u, ImmutableString("max(20E00E").mangledNameHash());
    ASSERT_EQ(0x00000538u, ImmutableString("max(30E00E").mangledNameHash());
    ASSERT_EQ(0x0000054au, ImmutableString("clamp(00B00B00B").mangledNameHash());
    ASSERT_EQ(0x00000399u, ImmutableString("clamp(10B00B00B").mangledNameHash());
    ASSERT_EQ(0x0000042fu, ImmutableString("clamp(20B00B00B").mangledNameHash());
    ASSERT_EQ(0x0000038eu, ImmutableString("clamp(30B00B00B").mangledNameHash());
    ASSERT_EQ(0x000001b1u, ImmutableString("clamp(10B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000060eu, ImmutableString("clamp(20B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000018u, ImmutableString("clamp(30B30B30B").mangledNameHash());
    ASSERT_EQ(0x00000391u, ImmutableString("clamp(00D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000360u, ImmutableString("clamp(10D00D00D").mangledNameHash());
    ASSERT_EQ(0x000000b4u, ImmutableString("clamp(20D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000031au, ImmutableString("clamp(30D00D00D").mangledNameHash());
    ASSERT_EQ(0x000004f1u, ImmutableString("clamp(10D10D10D").mangledNameHash());
    ASSERT_EQ(0x00000203u, ImmutableString("clamp(20D20D20D").mangledNameHash());
    ASSERT_EQ(0x0000045cu, ImmutableString("clamp(30D30D30D").mangledNameHash());
    ASSERT_EQ(0x000001a9u, ImmutableString("clamp(00E00E00E").mangledNameHash());
    ASSERT_EQ(0x000000fbu, ImmutableString("clamp(10E00E00E").mangledNameHash());
    ASSERT_EQ(0x000005efu, ImmutableString("clamp(20E00E00E").mangledNameHash());
    ASSERT_EQ(0x000000f8u, ImmutableString("clamp(30E00E00E").mangledNameHash());
    ASSERT_EQ(0x0000007bu, ImmutableString("clamp(10E10E10E").mangledNameHash());
    ASSERT_EQ(0x000001f1u, ImmutableString("clamp(20E20E20E").mangledNameHash());
    ASSERT_EQ(0x000004f6u, ImmutableString("clamp(30E30E30E").mangledNameHash());
    ASSERT_EQ(0x00000406u, ImmutableString("mix(00B00B00B").mangledNameHash());
    ASSERT_EQ(0x0000045au, ImmutableString("mix(10B10B00B").mangledNameHash());
    ASSERT_EQ(0x00000010u, ImmutableString("mix(20B20B00B").mangledNameHash());
    ASSERT_EQ(0x0000038du, ImmutableString("mix(30B30B00B").mangledNameHash());
    ASSERT_EQ(0x000003e0u, ImmutableString("mix(10B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000109u, ImmutableString("mix(20B20B20B").mangledNameHash());
    ASSERT_EQ(0x000002d9u, ImmutableString("mix(30B30B30B").mangledNameHash());
    ASSERT_EQ(0x000001c8u, ImmutableString("mix(00B00B00F").mangledNameHash());
    ASSERT_EQ(0x000003dfu, ImmutableString("mix(10B10B10F").mangledNameHash());
    ASSERT_EQ(0x00000105u, ImmutableString("mix(20B20B20F").mangledNameHash());
    ASSERT_EQ(0x000002d8u, ImmutableString("mix(30B30B30F").mangledNameHash());
    ASSERT_EQ(0x00000240u, ImmutableString("mix(00D00D00F").mangledNameHash());
    ASSERT_EQ(0x0000021fu, ImmutableString("mix(10D10D10F").mangledNameHash());
    ASSERT_EQ(0x00000023u, ImmutableString("mix(20D20D20F").mangledNameHash());
    ASSERT_EQ(0x000004e1u, ImmutableString("mix(30D30D30F").mangledNameHash());
    ASSERT_EQ(0x0000023eu, ImmutableString("mix(00E00E00F").mangledNameHash());
    ASSERT_EQ(0x000005dcu, ImmutableString("mix(10E10E10F").mangledNameHash());
    ASSERT_EQ(0x0000031bu, ImmutableString("mix(20E20E20F").mangledNameHash());
    ASSERT_EQ(0x000001d7u, ImmutableString("mix(30E30E30F").mangledNameHash());
    ASSERT_EQ(0x00000127u, ImmutableString("mix(00F00F00F").mangledNameHash());
    ASSERT_EQ(0x000002e5u, ImmutableString("mix(10F10F10F").mangledNameHash());
    ASSERT_EQ(0x00000151u, ImmutableString("mix(20F20F20F").mangledNameHash());
    ASSERT_EQ(0x000001c0u, ImmutableString("mix(30F30F30F").mangledNameHash());
    ASSERT_EQ(0x0000055bu, ImmutableString("step(00B00B").mangledNameHash());
    ASSERT_EQ(0x00000112u, ImmutableString("step(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000065u, ImmutableString("step(20B20B").mangledNameHash());
    ASSERT_EQ(0x00000361u, ImmutableString("step(30B30B").mangledNameHash());
    ASSERT_EQ(0x000004e4u, ImmutableString("step(00B10B").mangledNameHash());
    ASSERT_EQ(0x00000337u, ImmutableString("step(00B20B").mangledNameHash());
    ASSERT_EQ(0x000002a6u, ImmutableString("step(00B30B").mangledNameHash());
    ASSERT_EQ(0x00000472u, ImmutableString("smoothstep(00B00B00B").mangledNameHash());
    ASSERT_EQ(0x00000275u, ImmutableString("smoothstep(10B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000193u, ImmutableString("smoothstep(20B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000168u, ImmutableString("smoothstep(30B30B30B").mangledNameHash());
    ASSERT_EQ(0x000003f2u, ImmutableString("smoothstep(00B00B10B").mangledNameHash());
    ASSERT_EQ(0x0000037cu, ImmutableString("smoothstep(00B00B20B").mangledNameHash());
    ASSERT_EQ(0x00000152u, ImmutableString("smoothstep(00B00B30B").mangledNameHash());
    ASSERT_EQ(0x00000328u, ImmutableString("modf(00B00B").mangledNameHash());
    ASSERT_EQ(0x0000003au, ImmutableString("modf(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000410u, ImmutableString("modf(20B20B").mangledNameHash());
    ASSERT_EQ(0x00000224u, ImmutableString("modf(30B30B").mangledNameHash());
    ASSERT_EQ(0x0000027du, ImmutableString("isnan(00B").mangledNameHash());
    ASSERT_EQ(0x00000312u, ImmutableString("isnan(10B").mangledNameHash());
    ASSERT_EQ(0x00000533u, ImmutableString("isnan(20B").mangledNameHash());
    ASSERT_EQ(0x00000332u, ImmutableString("isnan(30B").mangledNameHash());
    ASSERT_EQ(0x000000b3u, ImmutableString("isinf(00B").mangledNameHash());
    ASSERT_EQ(0x00000139u, ImmutableString("isinf(10B").mangledNameHash());
    ASSERT_EQ(0x00000617u, ImmutableString("isinf(20B").mangledNameHash());
    ASSERT_EQ(0x00000057u, ImmutableString("isinf(30B").mangledNameHash());
    ASSERT_EQ(0x0000031eu, ImmutableString("floatBitsToInt(00B").mangledNameHash());
    ASSERT_EQ(0x00000288u, ImmutableString("floatBitsToInt(10B").mangledNameHash());
    ASSERT_EQ(0x0000022au, ImmutableString("floatBitsToInt(20B").mangledNameHash());
    ASSERT_EQ(0x000001b5u, ImmutableString("floatBitsToInt(30B").mangledNameHash());
    ASSERT_EQ(0x00000320u, ImmutableString("floatBitsToUint(00B").mangledNameHash());
    ASSERT_EQ(0x00000374u, ImmutableString("floatBitsToUint(10B").mangledNameHash());
    ASSERT_EQ(0x00000220u, ImmutableString("floatBitsToUint(20B").mangledNameHash());
    ASSERT_EQ(0x0000028eu, ImmutableString("floatBitsToUint(30B").mangledNameHash());
    ASSERT_EQ(0x000005e2u, ImmutableString("intBitsToFloat(00D").mangledNameHash());
    ASSERT_EQ(0x00000561u, ImmutableString("intBitsToFloat(10D").mangledNameHash());
    ASSERT_EQ(0x0000009eu, ImmutableString("intBitsToFloat(20D").mangledNameHash());
    ASSERT_EQ(0x00000033u, ImmutableString("intBitsToFloat(30D").mangledNameHash());
    ASSERT_EQ(0x000004cdu, ImmutableString("uintBitsToFloat(00E").mangledNameHash());
    ASSERT_EQ(0x0000053du, ImmutableString("uintBitsToFloat(10E").mangledNameHash());
    ASSERT_EQ(0x000005d3u, ImmutableString("uintBitsToFloat(20E").mangledNameHash());
    ASSERT_EQ(0x00000011u, ImmutableString("uintBitsToFloat(30E").mangledNameHash());
    ASSERT_EQ(0x0000061cu, ImmutableString("fma(00B00B00B").mangledNameHash());
    ASSERT_EQ(0x000003f1u, ImmutableString("fma(10B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000120u, ImmutableString("fma(20B20B20B").mangledNameHash());
    ASSERT_EQ(0x000001d2u, ImmutableString("fma(30B30B30B").mangledNameHash());
    ASSERT_EQ(0x000001e4u, ImmutableString("frexp(00B00D").mangledNameHash());
    ASSERT_EQ(0x00000580u, ImmutableString("frexp(10B10D").mangledNameHash());
    ASSERT_EQ(0x0000009du, ImmutableString("frexp(20B20D").mangledNameHash());
    ASSERT_EQ(0x000000c1u, ImmutableString("frexp(30B30D").mangledNameHash());
    ASSERT_EQ(0x000001aau, ImmutableString("ldexp(00B00D").mangledNameHash());
    ASSERT_EQ(0x000005feu, ImmutableString("ldexp(10B10D").mangledNameHash());
    ASSERT_EQ(0x00000235u, ImmutableString("ldexp(20B20D").mangledNameHash());
    ASSERT_EQ(0x00000291u, ImmutableString("ldexp(30B30D").mangledNameHash());
    ASSERT_EQ(0x0000028du, ImmutableString("packSnorm2x16(10B").mangledNameHash());
    ASSERT_EQ(0x000002c0u, ImmutableString("packHalf2x16(10B").mangledNameHash());
    ASSERT_EQ(0x00000586u, ImmutableString("unpackSnorm2x16(00E").mangledNameHash());
    ASSERT_EQ(0x0000006fu, ImmutableString("unpackHalf2x16(00E").mangledNameHash());
    ASSERT_EQ(0x0000012fu, ImmutableString("packUnorm2x16(10B").mangledNameHash());
    ASSERT_EQ(0x00000358u, ImmutableString("unpackUnorm2x16(00E").mangledNameHash());
    ASSERT_EQ(0x000001a1u, ImmutableString("packUnorm4x8(30B").mangledNameHash());
    ASSERT_EQ(0x00000459u, ImmutableString("packSnorm4x8(30B").mangledNameHash());
    ASSERT_EQ(0x000003ccu, ImmutableString("unpackUnorm4x8(00E").mangledNameHash());
    ASSERT_EQ(0x0000052du, ImmutableString("unpackSnorm4x8(00E").mangledNameHash());
    ASSERT_EQ(0x0000058cu, ImmutableString("length(00B").mangledNameHash());
    ASSERT_EQ(0x0000050fu, ImmutableString("length(10B").mangledNameHash());
    ASSERT_EQ(0x0000049bu, ImmutableString("length(20B").mangledNameHash());
    ASSERT_EQ(0x00000417u, ImmutableString("length(30B").mangledNameHash());
    ASSERT_EQ(0x000005a9u, ImmutableString("distance(00B00B").mangledNameHash());
    ASSERT_EQ(0x00000091u, ImmutableString("distance(10B10B").mangledNameHash());
    ASSERT_EQ(0x000003d4u, ImmutableString("distance(20B20B").mangledNameHash());
    ASSERT_EQ(0x00000388u, ImmutableString("distance(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000512u, ImmutableString("dot(00B00B").mangledNameHash());
    ASSERT_EQ(0x0000020du, ImmutableString("dot(10B10B").mangledNameHash());
    ASSERT_EQ(0x000002f0u, ImmutableString("dot(20B20B").mangledNameHash());
    ASSERT_EQ(0x0000038au, ImmutableString("dot(30B30B").mangledNameHash());
    ASSERT_EQ(0x0000042du, ImmutableString("cross(20B20B").mangledNameHash());
    ASSERT_EQ(0x0000036fu, ImmutableString("normalize(00B").mangledNameHash());
    ASSERT_EQ(0x000003f4u, ImmutableString("normalize(10B").mangledNameHash());
    ASSERT_EQ(0x000000c6u, ImmutableString("normalize(20B").mangledNameHash());
    ASSERT_EQ(0x0000003du, ImmutableString("normalize(30B").mangledNameHash());
    ASSERT_EQ(0x00000443u, ImmutableString("faceforward(00B00B00B").mangledNameHash());
    ASSERT_EQ(0x000002b7u, ImmutableString("faceforward(10B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000011du, ImmutableString("faceforward(20B20B20B").mangledNameHash());
    ASSERT_EQ(0x000005a6u, ImmutableString("faceforward(30B30B30B").mangledNameHash());
    ASSERT_EQ(0x000001efu, ImmutableString("reflect(00B00B").mangledNameHash());
    ASSERT_EQ(0x00000055u, ImmutableString("reflect(10B10B").mangledNameHash());
    ASSERT_EQ(0x000003b3u, ImmutableString("reflect(20B20B").mangledNameHash());
    ASSERT_EQ(0x000003c4u, ImmutableString("reflect(30B30B").mangledNameHash());
    ASSERT_EQ(0x000000bbu, ImmutableString("refract(00B00B00B").mangledNameHash());
    ASSERT_EQ(0x000001fbu, ImmutableString("refract(10B10B00B").mangledNameHash());
    ASSERT_EQ(0x00000161u, ImmutableString("refract(20B20B00B").mangledNameHash());
    ASSERT_EQ(0x00000404u, ImmutableString("refract(30B30B00B").mangledNameHash());
    ASSERT_EQ(0x00000181u, ImmutableString("matrixCompMult(50B50B").mangledNameHash());
    ASSERT_EQ(0x0000051au, ImmutableString("matrixCompMult(A0BA0B").mangledNameHash());
    ASSERT_EQ(0x00000407u, ImmutableString("matrixCompMult(F0BF0B").mangledNameHash());
    ASSERT_EQ(0x000000f6u, ImmutableString("matrixCompMult(90B90B").mangledNameHash());
    ASSERT_EQ(0x00000584u, ImmutableString("matrixCompMult(60B60B").mangledNameHash());
    ASSERT_EQ(0x000004d6u, ImmutableString("matrixCompMult(D0BD0B").mangledNameHash());
    ASSERT_EQ(0x0000007du, ImmutableString("matrixCompMult(70B70B").mangledNameHash());
    ASSERT_EQ(0x0000026eu, ImmutableString("matrixCompMult(E0BE0B").mangledNameHash());
    ASSERT_EQ(0x0000042bu, ImmutableString("matrixCompMult(B0BB0B").mangledNameHash());
    ASSERT_EQ(0x00000214u, ImmutableString("outerProduct(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000084u, ImmutableString("outerProduct(20B20B").mangledNameHash());
    ASSERT_EQ(0x00000122u, ImmutableString("outerProduct(30B30B").mangledNameHash());
    ASSERT_EQ(0x0000054fu, ImmutableString("outerProduct(20B10B").mangledNameHash());
    ASSERT_EQ(0x0000006cu, ImmutableString("outerProduct(10B20B").mangledNameHash());
    ASSERT_EQ(0x00000044u, ImmutableString("outerProduct(30B10B").mangledNameHash());
    ASSERT_EQ(0x000000e4u, ImmutableString("outerProduct(10B30B").mangledNameHash());
    ASSERT_EQ(0x000000a6u, ImmutableString("outerProduct(30B20B").mangledNameHash());
    ASSERT_EQ(0x0000000fu, ImmutableString("outerProduct(20B30B").mangledNameHash());
    ASSERT_EQ(0x000005b9u, ImmutableString("transpose(50B").mangledNameHash());
    ASSERT_EQ(0x00000462u, ImmutableString("transpose(A0B").mangledNameHash());
    ASSERT_EQ(0x000004f3u, ImmutableString("transpose(F0B").mangledNameHash());
    ASSERT_EQ(0x00000440u, ImmutableString("transpose(60B").mangledNameHash());
    ASSERT_EQ(0x000004feu, ImmutableString("transpose(90B").mangledNameHash());
    ASSERT_EQ(0x000004c2u, ImmutableString("transpose(70B").mangledNameHash());
    ASSERT_EQ(0x000005eau, ImmutableString("transpose(D0B").mangledNameHash());
    ASSERT_EQ(0x000001a8u, ImmutableString("transpose(B0B").mangledNameHash());
    ASSERT_EQ(0x00000035u, ImmutableString("transpose(E0B").mangledNameHash());
    ASSERT_EQ(0x0000003bu, ImmutableString("determinant(50B").mangledNameHash());
    ASSERT_EQ(0x0000032du, ImmutableString("determinant(A0B").mangledNameHash());
    ASSERT_EQ(0x00000461u, ImmutableString("determinant(F0B").mangledNameHash());
    ASSERT_EQ(0x0000020cu, ImmutableString("inverse(50B").mangledNameHash());
    ASSERT_EQ(0x000003e7u, ImmutableString("inverse(A0B").mangledNameHash());
    ASSERT_EQ(0x000004f8u, ImmutableString("inverse(F0B").mangledNameHash());
    ASSERT_EQ(0x00000140u, ImmutableString("lessThan(10B10B").mangledNameHash());
    ASSERT_EQ(0x0000003eu, ImmutableString("lessThan(20B20B").mangledNameHash());
    ASSERT_EQ(0x0000042cu, ImmutableString("lessThan(30B30B").mangledNameHash());
    ASSERT_EQ(0x0000039bu, ImmutableString("lessThan(10D10D").mangledNameHash());
    ASSERT_EQ(0x00000054u, ImmutableString("lessThan(20D20D").mangledNameHash());
    ASSERT_EQ(0x00000587u, ImmutableString("lessThan(30D30D").mangledNameHash());
    ASSERT_EQ(0x0000004cu, ImmutableString("lessThan(10E10E").mangledNameHash());
    ASSERT_EQ(0x000004dbu, ImmutableString("lessThan(20E20E").mangledNameHash());
    ASSERT_EQ(0x000004c0u, ImmutableString("lessThan(30E30E").mangledNameHash());
    ASSERT_EQ(0x000001c5u, ImmutableString("lessThanEqual(10B10B").mangledNameHash());
    ASSERT_EQ(0x000001bcu, ImmutableString("lessThanEqual(20B20B").mangledNameHash());
    ASSERT_EQ(0x0000000du, ImmutableString("lessThanEqual(30B30B").mangledNameHash());
    ASSERT_EQ(0x0000047du, ImmutableString("lessThanEqual(10D10D").mangledNameHash());
    ASSERT_EQ(0x00000147u, ImmutableString("lessThanEqual(20D20D").mangledNameHash());
    ASSERT_EQ(0x00000333u, ImmutableString("lessThanEqual(30D30D").mangledNameHash());
    ASSERT_EQ(0x000000ffu, ImmutableString("lessThanEqual(10E10E").mangledNameHash());
    ASSERT_EQ(0x000005ceu, ImmutableString("lessThanEqual(20E20E").mangledNameHash());
    ASSERT_EQ(0x0000005bu, ImmutableString("lessThanEqual(30E30E").mangledNameHash());
    ASSERT_EQ(0x00000319u, ImmutableString("greaterThan(10B10B").mangledNameHash());
    ASSERT_EQ(0x000005beu, ImmutableString("greaterThan(20B20B").mangledNameHash());
    ASSERT_EQ(0x0000011bu, ImmutableString("greaterThan(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000509u, ImmutableString("greaterThan(10D10D").mangledNameHash());
    ASSERT_EQ(0x0000050bu, ImmutableString("greaterThan(20D20D").mangledNameHash());
    ASSERT_EQ(0x00000062u, ImmutableString("greaterThan(30D30D").mangledNameHash());
    ASSERT_EQ(0x0000018fu, ImmutableString("greaterThan(10E10E").mangledNameHash());
    ASSERT_EQ(0x000000b9u, ImmutableString("greaterThan(20E20E").mangledNameHash());
    ASSERT_EQ(0x000000cdu, ImmutableString("greaterThan(30E30E").mangledNameHash());
    ASSERT_EQ(0x000004f0u, ImmutableString("greaterThanEqual(10B10B").mangledNameHash());
    ASSERT_EQ(0x0000001cu, ImmutableString("greaterThanEqual(20B20B").mangledNameHash());
    ASSERT_EQ(0x0000013bu, ImmutableString("greaterThanEqual(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000098u, ImmutableString("greaterThanEqual(10D10D").mangledNameHash());
    ASSERT_EQ(0x000005bau, ImmutableString("greaterThanEqual(20D20D").mangledNameHash());
    ASSERT_EQ(0x0000016fu, ImmutableString("greaterThanEqual(30D30D").mangledNameHash());
    ASSERT_EQ(0x00000015u, ImmutableString("greaterThanEqual(10E10E").mangledNameHash());
    ASSERT_EQ(0x0000021au, ImmutableString("greaterThanEqual(20E20E").mangledNameHash());
    ASSERT_EQ(0x00000104u, ImmutableString("greaterThanEqual(30E30E").mangledNameHash());
    ASSERT_EQ(0x00000311u, ImmutableString("equal(10B10B").mangledNameHash());
    ASSERT_EQ(0x0000023au, ImmutableString("equal(20B20B").mangledNameHash());
    ASSERT_EQ(0x00000182u, ImmutableString("equal(30B30B").mangledNameHash());
    ASSERT_EQ(0x0000002du, ImmutableString("equal(10D10D").mangledNameHash());
    ASSERT_EQ(0x000005dbu, ImmutableString("equal(20D20D").mangledNameHash());
    ASSERT_EQ(0x0000028bu, ImmutableString("equal(30D30D").mangledNameHash());
    ASSERT_EQ(0x00000489u, ImmutableString("equal(10E10E").mangledNameHash());
    ASSERT_EQ(0x000000f1u, ImmutableString("equal(20E20E").mangledNameHash());
    ASSERT_EQ(0x000002a8u, ImmutableString("equal(30E30E").mangledNameHash());
    ASSERT_EQ(0x000003b6u, ImmutableString("equal(10F10F").mangledNameHash());
    ASSERT_EQ(0x0000030fu, ImmutableString("equal(20F20F").mangledNameHash());
    ASSERT_EQ(0x00000436u, ImmutableString("equal(30F30F").mangledNameHash());
    ASSERT_EQ(0x00000589u, ImmutableString("notEqual(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000285u, ImmutableString("notEqual(20B20B").mangledNameHash());
    ASSERT_EQ(0x00000247u, ImmutableString("notEqual(30B30B").mangledNameHash());
    ASSERT_EQ(0x000002acu, ImmutableString("notEqual(10D10D").mangledNameHash());
    ASSERT_EQ(0x00000329u, ImmutableString("notEqual(20D20D").mangledNameHash());
    ASSERT_EQ(0x00000381u, ImmutableString("notEqual(30D30D").mangledNameHash());
    ASSERT_EQ(0x00000491u, ImmutableString("notEqual(10E10E").mangledNameHash());
    ASSERT_EQ(0x000003e5u, ImmutableString("notEqual(20E20E").mangledNameHash());
    ASSERT_EQ(0x000000fcu, ImmutableString("notEqual(30E30E").mangledNameHash());
    ASSERT_EQ(0x00000471u, ImmutableString("notEqual(10F10F").mangledNameHash());
    ASSERT_EQ(0x00000242u, ImmutableString("notEqual(20F20F").mangledNameHash());
    ASSERT_EQ(0x000002ccu, ImmutableString("notEqual(30F30F").mangledNameHash());
    ASSERT_EQ(0x0000010au, ImmutableString("any(10F").mangledNameHash());
    ASSERT_EQ(0x000003f7u, ImmutableString("any(20F").mangledNameHash());
    ASSERT_EQ(0x00000387u, ImmutableString("any(30F").mangledNameHash());
    ASSERT_EQ(0x0000042eu, ImmutableString("all(10F").mangledNameHash());
    ASSERT_EQ(0x000002bbu, ImmutableString("all(20F").mangledNameHash());
    ASSERT_EQ(0x00000341u, ImmutableString("all(30F").mangledNameHash());
    ASSERT_EQ(0x0000000bu, ImmutableString("not(10F").mangledNameHash());
    ASSERT_EQ(0x00000081u, ImmutableString("not(20F").mangledNameHash());
    ASSERT_EQ(0x00000609u, ImmutableString("not(30F").mangledNameHash());
    ASSERT_EQ(0x00000438u, ImmutableString("bitfieldExtract(00D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000022u, ImmutableString("bitfieldExtract(10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000540u, ImmutableString("bitfieldExtract(20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000005dfu, ImmutableString("bitfieldExtract(30D00D00D").mangledNameHash());
    ASSERT_EQ(0x000003f6u, ImmutableString("bitfieldExtract(00E00D00D").mangledNameHash());
    ASSERT_EQ(0x0000050au, ImmutableString("bitfieldExtract(10E00D00D").mangledNameHash());
    ASSERT_EQ(0x000005d2u, ImmutableString("bitfieldExtract(20E00D00D").mangledNameHash());
    ASSERT_EQ(0x00000096u, ImmutableString("bitfieldExtract(30E00D00D").mangledNameHash());
    ASSERT_EQ(0x000001abu, ImmutableString("bitfieldInsert(00D00D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000478u, ImmutableString("bitfieldInsert(10D10D00D00D").mangledNameHash());
    ASSERT_EQ(0x000004d0u, ImmutableString("bitfieldInsert(20D20D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000508u, ImmutableString("bitfieldInsert(30D30D00D00D").mangledNameHash());
    ASSERT_EQ(0x000004ddu, ImmutableString("bitfieldInsert(00E00E00D00D").mangledNameHash());
    ASSERT_EQ(0x00000458u, ImmutableString("bitfieldInsert(10E10E00D00D").mangledNameHash());
    ASSERT_EQ(0x0000059cu, ImmutableString("bitfieldInsert(20E20E00D00D").mangledNameHash());
    ASSERT_EQ(0x000005d1u, ImmutableString("bitfieldInsert(30E30E00D00D").mangledNameHash());
    ASSERT_EQ(0x00000396u, ImmutableString("bitfieldReverse(00D").mangledNameHash());
    ASSERT_EQ(0x0000004bu, ImmutableString("bitfieldReverse(10D").mangledNameHash());
    ASSERT_EQ(0x00000346u, ImmutableString("bitfieldReverse(20D").mangledNameHash());
    ASSERT_EQ(0x000003bbu, ImmutableString("bitfieldReverse(30D").mangledNameHash());
    ASSERT_EQ(0x00000397u, ImmutableString("bitfieldReverse(00E").mangledNameHash());
    ASSERT_EQ(0x00000049u, ImmutableString("bitfieldReverse(10E").mangledNameHash());
    ASSERT_EQ(0x00000347u, ImmutableString("bitfieldReverse(20E").mangledNameHash());
    ASSERT_EQ(0x000003bau, ImmutableString("bitfieldReverse(30E").mangledNameHash());
    ASSERT_EQ(0x000001b3u, ImmutableString("bitCount(00D").mangledNameHash());
    ASSERT_EQ(0x00000125u, ImmutableString("bitCount(10D").mangledNameHash());
    ASSERT_EQ(0x000003d0u, ImmutableString("bitCount(20D").mangledNameHash());
    ASSERT_EQ(0x00000357u, ImmutableString("bitCount(30D").mangledNameHash());
    ASSERT_EQ(0x000001b4u, ImmutableString("bitCount(00E").mangledNameHash());
    ASSERT_EQ(0x00000124u, ImmutableString("bitCount(10E").mangledNameHash());
    ASSERT_EQ(0x000003d1u, ImmutableString("bitCount(20E").mangledNameHash());
    ASSERT_EQ(0x00000356u, ImmutableString("bitCount(30E").mangledNameHash());
    ASSERT_EQ(0x000005e4u, ImmutableString("findLSB(00D").mangledNameHash());
    ASSERT_EQ(0x00000562u, ImmutableString("findLSB(10D").mangledNameHash());
    ASSERT_EQ(0x000004ecu, ImmutableString("findLSB(20D").mangledNameHash());
    ASSERT_EQ(0x000002b2u, ImmutableString("findLSB(30D").mangledNameHash());
    ASSERT_EQ(0x000005e3u, ImmutableString("findLSB(00E").mangledNameHash());
    ASSERT_EQ(0x00000171u, ImmutableString("findLSB(10E").mangledNameHash());
    ASSERT_EQ(0x000004ebu, ImmutableString("findLSB(20E").mangledNameHash());
    ASSERT_EQ(0x000002b3u, ImmutableString("findLSB(30E").mangledNameHash());
    ASSERT_EQ(0x00000623u, ImmutableString("findMSB(00D").mangledNameHash());
    ASSERT_EQ(0x00000067u, ImmutableString("findMSB(10D").mangledNameHash());
    ASSERT_EQ(0x00000526u, ImmutableString("findMSB(20D").mangledNameHash());
    ASSERT_EQ(0x000005b2u, ImmutableString("findMSB(30D").mangledNameHash());
    ASSERT_EQ(0x00000624u, ImmutableString("findMSB(00E").mangledNameHash());
    ASSERT_EQ(0x00000066u, ImmutableString("findMSB(10E").mangledNameHash());
    ASSERT_EQ(0x00000527u, ImmutableString("findMSB(20E").mangledNameHash());
    ASSERT_EQ(0x000005b1u, ImmutableString("findMSB(30E").mangledNameHash());
    ASSERT_EQ(0x000000f2u, ImmutableString("uaddCarry(00E00E00E").mangledNameHash());
    ASSERT_EQ(0x00000481u, ImmutableString("uaddCarry(10E10E10E").mangledNameHash());
    ASSERT_EQ(0x00000313u, ImmutableString("uaddCarry(20E20E20E").mangledNameHash());
    ASSERT_EQ(0x000003d5u, ImmutableString("uaddCarry(30E30E30E").mangledNameHash());
    ASSERT_EQ(0x000003ebu, ImmutableString("usubBorrow(00E00E00E").mangledNameHash());
    ASSERT_EQ(0x00000310u, ImmutableString("usubBorrow(10E10E10E").mangledNameHash());
    ASSERT_EQ(0x0000038cu, ImmutableString("usubBorrow(20E20E20E").mangledNameHash());
    ASSERT_EQ(0x00000426u, ImmutableString("usubBorrow(30E30E30E").mangledNameHash());
    ASSERT_EQ(0x000005f8u, ImmutableString("umulExtended(00E00E00E00E").mangledNameHash());
    ASSERT_EQ(0x00000408u, ImmutableString("umulExtended(10E10E10E10E").mangledNameHash());
    ASSERT_EQ(0x00000130u, ImmutableString("umulExtended(20E20E20E20E").mangledNameHash());
    ASSERT_EQ(0x0000040bu, ImmutableString("umulExtended(30E30E30E30E").mangledNameHash());
    ASSERT_EQ(0x000004c3u, ImmutableString("imulExtended(00D00D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000027eu, ImmutableString("imulExtended(10D10D10D10D").mangledNameHash());
    ASSERT_EQ(0x00000386u, ImmutableString("imulExtended(20D20D20D20D").mangledNameHash());
    ASSERT_EQ(0x000004c1u, ImmutableString("imulExtended(30D30D30D30D").mangledNameHash());
    ASSERT_EQ(0x000001e5u, ImmutableString("texture2D(00I10B").mangledNameHash());
    ASSERT_EQ(0x00000004u, ImmutableString("texture2DProj(00I20B").mangledNameHash());
    ASSERT_EQ(0x00000282u, ImmutableString("texture2DProj(00I30B").mangledNameHash());
    ASSERT_EQ(0x000000f3u, ImmutableString("textureCube(00K20B").mangledNameHash());
    ASSERT_EQ(0x000002fcu, ImmutableString("texture2D(00M10B").mangledNameHash());
    ASSERT_EQ(0x000002abu, ImmutableString("texture2DProj(00M20B").mangledNameHash());
    ASSERT_EQ(0x00000335u, ImmutableString("texture2DProj(00M30B").mangledNameHash());
    ASSERT_EQ(0x00000064u, ImmutableString("texture2DRect(00O10B").mangledNameHash());
    ASSERT_EQ(0x00000322u, ImmutableString("texture2DRectProj(00O20B").mangledNameHash());
    ASSERT_EQ(0x0000038fu, ImmutableString("texture2DRectProj(00O30B").mangledNameHash());
    ASSERT_EQ(0x00000364u, ImmutableString("texture(00O10B").mangledNameHash());
    ASSERT_EQ(0x0000020au, ImmutableString("textureProj(00O20B").mangledNameHash());
    ASSERT_EQ(0x00000276u, ImmutableString("textureProj(00O30B").mangledNameHash());
    ASSERT_EQ(0x000001ceu, ImmutableString("texture2DGradEXT(00I10B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000464u, ImmutableString("texture2DProjGradEXT(00I20B10B10B").mangledNameHash());
    ASSERT_EQ(0x000001d1u, ImmutableString("texture2DProjGradEXT(00I30B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000577u, ImmutableString("textureCubeGradEXT(00K20B20B20B").mangledNameHash());
    ASSERT_EQ(0x000003f0u, ImmutableString("texture2D(00I10B00B").mangledNameHash());
    ASSERT_EQ(0x000000b5u, ImmutableString("texture2DProj(00I20B00B").mangledNameHash());
    ASSERT_EQ(0x00000575u, ImmutableString("texture2DProj(00I30B00B").mangledNameHash());
    ASSERT_EQ(0x0000013fu, ImmutableString("textureCube(00K20B00B").mangledNameHash());
    ASSERT_EQ(0x00000430u, ImmutableString("dFdx(00B").mangledNameHash());
    ASSERT_EQ(0x000003b9u, ImmutableString("dFdx(10B").mangledNameHash());
    ASSERT_EQ(0x00000520u, ImmutableString("dFdx(20B").mangledNameHash());
    ASSERT_EQ(0x000004b5u, ImmutableString("dFdx(30B").mangledNameHash());
    ASSERT_EQ(0x000004bfu, ImmutableString("dFdy(00B").mangledNameHash());
    ASSERT_EQ(0x00000535u, ImmutableString("dFdy(10B").mangledNameHash());
    ASSERT_EQ(0x000000afu, ImmutableString("dFdy(20B").mangledNameHash());
    ASSERT_EQ(0x00000138u, ImmutableString("dFdy(30B").mangledNameHash());
    ASSERT_EQ(0x00000534u, ImmutableString("fwidth(00B").mangledNameHash());
    ASSERT_EQ(0x000004beu, ImmutableString("fwidth(10B").mangledNameHash());
    ASSERT_EQ(0x0000062au, ImmutableString("fwidth(20B").mangledNameHash());
    ASSERT_EQ(0x000005b3u, ImmutableString("fwidth(30B").mangledNameHash());
    ASSERT_EQ(0x0000055cu, ImmutableString("texture2DLodEXT(00I10B00B").mangledNameHash());
    ASSERT_EQ(0x0000013cu, ImmutableString("texture2DProjLodEXT(00I20B00B").mangledNameHash());
    ASSERT_EQ(0x00000129u, ImmutableString("texture2DProjLodEXT(00I30B00B").mangledNameHash());
    ASSERT_EQ(0x00000300u, ImmutableString("textureCubeLodEXT(00K20B00B").mangledNameHash());
    ASSERT_EQ(0x0000022eu, ImmutableString("shadow2DEXT(00d20B").mangledNameHash());
    ASSERT_EQ(0x0000016cu, ImmutableString("shadow2DProjEXT(00d30B").mangledNameHash());
    ASSERT_EQ(0x00000565u, ImmutableString("texture3D(00J20B").mangledNameHash());
    ASSERT_EQ(0x0000042au, ImmutableString("texture3DProj(00J30B").mangledNameHash());
    ASSERT_EQ(0x00000389u, ImmutableString("texture3D(00J20B00B").mangledNameHash());
    ASSERT_EQ(0x0000041eu, ImmutableString("texture3DProj(00J30B00B").mangledNameHash());
    ASSERT_EQ(0x000001a0u, ImmutableString("texture3DLod(00J20B00B").mangledNameHash());
    ASSERT_EQ(0x0000021cu, ImmutableString("texture3DProjLod(00J30B00B").mangledNameHash());
    ASSERT_EQ(0x000002a0u, ImmutableString("texture2DLod(00I10B00B").mangledNameHash());
    ASSERT_EQ(0x00000338u, ImmutableString("texture2DProjLod(00I20B00B").mangledNameHash());
    ASSERT_EQ(0x00000187u, ImmutableString("texture2DProjLod(00I30B00B").mangledNameHash());
    ASSERT_EQ(0x00000133u, ImmutableString("textureCubeLod(00K20B00B").mangledNameHash());
    ASSERT_EQ(0x000000c4u, ImmutableString("texture(00I10B").mangledNameHash());
    ASSERT_EQ(0x00000026u, ImmutableString("texture(00R10B").mangledNameHash());
    ASSERT_EQ(0x000005a7u, ImmutableString("texture(00X10B").mangledNameHash());
    ASSERT_EQ(0x0000047cu, ImmutableString("texture(00J20B").mangledNameHash());
    ASSERT_EQ(0x000000a7u, ImmutableString("texture(00S20B").mangledNameHash());
    ASSERT_EQ(0x000004adu, ImmutableString("texture(00Y20B").mangledNameHash());
    ASSERT_EQ(0x00000605u, ImmutableString("texture(00K20B").mangledNameHash());
    ASSERT_EQ(0x000004e7u, ImmutableString("texture(00T20B").mangledNameHash());
    ASSERT_EQ(0x000004d2u, ImmutableString("texture(00Z20B").mangledNameHash());
    ASSERT_EQ(0x00000521u, ImmutableString("texture(00L20B").mangledNameHash());
    ASSERT_EQ(0x00000063u, ImmutableString("texture(00U20B").mangledNameHash());
    ASSERT_EQ(0x000005fbu, ImmutableString("texture(00a20B").mangledNameHash());
    ASSERT_EQ(0x00000016u, ImmutableString("texture(00d20B").mangledNameHash());
    ASSERT_EQ(0x00000176u, ImmutableString("texture(00e30B").mangledNameHash());
    ASSERT_EQ(0x00000041u, ImmutableString("texture(00f30B").mangledNameHash());
    ASSERT_EQ(0x000001cau, ImmutableString("textureProj(00I20B").mangledNameHash());
    ASSERT_EQ(0x0000018eu, ImmutableString("textureProj(00R20B").mangledNameHash());
    ASSERT_EQ(0x00000217u, ImmutableString("textureProj(00X20B").mangledNameHash());
    ASSERT_EQ(0x0000023du, ImmutableString("textureProj(00I30B").mangledNameHash());
    ASSERT_EQ(0x00000102u, ImmutableString("textureProj(00R30B").mangledNameHash());
    ASSERT_EQ(0x00000622u, ImmutableString("textureProj(00X30B").mangledNameHash());
    ASSERT_EQ(0x00000227u, ImmutableString("textureProj(00J30B").mangledNameHash());
    ASSERT_EQ(0x00000137u, ImmutableString("textureProj(00S30B").mangledNameHash());
    ASSERT_EQ(0x000000b0u, ImmutableString("textureProj(00Y30B").mangledNameHash());
    ASSERT_EQ(0x000005f0u, ImmutableString("textureProj(00d30B").mangledNameHash());
    ASSERT_EQ(0x00000097u, ImmutableString("textureLod(00I10B00B").mangledNameHash());
    ASSERT_EQ(0x0000029cu, ImmutableString("textureLod(00R10B00B").mangledNameHash());
    ASSERT_EQ(0x00000435u, ImmutableString("textureLod(00X10B00B").mangledNameHash());
    ASSERT_EQ(0x00000375u, ImmutableString("textureLod(00J20B00B").mangledNameHash());
    ASSERT_EQ(0x000002d4u, ImmutableString("textureLod(00S20B00B").mangledNameHash());
    ASSERT_EQ(0x000004c7u, ImmutableString("textureLod(00Y20B00B").mangledNameHash());
    ASSERT_EQ(0x000003cfu, ImmutableString("textureLod(00K20B00B").mangledNameHash());
    ASSERT_EQ(0x00000514u, ImmutableString("textureLod(00T20B00B").mangledNameHash());
    ASSERT_EQ(0x0000043bu, ImmutableString("textureLod(00Z20B00B").mangledNameHash());
    ASSERT_EQ(0x000001a3u, ImmutableString("textureLod(00L20B00B").mangledNameHash());
    ASSERT_EQ(0x00000184u, ImmutableString("textureLod(00U20B00B").mangledNameHash());
    ASSERT_EQ(0x00000289u, ImmutableString("textureLod(00a20B00B").mangledNameHash());
    ASSERT_EQ(0x00000539u, ImmutableString("textureLod(00d20B00B").mangledNameHash());
    ASSERT_EQ(0x00000376u, ImmutableString("textureSize(00I00D").mangledNameHash());
    ASSERT_EQ(0x000004f7u, ImmutableString("textureSize(00R00D").mangledNameHash());
    ASSERT_EQ(0x00000318u, ImmutableString("textureSize(00X00D").mangledNameHash());
    ASSERT_EQ(0x00000551u, ImmutableString("textureSize(00J00D").mangledNameHash());
    ASSERT_EQ(0x00000246u, ImmutableString("textureSize(00S00D").mangledNameHash());
    ASSERT_EQ(0x000003e9u, ImmutableString("textureSize(00Y00D").mangledNameHash());
    ASSERT_EQ(0x00000013u, ImmutableString("textureSize(00K00D").mangledNameHash());
    ASSERT_EQ(0x00000177u, ImmutableString("textureSize(00T00D").mangledNameHash());
    ASSERT_EQ(0x000005deu, ImmutableString("textureSize(00Z00D").mangledNameHash());
    ASSERT_EQ(0x00000134u, ImmutableString("textureSize(00L00D").mangledNameHash());
    ASSERT_EQ(0x000003d6u, ImmutableString("textureSize(00U00D").mangledNameHash());
    ASSERT_EQ(0x00000158u, ImmutableString("textureSize(00a00D").mangledNameHash());
    ASSERT_EQ(0x0000047fu, ImmutableString("textureSize(00d00D").mangledNameHash());
    ASSERT_EQ(0x000000bfu, ImmutableString("textureSize(00e00D").mangledNameHash());
    ASSERT_EQ(0x00000143u, ImmutableString("textureSize(00f00D").mangledNameHash());
    ASSERT_EQ(0x000004e5u, ImmutableString("textureProjLod(00I20B00B").mangledNameHash());
    ASSERT_EQ(0x00000380u, ImmutableString("textureProjLod(00R20B00B").mangledNameHash());
    ASSERT_EQ(0x000005a5u, ImmutableString("textureProjLod(00X20B00B").mangledNameHash());
    ASSERT_EQ(0x000000bau, ImmutableString("textureProjLod(00I30B00B").mangledNameHash());
    ASSERT_EQ(0x0000025eu, ImmutableString("textureProjLod(00R30B00B").mangledNameHash());
    ASSERT_EQ(0x00000421u, ImmutableString("textureProjLod(00X30B00B").mangledNameHash());
    ASSERT_EQ(0x000004fdu, ImmutableString("textureProjLod(00J30B00B").mangledNameHash());
    ASSERT_EQ(0x000002f2u, ImmutableString("textureProjLod(00S30B00B").mangledNameHash());
    ASSERT_EQ(0x000003afu, ImmutableString("textureProjLod(00Y30B00B").mangledNameHash());
    ASSERT_EQ(0x000001f7u, ImmutableString("textureProjLod(00d30B00B").mangledNameHash());
    ASSERT_EQ(0x00000034u, ImmutableString("texelFetch(00I10D00D").mangledNameHash());
    ASSERT_EQ(0x00000166u, ImmutableString("texelFetch(00R10D00D").mangledNameHash());
    ASSERT_EQ(0x00000393u, ImmutableString("texelFetch(00X10D00D").mangledNameHash());
    ASSERT_EQ(0x00000195u, ImmutableString("texelFetch(00J20D00D").mangledNameHash());
    ASSERT_EQ(0x000005b5u, ImmutableString("texelFetch(00S20D00D").mangledNameHash());
    ASSERT_EQ(0x000000a9u, ImmutableString("texelFetch(00Y20D00D").mangledNameHash());
    ASSERT_EQ(0x000003d2u, ImmutableString("texelFetch(00L20D00D").mangledNameHash());
    ASSERT_EQ(0x0000022bu, ImmutableString("texelFetch(00U20D00D").mangledNameHash());
    ASSERT_EQ(0x000000c0u, ImmutableString("texelFetch(00a20D00D").mangledNameHash());
    ASSERT_EQ(0x00000336u, ImmutableString("textureGrad(00I10B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000016au, ImmutableString("textureGrad(00R10B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000103u, ImmutableString("textureGrad(00X10B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000055eu, ImmutableString("textureGrad(00J20B20B20B").mangledNameHash());
    ASSERT_EQ(0x0000051bu, ImmutableString("textureGrad(00S20B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000210u, ImmutableString("textureGrad(00Y20B20B20B").mangledNameHash());
    ASSERT_EQ(0x000005b4u, ImmutableString("textureGrad(00K20B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000179u, ImmutableString("textureGrad(00T20B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000092u, ImmutableString("textureGrad(00Z20B20B20B").mangledNameHash());
    ASSERT_EQ(0x000004e0u, ImmutableString("textureGrad(00d20B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000550u, ImmutableString("textureGrad(00e30B20B20B").mangledNameHash());
    ASSERT_EQ(0x0000035bu, ImmutableString("textureGrad(00L20B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000026au, ImmutableString("textureGrad(00U20B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000024cu, ImmutableString("textureGrad(00a20B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000040eu, ImmutableString("textureGrad(00f30B10B10B").mangledNameHash());
    ASSERT_EQ(0x000002fau, ImmutableString("textureProjGrad(00I20B10B10B").mangledNameHash());
    ASSERT_EQ(0x000002f3u, ImmutableString("textureProjGrad(00R20B10B10B").mangledNameHash());
    ASSERT_EQ(0x000003e8u, ImmutableString("textureProjGrad(00X20B10B10B").mangledNameHash());
    ASSERT_EQ(0x000004b2u, ImmutableString("textureProjGrad(00I30B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000515u, ImmutableString("textureProjGrad(00R30B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000019du, ImmutableString("textureProjGrad(00X30B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000086u, ImmutableString("textureProjGrad(00J30B20B20B").mangledNameHash());
    ASSERT_EQ(0x0000002cu, ImmutableString("textureProjGrad(00S30B20B20B").mangledNameHash());
    ASSERT_EQ(0x000001acu, ImmutableString("textureProjGrad(00Y30B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000251u, ImmutableString("textureProjGrad(00d30B10B10B").mangledNameHash());
    ASSERT_EQ(0x000005a1u, ImmutableString("textureSize(00P").mangledNameHash());
    ASSERT_EQ(0x000002aeu, ImmutableString("textureSize(00V").mangledNameHash());
    ASSERT_EQ(0x00000598u, ImmutableString("textureSize(00b").mangledNameHash());
    ASSERT_EQ(0x000005a0u, ImmutableString("textureSize(00Q").mangledNameHash());
    ASSERT_EQ(0x000005a4u, ImmutableString("textureSize(00W").mangledNameHash());
    ASSERT_EQ(0x00000597u, ImmutableString("textureSize(00c").mangledNameHash());
    ASSERT_EQ(0x000003b2u, ImmutableString("textureSize(00k00D").mangledNameHash());
    ASSERT_EQ(0x000004acu, ImmutableString("textureSize(00s00D").mangledNameHash());
    ASSERT_EQ(0x0000011eu, ImmutableString("textureSize(00x00D").mangledNameHash());
    ASSERT_EQ(0x000005c7u, ImmutableString("textureSize(00l00D").mangledNameHash());
    ASSERT_EQ(0x000000e5u, ImmutableString("texture(00k30B").mangledNameHash());
    ASSERT_EQ(0x000002a4u, ImmutableString("texture(00s30B").mangledNameHash());
    ASSERT_EQ(0x00000267u, ImmutableString("texture(00x30B").mangledNameHash());
    ASSERT_EQ(0x00000604u, ImmutableString("texture(00k30B00B").mangledNameHash());
    ASSERT_EQ(0x0000046cu, ImmutableString("texture(00s30B00B").mangledNameHash());
    ASSERT_EQ(0x000001bbu, ImmutableString("texture(00x30B00B").mangledNameHash());
    ASSERT_EQ(0x000004bdu, ImmutableString("texture(00l30B00B").mangledNameHash());
    ASSERT_EQ(0x00000293u, ImmutableString("textureLod(00k30B00B").mangledNameHash());
    ASSERT_EQ(0x00000243u, ImmutableString("textureLod(00s30B00B").mangledNameHash());
    ASSERT_EQ(0x00000594u, ImmutableString("textureLod(00x30B00B").mangledNameHash());
    ASSERT_EQ(0x000003feu, ImmutableString("textureGrad(00k30B20B20B").mangledNameHash());
    ASSERT_EQ(0x000005acu, ImmutableString("textureGrad(00s30B20B20B").mangledNameHash());
    ASSERT_EQ(0x0000051du, ImmutableString("textureGrad(00x30B20B20B").mangledNameHash());
    ASSERT_EQ(0x0000047bu, ImmutableString("textureGather(00k30B").mangledNameHash());
    ASSERT_EQ(0x00000419u, ImmutableString("textureGather(00s30B").mangledNameHash());
    ASSERT_EQ(0x000002d7u, ImmutableString("textureGather(00x30B").mangledNameHash());
    ASSERT_EQ(0x00000525u, ImmutableString("textureGather(00k30B00D").mangledNameHash());
    ASSERT_EQ(0x000001c9u, ImmutableString("textureGather(00s30B00D").mangledNameHash());
    ASSERT_EQ(0x000000b7u, ImmutableString("textureGather(00x30B00D").mangledNameHash());
    ASSERT_EQ(0x00000531u, ImmutableString("textureGather(00l30B00B").mangledNameHash());
    ASSERT_EQ(0x00000595u, ImmutableString("textureSize(00j").mangledNameHash());
    ASSERT_EQ(0x0000059au, ImmutableString("textureSize(00r").mangledNameHash());
    ASSERT_EQ(0x0000059bu, ImmutableString("textureSize(00w").mangledNameHash());
    ASSERT_EQ(0x000001f5u, ImmutableString("texelFetch(00j00D").mangledNameHash());
    ASSERT_EQ(0x00000433u, ImmutableString("texelFetch(00r00D").mangledNameHash());
    ASSERT_EQ(0x00000452u, ImmutableString("texelFetch(00w00D").mangledNameHash());
    ASSERT_EQ(0x00000362u, ImmutableString("texelFetch(00P10D00D").mangledNameHash());
    ASSERT_EQ(0x0000039fu, ImmutableString("texelFetch(00V10D00D").mangledNameHash());
    ASSERT_EQ(0x0000033au, ImmutableString("texelFetch(00b10D00D").mangledNameHash());
    ASSERT_EQ(0x0000044fu, ImmutableString("texelFetch(00Q20D00D").mangledNameHash());
    ASSERT_EQ(0x0000060fu, ImmutableString("texelFetch(00W20D00D").mangledNameHash());
    ASSERT_EQ(0x0000025cu, ImmutableString("texelFetch(00c20D00D").mangledNameHash());
    ASSERT_EQ(0x00000052u, ImmutableString("texture(00I10B00B").mangledNameHash());
    ASSERT_EQ(0x0000039cu, ImmutableString("texture(00R10B00B").mangledNameHash());
    ASSERT_EQ(0x000001e3u, ImmutableString("texture(00X10B00B").mangledNameHash());
    ASSERT_EQ(0x0000024du, ImmutableString("texture(00J20B00B").mangledNameHash());
    ASSERT_EQ(0x000004c6u, ImmutableString("texture(00S20B00B").mangledNameHash());
    ASSERT_EQ(0x000000aeu, ImmutableString("texture(00Y20B00B").mangledNameHash());
    ASSERT_EQ(0x0000055du, ImmutableString("texture(00K20B00B").mangledNameHash());
    ASSERT_EQ(0x0000037au, ImmutableString("texture(00T20B00B").mangledNameHash());
    ASSERT_EQ(0x00000172u, ImmutableString("texture(00Z20B00B").mangledNameHash());
    ASSERT_EQ(0x000000d5u, ImmutableString("texture(00L20B00B").mangledNameHash());
    ASSERT_EQ(0x0000023cu, ImmutableString("texture(00U20B00B").mangledNameHash());
    ASSERT_EQ(0x000004a2u, ImmutableString("texture(00a20B00B").mangledNameHash());
    ASSERT_EQ(0x000002c1u, ImmutableString("textureProj(00I20B00B").mangledNameHash());
    ASSERT_EQ(0x00000069u, ImmutableString("textureProj(00R20B00B").mangledNameHash());
    ASSERT_EQ(0x000002b4u, ImmutableString("textureProj(00X20B00B").mangledNameHash());
    ASSERT_EQ(0x00000294u, ImmutableString("textureProj(00I30B00B").mangledNameHash());
    ASSERT_EQ(0x00000000u, ImmutableString("textureProj(00R30B00B").mangledNameHash());
    ASSERT_EQ(0x00000590u, ImmutableString("textureProj(00X30B00B").mangledNameHash());
    ASSERT_EQ(0x0000033bu, ImmutableString("textureProj(00J30B00B").mangledNameHash());
    ASSERT_EQ(0x0000011fu, ImmutableString("textureProj(00S30B00B").mangledNameHash());
    ASSERT_EQ(0x000003e1u, ImmutableString("textureProj(00Y30B00B").mangledNameHash());
    ASSERT_EQ(0x00000409u, ImmutableString("texture(00d20B00B").mangledNameHash());
    ASSERT_EQ(0x00000367u, ImmutableString("texture(00e30B00B").mangledNameHash());
    ASSERT_EQ(0x0000049fu, ImmutableString("textureProj(00d30B00B").mangledNameHash());
    ASSERT_EQ(0x00000629u, ImmutableString("texture(00M10B00B").mangledNameHash());
    ASSERT_EQ(0x000004a3u, ImmutableString("textureProj(00M20B00B").mangledNameHash());
    ASSERT_EQ(0x00000334u, ImmutableString("textureProj(00M30B00B").mangledNameHash());
    ASSERT_EQ(0x000004afu, ImmutableString("texture(00N10B00B").mangledNameHash());
    ASSERT_EQ(0x000005edu, ImmutableString("textureProj(00N20B00B").mangledNameHash());
    ASSERT_EQ(0x0000004fu, ImmutableString("textureProj(00N30B00B").mangledNameHash());
    ASSERT_EQ(0x000001edu, ImmutableString("textureOffset(00I10B10D").mangledNameHash());
    ASSERT_EQ(0x0000028fu, ImmutableString("textureOffset(00R10B10D").mangledNameHash());
    ASSERT_EQ(0x0000010du, ImmutableString("textureOffset(00X10B10D").mangledNameHash());
    ASSERT_EQ(0x00000194u, ImmutableString("textureOffset(00J20B20D").mangledNameHash());
    ASSERT_EQ(0x0000018du, ImmutableString("textureOffset(00S20B20D").mangledNameHash());
    ASSERT_EQ(0x0000043du, ImmutableString("textureOffset(00Y20B20D").mangledNameHash());
    ASSERT_EQ(0x000004b4u, ImmutableString("textureOffset(00d20B10D").mangledNameHash());
    ASSERT_EQ(0x0000005au, ImmutableString("textureOffset(00L20B10D").mangledNameHash());
    ASSERT_EQ(0x00000352u, ImmutableString("textureOffset(00U20B10D").mangledNameHash());
    ASSERT_EQ(0x00000573u, ImmutableString("textureOffset(00a20B10D").mangledNameHash());
    ASSERT_EQ(0x00000382u, ImmutableString("textureProjOffset(00I20B10D").mangledNameHash());
    ASSERT_EQ(0x000001ecu, ImmutableString("textureProjOffset(00R20B10D").mangledNameHash());
    ASSERT_EQ(0x00000625u, ImmutableString("textureProjOffset(00X20B10D").mangledNameHash());
    ASSERT_EQ(0x0000010cu, ImmutableString("textureProjOffset(00I30B10D").mangledNameHash());
    ASSERT_EQ(0x00000621u, ImmutableString("textureProjOffset(00R30B10D").mangledNameHash());
    ASSERT_EQ(0x00000453u, ImmutableString("textureProjOffset(00X30B10D").mangledNameHash());
    ASSERT_EQ(0x0000048eu, ImmutableString("textureProjOffset(00J30B20D").mangledNameHash());
    ASSERT_EQ(0x0000005fu, ImmutableString("textureProjOffset(00S30B20D").mangledNameHash());
    ASSERT_EQ(0x00000159u, ImmutableString("textureProjOffset(00Y30B20D").mangledNameHash());
    ASSERT_EQ(0x0000030cu, ImmutableString("textureProjOffset(00d30B10D").mangledNameHash());
    ASSERT_EQ(0x0000034eu, ImmutableString("textureLodOffset(00I10B00B10D").mangledNameHash());
    ASSERT_EQ(0x00000498u, ImmutableString("textureLodOffset(00R10B00B10D").mangledNameHash());
    ASSERT_EQ(0x00000379u, ImmutableString("textureLodOffset(00X10B00B10D").mangledNameHash());
    ASSERT_EQ(0x00000284u, ImmutableString("textureLodOffset(00J20B00B20D").mangledNameHash());
    ASSERT_EQ(0x00000431u, ImmutableString("textureLodOffset(00S20B00B20D").mangledNameHash());
    ASSERT_EQ(0x00000545u, ImmutableString("textureLodOffset(00Y20B00B20D").mangledNameHash());
    ASSERT_EQ(0x000003e6u, ImmutableString("textureLodOffset(00d20B00B10D").mangledNameHash());
    ASSERT_EQ(0x0000061du, ImmutableString("textureLodOffset(00L20B00B10D").mangledNameHash());
    ASSERT_EQ(0x0000029du, ImmutableString("textureLodOffset(00U20B00B10D").mangledNameHash());
    ASSERT_EQ(0x0000001bu, ImmutableString("textureLodOffset(00a20B00B10D").mangledNameHash());
    ASSERT_EQ(0x0000060au, ImmutableString("textureProjLodOffset(00I20B00B10D").mangledNameHash());
    ASSERT_EQ(0x00000085u, ImmutableString("textureProjLodOffset(00R20B00B10D").mangledNameHash());
    ASSERT_EQ(0x0000023bu, ImmutableString("textureProjLodOffset(00X20B00B10D").mangledNameHash());
    ASSERT_EQ(0x00000476u, ImmutableString("textureProjLodOffset(00I30B00B10D").mangledNameHash());
    ASSERT_EQ(0x00000449u, ImmutableString("textureProjLodOffset(00R30B00B10D").mangledNameHash());
    ASSERT_EQ(0x00000305u, ImmutableString("textureProjLodOffset(00X30B00B10D").mangledNameHash());
    ASSERT_EQ(0x00000256u, ImmutableString("textureProjLodOffset(00J30B00B20D").mangledNameHash());
    ASSERT_EQ(0x000000a4u, ImmutableString("textureProjLodOffset(00S30B00B20D").mangledNameHash());
    ASSERT_EQ(0x00000563u, ImmutableString("textureProjLodOffset(00Y30B00B20D").mangledNameHash());
    ASSERT_EQ(0x00000473u, ImmutableString("textureProjLodOffset(00d30B00B10D").mangledNameHash());
    ASSERT_EQ(0x00000501u, ImmutableString("texelFetchOffset(00I10D00D10D").mangledNameHash());
    ASSERT_EQ(0x00000378u, ImmutableString("texelFetchOffset(00R10D00D10D").mangledNameHash());
    ASSERT_EQ(0x0000012eu, ImmutableString("texelFetchOffset(00X10D00D10D").mangledNameHash());
    ASSERT_EQ(0x0000002bu, ImmutableString("texelFetchOffset(00J20D00D20D").mangledNameHash());
    ASSERT_EQ(0x0000039au, ImmutableString("texelFetchOffset(00S20D00D20D").mangledNameHash());
    ASSERT_EQ(0x000001b7u, ImmutableString("texelFetchOffset(00Y20D00D20D").mangledNameHash());
    ASSERT_EQ(0x000005b8u, ImmutableString("texelFetchOffset(00L20D00D10D").mangledNameHash());
    ASSERT_EQ(0x00000306u, ImmutableString("texelFetchOffset(00U20D00D10D").mangledNameHash());
    ASSERT_EQ(0x00000080u, ImmutableString("texelFetchOffset(00a20D00D10D").mangledNameHash());
    ASSERT_EQ(0x00000283u, ImmutableString("textureGradOffset(00I10B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x00000207u, ImmutableString("textureGradOffset(00R10B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x0000012du, ImmutableString("textureGradOffset(00X10B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x000001cdu, ImmutableString("textureGradOffset(00J20B20B20B20D").mangledNameHash());
    ASSERT_EQ(0x000004f5u, ImmutableString("textureGradOffset(00S20B20B20B20D").mangledNameHash());
    ASSERT_EQ(0x0000040cu, ImmutableString("textureGradOffset(00Y20B20B20B20D").mangledNameHash());
    ASSERT_EQ(0x0000030au, ImmutableString("textureGradOffset(00d20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x000002e9u, ImmutableString("textureGradOffset(00L20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x000002e6u, ImmutableString("textureGradOffset(00U20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x00000241u, ImmutableString("textureGradOffset(00a20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x00000401u, ImmutableString("textureGradOffset(00f30B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x000001f9u,
              ImmutableString("textureProjGradOffset(00I20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x00000290u,
              ImmutableString("textureProjGradOffset(00R20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x000002a1u,
              ImmutableString("textureProjGradOffset(00X20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x00000422u,
              ImmutableString("textureProjGradOffset(00I30B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x000005b7u,
              ImmutableString("textureProjGradOffset(00R30B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x000005d8u,
              ImmutableString("textureProjGradOffset(00X30B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x00000634u,
              ImmutableString("textureProjGradOffset(00J30B20B20B20D").mangledNameHash());
    ASSERT_EQ(0x00000394u,
              ImmutableString("textureProjGradOffset(00S30B20B20B20D").mangledNameHash());
    ASSERT_EQ(0x00000178u,
              ImmutableString("textureProjGradOffset(00Y30B20B20B20D").mangledNameHash());
    ASSERT_EQ(0x0000010bu,
              ImmutableString("textureProjGradOffset(00d30B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x000005c8u, ImmutableString("textureOffset(00I10B10D00B").mangledNameHash());
    ASSERT_EQ(0x000000eeu, ImmutableString("textureOffset(00R10B10D00B").mangledNameHash());
    ASSERT_EQ(0x000000b1u, ImmutableString("textureOffset(00X10B10D00B").mangledNameHash());
    ASSERT_EQ(0x000005cdu, ImmutableString("textureOffset(00J20B20D00B").mangledNameHash());
    ASSERT_EQ(0x00000425u, ImmutableString("textureOffset(00S20B20D00B").mangledNameHash());
    ASSERT_EQ(0x000004f4u, ImmutableString("textureOffset(00Y20B20D00B").mangledNameHash());
    ASSERT_EQ(0x0000004au, ImmutableString("textureOffset(00d20B10D00B").mangledNameHash());
    ASSERT_EQ(0x000004fbu, ImmutableString("textureOffset(00L20B10D00B").mangledNameHash());
    ASSERT_EQ(0x00000560u, ImmutableString("textureOffset(00U20B10D00B").mangledNameHash());
    ASSERT_EQ(0x000000ebu, ImmutableString("textureOffset(00a20B10D00B").mangledNameHash());
    ASSERT_EQ(0x0000046eu, ImmutableString("textureProjOffset(00I20B10D00B").mangledNameHash());
    ASSERT_EQ(0x00000429u, ImmutableString("textureProjOffset(00R20B10D00B").mangledNameHash());
    ASSERT_EQ(0x00000517u, ImmutableString("textureProjOffset(00X20B10D00B").mangledNameHash());
    ASSERT_EQ(0x00000611u, ImmutableString("textureProjOffset(00I30B10D00B").mangledNameHash());
    ASSERT_EQ(0x0000031cu, ImmutableString("textureProjOffset(00R30B10D00B").mangledNameHash());
    ASSERT_EQ(0x000004a5u, ImmutableString("textureProjOffset(00X30B10D00B").mangledNameHash());
    ASSERT_EQ(0x000000fau, ImmutableString("textureProjOffset(00J30B20D00B").mangledNameHash());
    ASSERT_EQ(0x0000052au, ImmutableString("textureProjOffset(00S30B20D00B").mangledNameHash());
    ASSERT_EQ(0x00000038u, ImmutableString("textureProjOffset(00Y30B20D00B").mangledNameHash());
    ASSERT_EQ(0x0000017au, ImmutableString("textureProjOffset(00d30B10D00B").mangledNameHash());
    ASSERT_EQ(0x0000015eu, ImmutableString("texture(00M10B").mangledNameHash());
    ASSERT_EQ(0x0000021bu, ImmutableString("textureProj(00M20B").mangledNameHash());
    ASSERT_EQ(0x000002e8u, ImmutableString("textureProj(00M30B").mangledNameHash());
    ASSERT_EQ(0x000002e3u, ImmutableString("textureSize(00M00D").mangledNameHash());
    ASSERT_EQ(0x000004f2u, ImmutableString("texelFetch(00M10D00D").mangledNameHash());
    ASSERT_EQ(0x0000007cu, ImmutableString("texture(00N10B").mangledNameHash());
    ASSERT_EQ(0x00000302u, ImmutableString("textureProj(00N20B").mangledNameHash());
    ASSERT_EQ(0x0000028au, ImmutableString("textureProj(00N30B").mangledNameHash());
    ASSERT_EQ(0x000004e6u, ImmutableString("rgb_2_yuv(20B00H").mangledNameHash());
    ASSERT_EQ(0x00000339u, ImmutableString("yuv_2_rgb(20B00H").mangledNameHash());
    ASSERT_EQ(0x000003fau, ImmutableString("textureSize(00N00D").mangledNameHash());
    ASSERT_EQ(0x00000157u, ImmutableString("texelFetch(00N10D00D").mangledNameHash());
    ASSERT_EQ(0x000005adu, ImmutableString("textureGather(00I10B").mangledNameHash());
    ASSERT_EQ(0x0000033cu, ImmutableString("textureGather(00R10B").mangledNameHash());
    ASSERT_EQ(0x000000edu, ImmutableString("textureGather(00X10B").mangledNameHash());
    ASSERT_EQ(0x0000039eu, ImmutableString("textureGather(00I10B00D").mangledNameHash());
    ASSERT_EQ(0x000005ddu, ImmutableString("textureGather(00R10B00D").mangledNameHash());
    ASSERT_EQ(0x0000056eu, ImmutableString("textureGather(00X10B00D").mangledNameHash());
    ASSERT_EQ(0x000000a5u, ImmutableString("textureGather(00L20B").mangledNameHash());
    ASSERT_EQ(0x0000044eu, ImmutableString("textureGather(00U20B").mangledNameHash());
    ASSERT_EQ(0x00000272u, ImmutableString("textureGather(00a20B").mangledNameHash());
    ASSERT_EQ(0x00000074u, ImmutableString("textureGather(00L20B00D").mangledNameHash());
    ASSERT_EQ(0x0000031du, ImmutableString("textureGather(00U20B00D").mangledNameHash());
    ASSERT_EQ(0x000004abu, ImmutableString("textureGather(00a20B00D").mangledNameHash());
    ASSERT_EQ(0x0000060bu, ImmutableString("textureGather(00K20B").mangledNameHash());
    ASSERT_EQ(0x00000633u, ImmutableString("textureGather(00T20B").mangledNameHash());
    ASSERT_EQ(0x000005bdu, ImmutableString("textureGather(00Z20B").mangledNameHash());
    ASSERT_EQ(0x000002ffu, ImmutableString("textureGather(00K20B00D").mangledNameHash());
    ASSERT_EQ(0x00000301u, ImmutableString("textureGather(00T20B00D").mangledNameHash());
    ASSERT_EQ(0x000002dau, ImmutableString("textureGather(00Z20B00D").mangledNameHash());
    ASSERT_EQ(0x0000054bu, ImmutableString("textureGather(00d10B").mangledNameHash());
    ASSERT_EQ(0x000005e5u, ImmutableString("textureGather(00d10B00B").mangledNameHash());
    ASSERT_EQ(0x0000049eu, ImmutableString("textureGather(00f20B").mangledNameHash());
    ASSERT_EQ(0x000000b8u, ImmutableString("textureGather(00f20B00B").mangledNameHash());
    ASSERT_EQ(0x000002fbu, ImmutableString("textureGather(00e20B").mangledNameHash());
    ASSERT_EQ(0x00000090u, ImmutableString("textureGather(00e20B00B").mangledNameHash());
    ASSERT_EQ(0x00000608u,
              ImmutableString("textureGatherOffsets(00I10B10Dx400D").mangledNameHash());
    ASSERT_EQ(0x00000638u,
              ImmutableString("textureGatherOffsets(00R10B10Dx400D").mangledNameHash());
    ASSERT_EQ(0x0000006bu,
              ImmutableString("textureGatherOffsets(00X10B10Dx400D").mangledNameHash());
    ASSERT_EQ(0x0000008cu,
              ImmutableString("textureGatherOffsets(00L20B10Dx400D").mangledNameHash());
    ASSERT_EQ(0x000004b6u,
              ImmutableString("textureGatherOffsets(00U20B10Dx400D").mangledNameHash());
    ASSERT_EQ(0x0000026cu,
              ImmutableString("textureGatherOffsets(00a20B10Dx400D").mangledNameHash());
    ASSERT_EQ(0x000000f7u, ImmutableString("textureGatherOffsets(00I10B10Dx4").mangledNameHash());
    ASSERT_EQ(0x0000057du, ImmutableString("textureGatherOffsets(00R10B10Dx4").mangledNameHash());
    ASSERT_EQ(0x0000034cu, ImmutableString("textureGatherOffsets(00X10B10Dx4").mangledNameHash());
    ASSERT_EQ(0x0000045du, ImmutableString("textureGatherOffsets(00L20B10Dx4").mangledNameHash());
    ASSERT_EQ(0x000003eeu, ImmutableString("textureGatherOffsets(00U20B10Dx4").mangledNameHash());
    ASSERT_EQ(0x0000022fu, ImmutableString("textureGatherOffsets(00a20B10Dx4").mangledNameHash());
    ASSERT_EQ(0x0000008au,
              ImmutableString("textureGatherOffsets(00d10B00B10Dx4").mangledNameHash());
    ASSERT_EQ(0x00000111u,
              ImmutableString("textureGatherOffsets(00f20B00B10Dx4").mangledNameHash());
    ASSERT_EQ(0x000003e4u, ImmutableString("textureGatherOffset(00I10B10D00D").mangledNameHash());
    ASSERT_EQ(0x000000cau, ImmutableString("textureGatherOffset(00R10B10D00D").mangledNameHash());
    ASSERT_EQ(0x00000618u, ImmutableString("textureGatherOffset(00X10B10D00D").mangledNameHash());
    ASSERT_EQ(0x000001b2u, ImmutableString("textureGatherOffset(00L20B10D00D").mangledNameHash());
    ASSERT_EQ(0x0000039du, ImmutableString("textureGatherOffset(00U20B10D00D").mangledNameHash());
    ASSERT_EQ(0x00000058u, ImmutableString("textureGatherOffset(00a20B10D00D").mangledNameHash());
    ASSERT_EQ(0x00000059u, ImmutableString("textureGatherOffset(00I10B10D").mangledNameHash());
    ASSERT_EQ(0x0000060cu, ImmutableString("textureGatherOffset(00R10B10D").mangledNameHash());
    ASSERT_EQ(0x0000045bu, ImmutableString("textureGatherOffset(00X10B10D").mangledNameHash());
    ASSERT_EQ(0x0000000cu, ImmutableString("textureGatherOffset(00L20B10D").mangledNameHash());
    ASSERT_EQ(0x000002b5u, ImmutableString("textureGatherOffset(00U20B10D").mangledNameHash());
    ASSERT_EQ(0x0000040du, ImmutableString("textureGatherOffset(00a20B10D").mangledNameHash());
    ASSERT_EQ(0x000000efu, ImmutableString("textureGatherOffset(00d10B00B10D").mangledNameHash());
    ASSERT_EQ(0x00000248u, ImmutableString("textureGatherOffset(00f20B00B10D").mangledNameHash());
    ASSERT_EQ(0x0000035cu, ImmutableString("interpolateAtCentroid(00B").mangledNameHash());
    ASSERT_EQ(0x000002e2u, ImmutableString("interpolateAtCentroid(10B").mangledNameHash());
    ASSERT_EQ(0x000000c8u, ImmutableString("interpolateAtCentroid(20B").mangledNameHash());
    ASSERT_EQ(0x000003c5u, ImmutableString("interpolateAtCentroid(30B").mangledNameHash());
    ASSERT_EQ(0x0000051fu, ImmutableString("interpolateAtSample(00B00D").mangledNameHash());
    ASSERT_EQ(0x000000e1u, ImmutableString("interpolateAtSample(10B00D").mangledNameHash());
    ASSERT_EQ(0x000001fau, ImmutableString("interpolateAtSample(20B00D").mangledNameHash());
    ASSERT_EQ(0x000001ddu, ImmutableString("interpolateAtSample(30B00D").mangledNameHash());
    ASSERT_EQ(0x00000068u, ImmutableString("interpolateAtOffset(00B10B").mangledNameHash());
    ASSERT_EQ(0x00000455u, ImmutableString("interpolateAtOffset(10B10B").mangledNameHash());
    ASSERT_EQ(0x000003c1u, ImmutableString("interpolateAtOffset(20B10B").mangledNameHash());
    ASSERT_EQ(0x00000001u, ImmutableString("interpolateAtOffset(30B10B").mangledNameHash());
    ASSERT_EQ(0x00000507u, ImmutableString("atomicCounter(00G").mangledNameHash());
    ASSERT_EQ(0x00000482u, ImmutableString("atomicCounterIncrement(00G").mangledNameHash());
    ASSERT_EQ(0x00000160u, ImmutableString("atomicCounterDecrement(00G").mangledNameHash());
    ASSERT_EQ(0x00000101u, ImmutableString("atomicAdd(00E00E").mangledNameHash());
    ASSERT_EQ(0x00000021u, ImmutableString("atomicAdd(00D00D").mangledNameHash());
    ASSERT_EQ(0x0000022du, ImmutableString("atomicMin(00E00E").mangledNameHash());
    ASSERT_EQ(0x00000317u, ImmutableString("atomicMin(00D00D").mangledNameHash());
    ASSERT_EQ(0x00000620u, ImmutableString("atomicMax(00E00E").mangledNameHash());
    ASSERT_EQ(0x00000373u, ImmutableString("atomicMax(00D00D").mangledNameHash());
    ASSERT_EQ(0x000004ffu, ImmutableString("atomicAnd(00E00E").mangledNameHash());
    ASSERT_EQ(0x00000354u, ImmutableString("atomicAnd(00D00D").mangledNameHash());
    ASSERT_EQ(0x000003deu, ImmutableString("atomicOr(00E00E").mangledNameHash());
    ASSERT_EQ(0x000002aau, ImmutableString("atomicOr(00D00D").mangledNameHash());
    ASSERT_EQ(0x00000119u, ImmutableString("atomicXor(00E00E").mangledNameHash());
    ASSERT_EQ(0x000000a8u, ImmutableString("atomicXor(00D00D").mangledNameHash());
    ASSERT_EQ(0x000001b8u, ImmutableString("atomicExchange(00E00E").mangledNameHash());
    ASSERT_EQ(0x0000057eu, ImmutableString("atomicExchange(00D00D").mangledNameHash());
    ASSERT_EQ(0x0000020fu, ImmutableString("atomicCompSwap(00E00E00E").mangledNameHash());
    ASSERT_EQ(0x00000286u, ImmutableString("atomicCompSwap(00D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000024bu, ImmutableString("imageSize(00z").mangledNameHash());
    ASSERT_EQ(0x000002c4u, ImmutableString("imageSize(01A").mangledNameHash());
    ASSERT_EQ(0x000002c2u, ImmutableString("imageSize(01B").mangledNameHash());
    ASSERT_EQ(0x000002c3u, ImmutableString("imageSize(01C").mangledNameHash());
    ASSERT_EQ(0x000002c7u, ImmutableString("imageSize(01D").mangledNameHash());
    ASSERT_EQ(0x000002c8u, ImmutableString("imageSize(01E").mangledNameHash());
    ASSERT_EQ(0x000002c5u, ImmutableString("imageSize(01F").mangledNameHash());
    ASSERT_EQ(0x000002c6u, ImmutableString("imageSize(01G").mangledNameHash());
    ASSERT_EQ(0x000002beu, ImmutableString("imageSize(01H").mangledNameHash());
    ASSERT_EQ(0x000002bfu, ImmutableString("imageSize(01I").mangledNameHash());
    ASSERT_EQ(0x000002bcu, ImmutableString("imageSize(01J").mangledNameHash());
    ASSERT_EQ(0x000002bdu, ImmutableString("imageSize(01K").mangledNameHash());
    ASSERT_EQ(0x000002d2u, ImmutableString("imageSize(01a").mangledNameHash());
    ASSERT_EQ(0x000004d1u, ImmutableString("imageSize(01b").mangledNameHash());
    ASSERT_EQ(0x000002d1u, ImmutableString("imageSize(01c").mangledNameHash());
    ASSERT_EQ(0x000002d3u, ImmutableString("imageSize(01g").mangledNameHash());
    ASSERT_EQ(0x000002cdu, ImmutableString("imageSize(01h").mangledNameHash());
    ASSERT_EQ(0x000002ceu, ImmutableString("imageSize(01i").mangledNameHash());
    ASSERT_EQ(0x0000026bu, ImmutableString("imageLoad(00z10D").mangledNameHash());
    ASSERT_EQ(0x000004a4u, ImmutableString("imageLoad(01A10D").mangledNameHash());
    ASSERT_EQ(0x0000048cu, ImmutableString("imageLoad(01B10D").mangledNameHash());
    ASSERT_EQ(0x0000052eu, ImmutableString("imageLoad(01C20D").mangledNameHash());
    ASSERT_EQ(0x00000170u, ImmutableString("imageLoad(01D20D").mangledNameHash());
    ASSERT_EQ(0x000005ecu, ImmutableString("imageLoad(01E20D").mangledNameHash());
    ASSERT_EQ(0x0000001du, ImmutableString("imageLoad(01F20D").mangledNameHash());
    ASSERT_EQ(0x0000058au, ImmutableString("imageLoad(01G20D").mangledNameHash());
    ASSERT_EQ(0x000001f8u, ImmutableString("imageLoad(01H20D").mangledNameHash());
    ASSERT_EQ(0x00000007u, ImmutableString("imageLoad(01I20D").mangledNameHash());
    ASSERT_EQ(0x000000e0u, ImmutableString("imageLoad(01J20D").mangledNameHash());
    ASSERT_EQ(0x00000089u, ImmutableString("imageLoad(01K20D").mangledNameHash());
    ASSERT_EQ(0x0000031fu, ImmutableString("imageLoad(01a20D").mangledNameHash());
    ASSERT_EQ(0x000004fau, ImmutableString("imageLoad(01b20D").mangledNameHash());
    ASSERT_EQ(0x00000269u, ImmutableString("imageLoad(01c20D").mangledNameHash());
    ASSERT_EQ(0x00000006u, ImmutableString("imageLoad(01g00D").mangledNameHash());
    ASSERT_EQ(0x000000dau, ImmutableString("imageLoad(01h00D").mangledNameHash());
    ASSERT_EQ(0x000001d6u, ImmutableString("imageLoad(01i00D").mangledNameHash());
    ASSERT_EQ(0x0000000eu, ImmutableString("imageAtomicAdd(00z10D00E").mangledNameHash());
    ASSERT_EQ(0x0000062eu, ImmutableString("imageAtomicAdd(01A10D00E").mangledNameHash());
    ASSERT_EQ(0x00000149u, ImmutableString("imageAtomicAdd(01B10D00E").mangledNameHash());
    ASSERT_EQ(0x00000263u, ImmutableString("imageAtomicAdd(01C20D00E").mangledNameHash());
    ASSERT_EQ(0x0000052cu, ImmutableString("imageAtomicAdd(01D20D00E").mangledNameHash());
    ASSERT_EQ(0x00000543u, ImmutableString("imageAtomicAdd(01E20D00E").mangledNameHash());
    ASSERT_EQ(0x000000d3u, ImmutableString("imageAtomicAdd(01I20D00E").mangledNameHash());
    ASSERT_EQ(0x00000484u, ImmutableString("imageAtomicAdd(01J20D00E").mangledNameHash());
    ASSERT_EQ(0x0000041fu, ImmutableString("imageAtomicAdd(01K20D00E").mangledNameHash());
    ASSERT_EQ(0x0000018bu, ImmutableString("imageAtomicAdd(01g00D00E").mangledNameHash());
    ASSERT_EQ(0x00000180u, ImmutableString("imageAtomicAdd(01h00D00E").mangledNameHash());
    ASSERT_EQ(0x00000413u, ImmutableString("imageAtomicAdd(01i00D00E").mangledNameHash());
    ASSERT_EQ(0x000004c5u, ImmutableString("imageAtomicAdd(01F20D00E").mangledNameHash());
    ASSERT_EQ(0x000002b0u, ImmutableString("imageAtomicAdd(01G20D00E").mangledNameHash());
    ASSERT_EQ(0x00000511u, ImmutableString("imageAtomicAdd(01H20D00E").mangledNameHash());
    ASSERT_EQ(0x000002fdu, ImmutableString("imageAtomicAdd(01a20D00E").mangledNameHash());
    ASSERT_EQ(0x00000448u, ImmutableString("imageAtomicAdd(01b20D00E").mangledNameHash());
    ASSERT_EQ(0x0000053au, ImmutableString("imageAtomicAdd(01c20D00E").mangledNameHash());
    ASSERT_EQ(0x000001d4u, ImmutableString("imageAtomicAdd(01L00D00E").mangledNameHash());
    ASSERT_EQ(0x000005a2u, ImmutableString("imageAtomicAdd(01M00D00E").mangledNameHash());
    ASSERT_EQ(0x000000cfu, ImmutableString("imageAtomicAdd(01N00D00E").mangledNameHash());
    ASSERT_EQ(0x00000442u, ImmutableString("imageAtomicAdd(01O10D00E").mangledNameHash());
    ASSERT_EQ(0x00000536u, ImmutableString("imageAtomicAdd(01P10D00E").mangledNameHash());
    ASSERT_EQ(0x00000557u, ImmutableString("imageAtomicAdd(01Q10D00E").mangledNameHash());
    ASSERT_EQ(0x000000dcu, ImmutableString("imageAtomicAdd(01X10D00E").mangledNameHash());
    ASSERT_EQ(0x00000115u, ImmutableString("imageAtomicAdd(01Y10D00E").mangledNameHash());
    ASSERT_EQ(0x0000021du, ImmutableString("imageAtomicAdd(01Z10D00E").mangledNameHash());
    ASSERT_EQ(0x00000278u, ImmutableString("imageAtomicAdd(01R10D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000056u, ImmutableString("imageAtomicAdd(01S10D00D00E").mangledNameHash());
    ASSERT_EQ(0x000005e7u, ImmutableString("imageAtomicAdd(01T10D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000487u, ImmutableString("imageAtomicAdd(01U20D00D00E").mangledNameHash());
    ASSERT_EQ(0x0000016du, ImmutableString("imageAtomicAdd(01V20D00D00E").mangledNameHash());
    ASSERT_EQ(0x000001adu, ImmutableString("imageAtomicAdd(01W20D00D00E").mangledNameHash());
    ASSERT_EQ(0x0000004eu, ImmutableString("imageAtomicAdd(00z10D00D").mangledNameHash());
    ASSERT_EQ(0x0000062du, ImmutableString("imageAtomicAdd(01A10D00D").mangledNameHash());
    ASSERT_EQ(0x0000014au, ImmutableString("imageAtomicAdd(01B10D00D").mangledNameHash());
    ASSERT_EQ(0x00000264u, ImmutableString("imageAtomicAdd(01C20D00D").mangledNameHash());
    ASSERT_EQ(0x0000052bu, ImmutableString("imageAtomicAdd(01D20D00D").mangledNameHash());
    ASSERT_EQ(0x00000544u, ImmutableString("imageAtomicAdd(01E20D00D").mangledNameHash());
    ASSERT_EQ(0x000000d4u, ImmutableString("imageAtomicAdd(01I20D00D").mangledNameHash());
    ASSERT_EQ(0x00000483u, ImmutableString("imageAtomicAdd(01J20D00D").mangledNameHash());
    ASSERT_EQ(0x00000420u, ImmutableString("imageAtomicAdd(01K20D00D").mangledNameHash());
    ASSERT_EQ(0x0000018cu, ImmutableString("imageAtomicAdd(01g00D00D").mangledNameHash());
    ASSERT_EQ(0x0000017fu, ImmutableString("imageAtomicAdd(01h00D00D").mangledNameHash());
    ASSERT_EQ(0x00000414u, ImmutableString("imageAtomicAdd(01i00D00D").mangledNameHash());
    ASSERT_EQ(0x000004c4u, ImmutableString("imageAtomicAdd(01F20D00D").mangledNameHash());
    ASSERT_EQ(0x000002b1u, ImmutableString("imageAtomicAdd(01G20D00D").mangledNameHash());
    ASSERT_EQ(0x00000510u, ImmutableString("imageAtomicAdd(01H20D00D").mangledNameHash());
    ASSERT_EQ(0x000002feu, ImmutableString("imageAtomicAdd(01a20D00D").mangledNameHash());
    ASSERT_EQ(0x00000447u, ImmutableString("imageAtomicAdd(01b20D00D").mangledNameHash());
    ASSERT_EQ(0x0000053bu, ImmutableString("imageAtomicAdd(01c20D00D").mangledNameHash());
    ASSERT_EQ(0x000001d3u, ImmutableString("imageAtomicAdd(01L00D00D").mangledNameHash());
    ASSERT_EQ(0x000005a3u, ImmutableString("imageAtomicAdd(01M00D00D").mangledNameHash());
    ASSERT_EQ(0x000000ceu, ImmutableString("imageAtomicAdd(01N00D00D").mangledNameHash());
    ASSERT_EQ(0x00000441u, ImmutableString("imageAtomicAdd(01O10D00D").mangledNameHash());
    ASSERT_EQ(0x00000537u, ImmutableString("imageAtomicAdd(01P10D00D").mangledNameHash());
    ASSERT_EQ(0x00000556u, ImmutableString("imageAtomicAdd(01Q10D00D").mangledNameHash());
    ASSERT_EQ(0x000000ddu, ImmutableString("imageAtomicAdd(01X10D00D").mangledNameHash());
    ASSERT_EQ(0x00000114u, ImmutableString("imageAtomicAdd(01Y10D00D").mangledNameHash());
    ASSERT_EQ(0x0000021eu, ImmutableString("imageAtomicAdd(01Z10D00D").mangledNameHash());
    ASSERT_EQ(0x00000277u, ImmutableString("imageAtomicAdd(01R10D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000049au, ImmutableString("imageAtomicAdd(01S10D00D00D").mangledNameHash());
    ASSERT_EQ(0x000005e6u, ImmutableString("imageAtomicAdd(01T10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000486u, ImmutableString("imageAtomicAdd(01U20D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000016eu, ImmutableString("imageAtomicAdd(01V20D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000423u, ImmutableString("imageAtomicAdd(01W20D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000041au, ImmutableString("imageAtomicMin(00z10D00E").mangledNameHash());
    ASSERT_EQ(0x000003ffu, ImmutableString("imageAtomicMin(01A10D00E").mangledNameHash());
    ASSERT_EQ(0x0000017cu, ImmutableString("imageAtomicMin(01B10D00E").mangledNameHash());
    ASSERT_EQ(0x00000053u, ImmutableString("imageAtomicMin(01C20D00E").mangledNameHash());
    ASSERT_EQ(0x00000308u, ImmutableString("imageAtomicMin(01D20D00E").mangledNameHash());
    ASSERT_EQ(0x0000043au, ImmutableString("imageAtomicMin(01E20D00E").mangledNameHash());
    ASSERT_EQ(0x00000548u, ImmutableString("imageAtomicMin(01I20D00E").mangledNameHash());
    ASSERT_EQ(0x00000121u, ImmutableString("imageAtomicMin(01J20D00E").mangledNameHash());
    ASSERT_EQ(0x0000026fu, ImmutableString("imageAtomicMin(01K20D00E").mangledNameHash());
    ASSERT_EQ(0x0000059fu, ImmutableString("imageAtomicMin(01g00D00E").mangledNameHash());
    ASSERT_EQ(0x000000cbu, ImmutableString("imageAtomicMin(01h00D00E").mangledNameHash());
    ASSERT_EQ(0x00000497u, ImmutableString("imageAtomicMin(01i00D00E").mangledNameHash());
    ASSERT_EQ(0x000000e2u, ImmutableString("imageAtomicMin(01F20D00E").mangledNameHash());
    ASSERT_EQ(0x000001dau, ImmutableString("imageAtomicMin(01G20D00E").mangledNameHash());
    ASSERT_EQ(0x0000019bu, ImmutableString("imageAtomicMin(01H20D00E").mangledNameHash());
    ASSERT_EQ(0x000004dfu, ImmutableString("imageAtomicMin(01a20D00E").mangledNameHash());
    ASSERT_EQ(0x000001e7u, ImmutableString("imageAtomicMin(01b20D00E").mangledNameHash());
    ASSERT_EQ(0x000003b1u, ImmutableString("imageAtomicMin(01c20D00E").mangledNameHash());
    ASSERT_EQ(0x000004ceu, ImmutableString("imageAtomicMin(01L00D00E").mangledNameHash());
    ASSERT_EQ(0x00000366u, ImmutableString("imageAtomicMin(01M00D00E").mangledNameHash());
    ASSERT_EQ(0x00000205u, ImmutableString("imageAtomicMin(01N00D00E").mangledNameHash());
    ASSERT_EQ(0x00000368u, ImmutableString("imageAtomicMin(01O10D00E").mangledNameHash());
    ASSERT_EQ(0x00000262u, ImmutableString("imageAtomicMin(01P10D00E").mangledNameHash());
    ASSERT_EQ(0x0000027au, ImmutableString("imageAtomicMin(01Q10D00E").mangledNameHash());
    ASSERT_EQ(0x000000beu, ImmutableString("imageAtomicMin(01X10D00E").mangledNameHash());
    ASSERT_EQ(0x00000024u, ImmutableString("imageAtomicMin(01Y10D00E").mangledNameHash());
    ASSERT_EQ(0x00000503u, ImmutableString("imageAtomicMin(01Z10D00E").mangledNameHash());
    ASSERT_EQ(0x00000036u, ImmutableString("imageAtomicMin(01R10D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000529u, ImmutableString("imageAtomicMin(01S10D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000238u, ImmutableString("imageAtomicMin(01T10D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000554u, ImmutableString("imageAtomicMin(01U20D00D00E").mangledNameHash());
    ASSERT_EQ(0x000004b8u, ImmutableString("imageAtomicMin(01V20D00D00E").mangledNameHash());
    ASSERT_EQ(0x000005c1u, ImmutableString("imageAtomicMin(01W20D00D00E").mangledNameHash());
    ASSERT_EQ(0x0000041bu, ImmutableString("imageAtomicMin(00z10D00D").mangledNameHash());
    ASSERT_EQ(0x00000400u, ImmutableString("imageAtomicMin(01A10D00D").mangledNameHash());
    ASSERT_EQ(0x0000017bu, ImmutableString("imageAtomicMin(01B10D00D").mangledNameHash());
    ASSERT_EQ(0x000001f4u, ImmutableString("imageAtomicMin(01C20D00D").mangledNameHash());
    ASSERT_EQ(0x00000309u, ImmutableString("imageAtomicMin(01D20D00D").mangledNameHash());
    ASSERT_EQ(0x00000439u, ImmutableString("imageAtomicMin(01E20D00D").mangledNameHash());
    ASSERT_EQ(0x0000009cu, ImmutableString("imageAtomicMin(01I20D00D").mangledNameHash());
    ASSERT_EQ(0x000002d5u, ImmutableString("imageAtomicMin(01J20D00D").mangledNameHash());
    ASSERT_EQ(0x00000385u, ImmutableString("imageAtomicMin(01K20D00D").mangledNameHash());
    ASSERT_EQ(0x0000059eu, ImmutableString("imageAtomicMin(01g00D00D").mangledNameHash());
    ASSERT_EQ(0x000000ccu, ImmutableString("imageAtomicMin(01h00D00D").mangledNameHash());
    ASSERT_EQ(0x00000496u, ImmutableString("imageAtomicMin(01i00D00D").mangledNameHash());
    ASSERT_EQ(0x000000e3u, ImmutableString("imageAtomicMin(01F20D00D").mangledNameHash());
    ASSERT_EQ(0x000001d9u, ImmutableString("imageAtomicMin(01G20D00D").mangledNameHash());
    ASSERT_EQ(0x0000019cu, ImmutableString("imageAtomicMin(01H20D00D").mangledNameHash());
    ASSERT_EQ(0x000004deu, ImmutableString("imageAtomicMin(01a20D00D").mangledNameHash());
    ASSERT_EQ(0x000001e8u, ImmutableString("imageAtomicMin(01b20D00D").mangledNameHash());
    ASSERT_EQ(0x000003b0u, ImmutableString("imageAtomicMin(01c20D00D").mangledNameHash());
    ASSERT_EQ(0x000004cfu, ImmutableString("imageAtomicMin(01L00D00D").mangledNameHash());
    ASSERT_EQ(0x00000365u, ImmutableString("imageAtomicMin(01M00D00D").mangledNameHash());
    ASSERT_EQ(0x00000206u, ImmutableString("imageAtomicMin(01N00D00D").mangledNameHash());
    ASSERT_EQ(0x00000369u, ImmutableString("imageAtomicMin(01O10D00D").mangledNameHash());
    ASSERT_EQ(0x00000261u, ImmutableString("imageAtomicMin(01P10D00D").mangledNameHash());
    ASSERT_EQ(0x0000027bu, ImmutableString("imageAtomicMin(01Q10D00D").mangledNameHash());
    ASSERT_EQ(0x000000bdu, ImmutableString("imageAtomicMin(01X10D00D").mangledNameHash());
    ASSERT_EQ(0x00000025u, ImmutableString("imageAtomicMin(01Y10D00D").mangledNameHash());
    ASSERT_EQ(0x00000502u, ImmutableString("imageAtomicMin(01Z10D00D").mangledNameHash());
    ASSERT_EQ(0x00000037u, ImmutableString("imageAtomicMin(01R10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000528u, ImmutableString("imageAtomicMin(01S10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000239u, ImmutableString("imageAtomicMin(01T10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000555u, ImmutableString("imageAtomicMin(01U20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000004b7u, ImmutableString("imageAtomicMin(01V20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000005c2u, ImmutableString("imageAtomicMin(01W20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000002f6u, ImmutableString("imageAtomicMax(00z10D00E").mangledNameHash());
    ASSERT_EQ(0x000000a0u, ImmutableString("imageAtomicMax(01A10D00E").mangledNameHash());
    ASSERT_EQ(0x00000466u, ImmutableString("imageAtomicMax(01B10D00E").mangledNameHash());
    ASSERT_EQ(0x00000530u, ImmutableString("imageAtomicMax(01C20D00E").mangledNameHash());
    ASSERT_EQ(0x00000222u, ImmutableString("imageAtomicMax(01D20D00E").mangledNameHash());
    ASSERT_EQ(0x00000304u, ImmutableString("imageAtomicMax(01E20D00E").mangledNameHash());
    ASSERT_EQ(0x000003e3u, ImmutableString("imageAtomicMax(01I20D00E").mangledNameHash());
    ASSERT_EQ(0x0000057bu, ImmutableString("imageAtomicMax(01J20D00E").mangledNameHash());
    ASSERT_EQ(0x0000037eu, ImmutableString("imageAtomicMax(01K20D00E").mangledNameHash());
    ASSERT_EQ(0x0000046bu, ImmutableString("imageAtomicMax(01g00D00E").mangledNameHash());
    ASSERT_EQ(0x00000564u, ImmutableString("imageAtomicMax(01h00D00E").mangledNameHash());
    ASSERT_EQ(0x00000280u, ImmutableString("imageAtomicMax(01i00D00E").mangledNameHash());
    ASSERT_EQ(0x000003a9u, ImmutableString("imageAtomicMax(01F20D00E").mangledNameHash());
    ASSERT_EQ(0x00000460u, ImmutableString("imageAtomicMax(01G20D00E").mangledNameHash());
    ASSERT_EQ(0x00000258u, ImmutableString("imageAtomicMax(01H20D00E").mangledNameHash());
    ASSERT_EQ(0x000003a5u, ImmutableString("imageAtomicMax(01a20D00E").mangledNameHash());
    ASSERT_EQ(0x0000015bu, ImmutableString("imageAtomicMax(01b20D00E").mangledNameHash());
    ASSERT_EQ(0x0000045eu, ImmutableString("imageAtomicMax(01c20D00E").mangledNameHash());
    ASSERT_EQ(0x0000056fu, ImmutableString("imageAtomicMax(01L00D00E").mangledNameHash());
    ASSERT_EQ(0x00000542u, ImmutableString("imageAtomicMax(01M00D00E").mangledNameHash());
    ASSERT_EQ(0x000004d4u, ImmutableString("imageAtomicMax(01N00D00E").mangledNameHash());
    ASSERT_EQ(0x00000325u, ImmutableString("imageAtomicMax(01O10D00E").mangledNameHash());
    ASSERT_EQ(0x000001eau, ImmutableString("imageAtomicMax(01P10D00E").mangledNameHash());
    ASSERT_EQ(0x0000053eu, ImmutableString("imageAtomicMax(01Q10D00E").mangledNameHash());
    ASSERT_EQ(0x0000036cu, ImmutableString("imageAtomicMax(01X10D00E").mangledNameHash());
    ASSERT_EQ(0x00000071u, ImmutableString("imageAtomicMax(01Y10D00E").mangledNameHash());
    ASSERT_EQ(0x0000006du, ImmutableString("imageAtomicMax(01Z10D00E").mangledNameHash());
    ASSERT_EQ(0x000000deu, ImmutableString("imageAtomicMax(01R10D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000029u, ImmutableString("imageAtomicMax(01S10D00D00E").mangledNameHash());
    ASSERT_EQ(0x000001c1u, ImmutableString("imageAtomicMax(01T10D00D00E").mangledNameHash());
    ASSERT_EQ(0x000000f4u, ImmutableString("imageAtomicMax(01U20D00D00E").mangledNameHash());
    ASSERT_EQ(0x000002f9u, ImmutableString("imageAtomicMax(01V20D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000427u, ImmutableString("imageAtomicMax(01W20D00D00E").mangledNameHash());
    ASSERT_EQ(0x000002f7u, ImmutableString("imageAtomicMax(00z10D00D").mangledNameHash());
    ASSERT_EQ(0x000000a1u, ImmutableString("imageAtomicMax(01A10D00D").mangledNameHash());
    ASSERT_EQ(0x00000465u, ImmutableString("imageAtomicMax(01B10D00D").mangledNameHash());
    ASSERT_EQ(0x0000052fu, ImmutableString("imageAtomicMax(01C20D00D").mangledNameHash());
    ASSERT_EQ(0x00000223u, ImmutableString("imageAtomicMax(01D20D00D").mangledNameHash());
    ASSERT_EQ(0x00000303u, ImmutableString("imageAtomicMax(01E20D00D").mangledNameHash());
    ASSERT_EQ(0x000003e2u, ImmutableString("imageAtomicMax(01I20D00D").mangledNameHash());
    ASSERT_EQ(0x0000057cu, ImmutableString("imageAtomicMax(01J20D00D").mangledNameHash());
    ASSERT_EQ(0x0000037du, ImmutableString("imageAtomicMax(01K20D00D").mangledNameHash());
    ASSERT_EQ(0x0000046au, ImmutableString("imageAtomicMax(01g00D00D").mangledNameHash());
    ASSERT_EQ(0x000001fcu, ImmutableString("imageAtomicMax(01h00D00D").mangledNameHash());
    ASSERT_EQ(0x0000027fu, ImmutableString("imageAtomicMax(01i00D00D").mangledNameHash());
    ASSERT_EQ(0x000003aau, ImmutableString("imageAtomicMax(01F20D00D").mangledNameHash());
    ASSERT_EQ(0x0000045fu, ImmutableString("imageAtomicMax(01G20D00D").mangledNameHash());
    ASSERT_EQ(0x00000259u, ImmutableString("imageAtomicMax(01H20D00D").mangledNameHash());
    ASSERT_EQ(0x000003a4u, ImmutableString("imageAtomicMax(01a20D00D").mangledNameHash());
    ASSERT_EQ(0x0000015cu, ImmutableString("imageAtomicMax(01b20D00D").mangledNameHash());
    ASSERT_EQ(0x000002d0u, ImmutableString("imageAtomicMax(01c20D00D").mangledNameHash());
    ASSERT_EQ(0x00000570u, ImmutableString("imageAtomicMax(01L00D00D").mangledNameHash());
    ASSERT_EQ(0x00000541u, ImmutableString("imageAtomicMax(01M00D00D").mangledNameHash());
    ASSERT_EQ(0x000004d5u, ImmutableString("imageAtomicMax(01N00D00D").mangledNameHash());
    ASSERT_EQ(0x00000326u, ImmutableString("imageAtomicMax(01O10D00D").mangledNameHash());
    ASSERT_EQ(0x000001e9u, ImmutableString("imageAtomicMax(01P10D00D").mangledNameHash());
    ASSERT_EQ(0x0000053fu, ImmutableString("imageAtomicMax(01Q10D00D").mangledNameHash());
    ASSERT_EQ(0x0000036bu, ImmutableString("imageAtomicMax(01X10D00D").mangledNameHash());
    ASSERT_EQ(0x00000072u, ImmutableString("imageAtomicMax(01Y10D00D").mangledNameHash());
    ASSERT_EQ(0x000002a2u, ImmutableString("imageAtomicMax(01Z10D00D").mangledNameHash());
    ASSERT_EQ(0x000000dfu, ImmutableString("imageAtomicMax(01R10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000028u, ImmutableString("imageAtomicMax(01S10D00D00D").mangledNameHash());
    ASSERT_EQ(0x000001c2u, ImmutableString("imageAtomicMax(01T10D00D00D").mangledNameHash());
    ASSERT_EQ(0x000000f5u, ImmutableString("imageAtomicMax(01U20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000002f8u, ImmutableString("imageAtomicMax(01V20D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000428u, ImmutableString("imageAtomicMax(01W20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000005cau, ImmutableString("imageAtomicAnd(00z10D00E").mangledNameHash());
    ASSERT_EQ(0x00000020u, ImmutableString("imageAtomicAnd(01A10D00E").mangledNameHash());
    ASSERT_EQ(0x0000049du, ImmutableString("imageAtomicAnd(01B10D00E").mangledNameHash());
    ASSERT_EQ(0x00000116u, ImmutableString("imageAtomicAnd(01C20D00E").mangledNameHash());
    ASSERT_EQ(0x000004eau, ImmutableString("imageAtomicAnd(01D20D00E").mangledNameHash());
    ASSERT_EQ(0x0000036du, ImmutableString("imageAtomicAnd(01E20D00E").mangledNameHash());
    ASSERT_EQ(0x00000576u, ImmutableString("imageAtomicAnd(01I20D00E").mangledNameHash());
    ASSERT_EQ(0x000000d1u, ImmutableString("imageAtomicAnd(01J20D00E").mangledNameHash());
    ASSERT_EQ(0x000003d3u, ImmutableString("imageAtomicAnd(01K20D00E").mangledNameHash());
    ASSERT_EQ(0x00000144u, ImmutableString("imageAtomicAnd(01g00D00E").mangledNameHash());
    ASSERT_EQ(0x000002b8u, ImmutableString("imageAtomicAnd(01h00D00E").mangledNameHash());
    ASSERT_EQ(0x000002f4u, ImmutableString("imageAtomicAnd(01i00D00E").mangledNameHash());
    ASSERT_EQ(0x00000260u, ImmutableString("imageAtomicAnd(01F20D00E").mangledNameHash());
    ASSERT_EQ(0x000005f5u, ImmutableString("imageAtomicAnd(01G20D00E").mangledNameHash());
    ASSERT_EQ(0x0000058fu, ImmutableString("imageAtomicAnd(01H20D00E").mangledNameHash());
    ASSERT_EQ(0x000000e9u, ImmutableString("imageAtomicAnd(01a20D00E").mangledNameHash());
    ASSERT_EQ(0x00000131u, ImmutableString("imageAtomicAnd(01b20D00E").mangledNameHash());
    ASSERT_EQ(0x00000164u, ImmutableString("imageAtomicAnd(01c20D00E").mangledNameHash());
    ASSERT_EQ(0x000001bfu, ImmutableString("imageAtomicAnd(01L00D00E").mangledNameHash());
    ASSERT_EQ(0x00000190u, ImmutableString("imageAtomicAnd(01M00D00E").mangledNameHash());
    ASSERT_EQ(0x0000024au, ImmutableString("imageAtomicAnd(01N00D00E").mangledNameHash());
    ASSERT_EQ(0x00000569u, ImmutableString("imageAtomicAnd(01O10D00E").mangledNameHash());
    ASSERT_EQ(0x00000474u, ImmutableString("imageAtomicAnd(01P10D00E").mangledNameHash());
    ASSERT_EQ(0x00000163u, ImmutableString("imageAtomicAnd(01Q10D00E").mangledNameHash());
    ASSERT_EQ(0x00000295u, ImmutableString("imageAtomicAnd(01X10D00E").mangledNameHash());
    ASSERT_EQ(0x00000412u, ImmutableString("imageAtomicAnd(01Y10D00E").mangledNameHash());
    ASSERT_EQ(0x000002dbu, ImmutableString("imageAtomicAnd(01Z10D00E").mangledNameHash());
    ASSERT_EQ(0x0000008eu, ImmutableString("imageAtomicAnd(01R10D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000343u, ImmutableString("imageAtomicAnd(01S10D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000470u, ImmutableString("imageAtomicAnd(01T10D00D00E").mangledNameHash());
    ASSERT_EQ(0x0000014du, ImmutableString("imageAtomicAnd(01U20D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000045u, ImmutableString("imageAtomicAnd(01V20D00D00E").mangledNameHash());
    ASSERT_EQ(0x0000050du, ImmutableString("imageAtomicAnd(01W20D00D00E").mangledNameHash());
    ASSERT_EQ(0x000005c9u, ImmutableString("imageAtomicAnd(00z10D00D").mangledNameHash());
    ASSERT_EQ(0x0000001fu, ImmutableString("imageAtomicAnd(01A10D00D").mangledNameHash());
    ASSERT_EQ(0x000005d9u, ImmutableString("imageAtomicAnd(01B10D00D").mangledNameHash());
    ASSERT_EQ(0x00000117u, ImmutableString("imageAtomicAnd(01C20D00D").mangledNameHash());
    ASSERT_EQ(0x000004e9u, ImmutableString("imageAtomicAnd(01D20D00D").mangledNameHash());
    ASSERT_EQ(0x0000036eu, ImmutableString("imageAtomicAnd(01E20D00D").mangledNameHash());
    ASSERT_EQ(0x000001d0u, ImmutableString("imageAtomicAnd(01I20D00D").mangledNameHash());
    ASSERT_EQ(0x000000d0u, ImmutableString("imageAtomicAnd(01J20D00D").mangledNameHash());
    ASSERT_EQ(0x0000009bu, ImmutableString("imageAtomicAnd(01K20D00D").mangledNameHash());
    ASSERT_EQ(0x00000145u, ImmutableString("imageAtomicAnd(01g00D00D").mangledNameHash());
    ASSERT_EQ(0x000002afu, ImmutableString("imageAtomicAnd(01h00D00D").mangledNameHash());
    ASSERT_EQ(0x000002f5u, ImmutableString("imageAtomicAnd(01i00D00D").mangledNameHash());
    ASSERT_EQ(0x0000025fu, ImmutableString("imageAtomicAnd(01F20D00D").mangledNameHash());
    ASSERT_EQ(0x000005f6u, ImmutableString("imageAtomicAnd(01G20D00D").mangledNameHash());
    ASSERT_EQ(0x0000058eu, ImmutableString("imageAtomicAnd(01H20D00D").mangledNameHash());
    ASSERT_EQ(0x000000eau, ImmutableString("imageAtomicAnd(01a20D00D").mangledNameHash());
    ASSERT_EQ(0x0000055au, ImmutableString("imageAtomicAnd(01b20D00D").mangledNameHash());
    ASSERT_EQ(0x00000165u, ImmutableString("imageAtomicAnd(01c20D00D").mangledNameHash());
    ASSERT_EQ(0x000001beu, ImmutableString("imageAtomicAnd(01L00D00D").mangledNameHash());
    ASSERT_EQ(0x00000191u, ImmutableString("imageAtomicAnd(01M00D00D").mangledNameHash());
    ASSERT_EQ(0x00000249u, ImmutableString("imageAtomicAnd(01N00D00D").mangledNameHash());
    ASSERT_EQ(0x00000568u, ImmutableString("imageAtomicAnd(01O10D00D").mangledNameHash());
    ASSERT_EQ(0x00000475u, ImmutableString("imageAtomicAnd(01P10D00D").mangledNameHash());
    ASSERT_EQ(0x00000162u, ImmutableString("imageAtomicAnd(01Q10D00D").mangledNameHash());
    ASSERT_EQ(0x0000029eu, ImmutableString("imageAtomicAnd(01X10D00D").mangledNameHash());
    ASSERT_EQ(0x00000411u, ImmutableString("imageAtomicAnd(01Y10D00D").mangledNameHash());
    ASSERT_EQ(0x000002dcu, ImmutableString("imageAtomicAnd(01Z10D00D").mangledNameHash());
    ASSERT_EQ(0x0000008du, ImmutableString("imageAtomicAnd(01R10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000344u, ImmutableString("imageAtomicAnd(01S10D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000046fu, ImmutableString("imageAtomicAnd(01T10D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000014cu, ImmutableString("imageAtomicAnd(01U20D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000046u, ImmutableString("imageAtomicAnd(01V20D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000050cu, ImmutableString("imageAtomicAnd(01W20D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000002u, ImmutableString("imageAtomicOr(00z10D00E").mangledNameHash());
    ASSERT_EQ(0x00000370u, ImmutableString("imageAtomicOr(01A10D00E").mangledNameHash());
    ASSERT_EQ(0x00000616u, ImmutableString("imageAtomicOr(01B10D00E").mangledNameHash());
    ASSERT_EQ(0x00000245u, ImmutableString("imageAtomicOr(01C20D00E").mangledNameHash());
    ASSERT_EQ(0x00000094u, ImmutableString("imageAtomicOr(01D20D00E").mangledNameHash());
    ASSERT_EQ(0x0000007fu, ImmutableString("imageAtomicOr(01E20D00E").mangledNameHash());
    ASSERT_EQ(0x00000331u, ImmutableString("imageAtomicOr(01I20D00E").mangledNameHash());
    ASSERT_EQ(0x000003a7u, ImmutableString("imageAtomicOr(01J20D00E").mangledNameHash());
    ASSERT_EQ(0x000000feu, ImmutableString("imageAtomicOr(01K20D00E").mangledNameHash());
    ASSERT_EQ(0x000003d9u, ImmutableString("imageAtomicOr(01g00D00E").mangledNameHash());
    ASSERT_EQ(0x000003fcu, ImmutableString("imageAtomicOr(01h00D00E").mangledNameHash());
    ASSERT_EQ(0x000005f3u, ImmutableString("imageAtomicOr(01i00D00E").mangledNameHash());
    ASSERT_EQ(0x00000228u, ImmutableString("imageAtomicOr(01F20D00E").mangledNameHash());
    ASSERT_EQ(0x000001f3u, ImmutableString("imageAtomicOr(01G20D00E").mangledNameHash());
    ASSERT_EQ(0x0000062fu, ImmutableString("imageAtomicOr(01H20D00E").mangledNameHash());
    ASSERT_EQ(0x000001c7u, ImmutableString("imageAtomicOr(01a20D00E").mangledNameHash());
    ASSERT_EQ(0x0000061eu, ImmutableString("imageAtomicOr(01b20D00E").mangledNameHash());
    ASSERT_EQ(0x000003c3u, ImmutableString("imageAtomicOr(01c20D00E").mangledNameHash());
    ASSERT_EQ(0x000000d6u, ImmutableString("imageAtomicOr(01L00D00E").mangledNameHash());
    ASSERT_EQ(0x000002efu, ImmutableString("imageAtomicOr(01M00D00E").mangledNameHash());
    ASSERT_EQ(0x00000523u, ImmutableString("imageAtomicOr(01N00D00E").mangledNameHash());
    ASSERT_EQ(0x00000445u, ImmutableString("imageAtomicOr(01O10D00E").mangledNameHash());
    ASSERT_EQ(0x000000abu, ImmutableString("imageAtomicOr(01P10D00E").mangledNameHash());
    ASSERT_EQ(0x0000035eu, ImmutableString("imageAtomicOr(01Q10D00E").mangledNameHash());
    ASSERT_EQ(0x000004efu, ImmutableString("imageAtomicOr(01X10D00E").mangledNameHash());
    ASSERT_EQ(0x0000012bu, ImmutableString("imageAtomicOr(01Y10D00E").mangledNameHash());
    ASSERT_EQ(0x000003bdu, ImmutableString("imageAtomicOr(01Z10D00E").mangledNameHash());
    ASSERT_EQ(0x00000087u, ImmutableString("imageAtomicOr(01R10D00D00E").mangledNameHash());
    ASSERT_EQ(0x0000062cu, ImmutableString("imageAtomicOr(01S10D00D00E").mangledNameHash());
    ASSERT_EQ(0x0000030du, ImmutableString("imageAtomicOr(01T10D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000613u, ImmutableString("imageAtomicOr(01U20D00D00E").mangledNameHash());
    ASSERT_EQ(0x0000033eu, ImmutableString("imageAtomicOr(01V20D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000218u, ImmutableString("imageAtomicOr(01W20D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000003u, ImmutableString("imageAtomicOr(00z10D00D").mangledNameHash());
    ASSERT_EQ(0x00000371u, ImmutableString("imageAtomicOr(01A10D00D").mangledNameHash());
    ASSERT_EQ(0x00000615u, ImmutableString("imageAtomicOr(01B10D00D").mangledNameHash());
    ASSERT_EQ(0x00000244u, ImmutableString("imageAtomicOr(01C20D00D").mangledNameHash());
    ASSERT_EQ(0x00000095u, ImmutableString("imageAtomicOr(01D20D00D").mangledNameHash());
    ASSERT_EQ(0x0000007eu, ImmutableString("imageAtomicOr(01E20D00D").mangledNameHash());
    ASSERT_EQ(0x000004aeu, ImmutableString("imageAtomicOr(01I20D00D").mangledNameHash());
    ASSERT_EQ(0x000003a8u, ImmutableString("imageAtomicOr(01J20D00D").mangledNameHash());
    ASSERT_EQ(0x000000fdu, ImmutableString("imageAtomicOr(01K20D00D").mangledNameHash());
    ASSERT_EQ(0x000003d8u, ImmutableString("imageAtomicOr(01g00D00D").mangledNameHash());
    ASSERT_EQ(0x000003fdu, ImmutableString("imageAtomicOr(01h00D00D").mangledNameHash());
    ASSERT_EQ(0x000005f2u, ImmutableString("imageAtomicOr(01i00D00D").mangledNameHash());
    ASSERT_EQ(0x00000229u, ImmutableString("imageAtomicOr(01F20D00D").mangledNameHash());
    ASSERT_EQ(0x000001f2u, ImmutableString("imageAtomicOr(01G20D00D").mangledNameHash());
    ASSERT_EQ(0x00000630u, ImmutableString("imageAtomicOr(01H20D00D").mangledNameHash());
    ASSERT_EQ(0x000001c6u, ImmutableString("imageAtomicOr(01a20D00D").mangledNameHash());
    ASSERT_EQ(0x0000061fu, ImmutableString("imageAtomicOr(01b20D00D").mangledNameHash());
    ASSERT_EQ(0x000003c2u, ImmutableString("imageAtomicOr(01c20D00D").mangledNameHash());
    ASSERT_EQ(0x000000d7u, ImmutableString("imageAtomicOr(01L00D00D").mangledNameHash());
    ASSERT_EQ(0x000002eeu, ImmutableString("imageAtomicOr(01M00D00D").mangledNameHash());
    ASSERT_EQ(0x00000524u, ImmutableString("imageAtomicOr(01N00D00D").mangledNameHash());
    ASSERT_EQ(0x00000446u, ImmutableString("imageAtomicOr(01O10D00D").mangledNameHash());
    ASSERT_EQ(0x000000aau, ImmutableString("imageAtomicOr(01P10D00D").mangledNameHash());
    ASSERT_EQ(0x0000035fu, ImmutableString("imageAtomicOr(01Q10D00D").mangledNameHash());
    ASSERT_EQ(0x000004eeu, ImmutableString("imageAtomicOr(01X10D00D").mangledNameHash());
    ASSERT_EQ(0x0000012cu, ImmutableString("imageAtomicOr(01Y10D00D").mangledNameHash());
    ASSERT_EQ(0x000003bcu, ImmutableString("imageAtomicOr(01Z10D00D").mangledNameHash());
    ASSERT_EQ(0x00000088u, ImmutableString("imageAtomicOr(01R10D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000062bu, ImmutableString("imageAtomicOr(01S10D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000030eu, ImmutableString("imageAtomicOr(01T10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000614u, ImmutableString("imageAtomicOr(01U20D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000033du, ImmutableString("imageAtomicOr(01V20D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000219u, ImmutableString("imageAtomicOr(01W20D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000019fu, ImmutableString("imageAtomicXor(00z10D00E").mangledNameHash());
    ASSERT_EQ(0x00000315u, ImmutableString("imageAtomicXor(01A10D00E").mangledNameHash());
    ASSERT_EQ(0x0000054du, ImmutableString("imageAtomicXor(01B10D00E").mangledNameHash());
    ASSERT_EQ(0x0000040fu, ImmutableString("imageAtomicXor(01C20D00E").mangledNameHash());
    ASSERT_EQ(0x00000490u, ImmutableString("imageAtomicXor(01D20D00E").mangledNameHash());
    ASSERT_EQ(0x00000636u, ImmutableString("imageAtomicXor(01E20D00E").mangledNameHash());
    ASSERT_EQ(0x00000279u, ImmutableString("imageAtomicXor(01I20D00E").mangledNameHash());
    ASSERT_EQ(0x000005e1u, ImmutableString("imageAtomicXor(01J20D00E").mangledNameHash());
    ASSERT_EQ(0x00000552u, ImmutableString("imageAtomicXor(01K20D00E").mangledNameHash());
    ASSERT_EQ(0x000004d8u, ImmutableString("imageAtomicXor(01g00D00E").mangledNameHash());
    ASSERT_EQ(0x000001bau, ImmutableString("imageAtomicXor(01h00D00E").mangledNameHash());
    ASSERT_EQ(0x00000518u, ImmutableString("imageAtomicXor(01i00D00E").mangledNameHash());
    ASSERT_EQ(0x000000e8u, ImmutableString("imageAtomicXor(01F20D00E").mangledNameHash());
    ASSERT_EQ(0x00000571u, ImmutableString("imageAtomicXor(01G20D00E").mangledNameHash());
    ASSERT_EQ(0x00000078u, ImmutableString("imageAtomicXor(01H20D00E").mangledNameHash());
    ASSERT_EQ(0x0000005du, ImmutableString("imageAtomicXor(01a20D00E").mangledNameHash());
    ASSERT_EQ(0x00000150u, ImmutableString("imageAtomicXor(01b20D00E").mangledNameHash());
    ASSERT_EQ(0x00000350u, ImmutableString("imageAtomicXor(01c20D00E").mangledNameHash());
    ASSERT_EQ(0x00000135u, ImmutableString("imageAtomicXor(01L00D00E").mangledNameHash());
    ASSERT_EQ(0x000003ecu, ImmutableString("imageAtomicXor(01M00D00E").mangledNameHash());
    ASSERT_EQ(0x00000266u, ImmutableString("imageAtomicXor(01N00D00E").mangledNameHash());
    ASSERT_EQ(0x000005c4u, ImmutableString("imageAtomicXor(01O10D00E").mangledNameHash());
    ASSERT_EQ(0x000001e1u, ImmutableString("imageAtomicXor(01P10D00E").mangledNameHash());
    ASSERT_EQ(0x0000043fu, ImmutableString("imageAtomicXor(01Q10D00E").mangledNameHash());
    ASSERT_EQ(0x000003c7u, ImmutableString("imageAtomicXor(01X10D00E").mangledNameHash());
    ASSERT_EQ(0x00000048u, ImmutableString("imageAtomicXor(01Y10D00E").mangledNameHash());
    ASSERT_EQ(0x0000056cu, ImmutableString("imageAtomicXor(01Z10D00E").mangledNameHash());
    ASSERT_EQ(0x0000010fu, ImmutableString("imageAtomicXor(01R10D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000173u, ImmutableString("imageAtomicXor(01S10D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000559u, ImmutableString("imageAtomicXor(01T10D00D00E").mangledNameHash());
    ASSERT_EQ(0x0000017eu, ImmutableString("imageAtomicXor(01U20D00D00E").mangledNameHash());
    ASSERT_EQ(0x000003b4u, ImmutableString("imageAtomicXor(01V20D00D00E").mangledNameHash());
    ASSERT_EQ(0x0000056bu, ImmutableString("imageAtomicXor(01W20D00D00E").mangledNameHash());
    ASSERT_EQ(0x0000019eu, ImmutableString("imageAtomicXor(00z10D00D").mangledNameHash());
    ASSERT_EQ(0x00000314u, ImmutableString("imageAtomicXor(01A10D00D").mangledNameHash());
    ASSERT_EQ(0x0000054eu, ImmutableString("imageAtomicXor(01B10D00D").mangledNameHash());
    ASSERT_EQ(0x00000607u, ImmutableString("imageAtomicXor(01C20D00D").mangledNameHash());
    ASSERT_EQ(0x0000048fu, ImmutableString("imageAtomicXor(01D20D00D").mangledNameHash());
    ASSERT_EQ(0x00000637u, ImmutableString("imageAtomicXor(01E20D00D").mangledNameHash());
    ASSERT_EQ(0x00000186u, ImmutableString("imageAtomicXor(01I20D00D").mangledNameHash());
    ASSERT_EQ(0x000005e0u, ImmutableString("imageAtomicXor(01J20D00D").mangledNameHash());
    ASSERT_EQ(0x00000553u, ImmutableString("imageAtomicXor(01K20D00D").mangledNameHash());
    ASSERT_EQ(0x000004d9u, ImmutableString("imageAtomicXor(01g00D00D").mangledNameHash());
    ASSERT_EQ(0x000001b9u, ImmutableString("imageAtomicXor(01h00D00D").mangledNameHash());
    ASSERT_EQ(0x00000519u, ImmutableString("imageAtomicXor(01i00D00D").mangledNameHash());
    ASSERT_EQ(0x000000e7u, ImmutableString("imageAtomicXor(01F20D00D").mangledNameHash());
    ASSERT_EQ(0x00000572u, ImmutableString("imageAtomicXor(01G20D00D").mangledNameHash());
    ASSERT_EQ(0x00000077u, ImmutableString("imageAtomicXor(01H20D00D").mangledNameHash());
    ASSERT_EQ(0x0000005eu, ImmutableString("imageAtomicXor(01a20D00D").mangledNameHash());
    ASSERT_EQ(0x0000014fu, ImmutableString("imageAtomicXor(01b20D00D").mangledNameHash());
    ASSERT_EQ(0x00000351u, ImmutableString("imageAtomicXor(01c20D00D").mangledNameHash());
    ASSERT_EQ(0x000000d8u, ImmutableString("imageAtomicXor(01L00D00D").mangledNameHash());
    ASSERT_EQ(0x000003edu, ImmutableString("imageAtomicXor(01M00D00D").mangledNameHash());
    ASSERT_EQ(0x00000265u, ImmutableString("imageAtomicXor(01N00D00D").mangledNameHash());
    ASSERT_EQ(0x000005c3u, ImmutableString("imageAtomicXor(01O10D00D").mangledNameHash());
    ASSERT_EQ(0x000001e2u, ImmutableString("imageAtomicXor(01P10D00D").mangledNameHash());
    ASSERT_EQ(0x0000043eu, ImmutableString("imageAtomicXor(01Q10D00D").mangledNameHash());
    ASSERT_EQ(0x000003c8u, ImmutableString("imageAtomicXor(01X10D00D").mangledNameHash());
    ASSERT_EQ(0x00000047u, ImmutableString("imageAtomicXor(01Y10D00D").mangledNameHash());
    ASSERT_EQ(0x0000056du, ImmutableString("imageAtomicXor(01Z10D00D").mangledNameHash());
    ASSERT_EQ(0x0000010eu, ImmutableString("imageAtomicXor(01R10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000174u, ImmutableString("imageAtomicXor(01S10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000558u, ImmutableString("imageAtomicXor(01T10D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000017du, ImmutableString("imageAtomicXor(01U20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000003b5u, ImmutableString("imageAtomicXor(01V20D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000056au, ImmutableString("imageAtomicXor(01W20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000003adu, ImmutableString("imageAtomicExchange(00z10D00E").mangledNameHash());
    ASSERT_EQ(0x000001a6u, ImmutableString("imageAtomicExchange(01A10D00E").mangledNameHash());
    ASSERT_EQ(0x00000600u, ImmutableString("imageAtomicExchange(01B10D00E").mangledNameHash());
    ASSERT_EQ(0x000005abu, ImmutableString("imageAtomicExchange(01C20D00E").mangledNameHash());
    ASSERT_EQ(0x00000296u, ImmutableString("imageAtomicExchange(01D20D00E").mangledNameHash());
    ASSERT_EQ(0x0000027cu, ImmutableString("imageAtomicExchange(01E20D00E").mangledNameHash());
    ASSERT_EQ(0x00000349u, ImmutableString("imageAtomicExchange(01I20D00E").mangledNameHash());
    ASSERT_EQ(0x000002ecu, ImmutableString("imageAtomicExchange(01J20D00E").mangledNameHash());
    ASSERT_EQ(0x000005d5u, ImmutableString("imageAtomicExchange(01K20D00E").mangledNameHash());
    ASSERT_EQ(0x00000602u, ImmutableString("imageAtomicExchange(01g00D00E").mangledNameHash());
    ASSERT_EQ(0x000003a0u, ImmutableString("imageAtomicExchange(01h00D00E").mangledNameHash());
    ASSERT_EQ(0x0000032fu, ImmutableString("imageAtomicExchange(01i00D00E").mangledNameHash());
    ASSERT_EQ(0x0000032cu, ImmutableString("imageAtomicExchange(01F20D00E").mangledNameHash());
    ASSERT_EQ(0x00000469u, ImmutableString("imageAtomicExchange(01G20D00E").mangledNameHash());
    ASSERT_EQ(0x000004a9u, ImmutableString("imageAtomicExchange(01H20D00E").mangledNameHash());
    ASSERT_EQ(0x00000582u, ImmutableString("imageAtomicExchange(01a20D00E").mangledNameHash());
    ASSERT_EQ(0x00000031u, ImmutableString("imageAtomicExchange(01b20D00E").mangledNameHash());
    ASSERT_EQ(0x000004c9u, ImmutableString("imageAtomicExchange(01c20D00E").mangledNameHash());
    ASSERT_EQ(0x000002cau, ImmutableString("imageAtomicExchange(01L00D00E").mangledNameHash());
    ASSERT_EQ(0x00000155u, ImmutableString("imageAtomicExchange(01M00D00E").mangledNameHash());
    ASSERT_EQ(0x00000493u, ImmutableString("imageAtomicExchange(01N00D00E").mangledNameHash());
    ASSERT_EQ(0x0000048du, ImmutableString("imageAtomicExchange(01O10D00E").mangledNameHash());
    ASSERT_EQ(0x00000342u, ImmutableString("imageAtomicExchange(01P10D00E").mangledNameHash());
    ASSERT_EQ(0x00000201u, ImmutableString("imageAtomicExchange(01Q10D00E").mangledNameHash());
    ASSERT_EQ(0x000001feu, ImmutableString("imageAtomicExchange(01X10D00E").mangledNameHash());
    ASSERT_EQ(0x0000048au, ImmutableString("imageAtomicExchange(01Y10D00E").mangledNameHash());
    ASSERT_EQ(0x000002b6u, ImmutableString("imageAtomicExchange(01Z10D00E").mangledNameHash());
    ASSERT_EQ(0x0000032au, ImmutableString("imageAtomicExchange(01R10D00D00E").mangledNameHash());
    ASSERT_EQ(0x000001deu, ImmutableString("imageAtomicExchange(01S10D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000106u, ImmutableString("imageAtomicExchange(01T10D00D00E").mangledNameHash());
    ASSERT_EQ(0x0000044bu, ImmutableString("imageAtomicExchange(01U20D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000196u, ImmutableString("imageAtomicExchange(01V20D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000215u, ImmutableString("imageAtomicExchange(01W20D00D00E").mangledNameHash());
    ASSERT_EQ(0x000003aeu, ImmutableString("imageAtomicExchange(00z10D00D").mangledNameHash());
    ASSERT_EQ(0x000001a7u, ImmutableString("imageAtomicExchange(01A10D00D").mangledNameHash());
    ASSERT_EQ(0x000005ffu, ImmutableString("imageAtomicExchange(01B10D00D").mangledNameHash());
    ASSERT_EQ(0x000005aau, ImmutableString("imageAtomicExchange(01C20D00D").mangledNameHash());
    ASSERT_EQ(0x00000297u, ImmutableString("imageAtomicExchange(01D20D00D").mangledNameHash());
    ASSERT_EQ(0x00000185u, ImmutableString("imageAtomicExchange(01E20D00D").mangledNameHash());
    ASSERT_EQ(0x00000348u, ImmutableString("imageAtomicExchange(01I20D00D").mangledNameHash());
    ASSERT_EQ(0x000002edu, ImmutableString("imageAtomicExchange(01J20D00D").mangledNameHash());
    ASSERT_EQ(0x000005d4u, ImmutableString("imageAtomicExchange(01K20D00D").mangledNameHash());
    ASSERT_EQ(0x00000601u, ImmutableString("imageAtomicExchange(01g00D00D").mangledNameHash());
    ASSERT_EQ(0x000003a1u, ImmutableString("imageAtomicExchange(01h00D00D").mangledNameHash());
    ASSERT_EQ(0x0000032eu, ImmutableString("imageAtomicExchange(01i00D00D").mangledNameHash());
    ASSERT_EQ(0x00000082u, ImmutableString("imageAtomicExchange(01F20D00D").mangledNameHash());
    ASSERT_EQ(0x00000468u, ImmutableString("imageAtomicExchange(01G20D00D").mangledNameHash());
    ASSERT_EQ(0x000004aau, ImmutableString("imageAtomicExchange(01H20D00D").mangledNameHash());
    ASSERT_EQ(0x00000581u, ImmutableString("imageAtomicExchange(01a20D00D").mangledNameHash());
    ASSERT_EQ(0x00000032u, ImmutableString("imageAtomicExchange(01b20D00D").mangledNameHash());
    ASSERT_EQ(0x000004c8u, ImmutableString("imageAtomicExchange(01c20D00D").mangledNameHash());
    ASSERT_EQ(0x000002cbu, ImmutableString("imageAtomicExchange(01L00D00D").mangledNameHash());
    ASSERT_EQ(0x00000154u, ImmutableString("imageAtomicExchange(01M00D00D").mangledNameHash());
    ASSERT_EQ(0x00000494u, ImmutableString("imageAtomicExchange(01N00D00D").mangledNameHash());
    ASSERT_EQ(0x0000025bu, ImmutableString("imageAtomicExchange(01O10D00D").mangledNameHash());
    ASSERT_EQ(0x0000033fu, ImmutableString("imageAtomicExchange(01P10D00D").mangledNameHash());
    ASSERT_EQ(0x00000202u, ImmutableString("imageAtomicExchange(01Q10D00D").mangledNameHash());
    ASSERT_EQ(0x000001fdu, ImmutableString("imageAtomicExchange(01X10D00D").mangledNameHash());
    ASSERT_EQ(0x0000048bu, ImmutableString("imageAtomicExchange(01Y10D00D").mangledNameHash());
    ASSERT_EQ(0x000002adu, ImmutableString("imageAtomicExchange(01Z10D00D").mangledNameHash());
    ASSERT_EQ(0x0000032bu, ImmutableString("imageAtomicExchange(01R10D00D00D").mangledNameHash());
    ASSERT_EQ(0x000001dbu, ImmutableString("imageAtomicExchange(01S10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000107u, ImmutableString("imageAtomicExchange(01T10D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000044cu, ImmutableString("imageAtomicExchange(01U20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000002eau, ImmutableString("imageAtomicExchange(01V20D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000216u, ImmutableString("imageAtomicExchange(01W20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000003acu, ImmutableString("imageAtomicExchange(00z10D00B").mangledNameHash());
    ASSERT_EQ(0x000001a4u, ImmutableString("imageAtomicExchange(01A10D00B").mangledNameHash());
    ASSERT_EQ(0x000005fdu, ImmutableString("imageAtomicExchange(01B10D00B").mangledNameHash());
    ASSERT_EQ(0x000005aeu, ImmutableString("imageAtomicExchange(01C20D00B").mangledNameHash());
    ASSERT_EQ(0x00000298u, ImmutableString("imageAtomicExchange(01D20D00B").mangledNameHash());
    ASSERT_EQ(0x00000183u, ImmutableString("imageAtomicExchange(01E20D00B").mangledNameHash());
    ASSERT_EQ(0x0000034au, ImmutableString("imageAtomicExchange(01I20D00B").mangledNameHash());
    ASSERT_EQ(0x000002ebu, ImmutableString("imageAtomicExchange(01J20D00B").mangledNameHash());
    ASSERT_EQ(0x000005d7u, ImmutableString("imageAtomicExchange(01K20D00B").mangledNameHash());
    ASSERT_EQ(0x000005fcu, ImmutableString("imageAtomicExchange(01g00D00B").mangledNameHash());
    ASSERT_EQ(0x000003a3u, ImmutableString("imageAtomicExchange(01h00D00B").mangledNameHash());
    ASSERT_EQ(0x00000330u, ImmutableString("imageAtomicExchange(01i00D00B").mangledNameHash());
    ASSERT_EQ(0x00000083u, ImmutableString("imageAtomicExchange(01F20D00B").mangledNameHash());
    ASSERT_EQ(0x00000467u, ImmutableString("imageAtomicExchange(01G20D00B").mangledNameHash());
    ASSERT_EQ(0x000004a7u, ImmutableString("imageAtomicExchange(01H20D00B").mangledNameHash());
    ASSERT_EQ(0x00000583u, ImmutableString("imageAtomicExchange(01a20D00B").mangledNameHash());
    ASSERT_EQ(0x00000030u, ImmutableString("imageAtomicExchange(01b20D00B").mangledNameHash());
    ASSERT_EQ(0x000004cau, ImmutableString("imageAtomicExchange(01c20D00B").mangledNameHash());
    ASSERT_EQ(0x000002c9u, ImmutableString("imageAtomicExchange(01L00D00B").mangledNameHash());
    ASSERT_EQ(0x00000153u, ImmutableString("imageAtomicExchange(01M00D00B").mangledNameHash());
    ASSERT_EQ(0x00000492u, ImmutableString("imageAtomicExchange(01N00D00B").mangledNameHash());
    ASSERT_EQ(0x00000257u, ImmutableString("imageAtomicExchange(01O10D00B").mangledNameHash());
    ASSERT_EQ(0x000001ebu, ImmutableString("imageAtomicExchange(01P10D00B").mangledNameHash());
    ASSERT_EQ(0x00000200u, ImmutableString("imageAtomicExchange(01Q10D00B").mangledNameHash());
    ASSERT_EQ(0x000001ffu, ImmutableString("imageAtomicExchange(01X10D00B").mangledNameHash());
    ASSERT_EQ(0x00000488u, ImmutableString("imageAtomicExchange(01Y10D00B").mangledNameHash());
    ASSERT_EQ(0x000005b0u, ImmutableString("imageAtomicExchange(01Z10D00B").mangledNameHash());
    ASSERT_EQ(0x00000012u, ImmutableString("imageAtomicExchange(01R10D00D00B").mangledNameHash());
    ASSERT_EQ(0x0000015fu, ImmutableString("imageAtomicExchange(01S10D00D00B").mangledNameHash());
    ASSERT_EQ(0x00000169u, ImmutableString("imageAtomicExchange(01T10D00D00B").mangledNameHash());
    ASSERT_EQ(0x0000044au, ImmutableString("imageAtomicExchange(01U20D00D00B").mangledNameHash());
    ASSERT_EQ(0x00000197u, ImmutableString("imageAtomicExchange(01V20D00D00B").mangledNameHash());
    ASSERT_EQ(0x00000213u, ImmutableString("imageAtomicExchange(01W20D00D00B").mangledNameHash());
    ASSERT_EQ(0x00000307u, ImmutableString("imageAtomicCompSwap(00z10D00E00E").mangledNameHash());
    ASSERT_EQ(0x00000299u, ImmutableString("imageAtomicCompSwap(01A10D00E00E").mangledNameHash());
    ASSERT_EQ(0x00000141u, ImmutableString("imageAtomicCompSwap(01B10D00E00E").mangledNameHash());
    ASSERT_EQ(0x00000591u, ImmutableString("imageAtomicCompSwap(01C20D00E00E").mangledNameHash());
    ASSERT_EQ(0x0000051eu, ImmutableString("imageAtomicCompSwap(01D20D00E00E").mangledNameHash());
    ASSERT_EQ(0x000000dbu, ImmutableString("imageAtomicCompSwap(01E20D00E00E").mangledNameHash());
    ASSERT_EQ(0x00000321u, ImmutableString("imageAtomicCompSwap(01I20D00E00E").mangledNameHash());
    ASSERT_EQ(0x0000003cu, ImmutableString("imageAtomicCompSwap(01J20D00E00E").mangledNameHash());
    ASSERT_EQ(0x00000628u, ImmutableString("imageAtomicCompSwap(01K20D00E00E").mangledNameHash());
    ASSERT_EQ(0x000005c0u, ImmutableString("imageAtomicCompSwap(01g00D00E00E").mangledNameHash());
    ASSERT_EQ(0x00000148u, ImmutableString("imageAtomicCompSwap(01h00D00E00E").mangledNameHash());
    ASSERT_EQ(0x00000504u, ImmutableString("imageAtomicCompSwap(01i00D00E00E").mangledNameHash());
    ASSERT_EQ(0x00000156u, ImmutableString("imageAtomicCompSwap(01F20D00E00E").mangledNameHash());
    ASSERT_EQ(0x00000274u, ImmutableString("imageAtomicCompSwap(01G20D00E00E").mangledNameHash());
    ASSERT_EQ(0x000004a8u, ImmutableString("imageAtomicCompSwap(01H20D00E00E").mangledNameHash());
    ASSERT_EQ(0x00000019u, ImmutableString("imageAtomicCompSwap(01a20D00E00E").mangledNameHash());
    ASSERT_EQ(0x000000ecu, ImmutableString("imageAtomicCompSwap(01b20D00E00E").mangledNameHash());
    ASSERT_EQ(0x000003efu, ImmutableString("imageAtomicCompSwap(01c20D00E00E").mangledNameHash());
    ASSERT_EQ(0x00000415u, ImmutableString("imageAtomicCompSwap(01L00D00E00E").mangledNameHash());
    ASSERT_EQ(0x0000020bu, ImmutableString("imageAtomicCompSwap(01M00D00E00E").mangledNameHash());
    ASSERT_EQ(0x0000030bu, ImmutableString("imageAtomicCompSwap(01N00D00E00E").mangledNameHash());
    ASSERT_EQ(0x000000e6u, ImmutableString("imageAtomicCompSwap(01O10D00E00E").mangledNameHash());
    ASSERT_EQ(0x0000011au, ImmutableString("imageAtomicCompSwap(01P10D00E00E").mangledNameHash());
    ASSERT_EQ(0x00000372u, ImmutableString("imageAtomicCompSwap(01Q10D00E00E").mangledNameHash());
    ASSERT_EQ(0x000000c3u, ImmutableString("imageAtomicCompSwap(01X10D00E00E").mangledNameHash());
    ASSERT_EQ(0x00000198u, ImmutableString("imageAtomicCompSwap(01Y10D00E00E").mangledNameHash());
    ASSERT_EQ(0x000002f1u, ImmutableString("imageAtomicCompSwap(01Z10D00E00E").mangledNameHash());
    ASSERT_EQ(0x000002a9u,
              ImmutableString("imageAtomicCompSwap(01R10D00D00E00E").mangledNameHash());
    ASSERT_EQ(0x0000034fu,
              ImmutableString("imageAtomicCompSwap(01S10D00D00E00E").mangledNameHash());
    ASSERT_EQ(0x00000132u,
              ImmutableString("imageAtomicCompSwap(01T10D00D00E00E").mangledNameHash());
    ASSERT_EQ(0x000004bcu,
              ImmutableString("imageAtomicCompSwap(01U20D00D00E00E").mangledNameHash());
    ASSERT_EQ(0x0000055fu,
              ImmutableString("imageAtomicCompSwap(01V20D00D00E00E").mangledNameHash());
    ASSERT_EQ(0x0000000au,
              ImmutableString("imageAtomicCompSwap(01W20D00D00E00E").mangledNameHash());
    ASSERT_EQ(0x00000585u, ImmutableString("imageAtomicCompSwap(00z10D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000004du, ImmutableString("imageAtomicCompSwap(01A10D00D00D").mangledNameHash());
    ASSERT_EQ(0x000004edu, ImmutableString("imageAtomicCompSwap(01B10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000316u, ImmutableString("imageAtomicCompSwap(01C20D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000027u, ImmutableString("imageAtomicCompSwap(01D20D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000009u, ImmutableString("imageAtomicCompSwap(01E20D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000209u, ImmutableString("imageAtomicCompSwap(01I20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000002bau, ImmutableString("imageAtomicCompSwap(01J20D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000505u, ImmutableString("imageAtomicCompSwap(01K20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000004e3u, ImmutableString("imageAtomicCompSwap(01g00D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000023fu, ImmutableString("imageAtomicCompSwap(01h00D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000363u, ImmutableString("imageAtomicCompSwap(01i00D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000231u, ImmutableString("imageAtomicCompSwap(01F20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000001cfu, ImmutableString("imageAtomicCompSwap(01G20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000000c7u, ImmutableString("imageAtomicCompSwap(01H20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000003f3u, ImmutableString("imageAtomicCompSwap(01a20D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000001eu, ImmutableString("imageAtomicCompSwap(01b20D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000237u, ImmutableString("imageAtomicCompSwap(01c20D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000047au, ImmutableString("imageAtomicCompSwap(01L00D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000128u, ImmutableString("imageAtomicCompSwap(01M00D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000479u, ImmutableString("imageAtomicCompSwap(01N00D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000495u, ImmutableString("imageAtomicCompSwap(01O10D00D00D").mangledNameHash());
    ASSERT_EQ(0x000004ccu, ImmutableString("imageAtomicCompSwap(01P10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000456u, ImmutableString("imageAtomicCompSwap(01Q10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000626u, ImmutableString("imageAtomicCompSwap(01X10D00D00D").mangledNameHash());
    ASSERT_EQ(0x000004b1u, ImmutableString("imageAtomicCompSwap(01Y10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000211u, ImmutableString("imageAtomicCompSwap(01Z10D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000001au,
              ImmutableString("imageAtomicCompSwap(01R10D00D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000485u,
              ImmutableString("imageAtomicCompSwap(01S10D00D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000051u,
              ImmutableString("imageAtomicCompSwap(01T10D00D00D00D").mangledNameHash());
    ASSERT_EQ(0x000003ddu,
              ImmutableString("imageAtomicCompSwap(01U20D00D00D00D").mangledNameHash());
    ASSERT_EQ(0x000001a5u,
              ImmutableString("imageAtomicCompSwap(01V20D00D00D00D").mangledNameHash());
    ASSERT_EQ(0x000005cbu,
              ImmutableString("imageAtomicCompSwap(01W20D00D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000006au, ImmutableString("imageStore(00z10D30B").mangledNameHash());
    ASSERT_EQ(0x00000076u, ImmutableString("imageStore(01A10D30D").mangledNameHash());
    ASSERT_EQ(0x00000418u, ImmutableString("imageStore(01B10D30E").mangledNameHash());
    ASSERT_EQ(0x00000039u, ImmutableString("imageStore(01C20D30B").mangledNameHash());
    ASSERT_EQ(0x0000028cu, ImmutableString("imageStore(01D20D30D").mangledNameHash());
    ASSERT_EQ(0x000002ddu, ImmutableString("imageStore(01E20D30E").mangledNameHash());
    ASSERT_EQ(0x00000398u, ImmutableString("imageStore(01F20D30B").mangledNameHash());
    ASSERT_EQ(0x0000037fu, ImmutableString("imageStore(01G20D30D").mangledNameHash());
    ASSERT_EQ(0x0000044du, ImmutableString("imageStore(01H20D30E").mangledNameHash());
    ASSERT_EQ(0x0000041cu, ImmutableString("imageStore(01I20D30B").mangledNameHash());
    ASSERT_EQ(0x00000506u, ImmutableString("imageStore(01J20D30D").mangledNameHash());
    ASSERT_EQ(0x0000003fu, ImmutableString("imageStore(01K20D30E").mangledNameHash());
    ASSERT_EQ(0x000001f6u, ImmutableString("imageStore(01a20D30B").mangledNameHash());
    ASSERT_EQ(0x000003f5u, ImmutableString("imageStore(01b20D30D").mangledNameHash());
    ASSERT_EQ(0x0000058du, ImmutableString("imageStore(01c20D30E").mangledNameHash());
    ASSERT_EQ(0x00000118u, ImmutableString("imageStore(01g00D30B").mangledNameHash());
    ASSERT_EQ(0x0000025au, ImmutableString("imageStore(01h00D30D").mangledNameHash());
    ASSERT_EQ(0x00000075u, ImmutableString("imageStore(01i00D30E").mangledNameHash());
    ASSERT_EQ(0x000003c9u, ImmutableString("memoryBarrier(").mangledNameHash());
    ASSERT_EQ(0x000004dcu, ImmutableString("memoryBarrierAtomicCounter(").mangledNameHash());
    ASSERT_EQ(0x000000b2u, ImmutableString("memoryBarrierBuffer(").mangledNameHash());
    ASSERT_EQ(0x0000061au, ImmutableString("memoryBarrierImage(").mangledNameHash());
    ASSERT_EQ(0x00000522u, ImmutableString("barrier(").mangledNameHash());
    ASSERT_EQ(0x0000060du, ImmutableString("memoryBarrierShared(").mangledNameHash());
    ASSERT_EQ(0x0000002fu, ImmutableString("groupMemoryBarrier(").mangledNameHash());
    ASSERT_EQ(0x00000192u, ImmutableString("EmitVertex(").mangledNameHash());
    ASSERT_EQ(0x000002a5u, ImmutableString("EndPrimitive(").mangledNameHash());
    ASSERT_EQ(0x000003b8u, ImmutableString("textureVideoWEBGL(00y10B").mangledNameHash());
    ASSERT_EQ(0x00000416u, ImmutableString("texture(00y10B").mangledNameHash());
    ASSERT_EQ(0x0000049cu, ImmutableString("gl_DepthRangeParameters").mangledNameHash());
    ASSERT_EQ(0x000000d2u, ImmutableString("gl_DepthRange").mangledNameHash());
    ASSERT_EQ(0x000005f9u, ImmutableString("gl_MaxVertexAttribs").mangledNameHash());
    ASSERT_EQ(0x00000212u, ImmutableString("gl_MaxVertexUniformVectors").mangledNameHash());
    ASSERT_EQ(0x0000013au, ImmutableString("gl_MaxVertexTextureImageUnits").mangledNameHash());
    ASSERT_EQ(0x00000384u, ImmutableString("gl_MaxCombinedTextureImageUnits").mangledNameHash());
    ASSERT_EQ(0x0000038bu, ImmutableString("gl_MaxTextureImageUnits").mangledNameHash());
    ASSERT_EQ(0x00000454u, ImmutableString("gl_MaxFragmentUniformVectors").mangledNameHash());
    ASSERT_EQ(0x0000047eu, ImmutableString("gl_MaxVaryingVectors").mangledNameHash());
    ASSERT_EQ(0x00000383u, ImmutableString("gl_MaxDrawBuffers").mangledNameHash());
    ASSERT_EQ(0x00000113u, ImmutableString("gl_MaxDualSourceDrawBuffersEXT").mangledNameHash());
    ASSERT_EQ(0x000005f1u, ImmutableString("gl_MaxVertexOutputVectors").mangledNameHash());
    ASSERT_EQ(0x00000040u, ImmutableString("gl_MaxFragmentInputVectors").mangledNameHash());
    ASSERT_EQ(0x000003c0u, ImmutableString("gl_MinProgramTexelOffset").mangledNameHash());
    ASSERT_EQ(0x0000059du, ImmutableString("gl_MaxProgramTexelOffset").mangledNameHash());
    ASSERT_EQ(0x0000035du, ImmutableString("gl_MaxImageUnits").mangledNameHash());
    ASSERT_EQ(0x000005dau, ImmutableString("gl_MaxVertexImageUniforms").mangledNameHash());
    ASSERT_EQ(0x000000f0u, ImmutableString("gl_MaxFragmentImageUniforms").mangledNameHash());
    ASSERT_EQ(0x000001a2u, ImmutableString("gl_MaxComputeImageUniforms").mangledNameHash());
    ASSERT_EQ(0x000003d7u, ImmutableString("gl_MaxCombinedImageUniforms").mangledNameHash());
    ASSERT_EQ(0x00000050u,
              ImmutableString("gl_MaxCombinedShaderOutputResources").mangledNameHash());
    ASSERT_EQ(0x000001d5u, ImmutableString("gl_MaxComputeWorkGroupCount").mangledNameHash());
    ASSERT_EQ(0x00000377u, ImmutableString("gl_MaxComputeWorkGroupSize").mangledNameHash());
    ASSERT_EQ(0x000000d9u, ImmutableString("gl_MaxComputeUniformComponents").mangledNameHash());
    ASSERT_EQ(0x00000070u, ImmutableString("gl_MaxComputeTextureImageUnits").mangledNameHash());
    ASSERT_EQ(0x000002a3u, ImmutableString("gl_MaxComputeAtomicCounters").mangledNameHash());
    ASSERT_EQ(0x00000142u, ImmutableString("gl_MaxComputeAtomicCounterBuffers").mangledNameHash());
    ASSERT_EQ(0x00000108u, ImmutableString("gl_MaxVertexAtomicCounters").mangledNameHash());
    ASSERT_EQ(0x0000011cu, ImmutableString("gl_MaxFragmentAtomicCounters").mangledNameHash());
    ASSERT_EQ(0x00000477u, ImmutableString("gl_MaxCombinedAtomicCounters").mangledNameHash());
    ASSERT_EQ(0x00000005u, ImmutableString("gl_MaxAtomicCounterBindings").mangledNameHash());
    ASSERT_EQ(0x000001cbu, ImmutableString("gl_MaxVertexAtomicCounterBuffers").mangledNameHash());
    ASSERT_EQ(0x00000254u, ImmutableString("gl_MaxFragmentAtomicCounterBuffers").mangledNameHash());
    ASSERT_EQ(0x0000040au, ImmutableString("gl_MaxCombinedAtomicCounterBuffers").mangledNameHash());
    ASSERT_EQ(0x000005ccu, ImmutableString("gl_MaxAtomicCounterBufferSize").mangledNameHash());
    ASSERT_EQ(0x0000034bu, ImmutableString("gl_MaxGeometryInputComponents").mangledNameHash());
    ASSERT_EQ(0x0000024fu, ImmutableString("gl_MaxGeometryOutputComponents").mangledNameHash());
    ASSERT_EQ(0x000000bcu, ImmutableString("gl_MaxGeometryImageUniforms").mangledNameHash());
    ASSERT_EQ(0x000002e1u, ImmutableString("gl_MaxGeometryTextureImageUnits").mangledNameHash());
    ASSERT_EQ(0x00000014u, ImmutableString("gl_MaxGeometryOutputVertices").mangledNameHash());
    ASSERT_EQ(0x000005d0u,
              ImmutableString("gl_MaxGeometryTotalOutputComponents").mangledNameHash());
    ASSERT_EQ(0x00000632u, ImmutableString("gl_MaxGeometryUniformComponents").mangledNameHash());
    ASSERT_EQ(0x0000057fu, ImmutableString("gl_MaxGeometryAtomicCounters").mangledNameHash());
    ASSERT_EQ(0x0000054cu, ImmutableString("gl_MaxGeometryAtomicCounterBuffers").mangledNameHash());
    ASSERT_EQ(0x0000036au, ImmutableString("gl_FragCoord").mangledNameHash());
    ASSERT_EQ(0x0000013du, ImmutableString("gl_FrontFacing").mangledNameHash());
    ASSERT_EQ(0x00000395u, ImmutableString("gl_PointCoord").mangledNameHash());
    ASSERT_EQ(0x000001d8u, ImmutableString("gl_FragColor").mangledNameHash());
    ASSERT_EQ(0x000005eeu, ImmutableString("gl_FragData").mangledNameHash());
    ASSERT_EQ(0x000002d6u, ImmutableString("gl_FragDepth").mangledNameHash());
    ASSERT_EQ(0x000003f8u, ImmutableString("gl_HelperInvocation").mangledNameHash());
    ASSERT_EQ(0x0000014bu, ImmutableString("gl_SecondaryFragColorEXT").mangledNameHash());
    ASSERT_EQ(0x00000566u, ImmutableString("gl_SecondaryFragDataEXT").mangledNameHash());
    ASSERT_EQ(0x00000234u, ImmutableString("gl_FragDepthEXT").mangledNameHash());
    ASSERT_EQ(0x00000061u, ImmutableString("gl_LastFragData").mangledNameHash());
    ASSERT_EQ(0x000004b9u, ImmutableString("gl_LastFragColor").mangledNameHash());
    ASSERT_EQ(0x00000146u, ImmutableString("gl_LastFragColorARM").mangledNameHash());
    ASSERT_EQ(0x000004b0u, ImmutableString("gl_PrimitiveID").mangledNameHash());
    ASSERT_EQ(0x000004b3u, ImmutableString("gl_Layer").mangledNameHash());
    ASSERT_EQ(0x000002e7u, ImmutableString("gl_Position").mangledNameHash());
    ASSERT_EQ(0x00000189u, ImmutableString("gl_PointSize").mangledNameHash());
    ASSERT_EQ(0x000000c5u, ImmutableString("gl_InstanceID").mangledNameHash());
    ASSERT_EQ(0x000003dcu, ImmutableString("gl_VertexID").mangledNameHash());
    ASSERT_EQ(0x00000327u, ImmutableString("gl_DrawID").mangledNameHash());
    ASSERT_EQ(0x000005cfu, ImmutableString("gl_BaseVertex").mangledNameHash());
    ASSERT_EQ(0x0000014eu, ImmutableString("gl_BaseInstance").mangledNameHash());
    ASSERT_EQ(0x00000345u, ImmutableString("angle_BaseVertex").mangledNameHash());
    ASSERT_EQ(0x000002e4u, ImmutableString("angle_BaseInstance").mangledNameHash());
    ASSERT_EQ(0x00000236u, ImmutableString("gl_ClipDistance").mangledNameHash());
    ASSERT_EQ(0x000004d7u, ImmutableString("gl_MaxClipDistances").mangledNameHash());
    ASSERT_EQ(0x00000444u, ImmutableString("gl_NumWorkGroups").mangledNameHash());
    ASSERT_EQ(0x00000270u, ImmutableString("gl_WorkGroupSize").mangledNameHash());
    ASSERT_EQ(0x00000579u, ImmutableString("gl_WorkGroupID").mangledNameHash());
    ASSERT_EQ(0x00000549u, ImmutableString("gl_LocalInvocationID").mangledNameHash());
    ASSERT_EQ(0x000003dau, ImmutableString("gl_GlobalInvocationID").mangledNameHash());
    ASSERT_EQ(0x000003dbu, ImmutableString("gl_LocalInvocationIndex").mangledNameHash());
    ASSERT_EQ(0x000005bcu, ImmutableString("gl_PrimitiveIDIn").mangledNameHash());
    ASSERT_EQ(0x0000008bu, ImmutableString("gl_InvocationID").mangledNameHash());
    ASSERT_EQ(0x0000035au, ImmutableString("gl_PerVertex").mangledNameHash());
    ASSERT_EQ(0x00000255u, ImmutableString("gl_in").mangledNameHash());
    ASSERT_EQ(0x00000199u, ImmutableString("gl_ViewID_OVR").mangledNameHash());
    ASSERT_EQ(0x00000020u, ImmutableString("radians").unmangledNameHash());
    ASSERT_EQ(0x00000012u, ImmutableString("degrees").unmangledNameHash());
    ASSERT_EQ(0x0000008au, ImmutableString("sin").unmangledNameHash());
    ASSERT_EQ(0x00000049u, ImmutableString("cos").unmangledNameHash());
    ASSERT_EQ(0x0000007eu, ImmutableString("tan").unmangledNameHash());
    ASSERT_EQ(0x00000032u, ImmutableString("asin").unmangledNameHash());
    ASSERT_EQ(0x00000051u, ImmutableString("acos").unmangledNameHash());
    ASSERT_EQ(0x0000008eu, ImmutableString("atan").unmangledNameHash());
    ASSERT_EQ(0x00000046u, ImmutableString("sinh").unmangledNameHash());
    ASSERT_EQ(0x0000002eu, ImmutableString("cosh").unmangledNameHash());
    ASSERT_EQ(0x00000071u, ImmutableString("tanh").unmangledNameHash());
    ASSERT_EQ(0x00000079u, ImmutableString("asinh").unmangledNameHash());
    ASSERT_EQ(0x0000002cu, ImmutableString("acosh").unmangledNameHash());
    ASSERT_EQ(0x00000086u, ImmutableString("atanh").unmangledNameHash());
    ASSERT_EQ(0x00000056u, ImmutableString("pow").unmangledNameHash());
    ASSERT_EQ(0x000000a0u, ImmutableString("exp").unmangledNameHash());
    ASSERT_EQ(0x0000005fu, ImmutableString("log").unmangledNameHash());
    ASSERT_EQ(0x00000061u, ImmutableString("exp2").unmangledNameHash());
    ASSERT_EQ(0x0000003eu, ImmutableString("log2").unmangledNameHash());
    ASSERT_EQ(0x00000088u, ImmutableString("sqrt").unmangledNameHash());
    ASSERT_EQ(0x0000006fu, ImmutableString("inversesqrt").unmangledNameHash());
    ASSERT_EQ(0x0000003bu, ImmutableString("abs").unmangledNameHash());
    ASSERT_EQ(0x0000006eu, ImmutableString("sign").unmangledNameHash());
    ASSERT_EQ(0x00000084u, ImmutableString("floor").unmangledNameHash());
    ASSERT_EQ(0x00000048u, ImmutableString("trunc").unmangledNameHash());
    ASSERT_EQ(0x00000027u, ImmutableString("round").unmangledNameHash());
    ASSERT_EQ(0x00000017u, ImmutableString("roundEven").unmangledNameHash());
    ASSERT_EQ(0x0000001au, ImmutableString("ceil").unmangledNameHash());
    ASSERT_EQ(0x00000063u, ImmutableString("fract").unmangledNameHash());
    ASSERT_EQ(0x0000001eu, ImmutableString("mod").unmangledNameHash());
    ASSERT_EQ(0x0000009du, ImmutableString("min").unmangledNameHash());
    ASSERT_EQ(0x0000003cu, ImmutableString("max").unmangledNameHash());
    ASSERT_EQ(0x00000029u, ImmutableString("clamp").unmangledNameHash());
    ASSERT_EQ(0x00000089u, ImmutableString("mix").unmangledNameHash());
    ASSERT_EQ(0x00000045u, ImmutableString("step").unmangledNameHash());
    ASSERT_EQ(0x00000021u, ImmutableString("smoothstep").unmangledNameHash());
    ASSERT_EQ(0x00000025u, ImmutableString("modf").unmangledNameHash());
    ASSERT_EQ(0x00000033u, ImmutableString("isnan").unmangledNameHash());
    ASSERT_EQ(0x00000093u, ImmutableString("isinf").unmangledNameHash());
    ASSERT_EQ(0x0000001fu, ImmutableString("floatBitsToInt").unmangledNameHash());
    ASSERT_EQ(0x00000059u, ImmutableString("floatBitsToUint").unmangledNameHash());
    ASSERT_EQ(0x00000075u, ImmutableString("intBitsToFloat").unmangledNameHash());
    ASSERT_EQ(0x00000052u, ImmutableString("uintBitsToFloat").unmangledNameHash());
    ASSERT_EQ(0x00000066u, ImmutableString("fma").unmangledNameHash());
    ASSERT_EQ(0x00000011u, ImmutableString("frexp").unmangledNameHash());
    ASSERT_EQ(0x00000058u, ImmutableString("ldexp").unmangledNameHash());
    ASSERT_EQ(0x0000009fu, ImmutableString("packSnorm2x16").unmangledNameHash());
    ASSERT_EQ(0x000000a3u, ImmutableString("packHalf2x16").unmangledNameHash());
    ASSERT_EQ(0x0000003du, ImmutableString("unpackSnorm2x16").unmangledNameHash());
    ASSERT_EQ(0x00000054u, ImmutableString("unpackHalf2x16").unmangledNameHash());
    ASSERT_EQ(0x00000053u, ImmutableString("packUnorm2x16").unmangledNameHash());
    ASSERT_EQ(0x0000008fu, ImmutableString("unpackUnorm2x16").unmangledNameHash());
    ASSERT_EQ(0x0000006du, ImmutableString("packUnorm4x8").unmangledNameHash());
    ASSERT_EQ(0x0000000cu, ImmutableString("packSnorm4x8").unmangledNameHash());
    ASSERT_EQ(0x00000002u, ImmutableString("unpackUnorm4x8").unmangledNameHash());
    ASSERT_EQ(0x00000026u, ImmutableString("unpackSnorm4x8").unmangledNameHash());
    ASSERT_EQ(0x0000004fu, ImmutableString("length").unmangledNameHash());
    ASSERT_EQ(0x00000070u, ImmutableString("distance").unmangledNameHash());
    ASSERT_EQ(0x000000a5u, ImmutableString("dot").unmangledNameHash());
    ASSERT_EQ(0x00000087u, ImmutableString("cross").unmangledNameHash());
    ASSERT_EQ(0x00000081u, ImmutableString("normalize").unmangledNameHash());
    ASSERT_EQ(0x0000003au, ImmutableString("faceforward").unmangledNameHash());
    ASSERT_EQ(0x00000092u, ImmutableString("reflect").unmangledNameHash());
    ASSERT_EQ(0x0000009cu, ImmutableString("refract").unmangledNameHash());
    ASSERT_EQ(0x00000055u, ImmutableString("matrixCompMult").unmangledNameHash());
    ASSERT_EQ(0x0000009au, ImmutableString("outerProduct").unmangledNameHash());
    ASSERT_EQ(0x00000044u, ImmutableString("transpose").unmangledNameHash());
    ASSERT_EQ(0x00000067u, ImmutableString("determinant").unmangledNameHash());
    ASSERT_EQ(0x0000000du, ImmutableString("inverse").unmangledNameHash());
    ASSERT_EQ(0x00000023u, ImmutableString("lessThan").unmangledNameHash());
    ASSERT_EQ(0x00000043u, ImmutableString("lessThanEqual").unmangledNameHash());
    ASSERT_EQ(0x0000006au, ImmutableString("greaterThan").unmangledNameHash());
    ASSERT_EQ(0x00000069u, ImmutableString("greaterThanEqual").unmangledNameHash());
    ASSERT_EQ(0x0000004bu, ImmutableString("equal").unmangledNameHash());
    ASSERT_EQ(0x00000099u, ImmutableString("notEqual").unmangledNameHash());
    ASSERT_EQ(0x0000007fu, ImmutableString("any").unmangledNameHash());
    ASSERT_EQ(0x00000000u, ImmutableString("all").unmangledNameHash());
    ASSERT_EQ(0x0000001cu, ImmutableString("not").unmangledNameHash());
    ASSERT_EQ(0x00000076u, ImmutableString("bitfieldExtract").unmangledNameHash());
    ASSERT_EQ(0x0000006bu, ImmutableString("bitfieldInsert").unmangledNameHash());
    ASSERT_EQ(0x00000035u, ImmutableString("bitfieldReverse").unmangledNameHash());
    ASSERT_EQ(0x00000060u, ImmutableString("bitCount").unmangledNameHash());
    ASSERT_EQ(0x00000009u, ImmutableString("findLSB").unmangledNameHash());
    ASSERT_EQ(0x0000002au, ImmutableString("findMSB").unmangledNameHash());
    ASSERT_EQ(0x00000030u, ImmutableString("uaddCarry").unmangledNameHash());
    ASSERT_EQ(0x0000004du, ImmutableString("usubBorrow").unmangledNameHash());
    ASSERT_EQ(0x00000095u, ImmutableString("umulExtended").unmangledNameHash());
    ASSERT_EQ(0x00000013u, ImmutableString("imulExtended").unmangledNameHash());
    ASSERT_EQ(0x0000007bu, ImmutableString("texture2D").unmangledNameHash());
    ASSERT_EQ(0x00000041u, ImmutableString("texture2DProj").unmangledNameHash());
    ASSERT_EQ(0x0000009eu, ImmutableString("textureCube").unmangledNameHash());
    ASSERT_EQ(0x0000002bu, ImmutableString("texture2DRect").unmangledNameHash());
    ASSERT_EQ(0x0000001du, ImmutableString("texture2DRectProj").unmangledNameHash());
    ASSERT_EQ(0x00000010u, ImmutableString("texture").unmangledNameHash());
    ASSERT_EQ(0x00000001u, ImmutableString("textureProj").unmangledNameHash());
    ASSERT_EQ(0x00000072u, ImmutableString("texture2DGradEXT").unmangledNameHash());
    ASSERT_EQ(0x00000014u, ImmutableString("texture2DProjGradEXT").unmangledNameHash());
    ASSERT_EQ(0x0000000au, ImmutableString("textureCubeGradEXT").unmangledNameHash());
    ASSERT_EQ(0x00000036u, ImmutableString("dFdx").unmangledNameHash());
    ASSERT_EQ(0x00000024u, ImmutableString("dFdy").unmangledNameHash());
    ASSERT_EQ(0x00000005u, ImmutableString("fwidth").unmangledNameHash());
    ASSERT_EQ(0x0000004cu, ImmutableString("texture2DLodEXT").unmangledNameHash());
    ASSERT_EQ(0x00000018u, ImmutableString("texture2DProjLodEXT").unmangledNameHash());
    ASSERT_EQ(0x0000005bu, ImmutableString("textureCubeLodEXT").unmangledNameHash());
    ASSERT_EQ(0x0000007du, ImmutableString("shadow2DEXT").unmangledNameHash());
    ASSERT_EQ(0x0000007au, ImmutableString("shadow2DProjEXT").unmangledNameHash());
    ASSERT_EQ(0x00000094u, ImmutableString("texture3D").unmangledNameHash());
    ASSERT_EQ(0x0000006cu, ImmutableString("texture3DProj").unmangledNameHash());
    ASSERT_EQ(0x00000038u, ImmutableString("texture3DLod").unmangledNameHash());
    ASSERT_EQ(0x00000077u, ImmutableString("texture3DProjLod").unmangledNameHash());
    ASSERT_EQ(0x000000a4u, ImmutableString("texture2DLod").unmangledNameHash());
    ASSERT_EQ(0x00000057u, ImmutableString("texture2DProjLod").unmangledNameHash());
    ASSERT_EQ(0x0000000eu, ImmutableString("textureCubeLod").unmangledNameHash());
    ASSERT_EQ(0x00000039u, ImmutableString("textureLod").unmangledNameHash());
    ASSERT_EQ(0x00000050u, ImmutableString("textureSize").unmangledNameHash());
    ASSERT_EQ(0x0000005au, ImmutableString("textureProjLod").unmangledNameHash());
    ASSERT_EQ(0x00000097u, ImmutableString("texelFetch").unmangledNameHash());
    ASSERT_EQ(0x0000003fu, ImmutableString("textureGrad").unmangledNameHash());
    ASSERT_EQ(0x00000022u, ImmutableString("textureProjGrad").unmangledNameHash());
    ASSERT_EQ(0x00000068u, ImmutableString("textureGather").unmangledNameHash());
    ASSERT_EQ(0x00000028u, ImmutableString("textureOffset").unmangledNameHash());
    ASSERT_EQ(0x00000047u, ImmutableString("textureProjOffset").unmangledNameHash());
    ASSERT_EQ(0x00000085u, ImmutableString("textureLodOffset").unmangledNameHash());
    ASSERT_EQ(0x0000005eu, ImmutableString("textureProjLodOffset").unmangledNameHash());
    ASSERT_EQ(0x0000004eu, ImmutableString("texelFetchOffset").unmangledNameHash());
    ASSERT_EQ(0x0000008du, ImmutableString("textureGradOffset").unmangledNameHash());
    ASSERT_EQ(0x00000016u, ImmutableString("textureProjGradOffset").unmangledNameHash());
    ASSERT_EQ(0x00000006u, ImmutableString("rgb_2_yuv").unmangledNameHash());
    ASSERT_EQ(0x00000008u, ImmutableString("yuv_2_rgb").unmangledNameHash());
    ASSERT_EQ(0x00000065u, ImmutableString("textureGatherOffsets").unmangledNameHash());
    ASSERT_EQ(0x0000005du, ImmutableString("textureGatherOffset").unmangledNameHash());
    ASSERT_EQ(0x00000091u, ImmutableString("interpolateAtCentroid").unmangledNameHash());
    ASSERT_EQ(0x0000004au, ImmutableString("interpolateAtSample").unmangledNameHash());
    ASSERT_EQ(0x0000002du, ImmutableString("interpolateAtOffset").unmangledNameHash());
    ASSERT_EQ(0x00000074u, ImmutableString("atomicCounter").unmangledNameHash());
    ASSERT_EQ(0x00000007u, ImmutableString("atomicCounterIncrement").unmangledNameHash());
    ASSERT_EQ(0x00000042u, ImmutableString("atomicCounterDecrement").unmangledNameHash());
    ASSERT_EQ(0x00000078u, ImmutableString("atomicAdd").unmangledNameHash());
    ASSERT_EQ(0x000000a2u, ImmutableString("atomicMin").unmangledNameHash());
    ASSERT_EQ(0x00000034u, ImmutableString("atomicMax").unmangledNameHash());
    ASSERT_EQ(0x00000015u, ImmutableString("atomicAnd").unmangledNameHash());
    ASSERT_EQ(0x00000096u, ImmutableString("atomicOr").unmangledNameHash());
    ASSERT_EQ(0x00000080u, ImmutableString("atomicXor").unmangledNameHash());
    ASSERT_EQ(0x0000008bu, ImmutableString("atomicExchange").unmangledNameHash());
    ASSERT_EQ(0x00000062u, ImmutableString("atomicCompSwap").unmangledNameHash());
    ASSERT_EQ(0x0000009bu, ImmutableString("imageSize").unmangledNameHash());
    ASSERT_EQ(0x00000082u, ImmutableString("imageLoad").unmangledNameHash());
    ASSERT_EQ(0x0000000fu, ImmutableString("imageAtomicAdd").unmangledNameHash());
    ASSERT_EQ(0x0000008cu, ImmutableString("imageAtomicMin").unmangledNameHash());
    ASSERT_EQ(0x00000090u, ImmutableString("imageAtomicMax").unmangledNameHash());
    ASSERT_EQ(0x00000083u, ImmutableString("imageAtomicAnd").unmangledNameHash());
    ASSERT_EQ(0x00000031u, ImmutableString("imageAtomicOr").unmangledNameHash());
    ASSERT_EQ(0x0000002fu, ImmutableString("imageAtomicXor").unmangledNameHash());
    ASSERT_EQ(0x0000001bu, ImmutableString("imageAtomicExchange").unmangledNameHash());
    ASSERT_EQ(0x00000004u, ImmutableString("imageAtomicCompSwap").unmangledNameHash());
    ASSERT_EQ(0x0000005cu, ImmutableString("imageStore").unmangledNameHash());
    ASSERT_EQ(0x00000073u, ImmutableString("memoryBarrier").unmangledNameHash());
    ASSERT_EQ(0x00000019u, ImmutableString("memoryBarrierAtomicCounter").unmangledNameHash());
    ASSERT_EQ(0x0000007cu, ImmutableString("memoryBarrierBuffer").unmangledNameHash());
    ASSERT_EQ(0x0000000bu, ImmutableString("memoryBarrierImage").unmangledNameHash());
    ASSERT_EQ(0x00000040u, ImmutableString("barrier").unmangledNameHash());
    ASSERT_EQ(0x00000037u, ImmutableString("memoryBarrierShared").unmangledNameHash());
    ASSERT_EQ(0x000000a1u, ImmutableString("groupMemoryBarrier").unmangledNameHash());
    ASSERT_EQ(0x00000064u, ImmutableString("EmitVertex").unmangledNameHash());
    ASSERT_EQ(0x00000098u, ImmutableString("EndPrimitive").unmangledNameHash());
    ASSERT_EQ(0x00000003u, ImmutableString("textureVideoWEBGL").unmangledNameHash());
}

}  // namespace sh
