.TH DETEX 1L "12 August 1993" "Purdue University"
.SH NAME
detex \- a filter to strip \fITeX\fP commands from a .tex file.
.SH SYNOPSIS
.B detex
[ \fB\-clnstw\fR ] [ \fB\-e\fI environment-list\fR ] [ \fIfilename\fR[.tex] ... ]
.SH DESCRIPTION
.I Detex
(Version 2.8.3)
reads each file in sequence, removes all comments and
.I TeX
control sequences
and writes the remainder on the standard output.
All text in math mode and display mode is removed.
By default,
.I detex
follows \\input commands.
If a file cannot be opened, a warning message is
printed and the command is ignored.
If the
.B \-n
option is used, no \\input or \\include commands will be processed.
This allows single file processing.
If no input file is given on the command line,
.I detex
reads from standard input.
.PP
If the magic sequence ``\\begin{document}'' appears in the text,
.I detex
assumes it is dealing with
.I LaTeX
source and
.I detex
recognizes additional constructs used in
.IR LaTeX .
These include the \\include and \\includeonly commands.
The
.B \-l
option can be used to force
.I LaTeX
mode and the
.B \-t
option can be used to force
.I TeX
mode regardless of input content.
.PP
Text in various environment modes of
.I LaTeX
is ignored.  The default modes are array, eqnarray, equation, longtable,
picture, tabular and verbatim.  The
.B \-e
option can be used to specify a comma separated
.I environment-list
of environments to ignore.  The list replaces the defaults so specifying an
empty list effectively causes no environments to be ignored.
.PP
The
.B \-c
option can be used in
.I LaTeX
mode to have detex echo the arguments to \\cite,
\\ref, and \\pageref macros.  This can be useful when sending the output to
a style checker.
.PP
.I Detex
assumes the standard character classes are being used for
.IR TeX .
.I Detex
allows white space between control sequences
and magic characters like `{' when recognizing things like
.I LaTeX
environments.
.PP
The
.B \-r
option tries to naively replace $..$, $$..$$, \(..\) and \[..\]
with nouns and verbs (in particular, "noun" and "verbs")
in a way that keeps sentences readable.
.PP
If the
.B \-w
flag is given, the output is a word list, one `word' (string of two or more
letters and apostrophes beginning with a letter)
per line, and all other characters ignored.
Without \fB\-w\fR the output follows the original,
with the deletions mentioned above.  Newline characters are
preserved where possible
so that the lines of output match the input as closely as possible.
.PP
The TEXINPUTS environment variable is used to find \\input and \\include
files.  Like \fITeX\fP, it interprets a leading or trailing `:' as the default
TEXINPUTS.  It does \fInot\fP support the `//' directory expansion magic sequence.
.PP
Detex now handles the basic \fITeX\fP ligatures as a special case, replacing the
ligatures with acceptable charater substitutes.  This eliminates
spelling errors introduced by merely removing them.  The ligatures are
\\aa, \\ae, \\oe, \\ss, \\o, \\l (and their upper-case
equivalents).  The special "dotless" characters \\i and \\j are also
replaced with i and j respectively.
.PP
Note that previous versions of
.I detex
would replace control sequences with a space character to prevent words
from running together.
However, this caused accents in the middle of words to break words, generating
"spelling errors" that were not desirable.
Therefore, the new version merely removes these accents.
The old functionality can be essentially duplicated by using the
.B \-s
option.
.SH SEE ALSO
tex(1L)
.SH DIAGNOSTICS
Nesting of \\input is allowed but the number of opened files must not
exceed the system's limit on the number of simultaneously opened files.
.I Detex
ignores unrecognized option characters after printing a warning message.
.SH AUTHOR
Originally written by Daniel Trinkle, Computer Science Department, Purdue University
.PP
Maintained by Piotr Kubowicz <https://github.com/pkubowicz/opendetex>.
.SH BUGS
.I Detex
is not a complete
.I TeX
interpreter, so it can be confused by some constructs.
Most errors result in too much rather than too little output.
.PP
Running \fILaTeX\fR
source without a ``\\begin{document}''
through \fIdetex\fR may produce
errors.
.PP
Suggestions for improvements are (mildly) encouraged.
