/* -*- mode: C; indent-tabs-mode: t; tab-width: 8; c-basic-offset: 2; -*- */

/*
 * This file is part of Seed, the GObject Introspection<->Javascript bindings.
 *
 * Seed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 2 of
 * the License, or (at your option) any later version.
 * Seed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License
 * along with Seed.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright (C) Robert Carr 2009 <carrr@rpi.edu>
 */

#ifndef _SEED_IMPORTER_H
#define _SEED_IMPORTER_H

#include "seed-private.h"

extern JSObjectRef importer;

void seed_initialize_importer(JSContextRef ctx, JSObjectRef global);
JSObjectRef seed_gi_importer_do_namespace(JSContextRef ctx,
                                          gchar* namespace,
                                          JSValueRef* exception);

gboolean seed_importer_get_file_contents(const gchar* filename,
                                         gchar** contents,
                                         gsize* length,
                                         GError** error);

#endif
