#ifndef _RHEOLEF_SOLVER_WRAPPER_H
#define _RHEOLEF_SOLVER_WRAPPER_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
// solver wrapper implementation: direct or iterative with preconditioner
//
#include "rheolef/solver.h"

namespace rheolef {

// =======================================================================
// wrapper_rep
// =======================================================================
template<class T,class M>
class solver_wrapper_rep : public solver_abstract_rep<T,M> {
public:
  typedef solver_abstract_rep<T,M>	     base;
  typedef typename base::size_type           size_type;
  typedef typename base::determinant_type    determinant_type;

// allocator:

  solver_wrapper_rep ()
   : solver_abstract_rep<T,M>(solver_option()),
    _is_direct(),
    _is_sym(),
    _sa(),
    _a()
   {}
  explicit solver_wrapper_rep (const csr<T,M>& a, const solver_option& opt = solver_option());
  void update_values          (const csr<T,M>& a);
  void set_preconditionner    (const solver_basic<T,M>& sa) { _sa = sa; }
  ~solver_wrapper_rep ();

// accessors:

  vec<T,M> trans_solve (const vec<T,M>& rhs) const;
  vec<T,M> solve       (const vec<T,M>& rhs) const;
  determinant_type det() const;
  const solver_option& option() const { return solver_abstract_rep<T,M>::option(); }

// data:
protected:
  bool              _is_direct;
  bool              _is_sym;
  solver_basic<T,M> _sa; // factorization (when direct sover) or preconditionner (when iterative solver)
  csr<T,M>          _a;  // used only for iterative solvers
};

} // namespace rheolef
#endif // _RHEOLEF_SOLVER_WRAPPER_H
