dnl
dnl This file is part of Rheolef.
dnl
dnl Copyright (C) 2000-2009 Pierre Saramito 
dnl
dnl Rheolef is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2 of the License, or
dnl (at your option) any later version.
dnl 
dnl Rheolef is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl
dnl You should have received a copy of the GNU General Public License
dnl along with Rheolef; if not, write to the Free Software
dnl Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
dnl 
dnl ==========================================================================
dnl 
dnl Macro-expansion of .h and .c files using m4 :
dnl
dnl usage:
dnl        m4 < thisfile.m4 > thisfile.h
dnl        m4 -Dgenerate_body=1 < thisfile.m4 > thisfile.c
dnl
dnl author: Pierre.Saramito@imag.fr
dnl
dnl date : 24 march 1998
dnl
dnl contents
dnl  1.	dot and norm of a vector
dnl	unary operators (+,-) and functions (abs,cos,exp..)
dnl     binary operators (+,-,*,/) and functions (min,max,..)
dnl       with binary combinations scalar OP vector
dnl	  when scalar=Float
dnl
dnl  2. instanciation in library for the Float type
dnl
changequote(%{, %})dnl
dnl -----------------------------------------------------------------------------
dnl body($1=stmts)
dnl -----------------------------------------------------------------------------
define(body, dnl
ifelse(generate_body,1, %{
$1%},;
)dnl
)dnl
dnl -----------------------------------------------------------------------------
dnl body_declare($1=decls)
dnl -----------------------------------------------------------------------------
define(body_declare, dnl
ifelse(generate_body,1,dnl
%{$1%},dnl
)dnl
)dnl
dnl -----------------------------------------------------------------------------
dnl banner and includes
dnl -----------------------------------------------------------------------------
ifelse(generate_body,1,, %{dnl
#ifndef _SKIT_BLAS1_DENSE_NO_TMPL_H
#define _SKIT_BLAS1_DENSE_NO_TMPL_H
%})dnl
//
// file automatically generated using m4 expansion
//
// blas 1 expressions without template expression
// 
// author: Pierre.Saramito@imag.fr
//
// date: 1 april 1997
//
ifelse(generate_body,1,%{dnl
# include "blas1-dense-no-tmpl.h"
# include "blas-algorithm.h"
namespace rheolef {
%}dnl
,%{dnl
# include "vec.h"
namespace rheolef { 
%})dnl
dnl -----------------------------------------------------------------------------
body_declare(%{dnl

// ========================[ INLINE UTILITIES ]=================================
template <
    class PairInputIterator, 
    class T>
inline
T
normx (
    PairInputIterator iter_x, 
    PairInputIterator last_x, 
    const T&)
{
    T s = 0;
    while (iter_x != last_x) {
	s += sqr(*iter_x);
	++iter_x;
    }
    return std::sqrt(s);
}
template <
    class PairInputIterator1, 
    class PairInputIterator2,
    class T>
inline
T
xdoty (
    PairInputIterator1 iter_x, 
    PairInputIterator1 last_x, 
    PairInputIterator2 iter_y, 
    const T&)
{
    T s = 0;
    while (iter_x != last_x) {
	s += (*iter_x) * (*iter_y);
	++iter_x;
	++iter_y;
    }
    return s;
}
%})dnl
dnl ====================[ NORM AND DOT PRODUCT ]=================================
dnl    norm_dot_def()
dnl -----------------------------------------------------------------------------
define(norm_dot_def, %{dnl

// norm
template <class T>
T
norm (const vec<T>& x)dnl
body({
    return normx (x.begin(), x.end(), T());
})dnl

// dot product
template <class T>
T
dot (const vec<T>& x, const vec<T>& y)dnl
body({
    check_length(x,y);
    return xdoty (x.begin(), x.end(), y.begin(), T());
})dnl

%})dnl norm_dot_def
dnl -----------------------------------------------------------------------------
dnl    norm_dot_instanciate($1=float_type)
dnl -----------------------------------------------------------------------------
define(norm_dot_instanciate, %{dnl
body_declare(%{dnl
template $1 norm (const vec<$1>& x);
template $1 dot  (const vec<$1>& x, const vec<$1>& y);
%})dnl
%})dnl norm_dot_instanciate
dnl ======================[ DEF: UNARY OPERATORS ]===============================
dnl    unary_func_class($1=VecFct, $2=scalar_fct)
dnl -----------------------------------------------------------------------------
define(unary_func_class, %{dnl
body_declare(%{dnl

template<class T>
struct $1_op : std::unary_function<T, T> {
    T operator() (T x) const { return $2(x); }
};
%})dnl
%})dnl unary_func_class
dnl -----------------------------------------------------------------------------
dnl    unary_func_call($1=VecFct)
dnl -----------------------------------------------------------------------------
define(unary_func_call, %{dnl

template <class T>
vec<T>
$1 (const vec<T>& x)dnl
body({
    vec<T> z(x.n());
    zassignopx (z.begin(), z.end(), $1_op<T>(), x.begin());
    return z;
})dnl
%})dnl unary_func_call
dnl -----------------------------------------------------------------------------
dnl    unary_func2($1=VecFct, $2=scalar_fct)
dnl -----------------------------------------------------------------------------
define(unary_func2, %{dnl
unary_func_class($1,$2)dnl
unary_func_call($1)dnl
%})dnl unary_func2
dnl -----------------------------------------------------------------------------
dnl    unary_func($1=fct)
dnl -----------------------------------------------------------------------------
define(unary_func, %{dnl
unary_func2($1,$1)dnl
%})dnl unary_func
dnl -----------------------------------------------------------------------------
dnl    unary_func_instanciate($1=VecFct, $1=float_type)
dnl -----------------------------------------------------------------------------
define(unary_func_instanciate, %{dnl
body_declare(%{dnl
template vec<$2> $1 (const vec<$2>& x);
%})dnl
%})dnl unary_func_instanciate
dnl -----------------------------------------------------------------------------
dnl    unary_def()
dnl -----------------------------------------------------------------------------
define(unary_def, %{dnl

// unary operators
template <class T>
vec<T>
operator + (const vec<T>& x)dnl
body({
    return x;
})
template <class T>
vec<T>
operator - (const vec<T>& x)dnl
body({
    vec<T> z(x.n());
    zassignopx (z.begin(), z.end(), std::negate<T>(), x.begin());
    return z;
})
// unary functions
unary_func2(abs,xabs)dnl
dnl unary_func(tan)dnl not with bigfloat
dnl unary_func(acos)dnl not with bigfloat
dnl unary_func(asin)dnl not with bigfloat
unary_func2(atan,std::atan)dnl
unary_func2(cos,std::cos)dnl
unary_func2(cosh,std::cosh)dnl
unary_func2(exp,std::exp)dnl
unary_func2(log,std::log)dnl
unary_func2(log10,std::log10)dnl
unary_func2(sin,std::sin)dnl
unary_func2(sinh,std::sinh)dnl
unary_func2(sqrt,std::sqrt)dnl
unary_func2(tanh,std::tanh)dnl
%})dnl unary_def
dnl -----------------------------------------------------------------------------
dnl    unary_instanciate($1=float_type)
dnl -----------------------------------------------------------------------------
define(unary_instanciate, %{dnl
body_declare(%{dnl
template vec<$1> operator + (const vec<$1>&);
template vec<$1> operator - (const vec<$1>&);
unary_func_instanciate(abs,$1)dnl
dnl unary_func_instanciate(acos,$1)dnl not with bigfloat
dnl unary_func_instanciate(asin,$1)dnl not with bigfloat
unary_func_instanciate(atan,$1)dnl
unary_func_instanciate(cos,$1)dnl
unary_func_instanciate(cosh,$1)dnl
unary_func_instanciate(exp,$1)dnl
unary_func_instanciate(log,$1)dnl
unary_func_instanciate(log10,$1)dnl
unary_func_instanciate(sin,$1)dnl
unary_func_instanciate(sinh,$1)dnl
unary_func_instanciate(sqrt,$1)dnl
dnl unary_func_instanciate(tan,$1)dnl not with bigfloat
unary_func_instanciate(tanh,$1)dnl
%})dnl
%})dnl unary_instanciate
dnl =====================[ DEF: BINARY OPERATORS ]===============================
dnl    binary_generic($1=operator_name, $2=apply)
dnl -----------------------------------------------------------------------------
define(binary_generic, %{dnl

template <class T>
vec<T>
$1 (const vec<T>& x, const vec<T>& y)dnl
body({
    check_length(x,y);
    vec<T> z(x.n());
    zassignxopy (z.begin(), z.end(), $2<T, T, T>(), x.begin(), y.begin());
    return z;
})dnl
%})dnl binary_generic
dnl -----------------------------------------------------------------------------
dnl    binary_with_given_scalar($1=operator_name, $2=apply, $3=scalar_type)
dnl -----------------------------------------------------------------------------
define(binary_with_given_scalar, %{dnl

template <class T>
vec<T>
$1 (const vec<T>& x, const $3& lambda)dnl
body({
    vec<T> z(x.n());
    zassignopx (z.begin(), z.end(), bind2nd($2<T, $3, T>(), lambda), x.begin());
    return z;
})
template <class T>
vec<T>
$1 (const $3& lambda, const vec<T>& y)dnl
body({
    vec<T> z(y.n());
    zassignopx (z.begin(), z.end(), bind1st($2<$3, T, T>(), lambda), y.begin());
    return z;
})dnl
%})dnl binary_with_given_scalar
dnl -----------------------------------------------------------------------------
dnl    binary_basic($1=operator_name, $2=apply)
dnl -----------------------------------------------------------------------------
define(binary_basic, %{dnl
binary_generic($1, $2)dnl
binary_with_given_scalar($1, $2, Float)dnl
%})dnl binary_basic
dnl =====================[ DEF: COMPUTED ASSIGNMENT ]============================
dnl    computed_assignment_generic($1="op=", $2="Op_assign")
dnl -----------------------------------------------------------------------------
define(computed_assignment_generic, %{dnl

template <class T>
vec<T>&
operator $1 (vec<T>& z, const vec<T>& x)dnl
body({
    check_length(z,x);
    zopassignx ($2<T, T>(), z.begin(), z.end(), x.begin());
    return z;
})dnl
%})dnl computed_assignment_generic
dnl -----------------------------------------------------------------------------
dnl    computed_assignment_with_given_scalar($1="op=", $2="Op_assign", $3=sal_t)
dnl -----------------------------------------------------------------------------
define(computed_assignment_with_given_scalar, %{dnl

template <class T>
vec<T>&
operator $1 (vec<T>& z, const $3& lambda)dnl
body({
    zopassignr ($2<T, $3>(), z.begin(), z.end(), lambda);
    return z;
})dnl
%})dnl computed_assignment_with_given_scalar
dnl -----------------------------------------------------------------------------
dnl    computed_assignment($1=operator_name, $2=apply)
dnl -----------------------------------------------------------------------------
define(computed_assignment, %{dnl
computed_assignment_generic($1, $2)dnl
computed_assignment_with_given_scalar($1, $2, Float)dnl
%})dnl computed_assignment
dnl -----------------------------------------------------------------------------
dnl    binary_operator($1=op, $2=Op)
dnl -----------------------------------------------------------------------------
define(binary_operator, %{dnl
binary_basic(operator $1, $2_op)dnl
computed_assignment($1=,$2_assign)dnl
%})dnl binary_operator
dnl -----------------------------------------------------------------------------
dnl    binary_operator_instanciate($1=op, $2=float_type)
dnl -----------------------------------------------------------------------------
define(binary_operator_instanciate, %{dnl
body_declare(%{dnl
template vec<$2>  operator $1  (const vec<$2>&, const vec<$2>&);
template vec<$2>  operator $1  (const vec<$2>&, const Float&);
template vec<$2>  operator $1  (const Float&, const vec<$2>&);
template vec<$2>& operator $1= (vec<$2>&, const vec<$2>&);
template vec<$2>& operator $1= (vec<$2>&, const Float&);
%})dnl
%})dnl binary_operator_instanciate
dnl -----------------------------------------------------------------------------
dnl    binary_func_class($1=vec_fct, $2=scalar_fct)
dnl -----------------------------------------------------------------------------
define(binary_func_class, %{dnl
body_declare(%{dnl

template<class T1, class T2, class T3>
struct $1_op : std::binary_function<T1, T2, T3> {
T3 operator() (T1 x, T2 y) const { return $2(x,y); }
};dnl
%})dnl
%})dnl binary_func_class
dnl -----------------------------------------------------------------------------
dnl    binary_func($1=vec_fct, $2=scalar_fct)
dnl -----------------------------------------------------------------------------
define(binary_func, %{dnl
binary_func_class($1,$2)dnl
binary_basic($1, $1_op)dnl
%})dnl binary_func
dnl -----------------------------------------------------------------------------
dnl    binary_func_instanciate($1=f, $2=float_type)
dnl -----------------------------------------------------------------------------
define(binary_func_instanciate, %{dnl
body_declare(%{dnl
template vec<$2> $1 (const vec<$2>&, const vec<$2>&);
template vec<$2> $1 (const vec<$2>&, const Float&);
template vec<$2> $1 (const Float&,   const vec<$2>&);
%})dnl
%})dnl binary_func_instanciate
dnl -----------------------------------------------------------------------------
dnl    binary_def()
dnl -----------------------------------------------------------------------------
define(binary_def, %{dnl

// binary operators and computed assignments
binary_operator(+,add)dnl
binary_operator(-,sub)dnl
binary_operator(*,mul)dnl
binary_operator(/,div)dnl

// binary functions
binary_func(atan2,std::atan2)dnl
binary_func(max,std::max)dnl
binary_func(min,std::min)dnl
binary_func(pow,std::pow)dnl
%})dnl binary_def
dnl -----------------------------------------------------------------------------
dnl    binary_instanciate($1=float_type)
dnl -----------------------------------------------------------------------------
define(binary_instanciate, %{dnl
binary_operator_instanciate(+,$1)dnl
binary_operator_instanciate(-,$1)dnl
binary_operator_instanciate(/,$1)dnl
binary_operator_instanciate(*,$1)dnl
dnl
binary_func_instanciate(atan2,Float)dnl
binary_func_instanciate(max,Float)dnl
binary_func_instanciate(min,Float)dnl
binary_func_instanciate(pow,Float)dnl
%})dnl binary_instanciate
dnl -----------------------------------------------------------------------------
dnl    blas_dense()
dnl -----------------------------------------------------------------------------
define(blas_dense, %{dnl
norm_dot_def()dnl
unary_def()dnl
binary_def()dnl
%})dnl blas_dense
dnl -----------------------------------------------------------------------------
dnl    blas_dense_instanciate($1=float_type)
dnl -----------------------------------------------------------------------------
define(blas_dense_instanciate, %{dnl

// =====================[ INSTANCIATION IN LIBRARY ]=============================
norm_dot_instanciate($1)dnl
unary_instanciate($1)dnl
binary_instanciate($1)dnl
%})dnl blas_dense_instanciate
dnl =================[ GLOBAL MACRO EXPANSION ]==================================
blas_dense()dnl
blas_dense_instanciate(Float)dnl
ifelse(generate_body,1,

}// namespace rheolef
,dnl

}// namespace rheolef
#endif // _SKIT_BLAS1_DENSE_NO_TMPL_H
)dnl
