// Cg shaders, as static data buffers for release mode builds
// DO NOT EDIT - this file is autogenerated - see BUILD.txt
// To regenerate this file, run: premake4 embed

struct cgShaderDef_t
{
	const char* name;
	const char* shaderText;
};

static const cgShaderDef_t cg_renderprogs[] =
{
	{
		"renderprogs/global.inc",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2013-2016 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"uniform float4 rpScreenCorrectionFactor	:	register(c0);\n"
		"uniform float4 rpWindowCoord			:	register(c1);\n"
		"uniform float4 rpDiffuseModifier		:	register(c2);\n"
		"uniform float4 rpSpecularModifier		:	register(c3);\n"
		"\n"
		"uniform float4 rpLocalLightOrigin		:	register(c4);\n"
		"uniform float4 rpLocalViewOrigin		:	register(c5);\n"
		"\n"
		"uniform float4 rpLightProjectionS		:	register(c6);\n"
		"uniform float4 rpLightProjectionT		:	register(c7);\n"
		"uniform float4 rpLightProjectionQ		:	register(c8);\n"
		"uniform float4 rpLightFalloffS			:	register(c9);\n"
		"\n"
		"uniform float4 rpBumpMatrixS			:	register(c10);\n"
		"uniform float4 rpBumpMatrixT			:	register(c11);\n"
		"\n"
		"uniform float4 rpDiffuseMatrixS			:	register(c12);\n"
		"uniform float4 rpDiffuseMatrixT			:	register(c13);\n"
		"\n"
		"uniform float4 rpSpecularMatrixS		:	register(c14);\n"
		"uniform float4 rpSpecularMatrixT		:	register(c15);\n"
		"\n"
		"uniform float4 rpVertexColorModulate	:	register(c16);\n"
		"uniform float4 rpVertexColorAdd			:	register(c17);\n"
		"\n"
		"uniform float4 rpColor					:	register(c18);\n"
		"uniform float4 rpViewOrigin				:	register(c19);\n"
		"uniform float4 rpGlobalEyePos			:	register(c20);\n"
		"\n"
		"uniform float4 rpMVPmatrixX				:	register(c21);\n"
		"uniform float4 rpMVPmatrixY				:	register(c22);\n"
		"uniform float4 rpMVPmatrixZ				:	register(c23);\n"
		"uniform float4 rpMVPmatrixW				:	register(c24);\n"
		"\n"
		"uniform float4 rpModelMatrixX			:	register(c25);\n"
		"uniform float4 rpModelMatrixY			:	register(c26);\n"
		"uniform float4 rpModelMatrixZ			:	register(c27);\n"
		"uniform float4 rpModelMatrixW			:	register(c28);\n"
		"\n"
		"uniform float4 rpProjectionMatrixX		:	register(c29);\n"
		"uniform float4 rpProjectionMatrixY		:	register(c30);\n"
		"uniform float4 rpProjectionMatrixZ		:	register(c31);\n"
		"uniform float4 rpProjectionMatrixW		:	register(c32);\n"
		"\n"
		"uniform float4 rpModelViewMatrixX		:	register(c33);\n"
		"uniform float4 rpModelViewMatrixY		:	register(c34);\n"
		"uniform float4 rpModelViewMatrixZ		:	register(c35);\n"
		"uniform float4 rpModelViewMatrixW		:	register(c36);\n"
		"\n"
		"uniform float4 rpTextureMatrixS			:	register(c37);\n"
		"uniform float4 rpTextureMatrixT			:	register(c38);\n"
		"\n"
		"uniform float4 rpTexGen0S				:	register(c39);\n"
		"uniform float4 rpTexGen0T				:	register(c40);\n"
		"uniform float4 rpTexGen0Q				:	register(c41);\n"
		"uniform float4 rpTexGen0Enabled			:	register(c42);\n"
		"\n"
		"uniform float4 rpTexGen1S				:	register(c43);\n"
		"uniform float4 rpTexGen1T				:	register(c44);\n"
		"uniform float4 rpTexGen1Q				:	register(c45);\n"
		"uniform float4 rpTexGen1Enabled			:	register(c46);\n"
		"\n"
		"uniform float4 rpWobbleSkyX				:	register(c47);\n"
		"uniform float4 rpWobbleSkyY				:	register(c48);\n"
		"uniform float4 rpWobbleSkyZ				:	register(c49);\n"
		"\n"
		"uniform float4 rpOverbright				:	register(c50);\n"
		"uniform float4 rpEnableSkinning			:	register(c51);\n"
		"uniform float4 rpAlphaTest				:	register(c52);\n"
		"\n"
		"// RB begin\n"
		"uniform float4 rpAmbientColor			:	register(c53);\n"
		"uniform float4 rpGlobalLightOrigin		:	register(c54);\n"
		"uniform float4 rpJitterTexScale			:	register(c55);\n"
		"uniform float4 rpJitterTexOffset		:	register(c56);\n"
		"uniform float4 rpCascadeDistances		:	register(c57);\n"
		"\n"
		"#if defined( USE_UNIFORM_ARRAYS )\n"
		"uniform float4 rpShadowMatrices			:	register(c58);\n"
		"#else\n"
		"uniform float4 rpShadowMatrices[6*4]	:	register(c59);\n"
		"#endif\n"
		"// RB end\n"
		"\n"
		"static float dot2( float2 a, float2 b ) { return dot( a, b ); }\n"
		"static float dot3( float3 a, float3 b ) { return dot( a, b ); }\n"
		"static float dot3( float3 a, float4 b ) { return dot( a, b.xyz ); }\n"
		"static float dot3( float4 a, float3 b ) { return dot( a.xyz, b ); }\n"
		"static float dot3( float4 a, float4 b ) { return dot( a.xyz, b.xyz ); }\n"
		"static float dot4( float4 a, float4 b ) { return dot( a, b ); }\n"
		"static float dot4( float2 a, float4 b ) { return dot( float4( a, 0, 1 ), b ); }\n"
		"\n"
		"// RB begin\n"
		"#ifndef PI\n"
		"#define PI	3.14159265358979323846\n"
		"#endif\n"
		"\n"
		"#define DEG2RAD( a )				( ( a ) * PI / 180.0f )\n"
		"#define RAD2DEG( a )				( ( a ) * 180.0f / PI )\n"
		"\n"
		"// ----------------------\n"
		"// sRGB <-> Linear RGB Color Conversion\n"
		"// ----------------------\n"
		"\n"
		"half3 sRGBToLinearRGB( half3 rgb )\n"
		"{\n"
		"#if defined( USE_LINEAR_RGB ) && !defined( USE_SRGB )\n"
		"	return max( pow( rgb, half3( 2.2 ) ), half3( 0.0 ) );\n"
		"#else\n"
		"	return rgb;\n"
		"#endif\n"
		"}\n"
		"\n"
		"half4 sRGBAToLinearRGBA( half4 rgba )\n"
		"{\n"
		"#if defined( USE_LINEAR_RGB ) && !defined( USE_SRGB )\n"
		"	return float4( max( pow( rgba.rgb, half3( 2.2 ) ), half3( 0.0 ) ), rgba.a );\n"
		"#else\n"
		"	return rgba;\n"
		"#endif\n"
		"}\n"
		"\n"
		"half3 LinearRGBToSRGB( half3 rgb )\n"
		"{\n"
		"#if defined( USE_LINEAR_RGB ) && !defined( USE_SRGB )\n"
		"	return pow( rgb, half3( 1.0 ) / half3( 2.2 ) );\n"
		"#else\n"
		"	return rgb;\n"
		"#endif\n"
		"}\n"
		"\n"
		"half4 LinearRGBToSRGB( half4 rgba )\n"
		"{\n"
		"#if defined( USE_LINEAR_RGB ) && !defined( USE_SRGB )\n"
		"	rgba.rgb = pow( rgba.rgb, half3( 1.0 ) / half3( 2.2 ) );\n"
		"	return rgba; //pow( rgba, half4( 1.0 ) / half4( 2.2 ) );\n"
		"#else\n"
		"	return rgba;\n"
		"#endif\n"
		"}\n"
		"\n"
		"\n"
		"// RB end\n"
		"\n"
		"// ----------------------\n"
		"// YCoCg Color Conversion\n"
		"// ----------------------\n"
		"static const half4 matrixRGB1toCoCg1YX = half4(  0.50,  0.0, -0.50, 0.50196078 );	// Co\n"
		"static const half4 matrixRGB1toCoCg1YY = half4( -0.25,  0.5, -0.25, 0.50196078 );	// Cg\n"
		"static const half4 matrixRGB1toCoCg1YZ = half4(  0.0,   0.0,  0.0,  1.0 );			// 1.0\n"
		"static const half4 matrixRGB1toCoCg1YW = half4(  0.25,  0.5,  0.25, 0.0 );			// Y\n"
		"\n"
		"static const half4 matrixCoCg1YtoRGB1X = half4(  1.0, -1.0,  0.0,        1.0 );\n"
		"static const half4 matrixCoCg1YtoRGB1Y = half4(  0.0,  1.0, -0.50196078, 1.0 ); // -0.5 * 256.0 / 255.0\n"
		"static const half4 matrixCoCg1YtoRGB1Z = half4( -1.0, -1.0,  1.00392156, 1.0 ); // +1.0 * 256.0 / 255.0\n"
		"\n"
		"static half3 ConvertYCoCgToRGB( half4 YCoCg ) {\n"
		"	half3 rgbColor;\n"
		"\n"
		"	YCoCg.z = ( YCoCg.z * 31.875 ) + 1.0;			//z = z * 255.0/8.0 + 1.0\n"
		"	YCoCg.z = 1.0 / YCoCg.z;\n"
		"	YCoCg.xy *= YCoCg.z;\n"
		"	rgbColor.x = dot4( YCoCg, matrixCoCg1YtoRGB1X );\n"
		"	rgbColor.y = dot4( YCoCg, matrixCoCg1YtoRGB1Y );\n"
		"	rgbColor.z = dot4( YCoCg, matrixCoCg1YtoRGB1Z );\n"
		"	return rgbColor;\n"
		"}\n"
		"\n"
		"static float2 CenterScale( float2 inTC, float2 centerScale ) {\n"
		"	float scaleX = centerScale.x;\n"
		"	float scaleY = centerScale.y;\n"
		"	float4 tc0 = float4( scaleX, 0, 0, 0.5 - ( 0.5f * scaleX ) );\n"
		"	float4 tc1 = float4( 0, scaleY, 0, 0.5 - ( 0.5f * scaleY ) );\n"
		"\n"
		"	float2 finalTC;\n"
		"	finalTC.x = dot4( inTC, tc0 );\n"
		"	finalTC.y = dot4( inTC, tc1 );\n"
		"	return finalTC;\n"
		"}\n"
		"\n"
		"static float2 Rotate2D( float2 inTC, float2 cs ) {\n"
		"	float sinValue = cs.y;\n"
		"	float cosValue = cs.x;\n"
		"\n"
		"	float4 tc0 = float4( cosValue, -sinValue, 0, ( -0.5f * cosValue ) + ( 0.5f * sinValue ) + 0.5f );\n"
		"	float4 tc1 = float4( sinValue, cosValue, 0, ( -0.5f * sinValue ) + ( -0.5f * cosValue ) + 0.5f );\n"
		"\n"
		"	float2 finalTC;\n"
		"	finalTC.x = dot4( inTC, tc0 );\n"
		"	finalTC.y = dot4( inTC, tc1 );\n"
		"	return finalTC;\n"
		"}\n"
		"\n"
		"// better noise function available at https://github.com/ashima/webgl-noise\n"
		"float rand( float2 co ) {\n"
		"    return frac( sin( dot( co.xy, float2( 12.9898, 78.233 ) ) ) * 43758.5453 );\n"
		"}\n"
		"\n"
		"#define square( x )		( x * x )\n"
		"\n"
		"static const half4 LUMINANCE_SRGB = half4( 0.2125, 0.7154, 0.0721, 0.0 );\n"
		"static const half4 LUMINANCE_LINEAR = half4( 0.299, 0.587, 0.144, 0.0 );\n"
		"\n"
		"#define _half2( x )		half2( x )\n"
		"#define _half3( x )		half3( x )\n"
		"#define _half4( x )		half4( x )\n"
		"#define _float2( x )	float2( x )\n"
		"#define _float3( x )	float3( x )\n"
		"#define _float4( x )	float4( x )\n"
		"\n"
		"#define VPOS WPOS\n"
		"static float4 idtex2Dproj( sampler2D samp, float4 texCoords ) { return tex2Dproj( samp, texCoords.xyw ); }\n"
		"static float4 swizzleColor( float4 c )\n"
		"{ \n"
		"	return c;\n"
		"	//return sRGBAToLinearRGBA( c ); \n"
		"}\n"
		"static float2 vposToScreenPosTexCoord( float2 vpos ) { return vpos.xy * rpWindowCoord.xy; }\n"
		"\n"
		"#define BRANCH\n"
		"#define IFANY\n"
		"\n"
		
	},
	
	{
		"renderprogs/skinning.inc",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2013-2014 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"float4 modelPosition = vertex.position;\n"
		"\n"
		"// RB: no GPU skinning with ES 2.0\n"
		"#if defined(USE_GPU_SKINNING)\n"
		"BRANCH if ( rpEnableSkinning.x > 0.0 ) {\n"
		"	//--------------------------------------------------------------\n"
		"	// GPU transformation of the normal / binormal / bitangent\n"
		"	//\n"
		"	// multiplying with 255.1 give us the same result and is faster than floor( w * 255 + 0.5 )\n"
		"	//--------------------------------------------------------------\n"
		"	const float w0 = vertex.color2.x;\n"
		"	const float w1 = vertex.color2.y;\n"
		"	const float w2 = vertex.color2.z;\n"
		"	const float w3 = vertex.color2.w;\n"
		"\n"
		"	float4 matX, matY, matZ;	// must be float4 for vec4\n"
		"	int joint = int(vertex.color.x * 255.1 * 3.0);\n"
		"	matX = matrices[int(joint+0)] * w0;\n"
		"	matY = matrices[int(joint+1)] * w0;\n"
		"	matZ = matrices[int(joint+2)] * w0;\n"
		"\n"
		"	joint = int(vertex.color.y * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w1;\n"
		"	matY += matrices[int(joint+1)] * w1;\n"
		"	matZ += matrices[int(joint+2)] * w1;\n"
		"\n"
		"	joint = int(vertex.color.z * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w2;\n"
		"	matY += matrices[int(joint+1)] * w2;\n"
		"	matZ += matrices[int(joint+2)] * w2;\n"
		"\n"
		"	joint = int(vertex.color.w * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w3;\n"
		"	matY += matrices[int(joint+1)] * w3;\n"
		"	matZ += matrices[int(joint+2)] * w3;\n"
		"\n"
		"	modelPosition.x = dot4( matX, vertex.position );\n"
		"	modelPosition.y = dot4( matY, vertex.position );\n"
		"	modelPosition.z = dot4( matZ, vertex.position );\n"
		"	modelPosition.w = 1.0;\n"
		"}\n"
		"#endif\n"
		"// RB end\n"
		"\n"
		"result.position.x = dot4( modelPosition, rpMVPmatrixX );\n"
		"result.position.y = dot4( modelPosition, rpMVPmatrixY );\n"
		"result.position.z = dot4( modelPosition, rpMVPmatrixZ );\n"
		"result.position.w = dot4( modelPosition, rpMVPmatrixW );\n"
		
	},
	
	{
		"renderprogs/SMAA.inc",
		"/**\n"
		" * Copyright (C) 2013 Jorge Jimenez (jorge@iryoku.com)\n"
		" * Copyright (C) 2013 Jose I. Echevarria (joseignacioechevarria@gmail.com)\n"
		" * Copyright (C) 2013 Belen Masia (bmasia@unizar.es)\n"
		" * Copyright (C) 2013 Fernando Navarro (fernandn@microsoft.com)\n"
		" * Copyright (C) 2013 Diego Gutierrez (diegog@unizar.es)\n"
		" *\n"
		" * Permission is hereby granted, free of charge, to any person obtaining a copy\n"
		" * this software and associated documentation files (the \"Software\"), to deal in\n"
		" * the Software without restriction, including without limitation the rights to\n"
		" * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies\n"
		" * of the Software, and to permit persons to whom the Software is furnished to\n"
		" * do so, subject to the following conditions:\n"
		" *\n"
		" * The above copyright notice and this permission notice shall be included in\n"
		" * all copies or substantial portions of the Software. As clarification, there\n"
		" * is no requirement that the copyright notice and permission be included in\n"
		" * binary distributions of the Software.\n"
		" *\n"
		" * THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n"
		" * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n"
		" * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n"
		" * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n"
		" * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\n"
		" * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE\n"
		" * SOFTWARE.\n"
		" */\n"
		"\n"
		"\n"
		"/**\n"
		" * \n"
		" *                               E N H A N C E D\n"
		" *       S U B P I X E L   M O R P H O L O G I C A L   A N T I A L I A S I N G\n"
		" *\n"
		" *                         http://www.iryoku.com/smaa/\n"
		" *\n"
		" * Hi, welcome aboard!\n"
		" * \n"
		" * Here you'll find instructions to get the shader up and running as fast as\n"
		" * possible.\n"
		" *\n"
		" * IMPORTANTE NOTICE: when updating, remember to update both this file and the\n"
		" * precomputed textures! They may change from version to version.\n"
		" *\n"
		" * The shader has three passes, chained together as follows:\n"
		" *\n"
		" *                           |input|------------------\n"
		" *                              v                     |\n"
		" *                    [ SMAA*EdgeDetection ]          |\n"
		" *                              v                     |\n"
		" *                          |edgesTex|                |\n"
		" *                              v                     |\n"
		" *              [ SMAABlendingWeightCalculation ]     |\n"
		" *                              v                     |\n"
		" *                          |blendTex|                |\n"
		" *                              v                     |\n"
		" *                [ SMAANeighborhoodBlending ] <------\n"
		" *                              v\n"
		" *                           |output|\n"
		" *\n"
		" * Note that each [pass] has its own vertex and pixel shader. Remember to use\n"
		" * oversized triangles instead of quads to avoid overshading along the\n"
		" * diagonal.\n"
		" *\n"
		" * You've three edge detection methods to choose from: luma, color or depth.\n"
		" * They represent different quality/performance and anti-aliasing/sharpness\n"
		" * tradeoffs, so our recommendation is for you to choose the one that best\n"
		" * suits your particular scenario:\n"
		" *\n"
		" * - Depth edge detection is usually the fastest but it may miss some edges.\n"
		" *\n"
		" * - Luma edge detection is usually more expensive than depth edge detection,\n"
		" *   but catches visible edges that depth edge detection can miss.\n"
		" *\n"
		" * - Color edge detection is usually the most expensive one but catches\n"
		" *   chroma-only edges.\n"
		" *\n"
		" * For quickstarters: just use luma edge detection.\n"
		" *\n"
		" * The general advice is to not rush the integration process and ensure each\n"
		" * step is done correctly (don't try to integrate SMAA T2x with predicated edge\n"
		" * detection from the start!). Ok then, let's go!\n"
		" *\n"
		" *  1. The first step is to create two RGBA temporal render targets for holding\n"
		" *     |edgesTex| and |blendTex|.\n"
		" *\n"
		" *     In DX10 or DX11, you can use a RG render target for the edges texture.\n"
		" *     In the case of NVIDIA GPUs, using RG render targets seems to actually be\n"
		" *     slower.\n"
		" *\n"
		" *     On the Xbox 360, you can use the same render target for resolving both\n"
		" *     |edgesTex| and |blendTex|, as they aren't needed simultaneously.\n"
		" *\n"
		" *  2. Both temporal render targets |edgesTex| and |blendTex| must be cleared\n"
		" *     each frame. Do not forget to clear the alpha channel!\n"
		" *\n"
		" *  3. The next step is loading the two supporting precalculated textures,\n"
		" *     'areaTex' and 'searchTex'. You'll find them in the 'Textures' folder as\n"
		" *     C++ headers, and also as regular DDS files. They'll be needed for the\n"
		" *     'SMAABlendingWeightCalculation' pass.\n"
		" *\n"
		" *     If you use the C++ headers, be sure to load them in the format specified\n"
		" *     inside of them.\n"
		" *\n"
		" *     You can also compress 'areaTex' and 'searchTex' using BC5 and BC4\n"
		" *     respectively, if you have that option in your content processor pipeline.\n"
		" *     When compressing then, you get a non-perceptible quality decrease, and a\n"
		" *     marginal performance increase.\n"
		" *\n"
		" *  4. All samplers must be set to linear filtering and clamp.\n"
		" *\n"
		" *     After you get the technique working, remember that 64-bit inputs have\n"
		" *     half-rate linear filtering on GCN.\n"
		" *\n"
		" *     If SMAA is applied to 64-bit color buffers, switching to point filtering\n"
		" *     when accesing them will increase the performance. Search for\n"
		" *     'SMAASamplePoint' to see which textures may benefit from point\n"
		" *     filtering, and where (which is basically the color input in the edge\n"
		" *     detection and resolve passes).\n"
		" *\n"
		" *  5. All texture reads and buffer writes must be non-sRGB, with the exception\n"
		" *     of the input read and the output write in\n"
		" *     'SMAANeighborhoodBlending' (and only in this pass!). If sRGB reads in\n"
		" *     this last pass are not possible, the technique will work anyway, but\n"
		" *     will perform antialiasing in gamma space.\n"
		" *\n"
		" *     IMPORTANT: for best results the input read for the color/luma edge \n"
		" *     detection should *NOT* be sRGB.\n"
		" *\n"
		" *  6. Before including SMAA.h you'll have to setup the render target metrics,\n"
		" *     the target and any optional configuration defines. Optionally you can\n"
		" *     use a preset.\n"
		" *\n"
		" *     You have the following targets available: \n"
		" *         SMAA_HLSL_3\n"
		" *         SMAA_HLSL_4\n"
		" *         SMAA_HLSL_4_1\n"
		" *         SMAA_GLSL_3 *\n"
		" *         SMAA_GLSL_4 *\n"
		" *\n"
		" *         * (See SMAA_INCLUDE_VS and SMAA_INCLUDE_PS below).\n"
		" *\n"
		" *     And four presets:\n"
		" *         SMAA_PRESET_LOW          (%60 of the quality)\n"
		" *         SMAA_PRESET_MEDIUM       (%80 of the quality)\n"
		" *         SMAA_PRESET_HIGH         (%95 of the quality)\n"
		" *         SMAA_PRESET_ULTRA        (%99 of the quality)\n"
		" *\n"
		" *     For example:\n"
		" *         #define SMAA_RT_METRICS float4(1.0 / 1280.0, 1.0 / 720.0, 1280.0, 720.0)\n"
		" *         #define SMAA_HLSL_4\n"
		" *         #define SMAA_PRESET_HIGH\n"
		" *         #include \"SMAA.h\"\n"
		" *\n"
		" *     Note that SMAA_RT_METRICS doesn't need to be a macro, it can be a\n"
		" *     uniform variable. The code is designed to minimize the impact of not\n"
		" *     using a constant value, but it is still better to hardcode it.\n"
		" *\n"
		" *     Depending on how you encoded 'areaTex' and 'searchTex', you may have to\n"
		" *     add (and customize) the following defines before including SMAA.h:\n"
		" *          #define SMAA_AREATEX_SELECT(sample) sample.rg\n"
		" *          #define SMAA_SEARCHTEX_SELECT(sample) sample.r\n"
		" *\n"
		" *     If your engine is already using porting macros, you can define\n"
		" *     SMAA_CUSTOM_SL, and define the porting functions by yourself.\n"
		" *\n"
		" *  7. Then, you'll have to setup the passes as indicated in the scheme above.\n"
		" *     You can take a look into SMAA.fx, to see how we did it for our demo.\n"
		" *     Checkout the function wrappers, you may want to copy-paste them!\n"
		" *\n"
		" *  8. It's recommended to validate the produced |edgesTex| and |blendTex|.\n"
		" *     You can use a screenshot from your engine to compare the |edgesTex|\n"
		" *     and |blendTex| produced inside of the engine with the results obtained\n"
		" *     with the reference demo.\n"
		" *\n"
		" *  9. After you get the last pass to work, it's time to optimize. You'll have\n"
		" *     to initialize a stencil buffer in the first pass (discard is already in\n"
		" *     the code), then mask execution by using it the second pass. The last\n"
		" *     pass should be executed in all pixels.\n"
		" *\n"
		" *\n"
		" * After this point you can choose to enable predicated thresholding,\n"
		" * temporal supersampling and motion blur integration:\n"
		" *\n"
		" * a) If you want to use predicated thresholding, take a look into\n"
		" *    SMAA_PREDICATION; you'll need to pass an extra texture in the edge\n"
		" *    detection pass.\n"
		" *\n"
		" * b) If you want to enable temporal supersampling (SMAA T2x):\n"
		" *\n"
		" * 1. The first step is to render using subpixel jitters. I won't go into\n"
		" *    detail, but it's as simple as moving each vertex position in the\n"
		" *    vertex shader, you can check how we do it in our DX10 demo.\n"
		" *\n"
		" * 2. Then, you must setup the temporal resolve. You may want to take a look\n"
		" *    into SMAAResolve for resolving 2x modes. After you get it working, you'll\n"
		" *    probably see ghosting everywhere. But fear not, you can enable the\n"
		" *    CryENGINE temporal reprojection by setting the SMAA_REPROJECTION macro.\n"
		" *    Check out SMAA_DECODE_VELOCITY if your velocity buffer is encoded.\n"
		" *\n"
		" * 3. The next step is to apply SMAA to each subpixel jittered frame, just as\n"
		" *    done for 1x.\n"
		" *\n"
		" * 4. At this point you should already have something usable, but for best\n"
		" *    results the proper area textures must be set depending on current jitter.\n"
		" *    For this, the parameter 'subsampleIndices' of\n"
		" *    'SMAABlendingWeightCalculationPS' must be set as follows, for our T2x\n"
		" *    mode:\n"
		" *\n"
		" *    @SUBSAMPLE_INDICES\n"
		" *\n"
		" *    | S# |  Camera Jitter   |  subsampleIndices    |\n"
		" *    +----+------------------+---------------------+\n"
		" *    |  0 |  ( 0.25, -0.25)  |  float4(1, 1, 1, 0)  |\n"
		" *    |  1 |  (-0.25,  0.25)  |  float4(2, 2, 2, 0)  |\n"
		" *\n"
		" *    These jitter positions assume a bottom-to-top y axis. S# stands for the\n"
		" *    sample number.\n"
		" *\n"
		" * More information about temporal supersampling here:\n"
		" *    http://iryoku.com/aacourse/downloads/13-Anti-Aliasing-Methods-in-CryENGINE-3.pdf\n"
		" *\n"
		" * c) If you want to enable spatial multisampling (SMAA S2x):\n"
		" *\n"
		" * 1. The scene must be rendered using MSAA 2x. The MSAA 2x buffer must be\n"
		" *    created with:\n"
		" *      - DX10:     see below (*)\n"
		" *      - DX10.1:   D3D10_STANDARD_MULTISAMPLE_PATTERN or\n"
		" *      - DX11:     D3D11_STANDARD_MULTISAMPLE_PATTERN\n"
		" *\n"
		" *    This allows to ensure that the subsample order matches the table in\n"
		" *    @SUBSAMPLE_INDICES.\n"
		" *\n"
		" *    (*) In the case of DX10, we refer the reader to:\n"
		" *      - SMAA::detectMSAAOrder and\n"
		" *      - SMAA::msaaReorder\n"
		" *\n"
		" *    These functions allow to match the standard multisample patterns by\n"
		" *    detecting the subsample order for a specific GPU, and reordering\n"
		" *    them appropriately.\n"
		" *\n"
		" * 2. A shader must be run to output each subsample into a separate buffer\n"
		" *    (DX10 is required). You can use SMAASeparate for this purpose, or just do\n"
		" *    it in an existing pass (for example, in the tone mapping pass, which has\n"
		" *    the advantage of feeding tone mapped subsamples to SMAA, which will yield\n"
		" *    better results).\n"
		" *\n"
		" * 3. The full SMAA 1x pipeline must be run for each separated buffer, storing\n"
		" *    the results in the final buffer. The second run should alpha blend with\n"
		" *    the existing final buffer using a blending factor of 0.5.\n"
		" *    'subsampleIndices' must be adjusted as in the SMAA T2x case (see point\n"
		" *    b).\n"
		" *\n"
		" * d) If you want to enable temporal supersampling on top of SMAA S2x\n"
		" *    (which actually is SMAA 4x):\n"
		" *\n"
		" * 1. SMAA 4x consists on temporally jittering SMAA S2x, so the first step is\n"
		" *    to calculate SMAA S2x for current frame. In this case, 'subsampleIndices'\n"
		" *    must be set as follows:\n"
		" *\n"
		" *    | F# | S# |   Camera Jitter    |    Net Jitter     |   subsampleIndices   |\n"
		" *    +----+----+--------------------+-------------------+----------------------+\n"
		" *    |  0 |  0 |  ( 0.125,  0.125)  |  ( 0.375, -0.125) |  float4(5, 3, 1, 3)  |\n"
		" *    |  0 |  1 |  ( 0.125,  0.125)  |  (-0.125,  0.375) |  float4(4, 6, 2, 3)  |\n"
		" *    +----+----+--------------------+-------------------+----------------------+\n"
		" *    |  1 |  2 |  (-0.125, -0.125)  |  ( 0.125, -0.375) |  float4(3, 5, 1, 4)  |\n"
		" *    |  1 |  3 |  (-0.125, -0.125)  |  (-0.375,  0.125) |  float4(6, 4, 2, 4)  |\n"
		" *\n"
		" *    These jitter positions assume a bottom-to-top y axis. F# stands for the\n"
		" *    frame number. S# stands for the sample number.\n"
		" *\n"
		" * 2. After calculating SMAA S2x for current frame (with the new subsample\n"
		" *    indices), previous frame must be reprojected as in SMAA T2x mode (see\n"
		" *    point b).\n"
		" *\n"
		" * e) If motion blur is used, you may want to do the edge detection pass\n"
		" *    together with motion blur. This has two advantages:\n"
		" *\n"
		" * 1. Pixels under heavy motion can be omitted from the edge detection process.\n"
		" *    For these pixels we can just store \"no edge\", as motion blur will take\n"
		" *    care of them.\n"
		" * 2. The center pixel tap is reused.\n"
		" *\n"
		" * Note that in this case depth testing should be used instead of stenciling,\n"
		" * as we have to write all the pixels in the motion blur pass.\n"
		" *\n"
		" * That's it!\n"
		" */\n"
		"\n"
		"//-----------------------------------------------------------------------------\n"
		"// SMAA Presets\n"
		"\n"
		"/**\n"
		" * Note that if you use one of these presets, the following configuration\n"
		" * macros will be ignored if set in the \"Configurable Defines\" section.\n"
		" */\n"
		"\n"
		"#if defined(SMAA_PRESET_LOW)\n"
		"#define SMAA_THRESHOLD 0.15\n"
		"#define SMAA_MAX_SEARCH_STEPS 4\n"
		"#define SMAA_DISABLE_DIAG_DETECTION\n"
		"#define SMAA_DISABLE_CORNER_DETECTION\n"
		"#elif defined(SMAA_PRESET_MEDIUM)\n"
		"#define SMAA_THRESHOLD 0.1\n"
		"#define SMAA_MAX_SEARCH_STEPS 8\n"
		"#define SMAA_DISABLE_DIAG_DETECTION\n"
		"#define SMAA_DISABLE_CORNER_DETECTION\n"
		"#elif defined(SMAA_PRESET_HIGH)\n"
		"#define SMAA_THRESHOLD 0.1\n"
		"#define SMAA_MAX_SEARCH_STEPS 16\n"
		"#define SMAA_MAX_SEARCH_STEPS_DIAG 8\n"
		"#define SMAA_CORNER_ROUNDING 25\n"
		"#elif defined(SMAA_PRESET_ULTRA)\n"
		"#define SMAA_THRESHOLD 0.05\n"
		"#define SMAA_MAX_SEARCH_STEPS 32\n"
		"#define SMAA_MAX_SEARCH_STEPS_DIAG 16\n"
		"#define SMAA_CORNER_ROUNDING 25\n"
		"#endif\n"
		"\n"
		"//-----------------------------------------------------------------------------\n"
		"// Configurable Defines\n"
		"\n"
		"/**\n"
		" * SMAA_THRESHOLD specifies the threshold or sensitivity to edges.\n"
		" * Lowering this value you will be able to detect more edges at the expense of\n"
		" * performance. \n"
		" *\n"
		" * Range: [0, 0.5]\n"
		" *   0.1 is a reasonable value, and allows to catch most visible edges.\n"
		" *   0.05 is a rather overkill value, that allows to catch 'em all.\n"
		" *\n"
		" *   If temporal supersampling is used, 0.2 could be a reasonable value, as low\n"
		" *   contrast edges are properly filtered by just 2x.\n"
		" */\n"
		"#ifndef SMAA_THRESHOLD\n"
		"#define SMAA_THRESHOLD 0.1\n"
		"#endif\n"
		"\n"
		"/**\n"
		" * SMAA_DEPTH_THRESHOLD specifies the threshold for depth edge detection.\n"
		" * \n"
		" * Range: depends on the depth range of the scene.\n"
		" */\n"
		"#ifndef SMAA_DEPTH_THRESHOLD\n"
		"#define SMAA_DEPTH_THRESHOLD (0.1 * SMAA_THRESHOLD)\n"
		"#endif\n"
		"\n"
		"/**\n"
		" * SMAA_MAX_SEARCH_STEPS specifies the maximum steps performed in the\n"
		" * horizontal/vertical pattern searches, at each side of the pixel.\n"
		" *\n"
		" * In number of pixels, it's actually the double. So the maximum line length\n"
		" * perfectly handled by, for example 16, is 64 (by perfectly, we meant that\n"
		" * longer lines won't look as good, but still antialiased).\n"
		" *\n"
		" * Range: [0, 112]\n"
		" */\n"
		"#ifndef SMAA_MAX_SEARCH_STEPS\n"
		"#define SMAA_MAX_SEARCH_STEPS 16\n"
		"#endif\n"
		"\n"
		"/**\n"
		" * SMAA_MAX_SEARCH_STEPS_DIAG specifies the maximum steps performed in the\n"
		" * diagonal pattern searches, at each side of the pixel. In this case we jump\n"
		" * one pixel at time, instead of two.\n"
		" *\n"
		" * Range: [0, 20]\n"
		" *\n"
		" * On high-end machines it is cheap (between a 0.8x and 0.9x slower for 16 \n"
		" * steps), but it can have a significant impact on older machines.\n"
		" *\n"
		" * Define SMAA_DISABLE_DIAG_DETECTION to disable diagonal processing.\n"
		" */\n"
		"#ifndef SMAA_MAX_SEARCH_STEPS_DIAG\n"
		"#define SMAA_MAX_SEARCH_STEPS_DIAG 8\n"
		"#endif\n"
		"\n"
		"/**\n"
		" * SMAA_CORNER_ROUNDING specifies how much sharp corners will be rounded.\n"
		" *\n"
		" * Range: [0, 100]\n"
		" *\n"
		" * Define SMAA_DISABLE_CORNER_DETECTION to disable corner processing.\n"
		" */\n"
		"#ifndef SMAA_CORNER_ROUNDING\n"
		"#define SMAA_CORNER_ROUNDING 25\n"
		"#endif\n"
		"\n"
		"/**\n"
		" * If there is an neighbor edge that has SMAA_LOCAL_CONTRAST_FACTOR times\n"
		" * bigger contrast than current edge, current edge will be discarded.\n"
		" *\n"
		" * This allows to eliminate spurious crossing edges, and is based on the fact\n"
		" * that, if there is too much contrast in a direction, that will hide\n"
		" * perceptually contrast in the other neighbors.\n"
		" */\n"
		"#ifndef SMAA_LOCAL_CONTRAST_ADAPTATION_FACTOR\n"
		"#define SMAA_LOCAL_CONTRAST_ADAPTATION_FACTOR 2.0\n"
		"#endif\n"
		"\n"
		"/**\n"
		" * Predicated thresholding allows to better preserve texture details and to\n"
		" * improve performance, by decreasing the number of detected edges using an\n"
		" * additional buffer like the light accumulation buffer, object ids or even the\n"
		" * depth buffer (the depth buffer usage may be limited to indoor or short range\n"
		" * scenes).\n"
		" *\n"
		" * It locally decreases the luma or color threshold if an edge is found in an\n"
		" * additional buffer (so the global threshold can be higher).\n"
		" *\n"
		" * This method was developed by Playstation EDGE MLAA team, and used in \n"
		" * Killzone 3, by using the light accumulation buffer. More information here:\n"
		" *     http://iryoku.com/aacourse/downloads/06-MLAA-on-PS3.pptx \n"
		" */\n"
		"#ifndef SMAA_PREDICATION\n"
		"#define SMAA_PREDICATION 0\n"
		"#endif\n"
		"\n"
		"/**\n"
		" * Threshold to be used in the additional predication buffer. \n"
		" *\n"
		" * Range: depends on the input, so you'll have to find the magic number that\n"
		" * works for you.\n"
		" */\n"
		"#ifndef SMAA_PREDICATION_THRESHOLD\n"
		"#define SMAA_PREDICATION_THRESHOLD 0.01\n"
		"#endif\n"
		"\n"
		"/**\n"
		" * How much to scale the global threshold used for luma or color edge\n"
		" * detection when using predication.\n"
		" *\n"
		" * Range: [1, 5]\n"
		" */\n"
		"#ifndef SMAA_PREDICATION_SCALE\n"
		"#define SMAA_PREDICATION_SCALE 2.0\n"
		"#endif\n"
		"\n"
		"/**\n"
		" * How much to locally decrease the threshold.\n"
		" *\n"
		" * Range: [0, 1]\n"
		" */\n"
		"#ifndef SMAA_PREDICATION_STRENGTH\n"
		"#define SMAA_PREDICATION_STRENGTH 0.4\n"
		"#endif\n"
		"\n"
		"/**\n"
		" * Temporal reprojection allows to remove ghosting artifacts when using\n"
		" * temporal supersampling. We use the CryEngine 3 method which also introduces\n"
		" * velocity weighting. This feature is of extreme importance for totally\n"
		" * removing ghosting. More information here:\n"
		" *    http://iryoku.com/aacourse/downloads/13-Anti-Aliasing-Methods-in-CryENGINE-3.pdf\n"
		" *\n"
		" * Note that you'll need to setup a velocity buffer for enabling reprojection.\n"
		" * For static geometry, saving the previous depth buffer is a viable\n"
		" * alternative.\n"
		" */\n"
		"#ifndef SMAA_REPROJECTION\n"
		"#define SMAA_REPROJECTION 0\n"
		"#endif\n"
		"\n"
		"/**\n"
		" * SMAA_REPROJECTION_WEIGHT_SCALE controls the velocity weighting. It allows to\n"
		" * remove ghosting trails behind the moving object, which are not removed by\n"
		" * just using reprojection. Using low values will exhibit ghosting, while using\n"
		" * high values will disable temporal supersampling under motion.\n"
		" *\n"
		" * Behind the scenes, velocity weighting removes temporal supersampling when\n"
		" * the velocity of the subsamples differs (meaning they are different objects).\n"
		" *\n"
		" * Range: [0, 80]\n"
		" */\n"
		"#ifndef SMAA_REPROJECTION_WEIGHT_SCALE\n"
		"#define SMAA_REPROJECTION_WEIGHT_SCALE 30.0\n"
		"#endif\n"
		"\n"
		"/**\n"
		" * On some compilers, discard and texture cannot be used in vertex shaders. Thus, they need\n"
		" * to be compiled separately.\n"
		" */\n"
		"#ifndef SMAA_INCLUDE_VS\n"
		"#define SMAA_INCLUDE_VS 1\n"
		"#endif\n"
		"#ifndef SMAA_INCLUDE_PS\n"
		"#define SMAA_INCLUDE_PS 1\n"
		"#endif\n"
		"\n"
		"//-----------------------------------------------------------------------------\n"
		"// Texture Access Defines\n"
		"\n"
		"#ifndef SMAA_AREATEX_SELECT\n"
		"#if defined(SMAA_HLSL_3)\n"
		"#define SMAA_AREATEX_SELECT(sample) sample.ra\n"
		"#else\n"
		"#define SMAA_AREATEX_SELECT(sample) sample.rg\n"
		"#endif\n"
		"#endif\n"
		"\n"
		"#ifndef SMAA_SEARCHTEX_SELECT\n"
		"#define SMAA_SEARCHTEX_SELECT(sample) sample.r\n"
		"#endif\n"
		"\n"
		"#ifndef SMAA_DECODE_VELOCITY\n"
		"#define SMAA_DECODE_VELOCITY(sample) sample.rg\n"
		"#endif\n"
		"\n"
		"//-----------------------------------------------------------------------------\n"
		"// Non-Configurable Defines\n"
		"\n"
		"#define SMAA_AREATEX_MAX_DISTANCE 16\n"
		"#define SMAA_AREATEX_MAX_DISTANCE_DIAG 20\n"
		"#define SMAA_AREATEX_PIXEL_SIZE (1.0 / float2(160.0, 560.0))\n"
		"#define SMAA_AREATEX_SUBTEX_SIZE (1.0 / 7.0)\n"
		"#define SMAA_SEARCHTEX_SIZE float2(66.0, 33.0)\n"
		"#define SMAA_SEARCHTEX_PACKED_SIZE float2(64.0, 16.0)\n"
		"#define SMAA_CORNER_ROUNDING_NORM (float(SMAA_CORNER_ROUNDING) / 100.0)\n"
		"\n"
		"//-----------------------------------------------------------------------------\n"
		"// Porting Functions\n"
		"\n"
		"#if defined(SMAA_HLSL_3)\n"
		"#define API_V_DIR(v) v\n"
		"#define API_V_COORD(v) v\n"
		"#define API_V_BELOW(v1, v2)	v1 > v2\n"
		"#define API_V_ABOVE(v1, v2)	v1 < v2\n"
		"#define SMAATexture2D(tex) sampler2D tex\n"
		"#define SMAATexturePass2D(tex) tex\n"
		"#define SMAASampleLevelZero(tex, coord) tex2Dlod(tex, float4(coord, 0.0, 0.0))\n"
		"#define SMAASampleLevelZeroPoint(tex, coord) tex2Dlod(tex, float4(coord, 0.0, 0.0))\n"
		"#define SMAASampleLevelZeroOffset(tex, coord, offset) tex2Dlod(tex, float4(coord + offset * SMAA_RT_METRICS.xy, 0.0, 0.0))\n"
		"#define SMAASample(tex, coord) tex2D(tex, coord)\n"
		"#define SMAASamplePoint(tex, coord) tex2D(tex, coord)\n"
		"#define SMAASampleOffset(tex, coord, offset) tex2D(tex, coord + offset * SMAA_RT_METRICS.xy)\n"
		"#define SMAA_FLATTEN [flatten]\n"
		"#define SMAA_BRANCH [branch]\n"
		"#endif\n"
		"#if defined(SMAA_HLSL_4) || defined(SMAA_HLSL_4_1)\n"
		"#define API_V_DIR(v) v\n"
		"#define API_V_COORD(v) v\n"
		"#define API_V_BELOW(v1, v2)	v1 > v2\n"
		"#define API_V_ABOVE(v1, v2)	v1 < v2\n"
		"SamplerState LinearSampler { Filter = MIN_MAG_LINEAR_MIP_POINT; AddressU = Clamp; AddressV = Clamp; };\n"
		"SamplerState PointSampler { Filter = MIN_MAG_MIP_POINT; AddressU = Clamp; AddressV = Clamp; };\n"
		"#define SMAATexture2D(tex) Texture2D tex\n"
		"#define SMAATexturePass2D(tex) tex\n"
		"#define SMAASampleLevelZero(tex, coord) tex.SampleLevel(LinearSampler, coord, 0)\n"
		"#define SMAASampleLevelZeroPoint(tex, coord) tex.SampleLevel(PointSampler, coord, 0)\n"
		"#define SMAASampleLevelZeroOffset(tex, coord, offset) tex.SampleLevel(LinearSampler, coord, 0, offset)\n"
		"#define SMAASample(tex, coord) tex.Sample(LinearSampler, coord)\n"
		"#define SMAASamplePoint(tex, coord) tex.Sample(PointSampler, coord)\n"
		"#define SMAASampleOffset(tex, coord, offset) tex.Sample(LinearSampler, coord, offset)\n"
		"#define SMAA_FLATTEN [flatten]\n"
		"#define SMAA_BRANCH [branch]\n"
		"#define SMAATexture2DMS2(tex) Texture2DMS<float4, 2> tex\n"
		"#define SMAALoad(tex, pos, sample) tex.Load(pos, sample)\n"
		"#if defined(SMAA_HLSL_4_1)\n"
		"#define SMAAGather(tex, coord) tex.Gather(LinearSampler, coord, 0)\n"
		"#endif\n"
		"#endif\n"
		"#if defined(SMAA_GLSL_3) || defined(SMAA_GLSL_4)\n"
		"//#define API_V_DIR(v) -(v)\n"
		"//#define API_V_COORD(v) (1.0 - v)\n"
		"//#define API_V_BELOW(v1, v2)	v1 < v2\n"
		"//#define API_V_ABOVE(v1, v2)	v1 > v2\n"
		"\n"
		"#define API_V_DIR(v) v\n"
		"#define API_V_COORD(v) v\n"
		"#define API_V_BELOW(v1, v2)	v1 > v2\n"
		"#define API_V_ABOVE(v1, v2)	v1 < v2\n"
		"\n"
		"#define SMAATexture2D(tex) sampler2D tex\n"
		"#define SMAATexturePass2D(tex) tex\n"
		"#define SMAASampleLevelZero(tex, coord) textureLod(tex, coord, 0.0)\n"
		"#define SMAASampleLevelZeroPoint(tex, coord) textureLod(tex, coord, 0.0)\n"
		"#define SMAASampleLevelZeroOffset(tex, coord, offset) textureLodOffset(tex, coord, 0.0, offset)\n"
		"#define SMAASample(tex, coord) texture(tex, coord)\n"
		"#define SMAASamplePoint(tex, coord) texture(tex, coord)\n"
		"#define SMAASampleOffset(tex, coord, offset) texture(tex, coord, offset)\n"
		"#define SMAA_FLATTEN\n"
		"#define SMAA_BRANCH\n"
		"#define lerp(a, b, t) mix(a, b, t)\n"
		"#define saturate(a) clamp(a, 0.0, 10.0)\n"
		"#if defined(SMAA_GLSL_4)\n"
		"#define mad(a, b, c) fma(a, b, c)\n"
		"#define SMAAGather(tex, coord) textureGather(tex, coord)\n"
		"#else\n"
		"#define mad(a, b, c) (a * b + c)\n"
		"#endif\n"
		"//#define float2 vec2\n"
		"//#define float3 vec3\n"
		"//#define float4 vec4\n"
		"//#define int2 ivec2\n"
		"//#define int3 ivec3\n"
		"//#define int4 ivec4\n"
		"//#define bool2 bvec2\n"
		"//#define bool3 bvec3\n"
		"//#define bool4 bvec4\n"
		"#endif\n"
		"\n"
		"#if !defined(SMAA_HLSL_3) && !defined(SMAA_HLSL_4) && !defined(SMAA_HLSL_4_1) && !defined(SMAA_GLSL_3) && !defined(SMAA_GLSL_4) && !defined(SMAA_CUSTOM_SL)\n"
		"#error you must define the shading language: SMAA_HLSL_*, SMAA_GLSL_* or SMAA_CUSTOM_SL\n"
		"#endif\n"
		"\n"
		"//-----------------------------------------------------------------------------\n"
		"// Misc functions\n"
		"\n"
		"/**\n"
		" * Gathers current pixel, and the top-left neighbors.\n"
		" */\n"
		"float3 SMAAGatherNeighbours(float2 texcoord,\n"
		"                            float4 offset[3],\n"
		"                            SMAATexture2D(tex)) {\n"
		"    #ifdef SMAAGather\n"
		"    return SMAAGather(tex, texcoord + SMAA_RT_METRICS.xy * float2(-0.5, -0.5)).grb;\n"
		"    #else\n"
		"    float P = SMAASamplePoint(tex, texcoord).r;\n"
		"    float Pleft = SMAASamplePoint(tex, offset[0].xy).r;\n"
		"    float Ptop  = SMAASamplePoint(tex, offset[0].zw).r;\n"
		"    return float3(P, Pleft, Ptop);\n"
		"    #endif\n"
		"}\n"
		"\n"
		"/**\n"
		" * Adjusts the threshold by means of predication.\n"
		" */\n"
		"float2 SMAACalculatePredicatedThreshold(float2 texcoord,\n"
		"                                        float4 offset[3],\n"
		"                                        SMAATexture2D(predicationTex)) {\n"
		"    float3 neighbours = SMAAGatherNeighbours(texcoord, offset, SMAATexturePass2D(predicationTex));\n"
		"    float2 delta = abs(neighbours.xx - neighbours.yz);\n"
		"    float2 edges = step(SMAA_PREDICATION_THRESHOLD, delta);\n"
		"    return SMAA_PREDICATION_SCALE * SMAA_THRESHOLD * (1.0 - SMAA_PREDICATION_STRENGTH * edges);\n"
		"}\n"
		"\n"
		"/**\n"
		" * Conditional move:\n"
		" */\n"
		"void SMAAMovc(bool2 cond, inout float2 variable, float2 value) {\n"
		"    SMAA_FLATTEN if (cond.x) variable.x = value.x;\n"
		"    SMAA_FLATTEN if (cond.y) variable.y = value.y;\n"
		"}\n"
		"\n"
		"void SMAAMovc(bool4 cond, inout float4 variable, float4 value) {\n"
		"    SMAAMovc(cond.xy, variable.xy, value.xy);\n"
		"    SMAAMovc(cond.zw, variable.zw, value.zw);\n"
		"}\n"
		"\n"
		"\n"
		"#if SMAA_INCLUDE_VS\n"
		"//-----------------------------------------------------------------------------\n"
		"// Vertex Shaders\n"
		"\n"
		"/**\n"
		" * Edge Detection Vertex Shader\n"
		" */\n"
		"void SMAAEdgeDetectionVS(float2 texcoord,\n"
		"                         out float4 offset[3]) {\n"
		"    offset[0] = mad(SMAA_RT_METRICS.xyxy, float4(-1.0, 0.0, 0.0, API_V_DIR(-1.0)), texcoord.xyxy);\n"
		"    offset[1] = mad(SMAA_RT_METRICS.xyxy, float4( 1.0, 0.0, 0.0, API_V_DIR(1.0)), texcoord.xyxy);\n"
		"    offset[2] = mad(SMAA_RT_METRICS.xyxy, float4(-2.0, 0.0, 0.0, API_V_DIR(-2.0)), texcoord.xyxy);\n"
		"}\n"
		"\n"
		"/**\n"
		" * Blend Weight Calculation Vertex Shader\n"
		" */\n"
		"void SMAABlendingWeightCalculationVS(float2 texcoord,\n"
		"                                     out float2 pixcoord,\n"
		"                                     out float4 offset[3]) {\n"
		"    pixcoord = texcoord * SMAA_RT_METRICS.zw;\n"
		"\n"
		"    // We will use these offsets for the searches later on (see @PSEUDO_GATHER4):\n"
		"    offset[0] = mad(SMAA_RT_METRICS.xyxy, float4(-0.25, API_V_DIR(-0.125),  1.25, API_V_DIR(-0.125)), texcoord.xyxy);\n"
		"    offset[1] = mad(SMAA_RT_METRICS.xyxy, float4(-0.125, API_V_DIR(-0.25), -0.125,  API_V_DIR(1.25)), texcoord.xyxy);\n"
		"\n"
		"    // And these for the searches, they indicate the ends of the loops:\n"
		"    offset[2] = mad(SMAA_RT_METRICS.xxyy,\n"
		"                    float4(-2.0, 2.0, API_V_DIR(-2.0), API_V_DIR(2.0)) * float(SMAA_MAX_SEARCH_STEPS),\n"
		"                    float4(offset[0].xz, offset[1].yw));\n"
		"}\n"
		"\n"
		"/**\n"
		" * Neighborhood Blending Vertex Shader\n"
		" */\n"
		"void SMAANeighborhoodBlendingVS(float2 texcoord,\n"
		"                                out float4 offset) {\n"
		"    offset = mad(SMAA_RT_METRICS.xyxy, float4( 1.0, 0.0, 0.0, API_V_DIR(1.0)), texcoord.xyxy);\n"
		"}\n"
		"#endif // SMAA_INCLUDE_VS\n"
		"\n"
		"#if SMAA_INCLUDE_PS\n"
		"//-----------------------------------------------------------------------------\n"
		"// Edge Detection Pixel Shaders (First Pass)\n"
		"\n"
		"/**\n"
		" * Luma Edge Detection\n"
		" *\n"
		" * IMPORTANT NOTICE: luma edge detection requires gamma-corrected colors, and\n"
		" * thus 'colorTex' should be a non-sRGB texture.\n"
		" */\n"
		"float2 SMAALumaEdgeDetectionPS(float2 texcoord,\n"
		"                               float4 offset[3],\n"
		"                               SMAATexture2D(colorTex)\n"
		"                               #if SMAA_PREDICATION\n"
		"                               , SMAATexture2D(predicationTex)\n"
		"                               #endif\n"
		"                               ) {\n"
		"    // Calculate the threshold:\n"
		"    #if SMAA_PREDICATION\n"
		"    float2 threshold = SMAACalculatePredicatedThreshold(texcoord, offset, SMAATexturePass2D(predicationTex));\n"
		"    #else\n"
		"    float2 threshold = float2(SMAA_THRESHOLD, SMAA_THRESHOLD);\n"
		"    #endif\n"
		"\n"
		"    // Calculate lumas:\n"
		"    float3 weights = float3(0.2126, 0.7152, 0.0722);\n"
		"    float L = dot(SMAASamplePoint(colorTex, texcoord).rgb, weights);\n"
		"\n"
		"    float Lleft = dot(SMAASamplePoint(colorTex, offset[0].xy).rgb, weights);\n"
		"    float Ltop  = dot(SMAASamplePoint(colorTex, offset[0].zw).rgb, weights);\n"
		"\n"
		"    // We do the usual threshold:\n"
		"    float4 delta;\n"
		"    delta.xy = abs(L - float2(Lleft, Ltop));\n"
		"    float2 edges = step(threshold, delta.xy);\n"
		"\n"
		"    // Then discard if there is no edge:\n"
		"    if (dot(edges, float2(1.0, 1.0)) == 0.0)\n"
		"        discard;\n"
		"\n"
		"    // Calculate right and bottom deltas:\n"
		"    float Lright = dot(SMAASamplePoint(colorTex, offset[1].xy).rgb, weights);\n"
		"    float Lbottom  = dot(SMAASamplePoint(colorTex, offset[1].zw).rgb, weights);\n"
		"    delta.zw = abs(L - float2(Lright, Lbottom));\n"
		"\n"
		"    // Calculate the maximum delta in the direct neighborhood:\n"
		"    float2 maxDelta = max(delta.xy, delta.zw);\n"
		"\n"
		"    // Calculate left-left and top-top deltas:\n"
		"    float Lleftleft = dot(SMAASamplePoint(colorTex, offset[2].xy).rgb, weights);\n"
		"    float Ltoptop = dot(SMAASamplePoint(colorTex, offset[2].zw).rgb, weights);\n"
		"    delta.zw = abs(float2(Lleft, Ltop) - float2(Lleftleft, Ltoptop));\n"
		"\n"
		"    // Calculate the final maximum delta:\n"
		"    maxDelta = max(maxDelta.xy, delta.zw);\n"
		"    float finalDelta = max(maxDelta.x, maxDelta.y);\n"
		"\n"
		"    // Local contrast adaptation:\n"
		"    edges.xy *= step(finalDelta, SMAA_LOCAL_CONTRAST_ADAPTATION_FACTOR * delta.xy);\n"
		"\n"
		"    return edges;\n"
		"}\n"
		"\n"
		"/**\n"
		" * Color Edge Detection\n"
		" *\n"
		" * IMPORTANT NOTICE: color edge detection requires gamma-corrected colors, and\n"
		" * thus 'colorTex' should be a non-sRGB texture.\n"
		" */\n"
		"float2 SMAAColorEdgeDetectionPS(float2 texcoord,\n"
		"                                float4 offset[3],\n"
		"                                SMAATexture2D(colorTex)\n"
		"                                #if SMAA_PREDICATION\n"
		"                                , SMAATexture2D(predicationTex)\n"
		"                                #endif\n"
		"                                ) {\n"
		"    // Calculate the threshold:\n"
		"    #if SMAA_PREDICATION\n"
		"    float2 threshold = SMAACalculatePredicatedThreshold(texcoord, offset, predicationTex);\n"
		"    #else\n"
		"    float2 threshold = float2(SMAA_THRESHOLD, SMAA_THRESHOLD);\n"
		"    #endif\n"
		"\n"
		"    // Calculate color deltas:\n"
		"    float4 delta;\n"
		"    float3 C = SMAASamplePoint(colorTex, texcoord).rgb;\n"
		"\n"
		"    float3 Cleft = SMAASamplePoint(colorTex, offset[0].xy).rgb;\n"
		"    float3 t = abs(C - Cleft);\n"
		"    delta.x = max(max(t.r, t.g), t.b);\n"
		"\n"
		"    float3 Ctop  = SMAASamplePoint(colorTex, offset[0].zw).rgb;\n"
		"    t = abs(C - Ctop);\n"
		"    delta.y = max(max(t.r, t.g), t.b);\n"
		"\n"
		"    // We do the usual threshold:\n"
		"    float2 edges = step(threshold, delta.xy);\n"
		"\n"
		"    // Then discard if there is no edge:\n"
		"    if (dot(edges, float2(1.0, 1.0)) == 0.0)\n"
		"        discard;\n"
		"\n"
		"    // Calculate right and bottom deltas:\n"
		"    float3 Cright = SMAASamplePoint(colorTex, offset[1].xy).rgb;\n"
		"    t = abs(C - Cright);\n"
		"    delta.z = max(max(t.r, t.g), t.b);\n"
		"\n"
		"    float3 Cbottom  = SMAASamplePoint(colorTex, offset[1].zw).rgb;\n"
		"    t = abs(C - Cbottom);\n"
		"    delta.w = max(max(t.r, t.g), t.b);\n"
		"\n"
		"    // Calculate the maximum delta in the direct neighborhood:\n"
		"    float2 maxDelta = max(delta.xy, delta.zw);\n"
		"\n"
		"    // Calculate left-left and top-top deltas:\n"
		"    float3 Cleftleft  = SMAASamplePoint(colorTex, offset[2].xy).rgb;\n"
		"    t = abs(C - Cleftleft);\n"
		"    delta.z = max(max(t.r, t.g), t.b);\n"
		"\n"
		"    float3 Ctoptop = SMAASamplePoint(colorTex, offset[2].zw).rgb;\n"
		"    t = abs(C - Ctoptop);\n"
		"    delta.w = max(max(t.r, t.g), t.b);\n"
		"\n"
		"    // Calculate the final maximum delta:\n"
		"    maxDelta = max(maxDelta.xy, delta.zw);\n"
		"    float finalDelta = max(maxDelta.x, maxDelta.y);\n"
		"\n"
		"    // Local contrast adaptation:\n"
		"    edges.xy *= step(finalDelta, SMAA_LOCAL_CONTRAST_ADAPTATION_FACTOR * delta.xy);\n"
		"\n"
		"    return edges;\n"
		"}\n"
		"\n"
		"/**\n"
		" * Depth Edge Detection\n"
		" */\n"
		"float2 SMAADepthEdgeDetectionPS(float2 texcoord,\n"
		"                                float4 offset[3],\n"
		"                                SMAATexture2D(depthTex)) {\n"
		"    float3 neighbours = SMAAGatherNeighbours(texcoord, offset, SMAATexturePass2D(depthTex));\n"
		"    float2 delta = abs(neighbours.xx - float2(neighbours.y, neighbours.z));\n"
		"    float2 edges = step(SMAA_DEPTH_THRESHOLD, delta);\n"
		"\n"
		"    if (dot(edges, float2(1.0, 1.0)) == 0.0)\n"
		"        discard;\n"
		"\n"
		"    return edges;\n"
		"}\n"
		"\n"
		"//-----------------------------------------------------------------------------\n"
		"// Diagonal Search Functions\n"
		"\n"
		"#if !defined(SMAA_DISABLE_DIAG_DETECTION)\n"
		"\n"
		"/**\n"
		" * Allows to decode two binary values from a bilinear-filtered access.\n"
		" */\n"
		"float2 SMAADecodeDiagBilinearAccess(float2 e) {\n"
		"    // Bilinear access for fetching 'e' have a 0.25 offset, and we are\n"
		"    // interested in the R and G edges:\n"
		"    //\n"
		"    // +---G---+-------+\n"
		"    // |   x o R   x   |\n"
		"    // +-------+-------+\n"
		"    //\n"
		"    // Then, if one of these edge is enabled:\n"
		"    //   Red:   (0.75 * X + 0.25 * 1) => 0.25 or 1.0\n"
		"    //   Green: (0.75 * 1 + 0.25 * X) => 0.75 or 1.0\n"
		"    //\n"
		"    // This function will unpack the values (mad + mul + round):\n"
		"    // wolframalpha.com: round(x * abs(5 * x - 5 * 0.75)) plot 0 to 1\n"
		"    e.r = e.r * abs(5.0 * e.r - 5.0 * 0.75);\n"
		"    return round(e);\n"
		"}\n"
		"\n"
		"float4 SMAADecodeDiagBilinearAccess(float4 e) {\n"
		"    e.rb = e.rb * abs(5.0 * e.rb - 5.0 * 0.75);\n"
		"    return round(e);\n"
		"}\n"
		"\n"
		"/**\n"
		" * These functions allows to perform diagonal pattern searches.\n"
		" */\n"
		"float2 SMAASearchDiag1(SMAATexture2D(edgesTex), float2 texcoord, float2 dir, out float2 e) {\n"
		"	dir.y = API_V_DIR(dir.y);\n"
		"    float4 coord = float4(texcoord, -1.0, 1.0);\n"
		"    float3 t = float3(SMAA_RT_METRICS.xy, 1.0);\n"
		"    while (coord.z < float(SMAA_MAX_SEARCH_STEPS_DIAG - 1) &&\n"
		"           coord.w > 0.9) {\n"
		"        coord.xyz = mad(t, float3(dir, 1.0), coord.xyz);\n"
		"        e = SMAASampleLevelZero(edgesTex, coord.xy).rg;\n"
		"        coord.w = dot(e, float2(0.5, 0.5));\n"
		"    }\n"
		"    return coord.zw;\n"
		"}\n"
		"\n"
		"float2 SMAASearchDiag2(SMAATexture2D(edgesTex), float2 texcoord, float2 dir, out float2 e) {\n"
		"	dir.y = API_V_DIR(dir.y);\n"
		"    float4 coord = float4(texcoord, -1.0, 1.0);\n"
		"    coord.x += 0.25 * SMAA_RT_METRICS.x; // See @SearchDiag2Optimization\n"
		"    float3 t = float3(SMAA_RT_METRICS.xy, 1.0);\n"
		"    while (coord.z < float(SMAA_MAX_SEARCH_STEPS_DIAG - 1) &&\n"
		"           coord.w > 0.9) {\n"
		"        coord.xyz = mad(t, float3(dir, 1.0), coord.xyz);\n"
		"\n"
		"        // @SearchDiag2Optimization\n"
		"        // Fetch both edges at once using bilinear filtering:\n"
		"        e = SMAASampleLevelZero(edgesTex, coord.xy).rg;\n"
		"        e = SMAADecodeDiagBilinearAccess(e);\n"
		"\n"
		"        // Non-optimized version:\n"
		"        // e.g = SMAASampleLevelZero(edgesTex, coord.xy).g;\n"
		"        // e.r = SMAASampleLevelZeroOffset(edgesTex, coord.xy, int2(1, 0)).r;\n"
		"\n"
		"        coord.w = dot(e, float2(0.5, 0.5));\n"
		"    }\n"
		"    return coord.zw;\n"
		"}\n"
		"\n"
		"/** \n"
		" * Similar to SMAAArea, this calculates the area corresponding to a certain\n"
		" * diagonal distance and crossing edges 'e'.\n"
		" */\n"
		"float2 SMAAAreaDiag(SMAATexture2D(areaTex), float2 dist, float2 e, float offset) {\n"
		"    float2 texcoord = mad(float2(SMAA_AREATEX_MAX_DISTANCE_DIAG, SMAA_AREATEX_MAX_DISTANCE_DIAG), e, dist);\n"
		"\n"
		"    // We do a scale and bias for mapping to texel space:\n"
		"    texcoord = mad(SMAA_AREATEX_PIXEL_SIZE, texcoord, 0.5 * SMAA_AREATEX_PIXEL_SIZE);\n"
		"\n"
		"    // Diagonal areas are on the second half of the texture:\n"
		"    texcoord.x += 0.5;\n"
		"\n"
		"    // Move to proper place, according to the subpixel offset:\n"
		"    texcoord.y += SMAA_AREATEX_SUBTEX_SIZE * offset;\n"
		"\n"
		"	texcoord.y = API_V_COORD(texcoord.y);\n"
		"\n"
		"    // Do it!\n"
		"    return SMAA_AREATEX_SELECT(SMAASampleLevelZero(areaTex, texcoord));\n"
		"}\n"
		"\n"
		"/**\n"
		" * This searches for diagonal patterns and returns the corresponding weights.\n"
		" */\n"
		"float2 SMAACalculateDiagWeights(SMAATexture2D(edgesTex), SMAATexture2D(areaTex), float2 texcoord, float2 e, float4 subsampleIndices) {\n"
		"    float2 weights = float2(0.0, 0.0);\n"
		"\n"
		"    // Search for the line ends:\n"
		"    float4 d;\n"
		"    float2 end;\n"
		"    if (e.r > 0.0) {\n"
		"        d.xz = SMAASearchDiag1(SMAATexturePass2D(edgesTex), texcoord, float2(-1.0,  1.0), end);\n"
		"        d.x += float(end.y > 0.9);\n"
		"    } else\n"
		"        d.xz = float2(0.0, 0.0);\n"
		"    d.yw = SMAASearchDiag1(SMAATexturePass2D(edgesTex), texcoord, float2(1.0, -1.0), end);\n"
		"\n"
		"    SMAA_BRANCH\n"
		"    if (d.x + d.y > 2.0) { // d.x + d.y + 1 > 3\n"
		"        // Fetch the crossing edges:\n"
		"        float4 coords = mad(float4(-d.x + 0.25, API_V_DIR(d.x), d.y, API_V_DIR(-d.y - 0.25)), SMAA_RT_METRICS.xyxy, texcoord.xyxy);\n"
		"        float4 c;\n"
		"        c.xy = SMAASampleLevelZeroOffset(edgesTex, coords.xy, int2(-1,  0)).rg;\n"
		"        c.zw = SMAASampleLevelZeroOffset(edgesTex, coords.zw, int2( 1,  0)).rg;\n"
		"        c.yxwz = SMAADecodeDiagBilinearAccess(c.xyzw);\n"
		"\n"
		"        // Non-optimized version:\n"
		"        // float4 coords = mad(float4(-d.x, d.x, d.y, -d.y), SMAA_RT_METRICS.xyxy, texcoord.xyxy);\n"
		"        // float4 c;\n"
		"        // c.x = SMAASampleLevelZeroOffset(edgesTex, coords.xy, int2(-1,  0)).g;\n"
		"        // c.y = SMAASampleLevelZeroOffset(edgesTex, coords.xy, int2( 0,  0)).r;\n"
		"        // c.z = SMAASampleLevelZeroOffset(edgesTex, coords.zw, int2( 1,  0)).g;\n"
		"        // c.w = SMAASampleLevelZeroOffset(edgesTex, coords.zw, int2( 1, -1)).r;\n"
		"\n"
		"        // Merge crossing edges at each side into a single value:\n"
		"        float2 cc = mad(float2(2.0, 2.0), c.xz, c.yw);\n"
		"\n"
		"        // Remove the crossing edge if we didn't found the end of the line:\n"
		"        SMAAMovc(bool2(step(0.9, d.zw)), cc, float2(0.0, 0.0));\n"
		"\n"
		"        // Fetch the areas for this line:\n"
		"        weights += SMAAAreaDiag(SMAATexturePass2D(areaTex), d.xy, cc, subsampleIndices.z);\n"
		"    }\n"
		"\n"
		"    // Search for the line ends:\n"
		"    d.xz = SMAASearchDiag2(SMAATexturePass2D(edgesTex), texcoord, float2(-1.0, -1.0), end);\n"
		"    if (SMAASampleLevelZeroOffset(edgesTex, texcoord, int2(1, 0)).r > 0.0) {\n"
		"        d.yw = SMAASearchDiag2(SMAATexturePass2D(edgesTex), texcoord, float2(1.0, 1.0), end);\n"
		"        d.y += float(end.y > 0.9);\n"
		"    } else\n"
		"        d.yw = float2(0.0, 0.0);\n"
		"\n"
		"    SMAA_BRANCH\n"
		"    if (d.x + d.y > 2.0) { // d.x + d.y + 1 > 3\n"
		"        // Fetch the crossing edges:\n"
		"        float4 coords = mad(float4(-d.x, API_V_DIR(-d.x), d.y, API_V_DIR(d.y)), SMAA_RT_METRICS.xyxy, texcoord.xyxy);\n"
		"        float4 c;\n"
		"        c.x  = SMAASampleLevelZeroOffset(edgesTex, coords.xy, int2(-1,  0)).g;\n"
		"        c.y  = SMAASampleLevelZeroOffset(edgesTex, coords.xy, int2( 0, API_V_DIR(-1))).r;\n"
		"        c.zw = SMAASampleLevelZeroOffset(edgesTex, coords.zw, int2( 1,  0)).gr;\n"
		"        float2 cc = mad(float2(2.0, 2.0), c.xz, c.yw);\n"
		"\n"
		"        // Remove the crossing edge if we didn't found the end of the line:\n"
		"        SMAAMovc(bool2(step(0.9, d.zw)), cc, float2(0.0, 0.0));\n"
		"\n"
		"        // Fetch the areas for this line:\n"
		"        weights += SMAAAreaDiag(SMAATexturePass2D(areaTex), d.xy, cc, subsampleIndices.w).gr;\n"
		"    }\n"
		"\n"
		"    return weights;\n"
		"}\n"
		"#endif\n"
		"\n"
		"//-----------------------------------------------------------------------------\n"
		"// Horizontal/Vertical Search Functions\n"
		"\n"
		"/**\n"
		" * This allows to determine how much length should we add in the last step\n"
		" * of the searches. It takes the bilinearly interpolated edge (see \n"
		" * @PSEUDO_GATHER4), and adds 0, 1 or 2, depending on which edges and\n"
		" * crossing edges are active.\n"
		" */\n"
		"float SMAASearchLength(SMAATexture2D(searchTex), float2 e, float offset) {\n"
		"    // The texture is flipped vertically, with left and right cases taking half\n"
		"    // of the space horizontally:\n"
		"    float2 scale = SMAA_SEARCHTEX_SIZE * float2(0.5, -1.0);\n"
		"    float2 bias = SMAA_SEARCHTEX_SIZE * float2(offset, 1.0);\n"
		"\n"
		"    // Scale and bias to access texel centers:\n"
		"    scale += float2(-1.0,  1.0);\n"
		"    bias  += float2( 0.5, -0.5);\n"
		"\n"
		"    // Convert from pixel coordinates to texcoords:\n"
		"    // (We use SMAA_SEARCHTEX_PACKED_SIZE because the texture is cropped)\n"
		"    scale *= 1.0 / SMAA_SEARCHTEX_PACKED_SIZE;\n"
		"    bias *= 1.0 / SMAA_SEARCHTEX_PACKED_SIZE;\n"
		"\n"
		"	float2 coord = mad(scale, e, bias);\n"
		"	coord.y = API_V_COORD(coord.y);\n"
		"\n"
		"    // Lookup the search texture:\n"
		"    return SMAA_SEARCHTEX_SELECT(SMAASampleLevelZero(searchTex, coord));\n"
		"}\n"
		"\n"
		"/**\n"
		" * Horizontal/vertical search functions for the 2nd pass.\n"
		" */\n"
		"float SMAASearchXLeft(SMAATexture2D(edgesTex), SMAATexture2D(searchTex), float2 texcoord, float end) {\n"
		"    /**\n"
		"     * @PSEUDO_GATHER4\n"
		"     * This texcoord has been offset by (-0.25, -0.125) in the vertex shader to\n"
		"     * sample between edge, thus fetching four edges in a row.\n"
		"     * Sampling with different offsets in each direction allows to disambiguate\n"
		"     * which edges are active from the four fetched ones.\n"
		"     */\n"
		"    float2 e = float2(0.0, 1.0);\n"
		"    while (texcoord.x > end && \n"
		"           e.g > 0.8281 && // Is there some edge not activated?\n"
		"           e.r == 0.0) { // Or is there a crossing edge that breaks the line?\n"
		"        e = SMAASampleLevelZero(edgesTex, texcoord).rg;\n"
		"        texcoord = mad(-float2(2.0, 0.0), SMAA_RT_METRICS.xy, texcoord);\n"
		"    }\n"
		"\n"
		"    float offset = mad(-(255.0 / 127.0), SMAASearchLength(SMAATexturePass2D(searchTex), e, 0.0), 3.25);\n"
		"    return mad(SMAA_RT_METRICS.x, offset, texcoord.x);\n"
		"\n"
		"    // Non-optimized version:\n"
		"    // We correct the previous (-0.25, -0.125) offset we applied:\n"
		"    // texcoord.x += 0.25 * SMAA_RT_METRICS.x;\n"
		"\n"
		"    // The searches are bias by 1, so adjust the coords accordingly:\n"
		"    // texcoord.x += SMAA_RT_METRICS.x;\n"
		"\n"
		"    // Disambiguate the length added by the last step:\n"
		"    // texcoord.x += 2.0 * SMAA_RT_METRICS.x; // Undo last step\n"
		"    // texcoord.x -= SMAA_RT_METRICS.x * (255.0 / 127.0) * SMAASearchLength(SMAATexturePass2D(searchTex), e, 0.0);\n"
		"    // return mad(SMAA_RT_METRICS.x, offset, texcoord.x);\n"
		"}\n"
		"\n"
		"float SMAASearchXRight(SMAATexture2D(edgesTex), SMAATexture2D(searchTex), float2 texcoord, float end) {\n"
		"    float2 e = float2(0.0, 1.0);\n"
		"    while (texcoord.x < end && \n"
		"           e.g > 0.8281 && // Is there some edge not activated?\n"
		"           e.r == 0.0) { // Or is there a crossing edge that breaks the line?\n"
		"        e = SMAASampleLevelZero(edgesTex, texcoord).rg;\n"
		"        texcoord = mad(float2(2.0, 0.0), SMAA_RT_METRICS.xy, texcoord);\n"
		"    }\n"
		"    float offset = mad(-(255.0 / 127.0), SMAASearchLength(SMAATexturePass2D(searchTex), e, 0.5), 3.25);\n"
		"    return mad(-SMAA_RT_METRICS.x, offset, texcoord.x);\n"
		"}\n"
		"\n"
		"float SMAASearchYUp(SMAATexture2D(edgesTex), SMAATexture2D(searchTex), float2 texcoord, float end) {\n"
		"    float2 e = float2(1.0, 0.0);\n"
		"    while (API_V_BELOW(texcoord.y, end) && \n"
		"           e.r > 0.8281 && // Is there some edge not activated?\n"
		"           e.g == 0.0) { // Or is there a crossing edge that breaks the line?\n"
		"        e = SMAASampleLevelZero(edgesTex, texcoord).rg;\n"
		"        texcoord = mad(-float2(0.0, API_V_DIR(2.0)), SMAA_RT_METRICS.xy, texcoord);\n"
		"    }\n"
		"    float offset = mad(-(255.0 / 127.0), SMAASearchLength(SMAATexturePass2D(searchTex), e.gr, 0.0), 3.25);\n"
		"    return mad(SMAA_RT_METRICS.y, API_V_DIR(offset), texcoord.y);\n"
		"}\n"
		"\n"
		"float SMAASearchYDown(SMAATexture2D(edgesTex), SMAATexture2D(searchTex), float2 texcoord, float end) {\n"
		"    float2 e = float2(1.0, 0.0);\n"
		"    while (API_V_ABOVE(texcoord.y, end) && \n"
		"           e.r > 0.8281 && // Is there some edge not activated?\n"
		"           e.g == 0.0) { // Or is there a crossing edge that breaks the line?\n"
		"        e = SMAASampleLevelZero(edgesTex, texcoord).rg;\n"
		"        texcoord = mad(float2(0.0, API_V_DIR(2.0)), SMAA_RT_METRICS.xy, texcoord);\n"
		"    }\n"
		"    float offset = mad(-(255.0 / 127.0), SMAASearchLength(SMAATexturePass2D(searchTex), e.gr, 0.5), 3.25);\n"
		"    return mad(-SMAA_RT_METRICS.y, API_V_DIR(offset), texcoord.y);\n"
		"}\n"
		"\n"
		"/** \n"
		" * Ok, we have the distance and both crossing edges. So, what are the areas\n"
		" * at each side of current edge?\n"
		" */\n"
		"float2 SMAAArea(SMAATexture2D(areaTex), float2 dist, float e1, float e2, float offset) {\n"
		"    // Rounding prevents precision errors of bilinear filtering:\n"
		"    float2 texcoord = mad(float2(SMAA_AREATEX_MAX_DISTANCE, SMAA_AREATEX_MAX_DISTANCE), round(4.0 * float2(e1, e2)), dist);\n"
		"    \n"
		"    // We do a scale and bias for mapping to texel space:\n"
		"    texcoord = mad(SMAA_AREATEX_PIXEL_SIZE, texcoord, 0.5 * SMAA_AREATEX_PIXEL_SIZE);\n"
		"\n"
		"    // Move to proper place, according to the subpixel offset:\n"
		"    texcoord.y = mad(SMAA_AREATEX_SUBTEX_SIZE, offset, texcoord.y);\n"
		"\n"
		"	texcoord.y = API_V_COORD(texcoord.y);\n"
		"\n"
		"    // Do it!\n"
		"    return SMAA_AREATEX_SELECT(SMAASampleLevelZero(areaTex, texcoord));\n"
		"}\n"
		"\n"
		"//-----------------------------------------------------------------------------\n"
		"// Corner Detection Functions\n"
		"\n"
		"void SMAADetectHorizontalCornerPattern(SMAATexture2D(edgesTex), inout float2 weights, float4 texcoord, float2 d) {\n"
		"    #if !defined(SMAA_DISABLE_CORNER_DETECTION)\n"
		"    float2 leftRight = step(d.xy, d.yx);\n"
		"    float2 rounding = (1.0 - SMAA_CORNER_ROUNDING_NORM) * leftRight;\n"
		"\n"
		"    rounding /= leftRight.x + leftRight.y; // Reduce blending for pixels in the center of a line.\n"
		"\n"
		"    float2 factor = float2(1.0, 1.0);\n"
		"    factor.x -= rounding.x * SMAASampleLevelZeroOffset(edgesTex, texcoord.xy, int2(0,  API_V_DIR(1))).r;\n"
		"    factor.x -= rounding.y * SMAASampleLevelZeroOffset(edgesTex, texcoord.zw, int2(1,  API_V_DIR(1))).r;\n"
		"    factor.y -= rounding.x * SMAASampleLevelZeroOffset(edgesTex, texcoord.xy, int2(0, API_V_DIR(-2))).r;\n"
		"    factor.y -= rounding.y * SMAASampleLevelZeroOffset(edgesTex, texcoord.zw, int2(1, API_V_DIR(-2))).r;\n"
		"\n"
		"    weights *= saturate(factor);\n"
		"    #endif\n"
		"}\n"
		"\n"
		"void SMAADetectVerticalCornerPattern(SMAATexture2D(edgesTex), inout float2 weights, float4 texcoord, float2 d) {\n"
		"    #if !defined(SMAA_DISABLE_CORNER_DETECTION)\n"
		"    float2 leftRight = step(d.xy, d.yx);\n"
		"    float2 rounding = (1.0 - SMAA_CORNER_ROUNDING_NORM) * leftRight;\n"
		"\n"
		"    rounding /= leftRight.x + leftRight.y;\n"
		"\n"
		"    float2 factor = float2(1.0, 1.0);\n"
		"    factor.x -= rounding.x * SMAASampleLevelZeroOffset(edgesTex, texcoord.xy, int2( 1, 0)).g;\n"
		"    factor.x -= rounding.y * SMAASampleLevelZeroOffset(edgesTex, texcoord.zw, int2( 1, API_V_DIR(1))).g;\n"
		"    factor.y -= rounding.x * SMAASampleLevelZeroOffset(edgesTex, texcoord.xy, int2(-2, 0)).g;\n"
		"    factor.y -= rounding.y * SMAASampleLevelZeroOffset(edgesTex, texcoord.zw, int2(-2, API_V_DIR(1))).g;\n"
		"\n"
		"    weights *= saturate(factor);\n"
		"    #endif\n"
		"}\n"
		"\n"
		"//-----------------------------------------------------------------------------\n"
		"// Blending Weight Calculation Pixel Shader (Second Pass)\n"
		"\n"
		"float4 SMAABlendingWeightCalculationPS(float2 texcoord,\n"
		"                                       float2 pixcoord,\n"
		"                                       float4 offset[3],\n"
		"                                       SMAATexture2D(edgesTex),\n"
		"                                       SMAATexture2D(areaTex),\n"
		"                                       SMAATexture2D(searchTex),\n"
		"                                       float4 subsampleIndices) { // Just pass zero for SMAA 1x, see @SUBSAMPLE_INDICES.\n"
		"    float4 weights = float4(0.0, 0.0, 0.0, 0.0);\n"
		"\n"
		"    float2 e = SMAASample(edgesTex, texcoord).rg;\n"
		"\n"
		"    SMAA_BRANCH\n"
		"    if (e.g > 0.0) { // Edge at north\n"
		"        #if !defined(SMAA_DISABLE_DIAG_DETECTION)\n"
		"        // Diagonals have both north and west edges, so searching for them in\n"
		"        // one of the boundaries is enough.\n"
		"        weights.rg = SMAACalculateDiagWeights(SMAATexturePass2D(edgesTex), SMAATexturePass2D(areaTex), texcoord, e, subsampleIndices);\n"
		"\n"
		"        // We give priority to diagonals, so if we find a diagonal we skip \n"
		"        // horizontal/vertical processing.\n"
		"        SMAA_BRANCH\n"
		"        if (weights.r == -weights.g) { // weights.r + weights.g == 0.0\n"
		"        #endif\n"
		"\n"
		"        float2 d;\n"
		"\n"
		"        // Find the distance to the left:\n"
		"        float3 coords;\n"
		"        coords.x = SMAASearchXLeft(SMAATexturePass2D(edgesTex), SMAATexturePass2D(searchTex), offset[0].xy, offset[2].x);\n"
		"        coords.y = offset[1].y; // offset[1].y = texcoord.y - 0.25 * SMAA_RT_METRICS.y (@CROSSING_OFFSET)\n"
		"        d.x = coords.x;\n"
		"\n"
		"        // Now fetch the left crossing edges, two at a time using bilinear\n"
		"        // filtering. Sampling at -0.25 (see @CROSSING_OFFSET) enables to\n"
		"        // discern what value each edge has:\n"
		"        float e1 = SMAASampleLevelZero(edgesTex, coords.xy).r;\n"
		"\n"
		"        // Find the distance to the right:\n"
		"        coords.z = SMAASearchXRight(SMAATexturePass2D(edgesTex), SMAATexturePass2D(searchTex), offset[0].zw, offset[2].y);\n"
		"        d.y = coords.z;\n"
		"\n"
		"        // We want the distances to be in pixel units (doing this here allow to\n"
		"        // better interleave arithmetic and memory accesses):\n"
		"        d = abs(round(mad(SMAA_RT_METRICS.zz, d, -pixcoord.xx)));\n"
		"\n"
		"        // SMAAArea below needs a sqrt, as the areas texture is compressed\n"
		"        // quadratically:\n"
		"        float2 sqrt_d = sqrt(d);\n"
		"\n"
		"        // Fetch the right crossing edges:\n"
		"        float e2 = SMAASampleLevelZeroOffset(edgesTex, coords.zy, int2(1, 0)).r;\n"
		"\n"
		"        // Ok, we know how this pattern looks like, now it is time for getting\n"
		"        // the actual area:\n"
		"        weights.rg = SMAAArea(SMAATexturePass2D(areaTex), sqrt_d, e1, e2, subsampleIndices.y);\n"
		"\n"
		"        // Fix corners:\n"
		"        coords.y = texcoord.y;\n"
		"        SMAADetectHorizontalCornerPattern(SMAATexturePass2D(edgesTex), weights.rg, coords.xyzy, d);\n"
		"\n"
		"        #if !defined(SMAA_DISABLE_DIAG_DETECTION)\n"
		"        } else\n"
		"            e.r = 0.0; // Skip vertical processing.\n"
		"        #endif\n"
		"    }\n"
		"\n"
		"    SMAA_BRANCH\n"
		"    if (e.r > 0.0) { // Edge at west\n"
		"        float2 d;\n"
		"\n"
		"        // Find the distance to the top:\n"
		"        float3 coords;\n"
		"        coords.y = SMAASearchYUp(SMAATexturePass2D(edgesTex), SMAATexturePass2D(searchTex), offset[1].xy, offset[2].z);\n"
		"        coords.x = offset[0].x; // offset[1].x = texcoord.x - 0.25 * SMAA_RT_METRICS.x;\n"
		"        d.x = coords.y;\n"
		"\n"
		"        // Fetch the top crossing edges:\n"
		"        float e1 = SMAASampleLevelZero(edgesTex, coords.xy).g;\n"
		"\n"
		"        // Find the distance to the bottom:\n"
		"        coords.z = SMAASearchYDown(SMAATexturePass2D(edgesTex), SMAATexturePass2D(searchTex), offset[1].zw, offset[2].w);\n"
		"        d.y = coords.z;\n"
		"\n"
		"        // We want the distances to be in pixel units:\n"
		"        d = abs(round(mad(SMAA_RT_METRICS.ww, d, -pixcoord.yy)));\n"
		"\n"
		"        // SMAAArea below needs a sqrt, as the areas texture is compressed \n"
		"        // quadratically:\n"
		"        float2 sqrt_d = sqrt(d);\n"
		"\n"
		"        // Fetch the bottom crossing edges:\n"
		"        float e2 = SMAASampleLevelZeroOffset(edgesTex, coords.xz, int2(0, API_V_DIR(1))).g;\n"
		"\n"
		"        // Get the area for this direction:\n"
		"        weights.ba = SMAAArea(SMAATexturePass2D(areaTex), sqrt_d, e1, e2, subsampleIndices.x);\n"
		"\n"
		"        // Fix corners:\n"
		"        coords.x = texcoord.x;\n"
		"        SMAADetectVerticalCornerPattern(SMAATexturePass2D(edgesTex), weights.ba, coords.xyxz, d);\n"
		"    }\n"
		"\n"
		"    return weights;\n"
		"}\n"
		"\n"
		"//-----------------------------------------------------------------------------\n"
		"// Neighborhood Blending Pixel Shader (Third Pass)\n"
		"\n"
		"float4 SMAANeighborhoodBlendingPS(float2 texcoord,\n"
		"                                  float4 offset,\n"
		"                                  SMAATexture2D(colorTex),\n"
		"                                  SMAATexture2D(blendTex)\n"
		"                                  #if SMAA_REPROJECTION\n"
		"                                  , SMAATexture2D(velocityTex)\n"
		"                                  #endif\n"
		"                                  ) {\n"
		"    // Fetch the blending weights for current pixel:\n"
		"    float4 a;\n"
		"    a.x = SMAASample(blendTex, offset.xy).a; // Right\n"
		"    a.y = SMAASample(blendTex, offset.zw).g; // Top\n"
		"    a.wz = SMAASample(blendTex, texcoord).xz; // Bottom / Left\n"
		"\n"
		"    // Is there any blending weight with a value greater than 0.0?\n"
		"    SMAA_BRANCH\n"
		"    if (dot(a, float4(1.0, 1.0, 1.0, 1.0)) < 1e-5) {\n"
		"        float4 color = SMAASampleLevelZero(colorTex, texcoord);\n"
		"\n"
		"        #if SMAA_REPROJECTION\n"
		"        float2 velocity = SMAA_DECODE_VELOCITY(SMAASampleLevelZero(velocityTex, texcoord));\n"
		"\n"
		"        // Pack velocity into the alpha channel:\n"
		"        color.a = sqrt(5.0 * length(velocity));\n"
		"        #endif\n"
		"\n"
		"        return color;\n"
		"    } else {\n"
		"        bool h = max(a.x, a.z) > max(a.y, a.w); // max(horizontal) > max(vertical)\n"
		"\n"
		"        // Calculate the blending offsets:\n"
		"        float4 blendingOffset = float4(0.0, API_V_DIR(a.y), 0.0, API_V_DIR(a.w));\n"
		"        float2 blendingWeight = a.yw;\n"
		"        SMAAMovc(bool4(h, h, h, h), blendingOffset, float4(a.x, 0.0, a.z, 0.0));\n"
		"        SMAAMovc(bool2(h, h), blendingWeight, a.xz);\n"
		"        blendingWeight /= dot(blendingWeight, float2(1.0, 1.0));\n"
		"\n"
		"        // Calculate the texture coordinates:\n"
		"        float4 blendingCoord = mad(blendingOffset, float4(SMAA_RT_METRICS.xy, -SMAA_RT_METRICS.xy), texcoord.xyxy);\n"
		"\n"
		"        // We exploit bilinear filtering to mix current pixel with the chosen\n"
		"        // neighbor:\n"
		"        float4 color = blendingWeight.x * SMAASampleLevelZero(colorTex, blendingCoord.xy);\n"
		"        color += blendingWeight.y * SMAASampleLevelZero(colorTex, blendingCoord.zw);\n"
		"\n"
		"        #if SMAA_REPROJECTION\n"
		"        // Antialias velocity for proper reprojection in a later stage:\n"
		"        float2 velocity = blendingWeight.x * SMAA_DECODE_VELOCITY(SMAASampleLevelZero(velocityTex, blendingCoord.xy));\n"
		"        velocity += blendingWeight.y * SMAA_DECODE_VELOCITY(SMAASampleLevelZero(velocityTex, blendingCoord.zw));\n"
		"\n"
		"        // Pack velocity into the alpha channel:\n"
		"        color.a = sqrt(5.0 * length(velocity));\n"
		"        #endif\n"
		"\n"
		"        return color;\n"
		"    }\n"
		"}\n"
		"\n"
		"//-----------------------------------------------------------------------------\n"
		"// Temporal Resolve Pixel Shader (Optional Pass)\n"
		"\n"
		"float4 SMAAResolvePS(float2 texcoord,\n"
		"                     SMAATexture2D(currentColorTex),\n"
		"                     SMAATexture2D(previousColorTex)\n"
		"                     #if SMAA_REPROJECTION\n"
		"                     , SMAATexture2D(velocityTex)\n"
		"                     #endif\n"
		"                     ) {\n"
		"    #if SMAA_REPROJECTION\n"
		"    // Velocity is assumed to be calculated for motion blur, so we need to\n"
		"    // inverse it for reprojection:\n"
		"    float2 velocity = -SMAA_DECODE_VELOCITY(SMAASamplePoint(velocityTex, texcoord).rg);\n"
		"\n"
		"    // Fetch current pixel:\n"
		"    float4 current = SMAASamplePoint(currentColorTex, texcoord);\n"
		"\n"
		"    // Reproject current coordinates and fetch previous pixel:\n"
		"    float4 previous = SMAASamplePoint(previousColorTex, texcoord + velocity);\n"
		"\n"
		"    // Attenuate the previous pixel if the velocity is different:\n"
		"    float delta = abs(current.a * current.a - previous.a * previous.a) / 5.0;\n"
		"    float weight = 0.5 * saturate(1.0 - sqrt(delta) * SMAA_REPROJECTION_WEIGHT_SCALE);\n"
		"\n"
		"    // Blend the pixels according to the calculated weight:\n"
		"    return lerp(current, previous, weight);\n"
		"    #else\n"
		"    // Just blend the pixels:\n"
		"    float4 current = SMAASamplePoint(currentColorTex, texcoord);\n"
		"    float4 previous = SMAASamplePoint(previousColorTex, texcoord);\n"
		"    return lerp(current, previous, 0.5);\n"
		"    #endif\n"
		"}\n"
		"\n"
		"//-----------------------------------------------------------------------------\n"
		"// Separate Multisamples Pixel Shader (Optional Pass)\n"
		"\n"
		"#ifdef SMAALoad\n"
		"void SMAASeparatePS(float4 position,\n"
		"                    float2 texcoord,\n"
		"                    out float4 target0,\n"
		"                    out float4 target1,\n"
		"                    SMAATexture2DMS2(colorTexMS)) {\n"
		"    int2 pos = int2(position.xy);\n"
		"    target0 = SMAALoad(colorTexMS, pos, 0);\n"
		"    target1 = SMAALoad(colorTexMS, pos, 1);\n"
		"}\n"
		"#endif\n"
		"\n"
		"//-----------------------------------------------------------------------------\n"
		"#endif // SMAA_INCLUDE_PS\n"
		"\n"
		
	},
	
	{
		"renderprogs/BRDF.inc",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 2014 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"// Normal Distribution Function ( NDF ) or D( h )\n"
		"// GGX ( Trowbridge-Reitz )\n"
		"half Distribution_GGX( half hdotN, half alpha )\n"
		"{\n"
		"	// alpha is assumed to be roughness^2\n"
		"	float a2 = alpha * alpha;\n"
		"	//float tmp = ( hdotN * hdotN ) * ( a2 - 1.0 ) + 1.0;\n"
		"	float tmp = ( hdotN * a2 - hdotN ) * hdotN + 1.0;\n"
		"	\n"
		"	return ( a2 / ( PI * tmp * tmp ) );\n"
		"}\n"
		"\n"
		"half Distribution_GGX_Disney( half hdotN, half alphaG )\n"
		"{\n"
		"	float a2 = alphaG * alphaG;\n"
		"	float tmp = ( hdotN * hdotN ) * ( a2 - 1.0 ) + 1.0;\n"
		"	//tmp *= tmp;\n"
		"	\n"
		"	return ( a2 / ( PI * tmp ) );\n"
		"}\n"
		"\n"
		"half Distribution_GGX_1886( half hdotN, half alpha )\n"
		"{\n"
		"	// alpha is assumed to be roughness^2\n"
		"	return ( alpha / ( PI * pow( hdotN * hdotN * ( alpha - 1.0 ) + 1.0, 2.0 ) ) );\n"
		"}\n"
		"\n"
		"// Fresnel term F( v, h )\n"
		"// Fnone( v, h ) = F(0) = specularColor\n"
		"half3 Fresnel_Schlick( half3 specularColor, half vdotH )\n"
		"{\n"
		"	return specularColor + ( 1.0 - specularColor ) * pow( 1.0 - vdotH, 5.0 );\n"
		"}\n"
		"\n"
		"// Visibility term G( l, v, h )\n"
		"// Very similar to Marmoset Toolbag 2 and gives almost the same results as Smith GGX\n"
		"float Visibility_Schlick( half vdotN, half ldotN, float alpha )\n"
		"{\n"
		"	float k = alpha * 0.5;\n"
		"	\n"
		"	float schlickL = ( ldotN * ( 1.0 - k ) + k );\n"
		"	float schlickV = ( vdotN * ( 1.0 - k ) + k );\n"
		"	\n"
		"	return ( 0.25 / ( schlickL * schlickV ) );\n"
		"	//return ( ( schlickL * schlickV ) / ( 4.0 * vdotN * ldotN ) );\n"
		"}\n"
		"\n"
		"// see s2013_pbs_rad_notes.pdf\n"
		"// Crafting a Next-Gen Material Pipeline for The Order: 1886\n"
		"// this visibility function also provides some sort of back lighting\n"
		"float Visibility_SmithGGX( half vdotN, half ldotN, float alpha )\n"
		"{\n"
		"	// alpha is already roughness^2\n"
		"\n"
		"	float V1 = ldotN + sqrt( alpha + ( 1.0 - alpha ) * ldotN * ldotN );\n"
		"	float V2 = vdotN + sqrt( alpha + ( 1.0 - alpha ) * vdotN * vdotN );\n"
		"	\n"
		"	// RB: avoid too bright spots\n"
		"	return ( 1.0 / max( V1 * V2, 0.15 ) );\n"
		"}\n"
		"\n"
		"\n"
		"// Environment BRDF approximations\n"
		"// see s2013_pbs_black_ops_2_notes.pdf\n"
		"half a1vf( half g )\n"
		"{\n"
		"	return ( 0.25 * g + 0.75 );\n"
		"}\n"
		"\n"
		"half a004( half g, half vdotN )\n"
		"{\n"
		"	float t = min( 0.475 * g, exp2( -9.28 * vdotN ) );\n"
		"	return ( t + 0.0275 ) * g + 0.015;\n"
		"}\n"
		"\n"
		"half a0r( half g, half vdotN )\n"
		"{\n"
		"	return ( ( a004( g, vdotN ) - a1vf( g ) * 0.04 ) / 0.96 );\n"
		"}\n"
		"\n"
		"float3 EnvironmentBRDF( half g, half vdotN, float3 rf0 )\n"
		"{\n"
		"	float4 t = float4( 1.0 / 0.96, 0.475, ( 0.0275 - 0.25 * 0.04 ) / 0.96, 0.25 );\n"
		"	t *= float4( g, g, g, g );\n"
		"	t += float4( 0.0, 0.0, ( 0.015 - 0.75 * 0.04 ) / 0.96, 0.75 );\n"
		"	half a0 = t.x * min( t.y, exp2( -9.28 * vdotN ) ) + t.z;\n"
		"	half a1 = t.w;\n"
		"	\n"
		"	return saturate( a0 + rf0 * ( a1 - a0 ) );\n"
		"}\n"
		"\n"
		"\n"
		"half3 EnvironmentBRDFApprox( half roughness, half vdotN, half3 specularColor )\n"
		"{\n"
		"	const half4 c0 = half4( -1, -0.0275, -0.572, 0.022 );\n"
		"	const half4 c1 = half4( 1, 0.0425, 1.04, -0.04 );\n"
		"\n"
		"	half4 r = roughness * c0 + c1;\n"
		"	half a004 = min( r.x * r.x, exp2( -9.28 * vdotN ) ) * r.x + r.y;\n"
		"	half2 AB = half2( -1.04, 1.04 ) * a004 + r.zw;\n"
		"\n"
		"	return specularColor * AB.x + AB.y;\n"
		"\n"
		"}\n"
		"\n"
		"\n"
		"\n"
		"\n"
		
	},
	
	{
		"renderprogs/ambient_lighting.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2013-2015 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D	samp0 : register(s0); // texture 1 is the per-surface bump map\n"
		"uniform sampler2D	samp1 : register(s1); // texture 2 is the light falloff texture\n"
		"uniform sampler2D	samp2 : register(s2); // texture 3 is the light projection texture\n"
		"uniform sampler2D	samp3 : register(s3); // texture 4 is the per-surface diffuse map\n"
		"uniform sampler2D	samp4 : register(s4); // texture 5 is the per-surface specular map\n"
		"\n"
		"struct PS_IN {\n"
		"	half4 position	: VPOS;\n"
		"	half4 texcoord0	: TEXCOORD0_centroid;\n"
		"	half4 texcoord1	: TEXCOORD1_centroid;\n"
		"//	half4 texcoord2	: TEXCOORD2_centroid;\n"
		"//	half4 texcoord3	: TEXCOORD3_centroid;\n"
		"	half4 texcoord4	: TEXCOORD4_centroid;\n"
		"	half4 texcoord5	: TEXCOORD5_centroid;\n"
		"	half4 texcoord6	: TEXCOORD6_centroid;\n"
		"	half4 color		: COLOR0;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	half4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"	half4 bumpMap =			tex2D( samp0, fragment.texcoord1.xy );\n"
		"//	half4 lightFalloff =	idtex2Dproj( samp1, fragment.texcoord2 );\n"
		"//	half4 lightProj	=		idtex2Dproj( samp2, fragment.texcoord3 );\n"
		"	half4 YCoCG =			tex2D( samp3, fragment.texcoord4.xy );\n"
		"	half4 specMap =			sRGBAToLinearRGBA( tex2D( samp4, fragment.texcoord5.xy ) );\n"
		"\n"
		"	half3 lightVector = normalize( fragment.texcoord0.xyz );\n"
		"	half3 diffuseMap = sRGBToLinearRGB( ConvertYCoCgToRGB( YCoCG ) );\n"
		"\n"
		"	half3 localNormal;\n"
		"#if defined(USE_NORMAL_FMT_RGB8)\n"
		"	localNormal.xy = bumpMap.rg - 0.5;\n"
		"#else\n"
		"	localNormal.xy = bumpMap.wy - 0.5;\n"
		"#endif\n"
		"	localNormal.z = sqrt( abs( dot( localNormal.xy, localNormal.xy ) - 0.25 ) );\n"
		"	localNormal = normalize( localNormal );\n"
		"\n"
		"	const half specularPower = 10.0f;\n"
		"	half hDotN = dot3( normalize( fragment.texcoord6.xyz ), localNormal );\n"
		"	// RB: added abs\n"
		"	half3 specularContribution = _half3( pow( abs( hDotN ), specularPower ) );\n"
		"\n"
		"	half3 diffuseColor = diffuseMap * ( rpDiffuseModifier.xyz ) * 1.5f;\n"
		"	half3 specularColor = specMap.xyz * specularContribution * ( rpSpecularModifier.xyz ); \n"
		"	\n"
		"	// RB: http://developer.valvesoftware.com/wiki/Half_Lambert\n"
		"	float halfLdotN = dot3( localNormal, lightVector ) * 0.5 + 0.5;\n"
		"	halfLdotN *= halfLdotN;\n"
		"	\n"
		"	// traditional very dark Lambert light model used in Doom 3\n"
		"	float ldotN = dot3( localNormal, lightVector );\n"
		"	\n"
		"	half3 lightColor = sRGBToLinearRGB( rpAmbientColor.rgb );\n"
		"	\n"
		"	half rim =  1.0f - saturate( hDotN );\n"
		"	half rimPower = 8.0;\n"
		"	half3 rimColor = sRGBToLinearRGB( half3( 0.125 ) * 1.2 ) * lightColor * pow( rim, rimPower );\n"
		"	\n"
		"	//result.color.rgb = localNormal.xyz * 0.5 + 0.5;\n"
		"	result.color.xyz = ( ( diffuseColor + specularColor ) * halfLdotN * lightColor + rimColor ) * fragment.color.rgb;\n"
		"	//result.color = ( ( diffuseColor + specularColor ) * halfLdotN * lightColor + rimColor ) * fragment.color.rgba;\n"
		"	result.color.w = fragment.color.a;\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/ambient_lighting.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2013-2015 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"#if defined( USE_GPU_SKINNING )\n"
		"uniform matrices_ubo { float4 matrices[408]; };\n"
		"#endif\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"	float4 color2 : COLOR1;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position		: POSITION;\n"
		"	float4 texcoord0	: TEXCOORD0;\n"
		"	float4 texcoord1	: TEXCOORD1;\n"
		"//	float4 texcoord2	: TEXCOORD2;\n"
		"//	float4 texcoord3	: TEXCOORD3;\n"
		"	float4 texcoord4	: TEXCOORD4;\n"
		"	float4 texcoord5	: TEXCOORD5;\n"
		"	float4 texcoord6	: TEXCOORD6;\n"
		"	float4 color		: COLOR0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"\n"
		"	float4 vNormal = vertex.normal * 2.0 - 1.0;\n"
		"	float4 vTangent = vertex.tangent * 2.0 - 1.0;\n"
		"	float3 vBitangent = cross( vNormal.xyz, vTangent.xyz ) * vTangent.w;\n"
		"\n"
		"#if defined( USE_GPU_SKINNING )\n"
		"	//--------------------------------------------------------------\n"
		"	// GPU transformation of the normal / tangent / bitangent\n"
		"	//\n"
		"	// multiplying with 255.1 give us the same result and is faster than floor( w * 255 + 0.5 )\n"
		"	//--------------------------------------------------------------\n"
		"	const float w0 = vertex.color2.x;\n"
		"	const float w1 = vertex.color2.y;\n"
		"	const float w2 = vertex.color2.z;\n"
		"	const float w3 = vertex.color2.w;\n"
		"\n"
		"	float4 matX, matY, matZ;	// must be float4 for vec4\n"
		"	int joint = int(vertex.color.x * 255.1 * 3.0);\n"
		"	matX = matrices[int(joint+0)] * w0;\n"
		"	matY = matrices[int(joint+1)] * w0;\n"
		"	matZ = matrices[int(joint+2)] * w0;\n"
		"\n"
		"	joint = int(vertex.color.y * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w1;\n"
		"	matY += matrices[int(joint+1)] * w1;\n"
		"	matZ += matrices[int(joint+2)] * w1;\n"
		"\n"
		"	joint = int(vertex.color.z * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w2;\n"
		"	matY += matrices[int(joint+1)] * w2;\n"
		"	matZ += matrices[int(joint+2)] * w2;\n"
		"\n"
		"	joint = int(vertex.color.w * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w3;\n"
		"	matY += matrices[int(joint+1)] * w3;\n"
		"	matZ += matrices[int(joint+2)] * w3;\n"
		"\n"
		"	float3 normal;\n"
		"	normal.x = dot3( matX, vNormal );\n"
		"	normal.y = dot3( matY, vNormal );\n"
		"	normal.z = dot3( matZ, vNormal );\n"
		"	normal = normalize( normal );\n"
		"\n"
		"	float3 tangent;\n"
		"	tangent.x = dot3( matX, vTangent );\n"
		"	tangent.y = dot3( matY, vTangent );\n"
		"	tangent.z = dot3( matZ, vTangent );\n"
		"	tangent = normalize( tangent );\n"
		"\n"
		"	float3 bitangent;\n"
		"	bitangent.x = dot3( matX, vBitangent );\n"
		"	bitangent.y = dot3( matY, vBitangent );\n"
		"	bitangent.z = dot3( matZ, vBitangent );\n"
		"	bitangent = normalize( bitangent );\n"
		"\n"
		"	float4 modelPosition;\n"
		"	modelPosition.x = dot4( matX, vertex.position );\n"
		"	modelPosition.y = dot4( matY, vertex.position );\n"
		"	modelPosition.z = dot4( matZ, vertex.position );\n"
		"	modelPosition.w = 1.0;\n"
		"\n"
		"#else\n"
		"	float4 modelPosition = vertex.position;\n"
		"	float3 normal = vNormal.xyz;\n"
		"	float3 tangent = vTangent.xyz;\n"
		"	float3 bitangent = vBitangent.xyz;\n"
		"#endif\n"
		"\n"
		"	result.position.x = dot4( modelPosition, rpMVPmatrixX );\n"
		"	result.position.y = dot4( modelPosition, rpMVPmatrixY );\n"
		"	result.position.z = dot4( modelPosition, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( modelPosition, rpMVPmatrixW );\n"
		"\n"
		"	float4 defaultTexCoord = float4( 0.0f, 0.5f, 0.0f, 1.0f );\n"
		"\n"
		"	//calculate vector to light\n"
		"	//float4 toLight = rpLocalLightOrigin;\n"
		"	float4 toLight = normalize( float4( 0.0f, 0.5f, 1.0f, 1.0f ) );\n"
		"\n"
		"	//--------------------------------------------------------------\n"
		"\n"
		"	//result.texcoord0 is the direction to the light in tangent space\n"
		"	result.texcoord0.x = dot3( tangent, toLight );\n"
		"	result.texcoord0.y = dot3( bitangent, toLight );\n"
		"	result.texcoord0.z = dot3( normal, toLight );\n"
		"	result.texcoord0.w = 1.0f;\n"
		"\n"
		"	//textures 1 takes the base coordinates by the texture matrix\n"
		"	result.texcoord1 = defaultTexCoord;\n"
		"	result.texcoord1.x = dot4( vertex.texcoord.xy, rpBumpMatrixS );\n"
		"	result.texcoord1.y = dot4( vertex.texcoord.xy, rpBumpMatrixT );\n"
		"\n"
		"	//# texture 2 has one texgen\n"
		"	//result.texcoord2 = defaultTexCoord;\n"
		"	//result.texcoord2.x = dot4( vertex.position, rpLightFalloffS );\n"
		"\n"
		"	//# texture 3 has three texgens\n"
		"	//result.texcoord3.x = dot4( vertex.position, rpLightProjectionS );\n"
		"	//result.texcoord3.y = dot4( vertex.position, rpLightProjectionT );\n"
		"	//result.texcoord3.z = 0.0f;\n"
		"	//result.texcoord3.w = dot4( vertex.position, rpLightProjectionQ );\n"
		"\n"
		"	//# textures 4 takes the base coordinates by the texture matrix\n"
		"	result.texcoord4 = defaultTexCoord;\n"
		"	result.texcoord4.x = dot4( vertex.texcoord.xy, rpDiffuseMatrixS );\n"
		"	result.texcoord4.y = dot4( vertex.texcoord.xy, rpDiffuseMatrixT );\n"
		"\n"
		"	//# textures 5 takes the base coordinates by the texture matrix\n"
		"	result.texcoord5 = defaultTexCoord;\n"
		"	result.texcoord5.x = dot4( vertex.texcoord.xy, rpSpecularMatrixS );\n"
		"	result.texcoord5.y = dot4( vertex.texcoord.xy, rpSpecularMatrixT );\n"
		"\n"
		"	//# texture 6's texcoords will be the halfangle in texture space\n"
		"\n"
		"	//# calculate normalized vector to light in R0\n"
		"	toLight = normalize( toLight );\n"
		"\n"
		"	//# calculate normalized vector to viewer in R1\n"
		"	float4 toView = normalize( rpLocalViewOrigin - modelPosition );\n"
		"	\n"
		"	//# add together to become the half angle vector in object space (non-normalized)\n"
		"	float4 halfAngleVector = toLight + toView;\n"
		"\n"
		"	//# put into texture space\n"
		"	result.texcoord6.x = dot3( tangent, halfAngleVector );\n"
		"	result.texcoord6.y = dot3( bitangent, halfAngleVector );\n"
		"	result.texcoord6.z = dot3( normal, halfAngleVector );\n"
		"	result.texcoord6.w = 1.0f;\n"
		"\n"
		"#if defined( USE_GPU_SKINNING )\n"
		"	// for joint transformation of the tangent space, we use color and\n"
		"	// color2 for weighting information, so hopefully there aren't any\n"
		"	// effects that need vertex color...\n"
		"	result.color = float4( 1.0f, 1.0f, 1.0f, 1.0f );\n"
		"#else\n"
		"	//# generate the vertex color, which can be 1.0, color, or 1.0 - color\n"
		"	//# for 1.0 : env[16] = 0, env[17] = 1\n"
		"	//# for color : env[16] = 1, env[17] = 0\n"
		"	//# for 1.0-color : env[16] = -1, env[17] = 1	\n"
		"	result.color = ( swizzleColor( vertex.color ) * rpVertexColorModulate ) + rpVertexColorAdd;\n"
		"#endif\n"
		"}\n"
		
	},
	
	{
		"renderprogs/AmbientOcclusion_AO.pixel",
		"/**\n"
		" \file AmbientOcclusion_AO.pix\n"
		" \author Morgan McGuire and Michael Mara, NVIDIA Research\n"
		"\n"
		" Reference implementation of the Scalable Ambient Obscurance (AmbientOcclusion) screen-space ambient obscurance algorithm.\n"
		"\n"
		" The optimized algorithmic structure of AmbientOcclusion was published in McGuire, Mara, and Luebke, Scalable Ambient Obscurance,\n"
		" <i>HPG</i> 2012, and was developed at NVIDIA with support from Louis Bavoil.\n"
		"\n"
		" The mathematical ideas of AlchemyAO were first described in McGuire, Osman, Bukowski, and Hennessy, The\n"
		" Alchemy Screen-Space Ambient Obscurance Algorithm, <i>HPG</i> 2011 and were developed at\n"
		" Vicarious Visions.\n"
		"\n"
		" DX11 HLSL port by Leonardo Zide of Treyarch\n"
		"\n"
		" <hr>\n"
		"\n"
		"  Open Source under the \"BSD\" license: http://www.opensource.org/licenses/bsd-license.php\n"
		"\n"
		"  Copyright (c) 2011-2012, NVIDIA\n"
		"  Copyright (c) 2016 Robert Beckebans ( id Tech 4.x integration )\n"
		"  All rights reserved.\n"
		"\n"
		"  Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:\n"
		"\n"
		"  Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.\n"
		"  Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.\n"
		"  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n"
		"\n"
		"  */\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"\n"
		"\n"
		"#define DIFFERENT_DEPTH_RESOLUTIONS 0\n"
		"#define USE_DEPTH_PEEL 0\n"
		"#define CS_Z_PACKED_TOGETHER 0\n"
		"#define TEMPORALLY_VARY_TAPS 0\n"
		"#define HIGH_QUALITY 1\n"
		"#define USE_OCT16 0\n"
		"#define USE_MIPMAPS 1\n"
		"\n"
		"// Total number of direct samples to take at each pixel\n"
		"#define NUM_SAMPLES 11\n"
		"\n"
		"// This is the number of turns around the circle that the spiral pattern makes.  This should be prime to prevent\n"
		"// taps from lining up.  This particular choice was tuned for NUM_SAMPLES == 9\n"
		"#define NUM_SPIRAL_TURNS 7\n"
		"\n"
		"// If using depth mip levels, the log of the maximum pixel offset before we need to switch to a lower\n"
		"// miplevel to maintain reasonable spatial locality in the cache\n"
		"// If this number is too small (< 3), too many taps will land in the same pixel, and we'll get bad variance that manifests as flashing.\n"
		"// If it is too high (> 5), we'll get bad performance because we're not using the MIP levels effectively\n"
		"#define LOG_MAX_OFFSET (3)\n"
		"\n"
		"// This must be less than or equal to the MAX_MIP_LEVEL defined in SAmbientOcclusion.cpp\n"
		"#define MAX_MIP_LEVEL (5)\n"
		"\n"
		"#define MIN_MIP_LEVEL 0\n"
		"\n"
		"const float DOOM_TO_METERS = 0.0254;					// doom to meters\n"
		"const float METERS_TO_DOOM = ( 1.0 / DOOM_TO_METERS );	// meters to doom\n"
		"\n"
		"/** Used for preventing AO computation on the sky (at infinite depth) and defining the CS Z to bilateral depth key scaling.\n"
		"    This need not match the real far plane but should not be much more than it.*/\n"
		"//const float FAR_PLANE_Z = -4000.0;\n"
		"\n"
		"/** World-space AO radius in scene units (r).  e.g., 1.0m */\n"
		"const float radius = 1.0 * METERS_TO_DOOM;\n"
		"const float radius2 = radius * radius;\n"
		"const float invRadius2 = 1.0 / radius2;\n"
		"\n"
		"/** Bias to avoid AO in smooth corners, e.g., 0.01m */\n"
		"const float bias = 0.01 * METERS_TO_DOOM;\n"
		"\n"
		"/** intensity / radius^6 */\n"
		"const float intensity = 0.6;\n"
		"const float intensityDivR6 = intensity / ( radius* radius* radius* radius* radius* radius );\n"
		"\n"
		"/** The height in pixels of a 1m object if viewed from 1m away.\n"
		"    You can compute it from your projection matrix.  The actual value is just\n"
		"    a scale factor on radius; you can simply hardcode this to a constant (~500)\n"
		"    and make your radius value unitless (...but resolution dependent.)  */\n"
		"const float projScale = 500.0;\n"
		"\n"
		"//#expect NUM_SAMPLES \"Integer number of samples to take at each pixels\"\n"
		"//#expect NUM_SPIRAL_TURNS \"Integer number of turns around the circle that the spiral pattern makes. The G3D::AmbientOcclusion class provides a discrepancy-minimizing value of NUM_SPIRAL_TURNS for eac value of NUM_SAMPLES.\"\n"
		"//#expect DIFFERENT_DEPTH_RESOLUTIONS \"1 if the peeled depth buffer is at a different resolution than the primary depth buffer\"\n"
		"//#expect USE_DEPTH_PEEL \"1 to enable, 0 to disable\"\n"
		"//#expect CS_Z_PACKED_TOGETHER \"1 to enable, 0 to disable\"\n"
		"//#expect TEMPORALLY_VARY_SAMPLES \"1 to enable, 0 to disable\"\n"
		"\n"
		"// *INDENT-OFF*\n"
		"uniform sampler2D samp0 : register( s0 ); // view normal/roughness\n"
		"uniform sampler2D samp1 : register( s1 ); // view depth\n"
		" \n"
		"#define CS_Z_buffer		samp1\n"
		" \n"
		"struct PS_IN\n"
		"{\n"
		"	float2 texcoord0 : TEXCOORD0_centroid;\n"
		"};\n"
		" \n"
		"struct PS_OUT \n"
		"{\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"// *INDENT-ON*\n"
		"\n"
		"\n"
		"\n"
		"\n"
		"/** Used for packing Z into the GB channels */\n"
		"// float CSZToKey( float z )\n"
		"// {\n"
		"// return clamp( z * ( 1.0 / FAR_PLANE_Z ), 0.0, 1.0 );\n"
		"// }\n"
		"\n"
		"/** Used for packing Z into the GB channels */\n"
		"void packKey( float key, out float2 p )\n"
		"{\n"
		"	// Round to the nearest 1/256.0\n"
		"	float temp = floor( key * 256.0 );\n"
		"	\n"
		"	// Integer part\n"
		"	p.x = temp * ( 1.0 / 256.0 );\n"
		"	\n"
		"	// Fractional part\n"
		"	p.y = key * 256.0 - temp;\n"
		"}\n"
		"\n"
		"/** Reconstructs screen-space unit normal from screen-space position */\n"
		"float3 reconstructCSFaceNormal( float3 C )\n"
		"{\n"
		"	return normalize( cross( dFdy( C ), dFdx( C ) ) );\n"
		"}\n"
		"\n"
		"float3 reconstructNonUnitCSFaceNormal( float3 C )\n"
		"{\n"
		"	float3 n = cross( dFdy( C ), dFdx( C ) );\n"
		"	//n.z = sqrt( abs( dot( n.xy, n.xy ) - 0.25 ) );\n"
		"	return n;\n"
		"}\n"
		"\n"
		"float3 reconstructCSPosition( float2 S, float z )\n"
		"{\n"
		"	float4 P;\n"
		"	P.z = z * 2.0 - 1.0;\n"
		"	P.xy = ( S * rpScreenCorrectionFactor.xy ) * 2.0 - 1.0;\n"
		"	P.w = 1.0;\n"
		"	\n"
		"	float4 csP;\n"
		"	csP.x = dot4( P, rpModelMatrixX );\n"
		"	csP.y = dot4( P, rpModelMatrixY );\n"
		"	csP.z = dot4( P, rpModelMatrixZ );\n"
		"	csP.w = dot4( P, rpModelMatrixW );\n"
		"	\n"
		"	csP.xyz /= csP.w;\n"
		"	\n"
		"	return csP.xyz;\n"
		"}\n"
		"\n"
		"float3 sampleNormal( sampler2D normalBuffer, int2 ssC, int mipLevel )\n"
		"{\n"
		"#if USE_OCT16\n"
		"	return decode16( texelFetch( normalBuffer, ssC, mipLevel ).xy * 2.0 - 1.0 );\n"
		"#else\n"
		"	return texelFetch( normalBuffer, ssC, mipLevel ).xyz * 2.0 - 1.0;\n"
		"#endif\n"
		"}\n"
		"\n"
		"/** Returns a unit vector and a screen-space radius for the tap on a unit disk\n"
		"    (the caller should scale by the actual disk radius) */\n"
		"float2 tapLocation( int sampleNumber, float spinAngle, out float ssR )\n"
		"{\n"
		"	// Radius relative to ssR\n"
		"	float alpha = float( sampleNumber + 0.5 ) * ( 1.0 / NUM_SAMPLES );\n"
		"	float angle = alpha * ( NUM_SPIRAL_TURNS * 6.28 ) + spinAngle;\n"
		"	\n"
		"	ssR = alpha;\n"
		"	return float2( cos( angle ), sin( angle ) );\n"
		"}\n"
		"\n"
		"\n"
		"/** Read the camera-space position of the point at screen-space pixel ssP */\n"
		"float3 getPosition( int2 ssP, sampler2D cszBuffer )\n"
		"{\n"
		"	float3 P;\n"
		"	P.z = texelFetch( cszBuffer, ssP, 0 ).r;\n"
		"	\n"
		"	// Offset to pixel center\n"
		"	P = reconstructCSPosition( float2( ssP ) + float2( 0.5 ), P.z );\n"
		"	\n"
		"	return P;\n"
		"}\n"
		"\n"
		"void computeMipInfo( float ssR, int2 ssP, sampler2D cszBuffer, out int mipLevel, out int2 mipP )\n"
		"{\n"
		"	// Derivation:\n"
		"	//  mipLevel = floor(log(ssR / MAX_OFFSET));\n"
		"#ifdef GL_EXT_gpu_shader5\n"
		"	mipLevel = clamp( findMSB( int( ssR ) ) - LOG_MAX_OFFSET, 0, MAX_MIP_LEVEL );\n"
		"#else\n"
		"	mipLevel = clamp( int( floor( log2( ssR ) ) ) - LOG_MAX_OFFSET, 0, MAX_MIP_LEVEL );\n"
		"#endif\n"
		"	\n"
		"	// We need to divide by 2^mipLevel to read the appropriately scaled coordinate from a MIP-map.\n"
		"	// Manually clamp to the texture size because texelFetch bypasses the texture unit\n"
		"	\n"
		"	// used in newer radiosity\n"
		"	//mipP = ssP >> mipLevel;\n"
		"	\n"
		"	mipP = clamp( ssP >> mipLevel, int2( 0 ), textureSize( cszBuffer, mipLevel ) - int2( 1 ) );\n"
		"}\n"
		"\n"
		"/** Read the camera-space position of the point at screen-space pixel ssP + unitOffset * ssR.  Assumes length(unitOffset) == 1.\n"
		"    Use cszBufferScale if reading from the peeled depth buffer, which has been scaled by (1 / invCszBufferScale) from the original */\n"
		"float3 getOffsetPosition( int2 issC, float2 unitOffset, float ssR, sampler2D cszBuffer, float invCszBufferScale )\n"
		"{\n"
		"	int2 ssP = int2( ssR * unitOffset ) + issC;\n"
		"	\n"
		"	float3 P;\n"
		"	\n"
		"	int mipLevel;\n"
		"	int2 mipP;\n"
		"	computeMipInfo( ssR, ssP, cszBuffer, mipLevel, mipP );\n"
		"	\n"
		"#if USE_MIPMAPS\n"
		"	// RB: this is the key for fast ambient occlusion - use a hierarchical depth buffer\n"
		"	// for more information see McGuire12SAO.pdf - Scalable Ambient Obscurance\n"
		"	// http://graphics.cs.williams.edu/papers/SAOHPG12/\n"
		"	P.z = texelFetch( cszBuffer, mipP, mipLevel ).r;\n"
		"#else\n"
		"	P.z = texelFetch( cszBuffer, ssP, 0 ).r;\n"
		"#endif\n"
		"	\n"
		"	// Offset to pixel center\n"
		"	P = reconstructCSPosition( float2( ssP ) + float2( 0.5 ), P.z );\n"
		"	//P = reconstructCSPosition( ( float2( ssP ) + float2( 0.5 ) ) * invCszBufferScale, P.z );\n"
		"	\n"
		"	return P;\n"
		"}\n"
		"\n"
		"float fallOffFunction( float vv, float vn, float epsilon )\n"
		"{\n"
		"	// A: From the HPG12 paper\n"
		"	// Note large epsilon to avoid overdarkening within cracks\n"
		"	//  Assumes the desired result is intensity/radius^6 in main()\n"
		"	// return float(vv < radius2) * max((vn - bias) / (epsilon + vv), 0.0) * radius2 * 0.6;\n"
		"	\n"
		"	// B: Smoother transition to zero (lowers contrast, smoothing out corners). [Recommended]\n"
		"#if HIGH_QUALITY\n"
		"	// Epsilon inside the sqrt for rsqrt operation\n"
		"	float f = max( 1.0 - vv * invRadius2, 0.0 );\n"
		"	return f * max( ( vn - bias ) * rsqrt( epsilon + vv ), 0.0 );\n"
		"#else\n"
		"	// Avoid the square root from above.\n"
		"	//  Assumes the desired result is intensity/radius^6 in main()\n"
		"	float f = max( radius2 - vv, 0.0 );\n"
		"	return f * f * f * max( ( vn - bias ) / ( epsilon + vv ), 0.0 );\n"
		"#endif\n"
		"	\n"
		"	// C: Medium contrast (which looks better at high radii), no division.  Note that the\n"
		"	// contribution still falls off with radius^2, but we've adjusted the rate in a way that is\n"
		"	// more computationally efficient and happens to be aesthetically pleasing.  Assumes\n"
		"	// division by radius^6 in main()\n"
		"	//return 4.0 * max(1.0 - vv * invRadius2, 0.0) * max(vn - bias, 0.0);\n"
		"	\n"
		"	// D: Low contrast, no division operation\n"
		"	//return 2.0 * float(vv < radius * radius) * max(vn - bias, 0.0);\n"
		"}\n"
		"\n"
		"/** Compute the occlusion due to sample point \a Q about camera-space point \a C with unit normal \a n_C */\n"
		"float aoValueFromPositionsAndNormal( float3 C, float3 n_C, float3 Q )\n"
		"{\n"
		"	float3 v = Q - C;\n"
		"	//v = normalize( v );\n"
		"	float vv = dot( v, v );\n"
		"	float vn = dot( v, n_C );\n"
		"	const float epsilon = 0.001;\n"
		"	\n"
		"	// Without the angular adjustment term, surfaces seen head on have less AO\n"
		"	return fallOffFunction( vv, vn, epsilon ) * lerp( 1.0, max( 0.0, 1.5 * n_C.z ), 0.35 );\n"
		"}\n"
		"\n"
		"\n"
		"/** Compute the occlusion due to sample with index \a i about the pixel at \a ssC that corresponds\n"
		"    to camera-space point \a C with unit normal \a n_C, using maximum screen-space sampling radius \a ssDiskRadius\n"
		"\n"
		"    Note that units of H() in the HPG12 paper are meters, not\n"
		"    unitless.  The whole falloff/sampling function is therefore\n"
		"    unitless.  In this implementation, we factor out (9 / radius).\n"
		"\n"
		"    Four versions of the falloff function are implemented below\n"
		"\n"
		"    When sampling from the peeled depth buffer, make sure ssDiskRadius has been premultiplied by cszBufferScale\n"
		"*/\n"
		"float sampleAO( int2 issC, in float3 C, in float3 n_C, in float ssDiskRadius, in int tapIndex, in float randomPatternRotationAngle, in sampler2D cszBuffer, in float invCszBufferScale )\n"
		"{\n"
		"	// Offset on the unit disk, spun for this pixel\n"
		"	float ssR;\n"
		"	float2 unitOffset = tapLocation( tapIndex, randomPatternRotationAngle, ssR );\n"
		"	\n"
		"	// Ensure that the taps are at least 1 pixel away\n"
		"	ssR = max( 0.75, ssR * ssDiskRadius );\n"
		"	\n"
		"#if (CS_Z_PACKED_TOGETHER != 0)\n"
		"	vec3 Q0, Q1;\n"
		"	getOffsetPositions( ssC, unitOffset, ssR, cszBuffer, Q0, Q1 );\n"
		"	\n"
		"	return max( aoValueFromPositionsAndNormal( C, n_C, Q0 ), aoValueFromPositionsAndNormal( C, n_C, Q1 ) );\n"
		"#else\n"
		"	// The occluding point in camera space\n"
		"	vec3 Q = getOffsetPosition( issC, unitOffset, ssR, cszBuffer, invCszBufferScale );\n"
		"	\n"
		"	return aoValueFromPositionsAndNormal( C, n_C, Q );\n"
		"#endif\n"
		"}\n"
		"\n"
		"const float MIN_RADIUS = 3.0; // pixels\n"
		"\n"
		"#define visibility      result.color.r\n"
		"#define bilateralKey    result.color.gb\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result )\n"
		"{\n"
		"	result.color = float4( 1.0, 0.0, 0.0, 1.0 );\n"
		"	\n"
		"#if 0\n"
		"	if( fragment.texcoord0.x < 0.5 )\n"
		"	{\n"
		"		discard;\n"
		"	}\n"
		"#endif\n"
		"	\n"
		"	// Pixel being shaded\n"
		"	//float2 ssC = fragment.texcoord0;\n"
		"	//int2 issC = int2( ssC.x * rpScreenCorrectionFactor.z, ssC.y * rpScreenCorrectionFactor.w );\n"
		"	\n"
		"	int2 ssP = int2( gl_FragCoord.xy );\n"
		"	\n"
		"	// World space point being shaded\n"
		"	vec3 C = getPosition( ssP, CS_Z_buffer );\n"
		"	\n"
		"	//float z = length( C - rpGlobalEyePos.xyz );\n"
		"	//bilateralKey = CSZToKey( C.z );\n"
		"	//packKey( CSZToKey( C.z ), bilateralKey );\n"
		"	\n"
		"	//float key = CSZToKey( C.z );\n"
		"	\n"
		"#if 0\n"
		"	if( key >= 1.0 )\n"
		"	{\n"
		"		visibility = 0.0;\n"
		"		return;\n"
		"	}\n"
		"#endif\n"
		"	\n"
		"	visibility = 0.0;\n"
		"	\n"
		"#if 1\n"
		"	float3 n_C = sampleNormal( samp0, ssP, 0 );\n"
		"	\n"
		"	if( length( n_C ) < 0.01 )\n"
		"	{\n"
		"		visibility = 1.0;\n"
		"		return;\n"
		"	}\n"
		"	\n"
		"	n_C = normalize( n_C );\n"
		"	//n_C = -n_C;\n"
		"	\n"
		"#else\n"
		"	// Reconstruct normals from positions.\n"
		"	float3 n_C = reconstructNonUnitCSFaceNormal( C );\n"
		"	// Since n_C is computed from the cross product of cmaera-space edge vectors from points at adjacent pixels, its magnitude will be proportional to the square of distance from the camera\n"
		"	if( dot( n_C, n_C ) > ( square( C.z * C.z * 0.00006 ) ) ) // if the threshold # is too big you will see black dots where we used a bad normal at edges, too small -> white\n"
		"	{\n"
		"		// The normals from depth should be very small values before normalization,\n"
		"		// except at depth discontinuities, where they will be large and lead\n"
		"		// to 1-pixel false occlusions because they are not reliable\n"
		"		visibility = 1.0;\n"
		"		//result.color = float4( visibility, visibility, visibility, 1.0 );\n"
		"		return;\n"
		"	}\n"
		"	else\n"
		"	{\n"
		"		n_C = normalize( -n_C );\n"
		"	}\n"
		"#endif\n"
		"	\n"
		"	// Hash function used in the HPG12 AlchemyAO paper\n"
		"	float randomPatternRotationAngle = ( ( ( 3 * ssP.x ) ^ ( ssP.y + ssP.x * ssP.y ) )\n"
		"#if TEMPORALLY_VARY_TAPS\n"
		"										 + rpJitterTexOffset.x\n"
		"#endif\n"
		"									   ) * 10;\n"
		"									   \n"
		"	// Choose the screen-space sample radius\n"
		"	// proportional to the projected area of the sphere\n"
		"	float ssDiskRadius = -projScale * radius / C.z;\n"
		"	\n"
		"#if 1\n"
		"	if( ssDiskRadius <= MIN_RADIUS )\n"
		"	{\n"
		"		// There is no way to compute AO at this radius\n"
		"		visibility = 1.0;\n"
		"		return;\n"
		"	}\n"
		"#endif\n"
		"	\n"
		"#if USE_DEPTH_PEEL == 1\n"
		"#if DIFFERENT_DEPTH_RESOLUTIONS == 1\n"
		"	float unpeeledToPeeledScale = 1.0 / peeledToUnpeeledScale;\n"
		"#endif\n"
		"#endif\n"
		"	\n"
		"	float sum = 0.0;\n"
		"	for( int i = 0; i < NUM_SAMPLES; ++i )\n"
		"	{\n"
		"		sum += sampleAO( ssP, C, n_C, ssDiskRadius, i, randomPatternRotationAngle, CS_Z_buffer, 1 );\n"
		"	}\n"
		"	\n"
		"#if HIGH_QUALITY\n"
		"	float A = pow( max( 0.0, 1.0 - sqrt( sum * ( 3.0 / NUM_SAMPLES ) ) ), intensity );\n"
		"#else\n"
		"	float A = max( 0.0, 1.0 - sum * intensityDivR6 * ( 5.0 / NUM_SAMPLES ) );\n"
		"	// Anti-tone map to reduce contrast and drag dark region farther\n"
		"	// (x^0.2 + 1.2 * x^4)/2.2\n"
		"	//A = ( pow( A, 0.2 ) + 1.2 * A * A * A * A ) / 2.2;\n"
		"#endif\n"
		"	\n"
		"	// Visualize random spin distribution\n"
		"	//A = mod(randomPatternRotationAngle / (2 * 3.141592653589), 1.0);\n"
		"	\n"
		"	// Fade in as the radius reaches 2 pixels\n"
		"	visibility = lerp( 1.0, A, saturate( ssDiskRadius - MIN_RADIUS ) );\n"
		"	//visibility = A;\n"
		"	\n"
		"#if defined(BRIGHTPASS)\n"
		"	//result.color = float4( visibility, bilateralKey, 0.0, 1.0 );\n"
		"	//result.color = float4( bilateralKey, bilateralKey, bilateralKey, 1.0 );\n"
		"	result.color = float4( visibility, visibility, visibility, 1.0 );\n"
		"	//result.color = float4( n_C * 0.5 + 0.5, 1.0 );\n"
		"	//result.color = float4( n_C, 1.0 );\n"
		"	//result.color = texture( samp0, fragment.texcoord0 ).rgba;\n"
		"#endif\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/AmbientOcclusion_AO.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN \n"
		"{\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"};\n"
		"\n"
		"struct VS_OUT\n"
		"{\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord0 : TEXCOORD0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result )\n"
		"{\n"
		"	result.position = vertex.position;\n"
		"	result.texcoord0 = vertex.texcoord;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/AmbientOcclusion_blur.pixel",
		"/**\n"
		"  \file AmbientOcclusion_blur.pix\n"
		"  \author Morgan McGuire and Michael Mara, NVIDIA Research\n"
		"\n"
		"  \brief 7-tap 1D cross-bilateral blur using a packed depth key\n"
		"\n"
		"  Open Source under the \"BSD\" license: http://www.opensource.org/licenses/bsd-license.php\n"
		"\n"
		"  Copyright (c) 2011-2014, NVIDIA\n"
		"  Copyright (c) 2016 Robert Beckebans ( id Tech 4.x integration )\n"
		"  All rights reserved.\n"
		"\n"
		"  Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:\n"
		"\n"
		"  Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.\n"
		"  Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.\n"
		"  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n"
		"*/\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"// *INDENT-OFF*\n"
		"uniform sampler2D samp0 : register( s0 ); // view normals\n"
		"uniform sampler2D samp1 : register( s1 ); // view depth\n"
		"uniform sampler2D samp2 : register( s2 ); // view AO\n"
		" \n"
		"#define normal_buffer	samp0\n"
		"#define cszBuffer		samp1\n"
		"#define source			samp2 \n"
		" \n"
		"struct PS_IN\n"
		"{\n"
		"	float2 texcoord0 : TEXCOORD0_centroid;\n"
		"};\n"
		" \n"
		"struct PS_OUT \n"
		"{\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"// *INDENT-ON*\n"
		"\n"
		"#define PEELED_LAYER 0\n"
		"#define USE_OCT16 0\n"
		"#define USE_NORMALS 1\n"
		"\n"
		"//#expect PEELED_LAYER \"binary\"\n"
		"\n"
		"//////////////////////////////////////////////////////////////////////////////////////////////\n"
		"// Tunable Parameters:\n"
		"\n"
		"//#define NUM_KEY_COMPONENTS 1\n"
		"\n"
		"// The other parameters in this section must be passed in as macro values\n"
		"\n"
		"/** Increase to make depth edges crisper. Decrease to reduce flicker. */\n"
		"#define EDGE_SHARPNESS     (1.0)\n"
		"\n"
		"/** Step in 2-pixel intervals since we already blurred against neighbors in the\n"
		"    first AO pass.  This constant can be increased while R decreases to improve\n"
		"    performance at the expense of some dithering artifacts.\n"
		"\n"
		"    Morgan found that a scale of 3 left a 1-pixel checkerboard grid that was\n"
		"    unobjectionable after shading was applied but eliminated most temporal incoherence\n"
		"    from using small numbers of sample taps.\n"
		"    */\n"
		"#define SCALE               (2)\n"
		"\n"
		"/** Filter radius in pixels. This will be multiplied by SCALE. */\n"
		"#define R                   (4)\n"
		"\n"
		"#define MDB_WEIGHTS 	0\n"
		"//////////////////////////////////////////////////////////////////////////////////////////////\n"
		"\n"
		"/** Type of data to read from source.  This macro allows\n"
		"    the same blur shader to be used on different kinds of input data. */\n"
		"#define VALUE_TYPE        float\n"
		"\n"
		"/** Swizzle to use to extract the channels of source. This macro allows\n"
		"    the same blur shader to be used on different kinds of input data. */\n"
		"#define VALUE_COMPONENTS   r\n"
		"\n"
		"#define VALUE_IS_KEY       0\n"
		"\n"
		"\n"
		"\n"
		"\n"
		"/** (1, 0) or (0, 1)*/\n"
		"//uniform int2       axis;\n"
		"\n"
		"#if USE_OCT16\n"
		"#include <oct.glsl>\n"
		"#endif\n"
		"\n"
		"float3 sampleNormal( sampler2D normalBuffer, int2 ssC, int mipLevel )\n"
		"{\n"
		"#if USE_OCT16\n"
		"	return decode16( texelFetch( normalBuffer, ssC, mipLevel ).xy * 2.0 - 1.0 );\n"
		"#else\n"
		"	return normalize( texelFetch( normalBuffer, ssC, mipLevel ).xyz * 2.0 - 1.0 );\n"
		"#endif\n"
		"}\n"
		"\n"
		"#define  aoResult       result.color.VALUE_COMPONENTS\n"
		"#define  keyPassThrough result.color.KEY_COMPONENTS\n"
		"\n"
		"\n"
		"\n"
		"\n"
		"/** Used for preventing AO computation on the sky (at infinite depth) and defining the CS Z to bilateral depth key scaling.\n"
		"    This need not match the real far plane but should not be much more than it.*/\n"
		"const float FAR_PLANE_Z = -16000.0;\n"
		"\n"
		"float CSZToKey( float z )\n"
		"{\n"
		"	return clamp( z * ( 1.0 / FAR_PLANE_Z ), 0.0, 1.0 );\n"
		"}\n"
		"\n"
		"float reconstructCSZ( float d )\n"
		"{\n"
		"	//return clipInfo[0] / (clipInfo[1] * d + clipInfo[2]);\n"
		"	\n"
		"	// infinite far perspective matrix\n"
		"	return -3.0 / ( -1.0 * d + 1.0 );\n"
		"	\n"
		"	//d = d * 2.0 - 1.0;\n"
		"	//return -rpProjectionMatrixZ.w / ( -rpProjectionMatrixZ.z - d );\n"
		"}\n"
		"\n"
		"float3 reconstructCSPosition( float2 S, float z )\n"
		"{\n"
		"	float4 P;\n"
		"	P.z = z * 2.0 - 1.0;\n"
		"	P.xy = ( S * rpScreenCorrectionFactor.xy ) * 2.0 - 1.0;\n"
		"	P.w = 1.0;\n"
		"	\n"
		"	float4 csP;\n"
		"	csP.x = dot4( P, rpModelMatrixX );\n"
		"	csP.y = dot4( P, rpModelMatrixY );\n"
		"	csP.z = dot4( P, rpModelMatrixZ );\n"
		"	csP.w = dot4( P, rpModelMatrixW );\n"
		"	\n"
		"	csP.xyz /= csP.w;\n"
		"	\n"
		"	return csP.xyz;\n"
		"}\n"
		"\n"
		"float getKey( int2 ssP )\n"
		"{\n"
		"#if PEELED_LAYER\n"
		"	float key = texelFetch( cszBuffer, ssP, 0 ).g;\n"
		"#else\n"
		"	float key = texelFetch( cszBuffer, ssP, 0 ).r;\n"
		"#endif\n"
		"	\n"
		"#if 0\n"
		"	key = reconstructCSZ( key );\n"
		"#else\n"
		"	float3 P = reconstructCSPosition( float2( ssP ) + float2( 0.5 ), key );\n"
		"	key = P.z;\n"
		"#endif\n"
		"	\n"
		"	key = clamp( key * ( 1.0 / FAR_PLANE_Z ), 0.0, 1.0 );\n"
		"	return key;\n"
		"}\n"
		"\n"
		"float3 positionFromKey( float key, int2 ssC )\n"
		"{\n"
		"	float z = key * FAR_PLANE_Z;\n"
		"	float3 C = reconstructCSPosition( float2( ssC ) + float2( 0.5 ), z );\n"
		"	return C;\n"
		"}\n"
		"\n"
		"/** Read the camera-space position of the point at screen-space pixel ssP */\n"
		"float3 getPosition( int2 ssP, sampler2D cszBuffer )\n"
		"{\n"
		"	float3 P;\n"
		"	P.z = texelFetch( cszBuffer, ssP, 0 ).r;\n"
		"	\n"
		"	// Offset to pixel center\n"
		"	P = reconstructCSPosition( float2( ssP ) + float2( 0.5 ), P.z );\n"
		"	\n"
		"	return P;\n"
		"}\n"
		"\n"
		"float calculateBilateralWeight( float key, float tapKey, int2 tapLoc, float3 n_C, float3 C )\n"
		"{\n"
		"	// range domain (the \"bilateral\" weight). As depth difference increases, decrease weight.\n"
		"	float depthWeight = max( 0.0, 1.0 - ( EDGE_SHARPNESS * 2000.0 ) * abs( tapKey - key ) );\n"
		"	\n"
		"	float k_normal = 1.0;\n"
		"	float k_plane = 1.0;\n"
		"	\n"
		"	// Prevents blending over creases.\n"
		"	float normalWeight = 1.0;\n"
		"	float planeWeight = 1.0;\n"
		"	\n"
		"#if USE_NORMALS\n"
		"	float3 tapN_C = sampleNormal( normal_buffer, tapLoc, 0 );\n"
		"	depthWeight = 1.0;\n"
		"	\n"
		"	float normalError = 1.0 - dot( tapN_C, n_C ) * k_normal;\n"
		"	normalWeight = max( ( 1.0 - EDGE_SHARPNESS * normalError ), 0.00 );\n"
		"	\n"
		"	float lowDistanceThreshold2 = 0.001;\n"
		"	\n"
		"	//float3 tapC = positionFromKey( tapKey, tapLoc, projInfo );\n"
		"	float3 tapC = getPosition( tapLoc, cszBuffer );\n"
		"	\n"
		"	// Change in position in camera space\n"
		"	float3 dq = C - tapC;\n"
		"	\n"
		"	// How far away is this point from the original sample\n"
		"	// in camera space? (Max value is unbounded)\n"
		"	float distance2 = dot( dq, dq );\n"
		"	\n"
		"	// How far off the expected plane (on the perpendicular) is this point?  Max value is unbounded.\n"
		"	float planeError = max( abs( dot( dq, tapN_C ) ), abs( dot( dq, n_C ) ) );\n"
		"	\n"
		"	planeWeight = ( distance2 < lowDistanceThreshold2 ) ? 1.0 :\n"
		"				  pow( max( 0.0, 1.0 - EDGE_SHARPNESS * 2.0 * k_plane * planeError / sqrt( distance2 ) ), 2.0 );\n"
		"				  \n"
		"				  \n"
		"#endif\n"
		"				  \n"
		"	return depthWeight * normalWeight * planeWeight;\n"
		"}\n"
		"\n"
		"\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result )\n"
		"{\n"
		"\n"
		"//#   if __VERSION__ < 330\n"
		"	float kernel[R + 1];\n"
		"//      if R == 0, we never call this shader\n"
		"#if R == 1\n"
		"	kernel[0] = 0.5;\n"
		"	kernel[1] = 0.25;\n"
		"#elif R == 2\n"
		"	kernel[0] = 0.153170;\n"
		"	kernel[1] = 0.144893;\n"
		"	kernel[2] = 0.122649;\n"
		"#elif R == 3\n"
		"	kernel[0] = 0.153170;\n"
		"	kernel[1] = 0.144893;\n"
		"	kernel[2] = 0.122649;\n"
		"	kernel[3] = 0.092902;\n"
		"#elif R == 4\n"
		"	kernel[0] = 0.153170;\n"
		"	kernel[1] = 0.144893;\n"
		"	kernel[2] = 0.122649;\n"
		"	kernel[3] = 0.092902;\n"
		"	kernel[4] = 0.062970;\n"
		"#elif R == 5\n"
		"	kernel[0] = 0.111220;\n"
		"	kernel[1] = 0.107798;\n"
		"	kernel[2] = 0.098151;\n"
		"	kernel[3] = 0.083953;\n"
		"	kernel[4] = 0.067458;\n"
		"	kernel[5] = 0.050920;\n"
		"#elif R == 6\n"
		"	kernel[0] = 0.111220;\n"
		"	kernel[1] = 0.107798;\n"
		"	kernel[2] = 0.098151;\n"
		"	kernel[3] = 0.083953;\n"
		"	kernel[4] = 0.067458;\n"
		"	kernel[5] = 0.050920;\n"
		"	kernel[6] = 0.036108;\n"
		"#endif\n"
		"//#endif\n"
		"\n"
		"	int2 ssC = int2( gl_FragCoord.xy );\n"
		"	\n"
		"	float4 temp = texelFetch( source, ssC, 0 );\n"
		"	\n"
		"#if 0\n"
		"	if( fragment.texcoord0.x < 0.75 )\n"
		"	{\n"
		"		result.color = temp;\n"
		"		return;\n"
		"	}\n"
		"#endif\n"
		"	\n"
		"#if 0\n"
		"	float key = getKey( ssC );\n"
		"	float3 C = positionFromKey( key, ssC );\n"
		"#else\n"
		"	float3 C = getPosition( ssC, cszBuffer );\n"
		"	float key = CSZToKey( C.z );\n"
		"#endif\n"
		"	\n"
		"	VALUE_TYPE sum = temp.VALUE_COMPONENTS;\n"
		"	\n"
		"	if( key == 1.0 )\n"
		"	{\n"
		"		// Sky pixel (if you aren't using depth keying, disable this test)\n"
		"		aoResult = sum;\n"
		"#if defined(BRIGHTPASS)\n"
		"		result.color = float4( aoResult, aoResult, aoResult, 1.0 );\n"
		"#endif\n"
		"		return;\n"
		"	}\n"
		"	\n"
		"	// Base weight for falloff.  Increase this for more blurriness,\n"
		"	// decrease it for better edge discrimination\n"
		"	float BASE = kernel[0];\n"
		"	float totalWeight = BASE;\n"
		"	sum *= totalWeight;\n"
		"	\n"
		"	float3 n_C;\n"
		"#if USE_NORMALS\n"
		"	n_C = sampleNormal( normal_buffer, ssC, 0 );\n"
		"#endif\n"
		"	\n"
		"#if MDB_WEIGHTS == 0\n"
		"	for( int r = -R; r <= R; ++r )\n"
		"	{\n"
		"		// We already handled the zero case above.  This loop should be unrolled and the static branch optimized out,\n"
		"		// so the IF statement has no runtime cost\n"
		"		if( r != 0 )\n"
		"		{\n"
		"			int2 tapLoc = ssC + int2( rpJitterTexScale.xy ) * ( r * SCALE );\n"
		"			temp = texelFetch( source, tapLoc, 0 );\n"
		"			\n"
		"			\n"
		"			float tapKey = getKey( tapLoc );\n"
		"			VALUE_TYPE value  = temp.VALUE_COMPONENTS;\n"
		"			\n"
		"			// spatial domain: offset kernel tap\n"
		"			float weight = 0.3 + kernel[abs( r )];\n"
		"			\n"
		"			float bilateralWeight = calculateBilateralWeight( key, tapKey, tapLoc, n_C, C );\n"
		"			\n"
		"			weight *= bilateralWeight;\n"
		"			sum += value * weight;\n"
		"			totalWeight += weight;\n"
		"		}\n"
		"	}\n"
		"#else\n"
		"	\n"
		"	float lastBilateralWeight = 9999.0;\n"
		"	for( int r = -1; r >= -R; --r )\n"
		"	{\n"
		"		int2 tapLoc = ssC + int2( rpJitterTexScale.xy ) * ( r * SCALE );\n"
		"		temp = texelFetch( source, tapLoc, 0 );\n"
		"		float      tapKey = getKey( tapLoc );\n"
		"	\n"
		"		VALUE_TYPE value  = temp.VALUE_COMPONENTS;\n"
		"	\n"
		"		// spatial domain: offset kernel tap\n"
		"		float weight = 0.3 + kernel[abs( r )];\n"
		"	\n"
		"		// range domain (the \"bilateral\" weight). As depth difference increases, decrease weight.\n"
		"		float bilateralWeight = calculateBilateralWeight( key, tapKey, tapLoc, n_C, C );\n"
		"		bilateralWeight = min( lastBilateralWeight, bilateralWeight );\n"
		"		lastBilateralWeight = bilateralWeight;\n"
		"		weight *= bilateralWeight;\n"
		"		sum += value * weight;\n"
		"		totalWeight += weight;\n"
		"	}\n"
		"	\n"
		"	lastBilateralWeight = 9999.0;\n"
		"	for( int r = 1; r <= R; ++r )\n"
		"	{\n"
		"		int2 tapLoc = ssC + int2( rpJitterTexScale.xy ) * ( r * SCALE );\n"
		"		temp = texelFetch( source, tapLoc, 0 );\n"
		"		float      tapKey = getKey( tapLoc );\n"
		"		VALUE_TYPE value  = temp.VALUE_COMPONENTS;\n"
		"	\n"
		"		// spatial domain: offset kernel tap\n"
		"		float weight = 0.3 + kernel[abs( r )];\n"
		"	\n"
		"		// range domain (the \"bilateral\" weight). As depth difference increases, decrease weight.\n"
		"		float bilateralWeight = calculateBilateralWeight( key, tapKey, tapLoc, n_C, C );\n"
		"		bilateralWeight = min( lastBilateralWeight, bilateralWeight );\n"
		"		lastBilateralWeight = bilateralWeight;\n"
		"		weight *= bilateralWeight;\n"
		"		sum += value * weight;\n"
		"		totalWeight += weight;\n"
		"	}\n"
		"#endif\n"
		"	\n"
		"	const float epsilon = 0.0001;\n"
		"	aoResult = sum / ( totalWeight + epsilon );\n"
		"	\n"
		"#if defined(BRIGHTPASS)\n"
		"	result.color = float4( aoResult, aoResult, aoResult, 1.0 );\n"
		"#endif\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/AmbientOcclusion_blur.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN \n"
		"{\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"};\n"
		"\n"
		"struct VS_OUT\n"
		"{\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord0 : TEXCOORD0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result )\n"
		"{\n"
		"	result.position = vertex.position;\n"
		"	result.texcoord0 = vertex.texcoord;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/AmbientOcclusion_minify.pixel",
		"/**\n"
		" \file AmbientOcclusion_minify.pix\n"
		" \author Morgan McGuire and Michael Mara, NVIDIA Research\n"
		"\n"
		"  Open Source under the \"BSD\" license: http://www.opensource.org/licenses/bsd-license.php\n"
		"\n"
		"  Copyright (c) 2011-2012, NVIDIA\n"
		"  Copyright (c) 2016 Robert Beckebans ( id Tech 4.x integration )\n"
		"  All rights reserved.\n"
		"\n"
		"  Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:\n"
		"\n"
		"  Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.\n"
		"  Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.\n"
		"  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n"
		"\n"
		" */\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"// *INDENT-OFF*\n"
		"uniform sampler2D samp0 : register( s0 ); // zbuffer\n"
		" \n"
		"struct PS_IN\n"
		"{\n"
		"	float2 texcoord0 : TEXCOORD0_centroid;\n"
		"};\n"
		" \n"
		"struct PS_OUT \n"
		"{\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"// *INDENT-ON*\n"
		"\n"
		"//#extension GL_EXT_gpu_shader4 : enable\n"
		"\n"
		"//#expect USE_PEELED_DEPTH_BUFFER \"binary\"\n"
		"\n"
		"#if 0 //( USE_PEELED_DEPTH_BUFFER != 0 )\n"
		"#define mask rg\n"
		"#else\n"
		"#define mask r\n"
		"#endif\n"
		"\n"
		"float reconstructCSZ( float d )\n"
		"{\n"
		"	//return clipInfo[0] / (clipInfo[1] * d + clipInfo[2]);\n"
		"	\n"
		"	// infinite far perspective matrix\n"
		"	return -3.0 / ( -1.0 * d + 1.0 );\n"
		"	\n"
		"	//d = d * 2.0 - 1.0;\n"
		"	//return -rpProjectionMatrixZ.w / ( -rpProjectionMatrixZ.z - d );\n"
		"}\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result )\n"
		"{\n"
		"#if defined(BRIGHTPASS)\n"
		"	float2 ssC = fragment.texcoord0;\n"
		"	float depth = tex2D( samp0, ssC ).r;\n"
		"	//depth = reconstructCSZ( depth );\n"
		"	result.color.mask = depth;\n"
		"#else\n"
		"	//int2 ssP = int2( gl_FragCoord.xy );\n"
		"	int2 ssP = int2( fragment.texcoord0 * rpScreenCorrectionFactor.zw );\n"
		"	\n"
		"	int previousMIPNumber = int( rpJitterTexScale.x );\n"
		"	\n"
		"	// Rotated grid subsampling to avoid XY directional bias or Z precision bias while downsampling.\n"
		"	// On DX9, the bit-and can be implemented with floating-point modulo\n"
		"	//result.color.mask = texture( samp0, clamp( ssP * 2 + int2( ssP.y & 1, ssP.x & 1 ), int2( 0 ), textureSize( samp0, previousMIPNumber ) - int2( 1 ) ) * rpScreenCorrectionFactor.xy, previousMIPNumber ).mask;\n"
		"	result.color.mask = texelFetch( samp0, clamp( ssP * 2 + int2( ssP.y & 1, ssP.x & 1 ), int2( 0 ), textureSize( samp0, previousMIPNumber ) - int2( 1 ) ), previousMIPNumber ).mask;\n"
		"	//result.color.mask = texelFetch2D( samp0, int3( ssP * 2 + int2( ( ssP.y & 1 ) ^ 1, ( ssP.x & 1 ) ^ 1 ), 0 ) );\n"
		"	\n"
		"	// result.color.mask = texelFetch( samp0, ssP, 0 ).r;\n"
		"	\n"
		"	//float2 ssC = float2( ssP * 2 + int2( ( ssP.y & 1 ) ^ 1, ( ssP.x & 1 ) ^ 1 ) ) * rpScreenCorrectionFactor.xy;\n"
		"	//float2 ssC = float2( ssP ) * rpScreenCorrectionFactor.xy;\n"
		"	//float2 ssC = fragment.texcoord0;\n"
		"	//float depth = tex2D( samp0, ssC ).r;\n"
		"	//result.color.mask = depth;\n"
		"#endif\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/AmbientOcclusion_minify.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN \n"
		"{\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"};\n"
		"\n"
		"struct VS_OUT\n"
		"{\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord0 : TEXCOORD0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result )\n"
		"{\n"
		"	result.position = vertex.position;\n"
		"	result.texcoord0 = vertex.texcoord;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/bink.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0); // Y\n"
		"uniform sampler2D samp1 : register(s1); // Cr\n"
		"uniform sampler2D samp2 : register(s2); // Cb\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position : VPOS;\n"
		"	float2 texcoord0 : TEXCOORD0_centroid;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"	const float3 crc = float3( 1.595794678, -0.813476563, 0 );\n"
		"	const float3 crb = float3( 0, -0.391448975, 2.017822266 );\n"
		"	const float3 adj = float3( -0.87065506, 0.529705048f, -1.081668854f );\n"
		"	const float3 YScalar = float3( 1.164123535f, 1.164123535f, 1.164123535f );\n"
		"\n"
		"	float Y = tex2D( samp0, fragment.texcoord0.xy ).x;\n"
		"	float Cr = tex2D( samp1, fragment.texcoord0.xy ).x;\n"
		"	float Cb = tex2D( samp2, fragment.texcoord0.xy ).x;\n"
		"\n"
		"	float3 p = ( YScalar * Y );\n"
		"	p += ( crc * Cr ) + ( crb * Cb ) + adj;\n"
		"\n"
		"	result.color.xyz = p;\n"
		"	result.color.w = 1.0;\n"
		"	result.color *= rpColor;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/bink.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord0 : TEXCOORD0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"\n"
		"	result.texcoord0 = vertex.texcoord;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/bink_gui.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0); // Y\n"
		"uniform sampler2D samp1 : register(s1); // Cr\n"
		"uniform sampler2D samp2 : register(s2); // Cb\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position : VPOS;\n"
		"	float2 texcoord0 : TEXCOORD0_centroid;\n"
		"	float4 texcoord1 : TEXCOORD1_centroid;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"	const float3 crc = float3( 1.595794678, -0.813476563, 0 );\n"
		"	const float3 crb = float3( 0, -0.391448975, 2.017822266 );\n"
		"	const float3 adj = float3( -0.87065506, 0.529705048f, -1.081668854f );\n"
		"	const float3 YScalar = float3( 1.164123535f, 1.164123535f, 1.164123535f );\n"
		"\n"
		"	float Y = tex2D( samp0, fragment.texcoord0.xy ).x;\n"
		"	float Cr = tex2D( samp1, fragment.texcoord0.xy ).x;\n"
		"	float Cb = tex2D( samp2, fragment.texcoord0.xy ).x;\n"
		"\n"
		"	float3 p = ( YScalar * Y );\n"
		"	p += ( crc * Cr ) + ( crb * Cb ) + adj;\n"
		"\n"
		"	float4 binkImage;\n"
		"	binkImage.xyz = p;\n"
		"	binkImage.w = 1.0;\n"
		"\n"
		"	float4 color = ( binkImage * fragment.color ) + fragment.texcoord1;\n"
		"	result.color.xyz = color.xyz * color.w;\n"
		"	result.color.w = color.w;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/bink_gui.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2013 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"	float4 color2 : COLOR1;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord0 : TEXCOORD0;\n"
		"	float4 texcoord1 : TEXCOORD1;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"\n"
		"	result.texcoord0.xy = vertex.texcoord.xy;\n"
		"	result.texcoord1 = ( ( vertex.color2 ) * 2.0 ) - 1.0;\n"
		"	result.color =  swizzleColor( vertex.color );\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/blendLight.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0);\n"
		"uniform sampler2D samp1 : register(s1);\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position : VPOS;\n"
		"	float4 texcoord0 : TEXCOORD0_centroid;\n"
		"	float2 texcoord1 : TEXCOORD1_centroid;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"	result.color = idtex2Dproj( samp0, fragment.texcoord0 ) * tex2D( samp1, fragment.texcoord1 ) * rpColor;\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/blendLight.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 binormal : BINORMAL;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"	float4 texcoord0 : TEXCOORD0;\n"
		"	float2 texcoord1 : TEXCOORD1;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"\n"
		"	result.texcoord0.x = dot4( vertex.position, rpTexGen0S );\n"
		"	result.texcoord0.y = dot4( vertex.position, rpTexGen0T );\n"
		"	result.texcoord0.z = 0.0;\n"
		"	result.texcoord0.w = dot4( vertex.position, rpTexGen0Q );\n"
		"\n"
		"	result.texcoord1.x = dot4( vertex.position, rpTexGen1S );\n"
		"	result.texcoord1.y = 0.5;\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/bloodorb1_capture.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0); //_accum\n"
		"uniform sampler2D samp1 : register(s1); //_currentRender\n"
		"uniform sampler2D samp2 : register(s2); //mask\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position : VPOS;\n"
		"	float2 texcoord0 : TEXCOORD0_centroid;\n"
		"	float2 texcoord1 : TEXCOORD1_centroid;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"\n"
		"	float4 accumSample = tex2D( samp0, fragment.texcoord0 );\n"
		"	float4 maskSample = tex2D( samp2, fragment.texcoord1 );\n"
		"	float4 currentRenderSample = tex2D( samp1, fragment.texcoord1 );\n"
		"\n"
		"	result.color = lerp( accumSample, currentRenderSample, maskSample.a );\n"
		"}\n"
		
	},
	
	{
		"renderprogs/bloodorb1_capture.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"global.inc\"\n"
		"\n"
		"uniform float4 rpUser0 : register( c128 ); //rpCenterScale\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord0 : TEXCOORD0;\n"
		"	float2 texcoord1 : TEXCOORD1;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"\n"
		"	//center scale\n"
		"	const float4 centerScale = rpUser0;\n"
		"	result.texcoord0 = CenterScale( vertex.texcoord, centerScale.xy );\n"
		"\n"
		"	// pass through texcoords	\n"
		"	result.texcoord1 = vertex.texcoord;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/bloodorb2_capture.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0); //_accum\n"
		"uniform sampler2D samp1 : register(s1); //_currentRender\n"
		"uniform sampler2D samp2 : register(s2); //mask\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position : VPOS;\n"
		"	float2 texcoord0 : TEXCOORD0_centroid;\n"
		"	float2 texcoord1 : TEXCOORD1_centroid;\n"
		"	float2 texcoord2 : TEXCOORD2_centroid;\n"
		"	//float4 color	 : COLOR0;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"\n"
		"	float4 redTint = float4( 1, 0.98, 0.98, 1 );\n"
		"	float4 accumSample = tex2D( samp0, fragment.texcoord0 ) * redTint;\n"
		"\n"
		"	float4 maskSample = tex2D( samp2, fragment.texcoord1 );\n"
		"\n"
		"	float4 tint = float4( 1.0, 0.8, 0.8, 1 );\n"
		"	float4 currentRenderSample = tex2D( samp1, fragment.texcoord2 ) * tint;\n"
		"\n"
		"	result.color = lerp( accumSample, currentRenderSample, maskSample.a );\n"
		"}\n"
		
	},
	
	{
		"renderprogs/bloodorb2_capture.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"global.inc\"\n"
		"\n"
		"uniform float4 rpUser0 : register( c128 ); //rpCenterScaleTex0\n"
		"uniform float4 rpUser1 : register( c129 ); //rpRotateTex0\n"
		"uniform float4 rpUser2 : register( c130 ); //rpCenterScaleTex1\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord0 : TEXCOORD0;\n"
		"	float2 texcoord1 : TEXCOORD1;\n"
		"	float2 texcoord2 : TEXCOORD2;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"\n"
		"	const float4 centerScaleTex0 = rpUser0;\n"
		"	const float4 rotateTex0 = rpUser1;\n"
		"	const float4 centerScaleTex1 = rpUser2;\n"
		"\n"
		"	//center scale and rotate for _accum\n"
		"	float2 tc0 = CenterScale( vertex.texcoord, centerScaleTex0.xy );\n"
		"	result.texcoord0 = Rotate2D( tc0, rotateTex0.xy );\n"
		"\n"
		"	//center scale for mask\n"
		"	result.texcoord1 = CenterScale( vertex.texcoord, centerScaleTex1.xy );\n"
		"\n"
		"	// pass through for currentrender\n"
		"	result.texcoord2 = vertex.texcoord;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/bloodorb3_capture.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0); //_accum\n"
		"uniform sampler2D samp1 : register(s1); //_currentRender\n"
		"uniform sampler2D samp2 : register(s2); //mask\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position : VPOS;\n"
		"	float2 texcoord0 : TEXCOORD0_centroid;\n"
		"	float2 texcoord1 : TEXCOORD1_centroid;\n"
		"	float2 texcoord2 : TEXCOORD2_centroid;\n"
		"	float2 texcoord3 : TEXCOORD3_centroid;\n"
		"	float2 texcoord4 : TEXCOORD4;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"	float colorFactor = fragment.texcoord4.x;\n"
		"\n"
		"	float4 color0 = float4( 1.0f - colorFactor,	1.0f - colorFactor,		1.0f,	1.0f );\n"
		"	float4 color1 = float4( 1.0f,	0.95f - colorFactor,		0.95f,	0.5f );\n"
		"	float4 color2 = float4( 0.015f,	0.015f, 0.015f, 0.01f );\n"
		"\n"
		"	float4 accumSample0 = tex2D( samp0, fragment.texcoord0 ) * color0;\n"
		"	float4 accumSample1 = tex2D( samp0, fragment.texcoord1 ) * color1;\n"
		"	float4 accumSample2 = tex2D( samp0, fragment.texcoord2 ) * color2;\n"
		"	float4 maskSample = tex2D( samp2, fragment.texcoord3 );\n"
		"\n"
		"	float4 tint = float4( 0.8, 0.5, 0.5, 1 );\n"
		"	float4 currentRenderSample = tex2D( samp1, fragment.texcoord3 ) * tint;\n"
		"\n"
		"	// blend of the first 2 accumulation samples\n"
		"	float4 accumColor = lerp( accumSample0, accumSample1, 0.5f );\n"
		"	// add thrid sample\n"
		"	accumColor += accumSample2;\n"
		"\n"
		"	accumColor = lerp( accumColor, currentRenderSample, maskSample.a );\n"
		"	result.color = accumColor;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/bloodorb3_capture.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"global.inc\"\n"
		"\n"
		"uniform float4 rpUser0 : register( c128 ); //rpCenterScaleTex\n"
		"uniform float4 rpUser1 : register( c129 ); //rpRotateTex\n"
		"uniform float4 rpUser2 : register( c130 ); //rpColorFactor\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord0 : TEXCOORD0;\n"
		"	float2 texcoord1 : TEXCOORD1;\n"
		"	float2 texcoord2 : TEXCOORD2;\n"
		"	float2 texcoord3 : TEXCOORD3;\n"
		"	float2 texcoord4 : TEXCOORD4;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"\n"
		"	//_accum 1\n"
		"	const float4 centerScaleTex = rpUser0;\n"
		"	const float4 rotateTex = rpUser1;\n"
		"	float2 tc0 = CenterScale( vertex.texcoord, centerScaleTex.xy );\n"
		"	result.texcoord0 = Rotate2D( tc0, rotateTex.xy );\n"
		"\n"
		"	// accum 2\n"
		"	result.texcoord1 = Rotate2D( tc0, float2( rotateTex.z, -rotateTex.w ) );\n"
		"\n"
		"	// accum 3\n"
		"	result.texcoord2 = Rotate2D( tc0, rotateTex.zw );\n"
		"\n"
		"	// pass through for currentrender\n"
		"	result.texcoord3 = vertex.texcoord;\n"
		"\n"
		"	// pass through the color fator\n"
		"	const float4 colorFactor = rpUser2;\n"
		"	result.texcoord4 = colorFactor.xx;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/bloodorb_draw.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0); //_accum\n"
		"uniform sampler2D samp1 : register(s1); //_currentRender\n"
		"uniform sampler2D samp2 : register(s2); //mask\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position : VPOS;\n"
		"	float2 texcoord0 : TEXCOORD0_centroid;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"\n"
		"	float4 accumSample = tex2D( samp0, fragment.texcoord0 );\n"
		"	float4 currentRenderSample = tex2D( samp1, fragment.texcoord0 );\n"
		"	float4 maskSample = tex2D( samp2, fragment.texcoord0 );\n"
		"\n"
		"	result.color = lerp( accumSample, currentRenderSample, maskSample.a );\n"
		"}\n"
		
	},
	
	{
		"renderprogs/bloodorb_draw.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord0 : TEXCOORD0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"\n"
		"	// pass through texcoords\n"
		"	result.texcoord0 = vertex.texcoord;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/bumpyenvironment.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2013 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform samplerCUBE	samp0 : register(s0); // texture 0 is the cube map\n"
		"uniform sampler2D	samp1 : register(s1); // normal map\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position		: VPOS;\n"
		"	float2 texcoord0	: TEXCOORD0_centroid;\n"
		"	float3 texcoord1	: TEXCOORD1_centroid;\n"
		"	float3 texcoord2	: TEXCOORD2_centroid;\n"
		"	float3 texcoord3	: TEXCOORD3_centroid;\n"
		"	float3 texcoord4	: TEXCOORD4_centroid;\n"
		"	float4 color		: COLOR0;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"\n"
		"	float4 bump = tex2D( samp1, fragment.texcoord0 ) * 2.0f - 1.0f;\n"
		"	// RB begin\n"
		"	float3 localNormal;\n"
		"#if defined(USE_NORMAL_FMT_RGB8)\n"
		"	localNormal = float3( bump.rg, 0.0f );\n"
		"#else\n"
		"	localNormal = float3( bump.wy, 0.0f );\n"
		"#endif\n"
		"	// RB end\n"
		"	localNormal.z = sqrt( 1.0f - dot3( localNormal, localNormal ) );\n"
		"\n"
		"	float3 globalNormal;\n"
		"	globalNormal.x = dot3( localNormal, fragment.texcoord2 );\n"
		"	globalNormal.y = dot3( localNormal, fragment.texcoord3 );\n"
		"	globalNormal.z = dot3( localNormal, fragment.texcoord4 );\n"
		"\n"
		"	float3 globalEye = normalize( fragment.texcoord1 );\n"
		"\n"
		"	float3 reflectionVector = globalNormal * dot3( globalEye, globalNormal );\n"
		"	reflectionVector = ( reflectionVector * 2.0f ) - globalEye;\n"
		"\n"
		"	float4 envMap = texCUBE( samp0, reflectionVector );\n"
		"\n"
		"	result.color = float4( sRGBToLinearRGB( envMap.xyz ), 1.0f ) * fragment.color;\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/bumpyenvironment.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position		: POSITION;\n"
		"	float2 texcoord0	: TEXCOORD0;\n"
		"	float3 texcoord1	: TEXCOORD1;\n"
		"	float3 texcoord2	: TEXCOORD2;\n"
		"	float3 texcoord3	: TEXCOORD3;\n"
		"	float3 texcoord4	: TEXCOORD4;\n"
		"	float4 color		: COLOR0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"\n"
		"	float4 normal = vertex.normal * 2.0 - 1.0;\n"
		"	float4 tangent = vertex.tangent * 2.0 - 1.0;\n"
		"	float3 binormal = cross( normal.xyz, tangent.xyz ) * tangent.w;\n"
		"\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"\n"
		"	result.texcoord0 = vertex.texcoord.xy;\n"
		"\n"
		"	float4 toEye = rpLocalViewOrigin - vertex.position;\n"
		"	result.texcoord1.x = dot3( toEye, rpModelMatrixX );\n"
		"	result.texcoord1.y = dot3( toEye, rpModelMatrixY );\n"
		"	result.texcoord1.z = dot3( toEye, rpModelMatrixZ );\n"
		"\n"
		"	result.texcoord2.x = dot3( tangent, rpModelMatrixX );\n"
		"	result.texcoord3.x = dot3( tangent, rpModelMatrixY );\n"
		"	result.texcoord4.x = dot3( tangent, rpModelMatrixZ );\n"
		"\n"
		"	result.texcoord2.y = dot3( binormal, rpModelMatrixX );\n"
		"	result.texcoord3.y = dot3( binormal, rpModelMatrixY );\n"
		"	result.texcoord4.y = dot3( binormal, rpModelMatrixZ );\n"
		"\n"
		"	result.texcoord2.z = dot3( normal, rpModelMatrixX );\n"
		"	result.texcoord3.z = dot3( normal, rpModelMatrixY );\n"
		"	result.texcoord4.z = dot3( normal, rpModelMatrixZ );\n"
		"\n"
		"	result.color = rpColor;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/bumpyenvironment_skinned.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2013 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform samplerCUBE	samp0 : register(s0); // texture 0 is the cube map\n"
		"uniform sampler2D	samp1 : register(s1); // normal map\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position		: VPOS;\n"
		"	float2 texcoord0	: TEXCOORD0_centroid;\n"
		"	float3 texcoord1	: TEXCOORD1_centroid;\n"
		"	float3 texcoord2	: TEXCOORD2_centroid;\n"
		"	float3 texcoord3	: TEXCOORD3_centroid;\n"
		"	float3 texcoord4	: TEXCOORD4_centroid;\n"
		"	float4 color		: COLOR0;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"\n"
		"	float4 bump = tex2D( samp1, fragment.texcoord0 ) * 2.0f - 1.0f;\n"
		"	\n"
		"	// RB begin\n"
		"	float3 localNormal;\n"
		"#if defined(GLES2)\n"
		"	localNormal = float3( bump.rg, 0.0f );\n"
		"#else\n"
		"	localNormal = float3( bump.wy, 0.0f );\n"
		"#endif\n"
		"	// RB end\n"
		"	localNormal.z = sqrt( 1.0f - dot3( localNormal, localNormal ) );\n"
		"\n"
		"	float3 globalNormal;\n"
		"	globalNormal.x = dot3( localNormal, fragment.texcoord2 );\n"
		"	globalNormal.y = dot3( localNormal, fragment.texcoord3 );\n"
		"	globalNormal.z = dot3( localNormal, fragment.texcoord4 );\n"
		"\n"
		"	float3 globalEye = normalize( fragment.texcoord1 );\n"
		"\n"
		"	float3 reflectionVector = globalNormal * dot3( globalEye, globalNormal );\n"
		"	reflectionVector = ( reflectionVector * 2.0f ) - globalEye;\n"
		"\n"
		"	float4 envMap = texCUBE( samp0, reflectionVector );\n"
		"\n"
		"	result.color = float4( sRGBToLinearRGB( envMap.xyz ), 1.0f ) * fragment.color;\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/bumpyenvironment_skinned.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2014 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform matrices_ubo { float4 matrices[408]; };\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"	float4 color2 : COLOR1;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position		: POSITION;\n"
		"	float2 texcoord0	: TEXCOORD0;\n"
		"	float3 texcoord1	: TEXCOORD1;\n"
		"	float3 texcoord2	: TEXCOORD2;\n"
		"	float3 texcoord3	: TEXCOORD3;\n"
		"	float3 texcoord4	: TEXCOORD4;\n"
		"	float4 color		: COLOR0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	float4 vNormal = vertex.normal * 2.0 - 1.0;\n"
		"	float4 vTangent = vertex.tangent * 2.0 - 1.0;\n"
		"	float3 vBinormal = cross( vNormal.xyz, vTangent.xyz ) * vTangent.w;\n"
		"\n"
		"	//--------------------------------------------------------------\n"
		"	// GPU transformation of the normal / binormal / bitangent\n"
		"	//\n"
		"	// multiplying with 255.1 give us the same result and is faster than floor( w * 255 + 0.5 )\n"
		"	//--------------------------------------------------------------\n"
		"	const float w0 = vertex.color2.x;\n"
		"	const float w1 = vertex.color2.y;\n"
		"	const float w2 = vertex.color2.z;\n"
		"	const float w3 = vertex.color2.w;\n"
		"\n"
		"	float4 matX, matY, matZ;	// must be float4 for vec4\n"
		"	int joint = int(vertex.color.x * 255.1 * 3.0);\n"
		"	matX = matrices[int(joint+0)] * w0;\n"
		"	matY = matrices[int(joint+1)] * w0;\n"
		"	matZ = matrices[int(joint+2)] * w0;\n"
		"\n"
		"	joint = int(vertex.color.y * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w1;\n"
		"	matY += matrices[int(joint+1)] * w1;\n"
		"	matZ += matrices[int(joint+2)] * w1;\n"
		"\n"
		"	joint = int(vertex.color.z * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w2;\n"
		"	matY += matrices[int(joint+1)] * w2;\n"
		"	matZ += matrices[int(joint+2)] * w2;\n"
		"\n"
		"	joint = int(vertex.color.w * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w3;\n"
		"	matY += matrices[int(joint+1)] * w3;\n"
		"	matZ += matrices[int(joint+2)] * w3;\n"
		"\n"
		"	float3 normal;\n"
		"	normal.x = dot3( matX, vNormal );\n"
		"	normal.y = dot3( matY, vNormal );\n"
		"	normal.z = dot3( matZ, vNormal );\n"
		"	normal = normalize( normal );\n"
		"\n"
		"	float3 tangent;\n"
		"	tangent.x = dot3( matX, vTangent );\n"
		"	tangent.y = dot3( matY, vTangent );\n"
		"	tangent.z = dot3( matZ, vTangent );\n"
		"	tangent = normalize( tangent );\n"
		"\n"
		"	float3 binormal;\n"
		"	binormal.x = dot3( matX, vBinormal );\n"
		"	binormal.y = dot3( matY, vBinormal );\n"
		"	binormal.z = dot3( matZ, vBinormal );\n"
		"	binormal = normalize( binormal );\n"
		"\n"
		"	float4 modelPosition;\n"
		"	modelPosition.x = dot4( matX, vertex.position );\n"
		"	modelPosition.y = dot4( matY, vertex.position );\n"
		"	modelPosition.z = dot4( matZ, vertex.position );\n"
		"	modelPosition.w = 1.0;\n"
		"\n"
		"	result.position.x = dot4( modelPosition, rpMVPmatrixX );\n"
		"	result.position.y = dot4( modelPosition, rpMVPmatrixY );\n"
		"	result.position.z = dot4( modelPosition, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( modelPosition, rpMVPmatrixW );\n"
		"\n"
		"	result.texcoord0 = vertex.texcoord.xy;\n"
		"\n"
		"	float4 toEye = rpLocalViewOrigin - modelPosition;\n"
		"	result.texcoord1.x = dot3( toEye, rpModelMatrixX );\n"
		"	result.texcoord1.y = dot3( toEye, rpModelMatrixY );\n"
		"	result.texcoord1.z = dot3( toEye, rpModelMatrixZ );\n"
		"\n"
		"	result.texcoord2.x = dot3( tangent, rpModelMatrixX );\n"
		"	result.texcoord3.x = dot3( tangent, rpModelMatrixY );\n"
		"	result.texcoord4.x = dot3( tangent, rpModelMatrixZ );\n"
		"\n"
		"	result.texcoord2.y = dot3( binormal, rpModelMatrixX );\n"
		"	result.texcoord3.y = dot3( binormal, rpModelMatrixY );\n"
		"	result.texcoord4.y = dot3( binormal, rpModelMatrixZ );\n"
		"\n"
		"	result.texcoord2.z = dot3( normal, rpModelMatrixX );\n"
		"	result.texcoord3.z = dot3( normal, rpModelMatrixY );\n"
		"	result.texcoord4.z = dot3( normal, rpModelMatrixZ );\n"
		"\n"
		"	result.color = rpColor;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/color.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0);\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( out PS_OUT result ) {\n"
		"	result.color = rpColor;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/color.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2013-2014 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"#if defined(USE_GPU_SKINNING)\n"
		"uniform matrices_ubo { float4 matrices[408]; };\n"
		"#endif\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"	float4 color2 : COLOR1;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result )\n"
		"{\n"
		"#if defined(USE_GPU_SKINNING)\n"
		"	//--------------------------------------------------------------\n"
		"	// GPU transformation of the position\n"
		"	//\n"
		"	// multiplying with 255.1 give us the same result and is faster than floor( w * 255 + 0.5 )\n"
		"	//--------------------------------------------------------------\n"
		"	const float w0 = vertex.color2.x;\n"
		"	const float w1 = vertex.color2.y;\n"
		"	const float w2 = vertex.color2.z;\n"
		"	const float w3 = vertex.color2.w;\n"
		"\n"
		"	float4 matX, matY, matZ;	// must be float4 for vec4\n"
		"	int joint = int(vertex.color.x * 255.1 * 3.0);\n"
		"	matX = matrices[int(joint+0)] * w0;\n"
		"	matY = matrices[int(joint+1)] * w0;\n"
		"	matZ = matrices[int(joint+2)] * w0;\n"
		"\n"
		"	joint = int(vertex.color.y * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w1;\n"
		"	matY += matrices[int(joint+1)] * w1;\n"
		"	matZ += matrices[int(joint+2)] * w1;\n"
		"\n"
		"	joint = int(vertex.color.z * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w2;\n"
		"	matY += matrices[int(joint+1)] * w2;\n"
		"	matZ += matrices[int(joint+2)] * w2;\n"
		"\n"
		"	joint = int(vertex.color.w * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w3;\n"
		"	matY += matrices[int(joint+1)] * w3;\n"
		"	matZ += matrices[int(joint+2)] * w3;\n"
		"\n"
		"	float4 modelPosition;\n"
		"	modelPosition.x = dot4( matX, vertex.position );\n"
		"	modelPosition.y = dot4( matY, vertex.position );\n"
		"	modelPosition.z = dot4( matZ, vertex.position );\n"
		"	modelPosition.w = 1.0;\n"
		"\n"
		"	result.position.x = dot4( modelPosition, rpMVPmatrixX );\n"
		"	result.position.y = dot4( modelPosition, rpMVPmatrixY );\n"
		"	result.position.z = dot4( modelPosition, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( modelPosition, rpMVPmatrixW );\n"
		"#else\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"#endif\n"
		"}\n"
		
	},
	
	{
		"renderprogs/colorProcess.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0);\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position		: VPOS;\n"
		"	float4 color		: COLOR;\n"
		"	float3 texcoord0	: TEXCOORD0_centroid;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"	float4 src = tex2D( samp0, fragment.texcoord0.xy );\n"
		"	float4 target = fragment.color * dot3( float3( 0.333, 0.333, 0.333 ), src );\n"
		"	result.color = lerp( src, target, fragment.texcoord0.z );\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/colorProcess.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"global.inc\"\n"
		"\n"
		"uniform float4 rpUser0 : register(c128); //rpFraction\n"
		"uniform float4 rpUser1 : register(c129); //rpTargetHue\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position		: POSITION;\n"
		"	float4 color 		: COLOR0;\n"
		"	float3 texcoord0	: TEXCOORD0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"	\n"
		"	result.color = rpUser1; // targetHue\n"
		"	\n"
		"	result.texcoord0.x = vertex.texcoord.x;\n"
		"	result.texcoord0.y = 1.0f - vertex.texcoord.y;\n"
		"\n"
		"	result.texcoord0.z = rpUser0.x; // fraction\n"
		"}\n"
		"\n"
		"\n"
		
	},
	
	{
		"renderprogs/DeepGBufferRadiosity_radiosity.pixel",
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"// #version 120 // -*- c++ -*-\n"
		"// #extension GL_EXT_gpu_shader4 : require\n"
		"// #extension GL_ARB_gpu_shader5 : enable\n"
		"\n"
		"#define DIFFERENT_DEPTH_RESOLUTIONS 0\n"
		"#define USE_DEPTH_PEEL 0\n"
		"#define CS_Z_PACKED_TOGETHER 0\n"
		"#define TEMPORALLY_VARY_TAPS 0\n"
		"#define USE_OCT16 0\n"
		"#define COMPUTE_PEELED_LAYER 0\n"
		"#define USE_MIPMAPS 1\n"
		"#define USE_TAP_NORMAL 1\n"
		"\n"
		"#define HIGH_QUALITY 0\n"
		"\n"
		"#if HIGH_QUALITY\n"
		"// Total number of direct samples to take at each pixel\n"
		"#define NUM_SAMPLES 39\n"
		"\n"
		"// This is the number of turns around the circle that the spiral pattern makes.  This should be prime to prevent\n"
		"// taps from lining up.  This particular choice was tuned for NUM_SAMPLES == 9\n"
		"#define NUM_SPIRAL_TURNS 14\n"
		"\n"
		"#else\n"
		"\n"
		"#define NUM_SAMPLES 11\n"
		"#define NUM_SPIRAL_TURNS 7\n"
		"\n"
		"#endif\n"
		"\n"
		"// If using depth mip levels, the log of the maximum pixel offset before we need to switch to a lower\n"
		"// miplevel to maintain reasonable spatial locality in the cache\n"
		"// If this number is too small (< 3), too many taps will land in the same pixel, and we'll get bad variance that manifests as flashing.\n"
		"// If it is too high (> 5), we'll get bad performance because we're not using the MIP levels effectively\n"
		"#define LOG_MAX_OFFSET (3)\n"
		"\n"
		"// This must be less than or equal to the MAX_MIP_LEVEL defined in SAmbientOcclusion.cpp\n"
		"#define MAX_MIP_LEVEL (5)\n"
		"\n"
		"#define MIN_MIP_LEVEL 0\n"
		"\n"
		"const float DOOM_TO_METERS = 0.0254;					// doom to meters\n"
		"const float METERS_TO_DOOM = ( 1.0 / DOOM_TO_METERS );	// meters to doom\n"
		"\n"
		"/** Used for preventing AO computation on the sky (at infinite depth) and defining the CS Z to bilateral depth key scaling.\n"
		"    This need not match the real far plane but should not be much more than it.*/\n"
		"const float FAR_PLANE_Z = -4000.0;\n"
		"\n"
		"/** World-space AO radius in scene units (r).  e.g., 1.0m */\n"
		"const float radius = 1.0 * METERS_TO_DOOM;\n"
		"const float radius2 = radius * radius;\n"
		"const float invRadius2 = 1.0 / radius2;\n"
		"\n"
		"/** Bias to avoid AO in smooth corners, e.g., 0.01m */\n"
		"const float bias = 0.01 * METERS_TO_DOOM;\n"
		"\n"
		"/** The height in pixels of a 1m object if viewed from 1m away.\n"
		"    You can compute it from your projection matrix.  The actual value is just\n"
		"    a scale factor on radius; you can simply hardcode this to a constant (~500)\n"
		"    and make your radius value unitless (...but resolution dependent.)  */\n"
		"const float projScale = 500.0;\n"
		"\n"
		"// #expect NUM_SAMPLES \"Integer number of samples to take at each pixel\"\n"
		"// #expect NUM_SPIRAL_TURNS \"Integer number of turns around the circle that the spiral pattern makes. The DeepGBufferRadiosity class provides a discrepancy-minimizing value of NUM_SPIRAL_TURNS for each value of NUM_SAMPLES.\"\n"
		"// #expect USE_MIPMAPS \"1 to enable, 0 to disable\"\n"
		"// #expect USE_DEPTH_PEEL \"1 to enable, 0 to disable\"\n"
		"// #expect COMPUTE_PEELED_LAYER \"1 to enable, 0 to disable\"\n"
		"// #expect USE_TAP_NORMAL \"1 to enable, 0 to disable\"\n"
		"// #expect MIN_MIP_LEVEL \"non-negative integer\"\n"
		"// #expect USE_OCT16 \"1 to enable, 0 to disable\"\n"
		"// #if (!USE_DEPTH_PEEL) && COMPUTE_PEELED_LAYER\n"
		"// #error \"If computing a peeled layer, must be using depth peel!\"\n"
		"// #endif\n"
		"\n"
		"// *INDENT-OFF*\n"
		"uniform sampler2D samp0 : register( s0 ); // view normals\n"
		"uniform sampler2D samp1 : register( s1 ); // view depth\n"
		"uniform sampler2D samp2 : register( s2 ); // colors\n"
		" \n"
		"#define normal_buffer	samp0\n"
		"#define CS_Z_buffer		samp1\n"
		"#define colorBuffer		samp2\n"
		" \n"
		"struct PS_IN\n"
		"{\n"
		"	float2 texcoord0 : TEXCOORD0_centroid;\n"
		"};\n"
		" \n"
		"struct PS_OUT \n"
		"{\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"// *INDENT-ON*\n"
		"\n"
		"\n"
		"\n"
		"// #if 0 //normal_notNull\n"
		"// /** Same size as result buffer, do not offset by guard band when reading from it */\n"
		"// uniform sampler2D       normal_buffer;\n"
		"// uniform float4          normal_readMultiplyFirst;\n"
		"// uniform float4          normal_readAddSecond;\n"
		"\n"
		"// #if USE_OCT16\n"
		"// #include <oct.glsl>\n"
		"// #endif\n"
		"\n"
		"// #endif\n"
		"\n"
		"\n"
		"\n"
		"\n"
		"#if USE_DEPTH_PEEL\n"
		"uniform sampler2D       peeledColorBuffer;\n"
		"uniform sampler2D       peeledNormalBuffer;\n"
		"#endif\n"
		"\n"
		"//uniform float           indirectMultiplier;\n"
		"\n"
		"\n"
		"// Compatibility with future versions of GLSL: the shader still works if you change the\n"
		"// version line at the top to something like #version 330 compatibility.\n"
		"// #if __VERSION__ == 120\n"
		"// #   define texelFetch   texelFetch2D\n"
		"// #   define textureSize  textureSize2D\n"
		"// #   define result gl_FragData[0]\n"
		"// #   else\n"
		"// out float4            result;\n"
		"// #endif\n"
		"\n"
		"// #if COMPUTE_PEELED_LAYER\n"
		"// #   if __VERSION__ == 120\n"
		"// #       define peeledResult gl_FragData[1]\n"
		"// #   else\n"
		"// out float4       peeledResult;\n"
		"// #   endif\n"
		"// #   define indirectPeeledResult  peeledResult.rgb\n"
		"// #   define peeledVisibility      peeledResult.a\n"
		"// #endif\n"
		"\n"
		"#define indirectColor   result.color.rgb\n"
		"#define visibility      result.color.a\n"
		"\n"
		"/////////////////////////////////////////////////////////\n"
		"\n"
		"float reconstructCSZ( float d )\n"
		"{\n"
		"	//return clipInfo[0] / (clipInfo[1] * d + clipInfo[2]);\n"
		"	\n"
		"	// infinite far perspective matrix\n"
		"	return -3.0 / ( -1.0 * d + 1.0 );\n"
		"	\n"
		"	//d = d * 2.0 - 1.0;\n"
		"	//return -rpProjectionMatrixZ.w / ( -rpProjectionMatrixZ.z - d );\n"
		"}\n"
		"\n"
		"float3 reconstructCSPosition( float2 S, float z )\n"
		"{\n"
		"	float4 P;\n"
		"	P.z = z * 2.0 - 1.0;\n"
		"	//P.z = reconstructCSZ( z );\n"
		"	P.xy = ( S * rpScreenCorrectionFactor.xy ) * 2.0 - 1.0;\n"
		"	P.w = 1.0;\n"
		"	\n"
		"	float4 csP;\n"
		"	csP.x = dot4( P, rpModelMatrixX );\n"
		"	csP.y = dot4( P, rpModelMatrixY );\n"
		"	csP.z = dot4( P, rpModelMatrixZ );\n"
		"	csP.w = dot4( P, rpModelMatrixW );\n"
		"	\n"
		"	csP.xyz /= csP.w;\n"
		"	\n"
		"	return csP.xyz;\n"
		"}\n"
		"\n"
		"float3 sampleNormal( sampler2D normalBuffer, int2 ssC, int mipLevel )\n"
		"{\n"
		"#if USE_OCT16\n"
		"	return decode16( texelFetch( normalBuffer, ssC, mipLevel ).xy * 2.0 - 1.0 );\n"
		"#else\n"
		"	return texelFetch( normalBuffer, ssC, mipLevel ).xyz * 2.0 - 1.0;\n"
		"#endif\n"
		"}\n"
		"\n"
		"void sampleBothNormals( sampler2D normalBuffer, int2 ssC, int mipLevel, out float3 n_tap0, out float3 n_tap1 )\n"
		"{\n"
		"	float4 encodedNormals = texelFetch( normalBuffer, ssC, mipLevel ) * 2.0 - 1.0;\n"
		"	n_tap0 = decode16( encodedNormals.xy );\n"
		"	n_tap1 = decode16( encodedNormals.zw );\n"
		"}\n"
		"\n"
		"/** Returns a unit vector and a screen-space radius for the tap on a unit disk (the caller should scale by the actual disk radius) */\n"
		"float2 tapLocation( int sampleNumber, float spinAngle, float radialJitter, out float ssR )\n"
		"{\n"
		"	// Radius relative to ssR\n"
		"	float alpha = float( sampleNumber + radialJitter ) * ( 1.0 / NUM_SAMPLES );\n"
		"	float angle = alpha * ( NUM_SPIRAL_TURNS * 6.28 ) + spinAngle;\n"
		"	\n"
		"	ssR = alpha;\n"
		"	return float2( cos( angle ), sin( angle ) );\n"
		"}\n"
		"\n"
		"\n"
		"/** Read the camera-space position of the point at screen-space pixel ssP */\n"
		"float3 getPosition( int2 ssP, sampler2D cszBuffer )\n"
		"{\n"
		"	float3 P;\n"
		"	P.z = texelFetch( cszBuffer, ssP, 0 ).r;\n"
		"	\n"
		"	// Offset to pixel center\n"
		"	P = reconstructCSPosition( float2( ssP ) + float2( 0.5 ), P.z );\n"
		"	\n"
		"	return P;\n"
		"}\n"
		"\n"
		"\n"
		"void getPositions( int2 ssP, sampler2D cszBuffer, out float3 P0, out float3 P1 )\n"
		"{\n"
		"	float2 Zs = texelFetch( cszBuffer, ssP, 0 ).rg;\n"
		"	\n"
		"	// Offset to pixel center\n"
		"	P0 = reconstructCSPosition( float2( ssP ) + float2( 0.5 ), Zs.x );\n"
		"	P1 = reconstructCSPosition( float2( ssP ) + float2( 0.5 ), Zs.y );\n"
		"}\n"
		"\n"
		"\n"
		"void computeMipInfo( float ssR, int2 ssP, sampler2D cszBuffer, inout int mipLevel, inout int2 mipP )\n"
		"{\n"
		"#if USE_MIPMAPS\n"
		"	// Derivation:\n"
		"	//  mipLevel = floor(log(ssR / MAX_OFFSET));\n"
		"#ifdef GL_EXT_gpu_shader5\n"
		"	mipLevel = clamp( findMSB( int( ssR ) ) - LOG_MAX_OFFSET, MIN_MIP_LEVEL, MAX_MIP_LEVEL );\n"
		"#else\n"
		"	mipLevel = clamp( int( floor( log2( ssR ) ) ) - LOG_MAX_OFFSET, MIN_MIP_LEVEL, MAX_MIP_LEVEL );\n"
		"#endif\n"
		"	\n"
		"	// We need to divide by 2^mipLevel to read the appropriately scaled coordinate from a MIP-map.\n"
		"	// Manually clamp to the texture size because texelFetch bypasses the texture unit\n"
		"	//mipP = ssP >> mipLevel;//clamp(ssP >> mipLevel, int2(0), textureSize(CS_Z_buffer, mipLevel) - int2(1));\n"
		"	\n"
		"	mipP = clamp( ssP >> mipLevel, int2( 0 ), textureSize( cszBuffer, mipLevel ) - int2( 1 ) );\n"
		"#else\n"
		"	mipLevel = 0;\n"
		"	mipP = ssP;\n"
		"#endif\n"
		"}\n"
		"\n"
		"\n"
		"/** Read the camera-space position of the point at screen-space pixel ssP + unitOffset * ssR.  Assumes length(unitOffset) == 1.\n"
		"    Use cszBufferScale if reading from the peeled depth buffer, which has been scaled by (1 / invCszBufferScale) from the original */\n"
		"float3 getOffsetPosition( int2 ssC, float2 unitOffset, float ssR, sampler2D cszBuffer, float invCszBufferScale )\n"
		"{\n"
		"	int2 ssP = clamp( int2( ssR * unitOffset ) + ssC, int2( 0 ), int2( g3d_sz2D_colorBuffer.xy - 1 ) );\n"
		"	\n"
		"	int mipLevel;\n"
		"	int2 mipP;\n"
		"	computeMipInfo( ssR, ssP, cszBuffer, mipLevel, mipP );\n"
		"	\n"
		"	float3 P;\n"
		"	\n"
		"	P.z = texelFetch( cszBuffer, mipP, mipLevel ).r;\n"
		"	\n"
		"	// Offset to pixel center\n"
		"	P = reconstructCSPosition( ( float2( ssP ) + float2( 0.5 ) ) * invCszBufferScale, P.z );\n"
		"	\n"
		"	return P;\n"
		"}\n"
		"\n"
		"\n"
		"/** Read the camera-space position of the points at screen-space pixel ssP + unitOffset * ssR in both channels of the packed csz buffer.  Assumes length(unitOffset) == 1. */\n"
		"void getOffsetPositions( int2 ssC, float2 unitOffset, float ssR, sampler2D cszBuffer, out float3 P0, out float3 P1 )\n"
		"{\n"
		"	int2 ssP = clamp( int2( ssR * unitOffset ) + ssC, int2( 0 ), int2( g3d_sz2D_colorBuffer.xy - 1 ) );\n"
		"	\n"
		"	int mipLevel;\n"
		"	int2 mipP;\n"
		"	computeMipInfo( ssR, ssP, cszBuffer, mipLevel, mipP );\n"
		"	\n"
		"	float2 Zs = texelFetch( cszBuffer, mipP, mipLevel ).rg;\n"
		"	\n"
		"	// Offset to pixel center\n"
		"	P0 = reconstructCSPosition( ( float2( ssP ) + float2( 0.5 ) ), Zs.x );\n"
		"	P1 = reconstructCSPosition( ( float2( ssP ) + float2( 0.5 ) ), Zs.y );\n"
		"}\n"
		"\n"
		"\n"
		"void getOffsetPositionNormalAndLambertian\n"
		"( int2             ssP,\n"
		"  float            ssR,\n"
		"  sampler2D        cszBuffer,\n"
		"  sampler2D        bounceBuffer,\n"
		"  sampler2D        normalBuffer,\n"
		"  inout float3     Q,\n"
		"  inout float3     lambertian_tap,\n"
		"  inout float3     n_tap )\n"
		"{\n"
		"\n"
		"#if USE_MIPMAPS\n"
		"	int mipLevel;\n"
		"	int2 texel;\n"
		"	computeMipInfo( ssR, ssP, cszBuffer, mipLevel, texel );\n"
		"#else\n"
		"	int mipLevel = 0;\n"
		"	int2 texel = ssP;\n"
		"#endif\n"
		"	\n"
		"	float z = texelFetch( cszBuffer, texel, mipLevel ).r;\n"
		"	\n"
		"	// FIXME mip map bounce/normal buffers FBOs\n"
		"#if 0\n"
		"	float3 n = sampleNormal( normalBuffer, texel, mipLevel );\n"
		"	lambertian_tap = texelFetch( bounceBuffer, texel, mipLevel ).rgb;\n"
		"#else\n"
		"	float3 n = sampleNormal( normalBuffer, ssP, 0 );\n"
		"	lambertian_tap = texelFetch( bounceBuffer, ssP, 0 ).rgb;\n"
		"#endif\n"
		"\n"
		"	//n_tap = normalize( n );	\n"
		"	n_tap = n;\n"
		"	\n"
		"	// Offset to pixel center\n"
		"	Q = reconstructCSPosition( ( float2( ssP ) + float2( 0.5 ) ), z );\n"
		"}\n"
		"\n"
		"\n"
		"void getOffsetPositionsNormalsAndLambertians\n"
		"( int2           ssP,\n"
		"  float           ssR,\n"
		"  sampler2D       cszBuffer,\n"
		"  sampler2D       bounceBuffer,\n"
		"  sampler2D       peeledBounceBuffer,\n"
		"  sampler2D       normalBuffer,\n"
		"  sampler2D       peeledNormalBuffer,\n"
		"  out float3      Q0,\n"
		"  out float3      Q1,\n"
		"  out float3      lambertian_tap0,\n"
		"  out float3      lambertian_tap1,\n"
		"  out float3     n_tap0,\n"
		"  out float3     n_tap1 )\n"
		"{\n"
		"\n"
		"#if USE_MIPMAPS\n"
		"	int mipLevel;\n"
		"	int2 texel;\n"
		"	computeMipInfo( ssR, ssP, cszBuffer, mipLevel, texel );\n"
		"#else\n"
		"	int mipLevel = 0;\n"
		"	int2 texel = ssP;\n"
		"#endif\n"
		"	\n"
		"	float2 Zs = texelFetch( cszBuffer, texel, mipLevel ).rg;\n"
		"#if USE_OCT16\n"
		"	sampleBothNormals( normalBuffer, texel, mipLevel, n_tap0, n_tap1 );\n"
		"#else\n"
		"	n_tap0 = sampleNormal( normalBuffer, texel, mipLevel );\n"
		"	n_tap1 = sampleNormal( peeledNormalBuffer, texel, mipLevel );\n"
		"#endif\n"
		"	\n"
		"	lambertian_tap0 = texelFetch( bounceBuffer, texel, mipLevel ).rgb;\n"
		"	lambertian_tap1 = texelFetch( peeledBounceBuffer, texel, mipLevel ).rgb;\n"
		"	\n"
		"	// Offset to pixel center\n"
		"	Q0 = reconstructCSPosition( ( float2( ssP ) + float2( 0.5 ) ), Zs.x, projInfo );\n"
		"	Q1 = reconstructCSPosition( ( float2( ssP ) + float2( 0.5 ) ), Zs.y, projInfo );\n"
		"}\n"
		"\n"
		"\n"
		"void iiValueFromPositionsAndNormalsAndLambertian( int2 ssP, float3 X, float3 n_X, float3 Y, float3 n_Y, float3 radiosity_Y, inout float3 E, inout float weight_Y, inout float visibilityWeight_Y )\n"
		"{\n"
		"\n"
		"	float3 YminusX = Y - X;\n"
		"	float3 w_i = normalize( YminusX );\n"
		"	weight_Y = ( ( dot( w_i, n_X ) > 0.0 )\n"
		"#if USE_TAP_NORMAL\n"
		"				 && ( dot( -w_i, n_Y ) > 0.01 )\n"
		"#endif\n"
		"			   ) ? 1.0 : 0.0; // Backface check\n"
		"			   \n"
		"	// E = radiosity_Y * dot(w_i, n_X) * weight_Y * float(dot(YminusX, YminusX) < radius2);\n"
		"	\n"
		"	if( ( dot( YminusX, YminusX ) < radius2 ) && // Radius check\n"
		"			( weight_Y > 0 ) )\n"
		"	{\n"
		"		E = radiosity_Y * dot( w_i, n_X );\n"
		"	}\n"
		"	else\n"
		"	{\n"
		"#if USE_TAP_NORMAL == 0\n"
		"		weight_Y = 0;\n"
		"#endif\n"
		"		E = float3( 0 );\n"
		"	}\n"
		"}\n"
		"\n"
		"\n"
		"/** Compute the occlusion due to sample with index \a i about the pixel at \a ssC that corresponds\n"
		"    to camera-space point \a C with unit normal \a n_C, using maximum screen-space sampling radius \a ssDiskRadius\n"
		"\n"
		"    When sampling from the peeled depth buffer, make sure ssDiskRadius has been premultiplied by cszBufferScale\n"
		"*/\n"
		"void sampleIndirectLight\n"
		"( in int2             ssC,\n"
		"  in float3           C,\n"
		"  in float3           n_C,\n"
		"  in float3           C_peeled,\n"
		"  in float3           n_C_peeled,\n"
		"  in float            ssDiskRadius,\n"
		"  in int              tapIndex,\n"
		"  in float            randomPatternRotationAngle,\n"
		"  in float            radialJitter,\n"
		"  in sampler2D        cszBuffer,\n"
		"  in sampler2D        nBuffer,\n"
		"  in sampler2D        bounceBuffer,\n"
		"  inout float3        irradianceSum,\n"
		"  inout float         numSamplesUsed,\n"
		"  inout float3        iiPeeled,\n"
		"  inout float         weightSumPeeled )\n"
		"{\n"
		"\n"
		"	// Not used yet, quality optimization in progress...\n"
		"	float visibilityWeightPeeled0, visibilityWeightPeeled1;\n"
		"	\n"
		"	// Offset on the unit disk, spun for this pixel\n"
		"	float ssR;\n"
		"	float2 unitOffset = tapLocation( tapIndex, randomPatternRotationAngle, radialJitter, ssR );\n"
		"	ssR *= ssDiskRadius;\n"
		"	int2 ssP = int2( ssR * unitOffset ) + ssC;\n"
		"	\n"
		"#if USE_DEPTH_PEEL\n"
		"	float3 E, ii_tap0, ii_tap1;\n"
		"	float weight, weight0, weight1;\n"
		"	float visibilityWeight0, visibilityWeight1;\n"
		"	// The occluding point in camera space\n"
		"	float3 Q0, lambertian_tap0, n_tap0, Q1, lambertian_tap1, n_tap1;\n"
		"	getOffsetPositionsNormalsAndLambertians( ssP, ssR, cszBuffer, bounceBuffer, peeledColorBuffer, nBuffer, peeledNormalBuffer, Q0, Q1, lambertian_tap0, lambertian_tap1, n_tap0, n_tap1 );\n"
		"	iiValueFromPositionsAndNormalsAndLambertian( ssP, C, n_C, Q0, n_tap0, lambertian_tap0, ii_tap0, weight0, visibilityWeight0 );\n"
		"	float adjustedWeight0 = weight0 * dot( ii_tap0, ii_tap0 ) + weight0;\n"
		"	\n"
		"	iiValueFromPositionsAndNormalsAndLambertian( ssP, C, n_C, Q1, n_tap1, lambertian_tap1, ii_tap1, weight1, visibilityWeight1 );\n"
		"	float adjustedWeight1 = weight1 * dot( ii_tap1, ii_tap1 ) + weight1;\n"
		"	\n"
		"	weight = ( adjustedWeight0 > adjustedWeight1 ) ? weight0 : weight1;\n"
		"	E = ( adjustedWeight0 > adjustedWeight1 ) ? ii_tap0 : ii_tap1;\n"
		"	\n"
		"#if COMPUTE_PEELED_LAYER\n"
		"	\n"
		"	float weightPeeled0, weightPeeled1;\n"
		"	float3 ii_tapPeeled0, ii_tapPeeled1;\n"
		"	iiValueFromPositionsAndNormalsAndLambertian( ssP, C_peeled, n_C_peeled, Q0, n_tap0, lambertian_tap0, ii_tapPeeled0, weightPeeled0, visibilityWeightPeeled0 );\n"
		"	iiValueFromPositionsAndNormalsAndLambertian( ssP, C_peeled, n_C_peeled, Q1, n_tap1, lambertian_tap1, ii_tapPeeled1, weightPeeled1, visibilityWeightPeeled1 );\n"
		"	\n"
		"	float iiMag0 = dot( ii_tapPeeled0, ii_tapPeeled0 );\n"
		"	float iiMag1 = dot( ii_tapPeeled1, ii_tapPeeled1 );\n"
		"	weightSumPeeled += iiMag0 > iiMag1 ? weightPeeled0 : weightPeeled1;\n"
		"	iiPeeled        += iiMag0 > iiMag1 ? ii_tapPeeled0 : ii_tapPeeled1;\n"
		"	\n"
		"#endif\n"
		"	\n"
		"	numSamplesUsed += weight;\n"
		"	\n"
		"#else\n"
		"	\n"
		"	float3 E;\n"
		"	float visibilityWeight;\n"
		"	float weight_Y;\n"
		"	// The occluding point in camera space\n"
		"	float3 Q, lambertian_tap, n_tap;\n"
		"	getOffsetPositionNormalAndLambertian( ssP, ssR, cszBuffer, bounceBuffer, nBuffer, Q, lambertian_tap, n_tap );\n"
		"	iiValueFromPositionsAndNormalsAndLambertian( ssP, C, n_C, Q, n_tap, lambertian_tap, E, weight_Y, visibilityWeight );\n"
		"	numSamplesUsed += weight_Y;\n"
		"#endif\n"
		"	\n"
		"	irradianceSum += E;\n"
		"	//irradianceSum += pow( E, float3( 2.2 ) ); // RB: to linear RGB\n"
		"}\n"
		"\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result )\n"
		"{\n"
		"	result.color = float4( 0.0, 0.0, 0.0, 1.0 );\n"
		"	\n"
		"#if 0\n"
		"	if( fragment.texcoord0.x < 0.5 )\n"
		"	{\n"
		"		discard;\n"
		"	}\n"
		"#endif\n"
		"	\n"
		"	// Pixel being shaded\n"
		"	int2 ssC = int2( gl_FragCoord.xy );\n"
		"	\n"
		"#if COMPUTE_PEELED_LAYER\n"
		"	float3 C, C_peeled;\n"
		"	getPositions( ssC, CS_Z_buffer, C, C_peeled );\n"
		"	float3 n_C_peeled = sampleNormal( peeledNormalBuffer, ssC, 0 );\n"
		"#else\n"
		"	// World space point being shaded\n"
		"	float3 C = getPosition( ssC, CS_Z_buffer );\n"
		"	float3 C_peeled = float3( 0 );\n"
		"	float3 n_C_peeled = float3( 0 );\n"
		"#endif\n"
		"	\n"
		"	float3 n_C = sampleNormal( normal_buffer, ssC, 0 );\n"
		"	//n_C = normalize( n_C );\n"
		"	\n"
		"	\n"
		"	// Choose the screen-space sample radius\n"
		"	// proportional to the projected area of the sphere\n"
		"	float ssDiskRadius = -projScale * radius / C.z;\n"
		"	\n"
		"	// Hash function used in the HPG12 AlchemyAO paper\n"
		"	float randomPatternRotationAngle = ( 3 * ssC.x ^ ssC.y + ssC.x * ssC.y ) * 10;\n"
		"#if TEMPORALLY_VARY_TAPS\n"
		"	randomPatternRotationAngle += rpJitterTexOffset.x;\n"
		"#endif\n"
		"	\n"
		"	float radialJitter = fract( sin( gl_FragCoord.x * 1e2 +\n"
		"#if TEMPORALLY_VARY_TAPS\n"
		"									 rpJitterTexOffset.x +\n"
		"#endif\n"
		"									 gl_FragCoord.y ) * 1e5 + sin( gl_FragCoord.y * 1e3 ) * 1e3 ) * 0.8 + 0.1;\n"
		"									 \n"
		"	float numSamplesUsed = 0.0;\n"
		"	float3 irradianceSum = float3( 0 );\n"
		"	float3 ii_peeled = float3( 0 );\n"
		"	float peeledSum = 0.0;\n"
		"	for( int i = 0; i < NUM_SAMPLES; ++i )\n"
		"	{\n"
		"		sampleIndirectLight( ssC, C, n_C, C_peeled, n_C_peeled, ssDiskRadius, i, randomPatternRotationAngle, radialJitter, CS_Z_buffer, normal_buffer, colorBuffer, irradianceSum, numSamplesUsed, ii_peeled, peeledSum );\n"
		"	}\n"
		"	\n"
		"	const float solidAngleHemisphere = 2 * PI;\n"
		"	float3 E_X = irradianceSum * solidAngleHemisphere / ( numSamplesUsed + 0.00001 );\n"
		"	\n"
		"	indirectColor = E_X;\n"
		"	//indirectColor = pow( E_X, float3( 1.0 / 2.2 ) ); // RB: to sRGB\n"
		"	\n"
		"	// What is the ambient visibility of this location\n"
		"	visibility = 1 - numSamplesUsed / float( NUM_SAMPLES );\n"
		"	//visibility = clamp( 1 - numSamplesUsed / float( NUM_SAMPLES ), 0.0, 1.0 );\n"
		"	//visibility = pow( max( 0.0, 1.0 - sqrt( sum * ( 3.0 / NUM_SAMPLES ) ) ), intensity );\n"
		"	\n"
		"	//result.color = float4( visibility, visibility, visibility, 1.0 );\n"
		"	//result.color = float4( n_C * 0.5 + 0.5, 1.0 );\n"
		"	//result.color = texture( samp2, fragment.texcoord0 ).rgba;\n"
		"	\n"
		"#if COMPUTE_PEELED_LAYER\n"
		"	float A_peeled = 1 - peeledSum / float( NUM_SAMPLES );\n"
		"	float3 E_X_peeled = ii_peeled * solidAngleHemisphere / ( peeledSum + 0.00001 );\n"
		"	\n"
		"	indirectPeeledResult    = E_X_peeled;\n"
		"	peeledVisibility        = A_peeled;\n"
		"#endif\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/DeepGBufferRadiosity_radiosity.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN \n"
		"{\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"};\n"
		"\n"
		"struct VS_OUT\n"
		"{\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord0 : TEXCOORD0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result )\n"
		"{\n"
		"	result.position = vertex.position;\n"
		"	result.texcoord0 = vertex.texcoord;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/DeepGBufferRadiosity_blur.pixel",
		"/**\n"
		"  \file AmbientOcclusion_blur.pix\n"
		"  \author Morgan McGuire and Michael Mara, NVIDIA Research\n"
		"\n"
		"  \brief 7-tap 1D cross-bilateral blur using a packed depth key\n"
		"\n"
		"  Open Source under the \"BSD\" license: http://www.opensource.org/licenses/bsd-license.php\n"
		"\n"
		"  Copyright (c) 2011-2014, NVIDIA\n"
		"  Copyright (c) 2016 Robert Beckebans ( id Tech 4.x integration )\n"
		"  All rights reserved.\n"
		"\n"
		"  Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:\n"
		"\n"
		"  Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.\n"
		"  Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.\n"
		"  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n"
		"*/\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"// *INDENT-OFF*\n"
		"uniform sampler2D samp0 : register( s0 ); // view normals\n"
		"uniform sampler2D samp1 : register( s1 ); // view depth\n"
		"uniform sampler2D samp2 : register( s2 ); // view AO\n"
		" \n"
		"#define normal_buffer	samp0\n"
		"#define cszBuffer		samp1\n"
		"#define source			samp2 \n"
		" \n"
		"struct PS_IN\n"
		"{\n"
		"	float2 texcoord0 : TEXCOORD0_centroid;\n"
		"};\n"
		" \n"
		"struct PS_OUT \n"
		"{\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"// *INDENT-ON*\n"
		"\n"
		"#define PEELED_LAYER 0\n"
		"#define USE_OCT16 0\n"
		"#define USE_NORMALS 1\n"
		"\n"
		"//#expect PEELED_LAYER \"binary\"\n"
		"\n"
		"//////////////////////////////////////////////////////////////////////////////////////////////\n"
		"// Tunable Parameters:\n"
		"\n"
		"//#define NUM_KEY_COMPONENTS 1\n"
		"\n"
		"// The other parameters in this section must be passed in as macro values\n"
		"\n"
		"/** Increase to make depth edges crisper. Decrease to reduce flicker. */\n"
		"#define EDGE_SHARPNESS     (1.0)\n"
		"\n"
		"/** Step in 2-pixel intervals since we already blurred against neighbors in the\n"
		"    first AO pass.  This constant can be increased while R decreases to improve\n"
		"    performance at the expense of some dithering artifacts.\n"
		"\n"
		"    Morgan found that a scale of 3 left a 1-pixel checkerboard grid that was\n"
		"    unobjectionable after shading was applied but eliminated most temporal incoherence\n"
		"    from using small numbers of sample taps.\n"
		"    */\n"
		"#define SCALE               (2)\n"
		"\n"
		"/** Filter radius in pixels. This will be multiplied by SCALE. */\n"
		"#define R                   (4)\n"
		"\n"
		"#define MDB_WEIGHTS 	0\n"
		"//////////////////////////////////////////////////////////////////////////////////////////////\n"
		"\n"
		"/** Type of data to read from source.  This macro allows\n"
		"    the same blur shader to be used on different kinds of input data. */\n"
		"#define VALUE_TYPE        float4\n"
		"\n"
		"/** Swizzle to use to extract the channels of source. This macro allows\n"
		"    the same blur shader to be used on different kinds of input data. */\n"
		"#define VALUE_COMPONENTS   rgba\n"
		"\n"
		"#define VALUE_IS_KEY       0\n"
		"\n"
		"\n"
		"\n"
		"\n"
		"/** (1, 0) or (0, 1)*/\n"
		"//uniform int2       axis;\n"
		"\n"
		"#if USE_OCT16\n"
		"#include <oct.glsl>\n"
		"#endif\n"
		"\n"
		"float3 sampleNormal( sampler2D normalBuffer, int2 ssC, int mipLevel )\n"
		"{\n"
		"#if USE_OCT16\n"
		"	return decode16( texelFetch( normalBuffer, ssC, mipLevel ).xy * 2.0 - 1.0 );\n"
		"#else\n"
		"	return normalize( texelFetch( normalBuffer, ssC, mipLevel ).xyz * 2.0 - 1.0 );\n"
		"#endif\n"
		"}\n"
		"\n"
		"#define  blurResult         result.color.VALUE_COMPONENTS\n"
		"\n"
		"/** Used for preventing AO computation on the sky (at infinite depth) and defining the CS Z to bilateral depth key scaling.\n"
		"    This need not match the real far plane but should not be much more than it.*/\n"
		"const float FAR_PLANE_Z = -16000.0;\n"
		"\n"
		"float CSZToKey( float z )\n"
		"{\n"
		"	return clamp( z * ( 1.0 / FAR_PLANE_Z ), 0.0, 1.0 );\n"
		"}\n"
		"\n"
		"float reconstructCSZ( float d )\n"
		"{\n"
		"	//return clipInfo[0] / (clipInfo[1] * d + clipInfo[2]);\n"
		"	\n"
		"	// infinite far perspective matrix\n"
		"	return -3.0 / ( -1.0 * d + 1.0 );\n"
		"	\n"
		"	//d = d * 2.0 - 1.0;\n"
		"	//return -rpProjectionMatrixZ.w / ( -rpProjectionMatrixZ.z - d );\n"
		"}\n"
		"\n"
		"float3 reconstructCSPosition( float2 S, float z )\n"
		"{\n"
		"	float4 P;\n"
		"	P.z = z * 2.0 - 1.0;\n"
		"	P.xy = ( S * rpScreenCorrectionFactor.xy ) * 2.0 - 1.0;\n"
		"	P.w = 1.0;\n"
		"	\n"
		"	float4 csP;\n"
		"	csP.x = dot4( P, rpModelMatrixX );\n"
		"	csP.y = dot4( P, rpModelMatrixY );\n"
		"	csP.z = dot4( P, rpModelMatrixZ );\n"
		"	csP.w = dot4( P, rpModelMatrixW );\n"
		"	\n"
		"	csP.xyz /= csP.w;\n"
		"	\n"
		"	return csP.xyz;\n"
		"}\n"
		"\n"
		"float getKey( int2 ssP )\n"
		"{\n"
		"#if PEELED_LAYER\n"
		"	float key = texelFetch( cszBuffer, ssP, 0 ).g;\n"
		"#else\n"
		"	float key = texelFetch( cszBuffer, ssP, 0 ).r;\n"
		"#endif\n"
		"\n"
		"#if 0\n"
		"	key = reconstructCSZ( key );\n"
		"#else\n"
		"	float3 P = reconstructCSPosition( float2( ssP ) + float2( 0.5 ), key );\n"
		"	key = P.z;\n"
		"#endif\n"
		"	\n"
		"	key = clamp( key * ( 1.0 / FAR_PLANE_Z ), 0.0, 1.0 );\n"
		"	return key;\n"
		"}\n"
		"\n"
		"float3 positionFromKey( float key, int2 ssC )\n"
		"{\n"
		"	float z = key * FAR_PLANE_Z;\n"
		"	float3 C = reconstructCSPosition( float2( ssC ) + float2( 0.5 ), z );\n"
		"	return C;\n"
		"}\n"
		"\n"
		"/** Read the camera-space position of the point at screen-space pixel ssP */\n"
		"float3 getPosition( int2 ssP, sampler2D cszBuffer )\n"
		"{\n"
		"	float3 P;\n"
		"	P.z = texelFetch( cszBuffer, ssP, 0 ).r;\n"
		"	\n"
		"	// Offset to pixel center\n"
		"	P = reconstructCSPosition( float2( ssP ) + float2( 0.5 ), P.z );\n"
		"	\n"
		"	return P;\n"
		"}\n"
		"\n"
		"float calculateBilateralWeight( float key, float tapKey, int2 tapLoc, float3 n_C, float3 C )\n"
		"{\n"
		"	// range domain (the \"bilateral\" weight). As depth difference increases, decrease weight.\n"
		"	float depthWeight = max( 0.0, 1.0 - ( EDGE_SHARPNESS * 2000.0 ) * abs( tapKey - key ) );\n"
		"	\n"
		"	float k_normal = 1.0; //40.0;\n"
		"	float k_plane = 1.0; //0.5;\n"
		"	\n"
		"	// Prevents blending over creases.\n"
		"	float normalWeight = 1.0; //1000.0;\n"
		"	float planeWeight = 1.0;\n"
		"	\n"
		"#if USE_NORMALS\n"
		"	float3 tapN_C = sampleNormal( normal_buffer, tapLoc, 0 );\n"
		"	depthWeight = 1.0;\n"
		"	\n"
		"	float normalError = ( 1.0 - dot( tapN_C, n_C ) ) * k_normal;\n"
		"	normalWeight = max( 1.0 - EDGE_SHARPNESS * normalError, 0.00 );\n"
		"	\n"
		"	\n"
		"	float lowDistanceThreshold2 = 0.001; //0.01;\n"
		"	\n"
		"	//float3 tapC = positionFromKey( tapKey, tapLoc, projInfo );\n"
		"	float3 tapC = getPosition( tapLoc, cszBuffer );\n"
		"	\n"
		"	// Change in position in camera space\n"
		"	float3 dq = C - tapC;\n"
		"	\n"
		"	// How far away is this point from the original sample\n"
		"	// in camera space? (Max value is unbounded)\n"
		"	float distance2 = dot( dq, dq );\n"
		"	\n"
		"	// How far off the expected plane (on the perpendicular) is this point?  Max value is unbounded.\n"
		"	float planeError = max( abs( dot( dq, tapN_C ) ), abs( dot( dq, n_C ) ) );\n"
		"	\n"
		"	planeWeight = ( distance2 < lowDistanceThreshold2 ) ? 1.0 :\n"
		"				  pow( max( 0.0, 1.0 - EDGE_SHARPNESS * 2.0 * k_plane * planeError / sqrt( distance2 ) ), 2.0 );\n"
		"				  \n"
		"				  \n"
		"#endif\n"
		"				  \n"
		"	return depthWeight * normalWeight * planeWeight;\n"
		"}\n"
		"\n"
		"\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result )\n"
		"{\n"
		"\n"
		"//#   if __VERSION__ < 330\n"
		"	float kernel[R + 1];\n"
		"//      if R == 0, we never call this shader\n"
		"#if R == 1\n"
		"	kernel[0] = 0.5;\n"
		"	kernel[1] = 0.25;\n"
		"#elif R == 2\n"
		"	kernel[0] = 0.153170;\n"
		"	kernel[1] = 0.144893;\n"
		"	kernel[2] = 0.122649;\n"
		"#elif R == 3\n"
		"	kernel[0] = 0.153170;\n"
		"	kernel[1] = 0.144893;\n"
		"	kernel[2] = 0.122649;\n"
		"	kernel[3] = 0.092902;\n"
		"#elif R == 4\n"
		"	kernel[0] = 0.153170;\n"
		"	kernel[1] = 0.144893;\n"
		"	kernel[2] = 0.122649;\n"
		"	kernel[3] = 0.092902;\n"
		"	kernel[4] = 0.062970;\n"
		"#elif R == 5\n"
		"	kernel[0] = 0.111220;\n"
		"	kernel[1] = 0.107798;\n"
		"	kernel[2] = 0.098151;\n"
		"	kernel[3] = 0.083953;\n"
		"	kernel[4] = 0.067458;\n"
		"	kernel[5] = 0.050920;\n"
		"#elif R == 6\n"
		"	kernel[0] = 0.111220;\n"
		"	kernel[1] = 0.107798;\n"
		"	kernel[2] = 0.098151;\n"
		"	kernel[3] = 0.083953;\n"
		"	kernel[4] = 0.067458;\n"
		"	kernel[5] = 0.050920;\n"
		"	kernel[6] = 0.036108;\n"
		"#endif\n"
		"//#endif\n"
		"	\n"
		"	int2 ssC = int2( gl_FragCoord.xy );\n"
		"	\n"
		"	float4 temp = texelFetch( source, ssC, 0 );\n"
		"	\n"
		"#if 0\n"
		"	if( fragment.texcoord0.x < 0.75 )\n"
		"	{\n"
		"		result.color = temp;\n"
		"		return;\n"
		"	}\n"
		"#endif\n"
		"	\n"
		"#if 0\n"
		"	float key = getKey( ssC );\n"
		"	float3 C = positionFromKey( key, ssC );\n"
		"#else\n"
		"	float3 C = getPosition( ssC, cszBuffer );\n"
		"	float key = CSZToKey( C.z );\n"
		"#endif\n"
		"	\n"
		"	VALUE_TYPE sum = temp.VALUE_COMPONENTS;\n"
		"	\n"
		"	if( key == 1.0 )\n"
		"	{\n"
		"		// Sky pixel (if you aren't using depth keying, disable this test)\n"
		"		blurResult = sum;\n"
		"		return;\n"
		"	}\n"
		"	\n"
		"	// Base weight for falloff.  Increase this for more blurriness,\n"
		"	// decrease it for better edge discrimination\n"
		"	float BASE = kernel[0];\n"
		"	float totalWeight = BASE;\n"
		"	sum *= totalWeight;\n"
		"	\n"
		"	float3 n_C;\n"
		"#if USE_NORMALS\n"
		"	n_C = sampleNormal( normal_buffer, ssC, 0 );\n"
		"#endif\n"
		"	\n"
		"#if MDB_WEIGHTS == 0\n"
		"	for( int r = -R; r <= R; ++r )\n"
		"	{\n"
		"		// We already handled the zero case above.  This loop should be unrolled and the static branch optimized out,\n"
		"		// so the IF statement has no runtime cost\n"
		"		if( r != 0 )\n"
		"		{\n"
		"			int2 tapLoc = ssC + int2( rpJitterTexScale.xy ) * ( r * SCALE );\n"
		"			temp = texelFetch( source, tapLoc, 0 );\n"
		"			\n"
		"			\n"
		"			float tapKey = getKey( tapLoc );\n"
		"			VALUE_TYPE value  = temp.VALUE_COMPONENTS;\n"
		"			\n"
		"			// spatial domain: offset kernel tap\n"
		"			float weight = 0.3 + kernel[abs( r )];\n"
		"			\n"
		"			float bilateralWeight = calculateBilateralWeight( key, tapKey, tapLoc, n_C, C );\n"
		"			\n"
		"			weight *= bilateralWeight;\n"
		"			sum += value * weight;\n"
		"			totalWeight += weight;\n"
		"		}\n"
		"	}\n"
		"#else\n"
		"	\n"
		"	float lastBilateralWeight = 9999.0;\n"
		"	for( int r = -1; r >= -R; --r )\n"
		"	{\n"
		"		int2 tapLoc = ssC + int2( rpJitterTexScale.xy ) * ( r * SCALE );\n"
		"		temp = texelFetch( source, tapLoc, 0 );\n"
		"		float      tapKey = getKey( tapLoc );\n"
		"	\n"
		"		VALUE_TYPE value  = temp.VALUE_COMPONENTS;\n"
		"	\n"
		"		// spatial domain: offset kernel tap\n"
		"		float weight = 0.3 + kernel[abs( r )];\n"
		"	\n"
		"		// range domain (the \"bilateral\" weight). As depth difference increases, decrease weight.\n"
		"		float bilateralWeight = calculateBilateralWeight( key, tapKey, tapLoc, n_C, C );\n"
		"		bilateralWeight = min( lastBilateralWeight, bilateralWeight );\n"
		"		lastBilateralWeight = bilateralWeight;\n"
		"		weight *= bilateralWeight;\n"
		"		sum += value * weight;\n"
		"		totalWeight += weight;\n"
		"	}\n"
		"	\n"
		"	lastBilateralWeight = 9999.0;\n"
		"	for( int r = 1; r <= R; ++r )\n"
		"	{\n"
		"		int2 tapLoc = ssC + int2( rpJitterTexScale.xy ) * ( r * SCALE );\n"
		"		temp = texelFetch( source, tapLoc, 0 );\n"
		"		float      tapKey = getKey( tapLoc );\n"
		"		VALUE_TYPE value  = temp.VALUE_COMPONENTS;\n"
		"	\n"
		"		// spatial domain: offset kernel tap\n"
		"		float weight = 0.3 + kernel[abs( r )];\n"
		"	\n"
		"		// range domain (the \"bilateral\" weight). As depth difference increases, decrease weight.\n"
		"		float bilateralWeight = calculateBilateralWeight( key, tapKey, tapLoc, n_C, C );\n"
		"		bilateralWeight = min( lastBilateralWeight, bilateralWeight );\n"
		"		lastBilateralWeight = bilateralWeight;\n"
		"		weight *= bilateralWeight;\n"
		"		sum += value * weight;\n"
		"		totalWeight += weight;\n"
		"	}\n"
		"#endif\n"
		"	\n"
		"	const float epsilon = 0.0001;\n"
		"	blurResult = sum / ( totalWeight + epsilon );\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/DeepGBufferRadiosity_blur.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN \n"
		"{\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"};\n"
		"\n"
		"struct VS_OUT\n"
		"{\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord0 : TEXCOORD0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result )\n"
		"{\n"
		"	result.position = vertex.position;\n"
		"	result.texcoord0 = vertex.texcoord;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/debug_shadowmap.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2014 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2DArray samp0 : register(s0);\n"
		"\n"
		"struct PS_IN\n"
		"{\n"
		"	float4 position : VPOS;\n"
		"	float2 texcoord0 : TEXCOORD0_centroid;\n"
		"};\n"
		"\n"
		"struct PS_OUT\n"
		"{\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result )\n"
		"{\n"
		"	float3 tc;\n"
		"	tc.xy = fragment.texcoord0.xy;\n"
		"	tc.z = rpScreenCorrectionFactor.x; // layer\n"
		"\n"
		"	result.color = texture( samp0, tc );// * rpColor;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/debug_shadowmap.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord0 : TEXCOORD0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"\n"
		"	// compute oldschool texgen or multiply by texture matrix\n"
		"	BRANCH if ( rpTexGen0Enabled.x > 0.0 ) {\n"
		"		result.texcoord0.x = dot4( vertex.position, rpTexGen0S );\n"
		"		result.texcoord0.y = dot4( vertex.position, rpTexGen0T );\n"
		"	} else {\n"
		"		result.texcoord0.x = dot4( vertex.texcoord.xy, rpTextureMatrixS );\n"
		"		result.texcoord0.y = dot4( vertex.texcoord.xy, rpTextureMatrixT );\n"
		"	}\n"
		"}\n"
		
	},
	
	{
		"renderprogs/depth.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0);\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( out PS_OUT result ) {\n"
		"	result.color = float4( 0.0, 0.0, 0.0, 1.0 );\n"
		"}\n"
		
	},
	
	{
		"renderprogs/depth.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"}\n"
		
	},
	
	{
		"renderprogs/depth_skinned.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0);\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( out PS_OUT result ) {\n"
		"	result.color = float4( 0.0, 0.0, 0.0, 1.0 );\n"
		"}\n"
		
	},
	
	{
		"renderprogs/depth_skinned.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2014 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform matrices_ubo { float4 matrices[408]; };\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float4 color : COLOR0;\n"
		"	float4 color2 : COLOR1;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	//--------------------------------------------------------------\n"
		"	// GPU transformation of the normal / binormal / bitangent\n"
		"	//\n"
		"	// multiplying with 255.1 give us the same result and is faster than floor( w * 255 + 0.5 )\n"
		"	//--------------------------------------------------------------\n"
		"	const float w0 = vertex.color2.x;\n"
		"	const float w1 = vertex.color2.y;\n"
		"	const float w2 = vertex.color2.z;\n"
		"	const float w3 = vertex.color2.w;\n"
		"\n"
		"	float4 matX, matY, matZ;	// must be float4 for vec4\n"
		"	int joint = int(vertex.color.x * 255.1 * 3.0);\n"
		"	matX = matrices[int(joint+0)] * w0;\n"
		"	matY = matrices[int(joint+1)] * w0;\n"
		"	matZ = matrices[int(joint+2)] * w0;\n"
		"\n"
		"	joint = int(vertex.color.y * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w1;\n"
		"	matY += matrices[int(joint+1)] * w1;\n"
		"	matZ += matrices[int(joint+2)] * w1;\n"
		"\n"
		"	joint = int(vertex.color.z * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w2;\n"
		"	matY += matrices[int(joint+1)] * w2;\n"
		"	matZ += matrices[int(joint+2)] * w2;\n"
		"\n"
		"	joint = int(vertex.color.w * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w3;\n"
		"	matY += matrices[int(joint+1)] * w3;\n"
		"	matZ += matrices[int(joint+2)] * w3;\n"
		"\n"
		"	float4 modelPosition;\n"
		"	modelPosition.x = dot4( matX, vertex.position );\n"
		"	modelPosition.y = dot4( matY, vertex.position );\n"
		"	modelPosition.z = dot4( matZ, vertex.position );\n"
		"	modelPosition.w = 1.0;\n"
		"\n"
		"	result.position.x = dot4( modelPosition, rpMVPmatrixX );\n"
		"	result.position.y = dot4( modelPosition, rpMVPmatrixY );\n"
		"	result.position.z = dot4( modelPosition, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( modelPosition, rpMVPmatrixW );\n"
		"}\n"
		
	},
	
	{
		"renderprogs/enviroSuit.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"global.inc\"\n"
		"\n"
		"uniform sampler2D	samp0 : register(s0); // texture 0 is _current Render\n"
		"uniform sampler2D	samp1 : register(s1); // texture 1 is the per-surface bump map\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position		: VPOS;\n"
		"	float2 texcoord		: TEXCOORD0_centroid;\n"
		"	float4 color		: COLOR0;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"\n"
		"	float2 screenTexCoord = fragment.texcoord;\n"
		"	\n"
		"	// compute warp factor\n"
		"	float4 warpFactor = 1.0 - ( tex2D( samp1, screenTexCoord.xy ) * fragment.color );\n"
		"	screenTexCoord -= float2( 0.5, 0.5 );\n"
		"	screenTexCoord *= warpFactor.xy;\n"
		"	screenTexCoord += float2( 0.5, 0.5 );\n"
		"\n"
		"	// load the screen render\n"
		"	result.color = tex2D( samp0, screenTexCoord );\n"
		"\n"
		"}\n"
		
	},
	
	{
		"renderprogs/enviroSuit.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"global.inc\"\n"
		"\n"
		"// User Renderparms start at 128 as per renderprogs.h\n"
		"\n"
		"uniform float4 rpUser0 : register(c128); // rpScroll\n"
		"uniform	float4 rpUser1 : register(c129); // rpDeformMagnitude\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position		: POSITION;\n"
		"	float2 texcoord		: TEXCOORD0;\n"
		"	float4 color		: COLOR;\n"
		"};\n"
		"\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"	\n"
		"	result.texcoord = vertex.texcoord.xy;\n"
		"\n"
		"	const float4 deformMagnitude = rpUser1;\n"
		"	result.color = deformMagnitude;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/environment.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform samplerCUBE	samp0 : register(s0); // texture 0 is the cube map\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position		: VPOS;\n"
		"	float3 texcoord0	: TEXCOORD0_centroid;\n"
		"	float3 texcoord1	: TEXCOORD1_centroid;\n"
		"	float4 color		: COLOR0;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"\n"
		"	float3 globalNormal = normalize( fragment.texcoord1 );\n"
		"	float3 globalEye = normalize( fragment.texcoord0 );\n"
		"\n"
		"	float3 reflectionVector = _float3( dot3( globalEye, globalNormal ) );\n"
		"	reflectionVector *= globalNormal;\n"
		"	reflectionVector = ( reflectionVector * 2.0f ) - globalEye;\n"
		"\n"
		"	float4 envMap = texCUBE( samp0, reflectionVector );\n"
		"\n"
		"	result.color = float4( sRGBToLinearRGB( envMap.xyz ), 1.0f ) * fragment.color;\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/environment.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position		: POSITION;\n"
		"	float3 texcoord0	: TEXCOORD0;\n"
		"	float3 texcoord1	: TEXCOORD1;\n"
		"	float4 color		: COLOR0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"\n"
		"	float4 vNormal = vertex.normal * 2.0 - 1.0;\n"
		"\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"\n"
		"	float4 toEye = rpLocalViewOrigin - vertex.position;\n"
		"\n"
		"	result.texcoord0 = toEye.xyz;\n"
		"	result.texcoord1 = vNormal.xyz;\n"
		"\n"
		"	result.color = sRGBAToLinearRGBA( rpColor );\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/environment_skinned.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform samplerCUBE	samp0 : register(s0); // texture 0 is the cube map\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position		: VPOS;\n"
		"	float3 texcoord0	: TEXCOORD0_centroid;\n"
		"	float3 texcoord1	: TEXCOORD1_centroid;\n"
		"	float4 color		: COLOR0;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"\n"
		"	float3 globalNormal = normalize( fragment.texcoord1 );\n"
		"	float3 globalEye = normalize( fragment.texcoord0 );\n"
		"\n"
		"	float3 reflectionVector = _float3( dot3( globalEye, globalNormal ) );\n"
		"	reflectionVector *= globalNormal;\n"
		"	reflectionVector = ( reflectionVector * 2.0f ) - globalEye;\n"
		"\n"
		"	float4 envMap = texCUBE( samp0, reflectionVector );\n"
		"\n"
		"	result.color = float4( sRGBToLinearRGB( envMap.xyz ), 1.0f ) * fragment.color;\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/environment_skinned.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2014 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform matrices_ubo { float4 matrices[408]; };\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 color : COLOR0;\n"
		"	float4 color2 : COLOR1;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position		: POSITION;\n"
		"	float3 texcoord0	: TEXCOORD0;\n"
		"	float3 texcoord1	: TEXCOORD1;\n"
		"	float4 color		: COLOR0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	float4 vNormal = vertex.normal * 2.0 - 1.0;\n"
		"\n"
		"	//--------------------------------------------------------------\n"
		"	// GPU transformation of the normal / binormal / bitangent\n"
		"	//\n"
		"	// multiplying with 255.1 give us the same result and is faster than floor( w * 255 + 0.5 )\n"
		"	//--------------------------------------------------------------\n"
		"	const float w0 = vertex.color2.x;\n"
		"	const float w1 = vertex.color2.y;\n"
		"	const float w2 = vertex.color2.z;\n"
		"	const float w3 = vertex.color2.w;\n"
		"\n"
		"	float4 matX, matY, matZ;	// must be float4 for vec4\n"
		"	int joint = int(vertex.color.x * 255.1 * 3.0);\n"
		"	matX = matrices[int(joint+0)] * w0;\n"
		"	matY = matrices[int(joint+1)] * w0;\n"
		"	matZ = matrices[int(joint+2)] * w0;\n"
		"\n"
		"	joint = int(vertex.color.y * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w1;\n"
		"	matY += matrices[int(joint+1)] * w1;\n"
		"	matZ += matrices[int(joint+2)] * w1;\n"
		"\n"
		"	joint = int(vertex.color.z * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w2;\n"
		"	matY += matrices[int(joint+1)] * w2;\n"
		"	matZ += matrices[int(joint+2)] * w2;\n"
		"\n"
		"	joint = int(vertex.color.w * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w3;\n"
		"	matY += matrices[int(joint+1)] * w3;\n"
		"	matZ += matrices[int(joint+2)] * w3;\n"
		"\n"
		"	float3 vNormalSkinned;\n"
		"	vNormalSkinned.x = dot3( matX, vNormal );\n"
		"	vNormalSkinned.y = dot3( matY, vNormal );\n"
		"	vNormalSkinned.z = dot3( matZ, vNormal );\n"
		"	vNormalSkinned = normalize( vNormalSkinned );\n"
		"\n"
		"	float4 modelPosition;\n"
		"	modelPosition.x = dot4( matX, vertex.position );\n"
		"	modelPosition.y = dot4( matY, vertex.position );\n"
		"	modelPosition.z = dot4( matZ, vertex.position );\n"
		"	modelPosition.w = 1.0;\n"
		"\n"
		"	result.position.x = dot4( modelPosition, rpMVPmatrixX );\n"
		"	result.position.y = dot4( modelPosition, rpMVPmatrixY );\n"
		"	result.position.z = dot4( modelPosition, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( modelPosition, rpMVPmatrixW );\n"
		"\n"
		"	float4 toEye = rpLocalViewOrigin - modelPosition;\n"
		"\n"
		"	result.texcoord0 = toEye.xyz;\n"
		"	result.texcoord1 = vNormalSkinned.xyz;\n"
		"\n"
		"	result.color = rpColor;\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/fog.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0);\n"
		"uniform sampler2D samp1 : register(s1);\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position : VPOS;\n"
		"	float2 texcoord0 : TEXCOORD0_centroid;\n"
		"	float2 texcoord1 : TEXCOORD1_centroid;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"	result.color = tex2D( samp0, fragment.texcoord0 ) * tex2D( samp1, fragment.texcoord1 ) * sRGBAToLinearRGBA( rpColor );\n"
		"}\n"
		"\n"
		"\n"
		
	},
	
	{
		"renderprogs/fog.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord0 : TEXCOORD0;\n"
		"	float2 texcoord1 : TEXCOORD1;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"\n"
		"	result.texcoord0.x = dot4( vertex.position, rpTexGen0S );\n"
		"	result.texcoord0.y = dot4( vertex.position, rpTexGen0T );\n"
		"\n"
		"	result.texcoord1.x = dot4( vertex.position, rpTexGen1S );\n"
		"	result.texcoord1.y = dot4( vertex.position, rpTexGen1T );\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/fog_skinned.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0);\n"
		"uniform sampler2D samp1 : register(s1);\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position : VPOS;\n"
		"	float2 texcoord0 : TEXCOORD0_centroid;\n"
		"	float2 texcoord1 : TEXCOORD1_centroid;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"	result.color = tex2D( samp0, fragment.texcoord0 ) * tex2D( samp1, fragment.texcoord1 ) * sRGBAToLinearRGBA( rpColor );\n"
		"}\n"
		"\n"
		"\n"
		
	},
	
	{
		"renderprogs/fog_skinned.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2014 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform matrices_ubo { float4 matrices[408]; };\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 color : COLOR0;\n"
		"	float4 color2 : COLOR1;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord0 : TEXCOORD0;\n"
		"	float2 texcoord1 : TEXCOORD1;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	//--------------------------------------------------------------\n"
		"	// GPU transformation of the normal / binormal / bitangent\n"
		"	//\n"
		"	// multiplying with 255.1 give us the same result and is faster than floor( w * 255 + 0.5 )\n"
		"	//--------------------------------------------------------------\n"
		"	const float w0 = vertex.color2.x;\n"
		"	const float w1 = vertex.color2.y;\n"
		"	const float w2 = vertex.color2.z;\n"
		"	const float w3 = vertex.color2.w;\n"
		"\n"
		"	float4 matX, matY, matZ;	// must be float4 for vec4\n"
		"	int joint = int(vertex.color.x * 255.1 * 3.0);\n"
		"	matX = matrices[int(joint+0)] * w0;\n"
		"	matY = matrices[int(joint+1)] * w0;\n"
		"	matZ = matrices[int(joint+2)] * w0;\n"
		"\n"
		"	joint = int(vertex.color.y * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w1;\n"
		"	matY += matrices[int(joint+1)] * w1;\n"
		"	matZ += matrices[int(joint+2)] * w1;\n"
		"\n"
		"	joint = int(vertex.color.z * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w2;\n"
		"	matY += matrices[int(joint+1)] * w2;\n"
		"	matZ += matrices[int(joint+2)] * w2;\n"
		"\n"
		"	joint = int(vertex.color.w * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w3;\n"
		"	matY += matrices[int(joint+1)] * w3;\n"
		"	matZ += matrices[int(joint+2)] * w3;\n"
		"\n"
		"	float4 modelPosition;\n"
		"	modelPosition.x = dot4( matX, vertex.position );\n"
		"	modelPosition.y = dot4( matY, vertex.position );\n"
		"	modelPosition.z = dot4( matZ, vertex.position );\n"
		"	modelPosition.w = 1.0;\n"
		"	// end of skinning\n"
		"\n"
		"	// start of fog portion\n"
		"	result.position.x = dot4( modelPosition, rpMVPmatrixX );\n"
		"	result.position.y = dot4( modelPosition, rpMVPmatrixY );\n"
		"	result.position.z = dot4( modelPosition, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( modelPosition, rpMVPmatrixW );\n"
		"\n"
		"	result.texcoord0.x = dot4( modelPosition, rpTexGen0S );\n"
		"	result.texcoord0.y = dot4( modelPosition, rpTexGen0T );\n"
		"\n"
		"	result.texcoord1.x = dot4( modelPosition, rpTexGen1S );\n"
		"	result.texcoord1.y = dot4( modelPosition, rpTexGen1T );\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/fxaa.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"#define FXAA_GREEN_AS_LUMA 1\n"
		"#define FXAA_EARLY_EXIT 0\n"
		"#include \"Fxaa3_11.h\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0);\n"
		"uniform sampler2D samp1 : register(s1); // exponent bias -1\n"
		"uniform sampler2D samp2 : register(s2); // exponent bias -2\n"
		"\n"
		"uniform float4 rpUser0 : register( c128 );\n"
		"uniform float4 rpUser1 : register( c129 );\n"
		"uniform float4 rpUser2 : register( c130 );\n"
		"uniform float4 rpUser3 : register( c131 );\n"
		"uniform float4 rpUser4 : register( c132 );\n"
		"uniform float4 rpUser5 : register( c133 );\n"
		"uniform float4 rpUser6 : register( c134 );\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position : VPOS;\n"
		"	float2 texcoord0 : TEXCOORD0_centroid;\n"
		"};\n"
		"\n"
		"struct PS_OUT {	\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"\n"
		"	const float4 FXAAQualityRCPFrame = rpUser0;\n"
		"	const float4 FXAAConsoleRcpFrameOpt = rpUser1;\n"
		"	const float4 FXAAConsoleRcpFrameOpt2 = rpUser2;\n"
		"	const float4 FXAAConsole360RcpFrameOpt2 = rpUser3;\n"
		"	const float4 FXAAQualityParms = rpUser4;\n"
		"	const float4 FXAAConsoleEdgeParms = rpUser5;\n"
		"	const float4 FXAAConsole360ConstDir = rpUser6;\n"
		"\n"
		"	// Inputs - see more info in fxaa3_11.hfile\n"
		"	FxaaFloat2	fxaaPos = fragment.texcoord0;\n"
		"	FxaaFloat4	fxaaConsolePos;\n"
		"\n"
		"	float2 halfPixelOffset = float2( 0.5, 0.5 ) * FXAAQualityRCPFrame.xy;\n"
		"	fxaaConsolePos.xy = fxaaPos.xy - ( halfPixelOffset );\n"
		"	fxaaConsolePos.zw = fxaaPos.xy + ( halfPixelOffset );\n"
		"	FxaaFloat2	fxaaQualityRcpFrame = FXAAQualityRCPFrame.xy;\n"
		"	FxaaFloat4	fxaaConsoleRcpFrameOpt = FXAAConsoleRcpFrameOpt;\n"
		"	FxaaFloat4	fxaaConsoleRcpFrameOpt2 = FXAAConsoleRcpFrameOpt2;\n"
		"	FxaaFloat4	fxaaConsole360RcpFrameOpt2 = FXAAConsole360RcpFrameOpt2;\n"
		"\n"
		"	// Quality parms\n"
		"	FxaaFloat	fxaaQualitySubpix = FXAAQualityParms.x;\n"
		"	FxaaFloat	fxaaQualityEdgeThreshold = FXAAQualityParms.y;\n"
		"	FxaaFloat	fxaaQualityEdgeThresholdMin = FXAAQualityParms.z;\n"
		"\n"
		"	// Console specific Parms\n"
		"	FxaaFloat	fxaaConsoleEdgeSharpness = FXAAConsoleEdgeParms.x;\n"
		"	FxaaFloat	fxaaConsoleEdgeThreshold = FXAAConsoleEdgeParms.y;\n"
		"	FxaaFloat	fxaaConsoleEdgeThresholdMin = FXAAConsoleEdgeParms.z;\n"
		"\n"
		"	// 360 specific parms these have to come from a constant register so that the compiler\n"
		"	// does not unoptimize the shader\n"
		"	FxaaFloat4	fxaaConsole360ConstDir = FXAAConsole360ConstDir;\n"
		"\n"
		"\n"
		"	float4 colorSample = FxaaPixelShader(	fxaaPos,\n"
		"											fxaaConsolePos,\n"
		"											samp0,\n"
		"											samp1,\n"
		"											samp2,\n"
		"											fxaaQualityRcpFrame,\n"
		"											fxaaConsoleRcpFrameOpt,\n"
		"											fxaaConsoleRcpFrameOpt2,\n"
		"											fxaaConsole360RcpFrameOpt2,\n"
		"											fxaaQualitySubpix,\n"
		"											fxaaQualityEdgeThreshold,\n"
		"											fxaaQualityEdgeThresholdMin,\n"
		"											fxaaConsoleEdgeSharpness,\n"
		"											fxaaConsoleEdgeThreshold,\n"
		"											fxaaConsoleEdgeThresholdMin,\n"
		"											fxaaConsole360ConstDir );\n"
		"											\n"
		"	result.color = colorSample;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/fxaa.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord0 : TEXCOORD0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position = vertex.position;\n"
		"	result.texcoord0 =  vertex.texcoord;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/gbuffer.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2016 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D	samp0 : register(s0); // normal map\n"
		"\n"
		"struct PS_IN\n"
		"{\n"
		"	float4 position		: VPOS;\n"
		"	float2 texcoord0	: TEXCOORD0_centroid;\n"
		"	float3 texcoord1	: TEXCOORD1_centroid;\n"
		"	float3 texcoord2	: TEXCOORD2_centroid;\n"
		"	float3 texcoord3	: TEXCOORD3_centroid;\n"
		"	float3 texcoord4	: TEXCOORD4_centroid;\n"
		"	float4 color		: COLOR0;\n"
		"};\n"
		"\n"
		"struct PS_OUT\n"
		"{\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result )\n"
		"{\n"
		"	float4 bump = tex2D( samp0, fragment.texcoord0 ) * 2.0f - 1.0f;\n"
		"	\n"
		"	// RB begin\n"
		"	float3 localNormal;\n"
		"#if defined(USE_NORMAL_FMT_RGB8)\n"
		"	localNormal = float3( bump.rg, 0.0f );\n"
		"#else\n"
		"	localNormal = float3( bump.wy, 0.0f );\n"
		"#endif\n"
		"	// RB end\n"
		"	localNormal.z = sqrt( 1.0f - dot3( localNormal, localNormal ) );\n"
		"\n"
		"	float3 globalNormal;\n"
		"#if 1\n"
		"	globalNormal.x = dot3( localNormal, fragment.texcoord2 );\n"
		"	globalNormal.y = dot3( localNormal, fragment.texcoord3 );\n"
		"	globalNormal.z = dot3( localNormal, fragment.texcoord4 );\n"
		"#else\n"
		"	// only the normal in view space\n"
		"	globalNormal.x = fragment.texcoord2.z;\n"
		"	globalNormal.y = fragment.texcoord3.z;\n"
		"	globalNormal.z = fragment.texcoord4.z;\n"
		"	//globalNormal.z = fragment.texcoord4.z * -0.001; //sqrt( abs( dot( globalNormal.xy, globalNormal.xy ) - 0.25 ) );\n"
		"	globalNormal = normalize( globalNormal );\n"
		"#endif\n"
		"\n"
		"	// RB: rpColor is white and only used to generate the _fa_ uniform array\n"
		"	result.color.rgb = ( globalNormal.xyz * 0.5 + 0.5 ) * fragment.color.rgb;// * rpColor;\n"
		"	//result.color.rgb = ( globalNormal.xyz );// * fragment.color.rgb;// * rpColor;\n"
		"	result.color.a = 1.0;\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/gbuffer.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2016 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"#if defined( USE_GPU_SKINNING )\n"
		"uniform matrices_ubo { float4 matrices[408]; };\n"
		"#endif\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"	float4 color2 : COLOR1;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position		: POSITION;\n"
		"	float2 texcoord0	: TEXCOORD0;\n"
		"	float3 texcoord1	: TEXCOORD1;\n"
		"	float3 texcoord2	: TEXCOORD2;\n"
		"	float3 texcoord3	: TEXCOORD3;\n"
		"	float3 texcoord4	: TEXCOORD4;\n"
		"	float4 color		: COLOR0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	\n"
		"	float4 vNormal = vertex.normal * 2.0 - 1.0;\n"
		"	float4 vTangent = vertex.tangent * 2.0 - 1.0;\n"
		"	float3 vBitangent = cross( vNormal.xyz, vTangent.xyz ) * vTangent.w;\n"
		"\n"
		"#if defined( USE_GPU_SKINNING )\n"
		"	//--------------------------------------------------------------\n"
		"	// GPU transformation of the normal / tangent / bitangent\n"
		"	//\n"
		"	// multiplying with 255.1 give us the same result and is faster than floor( w * 255 + 0.5 )\n"
		"	//--------------------------------------------------------------\n"
		"	const float w0 = vertex.color2.x;\n"
		"	const float w1 = vertex.color2.y;\n"
		"	const float w2 = vertex.color2.z;\n"
		"	const float w3 = vertex.color2.w;\n"
		"\n"
		"	float4 matX, matY, matZ;	// must be float4 for vec4\n"
		"	int joint = int(vertex.color.x * 255.1 * 3.0);\n"
		"	matX = matrices[int(joint+0)] * w0;\n"
		"	matY = matrices[int(joint+1)] * w0;\n"
		"	matZ = matrices[int(joint+2)] * w0;\n"
		"\n"
		"	joint = int(vertex.color.y * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w1;\n"
		"	matY += matrices[int(joint+1)] * w1;\n"
		"	matZ += matrices[int(joint+2)] * w1;\n"
		"\n"
		"	joint = int(vertex.color.z * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w2;\n"
		"	matY += matrices[int(joint+1)] * w2;\n"
		"	matZ += matrices[int(joint+2)] * w2;\n"
		"\n"
		"	joint = int(vertex.color.w * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w3;\n"
		"	matY += matrices[int(joint+1)] * w3;\n"
		"	matZ += matrices[int(joint+2)] * w3;\n"
		"\n"
		"	float3 normal;\n"
		"	normal.x = dot3( matX, vNormal );\n"
		"	normal.y = dot3( matY, vNormal );\n"
		"	normal.z = dot3( matZ, vNormal );\n"
		"	normal = normalize( normal );\n"
		"\n"
		"	float3 tangent;\n"
		"	tangent.x = dot3( matX, vTangent );\n"
		"	tangent.y = dot3( matY, vTangent );\n"
		"	tangent.z = dot3( matZ, vTangent );\n"
		"	tangent = normalize( tangent );\n"
		"\n"
		"	float3 bitangent;\n"
		"	bitangent.x = dot3( matX, vBitangent );\n"
		"	bitangent.y = dot3( matY, vBitangent );\n"
		"	bitangent.z = dot3( matZ, vBitangent );\n"
		"	bitangent = normalize( bitangent );\n"
		"\n"
		"	float4 modelPosition;\n"
		"	modelPosition.x = dot4( matX, vertex.position );\n"
		"	modelPosition.y = dot4( matY, vertex.position );\n"
		"	modelPosition.z = dot4( matZ, vertex.position );\n"
		"	modelPosition.w = 1.0;\n"
		"\n"
		"#else\n"
		"	float4 modelPosition = vertex.position;\n"
		"	float3 normal = vNormal.xyz;\n"
		"	float3 tangent = vTangent.xyz;\n"
		"	float3 bitangent = vBitangent.xyz;\n"
		"#endif\n"
		"\n"
		"	result.position.x = dot4( modelPosition, rpMVPmatrixX );\n"
		"	result.position.y = dot4( modelPosition, rpMVPmatrixY );\n"
		"	result.position.z = dot4( modelPosition, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( modelPosition, rpMVPmatrixW );\n"
		"\n"
		"	// textures 0 takes the base coordinates by the texture matrix\n"
		"	result.texcoord0.x = dot4( vertex.texcoord.xy, rpBumpMatrixS );\n"
		"	result.texcoord0.y = dot4( vertex.texcoord.xy, rpBumpMatrixT );\n"
		"\n"
		"	//float4 toEye = rpLocalViewOrigin - modelPosition;\n"
		"	//result.texcoord1.x = dot3( toEye, rpModelMatrixX );\n"
		"	//result.texcoord1.y = dot3( toEye, rpModelMatrixY );\n"
		"	//result.texcoord1.z = dot3( toEye, rpModelMatrixZ );\n"
		"\n"
		"#if 0\n"
		"	// rotate into world space\n"
		"	result.texcoord2.x = dot3( tangent, rpModelMatrixX );\n"
		"	result.texcoord3.x = dot3( tangent, rpModelMatrixY );\n"
		"	result.texcoord4.x = dot3( tangent, rpModelMatrixZ );\n"
		"\n"
		"	result.texcoord2.y = dot3( bitangent, rpModelMatrixX );\n"
		"	result.texcoord3.y = dot3( bitangent, rpModelMatrixY );\n"
		"	result.texcoord4.y = dot3( bitangent, rpModelMatrixZ );\n"
		"\n"
		"	result.texcoord2.z = dot3( normal, rpModelMatrixX );\n"
		"	result.texcoord3.z = dot3( normal, rpModelMatrixY );\n"
		"	result.texcoord4.z = dot3( normal, rpModelMatrixZ );	\n"
		"	\n"
		"#else\n"
		"	// rotate into view space\n"
		"	result.texcoord2.x = dot3( tangent, rpModelViewMatrixX );\n"
		"	result.texcoord3.x = dot3( tangent, rpModelViewMatrixY );\n"
		"	result.texcoord4.x = dot3( tangent, rpModelViewMatrixZ );\n"
		"\n"
		"	result.texcoord2.y = dot3( bitangent, rpModelViewMatrixX );\n"
		"	result.texcoord3.y = dot3( bitangent, rpModelViewMatrixY );\n"
		"	result.texcoord4.y = dot3( bitangent, rpModelViewMatrixZ );\n"
		"\n"
		"	result.texcoord2.z = dot3( normal, rpModelViewMatrixX );\n"
		"	result.texcoord3.z = dot3( normal, rpModelViewMatrixY );\n"
		"	result.texcoord4.z = dot3( normal, rpModelViewMatrixZ );	\n"
		"#endif\n"
		"\n"
		"#if defined( USE_GPU_SKINNING )\n"
		"	// for joint transformation of the tangent space, we use color and\n"
		"	// color2 for weighting information, so hopefully there aren't any\n"
		"	// effects that need vertex color...\n"
		"	result.color = float4( 1.0f, 1.0f, 1.0f, 1.0f );\n"
		"#else\n"
		"	//# generate the vertex color, which can be 1.0, color, or 1.0 - color\n"
		"	//# for 1.0 : env[16] = 0, env[17] = 1\n"
		"	//# for color : env[16] = 1, env[17] = 0\n"
		"	//# for 1.0-color : env[16] = -1, env[17] = 1	\n"
		"	result.color = ( swizzleColor( vertex.color ) * rpVertexColorModulate ) + rpVertexColorAdd;\n"
		"#endif\n"
		"}\n"
		
	},
	
	{
		"renderprogs/gui.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0);\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position : VPOS;\n"
		"	float2 texcoord0 : TEXCOORD0_centroid;\n"
		"	float4 texcoord1 : TEXCOORD1_centroid;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"	float4 color = ( tex2D( samp0, fragment.texcoord0 ) * fragment.color ) + fragment.texcoord1;\n"
		"	result.color.xyz = color.xyz * color.w;\n"
		"	result.color.w = color.w;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/gui.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2013 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"	float4 color2 : COLOR1;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord0 : TEXCOORD0;\n"
		"	float4 texcoord1 : TEXCOORD1;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"\n"
		"	result.texcoord0.xy = vertex.texcoord.xy;\n"
		"	result.texcoord1 = ( ( vertex.color2 ) * 2.0 ) - 1.0;\n"
		"	result.color =  swizzleColor( vertex.color );\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/hdr_glare_chromatic.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2014-2015 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D samp0		: register(s0);\n"
		"\n"
		"struct PS_IN\n"
		"{\n"
		"	float4 position : VPOS;\n"
		"	float2 texcoord0 : TEXCOORD0_centroid;\n"
		"};\n"
		"\n"
		"struct PS_OUT\n"
		"{\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"float linterp( float t )\n"
		"{\n"
		"	return saturate( 1.0 - abs( 2.0 * t - 1.0 ) );\n"
		"}\n"
		"\n"
		"float remap( float t, float a, float b )\n"
		"{\n"
		"	return saturate( ( t - a ) / ( b - a ) );\n"
		"}\n"
		"\n"
		"float3 spectrumoffset( float t )\n"
		"{\n"
		"	float lo = step( t, 0.5 );\n"
		"	float hi = 1.0 - lo;\n"
		"	float w = linterp( remap( t, 1.0 / 6.0, 5.0 / 6.0 ) );\n"
		"	float3 ret = float3( lo, 1.0, hi ) * float3( 1.0 - w, w, 1.0 - w );\n"
		"\n"
		"	return ret; // pow( ret, float3( 1.0 / 2.2 ) );\n"
		"}\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result )\n"
		"{\n"
		"	float2 st = fragment.texcoord0;\n"
		"	\n"
		"	// base color with tone mapping applied\n"
		"	float4 color = tex2D( samp0, st );\n"
		"	\n"
		"	const float gaussFact[9] = float[9](0.13298076, 0.12579441, 0.10648267, 0.08065691, 0.05467002, 0.03315905, 0.01799699, 0.00874063, 0.00379866);\n"
		"	\n"
		"	const float3 chromaticOffsets[9] = float3[](\n"
		"	float3(0.5, 0.5, 0.5), // w\n"
		"	float3(0.8, 0.3, 0.3),\n"
		"//	float3(1.0, 0.2, 0.2), // r\n"
		"	float3(0.5, 0.2, 0.8),\n"
		"	float3(0.2, 0.2, 1.0), // b\n"
		"	float3(0.2, 0.3, 0.9),\n"
		"	float3(0.2, 0.9, 0.2), // g\n"
		"	float3(0.3, 0.5, 0.3),\n"
		"	float3(0.3, 0.5, 0.3),\n"
		"	float3(0.3, 0.5, 0.3)\n"
		"	//float3(0.3, 0.5, 0.3)\n"
		"	);\n"
		"	\n"
		"	float3 sumColor = float3( 0.0 );\n"
		"	float3 sumSpectrum = float3( 0.0 );\n"
		"\n"
		"	const int tap = 4;\n"
		"	const int samples = 9;\n"
		"	\n"
		"	float scale = 13.0; // bloom width\n"
		"	const float weightScale = 2.3; // bloom strength\n"
		"	\n"
		"	for( int i = 0; i < samples; i++ )\n"
		"    {\n"
		"	    //float t = ( ( float( 4 + ( i ) ) ) / ( float( samples ) - 1.0 ) );\n"
		"		//float t = log2( float( i ) / ( float( samples ) - 1.0 ) );\n"
		"		//float t = ( float( i ) / ( float( samples ) - 1.0 ) );\n"
		"		\n"
		"		//float3 so = spectrumoffset( t );\n"
		"		float3 so = chromaticOffsets[ i ];\n"
		"		float4 color = tex2D( samp0, st + float2( float( i ), 0 ) * rpWindowCoord.xy * scale );\n"
		"			\n"
		"		float weight = gaussFact[ i ];\n"
		"		sumColor += color.rgb * ( so.rgb * weight * weightScale );\n"
		"	}\n"
		"	\n"
		"#if 1\n"
		"	for( int i = 1; i < samples; i++ )\n"
		"    {\n"
		"	    //float t = ( ( float( 4 + ( i ) ) ) / ( float( samples ) - 1.0 ) );\n"
		"		\n"
		"		//float3 so = spectrumoffset( t );\n"
		"		float3 so = chromaticOffsets[ i ];\n"
		"		float4 color = tex2D( samp0, st + float2( float( -i ), 0 ) * rpWindowCoord.xy * scale );\n"
		"			\n"
		"		float weight = gaussFact[ i ];\n"
		"		sumColor += color.rgb * ( so.rgb * weight * weightScale );\n"
		"	}\n"
		"#endif\n"
		"	\n"
		"	result.color = float4( sumColor, 1.0 );\n"
		"	//result.color = float4( sumColor / float(samples), 1.0 );\n"
		"	//result.color = float4( sumColor / sumSpectrum, 1.0 );\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/hdr_glare_chromatic.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord0 : TEXCOORD0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position = vertex.position;\n"
		"\n"
		"	//result.position.x = vertex.position; //dot4( vertex.position, rpMVPmatrixX );\n"
		"	//result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	//result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	//result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"	result.texcoord0 =  vertex.texcoord;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/heatHazeWithMask.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"global.inc\"\n"
		"\n"
		"uniform sampler2D	samp0 : register(s0); // texture 0 is _current Render\n"
		"uniform sampler2D	samp1 : register(s1); // texture 1 is the per-surface bump map\n"
		"uniform sampler2D	samp2 : register(s2); // texture 2 is the mask texture\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position		: VPOS;\n"
		"	float4 texcoord0	: TEXCOORD0_centroid;\n"
		"	float4 texcoord1	: TEXCOORD1_centroid;\n"
		"	float4 texcoord2	: TEXCOORD2_centroid;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"\n"
		"	// load the distortion map\n"
		"	float4 mask = tex2D( samp2, fragment.texcoord0.xy );\n"
		"\n"
		"	// kill the pixel if the distortion wound up being very small\n"
		"	mask.xy -= 0.01f;\n"
		"	clip( mask );\n"
		"\n"
		"	// load the filtered normal map and convert to -1 to 1 range\n"
		"	float4 bumpMap = ( tex2D( samp1, fragment.texcoord1.xy ) * 2.0f ) - 1.0f;\n"
		"	float2 localNormal = bumpMap.wy;\n"
		"	localNormal *= mask.xy;\n"
		"\n"
		"	// calculate the screen texcoord in the 0.0 to 1.0 range\n"
		"	float2 screenTexCoord = vposToScreenPosTexCoord( fragment.position.xy );\n"
		"	screenTexCoord += ( localNormal * fragment.texcoord2.xy );\n"
		"	screenTexCoord = saturate( screenTexCoord );\n"
		"\n"
		"	result.color = ( tex2D( samp0, screenTexCoord ) );\n"
		"}\n"
		
	},
	
	{
		"renderprogs/heatHazeWithMask.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company.\n"
		"Copyright (C) 2013 Robert Beckebans \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"global.inc\"\n"
		"\n"
		"// RB: no GPU skinning with ES 2.0\n"
		"#if defined(USE_GPU_SKINNING)\n"
		"uniform matrices_ubo { float4 matrices[408]; };\n"
		"#endif\n"
		"// RB end\n"
		"\n"
		"uniform float4 rpUser0 : register(c128); // rpScroll\n"
		"uniform	float4 rpUser1 : register(c129); // rpDeformMagnitude\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"	float4 color2 : COLOR1;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position		: POSITION;\n"
		"	float4 texcoord0	: TEXCOORD0;\n"
		"	float4 texcoord1	: TEXCOORD1;\n"
		"	float4 texcoord2	: TEXCOORD2;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"\n"
		"	#include \"skinning.inc\"\n"
		"\n"
		"	// texture 0 takes the texture coordinates unmodified\n"
		"	result.texcoord0 = float4( vertex.texcoord.xy, 0, 0 );\n"
		"\n"
		"	// texture 1 takes the texture coordinates and adds a scroll\n"
		"	const float4 textureScroll = rpUser0;\n"
		"	result.texcoord1 = float4( vertex.texcoord.xy, 0, 0 ) + textureScroll;\n"
		"\n"
		"	// texture 2 takes the deform magnitude and scales it by the projection distance\n"
		"	float4 vec = float4( 0, 1, 0, 1 );\n"
		"	vec.z  = dot4( modelPosition, rpModelViewMatrixZ );\n"
		"\n"
		"	// magicProjectionAdjust is a magic scalar that scales the projection since we changed from \n"
		"	// using the X axis to the Y axis to calculate R1.  It is an approximation to closely match \n"
		"	// what the original game did\n"
		"	const float magicProjectionAdjust = 0.43f;\n"
		"	float x = dot4 ( vec, rpProjectionMatrixY ) * magicProjectionAdjust;\n"
		"	float w = dot4 ( vec, rpProjectionMatrixW );\n"
		"\n"
		"	// don't let the recip get near zero for polygons that cross the view plane\n"
		"	w = max( w, 1.0 );\n"
		"	x /= w;\n"
		"	//x = x * ( 1.0f / ( w + 0.00001f ) );\n"
		"\n"
		"	// clamp the distance so the the deformations don't get too wacky near the view\n"
		"	x = min( x, 0.02 );\n"
		"\n"
		"	const float4 deformMagnitude = rpUser1;\n"
		"	result.texcoord2 = x * deformMagnitude;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/heatHazeWithMaskAndVertex.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"global.inc\"\n"
		"\n"
		"uniform sampler2D	samp0 : register(s0); // texture 0 is _current Render\n"
		"uniform sampler2D	samp1 : register(s1); // texture 1 is the per-surface bump map\n"
		"uniform sampler2D	samp2 : register(s2); // texture 2 is the mask texture\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position		: VPOS;\n"
		"	float4 texcoord0	: TEXCOORD0_centroid;\n"
		"	float4 texcoord1	: TEXCOORD1_centroid;\n"
		"	float4 texcoord2	: TEXCOORD2_centroid;\n"
		"	float4 color		: COLOR0;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"\n"
		"	// load the distortion map\n"
		"	float4 mask = tex2D( samp2, fragment.texcoord0.xy );\n"
		"\n"
		"	// kill the pixel if the distortion wound up being very small\n"
		"	mask.xy *= fragment.color.xy;\n"
		"	mask.xy -= 0.01f;\n"
		"	clip( mask );\n"
		"\n"
		"	// load the filtered normal map and convert to -1 to 1 range\n"
		"	float4 bumpMap = ( tex2D( samp1, fragment.texcoord1.xy ) * 2.0f ) - 1.0f;\n"
		"	float2 localNormal = bumpMap.wy;\n"
		"	localNormal *= mask.xy;\n"
		"\n"
		"	// calculate the screen texcoord in the 0.0 to 1.0 range\n"
		"	float2 screenTexCoord = vposToScreenPosTexCoord( fragment.position.xy );\n"
		"	screenTexCoord += ( localNormal * fragment.texcoord2.xy );\n"
		"	screenTexCoord = saturate( screenTexCoord );\n"
		"\n"
		"	result.color = ( tex2D( samp0, screenTexCoord ) );\n"
		"}\n"
		
	},
	
	{
		"renderprogs/heatHazeWithMaskAndVertex.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2013 Robert Beckebans \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"global.inc\"\n"
		"\n"
		"// RB: no GPU skinning with ES 2.0\n"
		"#if defined(USE_GPU_SKINNING)\n"
		"uniform matrices_ubo { float4 matrices[408]; };\n"
		"#endif\n"
		"// RB end\n"
		"\n"
		"uniform float4 rpUser0 : register(c128); // rpScroll\n"
		"uniform	float4 rpUser1 : register(c129); // rpDeformMagnitude\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"	float4 color2 : COLOR1;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position		: POSITION;\n"
		"	float4 texcoord0	: TEXCOORD0;\n"
		"	float4 texcoord1	: TEXCOORD1;\n"
		"	float4 texcoord2	: TEXCOORD2;\n"
		"	float4 color		: COLOR0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"\n"
		"	#include \"skinning.inc\"\n"
		"\n"
		"	// texture 0 takes the texture coordinates unmodified\n"
		"	result.texcoord0 = float4( vertex.texcoord, 0 , 0 );\n"
		"\n"
		"	// texture 1 takes the texture coordinates and adds a scroll\n"
		"	const float4 textureScroll = rpUser0;\n"
		"	result.texcoord1 = float4( vertex.texcoord, 0, 0 ) + textureScroll;\n"
		"\n"
		"	// texture 2 takes the deform magnitude and scales it by the projection distance\n"
		"	float4 vec = float4( 0, 1, 0, 1 );\n"
		"	vec.z = dot4( modelPosition, rpModelViewMatrixZ );\n"
		"\n"
		"	// magicProjectionAdjust is a magic scalar that scales the projection since we changed from \n"
		"	// using the X axis to the Y axis to calculate x.  It is an approximation to closely match \n"
		"	// what the original game did\n"
		"	const float magicProjectionAdjust = 0.43f;\n"
		"	float x = dot4 ( vec, rpProjectionMatrixY ) * magicProjectionAdjust;\n"
		"	float w = dot4( vec, rpProjectionMatrixW );\n"
		"\n"
		"	// don't let the recip get near zero for polygons that cross the view plane\n"
		"	w = max( w, 1.0f );\n"
		"	x /= w;\n"
		"	//x = x * ( 1.0f / w );\n"
		"\n"
		"	// clamp the distance so the the deformations don't get too wacky near the view\n"
		"	x = min( x, 0.02f );\n"
		"\n"
		"	const float4 deformMagnitude = rpUser1;\n"
		"	result.texcoord2 = x * deformMagnitude;\n"
		"	result.color = swizzleColor( vertex.color );\n"
		"}\n"
		
	},
	
	{
		"renderprogs/heathaze.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company.\n"
		"Copyright (C) 2013-2014 Robert Beckebans \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"global.inc\"\n"
		"\n"
		"uniform sampler2D	samp0 : register(s0); // texture 0 is _current Render\n"
		"uniform sampler2D	samp1 : register(s1); // texture 1 is the per-surface bump map\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position		: VPOS;\n"
		"	float4 texcoord0	: TEXCOORD0_centroid;\n"
		"	float4 texcoord1	: TEXCOORD1_centroid;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"\n"
		"	// load the filtered normal map and convert to -1 to 1 range\n"
		"	float4 bumpMap = ( tex2D( samp1, fragment.texcoord0.xy ) * 2.0f ) - 1.0f;\n"
		"	float2 localNormal = bumpMap.wy;\n"
		"\n"
		"	// calculate the screen texcoord in the 0.0 to 1.0 range\n"
		"	float2 screenTexCoord = vposToScreenPosTexCoord( fragment.position.xy );\n"
		"	screenTexCoord += ( localNormal * fragment.texcoord1.xy );\n"
		"	screenTexCoord = saturate( screenTexCoord );\n"
		"\n"
		"	// load the screen render\n"
		"	result.color = ( tex2D( samp0, screenTexCoord.xy ) );\n"
		"}\n"
		
	},
	
	{
		"renderprogs/heathaze.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2013 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"global.inc\"\n"
		"\n"
		"// User Renderparms start at 128 as per renderprogs.h\n"
		"\n"
		"uniform float4 rpUser0 : register(c128); // rpScroll\n"
		"uniform	float4 rpUser1 : register(c129); // rpDeformMagnitude\n"
		"\n"
		"// RB: no GPU skinning with ES 2.0\n"
		"#if defined(USE_GPU_SKINNING)\n"
		"uniform matrices_ubo { float4 matrices[408]; };\n"
		"#endif\n"
		"// RB end\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"	float4 color2 : COLOR1;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position		: POSITION;\n"
		"	float4 texcoord0	: TEXCOORD0;\n"
		"	float4 texcoord1	: TEXCOORD1;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"\n"
		"	#include \"skinning.inc\"\n"
		"\n"
		"	//texture 0 takes the texture coordinates and adds a scroll\n"
		"	const float4 textureScroll = rpUser0;\n"
		"	result.texcoord0 = float4( vertex.texcoord.xy, 0, 0 ) + textureScroll;\n"
		"\n"
		"	//texture 1 takes the deform magnitude and scales it by the projection distance\n"
		"	float4	vec = float4( 0, 1, 0, 1 );\n"
		"	vec.z = dot4( modelPosition, rpModelViewMatrixZ ); // this is the modelview matrix\n"
		"\n"
		"	// magicProjectionAdjust is a magic scalar that scales the projection since we changed from \n"
		"	// using the X axis to the Y axis to calculate x.  It is an approximation to closely match \n"
		"	// what the original game did\n"
		"	const float magicProjectionAdjust = 0.43f;\n"
		"	float x = dot4( vec, rpProjectionMatrixY ) * magicProjectionAdjust;\n"
		"	float w = dot4( vec, rpProjectionMatrixW );\n"
		"\n"
		"	//don't let the recip get near zero for polygons that cross the view plane\n"
		"	w = max( w, 1.0 );\n"
		"	x /= w;\n"
		"	//x = x * ( 1.0f / w );\n"
		"\n"
		"	// clamp the distance so the the deformations don't get too wacky near the view\n"
		"	x = min( x, 0.02 );\n"
		"\n"
		"	const float4 deformMagnitude = rpUser1;\n"
		"	result.texcoord1 = x * deformMagnitude;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/interaction.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2013-2014 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"#include \"renderprogs/BRDF.inc\"\n"
		"\n"
		"uniform sampler2D	samp0 : register(s0); // texture 1 is the per-surface bump map\n"
		"uniform sampler2D	samp1 : register(s1); // texture 2 is the light falloff texture\n"
		"uniform sampler2D	samp2 : register(s2); // texture 3 is the light projection texture\n"
		"uniform sampler2D	samp3 : register(s3); // texture 4 is the per-surface diffuse map\n"
		"uniform sampler2D	samp4 : register(s4); // texture 5 is the per-surface specular map\n"
		"\n"
		"struct PS_IN\n"
		"{\n"
		"	half4 position	: VPOS;\n"
		"	half4 texcoord0	: TEXCOORD0_centroid;\n"
		"	half4 texcoord1	: TEXCOORD1_centroid;\n"
		"	half4 texcoord2	: TEXCOORD2_centroid;\n"
		"	half4 texcoord3	: TEXCOORD3_centroid;\n"
		"	half4 texcoord4	: TEXCOORD4_centroid;\n"
		"	half4 texcoord5	: TEXCOORD5_centroid;\n"
		"	half4 texcoord6	: TEXCOORD6_centroid;\n"
		"	half4 color		: COLOR0;\n"
		"};\n"
		"\n"
		"struct PS_OUT\n"
		"{\n"
		"	half4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result )\n"
		"{\n"
		"	half4 bumpMap =			tex2D( samp0, fragment.texcoord1.xy );\n"
		"	half4 lightFalloff =	( idtex2Dproj( samp1, fragment.texcoord2 ) );\n"
		"	half4 lightProj	=		( idtex2Dproj( samp2, fragment.texcoord3 ) );\n"
		"	half4 YCoCG =			tex2D( samp3, fragment.texcoord4.xy );\n"
		"	half4 specMapSRGB =		tex2D( samp4, fragment.texcoord5.xy );\n"
		"	half4 specMap =			sRGBAToLinearRGBA( specMapSRGB );\n"
		"\n"
		"	half3 lightVector = normalize( fragment.texcoord0.xyz );\n"
		"	half3 viewVector = normalize( fragment.texcoord6.xyz );\n"
		"	half3 diffuseMap = sRGBToLinearRGB( ConvertYCoCgToRGB( YCoCG ) );\n"
		"\n"
		"	half3 localNormal;\n"
		"	// RB begin\n"
		"#if defined(USE_NORMAL_FMT_RGB8)\n"
		"	localNormal.xy = bumpMap.rg - 0.5;\n"
		"#else\n"
		"	localNormal.xy = bumpMap.wy - 0.5;\n"
		"#endif\n"
		"	// RB end\n"
		"	localNormal.z = sqrt( abs( dot( localNormal.xy, localNormal.xy ) - 0.25 ) );\n"
		"	localNormal = normalize( localNormal );\n"
		"	\n"
		"	// traditional very dark Lambert light model used in Doom 3\n"
		"	half ldotN = saturate( dot3( localNormal, lightVector ) );\n"
		"\n"
		"#if defined(USE_HALF_LAMBERT)\n"
		"	// RB: http://developer.valvesoftware.com/wiki/Half_Lambert\n"
		"	half halfLdotN = dot3( localNormal, lightVector ) * 0.5 + 0.5;\n"
		"	halfLdotN *= halfLdotN;\n"
		"\n"
		"	// tweak to not loose so many details\n"
		"	half lambert = lerp( ldotN, halfLdotN, 0.5 );\n"
		"#else\n"
		"	half lambert = ldotN;\n"
		"#endif\n"
		"\n"
		"\n"
		"	half3 halfAngleVector = normalize( lightVector + viewVector );\n"
		"	half hdotN = clamp( dot3( halfAngleVector, localNormal ), 0.0, 1.0 );\n"
		"\n"
		"#if 0 //defined(USE_PBR)\n"
		"		\n"
		"#if 0 //defined(USE_METALNESS)\n"
		"	const half metallic = specMapSRGB.g;\n"
		"	const half roughness = specMapSRGB.r;\n"
		"	const half glossiness = 1.0 - roughness;\n"
		"\n"
		"	// the vast majority of real-world materials (anything not metal or gems) have F(0)\n"
		"	// values in a very narrow range (~0.02 - 0.08)\n"
		"	\n"
		"	// approximate non-metals with linear RGB 0.04 which is 0.08 * 0.5 (default in UE4)\n"
		"	const half3 dielectricColor = half3( 0.04 );\n"
		"	\n"
		"	// derive diffuse and specular from albedo(m) base color\n"
		"	const half3 baseColor = diffuseMap;\n"
		"	\n"
		"	half3 diffuseColor = baseColor * ( 1.0 - metallic );\n"
		"	half3 specularColor = lerp( dielectricColor, baseColor, metallic );\n"
		"#else\n"
		"	// HACK calculate roughness from D3 gloss maps\n"
		"	float Y = dot( LUMINANCE_SRGB.rgb, specMapSRGB.rgb );\n"
		"	\n"
		"	//const float glossiness = clamp( 1.0 - specMapSRGB.r, 0.0, 0.98 );\n"
		"	const float glossiness = clamp( pow( Y, 1.0 / 2.0 ), 0.0, 0.98 );\n"
		"	\n"
		"	const float roughness = 1.0 - glossiness;\n"
		"	\n"
		"	half3 diffuseColor = diffuseMap;\n"
		"	half3 specularColor = specMap.rgb;\n"
		"#endif\n"
		"\n"
		"		\n"
		"	// RB: compensate r_lightScale 3 and the division of Pi\n"
		"	//lambert *= 1.3;\n"
		"	\n"
		"	// rpDiffuseModifier contains light color multiplier\n"
		"	half3 lightColor = sRGBToLinearRGB( lightProj.xyz * lightFalloff.xyz );// * rpDiffuseModifier.xyz;\n"
		"	\n"
		"	half vdotN = clamp( dot3( viewVector, localNormal ), 0.0, 1.0 );\n"
		"	half vdotH = clamp( dot3( viewVector, halfAngleVector ), 0.0, 1.0 );\n"
		"	half ldotH = clamp( dot3( lightVector, halfAngleVector ), 0.0, 1.0 );\n"
		"	\n"
		"	// compensate r_lightScale 3 * 2\n"
		"	half3 reflectColor = specMap.rgb * rpSpecularModifier.rgb * 1.0;// * 0.5;\n"
		"	\n"
		"	// cheap approximation by ARM with only one division\n"
		"	// http://community.arm.com/servlet/JiveServlet/download/96891546-19496/siggraph2015-mmg-renaldas-slides.pdf\n"
		"	// page 26\n"
		"	\n"
		"	float rr = roughness * roughness;\n"
		"	float rrrr = rr * rr;\n"
		"	\n"
		"	// disney GGX\n"
		"	float D = ( hdotN * hdotN ) * ( rrrr - 1.0 ) + 1.0;\n"
		"	float VFapprox = ( ldotH * ldotH ) * ( roughness + 0.5 );\n"
		"	half3 specularBRDF = ( rrrr / ( 4.0 * PI * D * D * VFapprox ) ) * ldotN * reflectColor;\n"
		"	//specularBRDF = half3( 0.0 );\n"
		"	\n"
		"#if 0\n"
		"	result.color = float4( _half3( VFapprox ), 1.0 );\n"
		"	return;\n"
		"#endif\n"
		"	\n"
		"	// see http://seblagarde.wordpress.com/2012/01/08/pi-or-not-to-pi-in-game-lighting-equation/\n"
		"	//lambert /= PI;\n"
		"	\n"
		"	//half3 diffuseColor = mix( diffuseMap, F0, metal ) * rpDiffuseModifier.xyz;\n"
		"	half3 diffuseBRDF = diffuseColor * lambert * sRGBToLinearRGB( rpDiffuseModifier.xyz );\n"
		"		\n"
		"	result.color.xyz = ( diffuseBRDF + specularBRDF ) * lightColor * fragment.color.rgb * shadow;\n"
		"	result.color.w = 1.0;\n"
		"	\n"
		"#else\n"
		"	\n"
		"	/*\n"
		"	OLD Blinn Phong\n"
		"	*/\n"
		"\n"
		"	const half specularPower = 10.0f;\n"
		"	\n"
		"	// RB: added abs\n"
		"	half3 specularContribution = _half3( pow( hdotN, specularPower ) );\n"
		"\n"
		"	half3 diffuseColor = diffuseMap * sRGBToLinearRGB( rpDiffuseModifier.xyz );\n"
		"	half3 specularColor = specMap.xyz * specularContribution * sRGBToLinearRGB( rpSpecularModifier.xyz );\n"
		"	half3 lightColor = sRGBToLinearRGB( lightProj.xyz * lightFalloff.xyz );\n"
		"	\n"
		"	/*\n"
		"	half rim =  1.0f - saturate( hdotN );\n"
		"	half rimPower = 16.0f;\n"
		"	half3 rimColor = diffuseColor * lightProj.xyz * lightFalloff.xyz * 1.0f * pow( rim, rimPower ) * fragment.color.rgb;// * halfLdotN;\n"
		"	*/\n"
		"\n"
		"	result.color.xyz = ( diffuseColor + specularColor ) * lambert * lightColor * fragment.color.rgb; // + rimColor;\n"
		"	result.color.w = 1.0;\n"
		"#endif\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/interaction.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2014 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"#if defined( USE_GPU_SKINNING )\n"
		"uniform matrices_ubo { float4 matrices[408]; };\n"
		"#endif\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"	float4 color2 : COLOR1;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position		: POSITION;\n"
		"	float4 texcoord0	: TEXCOORD0;\n"
		"	float4 texcoord1	: TEXCOORD1;\n"
		"	float4 texcoord2	: TEXCOORD2;\n"
		"	float4 texcoord3	: TEXCOORD3;\n"
		"	float4 texcoord4	: TEXCOORD4;\n"
		"	float4 texcoord5	: TEXCOORD5;\n"
		"	float4 texcoord6	: TEXCOORD6;\n"
		"	float4 color		: COLOR0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"\n"
		"	float4 vNormal = vertex.normal * 2.0 - 1.0;\n"
		"	float4 vTangent = vertex.tangent * 2.0 - 1.0;\n"
		"	float3 vBitangent = cross( vNormal.xyz, vTangent.xyz ) * vTangent.w;\n"
		"\n"
		"#if defined( USE_GPU_SKINNING )\n"
		"	//--------------------------------------------------------------\n"
		"	// GPU transformation of the normal / tangent / bitangent\n"
		"	//\n"
		"	// multiplying with 255.1 give us the same result and is faster than floor( w * 255 + 0.5 )\n"
		"	//--------------------------------------------------------------\n"
		"	const float w0 = vertex.color2.x;\n"
		"	const float w1 = vertex.color2.y;\n"
		"	const float w2 = vertex.color2.z;\n"
		"	const float w3 = vertex.color2.w;\n"
		"\n"
		"	float4 matX, matY, matZ;	// must be float4 for vec4\n"
		"	int joint = int(vertex.color.x * 255.1 * 3.0);\n"
		"	matX = matrices[int(joint+0)] * w0;\n"
		"	matY = matrices[int(joint+1)] * w0;\n"
		"	matZ = matrices[int(joint+2)] * w0;\n"
		"\n"
		"	joint = int(vertex.color.y * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w1;\n"
		"	matY += matrices[int(joint+1)] * w1;\n"
		"	matZ += matrices[int(joint+2)] * w1;\n"
		"\n"
		"	joint = int(vertex.color.z * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w2;\n"
		"	matY += matrices[int(joint+1)] * w2;\n"
		"	matZ += matrices[int(joint+2)] * w2;\n"
		"\n"
		"	joint = int(vertex.color.w * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w3;\n"
		"	matY += matrices[int(joint+1)] * w3;\n"
		"	matZ += matrices[int(joint+2)] * w3;\n"
		"\n"
		"	float3 normal;\n"
		"	normal.x = dot3( matX, vNormal );\n"
		"	normal.y = dot3( matY, vNormal );\n"
		"	normal.z = dot3( matZ, vNormal );\n"
		"	normal = normalize( normal );\n"
		"\n"
		"	float3 tangent;\n"
		"	tangent.x = dot3( matX, vTangent );\n"
		"	tangent.y = dot3( matY, vTangent );\n"
		"	tangent.z = dot3( matZ, vTangent );\n"
		"	tangent = normalize( tangent );\n"
		"\n"
		"	float3 bitangent;\n"
		"	bitangent.x = dot3( matX, vBitangent );\n"
		"	bitangent.y = dot3( matY, vBitangent );\n"
		"	bitangent.z = dot3( matZ, vBitangent );\n"
		"	bitangent = normalize( bitangent );\n"
		"\n"
		"	float4 modelPosition;\n"
		"	modelPosition.x = dot4( matX, vertex.position );\n"
		"	modelPosition.y = dot4( matY, vertex.position );\n"
		"	modelPosition.z = dot4( matZ, vertex.position );\n"
		"	modelPosition.w = 1.0;\n"
		"\n"
		"#else\n"
		"	float4 modelPosition = vertex.position;\n"
		"	float3 normal = vNormal.xyz;\n"
		"	float3 tangent = vTangent.xyz;\n"
		"	float3 bitangent = vBitangent.xyz;\n"
		"#endif\n"
		"\n"
		"	result.position.x = dot4( modelPosition, rpMVPmatrixX );\n"
		"	result.position.y = dot4( modelPosition, rpMVPmatrixY );\n"
		"	result.position.z = dot4( modelPosition, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( modelPosition, rpMVPmatrixW );\n"
		"\n"
		"	float4 defaultTexCoord = float4( 0.0f, 0.5f, 0.0f, 1.0f );\n"
		"\n"
		"	//calculate vector to light\n"
		"	float4 toLight = rpLocalLightOrigin - modelPosition;\n"
		"\n"
		"	//--------------------------------------------------------------\n"
		"\n"
		"	//result.texcoord0 is the direction to the light in tangent space\n"
		"	result.texcoord0.x = dot3( tangent, toLight );\n"
		"	result.texcoord0.y = dot3( bitangent, toLight );\n"
		"	result.texcoord0.z = dot3( normal, toLight );\n"
		"	result.texcoord0.w = 1.0f;\n"
		"\n"
		"	//textures 1 takes the base coordinates by the texture matrix\n"
		"	result.texcoord1 = defaultTexCoord;\n"
		"	result.texcoord1.x = dot4( vertex.texcoord.xy, rpBumpMatrixS );\n"
		"	result.texcoord1.y = dot4( vertex.texcoord.xy, rpBumpMatrixT );\n"
		"\n"
		"	//# texture 2 has one texgen\n"
		"	result.texcoord2 = defaultTexCoord;\n"
		"	result.texcoord2.x = dot4( modelPosition, rpLightFalloffS );\n"
		"\n"
		"	//# texture 3 has three texgens\n"
		"	result.texcoord3.x = dot4( modelPosition, rpLightProjectionS );\n"
		"	result.texcoord3.y = dot4( modelPosition, rpLightProjectionT );\n"
		"	result.texcoord3.z = 0.0f;\n"
		"	result.texcoord3.w = dot4( modelPosition, rpLightProjectionQ );\n"
		"\n"
		"	//# textures 4 takes the base coordinates by the texture matrix\n"
		"	result.texcoord4 = defaultTexCoord;\n"
		"	result.texcoord4.x = dot4( vertex.texcoord.xy, rpDiffuseMatrixS );\n"
		"	result.texcoord4.y = dot4( vertex.texcoord.xy, rpDiffuseMatrixT );\n"
		"\n"
		"	//# textures 5 takes the base coordinates by the texture matrix\n"
		"	result.texcoord5 = defaultTexCoord;\n"
		"	result.texcoord5.x = dot4( vertex.texcoord.xy, rpSpecularMatrixS );\n"
		"	result.texcoord5.y = dot4( vertex.texcoord.xy, rpSpecularMatrixT );\n"
		"\n"
		"	//# texture 6's texcoords will be the halfangle in texture space\n"
		"\n"
		"	//# calculate normalized vector to light in R0\n"
		"	toLight = normalize( toLight );\n"
		"\n"
		"	//# calculate normalized vector to viewer in R1\n"
		"	float4 toView = normalize( rpLocalViewOrigin - modelPosition );\n"
		"	\n"
		"	//# put into texture space\n"
		"	result.texcoord6.x = dot3( tangent, toView );\n"
		"	result.texcoord6.y = dot3( bitangent, toView );\n"
		"	result.texcoord6.z = dot3( normal, toView );\n"
		"	result.texcoord6.w = 1.0f;\n"
		"\n"
		"#if defined( USE_GPU_SKINNING )\n"
		"	// for joint transformation of the tangent space, we use color and\n"
		"	// color2 for weighting information, so hopefully there aren't any\n"
		"	// effects that need vertex color...\n"
		"	result.color = float4( 1.0f, 1.0f, 1.0f, 1.0f );\n"
		"#else\n"
		"	//# generate the vertex color, which can be 1.0, color, or 1.0 - color\n"
		"	//# for 1.0 : env[16] = 0, env[17] = 1\n"
		"	//# for color : env[16] = 1, env[17] = 0\n"
		"	//# for 1.0-color : env[16] = -1, env[17] = 1	\n"
		"	result.color = ( swizzleColor( vertex.color ) * rpVertexColorModulate ) + rpVertexColorAdd;\n"
		"#endif\n"
		"}\n"
		
	},
	
	{
		"renderprogs/interactionAmbient.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D	samp0 : register(s0); // texture 1 is the per-surface bump map\n"
		"uniform sampler2D	samp1 : register(s1); // texture 2 is the light falloff texture\n"
		"uniform sampler2D	samp2 : register(s2); // texture 3 is the light projection texture\n"
		"uniform sampler2D	samp3 : register(s3); // texture 4 is the per-surface diffuse map\n"
		"uniform sampler2D	samp4 : register(s4); // texture 5 is the per-surface specular map\n"
		"\n"
		"struct PS_IN {\n"
		"	half4 position	: VPOS;\n"
		"	half4 texcoord1	: TEXCOORD1_centroid;\n"
		"	half4 texcoord2	: TEXCOORD2_centroid;\n"
		"	half4 texcoord3	: TEXCOORD3_centroid;\n"
		"	half4 texcoord4	: TEXCOORD4_centroid;\n"
		"	half4 texcoord5	: TEXCOORD5_centroid;\n"
		"	half4 texcoord6	: TEXCOORD6_centroid;\n"
		"	half4 color		: COLOR0;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	half4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"	half4 bumpMap =			tex2D( samp0, fragment.texcoord1.xy );\n"
		"	half4 lightFalloff =	idtex2Dproj( samp1, fragment.texcoord2 );\n"
		"	half4 lightProj	=		idtex2Dproj( samp2, fragment.texcoord3 );\n"
		"	half4 YCoCG =			tex2D( samp3, fragment.texcoord4.xy );\n"
		"	half4 specMap =			sRGBAToLinearRGBA( tex2D( samp4, fragment.texcoord5.xy ) );\n"
		"\n"
		"	const half3 ambientLightVector = half3( 0.5f, 9.5f - 0.385f, 0.8925f );\n"
		"	half3 lightVector = normalize( ambientLightVector );\n"
		"	half3 diffuseMap = sRGBToLinearRGB( ConvertYCoCgToRGB( YCoCG ) );\n"
		"\n"
		"	half3 localNormal;\n"
		"	// RB begin\n"
		"#if defined(USE_NORMAL_FMT_RGB8)\n"
		"	localNormal.xy = bumpMap.rg - 0.5;\n"
		"#else\n"
		"	localNormal.xy = bumpMap.wy - 0.5;\n"
		"#endif\n"
		"	// RB end\n"
		"	localNormal.z = sqrt( abs( dot( localNormal.xy, localNormal.xy ) - 0.25 ) );\n"
		"	localNormal = normalize( localNormal );\n"
		"	\n"
		"	// traditional very dark Lambert light model used in Doom 3\n"
		"	half ldotN = saturate( dot3( localNormal, lightVector ) );\n"
		"\n"
		"#if defined(USE_HALF_LAMBERT)\n"
		"	// RB: http://developer.valvesoftware.com/wiki/Half_Lambert\n"
		"	half halfLdotN = dot3( localNormal, lightVector ) * 0.5 + 0.5;\n"
		"	halfLdotN *= halfLdotN;\n"
		"\n"
		"	half lambert = halfLdotN;\n"
		"#else\n"
		"	half lambert = ldotN;\n"
		"#endif\n"
		"	\n"
		"	const half specularPower = 10.0f;\n"
		"	half hDotN = dot3( normalize( fragment.texcoord6.xyz ), localNormal );\n"
		"	// RB: added abs\n"
		"	half3 specularContribution = _half3( pow( abs( hDotN ), specularPower ) );\n"
		"\n"
		"	half3 diffuseColor = diffuseMap * sRGBToLinearRGB( rpDiffuseModifier.xyz );\n"
		"	half3 specularColor = specMap.xyz * specularContribution * sRGBToLinearRGB( rpSpecularModifier.xyz );\n"
		"	half3 lightColor = 1.0 * lightProj.xyz * lightFalloff.xyz;\n"
		"\n"
		"	result.color.xyz = ( diffuseColor + specularColor ) * lightColor * fragment.color.xyz;\n"
		"	result.color.w = 1.0;\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/interactionAmbient.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position		: POSITION;\n"
		"	float4 texcoord1	: TEXCOORD1;\n"
		"	float4 texcoord2	: TEXCOORD2;\n"
		"	float4 texcoord3	: TEXCOORD3;\n"
		"	float4 texcoord4	: TEXCOORD4;\n"
		"	float4 texcoord5	: TEXCOORD5;\n"
		"	float4 texcoord6	: TEXCOORD6;\n"
		"	float4 color		: COLOR0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"\n"
		"	float4 normal = vertex.normal * 2.0 - 1.0;\n"
		"	float4 tangent = vertex.tangent * 2.0 - 1.0;\n"
		"	float3 binormal = cross( normal.xyz, tangent.xyz ) * tangent.w;\n"
		"\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"\n"
		"	float4 defaultTexCoord = float4( 0.0f, 0.5f, 0.0f, 1.0f );\n"
		"\n"
		"	//calculate vector to light in R0\n"
		"	float4 toLight = rpLocalLightOrigin - vertex.position;\n"
		"\n"
		"	//textures 1 takes the base coordinates by the texture matrix\n"
		"	result.texcoord1 = defaultTexCoord;\n"
		"	result.texcoord1.x = dot4( vertex.texcoord.xy, rpBumpMatrixS );\n"
		"	result.texcoord1.y = dot4( vertex.texcoord.xy, rpBumpMatrixT );\n"
		"\n"
		"	//# texture 2 has one texgen\n"
		"	result.texcoord2 = defaultTexCoord;\n"
		"	result.texcoord2.x = dot4( vertex.position, rpLightFalloffS );\n"
		"\n"
		"	//# texture 3 has three texgens\n"
		"	result.texcoord3.x = dot4( vertex.position, rpLightProjectionS );\n"
		"	result.texcoord3.y = dot4( vertex.position, rpLightProjectionT );\n"
		"	result.texcoord3.z = 0.0f;\n"
		"	result.texcoord3.w = dot4( vertex.position, rpLightProjectionQ );\n"
		"\n"
		"	//# textures 4 takes the base coordinates by the texture matrix\n"
		"	result.texcoord4 = defaultTexCoord;\n"
		"	result.texcoord4.x = dot4( vertex.texcoord.xy, rpDiffuseMatrixS );\n"
		"	result.texcoord4.y = dot4( vertex.texcoord.xy, rpDiffuseMatrixT );\n"
		"\n"
		"	//# textures 5 takes the base coordinates by the texture matrix\n"
		"	result.texcoord5 = defaultTexCoord;\n"
		"	result.texcoord5.x = dot4( vertex.texcoord.xy, rpSpecularMatrixS );\n"
		"	result.texcoord5.y = dot4( vertex.texcoord.xy, rpSpecularMatrixT );\n"
		"\n"
		"	//# texture 6's texcoords will be the halfangle in texture space\n"
		"\n"
		"	//# calculate normalized vector to light in R0\n"
		"	toLight = normalize( toLight );\n"
		"\n"
		"	//# calculate normalized vector to viewer in R1\n"
		"	float4 toView = normalize( rpLocalViewOrigin - vertex.position );\n"
		"	\n"
		"	//# add together to become the half angle vector in object space (non-normalized)\n"
		"	float4 halfAngleVector = toLight + toView;\n"
		"\n"
		"	//# put into texture space\n"
		"	result.texcoord6.x = dot3( tangent, halfAngleVector );\n"
		"	result.texcoord6.y = dot3( binormal, halfAngleVector );\n"
		"	result.texcoord6.z = dot3( normal, halfAngleVector );\n"
		"	result.texcoord6.w = 1.0f;\n"
		"\n"
		"	//# generate the vertex color, which can be 1.0, color, or 1.0 - color\n"
		"	//# for 1.0 : env[16] = 0, env[17] = 1\n"
		"	//# for color : env[16] = 1, env[17] = 0\n"
		"	//# for 1.0-color : env[16] = -1, env[17] = 1	\n"
		"	result.color = ( swizzleColor( vertex.color ) * rpVertexColorModulate ) + rpVertexColorAdd;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/interactionAmbient_skinned.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2013 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D	samp0 : register(s0); // texture 1 is the per-surface bump map\n"
		"uniform sampler2D	samp1 : register(s1); // texture 2 is the light falloff texture\n"
		"uniform sampler2D	samp2 : register(s2); // texture 3 is the light projection texture\n"
		"uniform sampler2D	samp3 : register(s3); // texture 4 is the per-surface diffuse map\n"
		"uniform sampler2D	samp4 : register(s4); // texture 5 is the per-surface specular map\n"
		"\n"
		"struct PS_IN {\n"
		"	half4 position	: VPOS;\n"
		"	half4 texcoord1	: TEXCOORD1_centroid;\n"
		"	half4 texcoord2	: TEXCOORD2_centroid;\n"
		"	half4 texcoord3	: TEXCOORD3_centroid;\n"
		"	half4 texcoord4	: TEXCOORD4_centroid;\n"
		"	half4 texcoord5	: TEXCOORD5_centroid;\n"
		"	half4 texcoord6	: TEXCOORD6_centroid;\n"
		"	half4 color		: COLOR0;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	half4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"	half4 bumpMap =			tex2D( samp0, fragment.texcoord1.xy );\n"
		"	half4 lightFalloff =	idtex2Dproj( samp1, fragment.texcoord2 );\n"
		"	half4 lightProj	=		idtex2Dproj( samp2, fragment.texcoord3 );\n"
		"	half4 YCoCG =			tex2D( samp3, fragment.texcoord4.xy );\n"
		"	half4 specMap =			tex2D( samp4, fragment.texcoord5.xy );\n"
		"\n"
		"	const half3 ambientLightVector = half3( 0.5f, 9.5f - 0.385f, 0.8925f );\n"
		"	half3 lightVector = normalize( ambientLightVector );\n"
		"	half3 diffuseMap = ConvertYCoCgToRGB( YCoCG );\n"
		"\n"
		"	half3 localNormal;\n"
		"	// RB begin\n"
		"#if defined(USE_NORMAL_FMT_RGB8)\n"
		"	localNormal.xy = bumpMap.rg - 0.5;\n"
		"#else\n"
		"	localNormal.xy = bumpMap.wy - 0.5;\n"
		"#endif\n"
		"	// RB end\n"
		"	localNormal.z = sqrt( abs( dot( localNormal.xy, localNormal.xy ) - 0.25 ) );\n"
		"	localNormal = normalize( localNormal );\n"
		"	\n"
		"	// traditional very dark Lambert light model used in Doom 3\n"
		"	half ldotN = saturate( dot3( localNormal, lightVector ) );\n"
		"\n"
		"#if defined(USE_HALF_LAMBERT)\n"
		"	// RB: http://developer.valvesoftware.com/wiki/Half_Lambert\n"
		"	half halfLdotN = dot3( localNormal, lightVector ) * 0.5 + 0.5;\n"
		"	halfLdotN *= halfLdotN;\n"
		"\n"
		"	half lambert = halfLdotN;\n"
		"#else\n"
		"	half lambert = ldotN;\n"
		"#endif\n"
		"	\n"
		"	const half specularPower = 10.0f;\n"
		"	half hDotN = dot3( normalize( fragment.texcoord6.xyz ), localNormal );\n"
		"	// RB: added abs\n"
		"	half3 specularContribution = _half3( pow( abs( hDotN ), specularPower ) );\n"
		"\n"
		"	half3 diffuseColor = diffuseMap * rpDiffuseModifier.xyz;\n"
		"	half3 specularColor = specMap.xyz * specularContribution * rpSpecularModifier.xyz;\n"
		"	half3 lightColor = 1.0 * lightProj.xyz * lightFalloff.xyz;\n"
		"\n"
		"	result.color.xyz = ( diffuseColor + specularColor ) * lightColor * fragment.color.xyz;\n"
		"	result.color.w = 1.0;\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/interactionAmbient_skinned.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2014 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform matrices_ubo { float4 matrices[408]; };\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"	float4 color2 : COLOR1;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position		: POSITION;\n"
		"	float4 texcoord1	: TEXCOORD1;\n"
		"	float4 texcoord2	: TEXCOORD2;\n"
		"	float4 texcoord3	: TEXCOORD3;\n"
		"	float4 texcoord4	: TEXCOORD4;\n"
		"	float4 texcoord5	: TEXCOORD5;\n"
		"	float4 texcoord6	: TEXCOORD6;\n"
		"	float4 color		: COLOR0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"\n"
		"	float4 vNormal = vertex.normal * 2.0 - 1.0;\n"
		"	float4 vTangent = vertex.tangent * 2.0 - 1.0;\n"
		"	float3 vBinormal = cross( vNormal.xyz, vTangent.xyz ) * vTangent.w;\n"
		"\n"
		"	//--------------------------------------------------------------\n"
		"	// GPU transformation of the normal / binormal / bitangent\n"
		"	//\n"
		"	// multiplying with 255.1 give us the same result and is faster than floor( w * 255 + 0.5 )\n"
		"	//--------------------------------------------------------------\n"
		"	const float w0 = vertex.color2.x;\n"
		"	const float w1 = vertex.color2.y;\n"
		"	const float w2 = vertex.color2.z;\n"
		"	const float w3 = vertex.color2.w;\n"
		"\n"
		"	float4 matX, matY, matZ;	// must be float4 for vec4\n"
		"	int joint = int(vertex.color.x * 255.1 * 3.0);\n"
		"	matX = matrices[int(joint+0)] * w0;\n"
		"	matY = matrices[int(joint+1)] * w0;\n"
		"	matZ = matrices[int(joint+2)] * w0;\n"
		"\n"
		"	joint = int(vertex.color.y * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w1;\n"
		"	matY += matrices[int(joint+1)] * w1;\n"
		"	matZ += matrices[int(joint+2)] * w1;\n"
		"\n"
		"	joint = int(vertex.color.z * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w2;\n"
		"	matY += matrices[int(joint+1)] * w2;\n"
		"	matZ += matrices[int(joint+2)] * w2;\n"
		"\n"
		"	joint = int(vertex.color.w * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w3;\n"
		"	matY += matrices[int(joint+1)] * w3;\n"
		"	matZ += matrices[int(joint+2)] * w3;\n"
		"\n"
		"	float3 normal;\n"
		"	normal.x = dot3( matX, vNormal );\n"
		"	normal.y = dot3( matY, vNormal );\n"
		"	normal.z = dot3( matZ, vNormal );\n"
		"	normal = normalize( normal );\n"
		"\n"
		"	float3 tangent;\n"
		"	tangent.x = dot3( matX, vTangent );\n"
		"	tangent.y = dot3( matY, vTangent );\n"
		"	tangent.z = dot3( matZ, vTangent );\n"
		"	tangent = normalize( tangent );\n"
		"\n"
		"	float3 binormal;\n"
		"	binormal.x = dot3( matX, vBinormal );\n"
		"	binormal.y = dot3( matY, vBinormal );\n"
		"	binormal.z = dot3( matZ, vBinormal );\n"
		"	binormal = normalize( binormal );\n"
		"\n"
		"	float4 modelPosition;\n"
		"	modelPosition.x = dot4( matX, vertex.position );\n"
		"	modelPosition.y = dot4( matY, vertex.position );\n"
		"	modelPosition.z = dot4( matZ, vertex.position );\n"
		"	modelPosition.w = 1.0;\n"
		"\n"
		"	result.position.x = dot4( modelPosition, rpMVPmatrixX );\n"
		"	result.position.y = dot4( modelPosition, rpMVPmatrixY );\n"
		"	result.position.z = dot4( modelPosition, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( modelPosition, rpMVPmatrixW );\n"
		"\n"
		"	float4 defaultTexCoord = float4( 0.0f, 0.5f, 0.0f, 1.0f );\n"
		"\n"
		"	//calculate vector to light in R0\n"
		"	float4 toLight = rpLocalLightOrigin - modelPosition;\n"
		"\n"
		"	//textures 1 takes the base coordinates by the texture matrix\n"
		"	result.texcoord1 = defaultTexCoord;\n"
		"	result.texcoord1.x = dot4( vertex.texcoord.xy, rpBumpMatrixS );\n"
		"	result.texcoord1.y = dot4( vertex.texcoord.xy, rpBumpMatrixT );\n"
		"\n"
		"	//# texture 2 has one texgen\n"
		"	result.texcoord2 = defaultTexCoord;\n"
		"	result.texcoord2.x = dot4( modelPosition, rpLightFalloffS );\n"
		"\n"
		"	//# texture 3 has three texgens\n"
		"	result.texcoord3.x = dot4( modelPosition, rpLightProjectionS );\n"
		"	result.texcoord3.y = dot4( modelPosition, rpLightProjectionT );\n"
		"	result.texcoord3.z = 0.0f;\n"
		"	result.texcoord3.w = dot4( modelPosition, rpLightProjectionQ );\n"
		"\n"
		"	//# textures 4 takes the base coordinates by the texture matrix\n"
		"	result.texcoord4 = defaultTexCoord;\n"
		"	result.texcoord4.x = dot4( vertex.texcoord.xy, rpDiffuseMatrixS );\n"
		"	result.texcoord4.y = dot4( vertex.texcoord.xy, rpDiffuseMatrixT );\n"
		"\n"
		"	//# textures 5 takes the base coordinates by the texture matrix\n"
		"	result.texcoord5 = defaultTexCoord;\n"
		"	result.texcoord5.x = dot4( vertex.texcoord.xy, rpSpecularMatrixS );\n"
		"	result.texcoord5.y = dot4( vertex.texcoord.xy, rpSpecularMatrixT );\n"
		"\n"
		"	//# texture 6's texcoords will be the halfangle in texture space\n"
		"\n"
		"	//# calculate normalized vector to light in R0\n"
		"	toLight = normalize( toLight );\n"
		"\n"
		"	//# calculate normalized vector to viewer in R1\n"
		"	float4 toView = normalize( rpLocalViewOrigin - modelPosition );\n"
		"	\n"
		"	//# add together to become the half angle vector in object space (non-normalized)\n"
		"	float4 halfAngleVector = toLight + toView;\n"
		"\n"
		"	//# put into texture space\n"
		"	result.texcoord6.x = dot3( tangent, halfAngleVector );\n"
		"	result.texcoord6.y = dot3( binormal, halfAngleVector );\n"
		"	result.texcoord6.z = dot3( normal, halfAngleVector );\n"
		"	result.texcoord6.w = 1.0f;\n"
		"\n"
		"	//# generate the vertex color, which can be 1.0, color, or 1.0 - color\n"
		"	//# for 1.0 : env[16] = 0, env[17] = 1\n"
		"	//# for color : env[16] = 1, env[17] = 0\n"
		"	//# for 1.0-color : env[16] = -1, env[17] = 1	\n"
		"	result.color = ( swizzleColor( vertex.color ) * rpVertexColorModulate ) + rpVertexColorAdd;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/interactionSM.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2013-2014 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"#include \"renderprogs/BRDF.inc\"\n"
		"\n"
		"uniform sampler2D				samp0 : register(s0); // texture 1 is the per-surface bump map\n"
		"uniform sampler2D				samp1 : register(s1); // texture 2 is the light falloff texture\n"
		"uniform sampler2D				samp2 : register(s2); // texture 3 is the light projection texture\n"
		"uniform sampler2D				samp3 : register(s3); // texture 4 is the per-surface diffuse map\n"
		"uniform sampler2D				samp4 : register(s4); // texture 5 is the per-surface specular map\n"
		"uniform sampler2DArrayShadow	samp5 : register(s5); // texture 6 is the shadowmap array\n"
		"uniform sampler2D				samp6 : register(s6); // texture 7 is the jitter texture \n"
		"\n"
		"\n"
		"\n"
		"struct PS_IN\n"
		"{\n"
		"	half4 position		: VPOS;\n"
		"	half4 texcoord0		: TEXCOORD0_centroid;\n"
		"	half4 texcoord1		: TEXCOORD1_centroid;\n"
		"	half4 texcoord2		: TEXCOORD2_centroid;\n"
		"	half4 texcoord3		: TEXCOORD3_centroid;\n"
		"	half4 texcoord4		: TEXCOORD4_centroid;\n"
		"	half4 texcoord5		: TEXCOORD5_centroid;\n"
		"	half4 texcoord6		: TEXCOORD6_centroid;\n"
		"	half4 texcoord7		: TEXCOORD7_centroid;\n"
		"	half4 texcoord8		: TEXCOORD8_centroid;\n"
		"	half4 texcoord9		: TEXCOORD9_centroid;\n"
		"	half4 color			: COLOR0;\n"
		"};\n"
		"\n"
		"struct PS_OUT\n"
		"{\n"
		"	half4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result )\n"
		"{\n"
		"	half4 bumpMap =			tex2D( samp0, fragment.texcoord1.xy );\n"
		"	half4 lightFalloff =	( idtex2Dproj( samp1, fragment.texcoord2 ) );\n"
		"	half4 lightProj	=		( idtex2Dproj( samp2, fragment.texcoord3 ) );\n"
		"	half4 YCoCG =			tex2D( samp3, fragment.texcoord4.xy );\n"
		"	half4 specMapSRGB =		tex2D( samp4, fragment.texcoord5.xy );\n"
		"	half4 specMap =			sRGBAToLinearRGBA( specMapSRGB );\n"
		"\n"
		"	half3 lightVector = normalize( fragment.texcoord0.xyz );\n"
		"	half3 viewVector = normalize( fragment.texcoord6.xyz );\n"
		"	half3 diffuseMap = sRGBToLinearRGB( ConvertYCoCgToRGB( YCoCG ) );\n"
		"\n"
		"	half3 localNormal;\n"
		"	// RB begin\n"
		"#if defined(USE_NORMAL_FMT_RGB8)\n"
		"	localNormal.xy = bumpMap.rg - 0.5;\n"
		"#else\n"
		"	localNormal.xy = bumpMap.wy - 0.5;\n"
		"#endif\n"
		"	// RB end\n"
		"	localNormal.z = sqrt( abs( dot( localNormal.xy, localNormal.xy ) - 0.25 ) );\n"
		"	localNormal = normalize( localNormal );\n"
		"	\n"
		"	// traditional very dark Lambert light model used in Doom 3\n"
		"	half ldotN = saturate( dot3( localNormal, lightVector ) );\n"
		"\n"
		"#if defined(USE_HALF_LAMBERT)\n"
		"	// RB: http://developer.valvesoftware.com/wiki/Half_Lambert\n"
		"	half halfLdotN = dot3( localNormal, lightVector ) * 0.5 + 0.5;\n"
		"	halfLdotN *= halfLdotN;\n"
		"\n"
		"	// tweak to not loose so many details\n"
		"	half lambert = lerp( ldotN, halfLdotN, 0.5 );\n"
		"#else\n"
		"	half lambert = ldotN;\n"
		"#endif\n"
		"\n"
		"\n"
		"	//\n"
		"	// shadow mapping\n"
		"	//\n"
		"	int shadowIndex = 0;\n"
		"	\n"
		"#if defined( LIGHT_POINT )\n"
		"	float3 toLightGlobal = normalize( fragment.texcoord8.xyz );\n"
		"	\n"
		"	float axis[6];\n"
		"	axis[0] = -toLightGlobal.x;\n"
		"	axis[1] =  toLightGlobal.x;\n"
		"	axis[2] = -toLightGlobal.y;\n"
		"	axis[3] =  toLightGlobal.y;\n"
		"	axis[4] = -toLightGlobal.z;\n"
		"	axis[5] =  toLightGlobal.z;\n"
		"\n"
		"	for( int i = 0; i < 6; i++ )\n"
		"	{\n"
		"		if( axis[i] > axis[shadowIndex] )\n"
		"		{\n"
		"			shadowIndex = i;\n"
		"		}\n"
		"	}\n"
		"\n"
		"#endif // #if defined( POINTLIGHT )\n"
		"\n"
		"#if defined( LIGHT_PARALLEL )\n"
		"	\n"
		"	float viewZ = -fragment.texcoord9.z;\n"
		"	\n"
		"	shadowIndex = 4;\n"
		"	for( int i = 0; i < 4; i++ )\n"
		"	{\n"
		"		if( viewZ < rpCascadeDistances[i] )\n"
		"		{\n"
		"			shadowIndex = i;\n"
		"			break;\n"
		"		}\n"
		"	}\n"
		"#endif\n"
		"	\n"
		"#if 0\n"
		"	if( shadowIndex == 0 )\n"
		"	{\n"
		"		result.color = float4( 1.0, 0.0, 0.0, 1.0 );\n"
		"	}\n"
		"	else if( shadowIndex == 1 )\n"
		"	{\n"
		"		result.color = float4( 0.0, 1.0, 0.0, 1.0 );\n"
		"	}\n"
		"	else if( shadowIndex == 2 )\n"
		"	{\n"
		"		result.color = float4( 0.0, 0.0, 1.0, 1.0 );\n"
		"	}\n"
		"	else if( shadowIndex == 3 )\n"
		"	{\n"
		"		result.color = float4( 1.0, 1.0, 0.0, 1.0 );\n"
		"	}\n"
		"	else if( shadowIndex == 4 )\n"
		"	{\n"
		"		result.color = float4( 1.0, 0.0, 1.0, 1.0 );\n"
		"	}\n"
		"	else if( shadowIndex == 5 )\n"
		"	{\n"
		"		result.color = float4( 0.0, 1.0, 1.0, 1.0 );\n"
		"	}\n"
		"	\n"
		"	//result.color.xyz *= lightColor;\n"
		"	return;\n"
		"#endif\n"
		"	\n"
		"	float4 shadowMatrixX = rpShadowMatrices[ int ( shadowIndex * 4 + 0 ) ];\n"
		"	float4 shadowMatrixY = rpShadowMatrices[ int ( shadowIndex * 4 + 1 ) ];\n"
		"	float4 shadowMatrixZ = rpShadowMatrices[ int ( shadowIndex * 4 + 2 ) ];\n"
		"	float4 shadowMatrixW = rpShadowMatrices[ int ( shadowIndex * 4 + 3 ) ];\n"
		"	\n"
		"	float4 modelPosition = float4( fragment.texcoord7.xyz, 1.0 );\n"
		"	float4 shadowTexcoord;\n"
		"	shadowTexcoord.x = dot4( modelPosition, shadowMatrixX );\n"
		"	shadowTexcoord.y = dot4( modelPosition, shadowMatrixY );\n"
		"	shadowTexcoord.z = dot4( modelPosition, shadowMatrixZ );\n"
		"	shadowTexcoord.w = dot4( modelPosition, shadowMatrixW );\n"
		"	\n"
		"	//float bias = 0.005 * tan( acos( ldotN ) );\n"
		"	//bias = clamp( bias, 0, 0.01 );\n"
		"	float bias = 0.001;\n"
		"	\n"
		"	shadowTexcoord.xyz /= shadowTexcoord.w;\n"
		"	\n"
		"	shadowTexcoord.z = shadowTexcoord.z * rpScreenCorrectionFactor.w;\n"
		"	//shadowTexcoord.z = shadowTexcoord.z * 0.999991;\n"
		"	//shadowTexcoord.z = shadowTexcoord.z - bias;\n"
		"	shadowTexcoord.w = float(shadowIndex);\n"
		"\n"
		"#if 0\n"
		"	result.color.xyz = float3( shadowTexcoord.z, shadowTexcoord.z, shadowTexcoord.z );\n"
		"	result.color.w = 1.0;\n"
		"	return;\n"
		"#endif\n"
		"\n"
		"	// multiple taps\n"
		"	\n"
		"#if 0\n"
		"	float4 base = shadowTexcoord;\n"
		"	\n"
		"	base.xy += rpJitterTexScale.xy * -0.5;\n"
		"	\n"
		"	float shadow = 0.0;\n"
		"	\n"
		"	//float stepSize = 1.0 / 16.0;\n"
		"	float numSamples = 16;\n"
		"	float stepSize = 1.0 / numSamples;\n"
		"	\n"
		"	float4 jitterTC = ( fragment.position * rpScreenCorrectionFactor ) + rpJitterTexOffset;\n"
		"	for( float i = 0.0; i < numSamples; i += 1.0 )\n"
		"	{\n"
		"		float4 jitter = base + tex2D( samp6, jitterTC.xy ) * rpJitterTexScale;\n"
		"		jitter.zw = shadowTexcoord.zw;\n"
		"	\n"
		"		shadow += texture( samp5, jitter.xywz );\n"
		"		jitterTC.x += stepSize;\n"
		"	}\n"
		"	\n"
		"	shadow *= stepSize;\n"
		"#else\n"
		"	\n"
		"	const float2 poissonDisk[12] = float2[](\n"
		"	float2(0.6111618, 0.1050905),\n"
		"	float2(0.1088336, 0.1127091),\n"
		"	float2(0.3030421, -0.6292974),\n"
		"	float2(0.4090526, 0.6716492),\n"
		"	float2(-0.1608387, -0.3867823),\n"
		"	float2(0.7685862, -0.6118501),\n"
		"	float2(-0.1935026, -0.856501),\n"
		"	float2(-0.4028573, 0.07754025),\n"
		"	float2(-0.6411021, -0.4748057),\n"
		"	float2(-0.1314865, 0.8404058),\n"
		"	float2(-0.7005203, 0.4596822),\n"
		"	float2(-0.9713828, -0.06329931) );\n"
		"	\n"
		"	float shadow = 0.0;\n"
		"	\n"
		"	// RB: casting a float to int and using it as index can really kill the performance ...\n"
		"	float numSamples = 12.0; //int(rpScreenCorrectionFactor.w);\n"
		"	float stepSize = 1.0 / numSamples;\n"
		"	\n"
		"	float4 jitterTC = ( fragment.position * rpScreenCorrectionFactor ) + rpJitterTexOffset;\n"
		"	float4 random = tex2D( samp6, jitterTC.xy ) * PI;\n"
		"	//float4 random = fragment.position;\n"
		"	\n"
		"	float2 rot;\n"
		"	rot.x = cos( random.x );\n"
		"	rot.y = sin( random.x );\n"
		"	\n"
		"	float shadowTexelSize = rpScreenCorrectionFactor.z * rpJitterTexScale.x;\n"
		"    for( int i = 0; i < 12; i++ )\n"
		"    {\n"
		"        float2 jitter = poissonDisk[i];\n"
		"		float2 jitterRotated;\n"
		"		jitterRotated.x = jitter.x * rot.x - jitter.y * rot.y;\n"
		"		jitterRotated.y = jitter.x * rot.y + jitter.y * rot.x;\n"
		"        \n"
		"		float4 shadowTexcoordJittered = float4( shadowTexcoord.xy + jitterRotated * shadowTexelSize, shadowTexcoord.z, shadowTexcoord.w );\n"
		"       \n"
		"        shadow += texture( samp5, shadowTexcoordJittered.xywz);\n"
		"    }\n"
		"\n"
		"   shadow *= stepSize;\n"
		"\n"
		"	//float shadow = texture( samp5, shadowTexcoord.xywz );\n"
		"#endif\n"
		"\n"
		"\n"
		"	half3 halfAngleVector = normalize( lightVector + viewVector );\n"
		"	half hdotN = clamp( dot3( halfAngleVector, localNormal ), 0.0, 1.0 );\n"
		"\n"
		"#if 0 //defined(USE_PBR)\n"
		"		\n"
		"#if 0 //defined(USE_METALNESS)\n"
		"	const half metallic = specMapSRGB.g;\n"
		"	const half roughness = specMapSRGB.r;\n"
		"	const half glossiness = 1.0 - roughness;\n"
		"\n"
		"	// the vast majority of real-world materials (anything not metal or gems) have F(0)\n"
		"	// values in a very narrow range (~0.02 - 0.08)\n"
		"	\n"
		"	// approximate non-metals with linear RGB 0.04 which is 0.08 * 0.5 (default in UE4)\n"
		"	const half3 dielectricColor = half3( 0.04 );\n"
		"	\n"
		"	// derive diffuse and specular from albedo(m) base color\n"
		"	const half3 baseColor = diffuseMap;\n"
		"	\n"
		"	half3 diffuseColor = baseColor * ( 1.0 - metallic );\n"
		"	half3 specularColor = lerp( dielectricColor, baseColor, metallic );\n"
		"#else\n"
		"	// HACK calculate roughness from D3 gloss maps\n"
		"	float Y = dot( LUMINANCE_SRGB.rgb, specMapSRGB.rgb );\n"
		"	\n"
		"	//const float glossiness = clamp( 1.0 - specMapSRGB.r, 0.0, 0.98 );\n"
		"	const float glossiness = clamp( pow( Y, 1.0 / 2.0 ), 0.0, 0.98 );\n"
		"	\n"
		"	const float roughness = 1.0 - glossiness;\n"
		"	\n"
		"	half3 diffuseColor = diffuseMap;\n"
		"	half3 specularColor = specMap.rgb;\n"
		"#endif\n"
		"\n"
		"		\n"
		"	// RB: compensate r_lightScale 3 and the division of Pi\n"
		"	//lambert *= 1.3;\n"
		"	\n"
		"	// rpDiffuseModifier contains light color multiplier\n"
		"	half3 lightColor = sRGBToLinearRGB( lightProj.xyz * lightFalloff.xyz );// * rpDiffuseModifier.xyz;\n"
		"	\n"
		"	half vdotN = clamp( dot3( viewVector, localNormal ), 0.0, 1.0 );\n"
		"	half vdotH = clamp( dot3( viewVector, halfAngleVector ), 0.0, 1.0 );\n"
		"	half ldotH = clamp( dot3( lightVector, halfAngleVector ), 0.0, 1.0 );\n"
		"	\n"
		"	// compensate r_lightScale 3 * 2\n"
		"	half3 reflectColor = specMap.rgb * rpSpecularModifier.rgb * 1.0;// * 0.5;\n"
		"	\n"
		"	// cheap approximation by ARM with only one division\n"
		"	// http://community.arm.com/servlet/JiveServlet/download/96891546-19496/siggraph2015-mmg-renaldas-slides.pdf\n"
		"	// page 26\n"
		"	\n"
		"	float rr = roughness * roughness;\n"
		"	float rrrr = rr * rr;\n"
		"	\n"
		"	// disney GGX\n"
		"	float D = ( hdotN * hdotN ) * ( rrrr - 1.0 ) + 1.0;\n"
		"	float VFapprox = ( ldotH * ldotH ) * ( roughness + 0.5 );\n"
		"	half3 specularBRDF = ( rrrr / ( 4.0 * PI * D * D * VFapprox ) ) * ldotN * reflectColor;\n"
		"	//specularBRDF = half3( 0.0 );\n"
		"	\n"
		"#if 0\n"
		"	result.color = float4( _half3( VFapprox ), 1.0 );\n"
		"	return;\n"
		"#endif\n"
		"	\n"
		"	// see http://seblagarde.wordpress.com/2012/01/08/pi-or-not-to-pi-in-game-lighting-equation/\n"
		"	//lambert /= PI;\n"
		"	\n"
		"	//half3 diffuseColor = mix( diffuseMap, F0, metal ) * rpDiffuseModifier.xyz;\n"
		"	half3 diffuseBRDF = diffuseColor * lambert * sRGBToLinearRGB( rpDiffuseModifier.xyz );\n"
		"		\n"
		"	result.color.xyz = ( diffuseBRDF + specularBRDF ) * lightColor * fragment.color.rgb * shadow;\n"
		"	result.color.w = 1.0;\n"
		"	\n"
		"#else\n"
		"	\n"
		"	/*\n"
		"	OLD Blinn Phong\n"
		"	*/\n"
		"\n"
		"	const half specularPower = 10.0f;\n"
		"	\n"
		"	// RB: added abs\n"
		"	half3 specularContribution = _half3( pow( hdotN, specularPower ) );\n"
		"\n"
		"	half3 diffuseColor = diffuseMap * sRGBToLinearRGB( rpDiffuseModifier.xyz );\n"
		"	half3 specularColor = specMap.xyz * specularContribution * sRGBToLinearRGB( rpSpecularModifier.xyz );\n"
		"	half3 lightColor = sRGBToLinearRGB( lightProj.xyz * lightFalloff.xyz );\n"
		"	\n"
		"	/*\n"
		"	half rim =  1.0f - saturate( hdotN );\n"
		"	half rimPower = 16.0f;\n"
		"	half3 rimColor = diffuseColor * lightProj.xyz * lightFalloff.xyz * 1.0f * pow( rim, rimPower ) * fragment.color.rgb;// * halfLdotN;\n"
		"	*/\n"
		"\n"
		"	result.color.xyz = ( diffuseColor + specularColor ) * lambert * lightColor * fragment.color.rgb * shadow;// + rimColor;\n"
		"	//result.color.xyz = lightColor * lambert * fragment.color.rgb * shadow;// + rimColor;\n"
		"	result.color.w = 1.0;\n"
		"#endif\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/interactionSM.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2014 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"#if defined( USE_GPU_SKINNING )\n"
		"uniform matrices_ubo { float4 matrices[408]; };\n"
		"#endif\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"	float4 color2 : COLOR1;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position		: POSITION;\n"
		"	float4 texcoord0	: TEXCOORD0;\n"
		"	float4 texcoord1	: TEXCOORD1;\n"
		"	float4 texcoord2	: TEXCOORD2;\n"
		"	float4 texcoord3	: TEXCOORD3;\n"
		"	float4 texcoord4	: TEXCOORD4;\n"
		"	float4 texcoord5	: TEXCOORD5;\n"
		"	float4 texcoord6	: TEXCOORD6;\n"
		"	float4 texcoord7	: TEXCOORD7;\n"
		"	float4 texcoord8	: TEXCOORD8;\n"
		"	float4 texcoord9	: TEXCOORD9;\n"
		"	float4 color		: COLOR0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"\n"
		"	float4 vNormal = vertex.normal * 2.0 - 1.0;\n"
		"	float4 vTangent = vertex.tangent * 2.0 - 1.0;\n"
		"	float3 vBitangent = cross( vNormal.xyz, vTangent.xyz ) * vTangent.w;\n"
		"\n"
		"#if defined( USE_GPU_SKINNING )\n"
		"	//--------------------------------------------------------------\n"
		"	// GPU transformation of the normal / tangent / bitangent\n"
		"	//\n"
		"	// multiplying with 255.1 give us the same result and is faster than floor( w * 255 + 0.5 )\n"
		"	//--------------------------------------------------------------\n"
		"	const float w0 = vertex.color2.x;\n"
		"	const float w1 = vertex.color2.y;\n"
		"	const float w2 = vertex.color2.z;\n"
		"	const float w3 = vertex.color2.w;\n"
		"\n"
		"	float4 matX, matY, matZ;	// must be float4 for vec4\n"
		"	int joint = int(vertex.color.x * 255.1 * 3.0);\n"
		"	matX = matrices[int(joint+0)] * w0;\n"
		"	matY = matrices[int(joint+1)] * w0;\n"
		"	matZ = matrices[int(joint+2)] * w0;\n"
		"\n"
		"	joint = int(vertex.color.y * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w1;\n"
		"	matY += matrices[int(joint+1)] * w1;\n"
		"	matZ += matrices[int(joint+2)] * w1;\n"
		"\n"
		"	joint = int(vertex.color.z * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w2;\n"
		"	matY += matrices[int(joint+1)] * w2;\n"
		"	matZ += matrices[int(joint+2)] * w2;\n"
		"\n"
		"	joint = int(vertex.color.w * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w3;\n"
		"	matY += matrices[int(joint+1)] * w3;\n"
		"	matZ += matrices[int(joint+2)] * w3;\n"
		"\n"
		"	float3 normal;\n"
		"	normal.x = dot3( matX, vNormal );\n"
		"	normal.y = dot3( matY, vNormal );\n"
		"	normal.z = dot3( matZ, vNormal );\n"
		"	normal = normalize( normal );\n"
		"\n"
		"	float3 tangent;\n"
		"	tangent.x = dot3( matX, vTangent );\n"
		"	tangent.y = dot3( matY, vTangent );\n"
		"	tangent.z = dot3( matZ, vTangent );\n"
		"	tangent = normalize( tangent );\n"
		"\n"
		"	float3 bitangent;\n"
		"	bitangent.x = dot3( matX, vBitangent );\n"
		"	bitangent.y = dot3( matY, vBitangent );\n"
		"	bitangent.z = dot3( matZ, vBitangent );\n"
		"	bitangent = normalize( bitangent );\n"
		"\n"
		"	float4 modelPosition;\n"
		"	modelPosition.x = dot4( matX, vertex.position );\n"
		"	modelPosition.y = dot4( matY, vertex.position );\n"
		"	modelPosition.z = dot4( matZ, vertex.position );\n"
		"	modelPosition.w = 1.0;\n"
		"\n"
		"#else\n"
		"	float4 modelPosition = vertex.position;\n"
		"	float3 normal = vNormal.xyz;\n"
		"	float3 tangent = vTangent.xyz;\n"
		"	float3 bitangent = vBitangent.xyz;\n"
		"#endif\n"
		"\n"
		"	result.position.x = dot4( modelPosition, rpMVPmatrixX );\n"
		"	result.position.y = dot4( modelPosition, rpMVPmatrixY );\n"
		"	result.position.z = dot4( modelPosition, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( modelPosition, rpMVPmatrixW );\n"
		"\n"
		"	float4 defaultTexCoord = float4( 0.0f, 0.5f, 0.0f, 1.0f );\n"
		"\n"
		"	//calculate vector to light\n"
		"	float4 toLightLocal = rpLocalLightOrigin - modelPosition;\n"
		"\n"
		"	//--------------------------------------------------------------\n"
		"\n"
		"	//result.texcoord0 is the direction to the light in tangent space\n"
		"	result.texcoord0.x = dot3( tangent, toLightLocal );\n"
		"	result.texcoord0.y = dot3( bitangent, toLightLocal );\n"
		"	result.texcoord0.z = dot3( normal, toLightLocal );\n"
		"	result.texcoord0.w = 1.0f;\n"
		"\n"
		"	//textures 1 takes the base coordinates by the texture matrix\n"
		"	result.texcoord1 = defaultTexCoord;\n"
		"	result.texcoord1.x = dot4( vertex.texcoord.xy, rpBumpMatrixS );\n"
		"	result.texcoord1.y = dot4( vertex.texcoord.xy, rpBumpMatrixT );\n"
		"\n"
		"	//# texture 2 has one texgen\n"
		"	result.texcoord2 = defaultTexCoord;\n"
		"	result.texcoord2.x = dot4( modelPosition, rpLightFalloffS );\n"
		"\n"
		"	//# texture 3 has three texgens\n"
		"	result.texcoord3.x = dot4( modelPosition, rpLightProjectionS );\n"
		"	result.texcoord3.y = dot4( modelPosition, rpLightProjectionT );\n"
		"	result.texcoord3.z = 0.0f;\n"
		"	result.texcoord3.w = dot4( modelPosition, rpLightProjectionQ );\n"
		"\n"
		"	//# textures 4 takes the base coordinates by the texture matrix\n"
		"	result.texcoord4 = defaultTexCoord;\n"
		"	result.texcoord4.x = dot4( vertex.texcoord.xy, rpDiffuseMatrixS );\n"
		"	result.texcoord4.y = dot4( vertex.texcoord.xy, rpDiffuseMatrixT );\n"
		"\n"
		"	//# textures 5 takes the base coordinates by the texture matrix\n"
		"	result.texcoord5 = defaultTexCoord;\n"
		"	result.texcoord5.x = dot4( vertex.texcoord.xy, rpSpecularMatrixS );\n"
		"	result.texcoord5.y = dot4( vertex.texcoord.xy, rpSpecularMatrixT );\n"
		"\n"
		"	//# texture 6's texcoords will be the halfangle in texture space\n"
		"\n"
		"	//# calculate normalized vector to light in R0\n"
		"	toLightLocal = normalize( toLightLocal );\n"
		"\n"
		"	//# calculate normalized vector to viewer in R1\n"
		"	float4 toView = normalize( rpLocalViewOrigin - modelPosition );\n"
		"	\n"
		"	//# put into texture space\n"
		"	result.texcoord6.x = dot3( tangent, toView );\n"
		"	result.texcoord6.y = dot3( bitangent, toView );\n"
		"	result.texcoord6.z = dot3( normal, toView );\n"
		"	result.texcoord6.w = 1.0f;\n"
		"	\n"
		"	result.texcoord7 = modelPosition;\n"
		"	\n"
		"	float4 worldPosition;\n"
		"	worldPosition.x = dot4( modelPosition, rpModelMatrixX );\n"
		"	worldPosition.y = dot4( modelPosition, rpModelMatrixY );\n"
		"	worldPosition.z = dot4( modelPosition, rpModelMatrixZ );\n"
		"	worldPosition.w = dot4( modelPosition, rpModelMatrixW );\n"
		"	\n"
		"	float4 toLightGlobal = rpGlobalLightOrigin - worldPosition;\n"
		"	\n"
		"	result.texcoord8 = toLightGlobal;\n"
		"	\n"
		"	float4 viewPosition;\n"
		"	viewPosition.x = dot4( modelPosition, rpModelViewMatrixX );\n"
		"	viewPosition.y = dot4( modelPosition, rpModelViewMatrixY );\n"
		"	viewPosition.z = dot4( modelPosition, rpModelViewMatrixZ );\n"
		"	viewPosition.w = dot4( modelPosition, rpModelViewMatrixW );\n"
		"	\n"
		"	result.texcoord9 = viewPosition;\n"
		"\n"
		"#if defined( USE_GPU_SKINNING )\n"
		"	// for joint transformation of the tangent space, we use color and\n"
		"	// color2 for weighting information, so hopefully there aren't any\n"
		"	// effects that need vertex color...\n"
		"	result.color = float4( 1.0f, 1.0f, 1.0f, 1.0f );\n"
		"#else\n"
		"	//# generate the vertex color, which can be 1.0, color, or 1.0 - color\n"
		"	//# for 1.0 : env[16] = 0, env[17] = 1\n"
		"	//# for color : env[16] = 1, env[17] = 0\n"
		"	//# for 1.0-color : env[16] = -1, env[17] = 1	\n"
		"	result.color = ( swizzleColor( vertex.color ) * rpVertexColorModulate ) + rpVertexColorAdd;\n"
		"#endif\n"
		"}\n"
		
	},
	
	{
		"renderprogs/motionBlur.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2014 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0);   // view color\n"
		"uniform sampler2D samp1 : register(s1);   // view depth\n"
		"\n"
		"struct PS_IN {\n"
		"	float2 texcoord0 : TEXCOORD0_centroid;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"#if 0\n"
		"    if ( fragment.texcoord0.x < 0.5 ) {\n"
		"    // only draw on half the screen for comparison\n"
		"        discard;\n"
		"    }\n"
		"#endif\n"
		"	// don't motion blur the hands, which were drawn with alpha = 0\n"
		"	if ( tex2D( samp0, fragment.texcoord0 ).w == 0.0 ) {\n"
		"		discard;\n"
		"	}\n"
		"\n"
		"	// derive clip space from the depth buffer and screen position\n"
		"	float windowZ = tex2D( samp1, fragment.texcoord0 ).x;\n"
		"	float3 ndc = float3( fragment.texcoord0 * 2.0 - 1.0, windowZ * 2.0 - 1.0 );\n"
		"	float clipW = -rpProjectionMatrixZ.w / ( -rpProjectionMatrixZ.z - ndc.z );\n"
		"\n"
		"	float4 clip = float4( ndc * clipW, clipW );\n"
		"\n"
		"	// convert from clip space this frame to clip space previous frame\n"
		"	float4 reClip;\n"
		"	reClip.x = dot( rpMVPmatrixX, clip );\n"
		"	reClip.y = dot( rpMVPmatrixY, clip );\n"
		"	reClip.z = dot( rpMVPmatrixZ, clip );\n"
		"	reClip.w = dot( rpMVPmatrixW, clip );\n"
		"\n"
		"	// convert to NDC values\n"
		"	float2 prevTexCoord;\n"
		"	prevTexCoord.x = ( reClip.x / reClip.w ) * 0.5 + 0.5;\n"
		"	prevTexCoord.y = ( reClip.y / reClip.w ) * 0.5 + 0.5;\n"
		"\n"
		"	// sample along the line from prevTexCoord to fragment.texcoord0\n"
		"\n"
		"	float2 texCoord = prevTexCoord; //fragment.texcoord0;\n"
		"	float2 delta = ( fragment.texcoord0 - prevTexCoord );\n"
		"\n"
		"	float3 sum = float3( 0.0 );\n"
		"	float goodSamples = 0.0;\n"
		"	float samples = rpOverbright.x;\n"
		"\n"
		"	for ( float i = 0.0 ; i < samples ; i = i + 1.0 ) {\n"
		"		float2 pos = fragment.texcoord0 + delta * ( ( i / ( samples - 1.0 ) ) - 0.5 );\n"
		"		float4 color = tex2D( samp0, pos );\n"
		"		// only take the values that are not part of the weapon\n"
		"		sum += color.xyz * color.w;\n"
		"		goodSamples += color.w;\n"
		"	}\n"
		"	float invScale = 1.0 / goodSamples;\n"
		"\n"
		"	result.color = float4( sum * invScale, 1.0 );\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/motionBlur.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord0 : TEXCOORD0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position = vertex.position;\n"
		"	result.texcoord0 = vertex.texcoord;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/postprocess.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company.\n"
		"Copyright (C) 2015 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").\n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"// *INDENT-OFF*\n"
		"uniform sampler2D samp0		: register(s0);\n"
		"uniform sampler2D samp1		: register(s1);\n"
		" \n"
		"struct PS_IN\n"
		"{\n"
		"	float4 position : VPOS;\n"
		"	float2 texcoord0 : TEXCOORD0_centroid;\n"
		"};\n"
		" \n"
		"struct PS_OUT\n"
		"{\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"// *INDENT-ON*\n"
		"\n"
		"#define USE_TECHNICOLOR						1		// [0 or 1]\n"
		"\n"
		"#define Technicolor_Amount					0.5		// [0.00 to 1.00]\n"
		"#define Technicolor_Power					4.0		// [0.00 to 8.00]\n"
		"#define Technicolor_RedNegativeAmount		0.88	// [0.00 to 1.00]\n"
		"#define Technicolor_GreenNegativeAmount		0.88	// [0.00 to 1.00]\n"
		"#define Technicolor_BlueNegativeAmount		0.88	// [0.00 to 1.00]\n"
		"\n"
		"#define USE_VIBRANCE						1\n"
		"#define Vibrance							0.5	// [-1.00 to 1.00]\n"
		"#define	Vibrance_RGB_Balance				float3( 1.0, 1.0, 1.0 )\n"
		"\n"
		"#define USE_FILMGRAIN 						1\n"
		"\n"
		"float3 overlay( float3 a, float3 b )\n"
		"{\n"
		"	//return pow( abs( b ), 2.2 ) < 0.5 ? ( 2.0 * a * b ) : float3( 1.0, 1.0, 1.0 ) - float3( 2.0, 2.0, 2.0 ) * ( float3( 1.0, 1.0, 1.0 ) - a ) * ( 1.0 - b );\n"
		"	//return abs( b ) < 0.5 ? ( 2.0 * a * b ) : float3( 1.0, 1.0, 1.0 ) - float3( 2.0, 2.0, 2.0 ) * ( float3( 1.0, 1.0, 1.0 ) - a ) * ( 1.0 - b );\n"
		"	\n"
		"	return float3(\n"
		"			   b.x < 0.5 ? ( 2.0 * a.x * b.x ) : ( 1.0 - 2.0 * ( 1.0 - a.x ) * ( 1.0 - b.x ) ),\n"
		"			   b.y < 0.5 ? ( 2.0 * a.y * b.y ) : ( 1.0 - 2.0 * ( 1.0 - a.y ) * ( 1.0 - b.y ) ),\n"
		"			   b.z < 0.5 ? ( 2.0 * a.z * b.z ) : ( 1.0 - 2.0 * ( 1.0 - a.z ) * ( 1.0 - b.z ) ) );\n"
		"}\n"
		"\n"
		"\n"
		"void TechnicolorPass( inout float4 color )\n"
		"{\n"
		"	const float3 cyanFilter = float3( 0.0, 1.30, 1.0 );\n"
		"	const float3 magentaFilter = float3( 1.0, 0.0, 1.05 );\n"
		"	const float3 yellowFilter = float3( 1.6, 1.6, 0.05 );\n"
		"	const float3 redOrangeFilter = float3( 1.05, 0.62, 0.0 );\n"
		"	const float3 greenFilter = float3( 0.3, 1.0, 0.0 );\n"
		"	\n"
		"	float2 redNegativeMul   = color.rg * ( 1.0 / ( Technicolor_RedNegativeAmount * Technicolor_Power ) );\n"
		"	float2 greenNegativeMul = color.rg * ( 1.0 / ( Technicolor_GreenNegativeAmount * Technicolor_Power ) );\n"
		"	float2 blueNegativeMul  = color.rb * ( 1.0 / ( Technicolor_BlueNegativeAmount * Technicolor_Power ) );\n"
		"	\n"
		"	float redNegative   = dot( redOrangeFilter.rg, redNegativeMul );\n"
		"	float greenNegative = dot( greenFilter.rg, greenNegativeMul );\n"
		"	float blueNegative  = dot( magentaFilter.rb, blueNegativeMul );\n"
		"	\n"
		"	float3 redOutput   = float3( redNegative ) + cyanFilter;\n"
		"	float3 greenOutput = float3( greenNegative ) + magentaFilter;\n"
		"	float3 blueOutput  = float3( blueNegative ) + yellowFilter;\n"
		"	\n"
		"	float3 result = redOutput * greenOutput * blueOutput;\n"
		"	color.rgb = lerp( color.rgb, result, Technicolor_Amount );\n"
		"}\n"
		"\n"
		"\n"
		"void VibrancePass( inout float4 color )\n"
		"{\n"
		"	const float3 vibrance = Vibrance_RGB_Balance * Vibrance;\n"
		"	\n"
		"	float Y = dot( LUMINANCE_SRGB, color );\n"
		"	\n"
		"	float minColor = min( color.r, min( color.g, color.b ) );\n"
		"	float maxColor = max( color.r, max( color.g, color.b ) );\n"
		"	\n"
		"	float colorSat = maxColor - minColor;\n"
		"	\n"
		"	color.rgb = lerp( float3( Y ), color.rgb, ( 1.0 + ( vibrance * ( 1.0 - ( sign( vibrance ) * colorSat ) ) ) ) );\n"
		"}\n"
		"\n"
		"\n"
		"void FilmgrainPass( inout float4 color )\n"
		"{\n"
		"	float4 jitterTC = ( fragment.position * rpScreenCorrectionFactor ) + rpJitterTexOffset;\n"
		"	//float4 jitterTC = ( fragment.position * ( 1.0 / 128.0 ) ) + rpJitterTexOffset;\n"
		"	//float2 jitterTC = fragment.position.xy * 2.0;\n"
		"	//jitterTC.x *= rpWindowCoord.y / rpWindowCoord.x;\n"
		"	\n"
		"	float4 noiseColor = tex2D( samp1, fragment.position.xy + jitterTC.xy );\n"
		"	float Y = noiseColor.r;\n"
		"	//float Y = dot( LUMINANCE_VECTOR, noiseColor );\n"
		"	//noiseColor.rgb = float3( Y, Y, Y );\n"
		"	\n"
		"	float exposureFactor = 1.0;\n"
		"	exposureFactor = sqrt( exposureFactor );\n"
		"	const float noiseIntensity = 1.7; //rpScreenCorrectionFactor.z;\n"
		"	\n"
		"	float t = lerp( 3.5 * noiseIntensity, 1.13 * noiseIntensity, exposureFactor );\n"
		"	color.rgb = overlay( color.rgb, lerp( float3( 0.5 ), noiseColor.rgb, t ) );\n"
		"	\n"
		"	//color.rgb = noiseColor.rgb;\n"
		"	//color.rgb = lerp( color.rgb, noiseColor.rgb, 0.3 );\n"
		"}\n"
		"\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result )\n"
		"{\n"
		"	float2 tCoords = fragment.texcoord0;\n"
		"	\n"
		"	// base color with tone mapping and other post processing applied\n"
		"	float4 color = tex2D( samp0, tCoords );\n"
		"	\n"
		"#if USE_TECHNICOLOR\n"
		"	TechnicolorPass( color );\n"
		"#endif\n"
		"	\n"
		"#if USE_VIBRANCE\n"
		"	VibrancePass( color );\n"
		"#endif\n"
		"	\n"
		"#if USE_FILMGRAIN\n"
		"	FilmgrainPass( color );\n"
		"#endif\n"
		"	\n"
		"	result.color = color;\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/postprocess.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord0 : TEXCOORD0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position = vertex.position;\n"
		"\n"
		"	//result.position.x = vertex.position; //dot4( vertex.position, rpMVPmatrixX );\n"
		"	//result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	//result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	//result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"	result.texcoord0 =  vertex.texcoord;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/screen.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2014 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D samp0		: register(s0);\n"
		"\n"
		"struct PS_IN\n"
		"{\n"
		"	float4 position : VPOS;\n"
		"	float2 texcoord0 : TEXCOORD0_centroid;\n"
		"};\n"
		"\n"
		"struct PS_OUT\n"
		"{\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result )\n"
		"{\n"
		"	float2 tCoords = fragment.texcoord0;\n"
		"	\n"
		"	float4 color = tex2D( samp0, tCoords );\n"
		"	result.color = color;\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/screen.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord0 : TEXCOORD0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position = vertex.position;\n"
		"\n"
		"	//result.position.x = vertex.position; //dot4( vertex.position, rpMVPmatrixX );\n"
		"	//result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	//result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	//result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"	result.texcoord0 =  vertex.texcoord;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/shadow.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0);\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( out PS_OUT result ) {\n"
		"	result.color = rpColor;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/shadow.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	float4 vPos = vertex.position - rpLocalLightOrigin;\n"
		"	vPos = ( vPos.wwww * rpLocalLightOrigin ) + vPos;\n"
		"\n"
		"	result.position.x = dot4( vPos, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vPos, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vPos, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vPos, rpMVPmatrixW );\n"
		"}\n"
		
	},
	
	{
		"renderprogs/shadowDebug.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0);\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( out PS_OUT result ) {\n"
		"	result.color = rpColor;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/shadowDebug.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	float4 vPos = vertex.position - rpLocalLightOrigin;\n"
		"	vPos = ( vPos.wwww * rpLocalLightOrigin ) + vPos;\n"
		"\n"
		"	result.position.x = dot4( vPos, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vPos, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vPos, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vPos, rpMVPmatrixW );\n"
		"}\n"
		
	},
	
	{
		"renderprogs/shadowDebug_skinned.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0);\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( out PS_OUT result ) {\n"
		"	result.color = rpColor;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/shadowDebug_skinned.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2014 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform matrices_ubo { float4 matrices[408]; };\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float4 color : COLOR0;\n"
		"	float4 color2 : COLOR1;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	//--------------------------------------------------------------\n"
		"	// GPU transformation of the normal / binormal / bitangent\n"
		"	//\n"
		"	// multiplying with 255.1 give us the same result and is faster than floor( w * 255 + 0.5 )\n"
		"	//--------------------------------------------------------------\n"
		"	const float w0 = vertex.color2.x;\n"
		"	const float w1 = vertex.color2.y;\n"
		"	const float w2 = vertex.color2.z;\n"
		"	const float w3 = vertex.color2.w;\n"
		"\n"
		"	float4 matX, matY, matZ;	// must be float4 for vec4\n"
		"	int joint = int(vertex.color.x * 255.1 * 3.0);\n"
		"	matX = matrices[int(joint+0)] * w0;\n"
		"	matY = matrices[int(joint+1)] * w0;\n"
		"	matZ = matrices[int(joint+2)] * w0;\n"
		"\n"
		"	joint = int(vertex.color.y * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w1;\n"
		"	matY += matrices[int(joint+1)] * w1;\n"
		"	matZ += matrices[int(joint+2)] * w1;\n"
		"\n"
		"	joint = int(vertex.color.z * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w2;\n"
		"	matY += matrices[int(joint+1)] * w2;\n"
		"	matZ += matrices[int(joint+2)] * w2;\n"
		"\n"
		"	joint = int(vertex.color.w * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w3;\n"
		"	matY += matrices[int(joint+1)] * w3;\n"
		"	matZ += matrices[int(joint+2)] * w3;\n"
		"\n"
		"	float4 vertexPosition = vertex.position;\n"
		"	vertexPosition.w = 1.0;\n"
		"\n"
		"	float4 modelPosition;\n"
		"	modelPosition.x = dot4( matX, vertexPosition );\n"
		"	modelPosition.y = dot4( matY, vertexPosition );\n"
		"	modelPosition.z = dot4( matZ, vertexPosition );\n"
		"	modelPosition.w = vertex.position.w;\n"
		"\n"
		"	float4 vPos = modelPosition - rpLocalLightOrigin;\n"
		"	vPos = ( vPos.wwww * rpLocalLightOrigin ) + vPos;\n"
		"\n"
		"	result.position.x = dot4( vPos, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vPos, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vPos, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vPos, rpMVPmatrixW );\n"
		"}\n"
		
	},
	
	{
		"renderprogs/shadow_skinned.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0);\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( out PS_OUT result ) {\n"
		"	result.color = rpColor;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/shadow_skinned.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Coypright (C) 2014 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform matrices_ubo { float4 matrices[408]; };\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float4 color : COLOR0;\n"
		"	float4 color2 : COLOR1;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	//--------------------------------------------------------------\n"
		"	// GPU transformation of the normal / binormal / bitangent\n"
		"	//\n"
		"	// multiplying with 255.1 give us the same result and is faster than floor( w * 255 + 0.5 )\n"
		"	//--------------------------------------------------------------\n"
		"	const float w0 = vertex.color2.x;\n"
		"	const float w1 = vertex.color2.y;\n"
		"	const float w2 = vertex.color2.z;\n"
		"	const float w3 = vertex.color2.w;\n"
		"\n"
		"	float4 matX, matY, matZ;	// must be float4 for vec4\n"
		"	int joint = int(vertex.color.x * 255.1 * 3.0);\n"
		"	matX = matrices[int(joint+0)] * w0;\n"
		"	matY = matrices[int(joint+1)] * w0;\n"
		"	matZ = matrices[int(joint+2)] * w0;\n"
		"\n"
		"	joint = int(vertex.color.y * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w1;\n"
		"	matY += matrices[int(joint+1)] * w1;\n"
		"	matZ += matrices[int(joint+2)] * w1;\n"
		"\n"
		"	joint = int(vertex.color.z * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w2;\n"
		"	matY += matrices[int(joint+1)] * w2;\n"
		"	matZ += matrices[int(joint+2)] * w2;\n"
		"\n"
		"	joint = int(vertex.color.w * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w3;\n"
		"	matY += matrices[int(joint+1)] * w3;\n"
		"	matZ += matrices[int(joint+2)] * w3;\n"
		"\n"
		"	float4 vertexPosition = vertex.position;\n"
		"	vertexPosition.w = 1.0;\n"
		"\n"
		"	float4 modelPosition;\n"
		"	modelPosition.x = dot4( matX, vertexPosition );\n"
		"	modelPosition.y = dot4( matY, vertexPosition );\n"
		"	modelPosition.z = dot4( matZ, vertexPosition );\n"
		"	modelPosition.w = vertex.position.w;\n"
		"\n"
		"	float4 vPos = modelPosition - rpLocalLightOrigin;\n"
		"	vPos = ( vPos.wwww * rpLocalLightOrigin ) + vPos;\n"
		"\n"
		"	result.position.x = dot4( vPos, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vPos, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vPos, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vPos, rpMVPmatrixW );\n"
		"}\n"
		
	},
	
	{
		"renderprogs/simpleshade.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position		: VPOS;\n"
		"	float4 texcoord0	: TEXCOORD0_centroid;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"uniform sampler2D	samp0 : register(s0);\n"
		"\n"
		"static float2 screenPosToTexcoord( float2 pos, float4 bias_scale ) { return ( pos * bias_scale.zw + bias_scale.xy ); }\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"	const float renderWidth = 1280.0f;\n"
		"	const float renderHeight = 720.0f;\n"
		"	const float4 positionToViewTexture = float4( 0.5f / renderWidth, 0.5f / renderHeight, 1.0f / renderWidth, 1.0f / renderHeight );\n"
		"	\n"
		"	float interpolatedZOverW = ( 1.0 - ( fragment.texcoord0.z / fragment.texcoord0.w ) );\n"
		"\n"
		"	float3 pos;\n"
		"	pos.z = 1.0 / interpolatedZOverW;\n"
		"	pos.xy = pos.z * ( 2.0 * screenPosToTexcoord( fragment.position.xy, positionToViewTexture ) - 1.0 );\n"
		"\n"
		"	float3 normal = normalize( cross( ddy( pos ), ddx( pos ) ) );\n"
		"\n"
		"	// light is above and to the right in the eye plane\n"
		"	float3 L = normalize( float3( 1.0, 1.0, 0.0 ) - pos );\n"
		"\n"
		"	result.color.xyz = _float3( dot3( normal, L ) * 0.75 );\n"
		"	result.color.w = 1.0;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/simpleshade.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position		: POSITION;\n"
		"	float4 texcoord0	: TEXCOORD0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	float4 position;\n"
		"	position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"\n"
		"	result.position = position;\n"
		"	result.texcoord0 = position;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/skybox.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform samplerCUBE samp0 : register(s0);\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position : VPOS;\n"
		"	float3 texcoord0 : TEXCOORD0_centroid;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"	result.color = sRGBAToLinearRGBA( texCUBE( samp0, fragment.texcoord0 ) ) * fragment.color;\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/skybox.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"	float3 texcoord0 : TEXCOORD0;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"\n"
		"	result.texcoord0 = vertex.position.xyz - rpLocalViewOrigin.xyz;\n"
		"	\n"
		"	result.color = ( swizzleColor( vertex.color ) * rpVertexColorModulate ) + rpVertexColorAdd;\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/SMAA_blending_weight_calc.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company.\n"
		"Copyright (C) 2015 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").\n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"#define SMAA_INCLUDE_VS 0\n"
		"#define SMAA_INCLUDE_PS 1\n"
		"#include \"renderprogs/SMAA.inc\"\n"
		"\n"
		"// *INDENT-OFF*\n"
		"uniform sampler2D samp0		: register(s0);		// _smaaEdges\n"
		"uniform sampler2D samp1		: register(s1);		// _smaaArea\n"
		"uniform sampler2D samp2		: register(s2);		// _smaaSearch\n"
		" \n"
		"struct PS_IN\n"
		"{\n"
		"	float4 position : VPOS;\n"
		"	float2 texcoord0 : TEXCOORD0_centroid;\n"
		"	float4 texcoord1 : TEXCOORD1_centroid;\n"
		"	float4 texcoord2 : TEXCOORD2_centroid;\n"
		"	float4 texcoord3 : TEXCOORD3_centroid;\n"
		"	float4 texcoord4 : TEXCOORD4_centroid;\n"
		"};\n"
		" \n"
		"struct PS_OUT\n"
		"{\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"// *INDENT-ON*\n"
		"\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result )\n"
		"{\n"
		"	float2 texcoord = fragment.texcoord0;\n"
		"	\n"
		"	float4 offset[3];\n"
		"	offset[0] = fragment.texcoord1;\n"
		"	offset[1] = fragment.texcoord2;\n"
		"	offset[2] = fragment.texcoord3;\n"
		"\n"
		"	float2 pixcoord = fragment.texcoord4.st;\n"
		"	\n"
		"	// TODO\n"
		"	//float4 subsampleIndices = float4( 1.0, 1.0, 1.0, 0.0 );\n"
		"	float4 subsampleIndices = float4( 0.0, 0.0, 0.0, 0.0 );\n"
		"	\n"
		"	float4 color = SMAABlendingWeightCalculationPS( texcoord,\n"
		"                                       pixcoord,\n"
		"                                       offset,\n"
		"                                       samp0,\n"
		"                                       samp1,\n"
		"                                       samp2,\n"
		"                                       subsampleIndices );\n"
		"\n"
		"	//color = float4( texcoord.s, texcoord.t, 0.0, 1.0 );\n"
		"	result.color = color;\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/SMAA_blending_weight_calc.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2015 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"#define SMAA_INCLUDE_VS 1\n"
		"#define SMAA_INCLUDE_PS 0\n"
		"#include \"renderprogs/SMAA.inc\"\n"
		"\n"
		"struct VS_IN \n"
		"{\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT\n"
		"{\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord0 : TEXCOORD0;\n"
		"	float4 texcoord1 : TEXCOORD1;\n"
		"	float4 texcoord2 : TEXCOORD2;\n"
		"	float4 texcoord3 : TEXCOORD3;\n"
		"	float4 texcoord4 : TEXCOORD4;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result )\n"
		"{\n"
		"	result.position = vertex.position;\n"
		"\n"
		"	float2 texcoord = vertex.texcoord;\n"
		"	//float2 texcoord = float2( vertex.texcoord.s, 1.0 - vertex.texcoord.t );\n"
		"	result.texcoord0 = texcoord;\n"
		"\n"
		"	float4 offset[3];\n"
		"	float2 pixcoord;\n"
		"	SMAABlendingWeightCalculationVS( texcoord, pixcoord, offset );\n"
		"	\n"
		"	result.texcoord1 = offset[0];\n"
		"	result.texcoord2 = offset[1];\n"
		"	result.texcoord3 = offset[2];\n"
		"\n"
		"	result.texcoord4.st = pixcoord;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/SMAA_edge_detection.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company.\n"
		"Copyright (C) 2015 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").\n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"#define SMAA_INCLUDE_VS 0\n"
		"#define SMAA_INCLUDE_PS 1\n"
		"#include \"renderprogs/SMAA.inc\"\n"
		"\n"
		"// *INDENT-OFF*\n"
		"uniform sampler2D samp0		: register(s0);		// _currentColor\n"
		"uniform sampler2D samp1		: register(s1);		// TODO _predictColor\n"
		" \n"
		"struct PS_IN\n"
		"{\n"
		"	float4 position : VPOS;\n"
		"	float2 texcoord0 : TEXCOORD0_centroid;\n"
		"	float4 texcoord1 : TEXCOORD1_centroid;\n"
		"	float4 texcoord2 : TEXCOORD2_centroid;\n"
		"	float4 texcoord3 : TEXCOORD3_centroid;\n"
		"};\n"
		" \n"
		"struct PS_OUT\n"
		"{\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"// *INDENT-ON*\n"
		"\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result )\n"
		"{\n"
		"	float2 tCoords = fragment.texcoord0;\n"
		"	\n"
		"	float4 offset[3];\n"
		"	offset[0] = fragment.texcoord1;\n"
		"	offset[1] = fragment.texcoord2;\n"
		"	offset[2] = fragment.texcoord3;\n"
		"	\n"
		"	float4 color = float4( 0.0 );\n"
		"	color.rg = SMAALumaEdgeDetectionPS( tCoords,\n"
		"                               offset,\n"
		"                               samp0\n"
		"                               #if SMAA_PREDICATION\n"
		"                               , samp1\n"
		"                               #endif\n"
		"                               );\n"
		"	\n"
		"	result.color = color;\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/SMAA_edge_detection.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2015 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"#define SMAA_INCLUDE_VS 1\n"
		"#define SMAA_INCLUDE_PS 0\n"
		"#include \"renderprogs/SMAA.inc\"\n"
		"\n"
		"struct VS_IN \n"
		"{\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT\n"
		"{\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord0 : TEXCOORD0;\n"
		"	float4 texcoord1 : TEXCOORD1;\n"
		"	float4 texcoord2 : TEXCOORD2;\n"
		"	float4 texcoord3 : TEXCOORD3;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result )\n"
		"{\n"
		"	result.position = vertex.position;\n"
		"\n"
		"	float2 texcoord = vertex.texcoord;\n"
		"	//float2 texcoord = float2( vertex.texcoord.s, 1.0 - vertex.texcoord.t );\n"
		"	\n"
		"	result.texcoord0 = texcoord;\n"
		"\n"
		"	float4 offset[3];\n"
		"	SMAAEdgeDetectionVS( texcoord, offset );\n"
		"	\n"
		"	result.texcoord1 = offset[0];\n"
		"	result.texcoord2 = offset[1];\n"
		"	result.texcoord3 = offset[2];\n"
		"}\n"
		
	},
	
	{
		"renderprogs/SMAA_final.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company.\n"
		"Copyright (C) 2015 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").\n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"#define SMAA_INCLUDE_VS 0\n"
		"#define SMAA_INCLUDE_PS 1\n"
		"#include \"renderprogs/SMAA.inc\"\n"
		"\n"
		"// *INDENT-OFF*\n"
		"uniform sampler2D samp0		: register(s0);		// _currentColor\n"
		"uniform sampler2D samp1		: register(s1);		// _smaaBlend\n"
		"//uniform sampler2D samp2		: register(s1);		// _velocity\n"
		" \n"
		"struct PS_IN\n"
		"{\n"
		"	float4 position : VPOS;\n"
		"	float2 texcoord0 : TEXCOORD0_centroid;\n"
		"	float4 texcoord1 : TEXCOORD1_centroid;\n"
		"};\n"
		" \n"
		"struct PS_OUT\n"
		"{\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"// *INDENT-ON*\n"
		"\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result )\n"
		"{\n"
		"	float2 texcoord = fragment.texcoord0;\n"
		"	\n"
		"	float4 offset = fragment.texcoord1;\n"
		"\n"
		"	float4 color = SMAANeighborhoodBlendingPS(texcoord,\n"
		"                                  offset,\n"
		"                                  samp0,\n"
		"                                  samp1\n"
		"                                  #if SMAA_REPROJECTION\n"
		"                                  , SMAATexture2D(velocityTex)\n"
		"                                  #endif\n"
		"                                  );\n"
		"	\n"
		"	//color = tex2D( samp1, texcoord );\n"
		"	//color = float4( samp1 );\n"
		"	result.color = color;\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/SMAA_final.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2015 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"#define SMAA_INCLUDE_VS 1\n"
		"#define SMAA_INCLUDE_PS 0\n"
		"#include \"renderprogs/SMAA.inc\"\n"
		"\n"
		"struct VS_IN \n"
		"{\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT\n"
		"{\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord0 : TEXCOORD0;\n"
		"	float4 texcoord1 : TEXCOORD1;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result )\n"
		"{\n"
		"	result.position = vertex.position;\n"
		"\n"
		"	result.texcoord0 =  vertex.texcoord;\n"
		"\n"
		"	float4 offset;\n"
		"	SMAANeighborhoodBlendingVS( vertex.texcoord, offset );\n"
		"	\n"
		"	result.texcoord1 = offset;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/stereoDeGhost.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0);\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( out PS_OUT result ) {\n"
		"	result.color = rpColor;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/stereoDeGhost.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"}\n"
		
	},
	
	{
		"renderprogs/stereoInterlace.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0);\n"
		"uniform sampler2D samp1 : register(s1);\n"
		"\n"
		"struct PS_IN {\n"
		"	float2 texcoord0 : TEXCOORD0_centroid;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"    // texcoords will run from 0 to 1 across the entire screen\n"
		"    if ( fract( fragment.position.y * 0.5 ) < 0.5 ) {\n"
		"        result.color = tex2D( samp0, vec2( fragment.texcoord0 ) );\n"
		"    } else {\n"
		"        result.color = tex2D( samp1, vec2( fragment.texcoord0 ) );\n"
		"    }\n"
		"}\n"
		
	},
	
	{
		"renderprogs/stereoInterlace.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord0 : TEXCOORD0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"\n"
		"	result.texcoord0 = vertex.texcoord;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/stereoWarp.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"/*\n"
		"\n"
		"This shader will cover a square block of pixel coordinates, but some of them might\n"
		"be scissored off if the edges of the screen or the midpoint divider are visible through\n"
		"the optics.\n"
		"\n"
		"*/\n"
		"\n"
		"uniform sampler2D samp0 : register(s0);\n"
		"\n"
		"struct PS_IN {\n"
		"	vec4 texcoord0	: TEXCOORD0_centroid;\n"
		"};\n"
		"\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"    const float screenWarp_range   = 1.45;\n"
		"\n"
		"    const vec2    warpCenter = vec2( 0.5, 0.5 );\n"
		"    vec2    centeredTexcoord = fragment.texcoord0.xy - warpCenter;\n"
		"\n"
		"	float	radialLength = length( centeredTexcoord );\n"
		"	vec2	radialDir = normalize( centeredTexcoord );\n"
		"\n"
		"	// get it down into the 0 - PI/2 range\n"
		"	float	range = screenWarp_range;\n"
		"	float	scaledRadialLength = radialLength * range;\n"
		"	float	tanScaled = tan( scaledRadialLength );\n"
		"\n"
		"    float   rescaleValue = tan( 0.5 * range );\n"
		"\n"
		"    // If radialLength was 0.5, we want rescaled to also come out\n"
		"    // as 0.5, so the edges of the rendered image are at the edges\n"
		"    // of the warped image.\n"
		"	float	rescaled = tanScaled / rescaleValue;\n"
		"\n"
		"    vec2	warped = warpCenter + vec2( 0.5, 0.5 ) * radialDir * rescaled;\n"
		"\n"
		"	result.color = tex2D( samp0, warped );\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/stereoWarp.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float4 texcoord : TEXCOORD0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"	float4 texcoord0: TEXCOORD0;        // 0 to 1 box\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"	result.texcoord0 = vertex.texcoord;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/texture.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0);\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position : VPOS;\n"
		"	float2 texcoord0 : TEXCOORD0_centroid;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"	result.color = tex2D( samp0, fragment.texcoord0 ) * rpColor;\n"
		"	//result.color = textureLod( samp0, fragment.texcoord0, 2.0 ) * rpColor;\n"
		"	//result.color = float4( 0.0, 1.0, 0.0, 1.0 ) * rpColor;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/texture.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord0 : TEXCOORD0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"\n"
		"	// compute oldschool texgen or multiply by texture matrix\n"
		"	BRANCH if ( rpTexGen0Enabled.x > 0.0 ) {\n"
		"		result.texcoord0.x = dot4( vertex.position, rpTexGen0S );\n"
		"		result.texcoord0.y = dot4( vertex.position, rpTexGen0T );\n"
		"	} else {\n"
		"		result.texcoord0.x = dot4( vertex.texcoord.xy, rpTextureMatrixS );\n"
		"		result.texcoord0.y = dot4( vertex.texcoord.xy, rpTextureMatrixT );\n"
		"	}\n"
		"}\n"
		
	},
	
	{
		"renderprogs/texture_color.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0);\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position : VPOS;\n"
		"	float2 texcoord0 : TEXCOORD0_centroid;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"	float4 color = tex2D( samp0, fragment.texcoord0 ) * fragment.color;\n"
		"	clip( color.a - rpAlphaTest.x );\n"
		"	result.color = sRGBAToLinearRGBA( color );\n"
		"}\n"
		
	},
	
	{
		"renderprogs/texture_color.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord0 : TEXCOORD0;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"\n"
		"	// compute oldschool texgen or multiply by texture matrix\n"
		"	BRANCH if ( rpTexGen0Enabled.x > 0.0 ) {\n"
		"		result.texcoord0.x = dot4( vertex.position, rpTexGen0S );\n"
		"		result.texcoord0.y = dot4( vertex.position, rpTexGen0T );\n"
		"	} else {\n"
		"		result.texcoord0.x = dot4( vertex.texcoord.xy, rpTextureMatrixS );\n"
		"		result.texcoord0.y = dot4( vertex.texcoord.xy, rpTextureMatrixT );\n"
		"	}\n"
		"\n"
		"	float4 vertexColor = ( swizzleColor( vertex.color ) * rpVertexColorModulate ) + rpVertexColorAdd;\n"
		"	result.color =  vertexColor * rpColor;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/texture_color_skinned.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0);\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position : VPOS;\n"
		"	float2 texcoord0 : TEXCOORD0_centroid;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"	float4 color = tex2D( samp0, fragment.texcoord0 ) * fragment.color;\n"
		"	clip( color.a - rpAlphaTest.x );\n"
		"	result.color = sRGBAToLinearRGBA( color );\n"
		"}\n"
		
	},
	
	{
		"renderprogs/texture_color_skinned.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2014 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform matrices_ubo { float4 matrices[408]; };\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 color : COLOR0;\n"
		"	float4 color2 : COLOR1;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord0 : TEXCOORD0;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	//--------------------------------------------------------------\n"
		"	// GPU transformation of the normal / binormal / bitangent\n"
		"	//\n"
		"	// multiplying with 255.1 give us the same result and is faster than floor( w * 255 + 0.5 )\n"
		"	//--------------------------------------------------------------\n"
		"	const float w0 = vertex.color2.x;\n"
		"	const float w1 = vertex.color2.y;\n"
		"	const float w2 = vertex.color2.z;\n"
		"	const float w3 = vertex.color2.w;\n"
		"\n"
		"	float4 matX, matY, matZ;	// must be float4 for vec4\n"
		"	int joint = int(vertex.color.x * 255.1 * 3.0);\n"
		"	matX = matrices[int(joint+0)] * w0;\n"
		"	matY = matrices[int(joint+1)] * w0;\n"
		"	matZ = matrices[int(joint+2)] * w0;\n"
		"\n"
		"	joint = int(vertex.color.y * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w1;\n"
		"	matY += matrices[int(joint+1)] * w1;\n"
		"	matZ += matrices[int(joint+2)] * w1;\n"
		"\n"
		"	joint = int(vertex.color.z * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w2;\n"
		"	matY += matrices[int(joint+1)] * w2;\n"
		"	matZ += matrices[int(joint+2)] * w2;\n"
		"\n"
		"	joint = int(vertex.color.w * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w3;\n"
		"	matY += matrices[int(joint+1)] * w3;\n"
		"	matZ += matrices[int(joint+2)] * w3;\n"
		"\n"
		"	float4 modelPosition;\n"
		"	modelPosition.x = dot4( matX, vertex.position );\n"
		"	modelPosition.y = dot4( matY, vertex.position );\n"
		"	modelPosition.z = dot4( matZ, vertex.position );\n"
		"	modelPosition.w = 1.0;\n"
		"\n"
		"	result.position.x = dot4( modelPosition, rpMVPmatrixX );\n"
		"	result.position.y = dot4( modelPosition, rpMVPmatrixY );\n"
		"	result.position.z = dot4( modelPosition, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( modelPosition, rpMVPmatrixW );\n"
		"\n"
		"	// compute oldschool texgen or multiply by texture matrix\n"
		"	BRANCH if ( rpTexGen0Enabled.x > 0.0 ) {\n"
		"		result.texcoord0.x = dot4( modelPosition, rpTexGen0S );\n"
		"		result.texcoord0.y = dot4( modelPosition, rpTexGen0T );\n"
		"	} else {\n"
		"		result.texcoord0.x = dot4( vertex.texcoord.xy, rpTextureMatrixS );\n"
		"		result.texcoord0.y = dot4( vertex.texcoord.xy, rpTextureMatrixT );\n"
		"	}\n"
		"\n"
		"	float4 vertexColor = ( swizzleColor( vertex.color ) * rpVertexColorModulate ) + rpVertexColorAdd;\n"
		"	result.color =  vertexColor * rpColor;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/texture_color_texgen.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0);\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position : VPOS;\n"
		"	float4 texcoord0 : TEXCOORD0_centroid;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"\n"
		"	// we always do a projective texture lookup so that we can support texgen\n"
		"	// materials without a separate shader. Basic materials will have texture\n"
		"	// coordinates with w = 1 which will result in a NOP projection when tex2Dproj\n"
		"	// gets called.\n"
		"	float4 texSample = idtex2Dproj( samp0, fragment.texcoord0 );\n"
		"\n"
		"	result.color = sRGBAToLinearRGBA( texSample ) * fragment.color;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/texture_color_texgen.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"	float4 texcoord0 : TEXCOORD0;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"\n"
		"	float4 tc0;\n"
		"	tc0.x = dot4( vertex.position, rpTexGen0S );\n"
		"	tc0.y = dot4( vertex.position, rpTexGen0T );\n"
		"\n"
		"	tc0.z = 0.0f;\n"
		"	tc0.w = dot4( vertex.position, rpTexGen0Q ); \n"
		"\n"
		"	// multiply the texture matrix in\n"
		"	result.texcoord0.x = dot4( tc0, rpTextureMatrixS );\n"
		"	result.texcoord0.y = dot4( tc0, rpTextureMatrixT );\n"
		"	result.texcoord0.zw = tc0.zw;\n"
		"\n"
		"	// compute vertex modulation\n"
		"	float4 vertexColor = ( swizzleColor( vertex.color ) * rpVertexColorModulate ) + rpVertexColorAdd;\n"
		"	result.color =  vertexColor * rpColor;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/tonemap.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2009-2015 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D	samp0 : register(s0); // texture 0 is _currentRender\n"
		"uniform sampler2D	samp1 : register(s1); // texture 1 is heatmap\n"
		"\n"
		"struct PS_IN\n"
		"{\n"
		"	float4 position : VPOS;\n"
		"	float2 texcoord0 : TEXCOORD0_centroid;\n"
		"};\n"
		"\n"
		"struct PS_OUT\n"
		"{\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"\n"
		" \n"
		"float3 Uncharted2Tonemap( float3 x )\n"
		"{\n"
		"	float A = 0.22; // shoulder strength\n"
		"	float B = 0.3;	// linear strength\n"
		"	float C = 0.10;	// linear angle\n"
		"	float D = 0.20;	// toe strength\n"
		"	float E = 0.01;	// toe numerator\n"
		"	float F = 0.30;	// toe denominator\n"
		"	float W = 11.2;	// linear white point\n"
		"\n"
		"	return ( ( x * ( A * x + C * B ) + D * E ) / ( x * ( A * x + B ) + D * F ) ) - E / F;\n"
		"}\n"
		"\n"
		"// https://knarkowicz.wordpress.com/2016/01/06/aces-filmic-tone-mapping-curve/\n"
		"float3 ACESFilm( float3 x )\n"
		"{\n"
		"    float a = 2.51;\n"
		"    float b = 0.03;\n"
		"    float c = 2.43;\n"
		"    float d = 0.59;\n"
		"    float e = 0.14;\n"
		"    return saturate( ( x * ( a * x + b ) ) / ( x * ( c * x + d ) + e ) );\n"
		"}\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result )\n"
		"{\n"
		"	float2 tCoords = fragment.texcoord0;\n"
		"	\n"
		"#if defined(BRIGHTPASS_FILTER)\n"
		"	// multiply with 4 because the FBO is only 1/4th of the screen resolution\n"
		"	tCoords *= float2( 4.0, 4.0 );\n"
		"#endif\n"
		"	\n"
		"	float4 color = tex2D( samp0, tCoords );\n"
		"	\n"
		"	// get the luminance of the current pixel\n"
		"	float Y = dot( LUMINANCE_SRGB, color );\n"
		"\n"
		"	const float hdrGamma = 2.2;\n"
		"	float gamma = hdrGamma;\n"
		"	\n"
		"#if 0\n"
		"	// convert from sRGB to linear RGB\n"
		"	color.r = pow( color.r, gamma );\n"
		"	color.g = pow( color.g, gamma );\n"
		"	color.b = pow( color.b, gamma );\n"
		"#endif\n"
		"	\n"
		"#if defined(BRIGHTPASS)\n"
		"	if(Y < 0.1)\n"
		"	{\n"
		"		//discard;\n"
		"		result.color = float4( 0.0, 0.0, 0.0, 1.0 );\n"
		"		return;\n"
		"	}\n"
		"#endif\n"
		"	\n"
		"	float hdrKey = rpScreenCorrectionFactor.x;\n"
		"	float hdrAverageLuminance = rpScreenCorrectionFactor.y;\n"
		"	float hdrMaxLuminance = rpScreenCorrectionFactor.z;\n"
		"	\n"
		"	// calculate the relative luminance\n"
		"	float Yr = ( hdrKey * Y ) / hdrAverageLuminance;\n"
		"\n"
		"	float Ymax = hdrMaxLuminance;\n"
		"\n"
		"#define OPERATOR 2\n"
		"	\n"
		"#if OPERATOR == 0\n"
		"	// advanced Reinhard operator, artistically desirable to burn out bright areas\n"
		"	float L = Yr * ( 1.0 + Yr / ( Ymax * Ymax ) ) / ( 1.0 + Yr );\n"
		"	color.rgb *= L;\n"
		"\n"
		"#elif OPERATOR == 1\n"
		"	// http://freespace.virgin.net/hugo.elias/graphics/x_posure.htm\n"
		"	// exponential tone mapper that is very similar to the Uncharted one\n"
		"	// very good in keeping the colors natural\n"
		"	float exposure = 1.0;\n"
		"	float L = ( 1.0 - exp( -Yr * exposure ) );\n"
		"	color.rgb *= L;\n"
		"	\n"
		"	// Kodak filmic tone mappping, includes gamma correction\n"
		"	//float3 rgb = max( float3( 0 ), color.rgb - float3( 0.004 ) );\n"
		"	//color.rgb = rgb * ( float3( 0.5 ) + 6.2 * rgb ) / ( float3( 0.06 ) + rgb * ( float3( 1.7 ) + 6.2 * rgb ) );\n"
		"	\n"
		"	// http://iwasbeingirony.blogspot.de/2010/04/approximating-film-with-tonemapping.html\n"
		"	//const float cutoff = 0.025;\n"
		"	//color.rgb += ( cutoff * 2.0 - color.rgb ) * saturate( cutoff * 2 - color.rgb ) * ( 0.25 / cutoff ) - cutoff;\n"
		"	//color.rgb = color.rgb * ( float3( 0.5 ) + 6.2 * color.rgb ) / ( float3( 0.06 ) + color.rgb * ( float3( 1.7 ) + 6.2 * color.rgb ) );\n"
		"	\n"
		"#elif OPERATOR == 2\n"
		"\n"
		"	// can be in range [-4.0 .. 4.0]\n"
		"	//float exposureOffset = rpScreenCorrectionFactor.w;\n"
		"	\n"
		"	float avgLuminance = max( hdrAverageLuminance, 0.001 );\n"
		"	float linearExposure = ( hdrKey / avgLuminance );\n"
		"	float exposure = log2( max( linearExposure, 0.0001 ) );\n"
		"	\n"
		"	//exposure = -2.0;\n"
		"	float3 exposedColor = exp2( exposure ) * color.rgb;\n"
		"	\n"
		"	color.rgb = ACESFilm( exposedColor );\n"
		"	\n"
		"#elif OPERATOR == 3\n"
		"\n"
		"	// can be in range [-4.0 .. 4.0]\n"
		"	float exposure = rpScreenCorrectionFactor.w;\n"
		"	\n"
		"	// exposure curves ranges from 0.0625 to 16.0\n"
		"	float3 exposedColor = exp2( exposure ) * color.rgb;\n"
		"	//float3 exposedColor = exposure * color.rgb;\n"
		"	\n"
		"	float3 curr = ACESFilm( exposedColor );\n"
		"	\n"
		"	float3 whiteScale = 1.0 / ACESFilm( float3( Ymax ) );\n"
		"	color.rgb = curr * whiteScale;\n"
		"	\n"
		"#elif OPERATOR == 4\n"
		"	// Uncharted 2 tone mapping based on Kodak film curve\n"
		"\n"
		"	//float exposure = ( hdrKey / hdrAverageLuminance ) * 0.2;\n"
		"	//float exposure = Yr * 1.0;\n"
		"	float exposure = rpScreenCorrectionFactor.w;\n"
		"	float3 exposedColor = exposure * color.rgb;\n"
		"	\n"
		"	float3 curr = Uncharted2Tonemap( exposedColor );\n"
		"	\n"
		"	float3 whiteScale = 1.0 / Uncharted2Tonemap( float3( Ymax ) );\n"
		"	color.rgb = curr * whiteScale;\n"
		"#endif\n"
		"	\n"
		"#if defined(BRIGHTPASS)\n"
		"	// adjust contrast\n"
		"	//L = pow( L, 1.32 );\n"
		"	\n"
		"	const half hdrContrastThreshold = rpOverbright.x;\n"
		"	const half hdrContrastOffset = rpOverbright.y;\n"
		"	\n"
		"	//float T = max( ( Yr * ( 1.0 + Yr / ( Ymax * Ymax * 2.0 ) ) ) - hdrContrastThreshold, 0.0 );\n"
		"	//float T = max( 1.0 - exp( -Yr ) - hdrContrastThreshold, 0.0 );\n"
		"	float T = max( Yr - hdrContrastThreshold, 0.0 );\n"
		"	\n"
		"	float B = T > 0.0 ? T / ( hdrContrastOffset + T ) : T;\n"
		"	\n"
		"	color.rgb *= clamp( B, 0.0, 1.0 );\n"
		"#endif\n"
		"	\n"
		"#if 1\n"
		"	// convert from linear RGB to sRGB\n"
		"\n"
		"	//float hdrGamma = 2.2;\n"
		"	gamma = 1.0 / hdrGamma;\n"
		"	color.r = pow( color.r, gamma );\n"
		"	color.g = pow( color.g, gamma );\n"
		"	color.b = pow( color.b, gamma );\n"
		"#endif\n"
		"	\n"
		"#if defined(HDR_DEBUG)\n"
		"	//color = tex2D( samp1, float2( L, 0.0 ) );\n"
		"	color = tex2D( samp1, float2( dot( LUMINANCE_SRGB, color ), 0.0 ) );\n"
		"#endif\n"
		"\n"
		"	result.color = color;\n"
		"	\n"
		"#if 0\n"
		"	result.color = float4( L, L, L, 1.0 );\n"
		"#endif\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/tonemap.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord0 : TEXCOORD0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position = vertex.position;\n"
		"\n"
		"	//result.position.x = vertex.position; //dot4( vertex.position, rpMVPmatrixX );\n"
		"	//result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	//result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	//result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"	result.texcoord0 =  vertex.texcoord;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/vertex_color.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2013 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0);\n"
		"\n"
		"struct PS_IN\n"
		"{\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct PS_OUT\n"
		"{\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result )\n"
		"{\n"
		"	result.color = sRGBAToLinearRGBA( fragment.color );\n"
		"}\n"
		
	},
	
	{
		"renderprogs/vertex_color.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2013 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN\n"
		"{\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT\n"
		"{\n"
		"	float4 position : POSITION;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result )\n"
		"{\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"	\n"
		"	result.color =  swizzleColor( vertex.color );\n"
		"}\n"
		
	},
	
	{
		"renderprogs/wobblesky.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform samplerCUBE samp0 : register(s0);\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position : VPOS;\n"
		"	float3 texcoord0 : TEXCOORD0_centroid;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"	result.color = sRGBAToLinearRGBA( texCUBE( samp0, fragment.texcoord0 ) ) * fragment.color;\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/wobblesky.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"	float3 texcoord0 : TEXCOORD0;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"\n"
		"	float3 t0 = vertex.position.xyz - rpLocalViewOrigin.xyz;\n"
		"	result.texcoord0.x = dot3( t0, rpWobbleSkyX );\n"
		"	result.texcoord0.y = dot3( t0, rpWobbleSkyY );\n"
		"	result.texcoord0.z = dot3( t0, rpWobbleSkyZ );\n"
		"	\n"
		"	result.color = ( swizzleColor( vertex.color ) * rpVertexColorModulate ) + rpVertexColorAdd;\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/zcullReconstruct.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct PS_OUT {	\n"
		"	float depth : DEPTH;\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( out PS_OUT result ) {\n"
		"	result.depth = 1;\n"
		"	result.color = float4( 0.0, 0.0, 0.0, 0.0 );\n"
		"}\n"
		
	},
	
	{
		"renderprogs/zcullReconstruct.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position = vertex.position;\n"
		"	result.position.z = -1.0;\n"
		"}\n"
		
	},
	
	{0, 0},
	
};
