% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatter.r
\name{pvalue_format}
\alias{pvalue_format}
\alias{pvalue}
\title{p-values formatter}
\usage{
pvalue_format(accuracy = 0.001, decimal.mark = ".", add_p = FALSE)

pvalue(x, accuracy = 0.001, decimal.mark = ".", add_p = FALSE)
}
\arguments{
\item{accuracy}{Number to round to.}

\item{decimal.mark}{The character to be used to indicate the numeric
decimal point.}

\item{add_p}{Add "p=" before the value?}

\item{x}{A numeric vector of p-values.}
}
\value{
\code{pvalue_format} returns a function with single parameter
\code{x}, a numeric vector, that returns a character vector.
}
\description{
Formatter for p-values, adding a symbol "<" for small p-values.
}
\examples{
p <- c(.50, 0.12, .045, .011, .009, .00002, NA)
pvalue(p)
pvalue(p, accuracy = .01)
pvalue(p, add_p = TRUE)
custom_function <- pvalue_format(accuracy = .1, decimal.mark = ",")
custom_function(p)
}
