% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Node.R
\docType{methods}
\name{initialize,Node-method}
\alias{initialize,Node-method}
\alias{Node-initialize}
\title{Initialize a Node object.}
\usage{
\S4method{initialize}{Node}(.Object, world, literal, uri, blank, datatype_uri,
  language)
}
\arguments{
\item{.Object}{the Node object to be initialized}

\item{world}{a World object}

\item{literal}{a literal character value to be assigned to the node}

\item{uri}{a uri character value to be assigned to the node}

\item{blank}{a blank node identifier to be assigned to the node}

\item{datatype_uri}{a uri used to specify the datatype of a literal node, i.e. "http://www.w3.org/2001/XMLSchema#string"}

\item{language}{a character value specifying the RDF language tag (excluding the "@" symbol), i.e. "fr"}
}
\value{
the Node object
}
\description{
A Node has an associated type corresponding to the RDF component that it is representing. The list of possible
types is "resource", "literal" or "blank".
}
\details{
The url=' and 'literal=' arguments determine which type of Node is created. The Node type affects how the Node is processed
in serialization, for example a Node created with 'node1 <- new("Node", literal="http://www.example.com")' is processed
differently that a Node created with 'node1 <- new("Node", url="http://www.example.com")', with the former being processed
as an RDF literal and the latter processed as an RDF resource.
}
\note{
Refer to https://www.w3.org/TR/rdf11-concepts information on language tags.
}
