% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/attributes.R
\name{is_weighted}
\alias{is.weighted}
\alias{is_weighted}
\title{Weighted graphs}
\usage{
is_weighted(graph)
}
\arguments{
\item{graph}{The input graph.}
}
\value{
A logical scalar.
}
\description{
In weighted graphs, a real number is assigned to each (directed or
undirected) edge.
}
\details{
In igraph edge weights are represented via an edge attribute, called
\sQuote{weight}. The \code{is_weighted} function only checks that such an
attribute exists. (It does not even checks that it is a numeric edge
attribute.)

Edge weights are used for different purposes by the different functions.
E.g. shortest path functions use it as the cost of the path; community
finding methods use it as the strength of the relationship between two
vertices, etc. Check the manual pages of the functions working with weighted
graphs for details.
}
\examples{
g <- make_ring(10)
shortest_paths(g, 8, 2)
E(g)$weight <- seq_len(ecount(g))
shortest_paths(g, 8, 2)
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\keyword{graphs}

