% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gene.R
\name{groupGenes}
\alias{groupGenes}
\title{Group sequences by gene assignment}
\usage{
groupGenes(data, v_call = "V_CALL", j_call = "J_CALL", first = FALSE)
}
\arguments{
\item{data}{data.frame containing sequence data.}

\item{v_call}{name of the column containing the V-segment allele calls.}

\item{j_call}{name of the column containing the J-segment allele calls.}

\item{first}{if \code{TRUE} only the first call of the gene assignments 
is used. if \code{FALSE} the union of ambiguous gene 
assignments is used to group all sequences with any 
overlapping gene calls.}
}
\value{
Returns a modified \code{data} data.frame with union indices 
          in the \code{VJ_GROUP} column.
}
\description{
\code{groupGenes} will group rows by shared V and J gene assignments. 
In the case of ambiguous (multiple) gene assignments, the grouping will
be a union across all ambiguous V and J gene pairs, analagous to 
single-linkage clustering (i.e., allowing for chaining).
}
\details{
All rows containing \code{NA} valies in their \code{v_call} or \code{j_call} column will be removed. 
A warning will be issued when a row containing an \code{NA} is removed.

Ambiguous gene assignments are assumed to be separated by commas.
}
\examples{
# Group by genes
db <- groupGenes(ExampleDb)
 
}
