% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods.R
\docType{methods}
\name{normalizationFactors}
\alias{normalizationFactors}
\alias{normalizationFactors,DESeqDataSet-method}
\alias{normalizationFactors<-}
\alias{normalizationFactors<-,DESeqDataSet,matrix-method}
\title{Accessor functions for the normalization factors in a DESeqDataSet
object.}
\usage{
normalizationFactors(object, ...)

normalizationFactors(object, ...) <- value

\S4method{normalizationFactors}{DESeqDataSet}(object)

\S4method{normalizationFactors}{DESeqDataSet,matrix}(object) <- value
}
\arguments{
\item{object}{a \code{DESeqDataSet} object.}

\item{...}{additional arguments}

\item{value}{the matrix of normalization factors}
}
\description{
Gene-specific normalization factors for each sample can be provided as a matrix,
which will preempt \code{\link{sizeFactors}}. In some experiments, counts for each
sample have varying dependence on covariates, e.g. on GC-content for sequencing
data run on different days, and in this case it makes sense to provide
gene-specific factors for each sample rather than a single size factor.
}
\details{
Normalization factors alter the model of \code{\link{DESeq}} in the following way, for
counts \eqn{K_{ij}}{K_ij} and normalization factors \eqn{NF_{ij}}{NF_ij} for gene i and sample j:

\deqn{ K_{ij} \sim \textrm{NB}( \mu_{ij}, \alpha_i) }{ K_ij ~ NB(mu_ij, alpha_i) }
\deqn{ \mu_{ij} = NF_{ij} q_{ij} }{ mu_ij = NF_ij q_ij }
}
\note{
Normalization factors are on the scale of the counts (similar to \code{\link{sizeFactors}})
and unlike offsets, which are typically on the scale of the predictors (in this case, log counts).
Normalization factors should include library size normalization. They should have
row-wise geometric mean near 1, as is the case with size factors, such that the mean of normalized
counts is close to the mean of unnormalized counts. See example code below.
}
\examples{

dds <- makeExampleDESeqDataSet(n=100, m=4)

normFactors <- matrix(runif(nrow(dds)*ncol(dds),0.5,1.5),
                      ncol=ncol(dds),nrow=nrow(dds),
                      dimnames=list(1:nrow(dds),1:ncol(dds)))

# the normalization factors matrix should not have 0's in it
# it should have geometric mean near 1 for each row
normFactors <- normFactors / exp(rowMeans(log(normFactors)))
normalizationFactors(dds) <- normFactors

dds <- DESeq(dds)

}

