/*
 *  Copyright (c) 2010 The WebM project authors. All Rights Reserved.
 *
 *  Use of this source code is governed by a BSD-style license
 *  that can be found in the LICENSE file in the root of the source
 *  tree. An additional intellectual property rights grant can be found
 *  in the file PATENTS.  All contributing project authors may
 *  be found in the AUTHORS file in the root of the source tree.
 */

#ifndef VP8_COMMON_DEFAULT_COEF_PROBS_H_
#define VP8_COMMON_DEFAULT_COEF_PROBS_H_

#ifdef __cplusplus
extern "C" {
#endif

/*Generated file, included by entropy.c*/

static const vp8_prob default_coef_probs
    [BLOCK_TYPES][COEF_BANDS][PREV_COEF_CONTEXTS][ENTROPY_NODES] = {
      {   /* Block Type ( 0 ) */
        { /* Coeff Band ( 0 )*/
          { 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128 },
          { 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128 },
          { 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128 } },
        { /* Coeff Band ( 1 )*/
          { 253, 136, 254, 255, 228, 219, 128, 128, 128, 128, 128 },
          { 189, 129, 242, 255, 227, 213, 255, 219, 128, 128, 128 },
          { 106, 126, 227, 252, 214, 209, 255, 255, 128, 128, 128 } },
        { /* Coeff Band ( 2 )*/
          { 1, 98, 248, 255, 236, 226, 255, 255, 128, 128, 128 },
          { 181, 133, 238, 254, 221, 234, 255, 154, 128, 128, 128 },
          { 78, 134, 202, 247, 198, 180, 255, 219, 128, 128, 128 } },
        { /* Coeff Band ( 3 )*/
          { 1, 185, 249, 255, 243, 255, 128, 128, 128, 128, 128 },
          { 184, 150, 247, 255, 236, 224, 128, 128, 128, 128, 128 },
          { 77, 110, 216, 255, 236, 230, 128, 128, 128, 128, 128 } },
        { /* Coeff Band ( 4 )*/
          { 1, 101, 251, 255, 241, 255, 128, 128, 128, 128, 128 },
          { 170, 139, 241, 252, 236, 209, 255, 255, 128, 128, 128 },
          { 37, 116, 196, 243, 228, 255, 255, 255, 128, 128, 128 } },
        { /* Coeff Band ( 5 )*/
          { 1, 204, 254, 255, 245, 255, 128, 128, 128, 128, 128 },
          { 207, 160, 250, 255, 238, 128, 128, 128, 128, 128, 128 },
          { 102, 103, 231, 255, 211, 171, 128, 128, 128, 128, 128 } },
        { /* Coeff Band ( 6 )*/
          { 1, 152, 252, 255, 240, 255, 128, 128, 128, 128, 128 },
          { 177, 135, 243, 255, 234, 225, 128, 128, 128, 128, 128 },
          { 80, 129, 211, 255, 194, 224, 128, 128, 128, 128, 128 } },
        { /* Coeff Band ( 7 )*/
          { 1, 1, 255, 128, 128, 128, 128, 128, 128, 128, 128 },
          { 246, 1, 255, 128, 128, 128, 128, 128, 128, 128, 128 },
          { 255, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128 } } },
      {   /* Block Type ( 1 ) */
        { /* Coeff Band ( 0 )*/
          { 198, 35, 237, 223, 193, 187, 162, 160, 145, 155, 62 },
          { 131, 45, 198, 221, 172, 176, 220, 157, 252, 221, 1 },
          { 68, 47, 146, 208, 149, 167, 221, 162, 255, 223, 128 } },
        { /* Coeff Band ( 1 )*/
          { 1, 149, 241, 255, 221, 224, 255, 255, 128, 128, 128 },
          { 184, 141, 234, 253, 222, 220, 255, 199, 128, 128, 128 },
          { 81, 99, 181, 242, 176, 190, 249, 202, 255, 255, 128 } },
        { /* Coeff Band ( 2 )*/
          { 1, 129, 232, 253, 214, 197, 242, 196, 255, 255, 128 },
          { 99, 121, 210, 250, 201, 198, 255, 202, 128, 128, 128 },
          { 23, 91, 163, 242, 170, 187, 247, 210, 255, 255, 128 } },
        { /* Coeff Band ( 3 )*/
          { 1, 200, 246, 255, 234, 255, 128, 128, 128, 128, 128 },
          { 109, 178, 241, 255, 231, 245, 255, 255, 128, 128, 128 },
          { 44, 130, 201, 253, 205, 192, 255, 255, 128, 128, 128 } },
        { /* Coeff Band ( 4 )*/
          { 1, 132, 239, 251, 219, 209, 255, 165, 128, 128, 128 },
          { 94, 136, 225, 251, 218, 190, 255, 255, 128, 128, 128 },
          { 22, 100, 174, 245, 186, 161, 255, 199, 128, 128, 128 } },
        { /* Coeff Band ( 5 )*/
          { 1, 182, 249, 255, 232, 235, 128, 128, 128, 128, 128 },
          { 124, 143, 241, 255, 227, 234, 128, 128, 128, 128, 128 },
          { 35, 77, 181, 251, 193, 211, 255, 205, 128, 128, 128 } },
        { /* Coeff Band ( 6 )*/
          { 1, 157, 247, 255, 236, 231, 255, 255, 128, 128, 128 },
          { 121, 141, 235, 255, 225, 227, 255, 255, 128, 128, 128 },
          { 45, 99, 188, 251, 195, 217, 255, 224, 128, 128, 128 } },
        { /* Coeff Band ( 7 )*/
          { 1, 1, 251, 255, 213, 255, 128, 128, 128, 128, 128 },
          { 203, 1, 248, 255, 255, 128, 128, 128, 128, 128, 128 },
          { 137, 1, 177, 255, 224, 255, 128, 128, 128, 128, 128 } } },
      {   /* Block Type ( 2 ) */
        { /* Coeff Band ( 0 )*/
          { 253, 9, 248, 251, 207, 208, 255, 192, 128, 128, 128 },
          { 175, 13, 224, 243, 193, 185, 249, 198, 255, 255, 128 },
          { 73, 17, 171, 221, 161, 179, 236, 167, 255, 234, 128 } },
        { /* Coeff Band ( 1 )*/
          { 1, 95, 247, 253, 212, 183, 255, 255, 128, 128, 128 },
          { 239, 90, 244, 250, 211, 209, 255, 255, 128, 128, 128 },
          { 155, 77, 195, 248, 188, 195, 255, 255, 128, 128, 128 } },
        { /* Coeff Band ( 2 )*/
          { 1, 24, 239, 251, 218, 219, 255, 205, 128, 128, 128 },
          { 201, 51, 219, 255, 196, 186, 128, 128, 128, 128, 128 },
          { 69, 46, 190, 239, 201, 218, 255, 228, 128, 128, 128 } },
        { /* Coeff Band ( 3 )*/
          { 1, 191, 251, 255, 255, 128, 128, 128, 128, 128, 128 },
          { 223, 165, 249, 255, 213, 255, 128, 128, 128, 128, 128 },
          { 141, 124, 248, 255, 255, 128, 128, 128, 128, 128, 128 } },
        { /* Coeff Band ( 4 )*/
          { 1, 16, 248, 255, 255, 128, 128, 128, 128, 128, 128 },
          { 190, 36, 230, 255, 236, 255, 128, 128, 128, 128, 128 },
          { 149, 1, 255, 128, 128, 128, 128, 128, 128, 128, 128 } },
        { /* Coeff Band ( 5 )*/
          { 1, 226, 255, 128, 128, 128, 128, 128, 128, 128, 128 },
          { 247, 192, 255, 128, 128, 128, 128, 128, 128, 128, 128 },
          { 240, 128, 255, 128, 128, 128, 128, 128, 128, 128, 128 } },
        { /* Coeff Band ( 6 )*/
          { 1, 134, 252, 255, 255, 128, 128, 128, 128, 128, 128 },
          { 213, 62, 250, 255, 255, 128, 128, 128, 128, 128, 128 },
          { 55, 93, 255, 128, 128, 128, 128, 128, 128, 128, 128 } },
        { /* Coeff Band ( 7 )*/
          { 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128 },
          { 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128 },
          { 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128 } } },
      {   /* Block Type ( 3 ) */
        { /* Coeff Band ( 0 )*/
          { 202, 24, 213, 235, 186, 191, 220, 160, 240, 175, 255 },
          { 126, 38, 182, 232, 169, 184, 228, 174, 255, 187, 128 },
          { 61, 46, 138, 219, 151, 178, 240, 170, 255, 216, 128 } },
        { /* Coeff Band ( 1 )*/
          { 1, 112, 230, 250, 199, 191, 247, 159, 255, 255, 128 },
          { 166, 109, 228, 252, 211, 215, 255, 174, 128, 128, 128 },
          { 39, 77, 162, 232, 172, 180, 245, 178, 255, 255, 128 } },
        { /* Coeff Band ( 2 )*/
          { 1, 52, 220, 246, 198, 199, 249, 220, 255, 255, 128 },
          { 124, 74, 191, 243, 183, 193, 250, 221, 255, 255, 128 },
          { 24, 71, 130, 219, 154, 170, 243, 182, 255, 255, 128 } },
        { /* Coeff Band ( 3 )*/
          { 1, 182, 225, 249, 219, 240, 255, 224, 128, 128, 128 },
          { 149, 150, 226, 252, 216, 205, 255, 171, 128, 128, 128 },
          { 28, 108, 170, 242, 183, 194, 254, 223, 255, 255, 128 } },
        { /* Coeff Band ( 4 )*/
          { 1, 81, 230, 252, 204, 203, 255, 192, 128, 128, 128 },
          { 123, 102, 209, 247, 188, 196, 255, 233, 128, 128, 128 },
          { 20, 95, 153, 243, 164, 173, 255, 203, 128, 128, 128 } },
        { /* Coeff Band ( 5 )*/
          { 1, 222, 248, 255, 216, 213, 128, 128, 128, 128, 128 },
          { 168, 175, 246, 252, 235, 205, 255, 255, 128, 128, 128 },
          { 47, 116, 215, 255, 211, 212, 255, 255, 128, 128, 128 } },
        { /* Coeff Band ( 6 )*/
          { 1, 121, 236, 253, 212, 214, 255, 255, 128, 128, 128 },
          { 141, 84, 213, 252, 201, 202, 255, 219, 128, 128, 128 },
          { 42, 80, 160, 240, 162, 185, 255, 205, 128, 128, 128 } },
        { /* Coeff Band ( 7 )*/
          { 1, 1, 255, 128, 128, 128, 128, 128, 128, 128, 128 },
          { 244, 1, 255, 128, 128, 128, 128, 128, 128, 128, 128 },
          { 238, 1, 255, 128, 128, 128, 128, 128, 128, 128, 128 } } }
    };

#ifdef __cplusplus
}  // extern "C"
#endif

#endif  // VP8_COMMON_DEFAULT_COEF_PROBS_H_
