/***********************************************************************
 *
 * Copyright (C) 2010-2016 Innocent De Marchi <tangram.peces@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 ***********************************************************************/
#include <QtCore>
#include <QtGui>

#include "tauler.h"
#include "fitxa.h"
#include "frmprincipal.h"
#include "moviment.h"
#include "rellotge.h"
#include "funcions.h"
#include "constants.h"

/****************************************
*
*15/12/10: S'ha canviat el sceneJoc: ara, cada
* vegada que es canvia la modalitat de joc,
* es crea un sceneJoc. D'aquesta manera, el joc
* queda sempre ben dimensionat.
*****************************************/


const double distanciaEntreFitxes = 1.2;

extern int jocResolt;

Tauler::Tauler(  QUndoStack *movimentsUndoStack , Rellotge *rellotge,frmPrincipal *frmPrincipal,  QWidget* parent )
  : QGraphicsView(parent),
  p_movimentsUndoStack(movimentsUndoStack),
  p_rellotge(rellotge),
  p_frmPrinci(frmPrincipal)
{
        QGraphicsScene* sceneJoc = new QGraphicsScene(this);
        sceneJoc = new QGraphicsScene(this);
        setScene(sceneJoc);
        setRenderHints(QPainter::Antialiasing | QPainter::TextAntialiasing);
        setFrameStyle(QFrame::NoFrame);
        setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
        setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
        //setMinimumSize(frmPrincipal->minimumSize());
        setMinimumSize(QSize(290,290));

        comptadorFitxesJoc=0;
        comptadorFitxesEstatZeroJoc=0;
        //inicialment es juga
        p_estatDelJoc=joc;
        p_SolitariAtzar=false;
        p_SolitariPersonalitzat=false;
}

/*
  Retorna l'estat de la fitxa amb les coordenades del paràmetre
  */
int Tauler::estatFitxaJoc( const  QPoint& coordenades) const {
    if (m_fitxes.contains(coordenades.x()*100+coordenades.y())){
       return m_fitxes.value(coordenades.x()*100+coordenades.y())->estat();
           }
   else return -1;
}

void Tauler::marcaMovimentsFitxa(QList<QPoint> movimentsFitxa){
    for (int i=0; i<movimentsFitxa.size();++i){
          m_fitxes.value(movimentsFitxa.at(i).x()*100+movimentsFitxa.at(i).y())->setEstat(3);
    }
}

 //Canvia l'estat de les fitxes per tal de marcar un moviment
void Tauler::marcaMoviment (QString moviment){
    QStringList moviments=moviment.split(" ");
    m_fitxes.value(moviments.value(0).toInt())->setEstat(2);
    m_fitxes.value(moviments.value(2).toInt())->setEstat(3);
}

/*
  Elimina els buits marcats com a final d'un moviment anterior
  */
void Tauler::eliminaMarquesMoviments(const  QPoint& coordenades){
    //QHashIterator <int, Fitxa*> i(m_fitxes);
    QMapIterator <int, Fitxa*> i(m_fitxes);
    while (i.hasNext()) {
        i.next();
        if (i.value()->estat()==3){
            i.value()->setEstat(0);
        }
        if(  (i.value()->estat()==2) && !(i.key()==(coordenades.x()*100+coordenades.y())) ){
            i.value()->setEstat(1);
        }
    }
}


void Tauler::ferMoviment (int fitxaInicial, int fitxaBotada, int fitxaFinal,bool missatge){
       Moviment* nouMoviment = new Moviment(fitxaInicial,fitxaBotada,fitxaFinal,p_tipusMoviment,this);
       /*qCritical("%s", qPrintable(QString("%1 %2 %3").
                                  arg(fitxaInicial).
                                  arg(fitxaBotada).
                                  arg(fitxaFinal)));*/
       p_movimentsUndoStack->push(nouMoviment);
       p_frmPrinci->iniciSolucioAction->setEnabled(p_movimentsUndoStack->canUndo());
       //NO es mostrarà el missatge en els solitaris
       //a l'atzar
       if( (p_estatDelJoc==joc) && missatge){
           p_frmPrinci->mostraMissatge(3);}
         //  p_frmPrinci->statusBar()->showMessage(missatgeNumeroMoviments());;}
       marcaFinalDeJoc(p_tipusMoviment,true);
       ocuparFitxesFinalJoc();
}

void Tauler::marcaFinalDeJoc(int direccioMoviment, bool marcaFinal){
    if( jocFinalitzat()){
        //QHashIterator <int, Fitxa*> i(m_fitxes);
        QMapIterator <int, Fitxa*> i(m_fitxes);
        int numFitxes=0, ordFitxa=0;
        int numFitxesFinalJoc=0;
        jocResolt=1;
        if(p_estatDelJoc==joc){            
            p_rellotge->aturaRellotge();
            p_frmPrinci->mostraMissatge(0);}
        //es posen les fitxes en color vermell
        while (i.hasNext()) {
              i.next();
              if (i.value()->estat()==1){
                  i.value()->setEstat(5);
                  numFitxes++;
                  ordFitxa=i.key();
                  if(i.value()->fitxaFinalJoc()){
                   numFitxesFinalJoc++;
                  }
              }          
        }

        //En les modalitats "inverses" no queda només una fitxa
        //Aqui es controla quan queda només una fitxa o
        //bé els casos en què hi ha fitxes marcades
        //com a final del joc
        if ( ( (numFitxes==1) && (direccioMoviment != 2)
               && comptadorFitxesFinalJoc==0 )
            || (nomesQuedenFitxesMarcadesFinalJoc() && (direccioMoviment != 2) )
                                    ) {
          jocResolt=2;
          p_rellotge->aturaRellotge();
          m_fitxes.value(ordFitxa)->setEstat(4);
          i.toFront();
          while (i.hasNext()) {
              i.next();
              if (i.value()->estat()==5){
                  i.value()->setEstat(4);
              }
          }
          p_frmPrinci->mostraMissatge(1);
          if(p_estatDelJoc==joc){
              controlaRecords();
              p_frmPrinci->desaSolucions1();
              p_frmPrinci->veureSolucionsSlot();}
        }

        /* La primera opció és pels jocs que començan amb una fitxa.
         * La segona, per aquells que començan amb més d'una fitxa
         * (i això és per a les modaltats inverses)
        */
          if ( ((numFitxes==numeroDeMovimentsJoc()+1) && (direccioMoviment == 2)
              && comptadorFitxesJoc==1)  ||
             ((numFitxes==numeroDeMovimentsJoc()+comptadorFitxesJoc) &&
             (direccioMoviment == 2)) ){
          i.toFront();
          while (i.hasNext()) {
              i.next();
              if (i.value()->estat()==5){
                  i.value()->setEstat(4);
              }
          }
          p_rellotge->aturaRellotge();
          jocResolt=2;
          p_frmPrinci->mostraMissatge(1);
          if(p_estatDelJoc==joc){
              controlaRecords();
              p_frmPrinci->desaSolucions1();
              p_frmPrinci->veureSolucionsSlot();}
        }
     //14/12/12 Evita que quedin les fitxes bloquejades quan NO es
     //resol el joc
     //03/01/12  què????
     //04/01/12 S'ha deixat que quedin bloquejades les fitxes quan
     //s'hagi resolt el joc
     //if (jocResolt==2){
       //  setInteractive(false);}

     /*si es tracta d'un solitari personalitzat,
      *cal comprovar si s'ha de desar
      */
     if( (solitariPersonalitzat()) && (jocResolt==2) &&
         (p_estatDelJoc==joc) && marcaFinal){
         p_frmPrinci->solitariPersonalitzat_desarSolitari();
     }

    }// final if jocResolt()

}

/*
 * Comprova si només queden fitxes marcades com a final
 * de joc (i estan activades!)
 */
bool Tauler::nomesQuedenFitxesMarcadesFinalJoc(){
  //QHashIterator <int, Fitxa*> i(m_fitxes);
  QMapIterator <int, Fitxa*> i(m_fitxes);
  bool nomesFinalJoc=true;
  while (i.hasNext()) {
        i.next();
       // if ( ( ( (i.value()->estat()==1) || (i.value()->estat()==5) ) &&
        if ( (  (i.value()->estat() != 0) &&
             (!i.value()->fitxaFinalJoc())
                                   ) ||
            ((i.value()->estat()==0) &&
                (i.value()->fitxaFinalJoc()))
                                            ) {
             nomesFinalJoc=false;
       }
   }
  return nomesFinalJoc;
  }

/*
  Comprova, desprès de cada moviment, si el joc s'ha acabat
  El joc s'ha acabat si només queda una fitxa (o totes en
  les modalitats inverses)
  si només queden les fitxes (ocupades) marcades
  com a final de joc
  o si les fitxes que queden no son final de joc
  i no es poden moure
  */
bool Tauler::jocFinalitzat(){

   //QHashIterator <int, Fitxa*> i(m_fitxes);
   QMapIterator <int, Fitxa*> i(m_fitxes);
   //Pressuposam que el joc ha acabat
   bool finalitzat=true;
   while (i.hasNext()) {
        i.next();
        //Només comprovam les fitxes actives!
        if ( (i.value()->estat()==1) ){
            /* Si la fitxa es pot moure i
             * no està marcada com a final
             * del joc-> el joc no ha acabat
             */
            if  (i.value()->esPotMoure() &&
                !i.value()->fitxaFinalJoc()){
                finalitzat=false;
                break;
             }

            /* La fitxa es pot moure, però està marcada com
             * a final de joc i queden altres fitxes que
             * no estan marcades com a final de joc
             */
            if (
                 i.value()->esPotMoure() &&
                 i.value()->fitxaFinalJoc() &&
                 !nomesQuedenFitxesMarcadesFinalJoc()
                                   ){
                finalitzat=false;
                break;
                }
            if(p_tipusMoviment==2 && i.value()->esPotMoure()){
                finalitzat=false;
                break;
            }
            if( i.value()->fitxaFinalJoc() &&
                !nomesQuedenFitxesMarcadesFinalJoc()){
              finalitzat=false;
              break;
            }
        }
    }
 return finalitzat;
}

void Tauler::controlaRecords(){
    //dels solitaris especials no es desen els records
    if( !esSolitariEspecial()){
    QSettings records;
    QString record=records.value(QString("%1/record").arg(p_modalitatJocActual),QString("100:00:00")).toString();
    if (p_rellotge->retornaTemps(1)< record){
        QSettings().setValue(QString("%1/record").arg(p_modalitatJocActual), p_rellotge->retornaTemps(1));
        //missatge nou record personal
        p_frmPrinci->mostraMissatge(2);
    }
  }
  //  else qDebug("és una solitari especial! %d",p_modalitatJocActual.toInt());
}

/*
Carrega les fitxes de la modalitat de joc passada per paràmetre
  */
void Tauler::joc_CarregaJoc( QString p_tipusJoc, QString p_filesColumnes, QString p_estatFitxes){
    /*
     *Això fa que es «redimensioni» correctament el tauler
     *de joc quan es canvia de modalitat
     */
    scene()->clear();
    QGraphicsScene* sceneJoc1 = new QGraphicsScene(this);
    setScene(sceneJoc1);

    p_rellotge->aturaRellotge();
    p_rellotge->estableixTemps(QString("00:00:00"));
    comptadorFitxesJoc=0;
    comptadorFitxesEstatZeroJoc=0;
    p_estatDelJoc=joc;

/*qCritical("p_tipusJoc %s", qUtf8Printable(p_tipusJoc));
qCritical("p_filesColumnes %s", qUtf8Printable(p_filesColumnes));
qCritical("p_estatFitxes %s", qUtf8Printable(p_estatFitxes));*/

    QStringList  tipusJoc = p_tipusJoc.split(" ");
    setModalitatJocActual(tipusJoc.value(0));
    //Comprovam els solitaris especials (atzar i personalitzats)
    //setSolitariEspecial(p_modalitatJocActual);
    QStringList  filesColumnes= p_filesColumnes.split(" ");
    QStringList  estatFitxes = p_estatFitxes.split(" ");
    p_tipusMoviment=tipusJoc.value(1).toInt();
    p_numFitxesAillades=tipusJoc.value(2).toInt();
    p_numMoviments=tipusJoc.value(3).toInt();
    if ( (p_tipusMoviment==2) || (p_tipusMoviment==5) ){p_estatFitxaMitjana=0;}
    else {p_estatFitxaMitjana=1;}

    int files, columnes;
    files= filesColumnes.value(0).toInt();
    columnes=filesColumnes.value(1).toInt();
    m_fitxes.clear();
    if (columnes>0){
        for(int j=0 ; j<files;++j){
              for(int i=0 ; i<columnes;++i){
                   if(estatFitxes.value(j*columnes+i).toInt()>-1){
                       QPoint coord(j,i); //fila i columna
                       Fitxa *fitxa= new Fitxa(this);
                       fitxa->setCoordenades(coord);
                       fitxa->setEstat(estatFitxes.value(j*columnes+i).toInt());
                      // qDebug("%d",estatFitxes.value(j*columnes+i).toInt());
                       /*qCritical("%s", qPrintable(QString("Contador %1 estatFitxa %2")
                                                  .arg(estatFitxes.value(j*columnes+i).toInt())
                                                  .arg(estatFitxes.value(j*columnes+i).toInt())));*/
                       //fitxa->setFitxaSolitariPersonalitzat(false);
                       fitxa->setTipusMoviment(tipusJoc.value(1).toInt());
                       fitxa->setPos(fitxa->coordenades().y()*distanciaEntreFitxes*30,
                                             fitxa->coordenades().x()*distanciaEntreFitxes*30);
                       m_fitxes.insert(coord.x()*100+coord.y(),fitxa);
                       //qDebug("Insertada fitxa %d",coord.x()*100+coord.y());
                       //configuracioActual(false);
                       scene()->addItem(fitxa);
                       if (fitxa->estat()==1) {++comptadorFitxesJoc;}
                       if (fitxa->estat()==0){++comptadorFitxesEstatZeroJoc;}
                   }//if estatFitxes
               } //for columnes
           }//for files
 }
    else { //Solitaris de tipus triangular
    int contador=0;
    for(int j=0 ; j<files;++j){
               for(int i=0; i<j;++i){
                   //Afegit el if pel solitari tipus Rombe
                   if (estatFitxes.value(contador).toInt()>-1){
                       QPoint coord(j-1,i); //fila i columna
                       Fitxa *fitxa= new Fitxa(this);
                       fitxa->setEstat(estatFitxes.value(contador).toInt());
                      /* qCritical("%s", qPrintable(QString("Contador %1 estatFitxa %2")
                                                  .arg(contador)
                                                  .arg(estatFitxes.value(contador).toInt())));*/
                       fitxa->setTipusMoviment(tipusJoc.value(1).toInt());
                       fitxa->setCoordenades(coord);
                       fitxa->setPos( fitxa->coordenades().y()*distanciaEntreFitxes*30-15*1.2*j,
                                             fitxa->coordenades().x()*distanciaEntreFitxes*30+4*j);
                    //   fitxa->setPos( fitxa->coordenades().y()*distanciaEntreFitxes*30-15*1.2*j,
                     //                        fitxa->coordenades().x()*distanciaEntreFitxes*30);
                     //  qDebug("fitxa %d,%d",fitxa->pos().x(),fitxa->pos().y());
                       m_fitxes.insert(coord.x()*100+coord.y(),fitxa);
                       scene()->addItem(fitxa);
                       if (fitxa->estat() == 1) {++comptadorFitxesJoc;}
                       if (fitxa->estat()==0){++comptadorFitxesEstatZeroJoc;}
                        }//if estat fitxa
                       ++contador;
               } //for columnes
           }//for files
    }
p_movimentsUndoStack->clear();
configuracioActual(false);
setInteractive(true);
//Això per a què s'ajusti a la finestra
fitInView(sceneRect(), Qt::KeepAspectRatio);
}

/*Controla els tipus de joc especials
 */
void Tauler::setSolitariEspecial(QString codiJoc){
  //pressuposam que no és un solitari especial
  setSolitariAtzar(false);
  setSolitariPersonalitzat(false);
  //Marcam els jocs a l'atzar
  setSolitariAtzar(codiJoc=="1000");
  //marcam els jocs personalitzats
  setSolitariPersonalitzat(
   codiJoc=="1001" || codiJoc=="1002" ||codiJoc=="1003" );
}

/*
 * En els jocs amb fitxes finals marcades,
 * controla si el número de moviments per acabar
 * el joc permet deixar les fitxes finals ocupades
 */
bool Tauler::ocuparFitxesFinalJoc(){
  bool resultat=true;
  /* Si és un joc amb fitxes marcades com a final del joc
   */
  //QHashIterator <int, Fitxa*> fitxesFinalsJoc(m_fitxes);
  QMapIterator <int, Fitxa*> fitxesFinalsJoc(m_fitxes);
  bool ambFitxesFinalJoc=false;
  while (fitxesFinalsJoc.hasNext()) {
       fitxesFinalsJoc.next();
       if ( (fitxesFinalsJoc.value()->fitxaFinalJoc()) ){
         ambFitxesFinalJoc=true;
       }
  }
  if(ambFitxesFinalJoc){
   resultat=( (numeroFitxesFinalsSenseOcupar()<4) &&
              (numeroFitxesPerEliminar()>numeroFitxesFinalsSenseOcupar()) );
  }
  return resultat;
}

/* Retorna el número de fitxes marcades com a final
 * del joc que estan sense ocupar
 */
int Tauler::numeroFitxesFinalsSenseOcupar(){
    //QHashIterator <int, Fitxa*> fitxesFinalsJoc(m_fitxes);
    QMapIterator <int, Fitxa*> fitxesFinalsJoc(m_fitxes);
    int numeroFitxesFinalJoc=0;
    while (fitxesFinalsJoc.hasNext()) {
         fitxesFinalsJoc.next();
         if ( (fitxesFinalsJoc.value()->fitxaFinalJoc()) &&
             fitxesFinalsJoc.value()->estat()==0){
           numeroFitxesFinalJoc++;
         }
    }
   return numeroFitxesFinalJoc;
}

/* Calcula quantes fitxes cal eliminar per acabar
 * el joc (fitxes actives que no estan marcades com
 * a final de joc)
 */
int Tauler::numeroFitxesPerEliminar(){
    //QHashIterator <int, Fitxa*> fitxesFinalsJoc(m_fitxes);
    QMapIterator <int, Fitxa*> fitxesFinalsJoc(m_fitxes);
    int numeroFitxesFinalJoc=0;
    while (fitxesFinalsJoc.hasNext()) {
         fitxesFinalsJoc.next();
         if ( !(fitxesFinalsJoc.value()->fitxaFinalJoc()) &&
             fitxesFinalsJoc.value()->estat()==1){
           numeroFitxesFinalJoc++;
         }
    }
   return numeroFitxesFinalJoc;
}

 void Tauler::resizeEvent(QResizeEvent* event) {
        fitInView(sceneRect(), Qt::KeepAspectRatio);
        QGraphicsView::resizeEvent(event);
}

 /*
   Per a cada fitxa del joc, calcula els moviments possibles
   i els posa en el QList movimentsPossibles de cada fitxa
   */
 void Tauler::solucionaJocActual_CalculaMovimentsPosibles(){
      //Per a cada fitxa del joc, calcula els possibles moviments
     //i es desen a la QList fitxa.movimentsPossibles
     //QHashIterator <int, Fitxa*> iterator_fitxes(m_fitxes);
     QMapIterator <int, Fitxa*> iterator_fitxes(m_fitxes);
     while (iterator_fitxes.hasNext()) {
        iterator_fitxes.next();
        iterator_fitxes.value()->calculaMovimentsPosiblesFitxa();
     }
 }

 /* Comprova els moviments possibles, els selecciona segons diversos
  * criteris i preferències, i retorna una llista amb els moviments
  * preferits
  */
 QStringList Tauler::solucionaJocActual_CarregaMovimentsArbre
                     (QStringList movimentsFets, QString darrerMoviment){

    //QHashIterator <int, Fitxa*> iterator_fitxes(m_fitxes);
    QMapIterator <int, Fitxa*> iterator_fitxes(m_fitxes);
    QStringList itemsArbre; //tots els moviments possibles
    QStringList itemsArbre1;//moviments que enllaçan amb l'anterior
    QStringList itemsArbre2;//moviments per preferència
    QStringList itemsArbre3;//moviments per preferència que enllaçan amb l'anterior
    QStringList itemsArbre4;//moviments per nivell d'aïllament de les fitxes
    QStringList itemsArbre5;//moviments pel número de moviments posteriors
    QStringList itemsArbre6;//moviments que cumpleixen almenys 3 requisits

    solucionaJocActual_FitxesAillades1();
    /* Número de moviments que es faran al principi a l'atzar*/
    int numeroMovimentsInicialsAtzar=qrand() % comptadorFitxesJoc;
   // int numeroMovimentsInicialsAtzar=round(comptadorFitxesJoc*0.4);
    //qDebug("numeroMovimentsInicialsAtzar %d", numeroMovimentsInicialsAtzar);
    int preferenciaMenor=200;
    int aillamentMajor=0;
      while (iterator_fitxes.hasNext()) {
        iterator_fitxes.next();
        int index_fitxaInicial=
            iterator_fitxes.value()->coordenades().x()*100+
            iterator_fitxes.value()->coordenades().y();
        //només comprovam les fitxes actives
       if ( m_fitxes.value(index_fitxaInicial)->estat()==1){
        int movimentsPosibles=0;
        //qDebug("movimentsPossibles.count() %d",iterator_fitxes.value()->movimentsPossibles.count());
        for(int j=0 ; j<iterator_fitxes.value()->movimentsPossibles.count();++j){
            int index_fitxaBotada=iterator_fitxes.value()->movimentsPossibles.at(j).x();
            int index_fitxaFinal=iterator_fitxes.value()->movimentsPossibles.at(j).y();
            //qDebug("p_estatFitxaMitjana %d ",p_estatFitxaMitjana);
            if (   (m_fitxes.value(index_fitxaBotada)->estat()==p_estatFitxaMitjana) &&
                (m_fitxes.value(index_fitxaFinal)->estat()==0) ){
                QString moviment=QString("%1 %2 %3").arg(
                        index_fitxaInicial).arg(
                        index_fitxaBotada).arg(
                        index_fitxaFinal);
               //és possible aquest moviment
              if ( (movimentsFets.indexOf(QString("%1 %2").arg(p_movimentsUndoStack->index()+1).
                   arg(moviment))==-1)
                 //Aquesta condició no és eficient 19/12/11
                 // && (solucionaJocActual_CalculaMovimentsPosteriors(moviment))
                   ){
                itemsArbre.append(moviment);
                ++movimentsPosibles;
                /*Això s'ha posat una mica més abaix.
                  La intenció és aconseguir més diversitat en els primers moviments
                  del joc */
                /*if (p_movimentsUndoStack->index()<numeroMovimentsInicialsAtzar){
                    qDebug("Condició itemsArbre.count() %d", itemsArbre.count());
                    return itemsArbre;}*/
                }
               }
           } //for
         if (movimentsPosibles>0){
          //   m_fitxes.value(index_fitxaInicial)->setPreferenciaMoure(movimentsPosibles);
             preferenciaMenor=qMin(preferenciaMenor,m_fitxes.value(index_fitxaInicial)->preferenciaMoure());
             aillamentMajor=qMax(aillamentMajor,m_fitxes.value(index_fitxaInicial)->nivellAillament());
         }
        }//if inicial estat==1
      }

      /* Si no hi ha moviments possibles, no val la pena perdre el temps!*/
      if(itemsArbre.count()<1){return itemsArbre;}
      /* Per als primers moviments del joc, no es seleccionan tant els moviments */
      if (p_movimentsUndoStack->index()<numeroMovimentsInicialsAtzar){
          return itemsArbre;}

      //Miram quins moviments maximitzen el número de moviments posteriors
      itemsArbre5=solucionaJocActual_CalculaNumeroMovimentsPosteriors(itemsArbre);

      //Miram si és possible enllaçar algun dels moviments amb el darrerMoviment
     QStringList fitxesDarrerMoviment=QStringList(darrerMoviment.split(" "));
     if (fitxesDarrerMoviment.count()>0){
   //  QString fitxaFinalDarrerMoviment=fitxesDarrerMoviment.value(fitxesDarrerMoviment.count()-1);
     for(int j=0 ; j<itemsArbre.count();++j){
         QStringList fitxesMovimentArbre=QStringList(itemsArbre.value(j).split(" "));
         //final actual i inicial anterior
         if (   ( fitxesMovimentArbre.value(2).contains(fitxesDarrerMoviment.value(0)) ) ||
         //final actual i mitjana anterior
             ( fitxesMovimentArbre.value(2).contains(fitxesDarrerMoviment.value(1)))   ||
         //mitjana actual i final anterior
             ( fitxesMovimentArbre.value(1).contains(fitxesDarrerMoviment.value(2)))  ||
         //inicial actual i final anterior
             ( fitxesMovimentArbre.value(0).contains(fitxesDarrerMoviment.value(2)))  ){
             itemsArbre1.append(itemsArbre.value(j));
           //  if (p_movimentsUndoStack->index()>numeroMovimentsInicialsAtzar ){return itemsArbre1;}

             if (m_fitxes.value(fitxesMovimentArbre.value(0).toInt())->preferenciaMoure()==preferenciaMenor){
                itemsArbre3.prepend(itemsArbre.value(j));
              //  if (p_movimentsUndoStack->index()>numeroMovimentsInicialsAtzar ){return itemsArbre3;}
               }
         }
         if (m_fitxes.value(fitxesMovimentArbre.value(0).toInt())->preferenciaMoure()==preferenciaMenor ){
            itemsArbre2.prepend(itemsArbre.value(j));
           // if (p_movimentsUndoStack->index()>numeroMovimentsInicialsAtzar ){return itemsArbre2;}
          }

         if (m_fitxes.value(fitxesMovimentArbre.value(0).toInt())->preferenciaMoure()==aillamentMajor ){
            itemsArbre4.prepend(itemsArbre.value(j));
          //  if (p_movimentsUndoStack->index()>numeroMovimentsInicialsAtzar ){return itemsArbre4;}
          }
       }//for
    }// if fitxesDarrerMoviment.count()


for(int j=0 ; j<itemsArbre.count();++j){
    int repeticio=0;
    if (itemsArbre1.contains(itemsArbre.value(j))) {++repeticio;}
    if (itemsArbre2.contains(itemsArbre.value(j))) {++repeticio;}
    if (itemsArbre3.contains(itemsArbre.value(j))) {++repeticio;}
    if (itemsArbre4.contains(itemsArbre.value(j))) {++repeticio;}
    if (itemsArbre5.contains(itemsArbre.value(j))) {++repeticio;}
    if (repeticio>2){itemsArbre6.append(itemsArbre.value(j));}
}
//qDebug("itemsArbre6.count() %d", itemsArbre6.count());
QStringList movimentsSelecionats;
/*  versió 2.0 moviments que cumpleixen més de 3 requisits
      if (itemsArbre6.count()>0){return itemsArbre6;}
      //moviments per nivell d'aïllament de les fitxes
      else if (itemsArbre4.count()>0){return itemsArbre4;}
      //moviments per preferència que enllaçan amb l'anterior
      else if (itemsArbre3.count()>0){return itemsArbre3;}
      //moviments pel número de moviments posteriors
      else  if (itemsArbre5.count()>0){return itemsArbre5;}
      //moviments que enllaçan amb l'anterior
      else  if (itemsArbre1.count()>0){return itemsArbre1;}
      //moviments per preferència
      else if (itemsArbre2.count()>0){return itemsArbre2;}
      else return itemsArbre;*/

/*
if (itemsArbre5.count()>0){movimentsSelecionats.append(itemsArbre5);}
else if (itemsArbre2.count()>0){movimentsSelecionats.append(itemsArbre2);}
else if (itemsArbre6.count()>0){movimentsSelecionats.append(itemsArbre6);}
//else  if (itemsArbre6.count()>0){movimentsSelecionats.append(itemsArbre6);}
//else  if (itemsArbre2.count()>0){movimentsSelecionats.append(itemsArbre2);}
//else if (itemsArbre1.count()>0){movimentsSelecionats.append(itemsArbre1);}
else movimentsSelecionats.append(itemsArbre);
*/

/*
if (itemsArbre6.count()>0){return itemsArbre6;}
else if (itemsArbre4.count()>0){return itemsArbre4;}
else if (itemsArbre5.count()>0){return itemsArbre5;}
else if (itemsArbre2.count()>0){return itemsArbre2;}
else if (itemsArbre3.count()>0){return itemsArbre3;}
else  if (itemsArbre1.count()>0){return itemsArbre1;}
else movimentsSelecionats.append(itemsArbre);
*/

/*15/09/16 No està clar quina opció és millor*/
movimentsSelecionats.append(itemsArbre5);
movimentsSelecionats.append(itemsArbre2);
movimentsSelecionats.append(itemsArbre6);
if (movimentsSelecionats.count()<1){movimentsSelecionats.append(itemsArbre);}


/*
    QStringList itemsArbre; //tots els moviments possibles
    QStringList itemsArbre1;//moviments que enllaçan amb l'anterior
    QStringList itemsArbre2;//moviments per preferència
    QStringList itemsArbre3;//moviments per preferència que enllaçan amb l'anterior
    QStringList itemsArbre4;//moviments per nivell d'aïllament de les fitxes
    QStringList itemsArbre5;//moviments pel número de moviments posteriors
    QStringList itemsArbre6;//moviments que cumpleixen almenys 3 requisits    
*/

//Ara comprova si hi ha algun moviment que te com a final una fitxa
//marcada com a final de joc
if(comptadorFitxesFinalJoc>0){
   // qDebug("movimentsSelecionats.count() %d",movimentsSelecionats.size());
 QStringList movimentsAmbFitxaFinalJoc;
 for(int v=0 ; v<movimentsSelecionats.count();++v){
   //qDebug("EN EL FOR");
   QStringList fitxes=
           QStringList(movimentsSelecionats.value(v).split(" "));
   if (m_fitxes.value(
       fitxes.value(2).toInt())->fitxaFinalJoc()){
       //qDebug("FITXA FINAL!");
       movimentsAmbFitxaFinalJoc.append(movimentsSelecionats.value(v));
   }
 }
 if(movimentsAmbFitxaFinalJoc.count()>0){
     //qDebug("*** hi ha moviments finals");
   movimentsSelecionats.clear();
   movimentsSelecionats.append(movimentsAmbFitxaFinalJoc);
 }
 //else qDebug("no hi ha moviments finals");
}
/*
 qDebug("itemsArbre1.count() %d", itemsArbre1.count());
 qDebug("itemsArbre2.count() %d", itemsArbre2.count());
 qDebug("itemsArbre3.count() %d", itemsArbre3.count());
 qDebug("itemsArbre4.count() %d", itemsArbre4.count());
 qDebug("itemsArbre5.count() %d", itemsArbre5.count());
 qDebug("itemsArbre6.count() %d", itemsArbre6.count());
 qDebug("movimentsSelecionats.count() %d", movimentsSelecionats.count());
 qDebug("*****************");*/
 return movimentsSelecionats;
// return itemsArbre;
}

 /*
   Per a cada un dels moviments passats, calcula el nombre de moviments posibles
   després de fer els moviments passats.
   Retorna la clau del Has de la fitxa amb més moviments
   */
 QStringList Tauler::solucionaJocActual_CalculaNumeroMovimentsPosteriors(QStringList movimentsPosibles){
     //qDebug("solucionaJocActual_CalculaNumeroMovimentsPosteriors");     
     QList <int> llistaNumeroMoviments;
     for(int j=0 ; j<movimentsPosibles.count();++j){
         //Primer "simulam" el moviment
         QStringList moviment=QStringList(movimentsPosibles.value(j).split(" "));
         if ( (p_tipusMoviment != 2) && (p_tipusMoviment != 5)){
             m_fitxes.value(moviment.value(0).toInt())->setEstat(0);
             m_fitxes.value(moviment.value(1).toInt())->setEstat(0);
             m_fitxes.value(moviment.value(2).toInt())->setEstat(1);
             /* 09/09/16 Canviat
              * Ara calculam el número de moviments possibles amb aquesta situació
              */
             llistaNumeroMoviments.append(solucionaJocActual_MovimentsPosiblesActuals());
             /*if (numeroMoviments>maxNumMoviments){
                 maxNumMoviments=numeroMoviments;
                 if(llistaMovimentsMaxims.count()>0){
                 llistaMovimentsMaxims.removeLast();}
                 llistaMovimentsMaxims.append(movimentsPosibles.value(j));
             }*/
             //desfem el moviment
             m_fitxes.value(moviment.value(0).toInt())->setEstat(1);
             m_fitxes.value(moviment.value(1).toInt())->setEstat(1);
             m_fitxes.value(moviment.value(2).toInt())->setEstat(0);
         }//if p_tipusMoviment != 2
         else {
             m_fitxes.value(moviment.value(0).toInt())->setEstat(0);
             m_fitxes.value(moviment.value(1).toInt())->setEstat(1);
             m_fitxes.value(moviment.value(2).toInt())->setEstat(1);
             //Ara calculam el número de moviments possibles amb aquesta situació
             llistaNumeroMoviments.append(solucionaJocActual_MovimentsPosiblesActuals());
            /* if (numeroMoviments>maxNumMoviments){
                 maxNumMoviments=numeroMoviments;
                 if(llistaMovimentsMaxims.count()>0){
                 llistaMovimentsMaxims.removeLast();}
                 llistaMovimentsMaxims.append(movimentsPosibles.value(j));
             }*/
             //desfem el moviment
             m_fitxes.value(moviment.value(0).toInt())->setEstat(1);
             m_fitxes.value(moviment.value(1).toInt())->setEstat(0);
             m_fitxes.value(moviment.value(2).toInt())->setEstat(0);
         }//else p_tipusMoviment != 2
     }//for

  return solucionaJocActual_SeleccionaNumeroMovimentsPosteriors(movimentsPosibles,llistaNumeroMoviments);

  //qDebug("llistaMovimentsMaxims.count() %d", llistaMovimentsMaxims.count());
  //return llistaMovimentsMaxims;
 }

/* Dels moviments possibles, selecciona els que tenen el major nombre de moviments
 * posteriors
 */
QStringList Tauler::solucionaJocActual_SeleccionaNumeroMovimentsPosteriors(QStringList llistaMovimentsMaxims,
                                                                           QList <int> llistaNumeroMoviments){
  /* Màxim nombre de moviments*/
  int maximNombreDeMoviments=0;
  for(int j=0 ; j<llistaNumeroMoviments.count();++j){
     if(llistaNumeroMoviments.value(j)>maximNombreDeMoviments){
       maximNombreDeMoviments=llistaNumeroMoviments.value(j);
      // qDebug("maximNombreDeMoviments %d", maximNombreDeMoviments);
     }

  }
  /* Seleccionam els moviments que maximitzam el nombre de moviments posteriors*/
  QStringList movimentsMaxims;
  for(int j=0 ; j<llistaNumeroMoviments.count();++j){
     if(llistaNumeroMoviments.value(j)==maximNombreDeMoviments){
       movimentsMaxims.append(llistaMovimentsMaxims.value(j));
     }
  }
 //qDebug("movimentsMaxims.count() %d", movimentsMaxims.count());
 return movimentsMaxims;
}

 /* Comprova si s'ha arribat al final del joc. Això
  * és molt útil en les modalitats que tenen el final
  * de joc marcat
  */
bool Tauler::arribatFinalJoc(){
//QHashIterator <int, Fitxa*> iterator_fitxes(m_fitxes);
QMapIterator <int, Fitxa*> iterator_fitxes(m_fitxes);
int numeroFitxesActives=0;
while (iterator_fitxes.hasNext()) {
   iterator_fitxes.next();
   if ( iterator_fitxes.value()->estat()==1){
    ++numeroFitxesActives;}
}
bool finalDeJoc=false;
    if( (numeroFitxesActives==1) &&  (p_tipusMoviment != 2)
        && (comptadorFitxesFinalJoc==0) ){finalDeJoc=true;}
    else if ((nomesQuedenFitxesMarcadesFinalJoc())
             && (p_tipusMoviment != 2)){finalDeJoc=true;}
    else if ( (numeroFitxesActives==numeroDeMovimentsJoc()+1) )
            {finalDeJoc=true;}
 return finalDeJoc;
 }

 /*
   Per el moviment passat per paràmetre, comprova si hi ha
   moviments posteriors
   Cal tenir en compte que pot ésser el darrer moviment!!!
   19/11/12 Aquest proc. no pareix ésser eficaç. Ara no es fa
   servir

 bool Tauler::solucionaJocActual_CalculaMovimentsPosteriors(QString moviment){
         int numeroMoviments=0;
         //Primer "simulam" el moviment
         QStringList fitxes=QStringList(moviment.split(" "));
         if ( (p_tipusMoviment != 2) && (p_tipusMoviment != 5)){
         m_fitxes.value(fitxes.value(0).toInt())->setEstat(0);
         m_fitxes.value(fitxes.value(1).toInt())->setEstat(0);
         m_fitxes.value(fitxes.value(2).toInt())->setEstat(1);
         //Ara calculam el número de moviments possibles amb aquesta situació
         numeroMoviments=solucionaJocActual_MovimentsPosiblesActuals();

         //desfem el moviment
         m_fitxes.value(fitxes.value(0).toInt())->setEstat(1);
         m_fitxes.value(fitxes.value(1).toInt())->setEstat(1);
         m_fitxes.value(fitxes.value(2).toInt())->setEstat(0);}
      else {
         m_fitxes.value(fitxes.value(0).toInt())->setEstat(0);
         m_fitxes.value(fitxes.value(1).toInt())->setEstat(1);
         m_fitxes.value(fitxes.value(2).toInt())->setEstat(1);
         //Ara calculam el número de moviments possibles amb aquesta situació
         numeroMoviments=solucionaJocActual_MovimentsPosiblesActuals();
         //desfem el moviment
         m_fitxes.value(fitxes.value(0).toInt())->setEstat(1);
         m_fitxes.value(fitxes.value(1).toInt())->setEstat(0);
         m_fitxes.value(fitxes.value(2).toInt())->setEstat(0);}

   //Comprovam si estem al final del joc
  // if(arribatFinalJoc()){numeroMoviments=qMax(numeroMoviments,1);}

     return numeroMoviments>0;
 }
 */

/* Calcula el nombre de moviments reals de la configuració actual
 */
 int Tauler::solucionaJocActual_MovimentsPosiblesActuals(){ 
    QMapIterator <int, Fitxa*> iterator_fitxes(m_fitxes);
   // QHashIterator <int, Fitxa*> iterator_fitxes(m_fitxes);

    int movimentsPosibles=0;
    int numeroFitxesActives=0;
      while (iterator_fitxes.hasNext()) {
          iterator_fitxes.next();
        int index_fitxaInicial=iterator_fitxes.value()->coordenades().x()*100+iterator_fitxes.value()->coordenades().y();
        //només comprovam les fitxes actives
       if ( m_fitxes.value(index_fitxaInicial)->estat()==1){
        ++numeroFitxesActives;
        for(int j=0 ; j<iterator_fitxes.value()->movimentsPossibles.count();++j){
            int index_fitxaBotada=iterator_fitxes.value()->movimentsPossibles.at(j).x();
            int index_fitxaFinal=iterator_fitxes.value()->movimentsPossibles.at(j).y();
            if (   (m_fitxes.value(index_fitxaBotada)->estat()==p_estatFitxaMitjana) &&
                (m_fitxes.value(index_fitxaFinal)->estat()==0) ){
                ++movimentsPosibles;                
               }
           } //for
        }//if inicial estat==1
      }

if (arribatFinalJoc()){movimentsPosibles=qMax(movimentsPosibles,1);}

 return movimentsPosibles;
 }

 /*
   Comprova si hi ha alguna fitxa "aïllada"
   o sigui fitxes en estat 1 que no tenen cap moviment
   que es pugui fer efectiu o be cap moviment en què
   la fitxa mitjancera pugui passar a estat 1 desprès d'un moviment
   18/11/12 aques proc. no pareix molt eficaç
   03/09/16 Substituït pel procediement solucionaJocActual_FitxesAillades1()
   a la versió 2.1
   *
 bool Tauler::solucionaJocActual_FitxesAillades(){
     qDebug("Inici aillades*************");
     // Aquest procediment no és eficient
     // amb la modalitat inversa
     if(p_tipusMoviment==2){return false;}
     solucionaJocActual_CalculaMovimentsPosibles();
    // 22/08/16 Això no es fa servir per res
     //int nivellAillamentFitxes=0;
     int numeroFitxesAillades=0;
     //QHashIterator <int, Fitxa*> iterator_fitxes(m_fitxes);
     QMapIterator <int, Fitxa*> iterator_fitxes(m_fitxes);
     QString moviments;
    //posam totes les fitxes a no aïllades
     //while ( iterator_fitxes.hasNext() ){
     // iterator_fitxes.next();
     // iterator_fitxes.value()->setFitxaAillada(false);
     //}
     //iterator_fitxes.toFront();
     while ( iterator_fitxes.hasNext() ){
        iterator_fitxes.next();
        int index_fitxaInicial=
            iterator_fitxes.value()->coordenades().x()*100+iterator_fitxes.value()->coordenades().y();
        int index_fitxaBotada;
        int index_fitxaFinal;
        moviments.clear();
        m_fitxes.value(index_fitxaInicial)->calculaMovimentsFitxa();
        //Només poden estar "aïllades" les fitxes actives
        //(sí ho poden estar si son fitxes finals de joc!)
        //Tampoc pot estar aïllada una fitxa que és la mitjana d'un moviment posible
        if(  (m_fitxes.value(index_fitxaInicial)->estat()==1)   ||
            (!(m_fitxes.value(index_fitxaInicial)->fitxaFinalJoc()) &&
            (m_fitxes.value(index_fitxaInicial)->estat()==1) ) ){
        for(int j=0 ; j<iterator_fitxes.value()->movimentsPossibles.count();++j){
            index_fitxaBotada=iterator_fitxes.value()->movimentsPossibles.at(j).x();
            index_fitxaFinal=iterator_fitxes.value()->movimentsPossibles.at(j).y();
            //fitxa activa possibilitat de fer un moviment
            if (  (m_fitxes.value(index_fitxaInicial)->estat()==1) &&
                  (m_fitxes.value(index_fitxaBotada)->estat() ==p_estatFitxaMitjana) &&
                  (m_fitxes.value(index_fitxaFinal)->estat()==0)){
                  moviments.append("1"); //break;
              }
            else moviments.append("0");

            if (  (m_fitxes.value(index_fitxaInicial)->estat()==1) &&
                (m_fitxes.value(index_fitxaBotada)->estat() != p_estatFitxaMitjana)  ){
                //Cal mirar si la fitxa botada es el final d'un moviment possible
                if ( (!movimentPosibleFitxaFinal(index_fitxaBotada)) ){
                       moviments.append("0");
                }
                else {moviments.append("1");
                   // break;
                }
            }
            //La fitxa pot ésser la mitjana d'un moviment possible
            if (  (m_fitxes.value(index_fitxaInicial)->estat()==1)  ){
                if ( (!movimentPosibleFitxaMitjana(index_fitxaInicial)) ){
                       moviments.append("0");
                }
                else {moviments.append("1");
                   // break;
                }
            }
            if (  (m_fitxes.value(index_fitxaInicial)->estat()==1) &&
                  m_fitxes.value(index_fitxaInicial)->movimentsFitxa.count()<1){
                if ( (!movimentPosibleFitxaMitjana(index_fitxaInicial)) ){
                       moviments.append("");
                }
                else {moviments.append("0");
                   // break;
                }
            }
          }//final del for

        if ( !(moviments.contains("1"))  ){
            m_fitxes.value(index_fitxaInicial)->setFitxaAillada(true);
            if (m_fitxes.value(index_fitxaInicial)->nivellAillament()==1){
                numeroFitxesAillades=numeroFitxesAillades+1;}
        }
        else {
             m_fitxes.value(index_fitxaInicial)->setFitxaAillada(false);
        }
        qApp->processEvents();
      }//final del if inicial del while
     else {
       m_fitxes.value(index_fitxaInicial)->setFitxaAillada(false);
       }

    //if(m_fitxes.value(index_fitxaInicial)->estat()==1){
       m_fitxes.value(index_fitxaInicial)->calculaMovimentsFitxa();
     qDebug("m_fitxes.value(index_fitxaInicial)->movimentsFitxa() %d",
            m_fitxes.value(index_fitxaInicial)->movimentsFitxa.count());
     if(m_fitxes.value(index_fitxaInicial)->movimentsFitxa.count()<1){
          m_fitxes.value(index_fitxaInicial)->setFitxaAillada(true);
          qDebug("Fitxa sense moviments!********");
       }
    }
    if(m_fitxes.value(index_fitxaInicial)->estat()==1){
        qDebug("m_fitxes.value(index_fitxaInicial)->movimentsFitxa() %d",
               m_fitxes.value(index_fitxaInicial)->movimentsFitxa.count());
    }

   // nivellAillamentFitxes=nivellAillamentFitxes+m_fitxes.value(index_fitxaInicial)->nivellAillament();
    }//final while
qDebug("p_numFitxesAillades %d", p_numFitxesAillades);
qDebug("numeroFitxesAillades %d", numeroFitxesAillades);
//pausa(3000);
return  (numeroFitxesAillades>p_numFitxesAillades);
//return  (numeroFitxesAillades>0);
 }
 */

 /* Nou procediment per a la versió 2.1
   Comprova si hi ha alguna fitxa "aïllada"
   o sigui fitxes en estat 1 que no tenen cap moviment
   que es pugui fer efectiu o be que no tenen
   altres fitxes (o buits en el cas de la modialitat inversa)
   que permetin que es moguin
   */
 bool Tauler::solucionaJocActual_FitxesAillades1(){
     /* Aquest procediment no és eficient
      * amb la modalitat inversa
      03/09/16 A la versió 2.1 s'ha fet per la modalitat inversa */
     //if(p_tipusMoviment==2){return false;}
     solucionaJocActual_CalculaMovimentsPosibles();
     /* 22/08/16 Això no es fa servir per res*/
     //int nivellAillamentFitxes=0;
     int numeroFitxesAillades=0;
     //QHashIterator <int, Fitxa*> iterator_fitxes(m_fitxes);
     QMapIterator <int, Fitxa*> iterator_fitxes(m_fitxes);

     while ( iterator_fitxes.hasNext() ){
        iterator_fitxes.next();
        /* Calcula els moviments actuals (reals) de la fitxa*/
        iterator_fitxes.value()->calculaMovimentsFitxa();
        /* Només poden estar "aïllades" les fitxes actives sense moviments.
         * Poden estar aïllades les fitxes que son fitxes finals de joc*/
       if(  ((iterator_fitxes.value()->estat()==1) &&
            (iterator_fitxes.value()->movimentsFitxa.count()==0) ) &&
            (!(iterator_fitxes.value()->fitxaFinalJoc()))
            ){
           /* Es calcula la distància (del taxi) de la fitxa actual a altres fitxes
           * i també en diagonal si el moviment és en diagonal */
           QPoint distancies=distanciaDeUnaFitxaAAltres(iterator_fitxes.value()->coordenades());
           /* distancies.x() fitxes proximes
            * distancies.y() distància mínima */
           if(distancies.x() < 2 || distancies.y() > 2 ){
            iterator_fitxes.value()->setFitxaAillada(true);
            numeroFitxesAillades=numeroFitxesAillades+1;
            qApp->processEvents();
            //pausa(2000);
            }
           else iterator_fitxes.value()->setFitxaAillada(false);
         }//final del if inicial del while
     else {
       iterator_fitxes.value()->setFitxaAillada(false);
       }
    }//final while

//qDebug("p_numFitxesAillades %d", p_numFitxesAillades);
//qDebug("numeroFitxesAillades %d", numeroFitxesAillades);
//pausa(3000);
return  (numeroFitxesAillades>qMax(3,p_numFitxesAillades));
//return  (numeroFitxesAillades>qMax(p_numFitxesAillades,1));
//return  (numeroFitxesAillades>0);
 }

/* Calcula la distància entre una fitxa i les altres per saber
 * si està aïllada */
QPoint Tauler::distanciaDeUnaFitxaAAltres(QPoint coordenades){
QMapIterator <int, Fitxa*> iterator_fitxes(m_fitxes);
int proximitat=3;
int fitxesProximes=0;
int distanciaMinima=10000;
//qDebug("Fitxa %d %d", coordenades.x(),coordenades.y());
while ( iterator_fitxes.hasNext() ){
   iterator_fitxes.next();
   QPoint coordenadesAltraFitxa;
   bool continuar=false;
   /* només per fitxes actives*/
   if(p_tipusMoviment == 2 &&  /* Moviment invers*/
      iterator_fitxes.value()->estat()==0){
      coordenadesAltraFitxa=iterator_fitxes.value()->coordenades();
      continuar=true;
   }
   else if (iterator_fitxes.value()->estat()==1){
   coordenadesAltraFitxa=iterator_fitxes.value()->coordenades();
   continuar=true;
    }

   if (continuar){
   //qDebug("Altra fitxa %d %d", coordenadesAltraFitxa.x(),coordenadesAltraFitxa.y());
   /* No es calcula la distància d'un fitxa a si mateixa */
   if(coordenades != coordenadesAltraFitxa){
   int distancia=abs(coordenades.x()-coordenadesAltraFitxa.x())+
                 abs(coordenades.y()-coordenadesAltraFitxa.y());
   if (p_tipusMoviment==3){/* cas de moviments en diagonal
      * també es calcula les distàncies en diagonal*/
      if(abs(coordenades.x()-coordenadesAltraFitxa.x())==
         abs(coordenades.y()-coordenadesAltraFitxa.y()) ){/*Les fitxes estan en la mateixa diagonal*/
          int distanciaEnDiagonal=abs(coordenades.x()-coordenadesAltraFitxa.x());
          /* en aquest cas, s'agafa la distància més curta */
          distancia=qMin(distancia,distanciaEnDiagonal);
     }
   }/* if moviment en diagonal 3*/
   distanciaMinima=qMin(distanciaMinima,distancia);
   //qDebug("distancia %d",distancia);
   if(distancia<=proximitat || distanciaMinima < 3){
     fitxesProximes++;
     }
    }/* if de igualtat de coordenades*/
  }//if continuar
}/* final del while */

/*qDebug("fitxesProximes %d",fitxesProximes);
qDebug("distanciaMinima %d",distanciaMinima);*/
return QPoint(fitxesProximes,distanciaMinima);
}

 /*
   Comprova si hi ha algun moviment posible que tengui com a fitxa final
   la fitxa passada per paràmetre
   */
 bool Tauler::movimentPosibleFitxaFinal(int fitxaMijana){
  bool resultat=false;
 QMapIterator <int, Fitxa*> iterator_fitxes(m_fitxes);
 //QHashIterator <int, Fitxa*> iterator_fitxes(m_fitxes);

      while (iterator_fitxes.hasNext() && (! resultat) ) {
        iterator_fitxes.next();
        int index_fitxaInicial=iterator_fitxes.value()->coordenades().x()*100+iterator_fitxes.value()->coordenades().y();
        for(int j=0 ; j<iterator_fitxes.value()->movimentsPossibles.count();++j){
             if  (resultat){break;}
            int index_fitxaBotada=iterator_fitxes.value()->movimentsPossibles.at(j).x();
            int index_fitxaFinal=iterator_fitxes.value()->movimentsPossibles.at(j).y();
            if (  (m_fitxes.value(index_fitxaInicial)->estat()==1) &&
                (m_fitxes.value(index_fitxaBotada)->estat()==p_estatFitxaMitjana) &&
                ( index_fitxaFinal==fitxaMijana) ){
                resultat=true;
               }
            //miram si la fitxa botada és el final d'un moviment posible
            else if (  (m_fitxes.value(index_fitxaInicial)->estat()==1) &&
                !(m_fitxes.value(index_fitxaBotada)->estat()==p_estatFitxaMitjana) &&
                ( index_fitxaFinal==fitxaMijana) ){
                 if (movimentPosibleFitxaFinal1(index_fitxaBotada) ) {
                resultat=true;}
               }
            }
        }
  return resultat;
 }


 bool Tauler::movimentPosibleFitxaFinal1(int fitxaMijana){
  bool resultat=false;
  //QHashIterator <int, Fitxa*> iterator_fitxes(m_fitxes);
  QMapIterator <int, Fitxa*> iterator_fitxes(m_fitxes);

      while (iterator_fitxes.hasNext() && (! resultat) ) {
        iterator_fitxes.next();
        int index_fitxaInicial=iterator_fitxes.value()->coordenades().x()*100+iterator_fitxes.value()->coordenades().y();
        for(int j=0 ; j<iterator_fitxes.value()->movimentsPossibles.count();++j){
             if  (resultat){break;}
            int index_fitxaBotada=iterator_fitxes.value()->movimentsPossibles.at(j).x();
            int index_fitxaFinal=iterator_fitxes.value()->movimentsPossibles.at(j).y();
            if (  (m_fitxes.value(index_fitxaInicial)->estat()==1) &&
                (m_fitxes.value(index_fitxaBotada)->estat()==p_estatFitxaMitjana) &&
                ( index_fitxaFinal==fitxaMijana) ){
                resultat=true;
               }
            }
        }
  return resultat;
 }

 /*
   Comprova si hi ha algun moviment possible que tengui la fitxa
   passada per paràmetre com a fitxa botada
   */
 bool Tauler::movimentPosibleFitxaMitjana(int fitxaMitjana){
     bool resultat=false;
     //QHashIterator <int, Fitxa*> iterator_fitxes(m_fitxes);
     QMapIterator <int, Fitxa*> iterator_fitxes(m_fitxes);

      while (iterator_fitxes.hasNext() && (! resultat)) {
        iterator_fitxes.next();
        int index_fitxaInicial=iterator_fitxes.value()->coordenades().x()*100+iterator_fitxes.value()->coordenades().y();
        for(int j=0 ; j<iterator_fitxes.value()->movimentsPossibles.count();++j){
            if  (resultat){break;}
            int index_fitxaBotada=iterator_fitxes.value()->movimentsPossibles.at(j).x();
            //int index_fitxaFinal=iterator_fitxes.value()->movimentsPossibles.at(j).y();
            if (  (m_fitxes.value(index_fitxaInicial)->estat()==1) &&
                (m_fitxes.value(index_fitxaBotada)->estat()==p_estatFitxaMitjana) &&
                ( index_fitxaBotada==fitxaMitjana) ){
                resultat=true;
               }
            }
        }
  return resultat;
 }

 /*
   No es fa servir
   Determina si la posició central

 bool Tauler::movimentFitxaCentral(){
     //QPoint(3,3);
     bool resultat=false;
     int fitxaCentral=303;
     QHashIterator <int, Fitxa*> iterator_fitxes(m_fitxes);
      while (iterator_fitxes.hasNext() && !resultat ) {
        iterator_fitxes.next();
        int index_fitxaInicial=iterator_fitxes.value()->coordenades().x()*100+iterator_fitxes.value()->coordenades().y();
        for(int j=0 ; j<iterator_fitxes.value()->movimentsPossibles.count();++j){            
            int index_fitxaBotada=iterator_fitxes.value()->movimentsPossibles.at(j).x();
            if (  (m_fitxes.value(index_fitxaInicial)->estat()==1) &&
                (m_fitxes.value(index_fitxaBotada)->estat()==p_estatFitxaMitjana) &&
                fitxaCentral==iterator_fitxes.value()->movimentsPossibles.at(j).y() ){
             //   qDebug("fitxa central SI");
                resultat= true;
               }
            }
        }
// qDebug("fitxa central NO");
return resultat;
 }
 */

 void Tauler::eliminaFitxesVermelles(){
    //QHashIterator <int, Fitxa*> i(m_fitxes);
    QMapIterator <int, Fitxa*> i(m_fitxes);
    while (i.hasNext()) {
        i.next();
        if (i.value()->estat()==5){
            i.value()->setEstat(1);
        }
     }
}

/* Posa totes les fitxes actives
 * a color blau
 */
 void Tauler::eliminaFitxesVerdes(){
    //QHashIterator <int, Fitxa*> i(m_fitxes);
    QMapIterator <int, Fitxa*> i(m_fitxes);
    while (i.hasNext()) {
        i.next();
        if (i.value()->estat()==4){
            i.value()->setEstat(1);
        }
     }
}

QString Tauler::configuracioActual(bool comptarFitxes){

    // QHashIterator <int, Fitxa*> p(m_fitxes);
     QMapIterator <int, Fitxa*> p(m_fitxes);
     QString configuracioActual;
     if (comptarFitxes){
         comptadorFitxesJoc=0;
         comptadorFitxesEstatZeroJoc=0;
         comptadorFitxesFinalJoc=0;
     }

        int contador=0;
        while (p.hasNext()) {
              p.next();
              configuracioActual.append(QString("%1").arg((p.value()->estat())));
              //qCritical("configuracioActual %s",qPrintable(configuracioActual));
              //qDebug("Key %d estat %d",p.key(),p.value()->estat());

              if (comptarFitxes){
               if (p.value()->estat()==1){++comptadorFitxesJoc;}
               if (p.value()->estat()==0){++comptadorFitxesEstatZeroJoc;}
               if (p.value()->fitxaFinalJoc()){
                  ++comptadorFitxesFinalJoc;
                  }
              }
           ++contador;
          }
/* Això cal quan es modifica un joc del programa
 * i s'han eliminat fitxes.
 */
configuracioActual.remove("6");
//qDebug("contador %d",contador);
//qCritical("configuracioActual %s",qPrintable(configuracioActual));
return configuracioActual;
 }

/* Retorna la configuració actual de les fitxes amb les
 * fitxes finals de joc marcades amb -
 * 10/02/13 Al final no es fa servir

QString Tauler::configuracioInicialAmbFitxesMarcades(){
 QHashIterator <int, Fitxa*> i(m_fitxes);
 QString configuracioActual;
 while (i.hasNext()) {
       i.next();
       configuracioActual.append(QString("%1").arg((i.value()->estat())));
       if (i.value()->fitxaFinalJoc()){
           configuracioActual.append("-");
       }
   }
return configuracioActual;
}*/


 //Carrega la configuració passada
void Tauler::carregaConfiguracio(QString configuracio){
     //QHashIterator <int, Fitxa*> i(m_fitxes);
     QMapIterator <int, Fitxa*> i(m_fitxes);
     int contador=0;
     while (i.hasNext()) {
              i.next();
              QString valor=configuracio.at(contador);
              i.value()->setEstat(valor.toInt());
              contador ++;
          }
 }

 /*
Canvia l'estat de les fitxes a l'atzar
Es fa servir quan el joc està en pausa
*/
void Tauler::estatFitxesAtzar(){
    qsrand(QTime::currentTime().msec());
     //QHashIterator <int, Fitxa*> i(m_fitxes);
     QMapIterator <int, Fitxa*> i(m_fitxes);
     while (i.hasNext()) {
              i.next();
              i.value()->setEstat(qrand() % 5);
          }
 }

 /*
   Retorna el número de moviments que cal fer en el joc
   (en funció del tipus de moviment)
   */
 int Tauler::numeroDeMovimentsJoc(){
    /* qDebug("p_tipusMoviment %d",p_tipusMoviment);
     qDebug("comptadorFitxesFinalJoc %d",comptadorFitxesFinalJoc);
     qDebug("comptadorFitxesJoc %d",comptadorFitxesJoc);
     qDebug("comptadorFitxesFinalJoc %d",comptadorFitxesFinalJoc);*/
     if (p_tipusMoviment !=2){
         if(comptadorFitxesFinalJoc<2){
           return comptadorFitxesJoc-1;
         }
         else
          return comptadorFitxesJoc-comptadorFitxesFinalJoc;
      }
       // qDebug("num, mov. %d",comptadorFitxesJoc-qMax(1,comptadorFitxesFinalJoc));
        // return comptadorFitxesJoc-qMax(1,comptadorFitxesFinalJoc);}
     else {
        // qDebug("m_fitxes.count() %d",m_fitxes.count());
        // qDebug("comptadorFitxesJoc %d",comptadorFitxesJoc);
        // 10/01/13 modificat
        return comptadorFitxesEstatZeroJoc-1;
     }
 }

 /*
   Retorna el missatge del número de moviments realitzats i el total
   No es fa servir

 QString Tauler::missatgeNumeroMoviments(){
    return QString(tr("Moviment %1 de %2 ")).arg(p_movimentsUndoStack->index()).arg(numeroDeMovimentsJoc());
 }
 */


 void Tauler::setModalitatJocActual(QString valor){
   p_modalitatJocActual=valor;
   setSolitariEspecial(p_modalitatJocActual);
 }

 void Tauler::setEstatDelJoc(EstatsDelJoc valor){
     if(p_estatDelJoc != valor){
      p_estatDelJoc=valor;
    }
 }

 /* Conserva el codi (per la traducció)
  * del joc actual
  */
 void Tauler::setCodiNomJocActual (QString codi){
     p_codiNomJocActual=codi;
 }

 /* En la generació d'un joc a l'atzar
  * marca les fitxes que s'ha fet servir per
  * generar el joc
  */
 void Tauler::solitariAtzar_MarcaFitxaUsada(int fitxa,bool marcaFitxaFinal){
   m_fitxes.value(fitxa)->setfitxaUsadaGeneracioSolitariAtzar(true);
   m_fitxes.value(fitxa)->setFitxaFinalJoc(marcaFitxaFinal);
 }


 /* En la generació d'un joc a l'atzar
  * retorna l'estat de les fitxes del
  * joc generat a l'atzar
  */
 QString Tauler::solitariAtzar_dadesEstatFitxes(int files, int columnes){
     //QHashIterator <int, Fitxa*> i(m_fitxes);
     QMapIterator <int, Fitxa*> i(m_fitxes);
     QString dadesFitxes;
     QStringList dadesFitxesList;
     //omplim la llista
     for(int j=0; j<files*columnes; j++){
         dadesFitxesList.append("-2");
     }
     i.toFront();
     while (i.hasNext()) {
              i.next();
              //Si la fitxa està marcada (s'ha fet
              //servir en la generació del joc)
              if (i.value()->fitxaUsadaGeneracioSolitariAtzar()){
                  //Si està marcada com a final del joc
                  if(i.value()->fitxaFinalJoc()){
                      dadesFitxesList.replace(
                        i.value()->coordenades().x()*columnes+
                        i.value()->coordenades().y(),
                        QString("1%1").arg(i.value()->estat()));
                  }
                  else dadesFitxesList.replace(
                         i.value()->coordenades().x()*columnes+
                         i.value()->coordenades().y(),
                         QString("%1").arg(i.value()->estat()));
              }
              else {dadesFitxesList.replace(
                          i.value()->coordenades().x()*columnes+
                          i.value()->coordenades().y(),
                          QString("-1"));
              }
          }
   dadesFitxes.clear();
   //passam les dades de la llista a una cadena
   for(int j=0; j<dadesFitxesList.count(); j++){
       dadesFitxes=dadesFitxes+dadesFitxesList.value(j)+" ";
   }
   return dadesFitxes.simplified();
 }

 /* Estableix si s'està jugant un solitari a l'atzar
  */
 void Tauler::setSolitariAtzar(bool valor){
  p_SolitariAtzar=valor;
 }

 /* Retorna les files i columnes, i les dades de les
  * fitxes d'un solitari personalitzat
  */
 QStringList Tauler::solitariPersonalitzat_dadesFitxes(){
 //calculem les files i columnes
 QStringList filesColumnes=solitariPersonalitzat_filesColumnes().split(" ");
 int minFila=filesColumnes.value(0).toInt();
 int maxFila=filesColumnes.value(1).toInt();
 int files=maxFila-minFila+1;
 int minCol=filesColumnes.value(2).toInt();
 int maxCol=filesColumnes.value(3).toInt();
 int columnes=maxCol-minCol+1;

 QStringList dadesFitxesList;
 //omplim la llista
 for(int j=0; j<files*columnes; j++){
     dadesFitxesList.append("-1");
 }
 //QHashIterator <int, Fitxa*> i(m_fitxes);
 QMapIterator <int, Fitxa*> i(m_fitxes);
 i.toFront();
 while (i.hasNext()) {
          i.next();
          if( (i.value()->coordenades().x()>=minFila) &&
              (i.value()->coordenades().x()<=maxFila) &&
              (i.value()->coordenades().y()>=minCol) &&
              (i.value()->coordenades().y()<=maxCol) ){
              //els estats 6 no cal reemplaçar-los
              //(ja hi ha -1 per defecte)
              if (i.value()->estat() != 6){
                 dadesFitxesList.replace(
                     (i.value()->coordenades().x()-minFila)*columnes+
                      i.value()->coordenades().y()-minCol,
                      QString("%1").arg(i.value()->estat()));
                 //Això per les fitxes marcades com a final de joc
                 if(i.value()->fitxaFinalJoc()){
                   dadesFitxesList.replace(
                         (i.value()->coordenades().x()-minFila)*columnes+
                          i.value()->coordenades().y()-minCol,
                          QString("1%1").arg(i.value()->estat()));
                 }
              }
          }
    }//final while
 //passam les dades de la llista a una cadena
 QString dadesFitxes;
 for(int j=0; j<dadesFitxesList.count(); j++){
     dadesFitxes=dadesFitxes+dadesFitxesList.value(j)+" ";
   }
 dadesFitxesList.clear();
 dadesFitxesList.append(QString("%1 %2").arg(files).arg(columnes));
 dadesFitxesList.append(dadesFitxes.simplified());
 //qCritical("Tauler::solitariPersonalitzat_dadesFitxes\n %s", qPrintable(dadesFitxes));
 return dadesFitxesList;
 }

 /* Retorna el número de files i columnes del joc
  * personalitzat.
  * La llista té les coordenades més petita i més gran
  * de files i columnes.
  */
 QString Tauler::solitariPersonalitzat_filesColumnes(){
  //QHashIterator <int, Fitxa*> i(m_fitxes);
  QMapIterator <int, Fitxa*> i(m_fitxes);
  int minFila=1000, maxFila=0,minCol=1000,maxCol=0;
  while (i.hasNext()) {
     i.next();
     //Si la fitxa s'ha fet servir
     if(i.value()->estat() != 6){
         minFila=qMin(minFila,i.value()->coordenades().x()) ;
         maxFila=qMax(maxFila,i.value()->coordenades().x()) ;
         minCol=qMin(minCol,i.value()->coordenades().y()) ;
         maxCol=qMax(maxCol,i.value()->coordenades().y()) ;
     }
  }
 QString filesColumnes;
 filesColumnes.append(QString("%1 %2 ").arg(minFila).arg(maxFila));
 filesColumnes.append(QString("%1 %2").arg(minCol).arg(maxCol));
 //QString missatge=QString(filesColumnes.value(0)+" "+filesColumnes.value(1));
 //qCritical("%s", qPrintable(filesColumnes));
 return filesColumnes;
 }

 /* Estableix si s'està jugant un solitari personalitzat
  */
 void Tauler::setSolitariPersonalitzat(bool valor){
  p_SolitariPersonalitzat=valor;
 }

 /* Estableix si s'està jugant un solitari modificat
  */
 void Tauler::setSolitariModificat(bool valor){
  p_SolitariModificat=valor;
 }

 /* Marcam totes les fitxes com a personalitzades
  * (segons el valor passat)
  */
 void Tauler::marcaFitxesSolitariPersonalitzat(bool valor){
     QMapIterator <int, Fitxa*> i(m_fitxes);
     //QHashIterator <int, Fitxa*> i(m_fitxes);
     while (i.hasNext()) {
        i.next();
        i.value()->setFitxaSolitariPersonalitzat(valor);
     }
 }

 /* Comprova si hi ha alguna fitxa del solitari marcada
  * com a personalitzada
  * 10/02/13 Finalment, no es fa servir això

 bool Tauler::solitariPersonalitzat_hiHaFitxesMarcades(){
  QHashIterator <int, Fitxa*> i(m_fitxes);
  bool valor=false;
  while (i.hasNext()) {
    i.next();
    if(i.value()->fitxaSolitariPersonalitzat()){
      valor=true;
      break;
     }
    }
  return valor;
 }*/
