/* $Id: Suspect_rule_set.cpp 569301 2018-08-18 17:15:27Z kachalos $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using the following specifications:
 *   'macro.asn'.
 */

// standard includes
#include <ncbi_pch.hpp>

// generated includes
#include <objects/macro/Suspect_rule_set.hpp>

//#include <util/util_misc.hpp>
#include <util/line_reader.hpp>
#include <serial/enumvalues.hpp>
#include <serial/serialimpl.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

static bool  s_OrganelleProductRulesInitialized = false;
DEFINE_STATIC_FAST_MUTEX(s_OrganelleProductRulesMutex);
static CRef<CSuspect_rule_set> s_OrganelleProductRules;

static bool  s_ProductRulesInitialized = false;
static string  s_ProductRulesFileName;
DEFINE_STATIC_FAST_MUTEX(s_ProductRulesMutex);
static CRef<CSuspect_rule_set> s_ProductRules;


// destructor
CSuspect_rule_set::~CSuspect_rule_set(void)
{
}


#define _FSM_RULES static const char* const s_Defaultorganelleproducts[]
#define _FSM_EMIT static bool s_Defaultorganelleproducts_emit[]
#define _FSM_HITS static map<size_t, vector<size_t>> s_Defaultorganelleproducts_hits
#define _FSM_STATES static size_t s_Defaultorganelleproducts_states[]
#include "organelle_products.inc"
#undef _FSM_EMIT
#undef _FSM_HITS
#undef _FSM_STATES
#undef _FSM_RULES


static void s_InitializeOrganelleProductRules(const string& name)
{
    CFastMutexGuard GUARD(s_OrganelleProductRulesMutex);
    if (s_OrganelleProductRulesInitialized) {
        return;
    }
    s_OrganelleProductRules.Reset(new CSuspect_rule_set());
    //string file = name.empty() ? g_FindDataFile("organelle_products.prt") : name;

    if ( !name.empty() ) {
        LOG_POST("Reading from " + name + " for organelle products");
        auto_ptr<CObjectIStream> in;
        in.reset(CObjectIStream::Open(name, eSerial_AsnText));
        string header = in->ReadFileHeader();
        in->Read(ObjectInfo(*s_OrganelleProductRules), CObjectIStream::eNoFileHeader);    
        s_OrganelleProductRules->SetPrecompiledData(0, 0, 0);
    }
    if (!s_OrganelleProductRules->IsSet()) {
        //LOG_POST("Falling back on built-in data for organelle products");
        size_t num_lines = sizeof (s_Defaultorganelleproducts) / sizeof (char *);     
        string all_rules = "";
        for (size_t i = 0; i < num_lines; i++) {
            all_rules += s_Defaultorganelleproducts[i];
        }
        CNcbiIstrstream istr(all_rules.c_str());
        istr >> MSerial_AsnText >> *s_OrganelleProductRules;
        s_OrganelleProductRules->SetPrecompiledData(s_Defaultorganelleproducts_emit, &s_Defaultorganelleproducts_hits, s_Defaultorganelleproducts_states);
    }

    s_OrganelleProductRulesInitialized = true;
}


#define _FSM_RULES static const char* const s_Defaultproductrules[]
#define _FSM_EMIT static bool s_Defaultproductrules_emit[]
#define _FSM_HITS static map<size_t, vector<size_t>> s_Defaultproductrules_hits
#define _FSM_STATES static size_t s_Defaultproductrules_states[]
#include "product_rules.inc"
#undef _FSM_EMIT
#undef _FSM_HITS
#undef _FSM_STATES
#undef _FSM_RULES


static void s_InitializeProductRules(const string& name)
{
    CFastMutexGuard GUARD(s_ProductRulesMutex);
    if (s_ProductRulesInitialized && name == s_ProductRulesFileName) {
        return;
    }
    s_ProductRules.Reset(new CSuspect_rule_set());
    s_ProductRulesFileName = name;
    //string file = name.empty() ? g_FindDataFile("product_rules.prt") : name;

    if (!name.empty()) {
        LOG_POST("Reading from " + name + " for suspect product rules");
        auto_ptr<CObjectIStream> in;
        in.reset(CObjectIStream::Open(name, eSerial_AsnText));
        string header = in->ReadFileHeader();
        in->Read(ObjectInfo(*s_ProductRules), CObjectIStream::eNoFileHeader);    
        s_ProductRules->SetPrecompiledData(0, 0, 0);
    }
    if (!s_ProductRules->IsSet()) {
        //LOG_POST("Falling back on built-in data for suspect product rules");
        size_t num_lines = sizeof (s_Defaultproductrules) / sizeof (char *);     
        string all_rules = "";
        for (size_t i = 0; i < num_lines; i++) {
            all_rules += s_Defaultproductrules[i];
        }
        CNcbiIstrstream istr(all_rules.c_str());
        istr >> MSerial_AsnText >> *s_ProductRules;
        s_ProductRules->SetPrecompiledData(s_Defaultproductrules_emit, &s_Defaultproductrules_hits, s_Defaultproductrules_states);
    }

    s_ProductRulesInitialized = true;
}


CConstRef<CSuspect_rule_set> CSuspect_rule_set::GetOrganelleProductRules(const string& name)
{
    s_InitializeOrganelleProductRules(name);
    return CConstRef<CSuspect_rule_set>(s_OrganelleProductRules.GetPointer());
}


CConstRef<CSuspect_rule_set> CSuspect_rule_set::GetProductRules(const string& name)
{
    s_InitializeProductRules(name);
    return CConstRef<CSuspect_rule_set>(s_ProductRules.GetPointer());
}


void CSuspect_rule_set::Screen(const char* input, char* output) const
{
    const auto& callback = [&](size_t n) { output[n] = 1; };
    if (m_Precompiled_states) {
        CMultipatternSearch::Search(input, m_Precompiled_states, m_Precompiled_emit, *m_Precompiled_hits, callback);
        return;
    }

    if (!m_FSM) {
        m_FSM.reset(new CMultipatternSearch);
        vector<string> patterns;
        for (auto rule: Get()) {
            const CSearch_func& find = rule->GetFind();
            patterns.push_back(find.GetRegex());
        }
        m_FSM->AddPatterns(patterns);
    }
    m_FSM->Search(input, callback);
}


END_objects_SCOPE // namespace ncbi::objects::
END_NCBI_SCOPE

/* Original file checksum: lines: 57, chars: 1741, CRC32: b1125738 */
