{-DHUN| module defining the datatypes needed for the outer imperative flow control of the program. All configurtion information needed for single run of the program is stored here. DHUN-}
module ImperativeState where
import Data.Map
import Control.Monad.State
import Control.Monad.Except
import UrlAnalyse
import Control.Concurrent.MVar
import Data.List
import Network.URL
data MyError = DownloadError String String
             | OtherError String
             | WikiUrlParseError String
             | NotImplementedError
             | NotExcatlyOneError String
             | NotIntegerError String
             | NotIntegerPairError String
             | NotAtMostOneError String
             | ToManyOptionsError
             | PaperError
 
type MyErrorMonad = Either MyError 

instance Show MyError where
        show (DownloadError theLemma theUrl)
          = "Error downloading the lemma \"" ++
              theLemma ++ "\" form the url \"" ++ theUrl ++ "\""
        show (WikiUrlParseError theUrl)
          = "Error: The supplied url " ++ theUrl ++ " could not be parsed"
        show NotImplementedError
          = "Error: The requested feature is not implemented yet"
        show (NotIntegerPairError msg)
          = "Error: The option --" ++ msg ++ "could not be parsed to a pair of integers (like -f 23:42)"
        show PaperError
          = "Error: The option paper may only be one of A4,A5,B5,letter,legal,executive"
        show ToManyOptionsError
          = "Error: at most one of the options --internal --templates --message --html may be given"
        show (NotExcatlyOneError msg)
          = "Error: The option --" ++
              msg ++ " has to be present exactly once in the command line"
        show (NotAtMostOneError msg)
          = "Error: The option --" ++
              msg ++ " can only be present at most once in the command line"
        show (NotIntegerError msg)
          = "Error: The option --" ++
              msg ++ " could not be parsed as an integer."
        show (OtherError msg) = msg
 
data Contributor = Contributor{name :: String, edits :: Integer,
                               href :: String}
                 deriving (Eq, Ord, Show, Read)
 
myplus :: Contributor -> Contributor -> Contributor
myplus x y = x{edits = (edits x) + (edits y)}
 
contribsum :: [Map String Contributor] -> Map String Contributor
contribsum x = Data.List.foldl (unionWith myplus) Data.Map.empty x
 
imperativeStateZero :: IO ImperativeState
imperativeStateZero
  = do v<-newMVar (0::Int)
       return ImperativeState{audict = [], fullUrl = fullWikiUrlZero,
                    tmpPath = "" ,counter=v}
 
data ImperativeState = ImperativeState{audict ::
                                       [MVar (Map String Contributor)],
                                       fullUrl :: FullWikiUrl, tmpPath :: String, counter::MVar Int}

data ImageInfo = ImageInfo{wikiFilename :: String,imageNumber::Integer,contributorUrls::[String],descriptionUrl::URL}

 
type ImperativeMonad = ExceptT MyError (StateT ImperativeState IO)
 
data RunMode = HTML
             | ExpandedTemplates
             | StandardTemplates
             | UserTemplateFile String
             deriving (Show, Read)
 
data SourceMode = Included
                | Excluded
                deriving (Show, Read)
 
data OutputType = PlainPDF | ZipArchive
                deriving (Show, Read,Eq)
data FullConfig = FullConfig{headers :: Maybe String,
                             resolution :: Integer, outputFilename :: String,
                             inputUrl :: String, runMode :: RunMode, paper :: String,
                             vector :: Bool, copy :: Maybe String, mainPath :: String,
                             server :: Maybe Int, outputType::OutputType, selfTest ::Maybe (Integer,Integer)}
                deriving (Show, Read)
