/*
    libmaus2
    Copyright (C) 2020 German Tischler-Höhle

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#if ! defined(LIBMAUS2_ARCH_CACHELINESIZE_HPP)
#define LIBMAUS2_ARCH_CACHELINESIZE_HPP

#include <atomic>
#include <mutex>

namespace libmaus2
{
	namespace arch
	{
		struct CacheLineSize
		{
			static std::mutex cachelinesizelock;
			static std::atomic<int> cachelinesizeinitcomplete;
			static std::atomic<unsigned int> cachelinesize;

			static std::size_t getCacheLineSize();
		};
	}
}

#endif
