------------------------------------------------------------------------------
--                              G N A T L I B                               --
--                                                                          --
--                     Copyright (C) 2001-2015, AdaCore                     --
--                                                                          --
-- This library is free software;  you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software  Foundation;  either version 3,  or (at your  option) any later --
-- version. This library is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE.                            --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
------------------------------------------------------------------------------

with GNATCOLL.Traces;     use GNATCOLL.Traces;
with GNATCOLL.VFS;        use GNATCOLL.VFS;
with Traces2_Support; use Traces2_Support;

procedure Traces2 is
   Me1 : GNATCOLL.Traces.Trace_Handle;
   Cust : GNATCOLL.Traces.Trace_Handle;
   Me2 : GNATCOLL.Traces.Trace_Handle;
   Me3 : GNATCOLL.Traces.Trace_Handle;
   Me4 : GNATCOLL.Traces.Trace_Handle;
   Fact : constant Stream_Factory_Access := new Factory;
begin
   Register_Stream_Factory ("mystream", Fact);

   --  Declare the stream, but this will be overridden by the
   --  configuration file.

   Me1 := Create ("MODULE1", Stream => "&mystream:me1");

   --  Output to custom stream

   Me2 := Create ("MODULE2");  --  Read before config file
   Parse_Config_File (Create_From_Base ("traces_config.cfg"));
   Me3 := Create ("MODULE3");  --  Read after config file
   Me4 := Create ("MODULE4");  --  Use default stream

   Trace (Me1, "Message 1");
   Trace (Me2, "Message 2");
   Trace (Me3, "Message 3");
   Trace (Me4, "Message 4");

   --  Overriding stream has no effect when the stream is already
   --  associated with a non-default stream

   Me1 := Create ("MODULE1", Stream => "&mystream:overridden");
   Trace (Me1, "Message to overridden stream");

   --  ..  but has an effect on default streams

   Me4 := Create ("MODULE4", Stream => "&mystream:overridden");
   Trace (Me4, "Message to overridden stream");

   --  Output to file

   Me1 := Create ("MODULE5", Stream => "outfile");
   Trace (Me1, "Message 1 to outfile");

   --  output to non-existing stream (defaults to default stream)

   Me1 := Create ("MODULE6", Stream => "&invalid");
   Trace (Me1, "Message 1 to invalid stream");

   --  Custom handles and decorators

   Me1 := Create ("DEBUG.CUSTOM", On, Factory => My_Decorator_Factory'Access);
   Add_Global_Decorator (Me1);

   Set_Active (Create ("DEBUG.COUNT"), True);
   Set_Active (Create ("DEBUG.ENCLOSING_ENTITY"), True);
   Cust := Create ("CUSTOM",
                   Stream => "&1",
                   Factory => My_Handle_Factory'Access);
   Trace (Cust, "Message on custom");

   Me2 := Create ("FOO", On, Stream => "&1");
   Trace (Me2, "Message with only global decorator");

   Set_Active (Create ("DEBUG.CUSTOM"), False);
   Trace (Me2, "global decorator disabled");

   Finalize;

end Traces2;
