; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -O0 -mtriple=mipsel-linux-gnu -global-isel -verify-machineinstrs %s -o -| FileCheck %s -check-prefixes=MIPS32
; RUN: llc -O0 -mtriple=mipsel-linux-gnu -global-isel -mcpu=mips32r6 -verify-machineinstrs %s -o -| FileCheck %s -check-prefixes=MIPS32R6

@float_align1 = common global float 0.000000e+00, align 1
@float_align2 = common global float 0.000000e+00, align 2
@float_align4 = common global float 0.000000e+00, align 4
@float_align8 = common global float 0.000000e+00, align 8
@i32_align1 = common global i32 0, align 1
@i32_align2 = common global i32 0, align 2
@i32_align4 = common global i32 0, align 4
@i32_align8 = common global i32 0, align 8

define void @store_float_align1(float %a) {
; MIPS32-LABEL: store_float_align1:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $1, %hi(float_align1)
; MIPS32-NEXT:    addiu $1, $1, %lo(float_align1)
; MIPS32-NEXT:    mfc1 $2, $f12
; MIPS32-NEXT:    swl $2, 3($1)
; MIPS32-NEXT:    swr $2, 0($1)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: store_float_align1:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lui $1, %hi(float_align1)
; MIPS32R6-NEXT:    addiu $1, $1, %lo(float_align1)
; MIPS32R6-NEXT:    swc1 $f12, 0($1)
; MIPS32R6-NEXT:    jrc $ra
entry:
  store float %a, float* @float_align1, align 1
  ret void
}

define void @store_float_align2(float %a) {
; MIPS32-LABEL: store_float_align2:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $1, %hi(float_align2)
; MIPS32-NEXT:    addiu $1, $1, %lo(float_align2)
; MIPS32-NEXT:    mfc1 $2, $f12
; MIPS32-NEXT:    swl $2, 3($1)
; MIPS32-NEXT:    swr $2, 0($1)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: store_float_align2:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lui $1, %hi(float_align2)
; MIPS32R6-NEXT:    addiu $1, $1, %lo(float_align2)
; MIPS32R6-NEXT:    swc1 $f12, 0($1)
; MIPS32R6-NEXT:    jrc $ra
entry:
  store float %a, float* @float_align2, align 2
  ret void
}

define void @store_float_align4(float %a) {
; MIPS32-LABEL: store_float_align4:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $1, %hi(float_align4)
; MIPS32-NEXT:    addiu $1, $1, %lo(float_align4)
; MIPS32-NEXT:    swc1 $f12, 0($1)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: store_float_align4:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lui $1, %hi(float_align4)
; MIPS32R6-NEXT:    addiu $1, $1, %lo(float_align4)
; MIPS32R6-NEXT:    swc1 $f12, 0($1)
; MIPS32R6-NEXT:    jrc $ra
entry:
  store float %a, float* @float_align4, align 4
  ret void
}

define void @store_float_align8(float %a) {
; MIPS32-LABEL: store_float_align8:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $1, %hi(float_align8)
; MIPS32-NEXT:    addiu $1, $1, %lo(float_align8)
; MIPS32-NEXT:    swc1 $f12, 0($1)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: store_float_align8:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lui $1, %hi(float_align8)
; MIPS32R6-NEXT:    addiu $1, $1, %lo(float_align8)
; MIPS32R6-NEXT:    swc1 $f12, 0($1)
; MIPS32R6-NEXT:    jrc $ra
entry:
  store float %a, float* @float_align8, align 8
  ret void
}

define void @store_i32_align1(i32 signext %a) {
; MIPS32-LABEL: store_i32_align1:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $1, %hi(i32_align1)
; MIPS32-NEXT:    addiu $1, $1, %lo(i32_align1)
; MIPS32-NEXT:    swl $4, 3($1)
; MIPS32-NEXT:    swr $4, 0($1)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: store_i32_align1:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lui $1, %hi(i32_align1)
; MIPS32R6-NEXT:    addiu $1, $1, %lo(i32_align1)
; MIPS32R6-NEXT:    sw $4, 0($1)
; MIPS32R6-NEXT:    jrc $ra
entry:
  store i32 %a, i32* @i32_align1, align 1
  ret void
}

define void @store_i32_align2(i32 signext %a) {
; MIPS32-LABEL: store_i32_align2:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $1, %hi(i32_align2)
; MIPS32-NEXT:    addiu $1, $1, %lo(i32_align2)
; MIPS32-NEXT:    swl $4, 3($1)
; MIPS32-NEXT:    swr $4, 0($1)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: store_i32_align2:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lui $1, %hi(i32_align2)
; MIPS32R6-NEXT:    addiu $1, $1, %lo(i32_align2)
; MIPS32R6-NEXT:    sw $4, 0($1)
; MIPS32R6-NEXT:    jrc $ra
entry:
  store i32 %a, i32* @i32_align2, align 2
  ret void
}

define void @store_i32_align4(i32 signext %a) {
; MIPS32-LABEL: store_i32_align4:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $1, %hi(i32_align4)
; MIPS32-NEXT:    addiu $1, $1, %lo(i32_align4)
; MIPS32-NEXT:    sw $4, 0($1)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: store_i32_align4:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lui $1, %hi(i32_align4)
; MIPS32R6-NEXT:    addiu $1, $1, %lo(i32_align4)
; MIPS32R6-NEXT:    sw $4, 0($1)
; MIPS32R6-NEXT:    jrc $ra
entry:
  store i32 %a, i32* @i32_align4, align 4
  ret void
}

define void @store_i32_align8(i32 signext %a) {
; MIPS32-LABEL: store_i32_align8:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $1, %hi(i32_align8)
; MIPS32-NEXT:    addiu $1, $1, %lo(i32_align8)
; MIPS32-NEXT:    sw $4, 0($1)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS32R6-LABEL: store_i32_align8:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lui $1, %hi(i32_align8)
; MIPS32R6-NEXT:    addiu $1, $1, %lo(i32_align8)
; MIPS32R6-NEXT:    sw $4, 0($1)
; MIPS32R6-NEXT:    jrc $ra
entry:
  store i32 %a, i32* @i32_align8, align 8
  ret void
}
