/***********************************************************************************

    Copyright (C) 2007-2018 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_PANEL_MAIN_HEADER
#define LIFEOGRAPH_PANEL_MAIN_HEADER


#include <gtkmm.h>

#include "diarydata.hpp"


namespace LIFEO
{

static const int        BROWSING_HISTORY_SIZE = 5;


class PanelMain
{
    public:
                                PanelMain();

        bool                    is_cur_elem( DiaryElement* elem )
        { return( elem == get_cur_elem() ); }

        void                    show( ElementViewProto* );

        void                    handle_login();
        void                    handle_logout();

        void                    go_back();
        void                    go_forward();

        void                    remove_element_from_history( DiaryElement* );
        void                    clear_history();

        DiaryElement*           get_cur_elem()
        { return m_elem_cur; }
        DiaryElement::Type      get_cur_elem_type()
        { return( m_elem_cur == nullptr ? DiaryElement::ET_NONE : m_elem_cur->get_type() ); }

        void                    set_icon( const Glib::RefPtr< Gdk::Pixbuf > icon )
        {
            m_image_elem->set( icon );
        }
        void                    update_overlay_icon()
        {
            m_image_overlay->set_visible(
                    m_cur_shower->get_element()->get_type() == DiaryElement::ET_ENTRY &&
                    m_cur_shower->get_element()->is_favored() );
        }

        void                    hide_popover()
        { if( m_Po_elem ) m_Po_elem->hide(); }

        void                    start_title_edit();
        bool                    cancel_title_edit();
        void                    apply_title_edit();
        // for entries whose title is partly defined by contents of entry text editor:
        void                    refresh_title()
        {
            m_label_elem_title->set_text( m_cur_shower->get_title_str() );
        }
        void                    refresh_extra_info()
        {
            m_label_elem_extra->set_text( m_cur_shower->get_info_str() );
        }

        //bool                    handle_entry_title_focus_out( GdkEventFocus* );
        void                    handle_entry_title_changed();
        bool                    handle_entry_title_key_press( GdkEventKey* );
        void                    handle_title_button_clicked();
        bool                    handle_title_click( GdkEventButton* );
        bool                    handle_title_hover( GdkEventCrossing* );
        bool                    handle_title_hover_out( GdkEventCrossing* );

        std::list< DiaryElement* >
                                m_browsing_history;
        unsigned int            m_bhist_offset{ 0 };  // browsing history index

    protected:
        void                    set_extra_tools( Gtk::Widget* );

        bool                    m_flag_index_locked{ false };
        bool                    m_flag_title_edit_in_progress{ false };
        bool                    m_flag_title_editable{ false };
        bool                    m_flag_title_applicable{ false };

        ElementViewProto*       m_cur_shower;
        DiaryElement*           m_elem_cur{ nullptr };

        Gtk::Widget*            m_ptr2widget{ nullptr };
        Gtk::Stack*             m_St_content;

        Gtk::EventBox*          m_eventbox_elem_title;
        Gtk::Label*             m_label_elem_title;
        Gtk::Box*               m_Bx_elem_title;
        Gtk::Box*               m_Bx_elem_title_edit;
        EntryClear*             m_E_elem_title;
        Gtk::Button*            m_B_elem_title;
        Gtk::Label*             m_label_elem_extra;
        Gtk::Button*            m_button_back;
        Gtk::Image*             m_image_elem;
        Gtk::Image*             m_image_overlay;
        Gtk::MenuButton*        m_button_elem;
        Gtk::Popover*           m_Po_elem;
        Gtk::Alignment*         m_alignment_extra_tools;

        Glib::RefPtr< Gtk::Action > m_action_previous_browsing;
};


} // end of namespace LIFEO

#endif
