/*
 * Copyright (C) 2015-2018 S[&]T, The Netherlands.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the copyright holder nor the names of its
 *    contributors may be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "harp-internal.h"

#include <string.h>

enum latitude_band
{
    tropic,
    subarctic,
    midlat
};

static const double altitude[] = {
    0.0,
    1000.0,
    2000.0,
    3000.0,
    4000.0,
    5000.0,
    6000.0,
    7000.0,
    8000.0,
    9000.0,
    10000.0,
    11000.0,
    12000.0,
    13000.0,
    14000.0,
    15000.0,
    16000.0,
    17000.0,
    18000.0,
    19000.0,
    20000.0,
    21000.0,
    22000.0,
    23000.0,
    24000.0,
    25000.0,
    27500.0,
    30000.0,
    32500.0,
    35000.0,
    37500.0,
    40000.0,
    42500.0,
    45000.0,
    47500.0,
    50000.0,
    55000.0,
    60000.0,
    65000.0,
    70000.0,
    75000.0,
    80000.0,
    85000.0,
    90000.0,
    95000.0,
    100000.0,
    105000.0,
    110000.0,
    115000.0,
    120000.0
};

static const double tropic_pressure[] = {
    1013.00000,
    904.00000,
    805.00000,
    715.00000,
    633.00000,
    559.00000,
    492.00000,
    432.00000,
    378.00000,
    329.00000,
    286.00000,
    247.00000,
    213.00000,
    182.00000,
    156.00000,
    132.00000,
    111.00000,
    93.70000,
    78.90000,
    66.60000,
    56.50000,
    48.00000,
    40.90000,
    35.00000,
    30.00000,
    25.70000,
    17.63000,
    12.20000,
    8.52000,
    6.00000,
    4.26000,
    3.05000,
    2.20000,
    1.59000,
    1.16000,
    0.85400,
    0.45600,
    0.23900,
    0.12100,
    0.05800,
    0.02600,
    0.01100,
    0.00440,
    0.00172,
    0.00069,
    0.00029,
    0.00013,
    0.00006,
    0.00004,
    0.00002
};

static const double tropic_temperature[] = {
    299.700,
    293.700,
    287.700,
    283.700,
    277.000,
    270.300,
    263.600,
    257.000,
    250.300,
    243.600,
    237.000,
    230.100,
    223.600,
    217.000,
    210.300,
    203.700,
    197.000,
    194.800,
    198.800,
    202.700,
    206.700,
    210.700,
    214.600,
    217.000,
    219.200,
    221.400,
    227.000,
    232.300,
    237.700,
    243.100,
    248.500,
    254.000,
    259.400,
    264.800,
    269.600,
    270.200,
    263.400,
    253.100,
    236.000,
    218.900,
    201.800,
    184.800,
    177.100,
    177.000,
    184.300,
    190.700,
    212.000,
    241.600,
    299.700,
    380.000
};

static const double tropic_air_number_density[] = {
    2.448130E+19,
    2.229340E+19,
    2.026599E+19,
    1.825402E+19,
    1.655144E+19,
    1.497882E+19,
    1.351859E+19,
    1.217482E+19,
    1.093812E+19,
    9.782062E+18,
    8.740364E+18,
    7.774853E+18,
    6.899532E+18,
    6.074680E+18,
    5.372756E+18,
    4.693478E+18,
    4.081019E+18,
    3.483874E+18,
    2.874567E+18,
    2.379755E+18,
    1.979793E+18,
    1.650017E+18,
    1.380402E+18,
    1.168208E+18,
    9.912712E+17,
    8.407510E+17,
    5.625204E+17,
    3.803842E+17,
    2.596105E+17,
    1.787632E+17,
    1.241638E+17,
    8.697170E+16,
    6.142774E+16,
    4.349016E+16,
    3.116377E+16,
    2.289203E+16,
    1.253894E+16,
    6.839393E+15,
    3.713515E+15,
    1.919084E+15,
    9.331769E+14,
    4.311244E+14,
    1.799476E+14,
    7.038287E+13,
    2.703802E+13,
    1.097638E+13,
    4.441394E+12,
    1.939631E+12,
    8.700167E+11,
    4.288552E+11
};

static const double tropic_ch4_number_density[] = {
    4.161864e+13,
    3.789917e+13,
    3.445254e+13,
    3.103215e+13,
    2.813774e+13,
    2.546425e+13,
    2.298185e+13,
    2.068523e+13,
    1.856218e+13,
    1.656120e+13,
    1.472766e+13,
    1.302301e+13,
    1.146714e+13,
    9.992953e+12,
    8.736192e+12,
    7.533108e+12,
    6.456238e+12,
    5.410512e+12,
    4.372261e+12,
    3.522074e+12,
    2.819254e+12,
    2.235797e+12,
    1.755889e+12,
    1.391350e+12,
    1.108253e+12,
    8.870013e+11,
    5.552133e+11,
    3.475226e+11,
    2.154789e+11,
    1.333587e+11,
    8.217245e+10,
    4.903515e+10,
    2.834305e+10,
    1.579144e+10,
    8.641801e+09,
    4.807376e+09,
    2.070201e+09,
    1.025920e+09,
    5.570330e+08,
    2.878656e+08,
    1.399780e+08,
    6.466931e+07,
    2.699241e+07,
    9.853704e+06,
    3.514979e+06,
    1.317179e+06,
    4.885584e+05,
    1.842669e+05,
    5.220154e+04,
    1.286579e+04
};

static const double tropic_co_number_density[] = {
    3.672233e+12,
    3.232576e+12,
    2.835241e+12,
    2.462493e+12,
    2.171571e+12,
    1.951760e+12,
    1.741213e+12,
    1.518215e+12,
    1.296181e+12,
    1.070169e+12,
    8.707240e+11,
    6.969449e+11,
    5.391350e+11,
    3.872041e+11,
    2.699838e+11,
    1.849718e+11,
    1.252477e+11,
    8.671452e+10,
    5.651457e+10,
    3.686279e+10,
    2.635132e+10,
    2.032842e+10,
    1.700672e+10,
    1.526863e+10,
    1.387794e+10,
    1.278795e+10,
    9.686701e+09,
    7.588742e+09,
    5.882834e+09,
    4.445886e+09,
    3.399640e+09,
    2.694411e+09,
    2.156136e+09,
    1.733970e+09,
    1.396774e+09,
    1.165674e+09,
    7.504634e+08,
    4.760267e+08,
    3.412013e+08,
    3.719224e+08,
    5.307965e+08,
    6.678185e+08,
    6.926252e+08,
    4.638279e+08,
    2.822799e+08,
    1.871491e+08,
    1.097480e+08,
    6.513349e+07,
    3.608866e+07,
    2.144298e+07
};

static const double tropic_co2_number_density[] = {
    8.085000E+15,
    7.362299E+15,
    6.692400E+15,
    6.029100E+15,
    5.464800E+15,
    4.946700E+15,
    4.464900E+15,
    4.019400E+15,
    3.613500E+15,
    3.230370E+15,
    2.886510E+15,
    2.567400E+15,
    2.278320E+15,
    2.006070E+15,
    1.774410E+15,
    1.550010E+15,
    1.347720E+15,
    1.150380E+15,
    9.494100E+14,
    7.857300E+14,
    6.537300E+14,
    5.448300E+14,
    4.557300E+14,
    3.857700E+14,
    3.273600E+14,
    2.776290E+14,
    1.857570E+14,
    1.256310E+14,
    8.573400E+13,
    5.903700E+13,
    4.101900E+13,
    2.871990E+13,
    2.028510E+13,
    1.436160E+13,
    1.029270E+13,
    7.560300E+12,
    4.141500E+12,
    2.258520E+12,
    1.226280E+12,
    6.336000E+11,
    3.081540E+11,
    1.414992E+11,
    5.763200E+10,
    2.183330E+10,
    7.306201E+09,
    2.141100E+09,
    4.889500E+08,
    1.164600E+08,
    3.482400E+07,
    1.478750E+07
};

static const double tropic_h2o_number_density[] = {
    6.352850E+17,
    4.348219E+17,
    3.110952E+17,
    1.571220E+17,
    7.354296E+16,
    5.015654E+16,
    2.842653E+16,
    1.570002E+16,
    8.362515E+15,
    4.011532E+15,
    1.672426E+15,
    5.684068E+14,
    2.005612E+14,
    6.018210E+13,
    3.344494E+13,
    1.878800E+13,
    1.225200E+13,
    1.010940E+13,
    7.911750E+12,
    6.190600E+12,
    5.150600E+12,
    4.375150E+12,
    3.866800E+12,
    3.390100E+12,
    3.174400E+12,
    2.734225E+12,
    2.026440E+12,
    1.522800E+12,
    1.117140E+12,
    8.229400E+11,
    6.090700E+11,
    4.525560E+11,
    3.380850E+11,
    2.480640E+11,
    1.840210E+11,
    1.374600E+11,
    7.530000E+10,
    4.106400E+10,
    2.006640E+10,
    8.640000E+09,
    3.081540E+09,
    9.059399E+08,
    2.341300E+08,
    5.986550E+07,
    1.461240E+07,
    4.392000E+06,
    1.511300E+06,
    5.434800E+05,
    2.089440E+05,
    8.450001E+04,
};

static const double tropic_n2o_number_density[] = {
    7.834097e+12,
    7.133961e+12,
    6.485184e+12,
    5.841346e+12,
    5.296515e+12,
    4.793271e+12,
    4.325994e+12,
    3.895981e+12,
    3.500235e+12,
    3.125401e+12,
    2.778590e+12,
    2.441329e+12,
    2.135427e+12,
    1.851582e+12,
    1.611306e+12,
    1.381774e+12,
    1.174121e+12,
    9.695721e+11,
    7.678047e+11,
    6.013703e+11,
    4.682259e+11,
    3.620175e+11,
    2.831232e+11,
    2.297888e+11,
    1.858653e+11,
    1.476374e+11,
    8.932916e+10,
    5.386295e+10,
    3.024493e+10,
    1.658046e+10,
    8.310369e+09,
    3.925073e+09,
    1.689894e+09,
    6.919355e+08,
    2.922568e+08,
    1.087841e+08,
    3.761721e+07,
    1.412349e+07,
    5.596325e+06,
    2.205050e+06,
    8.296028e+05,
    3.042045e+05,
    1.028591e+05,
    3.313660e+04,
    1.063146e+04,
    3.647487e+03,
    1.260036e+03,
    4.738568e+02,
    1.844454e+02,
    7.938192e+01
};

static const double tropic_no2_number_density[] = {
    5.635000E+08,
    5.131300E+08,
    4.664400E+08,
    4.202100E+08,
    3.808800E+08,
    3.447700E+08,
    3.111900E+08,
    2.801400E+08,
    2.518500E+08,
    2.271048E+08,
    2.081786E+08,
    2.038360E+08,
    2.174760E+08,
    2.705155E+08,
    4.021996E+08,
    8.031870E+08,
    1.302796E+09,
    1.809234E+09,
    2.218167E+09,
    2.523860E+09,
    2.753590E+09,
    2.905760E+09,
    2.982960E+09,
    3.016020E+09,
    3.035520E+09,
    3.146462E+09,
    2.707549E+09,
    2.345112E+09,
    1.873158E+09,
    1.302392E+09,
    7.781180E+08,
    3.507309E+08,
    1.333899E+08,
    5.004800E+07,
    2.077254E+07,
    1.014913E+07,
    4.254450E+06,
    1.950540E+06,
    9.401481E+05,
    4.435200E+05,
    2.007670E+05,
    8.714280E+04,
    3.457920E+04,
    1.288869E+04,
    4.762560E+03,
    1.866600E+03,
    7.289800E+02,
    3.086190E+02,
    1.349430E+02,
    6.379750E+01
};

static const double tropic_o2_number_density[] = {
    5.120500E+18,
    4.662790E+18,
    4.238520E+18,
    3.818430E+18,
    3.461040E+18,
    3.132910E+18,
    2.827770E+18,
    2.545620E+18,
    2.288550E+18,
    2.045901E+18,
    1.828123E+18,
    1.626020E+18,
    1.442936E+18,
    1.270511E+18,
    1.123793E+18,
    9.816730E+17,
    8.535560E+17,
    7.285740E+17,
    6.012930E+17,
    4.976290E+17,
    4.140290E+17,
    3.450590E+17,
    2.886290E+17,
    2.443210E+17,
    2.073280E+17,
    1.758317E+17,
    1.176461E+17,
    7.956630E+16,
    5.429820E+16,
    3.739010E+16,
    2.597870E+16,
    1.818927E+16,
    1.284723E+16,
    9.095680E+15,
    6.518710E+15,
    4.788190E+15,
    2.622950E+15,
    1.430396E+15,
    7.766440E+14,
    4.012800E+14,
    1.951642E+14,
    9.016260E+13,
    3.602000E+13,
    1.338170E+13,
    4.870800E+12,
    1.756800E+12,
    6.223000E+11,
    2.329200E+11,
    8.183640E+10,
    3.063125E+10
};

static const double tropic_o3_number_density[] = {
    7.029050E+11,
    7.027649E+11,
    6.777576E+11,
    6.401807E+11,
    5.897016E+11,
    5.646733E+11,
    5.397117E+11,
    5.143614E+11,
    4.895745E+11,
    4.894500E+11,
    4.893947E+11,
    5.144914E+11,
    5.395476E+11,
    5.646784E+11,
    5.645850E+11,
    5.899431E+11,
    5.897296E+11,
    8.715000E+11,
    1.438500E+12,
    2.261950E+12,
    2.773400E+12,
    2.971800E+12,
    3.314400E+12,
    3.974600E+12,
    4.265600E+12,
    4.543020E+12,
    4.390620E+12,
    3.540510E+12,
    2.559030E+12,
    1.735330E+12,
    1.093840E+12,
    6.527249E+11,
    3.626730E+11,
    1.958400E+11,
    1.076055E+11,
    6.414800E+10,
    2.259000E+10,
    7.528400E+09,
    2.415400E+09,
    5.760000E+08,
    1.680840E+08,
    1.423620E+08,
    9.005000E+07,
    3.662360E+07,
    1.353000E+07,
    4.392000E+06,
    8.890001E+05,
    9.705000E+04,
    4.353000E+03,
    2.112500E+02
};

static const double midlat_summer_pressure[] = {
    1013.00000,
    902.00000,
    802.00000,
    710.00000,
    628.00000,
    554.00000,
    487.00000,
    426.00000,
    372.00000,
    324.00000,
    281.00000,
    243.00000,
    209.00000,
    179.00000,
    153.00000,
    130.00000,
    111.00000,
    95.00000,
    81.20000,
    69.50000,
    59.50000,
    51.00000,
    43.70000,
    37.60000,
    32.20000,
    27.70000,
    19.07000,
    13.20000,
    9.30000,
    6.52000,
    4.64000,
    3.33000,
    2.41000,
    1.76000,
    1.29000,
    0.95100,
    0.51500,
    0.27200,
    0.13900,
    0.06700,
    0.03000,
    0.01200,
    0.00448,
    0.00164,
    0.00062,
    0.00026,
    0.00012,
    0.00006,
    0.00004,
    0.00002
};

static const double midlat_summer_temperature[] = {
    294.200,
    289.700,
    285.200,
    279.200,
    273.200,
    267.200,
    261.200,
    254.700,
    248.200,
    241.700,
    235.300,
    228.800,
    222.300,
    215.800,
    215.700,
    215.700,
    215.700,
    215.700,
    216.800,
    217.900,
    219.200,
    220.400,
    221.600,
    222.800,
    223.900,
    225.100,
    228.450,
    233.700,
    239.000,
    245.200,
    251.300,
    257.500,
    263.700,
    269.900,
    275.200,
    275.700,
    269.300,
    257.100,
    240.100,
    218.100,
    196.100,
    174.100,
    165.100,
    165.000,
    178.300,
    190.500,
    222.200,
    262.400,
    316.800,
    380.000
};

static const double midlat_summer_air_number_density[] = {
    2.493898E+19,
    2.255121E+19,
    2.036745E+19,
    1.841852E+19,
    1.664910E+19,
    1.501707E+19,
    1.350416E+19,
    1.211414E+19,
    1.085558E+19,
    9.709126E+18,
    8.649604E+18,
    7.692404E+18,
    6.809554E+18,
    6.007772E+18,
    5.137515E+18,
    4.365209E+18,
    3.727217E+18,
    3.189961E+18,
    2.712742E+18,
    2.310146E+18,
    1.966021E+18,
    1.675986E+18,
    1.428313E+18,
    1.222319E+18,
    1.041630E+18,
    8.912839E+17,
    6.046045E+17,
    4.090977E+17,
    2.818363E+17,
    1.925923E+17,
    1.337326E+17,
    9.366532E+16,
    6.619401E+16,
    4.723040E+16,
    3.395104E+16,
    2.498363E+16,
    1.385105E+16,
    7.662644E+15,
    4.193093E+15,
    2.225005E+15,
    1.108040E+15,
    4.992227E+14,
    1.965363E+14,
    7.198993E+13,
    2.538870E+13,
    9.809267E+12,
    3.813762E+12,
    1.686511E+12,
    8.139105E+11,
    4.326673E+11
};

static const double midlat_summer_ch4_number_density[] = {
    4.239669e+13,
    3.833745e+13,
    3.462502e+13,
    3.131181e+13,
    2.825381e+13,
    2.533405e+13,
    2.257919e+13,
    1.997642e+13,
    1.768392e+13,
    1.568040e+13,
    1.365786e+13,
    1.186181e+13,
    1.026891e+13,
    8.885585e+12,
    7.454611e+12,
    6.207391e+12,
    5.180885e+12,
    4.325631e+12,
    3.588995e+12,
    2.959327e+12,
    2.406435e+12,
    1.934108e+12,
    1.522598e+12,
    1.189328e+12,
    9.166441e+11,
    7.030520e+11,
    4.260087e+11,
    2.583479e+11,
    1.576045e+11,
    9.645122e+10,
    5.955174e+10,
    3.667972e+10,
    2.243338e+10,
    1.356943e+10,
    8.094011e+09,
    4.856868e+09,
    2.180178e+09,
    1.149408e+09,
    6.289704e+08,
    3.337542e+08,
    1.662077e+08,
    7.488417e+07,
    2.948075e+07,
    1.007869e+07,
    3.300565e+06,
    1.177124e+06,
    4.195182e+05,
    1.602202e+05,
    4.883513e+04,
    1.298015e+04
};

static const double midlat_summer_co_number_density[] = {
    3.740885e+12,
    3.269959e+12,
    2.849436e+12,
    2.484684e+12,
    2.184384e+12,
    1.956744e+12,
    1.739354e+12,
    1.510648e+12,
    1.286399e+12,
    1.062189e+12,
    8.616824e+11,
    6.895542e+11,
    5.321040e+11,
    3.829393e+11,
    2.581628e+11,
    1.720346e+11,
    1.143895e+11,
    7.939893e+10,
    5.333307e+10,
    3.578453e+10,
    2.616801e+10,
    2.064836e+10,
    1.759700e+10,
    1.597587e+10,
    1.458297e+10,
    1.355657e+10,
    1.041140e+10,
    8.161583e+09,
    6.386475e+09,
    4.789820e+09,
    3.632215e+09,
    2.774395e+09,
    2.077190e+09,
    1.561925e+09,
    1.183885e+09,
    9.106627e+08,
    5.433823e+08,
    3.580790e+08,
    2.685284e+08,
    2.618858e+08,
    3.252131e+08,
    3.402237e+08,
    2.879286e+08,
    2.051014e+08,
    1.311594e+08,
    9.887842e+07,
    7.112740e+07,
    4.828531e+07,
    3.166144e+07,
    2.163359e+07
};

static const double midlat_summer_co2_number_density[] = {
    8.236800E+15,
    7.448100E+15,
    6.725400E+15,
    6.081900E+15,
    5.497800E+15,
    4.959900E+15,
    4.458300E+15,
    3.999600E+15,
    3.583800E+15,
    3.206280E+15,
    2.856480E+15,
    2.540340E+15,
    2.248620E+15,
    1.983960E+15,
    1.696530E+15,
    1.441440E+15,
    1.230900E+15,
    1.053360E+15,
    8.959500E+14,
    7.629600E+14,
    6.491100E+14,
    5.534100E+14,
    4.715700E+14,
    4.035900E+14,
    3.438600E+14,
    2.943270E+14,
    1.996500E+14,
    1.351020E+14,
    9.306000E+13,
    6.359100E+13,
    4.415400E+13,
    3.093090E+13,
    2.185920E+13,
    1.559580E+13,
    1.121340E+13,
    8.250000E+12,
    4.573800E+12,
    2.530440E+12,
    1.384680E+12,
    7.349100E+11,
    3.659700E+11,
    1.638688E+11,
    6.294400E+10,
    2.233240E+10,
    6.860700E+09,
    1.914120E+09,
    4.197600E+08,
    1.012800E+08,
    3.258000E+07,
    1.515500E+07
};

static const double midlat_summer_h2o_number_density[] = {
    4.682496E+17,
    3.110146E+17,
    1.972784E+17,
    1.102851E+17,
    6.352458E+16,
    3.344175E+16,
    2.040010E+16,
    1.236240E+16,
    7.019904E+15,
    4.011736E+15,
    2.139763E+15,
    7.356209E+14,
    2.006042E+14,
    4.809600E+13,
    2.570500E+13,
    1.485120E+13,
    1.230900E+13,
    1.021440E+13,
    8.552250E+12,
    7.398400E+12,
    6.491100E+12,
    5.785650E+12,
    5.144399E+12,
    4.708550E+12,
    4.168000E+12,
    3.745980E+12,
    2.692250E+12,
    1.924180E+12,
    1.367700E+12,
    9.538649E+11,
    6.690000E+11,
    4.780230E+11,
    3.510720E+11,
    2.575670E+11,
    1.868900E+11,
    1.375000E+11,
    7.415099E+10,
    3.834000E+10,
    1.846240E+10,
    8.239900E+09,
    3.271550E+09,
    1.049160E+09,
    2.616110E+08,
    6.123400E+07,
    1.372140E+07,
    3.926400E+06,
    1.297440E+06,
    4.726400E+05,
    1.954800E+05,
    8.660000E+04
};

static const double midlat_summer_n2o_number_density[] = {
    7.980554e+12,
    7.216462e+12,
    6.517651e+12,
    5.893987e+12,
    5.327767e+12,
    4.805511e+12,
    4.321376e+12,
    3.876564e+12,
    3.468393e+12,
    3.071028e+12,
    2.677945e+12,
    2.299283e+12,
    1.999305e+12,
    1.718240e+12,
    1.438519e+12,
    1.189095e+12,
    9.731863e+11,
    7.722973e+11,
    5.897563e+11,
    4.257642e+11,
    3.159429e+11,
    2.217352e+11,
    1.636864e+11,
    1.265113e+11,
    1.002267e+11,
    7.984204e+10,
    4.840513e+10,
    2.740165e+10,
    1.397359e+10,
    7.116359e+09,
    3.368759e+09,
    1.626047e+09,
    7.665346e+08,
    3.620247e+08,
    1.806553e+08,
    8.032320e+07,
    2.811792e+07,
    1.070482e+07,
    4.276998e+06,
    1.729292e+06,
    6.933078e+05,
    2.579011e+05,
    8.553347e+04,
    2.683092e+04,
    8.218407e+03,
    2.789784e+03,
    9.626035e+02,
    3.811554e+02,
    1.659581e+02,
    8.008754e+01
};

static const double midlat_summer_no2_number_density[] = {
    5.740800E+08,
    5.191100E+08,
    4.687400E+08,
    4.238900E+08,
    3.831800E+08,
    3.456900E+08,
    3.107300E+08,
    2.787600E+08,
    2.497800E+08,
    2.254112E+08,
    2.060128E+08,
    2.016876E+08,
    2.146410E+08,
    2.675340E+08,
    3.845468E+08,
    7.469280E+08,
    1.189870E+09,
    1.656648E+09,
    2.093265E+09,
    2.450720E+09,
    2.734130E+09,
    2.951520E+09,
    3.086640E+09,
    3.155340E+09,
    3.188520E+09,
    3.335706E+09,
    2.910050E+09,
    2.521904E+09,
    2.033220E+09,
    1.402856E+09,
    8.375880E+08,
    3.777319E+08,
    1.437408E+08,
    5.434900E+07,
    2.263068E+07,
    1.107500E+07,
    4.698540E+06,
    2.185380E+06,
    1.061588E+06,
    5.144370E+05,
    2.384350E+05,
    1.009192E+05,
    3.776640E+04,
    1.318332E+04,
    4.472160E+03,
    1.668720E+03,
    6.258240E+02,
    2.683920E+02,
    1.262475E+02,
    6.538300E+01
};

static const double midlat_summer_o2_number_density[] = {
    5.216640E+18,
    4.717130E+18,
    4.259420E+18,
    3.851870E+18,
    3.481940E+18,
    3.141270E+18,
    2.823590E+18,
    2.533080E+18,
    2.269740E+18,
    2.030644E+18,
    1.809104E+18,
    1.608882E+18,
    1.424126E+18,
    1.256508E+18,
    1.074469E+18,
    9.129120E+17,
    7.795700E+17,
    6.671280E+17,
    5.674350E+17,
    4.832080E+17,
    4.111030E+17,
    3.504930E+17,
    2.986610E+17,
    2.556070E+17,
    2.177780E+17,
    1.864071E+17,
    1.264450E+17,
    8.556460E+16,
    5.893800E+16,
    4.027430E+16,
    2.796420E+16,
    1.958957E+16,
    1.384416E+16,
    9.877339E+15,
    7.101820E+15,
    5.225000E+15,
    2.896740E+15,
    1.602612E+15,
    8.769640E+14,
    4.654430E+14,
    2.317810E+14,
    1.044164E+14,
    3.934000E+13,
    1.368760E+13,
    4.573800E+12,
    1.570560E+12,
    5.342400E+11,
    2.025600E+11,
    7.656301E+10,
    3.139250E+10
};

static const double midlat_summer_o3_number_density[] = {
    7.530432E+11,
    7.531609E+11,
    7.528372E+11,
    7.781146E+11,
    8.031786E+11,
    8.284536E+11,
    8.657207E+11,
    9.409968E+11,
    9.910836E+11,
    1.079448E+12,
    1.128742E+12,
    1.380251E+12,
    1.519522E+12,
    1.803600E+12,
    2.262040E+12,
    2.184000E+12,
    2.238000E+12,
    2.234400E+12,
    2.715000E+12,
    3.468000E+12,
    3.934000E+12,
    4.024800E+12,
    4.144100E+12,
    4.158200E+12,
    4.168000E+12,
    4.281120E+12,
    3.630000E+12,
    2.865800E+12,
    2.284200E+12,
    1.715030E+12,
    1.164060E+12,
    7.076615E+11,
    3.908160E+11,
    2.126700E+11,
    1.189300E+11,
    7.000000E+10,
    2.494800E+10,
    9.968400E+09,
    3.356800E+09,
    8.908001E+08,
    2.107100E+08,
    9.992000E+07,
    1.121190E+08,
    5.403000E+07,
    1.778700E+07,
    3.926400E+06,
    7.632000E+05,
    8.440001E+04,
    4.072500E+03,
    2.165000E+02
};

static const double midlat_winter_pressure[] = {
    1018.00000,
    897.29999,
    789.70001,
    693.79999,
    608.09998,
    531.29999,
    462.70001,
    401.60001,
    347.29999,
    299.29999,
    256.79999,
    219.89999,
    188.20000,
    161.10001,
    137.80000,
    117.80000,
    100.70000,
    86.10000,
    73.60000,
    62.80000,
    53.70000,
    45.80000,
    39.10000,
    33.40000,
    28.60000,
    24.40000,
    16.46000,
    11.10000,
    7.56000,
    5.18000,
    3.60000,
    2.53000,
    1.80000,
    1.29000,
    0.94000,
    0.68300,
    0.36200,
    0.18800,
    0.09500,
    0.04700,
    0.02220,
    0.01030,
    0.00456,
    0.00198,
    0.00088,
    0.00041,
    0.00020,
    0.00011,
    0.00006,
    0.00004
};

static const double midlat_winter_temperature[] = {
    272.200,
    268.700,
    265.200,
    261.700,
    255.700,
    249.700,
    243.700,
    237.700,
    231.700,
    225.700,
    219.700,
    219.200,
    218.700,
    218.200,
    217.700,
    217.200,
    216.700,
    216.200,
    215.700,
    215.200,
    215.200,
    215.200,
    215.200,
    215.200,
    215.200,
    215.200,
    215.500,
    217.400,
    220.400,
    227.900,
    235.500,
    243.200,
    250.800,
    258.500,
    265.100,
    265.700,
    260.600,
    250.800,
    240.900,
    230.700,
    220.400,
    210.100,
    199.800,
    199.500,
    208.300,
    218.600,
    237.100,
    259.500,
    293.000,
    333.000
};

static const double midlat_winter_air_number_density[] = {
    2.708766E+19,
    2.418699E+19,
    2.156753E+19,
    1.920182E+19,
    1.722488E+19,
    1.541108E+19,
    1.375168E+19,
    1.223704E+19,
    1.085652E+19,
    9.604770E+18,
    8.465970E+18,
    7.266018E+18,
    6.232793E+18,
    5.347523E+18,
    4.584612E+18,
    3.928234E+18,
    3.365754E+18,
    2.884426E+18,
    2.471380E+18,
    2.113631E+18,
    1.807356E+18,
    1.541470E+18,
    1.315971E+18,
    1.124129E+18,
    9.625772E+17,
    8.212197E+17,
    5.532155E+17,
    3.698071E+17,
    2.484403E+17,
    1.646256E+17,
    1.107193E+17,
    7.534749E+16,
    5.198245E+16,
    3.614440E+16,
    2.568206E+16,
    1.861834E+16,
    1.006111E+16,
    5.429278E+15,
    2.856266E+15,
    1.475577E+15,
    7.295469E+14,
    3.550774E+14,
    1.653032E+14,
    7.188431E+13,
    3.049454E+13,
    1.349841E+13,
    6.109564E+12,
    2.950186E+12,
    1.478242E+12,
    7.830151E+11
};

static const double midlat_winter_ch4_number_density[] = {
    4.604949e+13,
    4.111830e+13,
    3.666518e+13,
    3.264343e+13,
    2.923091e+13,
    2.599876e+13,
    2.299305e+13,
    2.017908e+13,
    1.768545e+13,
    1.551186e+13,
    1.336791e+13,
    1.120432e+13,
    9.399147e+12,
    7.909067e+12,
    6.652341e+12,
    5.586005e+12,
    4.678446e+12,
    3.911321e+12,
    3.269669e+12,
    2.707589e+12,
    2.212227e+12,
    1.778874e+12,
    1.402839e+12,
    1.093788e+12,
    8.470767e+11,
    6.513161e+11,
    3.944467e+11,
    2.380843e+11,
    1.427553e+11,
    8.313676e+10,
    4.961384e+10,
    2.961940e+10,
    1.764822e+10,
    1.039524e+10,
    6.127804e+09,
    3.619443e+09,
    1.583635e+09,
    8.144002e+08,
    4.284443e+08,
    2.213389e+08,
    1.094332e+08,
    5.326215e+07,
    2.479573e+07,
    1.006391e+07,
    3.964331e+06,
    1.619826e+06,
    6.720590e+05,
    2.802706e+05,
    8.869540e+04,
    2.349069e+04
};

static const double midlat_winter_co_number_density[] = {
    4.063191e+12,
    3.507150e+12,
    3.017329e+12,
    2.590352e+12,
    2.259927e+12,
    2.008084e+12,
    1.771235e+12,
    1.525974e+12,
    1.286511e+12,
    1.050773e+12,
    8.433887e+11,
    6.513326e+11,
    4.870354e+11,
    3.408546e+11,
    2.303791e+11,
    1.548133e+11,
    1.032961e+11,
    7.179408e+10,
    4.858783e+10,
    3.274048e+10,
    2.405616e+10,
    1.899110e+10,
    1.621293e+10,
    1.469251e+10,
    1.347622e+10,
    1.230200e+10,
    8.840475e+09,
    6.323767e+09,
    4.596193e+09,
    3.287606e+09,
    2.377168e+09,
    1.756368e+09,
    1.362994e+09,
    1.104946e+09,
    9.766990e+08,
    1.162727e+09,
    1.489060e+09,
    1.588623e+09,
    1.595526e+09,
    1.590689e+09,
    1.383965e+09,
    1.051040e+09,
    7.481698e+08,
    4.932752e+08,
    3.214158e+08,
    2.306902e+08,
    1.510911e+08,
    9.909778e+07,
    6.133287e+07,
    3.915115e+07
};

static const double midlat_winter_co2_number_density[] = {
    8.946300E+15,
    7.986000E+15,
    7.121400E+15,
    6.342600E+15,
    5.689200E+15,
    5.088600E+15,
    4.540800E+15,
    4.042500E+15,
    3.583800E+15,
    3.171960E+15,
    2.795760E+15,
    2.399430E+15,
    2.058210E+15,
    1.765830E+15,
    1.514040E+15,
    1.297230E+15,
    1.111440E+15,
    9.523800E+14,
    8.160900E+14,
    6.979500E+14,
    5.969700E+14,
    5.091900E+14,
    4.346100E+14,
    3.712500E+14,
    3.178890E+14,
    2.711940E+14,
    1.826880E+14,
    1.221330E+14,
    8.203800E+13,
    5.435100E+13,
    3.656400E+13,
    2.488200E+13,
    1.716660E+13,
    1.193610E+13,
    8.481000E+12,
    6.147900E+12,
    3.323100E+12,
    1.792890E+12,
    9.431400E+11,
    4.874100E+11,
    2.409330E+11,
    1.165384E+11,
    5.292800E+10,
    2.230140E+10,
    8.240400E+09,
    2.634450E+09,
    6.725400E+08,
    1.771200E+08,
    5.916000E+07,
    2.742600E+07
};

static const double midlat_winter_h2o_number_density[] = {
    1.170068E+17,
    8.358680E+16,
    6.016504E+16,
    4.013136E+16,
    2.206720E+16,
    1.270762E+16,
    7.021728E+15,
    2.843225E+15,
    1.169622E+15,
    5.350039E+14,
    2.507712E+14,
    7.271000E+13,
    3.742200E+13,
    2.675500E+13,
    2.202240E+13,
    1.847570E+13,
    1.549280E+13,
    1.298700E+13,
    1.112850E+13,
    9.517500E+12,
    8.140500E+12,
    6.943500E+12,
    5.966010E+12,
    5.118751E+12,
    4.431180E+12,
    3.821370E+12,
    2.601920E+12,
    1.757975E+12,
    1.193280E+12,
    7.987950E+11,
    5.429200E+11,
    3.732300E+11,
    2.601000E+11,
    1.808500E+11,
    1.285000E+11,
    9.221850E+10,
    4.883950E+10,
    2.444850E+10,
    1.143200E+10,
    4.874100E+09,
    1.971270E+09,
    7.106000E+08,
    2.199820E+08,
    6.114900E+07,
    1.648080E+07,
    5.404000E+06,
    2.078760E+06,
    8.265599E+05,
    3.549600E+05,
    1.567200E+05
};

static const double midlat_winter_n2o_number_density[] = {
    8.668140e+12,
    7.739916e+12,
    6.901681e+12,
    6.144645e+12,
    5.512017e+12,
    4.931596e+12,
    4.400583e+12,
    3.915893e+12,
    3.468693e+12,
    3.038020e+12,
    2.621092e+12,
    2.171835e+12,
    1.829967e+12,
    1.529407e+12,
    1.283705e+12,
    1.070062e+12,
    8.788074e+11,
    6.983265e+11,
    5.372835e+11,
    3.895462e+11,
    2.929755e+11,
    2.099503e+11,
    1.618661e+11,
    1.263534e+11,
    1.008791e+11,
    7.933885e+10,
    4.809152e+10,
    2.782457e+10,
    1.521961e+10,
    8.422330e+09,
    4.393388e+09,
    2.256680e+09,
    1.081246e+09,
    4.738579e+08,
    2.072821e+08,
    7.752757e+07,
    2.645093e+07,
    9.821666e+06,
    3.773166e+06,
    1.485922e+06,
    5.751077e+05,
    2.248728e+05,
    8.585935e+04,
    3.114779e+04,
    1.117941e+04,
    4.238545e+03,
    1.659986e+03,
    7.000864e+02,
    3.088078e+02,
    1.449376e+02
};

static const double midlat_winter_no2_number_density[] = {
    6.235300E+08,
    5.566000E+08,
    4.963400E+08,
    4.420600E+08,
    3.965200E+08,
    3.546600E+08,
    3.164800E+08,
    2.817500E+08,
    2.497800E+08,
    2.229984E+08,
    2.016336E+08,
    1.905002E+08,
    1.964655E+08,
    2.381195E+08,
    3.431824E+08,
    6.722010E+08,
    1.074392E+09,
    1.497834E+09,
    1.906683E+09,
    2.241900E+09,
    2.514510E+09,
    2.715680E+09,
    2.844720E+09,
    2.902500E+09,
    2.947698E+09,
    3.073532E+09,
    2.662816E+09,
    2.279816E+09,
    1.792406E+09,
    1.199016E+09,
    6.936080E+08,
    3.038620E+08,
    1.128834E+08,
    4.159550E+07,
    1.711620E+07,
    8.253090E+06,
    3.413730E+06,
    1.548405E+06,
    7.230740E+05,
    3.411870E+05,
    1.569715E+05,
    7.177059E+04,
    3.175680E+04,
    1.316502E+04,
    5.371520E+03,
    2.296700E+03,
    1.002696E+03,
    4.693680E+02,
    2.292450E+02,
    1.183236E+02
};

static const double midlat_winter_o2_number_density[] = {
    5.665990E+18,
    5.057800E+18,
    4.510220E+18,
    4.016980E+18,
    3.603160E+18,
    3.222780E+18,
    2.875840E+18,
    2.560250E+18,
    2.269740E+18,
    2.008908E+18,
    1.770648E+18,
    1.519639E+18,
    1.303533E+18,
    1.118359E+18,
    9.588920E+17,
    8.215790E+17,
    7.039120E+17,
    6.031740E+17,
    5.168570E+17,
    4.420350E+17,
    3.780810E+17,
    3.224870E+17,
    2.752530E+17,
    2.351250E+17,
    2.013297E+17,
    1.717562E+17,
    1.157024E+17,
    7.735090E+16,
    5.195740E+16,
    3.442230E+16,
    2.315720E+16,
    1.575860E+16,
    1.087218E+16,
    7.559530E+15,
    5.371300E+15,
    3.893670E+15,
    2.104630E+15,
    1.135497E+15,
    5.973220E+14,
    3.086930E+14,
    1.525909E+14,
    7.425770E+13,
    3.308000E+13,
    1.366860E+13,
    5.493600E+12,
    2.161600E+12,
    8.559601E+11,
    3.542400E+11,
    1.390260E+11,
    5.681100E+10
};

static const double midlat_winter_o3_number_density[] = {
    7.531159E+11,
    6.776000E+11,
    6.148142E+11,
    6.150400E+11,
    6.149508E+11,
    7.278240E+11,
    8.031712E+11,
    9.666475E+11,
    1.128354E+12,
    1.506200E+12,
    2.007864E+12,
    2.635010E+12,
    3.263198E+12,
    3.764963E+12,
    3.670400E+12,
    3.537900E+12,
    3.704800E+12,
    4.040400E+12,
    4.451400E+12,
    4.864500E+12,
    5.246100E+12,
    5.400500E+12,
    5.136300E+12,
    4.837501E+12,
    4.527510E+12,
    4.191180E+12,
    3.100160E+12,
    2.257610E+12,
    1.690480E+12,
    1.169370E+12,
    7.977600E+11,
    5.202600E+11,
    3.069180E+11,
    1.663820E+11,
    9.509000E+10,
    5.123250E+10,
    1.711900E+10,
    5.433000E+09,
    1.571900E+09,
    4.726400E+08,
    1.825250E+08,
    8.171900E+07,
    9.097000E+07,
    5.755200E+07,
    2.441600E+07,
    5.404000E+06,
    1.222800E+06,
    1.476000E+05,
    7.395000E+03,
    3.918000E+02
};

static const double subarctic_summer_pressure[] = {
    1010.00000,
    896.00000,
    792.90002,
    700.00000,
    616.00000,
    541.00000,
    474.00000,
    413.00000,
    359.00000,
    310.79999,
    267.70001,
    230.00000,
    197.70000,
    170.00000,
    146.00000,
    126.00000,
    108.00000,
    92.80000,
    79.80000,
    68.60000,
    59.00000,
    50.70000,
    43.60000,
    37.50000,
    32.28000,
    27.80000,
    19.23000,
    13.40000,
    9.40000,
    6.61000,
    4.72000,
    3.40000,
    2.48000,
    1.82000,
    1.34000,
    0.98700,
    0.53700,
    0.28800,
    0.14700,
    0.07100,
    0.03200,
    0.01250,
    0.00451,
    0.00161,
    0.00061,
    0.00025,
    0.00011,
    0.00006,
    0.00004,
    0.00002
};

static const double subarctic_summer_temperature[] = {
    287.200,
    281.700,
    276.300,
    270.900,
    265.500,
    260.100,
    253.100,
    246.100,
    239.200,
    232.200,
    225.200,
    225.200,
    225.200,
    225.200,
    225.200,
    225.200,
    225.200,
    225.200,
    225.200,
    225.200,
    225.200,
    225.200,
    225.200,
    225.200,
    226.600,
    228.100,
    231.000,
    235.100,
    240.000,
    247.200,
    254.600,
    262.100,
    269.500,
    273.600,
    276.200,
    277.200,
    274.000,
    262.700,
    239.700,
    216.600,
    193.600,
    170.600,
    161.700,
    161.600,
    176.800,
    190.400,
    226.000,
    270.100,
    322.700,
    380.000
};

static const double subarctic_summer_air_number_density[] = {
    2.547116E+19,
    2.303737E+19,
    2.078497E+19,
    1.871548E+19,
    1.680459E+19,
    1.506498E+19,
    1.356432E+19,
    1.215487E+19,
    1.087039E+19,
    9.694616E+18,
    8.609776E+18,
    7.397267E+18,
    6.358433E+18,
    5.467545E+18,
    4.695657E+18,
    4.052416E+18,
    3.473499E+18,
    2.984637E+18,
    2.566530E+18,
    2.206315E+18,
    1.897560E+18,
    1.630615E+18,
    1.402264E+18,
    1.206076E+18,
    1.031776E+18,
    8.827370E+17,
    6.029470E+17,
    4.128230E+17,
    2.836798E+17,
    1.936711E+17,
    1.342751E+17,
    9.395583E+16,
    6.665071E+16,
    4.818004E+16,
    3.513929E+16,
    2.578907E+16,
    1.419501E+16,
    7.940434E+15,
    4.441822E+15,
    2.374169E+15,
    1.197172E+15,
    5.306923E+14,
    2.020125E+14,
    7.215997E+13,
    2.482574E+13,
    9.434015E+12,
    3.621444E+12,
    1.608935E+12,
    7.945406E+11,
    4.307612E+11
};

static const double subarctic_summer_ch4_number_density[] = {
    4.239669e+13,
    3.833745e+13,
    3.462502e+13,
    3.131181e+13,
    2.825381e+13,
    2.533405e+13,
    2.257919e+13,
    1.997642e+13,
    1.768392e+13,
    1.568040e+13,
    1.365786e+13,
    1.186181e+13,
    1.026891e+13,
    8.885585e+12,
    7.454611e+12,
    6.207391e+12,
    5.180885e+12,
    4.325631e+12,
    3.588995e+12,
    2.959327e+12,
    2.406435e+12,
    1.934108e+12,
    1.522598e+12,
    1.189328e+12,
    9.166441e+11,
    7.030520e+11,
    4.260087e+11,
    2.583479e+11,
    1.576045e+11,
    9.645122e+10,
    5.955174e+10,
    3.667972e+10,
    2.243338e+10,
    1.356943e+10,
    8.094011e+09,
    4.856868e+09,
    2.180178e+09,
    1.149408e+09,
    6.289704e+08,
    3.337542e+08,
    1.662077e+08,
    7.488417e+07,
    2.948075e+07,
    1.007869e+07,
    3.300565e+06,
    1.177124e+06,
    4.195182e+05,
    1.602202e+05,
    4.883513e+04,
    1.298015e+04
};

static const double subarctic_summer_co_number_density[] = {
    3.740885e+12,
    3.269959e+12,
    2.849436e+12,
    2.484684e+12,
    2.184384e+12,
    1.956744e+12,
    1.739354e+12,
    1.510648e+12,
    1.286399e+12,
    1.062189e+12,
    8.616824e+11,
    6.895542e+11,
    5.321040e+11,
    3.829393e+11,
    2.581628e+11,
    1.720346e+11,
    1.143895e+11,
    7.939893e+10,
    5.333307e+10,
    3.578453e+10,
    2.616801e+10,
    2.064836e+10,
    1.759700e+10,
    1.597587e+10,
    1.458297e+10,
    1.355657e+10,
    1.041140e+10,
    8.161583e+09,
    6.386475e+09,
    4.789820e+09,
    3.632215e+09,
    2.774395e+09,
    2.077190e+09,
    1.561925e+09,
    1.183885e+09,
    9.106627e+08,
    5.433823e+08,
    3.580790e+08,
    2.685284e+08,
    2.618858e+08,
    3.252131e+08,
    3.402237e+08,
    2.879286e+08,
    2.051014e+08,
    1.311594e+08,
    9.887842e+07,
    7.112740e+07,
    4.828531e+07,
    3.166144e+07,
    2.163359e+07
};

static const double subarctic_summer_co2_number_density[] = {
    8.411700E+15,
    7.606500E+15,
    6.864000E+15,
    6.180900E+15,
    5.550600E+15,
    4.976400E+15,
    4.478100E+15,
    4.012800E+15,
    3.590400E+15,
    3.201330E+15,
    2.843280E+15,
    2.442660E+15,
    2.099790E+15,
    1.805430E+15,
    1.550670E+15,
    1.338150E+15,
    1.147080E+15,
    9.857100E+14,
    8.474400E+14,
    7.286400E+14,
    6.266700E+14,
    5.385600E+14,
    4.629900E+14,
    3.983100E+14,
    3.408900E+14,
    2.915220E+14,
    1.991220E+14,
    1.363230E+14,
    9.368700E+13,
    6.395400E+13,
    4.435200E+13,
    3.102660E+13,
    2.201100E+13,
    1.590930E+13,
    1.160280E+13,
    8.517300E+12,
    4.689300E+12,
    2.622180E+12,
    1.466850E+12,
    7.840800E+11,
    3.953400E+11,
    1.742008E+11,
    6.470400E+10,
    2.238510E+10,
    6.706800E+09,
    1.840995E+09,
    3.986400E+08,
    9.660000E+07,
    3.180400E+07,
    1.508850E+07
};

static const double subarctic_summer_h2o_number_density[] = {
    3.043506E+17,
    2.005581E+17,
    1.404000E+17,
    9.027860E+16,
    5.685160E+16,
    3.344744E+16,
    1.804810E+16,
    9.692736E+15,
    4.347648E+15,
    1.261130E+15,
    3.653184E+14,
    9.844661E+13,
    3.817800E+13,
    2.434595E+13,
    1.879600E+13,
    1.622000E+13,
    1.390400E+13,
    1.209735E+13,
    1.104240E+13,
    9.936000E+12,
    8.735400E+12,
    7.670400E+12,
    6.734400E+12,
    5.829810E+12,
    5.010049E+12,
    4.328660E+12,
    2.986830E+12,
    2.065500E+12,
    1.419500E+12,
    9.690000E+11,
    6.720000E+11,
    4.701000E+11,
    3.335000E+11,
    2.410500E+11,
    1.758000E+11,
    1.277595E+11,
    6.891850E+10,
    3.575700E+10,
    1.778000E+10,
    7.840800E+09,
    3.234600E+09,
    1.062200E+09,
    2.689260E+08,
    6.137850E+07,
    1.341360E+07,
    3.776400E+06,
    1.232160E+06,
    4.508000E+05,
    1.908240E+05,
    8.622001E+04
};

static const double subarctic_summer_n2o_number_density[] = {
    7.980554e+12,
    7.216462e+12,
    6.517651e+12,
    5.893987e+12,
    5.327767e+12,
    4.805511e+12,
    4.321376e+12,
    3.876564e+12,
    3.468393e+12,
    3.071028e+12,
    2.677945e+12,
    2.299283e+12,
    1.999305e+12,
    1.718240e+12,
    1.438519e+12,
    1.189095e+12,
    9.731863e+11,
    7.722973e+11,
    5.897563e+11,
    4.257642e+11,
    3.159429e+11,
    2.217352e+11,
    1.636864e+11,
    1.265113e+11,
    1.002267e+11,
    7.984204e+10,
    4.840513e+10,
    2.740165e+10,
    1.397359e+10,
    7.116359e+09,
    3.368759e+09,
    1.626047e+09,
    7.665346e+08,
    3.620247e+08,
    1.806553e+08,
    8.032320e+07,
    2.811792e+07,
    1.070482e+07,
    4.276998e+06,
    1.729292e+06,
    6.933078e+05,
    2.579011e+05,
    8.553347e+04,
    2.683092e+04,
    8.218407e+03,
    2.789784e+03,
    9.626035e+02,
    3.811554e+02,
    1.659581e+02,
    8.008754e+01
};

static const double subarctic_summer_no2_number_density[] = {
    5.862700E+08,
    5.301500E+08,
    4.784000E+08,
    4.307900E+08,
    3.868600E+08,
    3.468400E+08,
    3.121100E+08,
    2.796800E+08,
    2.502400E+08,
    2.250632E+08,
    2.050608E+08,
    1.939324E+08,
    2.004345E+08,
    2.434595E+08,
    3.514852E+08,
    6.934050E+08,
    1.108844E+09,
    1.550253E+09,
    1.979928E+09,
    2.340480E+09,
    2.639610E+09,
    2.872320E+09,
    3.030480E+09,
    3.114060E+09,
    3.160980E+09,
    3.303916E+09,
    2.902354E+09,
    2.544696E+09,
    2.046919E+09,
    1.410864E+09,
    8.413440E+08,
    3.789006E+08,
    1.447390E+08,
    5.544150E+07,
    2.341656E+07,
    1.143383E+07,
    4.817190E+06,
    2.264610E+06,
    1.124585E+06,
    5.488560E+05,
    2.575700E+05,
    1.072822E+05,
    3.882240E+04,
    1.321443E+04,
    4.371840E+03,
    1.604970E+03,
    5.943360E+02,
    2.559900E+02,
    1.232405E+02,
    6.509610E+01
};

static const double subarctic_summer_o2_number_density[] = {
    5.327410E+18,
    4.817450E+18,
    4.347200E+18,
    3.914570E+18,
    3.515380E+18,
    3.151720E+18,
    2.836130E+18,
    2.541440E+18,
    2.273920E+18,
    2.027509E+18,
    1.800744E+18,
    1.547018E+18,
    1.329867E+18,
    1.143439E+18,
    9.820909E+17,
    8.474950E+17,
    7.264840E+17,
    6.242830E+17,
    5.367120E+17,
    4.614720E+17,
    3.968910E+17,
    3.410880E+17,
    2.932270E+17,
    2.522630E+17,
    2.158970E+17,
    1.846306E+17,
    1.261106E+17,
    8.633790E+16,
    5.933510E+16,
    4.050420E+16,
    2.808960E+16,
    1.965018E+16,
    1.394030E+16,
    1.007589E+16,
    7.348440E+15,
    5.394290E+15,
    2.969890E+15,
    1.660714E+15,
    9.290050E+14,
    4.965840E+14,
    2.503820E+14,
    1.109999E+14,
    4.044000E+13,
    1.371990E+13,
    4.471200E+12,
    1.510560E+12,
    5.073600E+11,
    1.932000E+11,
    7.473940E+10,
    3.125475E+10
};

static const double subarctic_summer_o3_number_density[] = {
    6.148188E+11,
    6.776700E+11,
    7.028321E+11,
    7.280351E+11,
    7.531996E+11,
    8.034624E+11,
    8.907348E+11,
    9.409409E+11,
    9.916032E+11,
    1.377542E+12,
    1.628424E+12,
    2.257610E+12,
    2.608830E+12,
    2.735500E+12,
    2.819400E+12,
    2.838500E+12,
    2.954600E+12,
    2.987000E+12,
    3.338400E+12,
    3.753600E+12,
    3.987900E+12,
    4.406400E+12,
    4.629900E+12,
    4.465900E+12,
    4.338600E+12,
    3.975300E+12,
    3.198020E+12,
    2.354670E+12,
    1.958910E+12,
    1.492260E+12,
    1.048320E+12,
    6.581400E+11,
    3.601800E+11,
    2.024820E+11,
    1.125120E+11,
    6.452500E+10,
    2.415700E+10,
    9.535200E+09,
    3.556000E+09,
    9.504000E+08,
    2.396000E+08,
    9.559800E+07,
    1.314300E+08,
    6.498900E+07,
    1.987200E+07,
    3.776400E+06,
    7.248001E+05,
    8.050000E+04,
    3.975500E+03,
    2.155500E+02
};

static const double subarctic_winter_pressure[] = {
    1013.00000,
    887.79999,
    777.50000,
    679.79999,
    593.20001,
    515.79999,
    446.70001,
    385.29999,
    330.79999,
    282.89999,
    241.80000,
    206.70000,
    176.60001,
    151.00000,
    129.10001,
    110.30000,
    94.31000,
    80.58000,
    68.82000,
    58.75000,
    50.14000,
    42.77000,
    36.47000,
    31.09000,
    26.49000,
    22.56000,
    15.13000,
    10.20000,
    6.91000,
    4.70100,
    3.23000,
    2.24300,
    1.57000,
    1.11300,
    0.79000,
    0.57190,
    0.29900,
    0.15500,
    0.07900,
    0.04000,
    0.02000,
    0.00966,
    0.00450,
    0.00202,
    0.00091,
    0.00042,
    0.00021,
    0.00011,
    0.00006,
    0.00004
};

static const double subarctic_winter_temperature[] = {
    257.200,
    259.100,
    255.900,
    252.700,
    247.700,
    240.900,
    234.100,
    227.300,
    220.600,
    217.200,
    217.200,
    217.200,
    217.200,
    217.200,
    217.200,
    217.200,
    216.600,
    216.000,
    215.400,
    214.800,
    214.200,
    213.600,
    213.000,
    212.400,
    211.800,
    211.200,
    213.600,
    216.000,
    218.500,
    222.300,
    228.500,
    234.700,
    240.800,
    247.000,
    253.200,
    259.300,
    259.100,
    250.900,
    248.400,
    245.400,
    234.700,
    223.900,
    213.100,
    202.300,
    211.000,
    218.500,
    234.000,
    252.600,
    288.500,
    333.000
};

static const double subarctic_winter_air_number_density[] = {
    2.852662E+19,
    2.481759E+19,
    2.200604E+19,
    1.948443E+19,
    1.734551E+19,
    1.550802E+19,
    1.382058E+19,
    1.227754E+19,
    1.086105E+19,
    9.433762E+18,
    8.063216E+18,
    6.892749E+18,
    5.889016E+18,
    5.035342E+18,
    4.305051E+18,
    3.678134E+18,
    3.153632E+18,
    2.702000E+18,
    2.314093E+18,
    1.981004E+18,
    1.695418E+18,
    1.450273E+18,
    1.240132E+18,
    1.060176E+18,
    9.058741E+17,
    7.736723E+17,
    5.130379E+17,
    3.420253E+17,
    2.290543E+17,
    1.531661E+17,
    1.023831E+17,
    6.921943E+16,
    4.722316E+16,
    3.263698E+16,
    2.259827E+16,
    1.597458E+16,
    8.358255E+15,
    4.474483E+15,
    2.303495E+15,
    1.180585E+15,
    6.172040E+14,
    3.124891E+14,
    1.529470E+14,
    7.239309E+13,
    3.113413E+13,
    1.402170E+13,
    6.407171E+12,
    3.096722E+12,
    1.506320E+12,
    7.808399E+11
};

static const double subarctic_winter_ch4_number_density[] = {
    4.604949e+13,
    4.111830e+13,
    3.666518e+13,
    3.264343e+13,
    2.923091e+13,
    2.599876e+13,
    2.299305e+13,
    2.017908e+13,
    1.768545e+13,
    1.551186e+13,
    1.336791e+13,
    1.120432e+13,
    9.399147e+12,
    7.909067e+12,
    6.652341e+12,
    5.586005e+12,
    4.678446e+12,
    3.911321e+12,
    3.269669e+12,
    2.707589e+12,
    2.212227e+12,
    1.778874e+12,
    1.402839e+12,
    1.093788e+12,
    8.470767e+11,
    6.513161e+11,
    3.944467e+11,
    2.380843e+11,
    1.427553e+11,
    8.313676e+10,
    4.961384e+10,
    2.961940e+10,
    1.764822e+10,
    1.039524e+10,
    6.127804e+09,
    3.619443e+09,
    1.583635e+09,
    8.144002e+08,
    4.284443e+08,
    2.213389e+08,
    1.094332e+08,
    5.326215e+07,
    2.479573e+07,
    1.006391e+07,
    3.964331e+06,
    1.619826e+06,
    6.720590e+05,
    2.802706e+05,
    8.869540e+04,
    2.349069e+04
};

static const double subarctic_winter_co_number_density[] = {
    4.063191e+12,
    3.507150e+12,
    3.017329e+12,
    2.590352e+12,
    2.259927e+12,
    2.008084e+12,
    1.771235e+12,
    1.525974e+12,
    1.286511e+12,
    1.050773e+12,
    8.433887e+11,
    6.513326e+11,
    4.870354e+11,
    3.408546e+11,
    2.303791e+11,
    1.548133e+11,
    1.032961e+11,
    7.179408e+10,
    4.858783e+10,
    3.274048e+10,
    2.405616e+10,
    1.899110e+10,
    1.621293e+10,
    1.469251e+10,
    1.347622e+10,
    1.230200e+10,
    8.840475e+09,
    6.323767e+09,
    4.596193e+09,
    3.287606e+09,
    2.377168e+09,
    1.756368e+09,
    1.362994e+09,
    1.104946e+09,
    9.766990e+08,
    1.162727e+09,
    1.489060e+09,
    1.588623e+09,
    1.595526e+09,
    1.590689e+09,
    1.383965e+09,
    1.051040e+09,
    7.481698e+08,
    4.932752e+08,
    3.214158e+08,
    2.306902e+08,
    1.510911e+08,
    9.909778e+07,
    6.133287e+07,
    3.915115e+07
};

static const double subarctic_winter_co2_number_density[] = {
    9.421500E+15,
    8.197200E+15,
    7.266600E+15,
    6.435000E+15,
    5.728800E+15,
    5.121600E+15,
    4.563900E+15,
    4.055700E+15,
    3.587100E+15,
    3.115200E+15,
    2.662770E+15,
    2.276340E+15,
    1.944690E+15,
    1.662870E+15,
    1.421640E+15,
    1.214730E+15,
    1.041480E+15,
    8.923200E+14,
    7.642800E+14,
    6.540600E+14,
    5.600100E+14,
    4.788300E+14,
    4.095300E+14,
    3.501300E+14,
    2.991450E+14,
    2.554860E+14,
    1.694220E+14,
    1.129590E+14,
    7.563600E+13,
    5.058900E+13,
    3.382500E+13,
    2.285910E+13,
    1.559580E+13,
    1.077780E+13,
    7.461300E+12,
    5.276700E+12,
    2.760120E+12,
    1.477740E+12,
    7.606500E+11,
    3.897300E+11,
    2.038080E+11,
    1.025656E+11,
    4.899200E+10,
    2.245640E+10,
    8.413200E+09,
    2.735850E+09,
    7.053200E+08,
    1.859400E+08,
    6.028000E+07,
    2.734900E+07
};

static const double subarctic_winter_h2o_number_density[] = {
    4.011275E+16,
    4.011660E+16,
    3.142254E+16,
    2.273700E+16,
    1.371093E+16,
    6.687568E+15,
    3.276327E+15,
    1.806630E+15,
    3.678408E+14,
    2.809344E+14,
    1.613800E+14,
    6.898000E+13,
    3.535800E+13,
    2.242355E+13,
    1.938600E+13,
    1.674855E+13,
    1.451760E+13,
    1.257360E+13,
    1.088520E+13,
    9.414500E+12,
    8.145601E+12,
    7.037350E+12,
    6.080900E+12,
    5.251950E+12,
    4.532500E+12,
    3.871000E+12,
    2.567000E+12,
    1.711500E+12,
    1.146000E+12,
    7.664999E+11,
    5.125000E+11,
    3.463500E+11,
    2.363000E+11,
    1.633000E+11,
    1.130500E+11,
    7.915050E+10,
    4.056540E+10,
    2.015100E+10,
    9.220000E+09,
    3.897300E+09,
    1.667520E+09,
    6.254000E+08,
    2.036230E+08,
    6.157400E+07,
    1.682640E+07,
    5.612000E+06,
    2.180080E+06,
    8.677201E+05,
    3.616800E+05,
    1.562800E+05
};

static const double subarctic_winter_n2o_number_density[] = {
    8.668140e+12,
    7.739916e+12,
    6.901681e+12,
    6.144645e+12,
    5.512017e+12,
    4.931596e+12,
    4.400583e+12,
    3.915893e+12,
    3.468693e+12,
    3.038020e+12,
    2.621092e+12,
    2.171835e+12,
    1.829967e+12,
    1.529407e+12,
    1.283705e+12,
    1.070062e+12,
    8.788074e+11,
    6.983265e+11,
    5.372835e+11,
    3.895462e+11,
    2.929755e+11,
    2.099503e+11,
    1.618661e+11,
    1.263534e+11,
    1.008791e+11,
    7.933885e+10,
    4.809152e+10,
    2.782457e+10,
    1.521961e+10,
    8.422330e+09,
    4.393388e+09,
    2.256680e+09,
    1.081246e+09,
    4.738579e+08,
    2.072821e+08,
    7.752757e+07,
    2.645093e+07,
    9.821666e+06,
    3.773166e+06,
    1.485922e+06,
    5.751077e+05,
    2.248728e+05,
    8.585935e+04,
    3.114779e+04,
    1.117941e+04,
    4.238545e+03,
    1.659986e+03,
    7.000864e+02,
    3.088078e+02,
    1.449376e+02
};

static const double subarctic_winter_no2_number_density[] = {
    6.566500E+08,
    5.713200E+08,
    5.064600E+08,
    4.485000E+08,
    3.992800E+08,
    3.569600E+08,
    3.180900E+08,
    2.826700E+08,
    2.500100E+08,
    2.190080E+08,
    1.920422E+08,
    1.807276E+08,
    1.856295E+08,
    2.242355E+08,
    3.222384E+08,
    6.294510E+08,
    1.006764E+09,
    1.403376E+09,
    1.785636E+09,
    2.100920E+09,
    2.358830E+09,
    2.553760E+09,
    2.680560E+09,
    2.737380E+09,
    2.773890E+09,
    2.895508E+09,
    2.469454E+09,
    2.108568E+09,
    1.652532E+09,
    1.116024E+09,
    6.416500E+08,
    2.791581E+08,
    1.025542E+08,
    3.755900E+07,
    1.505826E+07,
    7.083570E+06,
    2.835396E+06,
    1.276230E+06,
    5.831650E+05,
    2.728110E+05,
    1.327840E+05,
    6.316540E+04,
    2.939520E+04,
    1.325652E+04,
    5.484160E+03,
    2.385100E+03,
    1.051568E+03,
    4.927410E+02,
    2.335850E+02,
    1.179914E+02
};

static const double subarctic_winter_o2_number_density[] = {
    5.966950E+18,
    5.191560E+18,
    4.602180E+18,
    4.075500E+18,
    3.628240E+18,
    3.243680E+18,
    2.890470E+18,
    2.568610E+18,
    2.271830E+18,
    1.972960E+18,
    1.686421E+18,
    1.441682E+18,
    1.231637E+18,
    1.053151E+18,
    9.003720E+17,
    7.693290E+17,
    6.596040E+17,
    5.651360E+17,
    4.840440E+17,
    4.142380E+17,
    3.546730E+17,
    3.032590E+17,
    2.593690E+17,
    2.217490E+17,
    1.894585E+17,
    1.618078E+17,
    1.073006E+17,
    7.154070E+16,
    4.790280E+16,
    3.203970E+16,
    2.142250E+16,
    1.447743E+16,
    9.877339E+15,
    6.825940E+15,
    4.725491E+15,
    3.341910E+15,
    1.748076E+15,
    9.359020E+14,
    4.817450E+14,
    2.468290E+14,
    1.290784E+14,
    6.535430E+13,
    3.062000E+13,
    1.376360E+13,
    5.608800E+12,
    2.244800E+12,
    8.976799E+11,
    3.718800E+11,
    1.416580E+11,
    5.665150E+10
};

static const double subarctic_winter_o3_number_density[] = {
    5.144710E+11,
    5.146847E+11,
    5.143872E+11,
    5.395650E+11,
    5.647208E+11,
    5.899152E+11,
    6.148818E+11,
    8.912709E+11,
    1.130480E+12,
    1.982400E+12,
    2.420700E+12,
    2.414300E+12,
    2.357200E+12,
    3.275350E+12,
    3.877200E+12,
    4.417200E+12,
    4.734000E+12,
    5.137600E+12,
    5.674200E+12,
    6.144200E+12,
    6.278900E+12,
    5.804000E+12,
    5.212200E+12,
    4.774500E+12,
    4.169900E+12,
    3.638740E+12,
    2.515660E+12,
    1.848420E+12,
    1.352280E+12,
    9.504599E+11,
    6.406250E+11,
    4.086930E+11,
    2.410260E+11,
    1.339060E+11,
    6.783000E+10,
    4.157400E+10,
    1.338240E+10,
    4.254100E+09,
    1.498250E+09,
    5.905000E+08,
    2.038080E+08,
    4.065100E+07,
    1.148250E+08,
    5.795200E+07,
    2.492800E+07,
    5.612000E+06,
    1.282400E+06,
    1.549500E+05,
    7.535000E+03,
    3.907000E+02
};

int harp_aux_afgl86_get_profile(const char *name, double datetime, double latitude, int *num_vertical,
                                const double **values)
{
    double fraction_of_year = harp_fraction_of_year_from_datetime(datetime);
    enum latitude_band band;
    int summer;

    if (latitude >= 0.0)
    {
        /* Northern hemisphere */
        summer = (fraction_of_year >= 0.25 && fraction_of_year < 0.75);
    }
    else
    {
        /* Southern hemisphere */
        summer = (fraction_of_year < 0.25 || fraction_of_year >= 0.75);
    }

    if (latitude > -30.0 && latitude < 30.0)
    {
        band = tropic;
    }
    else if (latitude > 80.0 || latitude < -80.0)
    {
        band = subarctic;
    }
    else
    {
        band = midlat;
    }

    if (strcmp(name, "altitude") == 0)
    {
        *values = altitude;
    }
    else if (strcmp(name, "pressure") == 0)
    {
        switch (band)
        {
            case tropic:
                *values = tropic_pressure;
                break;
            case midlat:
                *values = summer ? midlat_summer_pressure : midlat_winter_pressure;
                break;
            case subarctic:
                *values = summer ? subarctic_summer_pressure : subarctic_winter_pressure;
                break;
        }
    }
    else if (strcmp(name, "temperature") == 0)
    {
        switch (band)
        {
            case tropic:
                *values = tropic_temperature;
                break;
            case midlat:
                *values = summer ? midlat_summer_temperature : midlat_winter_temperature;
                break;
            case subarctic:
                *values = summer ? subarctic_summer_temperature : subarctic_winter_temperature;
                break;
        }
    }
    else if (strcmp(name, "number_density") == 0)
    {
        switch (band)
        {
            case tropic:
                *values = tropic_air_number_density;
                break;
            case midlat:
                *values = summer ? midlat_summer_air_number_density : midlat_winter_air_number_density;
                break;
            case subarctic:
                *values = summer ? subarctic_summer_air_number_density : subarctic_winter_air_number_density;
                break;
        }
    }
    else if (strcmp(name, "CH4_number_density") == 0)
    {
        switch (band)
        {
            case tropic:
                *values = tropic_ch4_number_density;
                break;
            case midlat:
                *values = summer ? midlat_summer_ch4_number_density : midlat_winter_ch4_number_density;
                break;
            case subarctic:
                *values = summer ? subarctic_summer_ch4_number_density : subarctic_winter_ch4_number_density;
                break;
        }
    }
    else if (strcmp(name, "CO_number_density") == 0)
    {
        switch (band)
        {
            case tropic:
                *values = tropic_co_number_density;
                break;
            case midlat:
                *values = summer ? midlat_summer_co_number_density : midlat_winter_co_number_density;
                break;
            case subarctic:
                *values = summer ? subarctic_summer_co_number_density : subarctic_winter_co_number_density;
                break;
        }
    }
    else if (strcmp(name, "CO2_number_density") == 0)
    {
        switch (band)
        {
            case tropic:
                *values = tropic_co2_number_density;
                break;
            case midlat:
                *values = summer ? midlat_summer_co2_number_density : midlat_winter_co2_number_density;
                break;
            case subarctic:
                *values = summer ? subarctic_summer_co2_number_density : subarctic_winter_co2_number_density;
                break;
        }
    }
    else if (strcmp(name, "H2O_number_density") == 0)
    {
        switch (band)
        {
            case tropic:
                *values = tropic_h2o_number_density;
                break;
            case midlat:
                *values = summer ? midlat_summer_h2o_number_density : midlat_winter_h2o_number_density;
                break;
            case subarctic:
                *values = summer ? subarctic_summer_h2o_number_density : subarctic_winter_h2o_number_density;
                break;
        }
    }
    else if (strcmp(name, "N2O_number_density") == 0)
    {
        switch (band)
        {
            case tropic:
                *values = tropic_n2o_number_density;
                break;
            case midlat:
                *values = summer ? midlat_summer_n2o_number_density : midlat_winter_n2o_number_density;
                break;
            case subarctic:
                *values = summer ? subarctic_summer_n2o_number_density : subarctic_winter_n2o_number_density;
                break;
        }
    }
    else if (strcmp(name, "NO2_number_density") == 0)
    {
        switch (band)
        {
            case tropic:
                *values = tropic_no2_number_density;
                break;
            case midlat:
                *values = summer ? midlat_summer_no2_number_density : midlat_winter_no2_number_density;
                break;
            case subarctic:
                *values = summer ? subarctic_summer_no2_number_density : subarctic_winter_no2_number_density;
                break;
        }
    }
    else if (strcmp(name, "O2_number_density") == 0)
    {
        switch (band)
        {
            case tropic:
                *values = tropic_o2_number_density;
                break;
            case midlat:
                *values = summer ? midlat_summer_o2_number_density : midlat_winter_o2_number_density;
                break;
            case subarctic:
                *values = summer ? subarctic_summer_o2_number_density : subarctic_winter_o2_number_density;
                break;
        }
    }
    else if (strcmp(name, "O3_number_density") == 0)
    {
        switch (band)
        {
            case tropic:
                *values = tropic_o3_number_density;
                break;
            case midlat:
                *values = summer ? midlat_summer_o3_number_density : midlat_winter_o3_number_density;
                break;
            case subarctic:
                *values = summer ? subarctic_summer_o3_number_density : subarctic_winter_o3_number_density;
                break;
        }
    }
    else
    {
        harp_set_error(HARP_ERROR_INVALID_ARGUMENT, "AFGL86 climatology does not have a profile for '%s'", name);
        return -1;
    }

    *num_vertical = 50;

    return 0;
}
