// Generated by gmmproc 2.50.0 -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_URIHANDLER_H
#define _GSTREAMERMM_URIHANDLER_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008-2016 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gst.h>
#include <glibmm/interface.h>
#include <gstreamermm/enums.h>
#include <glibmm/arrayhandle.h>
#include <cstdio>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GstURIHandler = struct _GstURIHandler;
using GstURIHandlerClass = struct _GstURIHandlerClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gst
{ class URIHandler_Class; } // namespace Gst
#endif // DOXYGEN_SHOULD_SKIP_THIS

namespace Gst
{

class Element;

/** @addtogroup gstreamermmEnums gstreamermm Enums and Flags */

/** 
 *  @var URIType URI_UNKNOWN
 * The URI direction is unknown.
 * 
 *  @var URIType URI_SINK
 * The URI is a consumer.
 * 
 *  @var URIType URI_SRC
 * The URI is a producer.
 * 
 *  @enum URIType
 * 
 * The different types of URI direction.
 *
 * @ingroup gstreamermmEnums
 */
enum URIType
{
  URI_UNKNOWN,
  URI_SINK,
  URI_SRC
};

} // namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::URIType> : public Glib::Value_Enum<Gst::URIType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gst
{

/** 
 *  @var URIError URI_ERROR_UNSUPPORTED_PROTOCOL
 * The protocol is not supported.
 * 
 *  @var URIError URI_ERROR_BAD_URI
 * There was a problem with the URI.
 * 
 *  @var URIError URI_ERROR_BAD_STATE
 * Could not set or change the URI because the
 * URI handler was in a state where that is not possible or not permitted.
 * 
 *  @var URIError URI_ERROR_BAD_REFERENCE
 * There was a problem with the entity that
 * the URI references.
 * 
 *  @enum URIError
 * 
 * Different URI-related errors that can occur.
 *
 * @ingroup gstreamermmEnums
 */
enum URIError
{
  URI_ERROR_UNSUPPORTED_PROTOCOL,
  URI_ERROR_BAD_URI,
  URI_ERROR_BAD_STATE,
  URI_ERROR_BAD_REFERENCE
};

} // namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::URIError> : public Glib::Value_Enum<Gst::URIError>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gst
{


/** An interface to ease URI handling in plugins.
 * The Gst::URIHandler is an interface that is implemented by Source and Sink
 * Gst::Element to simplify then handling of URI.
 *
 * An application can use the following functions to quickly get an element
 * that handles the given URI for reading or writing (make_element_from_uri()).
 *
 * Source and Sink plugins should implement this interface when possible.
 *
 * Last reviewed on 2016-08-27 (1.8.0)
 * @ingroup GstInterfaces
 */

class URIHandler : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = URIHandler;
  using CppClassType = URIHandler_Class;
  using BaseObjectType = GstURIHandler;
  using BaseClassType = GstURIHandlerInterface;

  // noncopyable
  URIHandler(const URIHandler&) = delete;
  URIHandler& operator=(const URIHandler&) = delete;

private:
  friend class URIHandler_Class;
  static CppClassType urihandler_class_;

#endif /* DOXYGEN_SHOULD_SKIP_THIS */
protected:
  /**
   * You should derive from this class to use it.
   */
  URIHandler();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  /** Called by constructors of derived classes. Provide the result of
   * the Class init() function to ensure that it is properly
   * initialized.
   *
   * @param interface_class The Class object for the derived type.
   */
  explicit URIHandler(const Glib::Interface_Class& interface_class);

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface.
  explicit URIHandler(GstURIHandler* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  URIHandler(URIHandler&& src) noexcept;
  URIHandler& operator=(URIHandler&& src) noexcept;

  ~URIHandler() noexcept override;

  static void add_interface(GType gtype_implementer);

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstURIHandler*       gobj()       { return reinterpret_cast<GstURIHandler*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstURIHandler* gobj() const { return reinterpret_cast<GstURIHandler*>(gobject_); }

private:


public:
  
  /** Tests if the given string is a valid protocol identifier. Protocols
   * must consist of alphanumeric characters, '+', '-' and '.' and must
   * start with a alphabetic character. See RFC 3986 Section 3.1.
   * 
   * @param protocol A string.
   * @return <tt>true</tt> if the string is a valid protocol identifier, <tt>false</tt> otherwise.
   */
  static bool protocol_is_valid(const Glib::ustring& protocol);
  
  /** Checks if an element exists that supports the given URI protocol. Note
   * that a positive return value does not imply that a subsequent call to
   * Gst::Element::make_from_uri() is guaranteed to work.
   * 
   * @param type Whether to check for a source or a sink.
   * @param protocol Protocol that should be checked for (e.g. "http" or "smb").
   * @return <tt>true</tt>.
   */
  static bool protocol_is_supported(const Gst::URIType type, const Glib::ustring& protocol);
  
  /** Tests if the given string is a valid URI identifier. URIs start with a valid
   * scheme followed by ":" and maybe a string identifying the location.
   * 
   * @param uri A URI string.
   * @return <tt>true</tt> if the string is a valid URI.
   */
  static bool uri_is_valid(const Glib::ustring& uri);
  
  /** Checks if the protocol of a given valid URI matches @a protocol.
   * 
   * @param uri A URI string.
   * @param protocol A protocol string (e.g. "http").
   * @return <tt>true</tt> if the protocol matches.
   */
  static bool uri_has_protocol(const Glib::ustring& uri, const Glib::ustring& protocol);
  
  /** Extracts the protocol out of a given valid URI.
   * 
   * @param uri A URI string.
   * @return The protocol for this URI.
   */
  static Glib::ustring get_protocol(const Glib::ustring& uri);
  
  /** Extracts the location out of a given valid URI, ie. the protocol and "://"
   * are stripped from the URI, which means that the location returned includes
   * the hostname if one is specified.
   * 
   * Free-function: g_free
   * 
   * @param uri A URI string.
   * @return The location for this URI. Returns <tt>nullptr</tt> if the
   * URI isn't valid. If the URI does not contain a location, an empty
   * string is returned.
   */
  static Glib::ustring get_location(const Glib::ustring& uri);
  
  /** Constructs a URI for a given valid protocol and location.
   * 
   * @param protocol Protocol for URI.
   * @param location Location for URI.
   * @return A new string for this URI. Returns <tt>nullptr</tt> if the
   * given URI protocol is not valid, or the given location is <tt>nullptr</tt>.
   */
  static Glib::ustring construct_uri(const Glib::ustring& protocol, const Glib::ustring& location);
  
  /** Similar to Glib::filename_to_uri(), but attempts to handle relative file paths
   * as well. Before converting @a filename into an URI, it will be prefixed by
   * the current working directory if it is a relative path, and then the path
   * will be canonicalised so that it doesn't contain any './' or '../' segments.
   * 
   * On Windows #filename should be in UTF-8 encoding.
   * 
   * @param filename Absolute or relative file name path.
   * @return Newly-allocated URI string, or <tt>nullptr</tt> on error.
   */
  static Glib::ustring filename_to_uri(const Glib::ustring& filename);
  
  /** Creates an element for handling the given URI.
   * 
   * @param type Whether to create a source or a sink.
   * @param uri URI to create an element for.
   * @param name Name of created element, can be <tt>nullptr</tt>.
   * @return A new element or <tt>nullptr</tt> if none could be created.
   */
  static Glib::RefPtr<Gst::Element> make_element_from_uri(const Gst::URIType type, const Glib::ustring& uri, const Glib::ustring& name);

  
  /** Gets the type of the given URI handler
   * 
   * @return The Gst::URIType of the URI handler.
   * Returns Gst::URI_UNKNOWN if the @a handler isn't implemented correctly.
   */
  URIType get_uri_type() const;

 
  /** Gets the list of protocols supported by @a handler. This list may not be
   * modified.
   * 
   * @return The
   * supported protocols.  Returns <tt>nullptr</tt> if the @a handler isn't
   * implemented properly, or the @a handler doesn't support any
   * protocols.
   */
  std::vector<Glib::ustring> get_protocols() const;

  
  /** Gets the currently handled URI.
   * 
   * @return The URI currently handled by
   * the @a handler.  Returns <tt>nullptr</tt> if there are no URI currently
   * handled.
   */
  Glib::ustring get_uri() const;
  
  /** Tries to set the URI of the given handler.
   * 
   * @param uri URI to set.
   * @return <tt>true</tt> if the URI was set successfully, else <tt>false</tt>.
   */
  bool set_uri(const Glib::ustring& uri);

 
  /** Virtual method which should be implemented to return the URI currently
   * handled by the element.
   */
    virtual Glib::ustring get_uri_vfunc() const;


  /** Virtual method which should be implemented to set a new URI.
   */
    virtual bool set_uri_vfunc(const Glib::ustring& uri, GError** error);


  /**
   * Method to return the list of protocols handled by the element.
   */
  virtual const gchar * const * get_protocols_vfunc() const;

  /**
   * Method to tell whether the element handles source or sink URI.
   */
  virtual URIType get_type_vfunc();


protected:

  
public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gst


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::URIHandler
   */
  Glib::RefPtr<Gst::URIHandler> wrap(GstURIHandler* object, bool take_copy = false);

} // namespace Glib


#endif /* _GSTREAMERMM_URIHANDLER_H */

